---

layout: post

title: 认识李英强的十二年

categories: Archive

date: 2019-01-17

tags: 李英强

image_feature: "https://i.loli.net/2019/01/18/5c40a99daea1f.jpg"

description: 你们要记念被捆绑的人，好像与他们同受捆绑。（希伯来书 13：3）

---

原文来自「柳建树的私聊」：~~[认识李英强的十二年](http://archive.li/Sdymu)~~

---

![](https://i.loli.net/2019/01/18/5c40a99daea1f.jpg)

<figcaption>你们要记念被捆绑的人，好像与他们同受捆绑。（希伯来书 13：3）</figcaption>

## 引子：严肃的话题

我和爱人偶尔会谈起英强。说到最后，总是谈到一个话题：“你说，他们会不会被抓？”

我总是缓慢地说道：“很有可能。”同时摆出严肃忧虑的神情。然后，话题在沉默中结束。

其实，我那时倒未曾特别忧虑。一方面觉得，既然他已做好准备，坦然，我们何必徒增忧虑？待事情发生，尽自己本分便是。一方面也是心存侥幸，觉得或许未必便会……

然而，引用某位政治警察的话：“共产党不相信意外”。一个多月前（12月11日），靴子落下，英强被抓。罪名：寻衅滋事。同批被抓的还有他所在教会的牧师信徒，超过一百人。截止今天，仍有十五人在关押中。

有一夜，我梦见英强被刑讯，死了。短促恍惚的梦。醒来想想，不太可能。我们是法治国家，刑讯逼供是警察的日常工作，怎么会出差池？但那不祥的感觉，终究留下了影子。这些年过去，我终究也学会“以最坏的恶意来推测中国人”了。

如今，英强被带走已满37天。逮捕还是释放？没有消息。看来，他一时还难以回家。

## 1.初次见面

按年头算，认识英强十二年了。2007年，我在北京的郊区上大学。偶然的机会，在一间烟雾缭绕的办公室，和他打了个照面。

印象中，他穿褪色的牛仔上衣和灰褐色的西装裤——体面的乡镇小贩常喜欢穿的那种。后来成为他标志特征的山羊胡，当时已初具规模。这胡子是在向初见面的人宣示：我这个人可比较难搞哟！不过当他呵呵笑起来，胡子便欢快地翘起，使得那笑脸变得和善又滑稽，人们便不禁因为笑他的笑而笑。

或许在短暂的会面中，我们曾这样相对而笑过，所以我记住了他，知道他和妻子新月马上要离开北京，回农村老家去办图书馆。

回到学校后，我便找到图书馆简陋的网站，用Google Reader订阅了图书馆的博客。是的，那时Google还没有被迫退出中国，维基百科没有被封锁，敏感词也只有屈指可数几个。那时似乎极权的“总发条已经松了”（引自当时流行的读物，崔卫平老师翻译的《哈维尔文集》）。那时单纯而相信“进步”的我，未曾料到他们会“不忘初心”，“撸lu起qi袖xiu子zi加油干”，更不会料到十二年后，我会坐在这里，谈论那个只见过匆匆一面的人。

## 2.博客

立人的博客好看。坦率讲，那是我迄今为止读过的最动人的博客。所谓“动人”（moving），就是指具有一种让人行动起来的力量。读过那么多博客，只有立人的博客让我真的走向行动。因此，说它是最动人的，也并不为过吧？

你想看看吗？抱歉，已经看不到。立人14年被封杀，所有网络账号一夜间消失，包括那个博客。文章没有备份。

这让我痛惜。

那些用心血写成的文字，像是温热的动物，曾经乖巧地停在我的掌心。只在瞬息间，它们被吸进无形的黑洞，被撕扯成不具意义的碎片，不可挽回地、彻彻底底地消失在世界上。这是一个怎样的世界？可以毫无顾忌地毁灭珍惜之物。

立人被关停，损失很大。唯独这项损失，不只是损失，而是毁灭。场馆可以重建，图书可以重置，人员可以再聚。唯独这些小小的生命碎块，永久湮灭于虚无。

这让我痛恨。

## 3.博客找到了！

说到这里，不禁又在网上搜索一番，不料竟然找到了上述博客里的很多文章！原来一位有心的立人同事，做了备份！细细地浏览了一遍，似乎还颇为完整。真是太棒了。一起看些片段。（很多是英强的妻子新月所写。）

![](https://i.loli.net/2019/01/18/5c40a99e9b3ee.jpg)

<figcaption>阅览室装修中，刮大白的，完了还要刷乳胶漆，淡青色地～</figcaption>

![](https://i.loli.net/2019/01/18/5c40a9a485ab8.jpg)

<figcaption>布置一个书房，央小林儿写个毛笔字～</figcaption>

![](https://i.loli.net/2019/01/18/5c40a9a6bdbed.jpg)

<figcaption>字很丑？无所谓的，自己的就好~贴在衣柜的后面，一个大衣柜，把房间一分，一边卧室一边临时书房~</figcaption>

![](https://i.loli.net/2019/01/18/5c40a9aa7fbee.jpg)

<figcaption>窗帘的效果。</figcaption>

![](https://i.loli.net/2019/01/18/5c40a9ac06108.jpg)

<figcaption>笔筒，一元</figcaption>

![](https://i.loli.net/2019/01/18/5c40a9aeda79c.jpg)

<figcaption>分类图书，准备上架啦～</figcaption>

![](https://i.loli.net/2019/01/18/5c40a9b10a5bd.jpg)

<figcaption>做了一天的木工，腰酸背痛，杂志架被改了书架～</figcaption>

![](https://i.loli.net/2019/01/18/5c40a9b5b43cd.jpg)

<figcaption>改头换面的桌子——贴了木纹纸的！老师们纷纷想效仿；藤编的信筐，如愿以偿——县城一家花店把人家装东西的买来……</figcaption>

![](https://i.loli.net/2019/01/18/5c40a9b9efb7a.jpg)

<figcaption>四点半开始吃晚饭，五点四十上课，中途只有四十多分钟有效时间。图书馆阅览室门口排队等坐位的小孩。</figcaption>

<figcaption>开馆第三天，办理借书证66个，借走图书67本，借什么的都有——并不只看童话的。收到学生捐书2本，义工1名……</figcaption>

![](https://i.loli.net/2019/01/18/5c40a9be58a27.jpg)

![](https://i.loli.net/2019/01/18/5c40a9c181401.jpg)

<figcaption>(图书馆的小读者）</figcaption>

## 4.网站

博客之外，我还喜欢看立人的网站（www.xctsg.cn）。网站被封禁了。通过互联网档案室（Internet Archive）可以看到一些遗迹。来看几条记录。
> 2007年9月27日至10月11日，李英强赴湖北考察第一个试点的基本情况。

这是目前能找到最早的一条动态。我认识英强应是这之后不久。

> 2007年10月28日，传知行研究所李英强、郭玉闪邀请贺卫方等几位师友讨论乡村图书馆计划。期间收到捐款5000元。

原来贺老师是最早的支持者之一。

> 2007年11月4日，开始买书。到北大周末书市淘书9本，共花去45元。

五元一本，良心价格。后来二十多个图书馆、数十万册书，就是从这几本廉价的二手书开始的。

> 2007年12月18日，收到茅于轼先生捐款2000元，北京华一律师事务所律师夏霖先生捐款1000元；浙江台州陶灵敏女士捐款2000元。

如今，茅老刚刚过了九十大寿，身体还好。夏霖在监狱中，判刑十年，刑期还剩六年。陶灵敏女士，您还好吗？

> 截至2007年12月22日，第一分馆已累计办理借书证136个。
>
> 2008年3月12日，第一分馆周末选修课开始启动，首批选修课为两门，其一为《中学经济学》，其二为《电影欣赏》。

图书馆的活动开始多起来。

> 2008年10月29日，第二分馆买白板笔2支，6元；报夹2个，10元；合计支出16元。

记录够详细的。

> 2009年4月21日，第三分馆唐仲容图书馆收到澳门濠江中学陈虹女士捐赠图书31册。这是我们迄今收到的第一批中国大陆以外国家和地区的图书捐赠，特此致谢。

这不会后来也成了“接受境外势力资助”的罪证了吧？

## 5.改变的可能

立人的博客、网站，我珍惜地一篇篇读下来，边边角角的信息也没落下。看一个图书馆的建立，就像用桑叶养一只蚕，看它一点点胖起来，心中满足。

读着这些琐碎的内容，我对世界的理解逐渐起了变化。我原本以为，这个世界是一个冷酷的场所，我要么去适应，要么被抛弃。而英强和新月的生活让我看到，虽然这个世界很糟糕，但力量微弱如我们，也能从一条窗帘、一本书开始，改善世界，改善自己的生活。

改变是可能的。仅仅是确认这种可能性的存在，就足以让人振奋。正是看到了这种可能，我很想行动起来。

## 6.志愿者

大学最后一个学期，同学们考研、找工作，都已告一段落，我还不知何去何从。一切和体制相关的事都让我厌恶，而在我们的社会，有什么是和体制无关的呢？我想起了英强。于是，立人网站上多了这样一条消息：

> 2009年4月3日，北京志愿者柳建树到达巴中。

走出长途车站，英强和新月已经在路边等待。其实他们不必来接我的，他们过来要坐很久的车。但他们还是兴冲冲地来了，我想他们大概也是寂寞的。

我们挤在小巴车里，又在山路上颠簸一个小时。沿途有两三起车祸，都是车子冲开护栏，掉进山谷中。

来到他们的宿舍，门口挂着一幅字：小舟从此逝，江海寄余生。（不知是不是上面图片中那副。）我印象深刻。大概从那时起，我的人生轨迹发生了细小而决定性的转向。我也像一列小巴，偏离了平坦明确的大路，驶入了未知的山区。

宿舍简陋。大概有四张铁架床，两张放东西，两张睡人。墙上挂着日历，是北京锡安教会制作的。那时英强已经决志信主。我们就坐在铁架床上聊起来。主要是英强在说，我在听。

听英强说话，总是愉快的。他善于把复杂的问题简化，并用口语表达。他善于拆穿人的虚伪，并滑稽地揶揄一番。他还善于让言辞稍微过火，以激起注意，就像把肉串上的肥肉烤焦。他边想边说，每当说出自己意料之外的妙语，不等别人反应，自己就先笑了。说话时，他的胡子从旁辅佐，像是相声里捧哏的角色，在强调、润色、夸大他的观点，忙得不亦乐乎。

不过，英强的话语真正动人的时刻，出现在谈话的间隙。在这些偶尔出现的间隙，英强会显得朴素、笨拙，像个执拗的孩子。

## 7.出走的少年

英强老家在湖北农村。或许是无拘无束的乡村生活让他决绝而执拗。他是个认死理的人。高一时，英强的成绩还不错。突然有一天，他感到生活没有意义。他决定离家出走。

父母来劝，无果。老师来劝，他反问：你幸福吗？老师默然。英强站上讲台，对全班发表演讲。讲罢，慨然而去。

他从湖北黄冈出走，历时一月，打工、流浪，辗转来到长沙。他最终还是返回了学校。但对于一个高一的少年来说，这已是了不起的冒险。

十六岁时做的事，往往成为一生的主题。某种意义上，英强一直在延续十六岁的那次出走，他一直在猛烈地反对庸俗，猛烈地寻求意义。像是骆驼闻到水，鲨鱼闻到血腥，他无法克制上路的冲动。

一开始，他找到的是自由主义。大学时，他有个小圈子，读一些禁书，谈论些时事。毕业后到电信公司工作，他不甘心，混迹在天涯关天茶舍，备考研究生。考上北大后，他结识了颇多泛自由派知识分子，开始编辑《大风》，一本言论尺度很大的民间杂志。杂志封面上印着哈维尔的话：“活在真实中”。也是在自由主义的框架下，英强开始了立人图书馆。

不过，自由主义终究无法完整地安顿人生。英强当然要继续上路。他终于走向了上帝。毕竟，只有在宗教里，价值亘古不变，过犯既往不咎，幸福确定不移。

他就这样从世界的中心——盛产分数的黄冈——出发，跋涉到世界的尽头、天国的门口。这一次，他没有中途折返。意义一定就在那里吧，如果这个世界真的有意义的话。

## 8.建起一个图书馆

那次去四川，我的工作是帮忙筹备一个全新的图书馆。立人网站写道：

> 4月5日，（柳建树）和李英强、张新月一起到第四分馆晏阳初图书馆筹备开馆。

我们到达图书馆所在地，和校领导见面，打扫宿舍，赶集采买生活用品，用塑料布隔出厨房，摆设阅览室的桌椅，为图书馆分类、编号、贴胶带、录入电脑，招募志愿者，培训志愿者。忙得不亦乐乎。还记得一些细节。

有一天我看到，英强的裤子——可能是初次见面时穿的那条——在屁股的位置破了一个大洞，而且他大概穿着这破洞的裤子好几天了。我们不禁大笑。

新月去赶集，围观江湖郎中做眼睛手术。三五分钟，病人竟然神奇地治愈了。她对此深信不疑，被我们嘲笑。其实我也不懂其中的玄机。

整理图书时，看到很多《财经》杂志，英强随口说，这是中国最好的杂志。对杂志一无所知的我心想：“原来如此。”谁想到，后来我和这份杂志还会产生一些交集。

因为只有一间宿舍，所以晚上我睡在图书馆的桌子上。我把MP3随手放在枕边，起床也没收起。后来发现，东西不见了。恐怕是某个学生看见，拿走了。一开始我有点气恼，不过很快就感到内疚。因为我的粗心，一个学生或许永远不会再来图书馆了。

经过一周的工作，图书馆的网站有了新消息：

> 2009年4月13日，第四分馆晏阳初图书馆开始试运营。首日开放接待阅览读者约200人，办理借书证35个。

我终于过上了在博客中看到的那种生活。 

## 9.我在立人的成功

半年后，我回到四川的图书馆。这次我已大学毕业，决定在立人工作一年。网站上写道：

> 2009年11月1日，支付……柳建树400元……
>

这是第一个月的生活补贴。

一开始，工作不太顺利。因为私人事务，我分心很多。四川的冬天湿冷刺骨，真不好过。不过英强很宽容，从来没催促、责怪，总是给我更多时间。这让我信任他。

春节后，有新同事加入，工作有了起色。很多学生喜欢来图书馆。很多人、书、事，在这里建立连接。

一年的工作结束时，我兴致高涨。因为远离了长期浸淫的虚伪生活，我重新获得了活力——那活力是每个生命本自具足的。我感到自己终于“活在真实中”。 

后来，我出国读书，但我对立人还很留恋。2010年，中国人获得了诺贝尔和平奖，那天英强恰好在北京，和朋友庆祝起来。我和英强通邮件，说真遗憾错过欢乐的聚会。英强回信道： 

> 小树，这个转型大时代，你是不会错过的。
>
> 中国最近十年，还将出现比这更大的事情，而且会有很多。
>
> 我们都不会错过。

在异国他乡，我心潮澎湃。后来，当英强说：我想邀请你回到立人来，“我们一起大干一票。”我快乐地答应了。

## 10.我在立人的失败 

如果有机会重新安排我在立人的工作，我会希望：在乡村生活，而不是在北京——北京让人虚妄；和学生在一起，而不是媒体与“合作机构”——学生让人专注；和同事在一起，而不是孤身一人——我需要很多鼓励、很多关心、很多帮助。 

可惜，那时我贪心、骄傲、孤僻，以致工作一段时间后，我对立人——更是对自己——失去了信心。 

那时我和朋友谈起工作，他直截了当地说：我觉得你很需要帮助。奇怪的是，在他说起之前，我自己从未想到这一层。我不习惯求助，以为那是软弱的。我是那么聪明完善，难道还需要别人帮助吗？当然，现在明白，那时我真是傻得冒气。 

最终我也没向英强求助。我只是告诉他，我要离开了。他没有劝阻。我感谢他一如既往的尊重，但有时也暗自设想：他当时要是把我臭骂一顿就好了。那样的话，我或许会少做一些傻事。 

我和英强从未谈起这些。去年他写了一封关于立人的道歉信（《迟到四年的道歉——写给“立人之友”和曾关心支持立人的朋友们》），有这样一句： “在带领团队的时候，我缺乏对团队每一个成员的真切的关心和爱，缺乏对每一个具体的志愿者和员工的倾听和帮助。”

我想，或许他在这样说的时候，也想到了我。 

其实，英强做得也并非多差，他只是没达到自己的预期。毕竟，我们曾一起描述立人想要培养什么样的人，而位列第一的是：爱的能力。我们这群自以为义的家伙，善于运用高尚的词语，而真正做起事来，心中的信、望、爱，只有鼻涕球那么可怜的一点儿。这让我愧疚、沮丧，英强想必也一样。英强日益走向基督信仰，或许这种心情也是原因之一。

## 11.立人关闭

离开立人后，我做起一份莫名其妙的工作。那是我工作待遇最好的时期，也是人生彻底跌入谷底的时期。

我硬着头皮辞职，努力把人生引入正轨。刚取得了一点成效，我的情感生活又彻底破产。我努力做君子，我努力做绅士，但我内心的爱始终只有一点点。我连自己都不爱，又怎么爱别人？我连亲近的人都不爱，又怎么爱远方的陌生人？那个秋天北京的雾霾很大。我孤身一人住在群租房里，周日早上经常去教堂，坐在后排听着赞美诗，流下泪来。

二零一四年，九月十月，因为一点捕风捉影的政治波动，立人被关停，一些人牵连被抓。虽然立人从来都是一群充满缺陷的人在手忙脚乱地维持着的充满缺陷的机构，虽然立人所取得的效果终究只有可怜兮兮的一点，但立人的覆灭终究是可惜的，尤其当我想到那些在阅览室门口排队，等待看书的孩子。

文明像是多米诺骨牌，建立总是那么缓慢，倒掉却迅速无比。“何必这样呢？！”我想要质问谁，却不知该质问谁。于是这问题在胸中腐烂，缓慢地释出毒素。

天气转冷后，北京的雾霾愈加浓重了。

## 12.流浪与款待

我很想离开一阵，索性去成都看看英强。这两年，他越来越多地参与到教会中。他一家人租住在老旧的公寓楼里，房间布置得整洁，离教会很近。客厅没有电视，摆了很多折叠板凳和圣经，是查经小组要用到的。他的女儿卡尔松3岁，圣洁可爱。新月做了简单的饭菜。饭前祷告，英强说：主啊，感谢你把小树带来我们家。那一刻，我切实感觉到自己被款待了。

![](https://i.loli.net/2019/01/18/5c40a9e60dcba.jpg)

<figcaption>（新月画的卡尔松。2016年）</figcaption>

饭后，我们在客厅促膝坐下聊天。想起五年前在四川的宿舍里，我们也是这样坐着。变了的与没变的，让时间感扭曲。

基督教一直是话题之一。我渴望被说服，我渴望相信。如果最重要的真理已经被发现，那生活岂不是一马平川？ 如果救赎与恩典已经有标准流程，那幸福岂不唾手可得？为了接近信仰，我参加了礼拜，去尼哥底母查经班，去川大查经班，还有一日，我和英强一家到浣花溪散步。走到湖边，我们拿出王怡的诗集《大教堂》，轮流朗颂，讨论一番。玩得尽兴。

只是，我终究无法相信。临走，英强送我一本提摩太·凯勒的《诸神的面具》。两周后，我在某趟夜班火车上读这本书，泪流满面。基督教给我很大的启发和安慰，但我终究是个思想上的流浪汉，我只想睡在教堂的门口。 

那之后，我回北京讨生活，也因为立人，在看守所生活了一个月。英强走上了全职服侍的道路，从神学生，到执事，到长老。立人原本是他的现世牵挂。立人被关，他便如热气球扔掉了最后的压舱物，缓缓向天空升去。

## 13.卡尔松

18年，我又到成都拜访英强一家。他家搬到了另一座老旧的公寓楼，依然整洁，依然离教会很近。

卡尔松7岁。饭后，她不声不响地坐到小板凳上，捧起一本书读起来。我和英强照例聊起基督教。但没过多久，我开始和卡尔松玩起来。

她没有什么玩具，只是用大眼睛看着我，给我讲她的生活。她在教会办的小学上二年级。她每天的起床和睡觉时间。她最喜欢的一套书是苏珊·鲍尔的《世界的故事》（天津社会科学院出版社），她把她放在床边的窗台上。

许多孩子因耽于逸乐而早早粗鄙起来，而卡尔松有种圣洁感。那是人最好的状态。那是人接近神的样子。和她普普通通的相处，我竟有种感动。从卡尔松身上，我感到了英强一家的生命状态。他们单纯、热烈、美善。

我爱他们一家。

## 14.危险

这宁静的家庭之下，横着暴力的深渊。

离开立人后，英强其实更“激进”了。在立人，他回避和体制正面冲突，他甚至通过“北大毕业生返乡参与新农村建设”的话语，为立人换一点——现在看来也没什么用处的——来自体制的认可。现在，这些策略上的机巧都被废弃了。我可以想象英强的轻松。他终于可以更彻底地“活在真实中”。

英强开始经常说：

> 在这个邪恶的世代，基督徒不坐牢是可耻的。

这句话不是用来苛责别人，而是用来鞭策自己。英强和他的教会也的确是这样做的。他们在敬拜中直斥当权者的罪恶。他们在春夏之交的纪念日组织“为国家祷告会”。当他们的教堂被封，他们到公园里、广场上继续聚会。他和他的教会，不妥协。

旁人看来，他们这样做，无异于主动地走向捆绑。在这个稳定压倒一切的国家，这一切是多么危险啊！

知道危险为什么还做呢？鸡蛋撞石头的意义何在呢？低调的发展不好吗？这些问题，我没问过英强。等到下次见他，我或许要问一问。或许，我不会问。

## 15.预备

决心赴险之后，英强一直在做准备。年初的时候，英强就向朋友请教看守所里的注意事项。几个月前，英强给孩子录了一段视频：“我要去一个你们所不知道的、但是是上帝让我去的地方。那个地方我也不知道是什么样。是上帝让我去呢，我就去。……爸爸每天都会为你们祷告，这就是爸爸要送给你们的最美好的礼物。”英强和新月甚至约好，他被捕以后，每天下午五点，一家人同时祷告。

有了这些准备，英强颇为自豪地说：

> “我们家早就预备好了……我妻子也是一直在做准备，但是她真正做好准备是6月4号那天。5号凌晨我从派出所出来的时候，她还专门为此写了一首小诗，她说‘这一次是真的把你交给主了。’……

> 我妻子比我还要清楚。前天我跟她讲了我们可能要做最坏的准备，不能有侥幸心理。我还没说完，她就说‘最坏的准备无非是你在牢里面被打死，打死了、殉道了也是好得无比的’。所以我们就准备好去坐牢，我跟我妻子也讲清楚，说你要预备我回不来了。预备我回来的话，就得等啊等啊，有一天你就会对上帝很失望，但如果你一开始就预备我回不来那回来了是主的恩典，没回来也是主的恩典。”

看到这段，我又想起那个梦的冰冷触感。

英强啊，或许你已经预备好，或许新月已经预备好，但我们许多朋友还没有啊。请不要抛下我们。请一定不要让自己被打死——我们都知道，他们能做出什么事。请你一定平安归来。如果他们逼你说假话、起假誓、作假见证，我决不怪罪你的选择——在那种情况下，还有何选择可言呢？我相信耶稣更不会怪罪你。毕竟，耶稣的宽恕和爱，岂不要比我大得多吗？可惜，我没有上帝可祷告，但我作为一个人，普普通通的一个人，我要祝愿你：平安归来。

## 16.被抓以后

英强被抓，新月哭了几次。朋友去看望她，被带走、登记。她出门买菜，也有两人跟踪。如今，跟踪的人不在了，家门口装上了摄像头——科学技术才是第一生产力嘛。

精神上的困难之外，还有更现实的困难。虽然英强从未和我谈起，虽然他一家人从未显出寒酸，但我知道，英强家在经济上，一直是拮据的。怎么能不拮据呢？立人和教会的工资，让一个人糊口尚且勉强，更别提要养一家人了。但我最近看到英强写的一段话，才知道他家的困难，比我所知的更为沉重。他写道：

> “我家里的状况不是太理想，我父亲瘫痪，母亲全时间照顾父亲，我弟弟还不信主，因为贩毒的原因被判刑，还在服刑当中，坐牢。他有个儿子，非婚生的，是我父母在抚养，这些都是我们要承担的，很多年来家里唯一的经济来源基本就是我。我妻子的父母身体都不太好，在农村老家。我们也有两个孩子，生活压力是比较大的。”

英强啊，你倒是轻描淡写。这岂止是“比较大”而已？

## 17.了不起的卡尔松

卡尔松也惊人地坚强。她主动帮妈妈做事，还和妈妈说：

> “你知道我为什么这些天没有哭吗？因为每次每次当我想哭的时候，我就知道爸爸给我说过的，没有上帝的允许什么都不会发生，既然发生了那就是上帝的意思，那就是上帝把爸爸带去了，我就又笑了。我还有一个秘诀就是，上帝让发生的每一件事情都是好的，都是对我们有好处的。所以我就不哭了。”

![](https://i.loli.net/2019/01/18/5c40a9e7bdc81.jpg)

<figcaption>（卡尔松和弟弟在看爸爸录的视频）</figcaption>

卡尔松还写了两首诗。

![](https://i.loli.net/2019/01/18/5c40a9fade7b4.jpg)

![](https://i.loli.net/2019/01/18/5c40a9fde398d.jpg)

卡尔松！了不起的卡尔松！

我记挂英强，但没什么能做的。唯有把这速朽的文章折成纸船，掷入信息的洪流，寄托一点心愿。

我记挂卡尔松，相信可以为她做点什么。

或许可以送些钱过去？新月说：“我很好，亲友们不要担心，经济上目前没有问题，房租已交了半年。请关心其他的教案家庭。”看来，给钱她怕是不会收的。

看到新月写给英强的信：“我挺好的，娃们也不错，只是卡尔松的很多书之前放在学校里没有拿回来，都殉道了，接下来要买一些。”于是我想，要不，就为卡尔松买些书吧。她爱读书，会很高兴的。就这么定了！

如果你想和我一起，送一些书给卡尔松，请打赏。这篇文章的赏金，会全部给卡尔松——当然还有她4岁的弟弟——买书。同时，欢迎留言，注明你想送给卡尔松的书，我会尽量考虑你的建议。如果金额较多，也不一定一下子全部买书。总之都交给她就是。谢谢你了！

## 尾声

如之前所说，认识英强十二年了。这十二年里，他从名校精英，公益新秀，到教会长老，又到阶下囚。这十二年里，我走在英强之后，也经历了大致相似的历程，只是在信仰的岔道口，我们悄然走上了不同的路。他全心投入信仰。我却还有些不舍。我想继续探索一下，在中国做一个世俗的自由主义者，是一种什么样的体验。或许结局确如里尔克所说：“哪有胜利可言，挺住就是一切。”但既然还能挺住，就再挺一会儿好了。放弃的话，总是觉得没法对自己交代。

自由主义在中国，从来贫弱，愈发边缘。这十二年里，多少人被禁言，多少人变敏感，多少人被逼迫，多少人被收买，多少人偏安一隅，多少人避走海外，多少人身陷囹圄，没能出来，或者幸运地走出来，却已遭受致命的损害。还有多少人，只是日复一日、悄无声息地，被侮辱、被损害，日渐萎靡下去，像是呼吸着雾霾。

对于这一切，我感到悲哀。我不明白，除了拥抱自由主义，中国还能向何处去呢？难道时至今日，我们还要像野蛮人一样生活吗？难道那么多苦难，我们还要重新经历一遍吗？难道我们所有人就这样，沉默着，算计着，眼看着中国滑向深渊吗？我真的不明白。

接下来的十二年，对我是漫长的，对英强是残酷的，那么对你呢？对十三亿中国人呢？我感到悲观，但也保有一点点期待。

（完）

防失联，请关注我的另一个公众号：自知读书。

在自知，我们一起学习自由的知识。

![](https://i.loli.net/2019/01/18/5c40aa0280249.jpg)
