---

layout: post

title: 员外郎王林清

categories: Archive

date: 2019-01-13 12:00

tags: 王林清

image_feature: "https://i.loli.net/2019/01/17/5c40a4f12c6b2.jpg"

description: 所有事到最后都会是好事。如果还不是，那它还没到最后。

---

原文来自「呦呦鹿鸣的鹿鸣君」：~~[员外郎王林清](https://mp.weixin.qq.com/s/bbIAXNDdyRDeMbDD7Jwv8w)~~

---

![](https://i.loli.net/2019/01/17/5c40a4eb42ef9.jpg)

\[**1**\]

> 所有事到最后都会是好事。如果还不是，那它还没到最后。
>
> ——约翰·列侬

1995年，91-1班王林清考研失败了。即便，他是班长印象里最擅长打勾机、记牌的“小清新”。

日子还要过。尤其，需要一份工作，一份体面的工作。

王林清本科就读的烟台大学法律系，既非北大、人大、武大法学院这样国家眷顾的名门，也不是西南、中南、华东等五大司法部直属政法系院校。她更像一个试验性的旁枝：以“沿海城市中第一所由地方政府筹资建的大学”的名义，勉力搭上北大、清华的名校航空母舰——1990年，“北大、清华支援烟台大学建设委员会”成立，烟台大学法律系由北大法律系直接援建。

次年，烟台人王林清考入烟台大学法律系。

![](https://i.loli.net/2019/01/17/5c40a4ee006e0.jpg)

其时，北京大学法律系硕士生房绍坤，已到这里工作5年。1999年，法律系升级为法学院，37岁的房绍坤成为法学院院长，再后来，升任烟台大学校长。房绍坤还拜入了民法学者王利明门下，成为这位人民大学副校长的博士生，并被安排挂任人大校长助理半年。2016年，这位在烟台大学任职满30年、经山东省政府任命的正厅级干部，开始学术地位的最后冲击——申报人文社科领域的高级称号“长江学者”。

考研失败、出身一般的王林清，似乎与这种身边标杆的事业路线无缘了。

他被分配进入了烟台中级人民法院工作，走上另一条路。

很快，就听到了好消息：1996年春节前夕，2月8日，中国社会科学院研究员王家福，后来名列“改革开放40年100人”之一的法学家，第二次被请到中南海怀仁堂，为中央领导同志讲授法律知识。正是在这个会议上，总SJ江ZM首次提出“依法治国”的方针。

也在这一年，电影《被告山杠爷》广受欢迎，在北京第三届大学生电影节上获得最佳故事片奖。山杠爷是堆堆坪村的村主任，德高望重、大公无私、敢说敢管，但没想到，他用“游街”的办法教育村里一个不孝儿媳，却逼出了人命，触犯了法律，最终使自己成了“被告”。这部以小见大、充满悲剧色彩的电影被广为推荐，预示着古老的中国大陆决心割舍乡土社会里最后的一点宗法色彩，努力向一个现代法治国家靠拢。

越来越多的人乐观起来：过去的已经过去，一个新的时代，就要到来了。在这个国家享有崇高地位的马克思曾确凿无疑地说过：“法官是法律世界的国王，除了法律就没有别的上司。”

是的，无产阶级革命导师的话总是斩钉截铁，又总是那么激荡人心。 王林清就处在这样一个氛围中。

\[**2**\]

> 法律必须被信仰，否则形同虚设。
>
> ——伯尔曼《法律帝国》 

然而，此时的他，又一次到了选择的路口：某个案件被要求按照领导要求来裁决。 

这并不奇怪，司法体系所要解决的一切问题之核心，也是“实然”和“应然”之间的冲突。人们都相信进程，但进程中都是充满艰辛的，从来没有什么是生而有之理所当然的，“没有别的上司”作为理想，将被摁在地上摩擦，是必经的过程。

正是在1995年，山东法院系统发生了一个不大不小的事。某县法院行政庭的庭长和审判员阮文广、靳学英在审理中认定本县劳动教养委员会对某农民作出的劳动教养决定违法，二审法院也维持了他们的判决。法院为这个农民主持了公道，但在二审判决后，该县检察院以徇私枉法罪为由，将阮文广、靳学英逮捕，关押近一年后，作出定罪免于起诉的决定。两位法官多次到最高人民法院申诉。最高法院复查后认为，一、二审判决没有问题，两位法官不存在徇私枉法行为，指派法官蔡小雪继续处理此案、维护法官权益。蔡小雪先后找到了全国人大内务司法委员会、最高人民检察院等多个部门，到2003年时，撤销了县检察院作出的定罪免于起诉的决定，最终，两位法官得到了公正。可惜的是，此时，阮文广、靳学英已到退休年龄，错过了多次晋升机会。蔡小雪说：“靳学英放出后，听说精神出了点问题；我见到阮文广时，他已满头白发，看上去比他实际年龄大很多的苍老老人。”

到更大、更高的平台去，会更好吧。本科时的**梦想，又发芽了**，此时的王林清，开始发奋考研。

关于学习的一切，特别是智识的挑战，往往意味着各种不为外人道的巅峰体验。这次他成功了。王林清考上了北京大学民法学硕士，毕业后，他再接再厉，考上了中国政法大学商法学博士。博士论文是《公司内部监督机制法律构造研究》，“评价了我国公司内部监督的窘境；阐释了董事会职能重新定位的合理性与必要性；明确了独立董事制度的独特作用；探讨了不同类型公司的内部监督机制的构建。”截至2019年1月1日，在知网上被下载1882次。

![](https://i.loli.net/2019/01/17/5c40a4f12c6b2.jpg)

“学霸”的道路，被一张张考卷一篇篇论文，生生砸开了。像很多拼命进入体制的山东人一样，王林清也在这样的轨道之中。

\[**3**\]

> 法律职业的社会地位，是一个民族文明的标志。
>
> ——费尔德

高考、研究生考试、博士生考试、论文答辩——千军万马，一路杀将出来，几进几出，都是为了最后一个关卡——国家公务员考试。

2006年5月16日，最高人民法院发布招录国家公务员拟录用人员名单。一共107人，王林清名列第53号。 

这批中国法治未来的栋梁之选，海纳百川，来历颇为丰富：除了各大著名高校，有来自培训学校的（南京新东方学校、北京福来得实用管理培训学校）；有来自贸易公司、光电公司、机械公司的（四川省内江市方向光电股份公司、北京神华天泓贸易有限公司、北京北起百莱玛机械有限公司）；有来自外企的（德国诺马公司北京代表处）；有来自区法院、区国土局的（湖北省宜昌市猇亭区人民法院、江苏省常州市国土资源局武进分局）；有来自生物公司的（北京北大维信生物科技有限公司）；有来自城管的（北京市昌平区城市管理监察大队）。  

一开始，王林清并没有显露特别之处。同一届同事，同样来自中国政法大学的，有28人。他的本科母校烟台大学，没有同学进入，他的硕士母校北京大学，有10人。 

最高人民法院已经是这个国家法律人的最高平台，任何人，成为她的一员，都足以骄傲。

终其一生都没有离开家乡科尼斯堡的大哲学家康德曾经说：“世界上唯有两样东西能让我们的内心受到深深的震撼，一是我们头顶上灿烂的星空，一是我们内心崇高的道德法则。”现在，站在世界上最大的转型国家的法律人的最高平台，王林清，有机会仰望头顶灿烂的星空，并叩问内心的崇高法则。

他不可能想到：在接下来十来年中，他在与同僚们的共同出发的奔跑中，会走向另外一条轨道。 

\[**4**\]

> 法律解释者都期望在法律中寻获其时代问题的答案。
>
> ——（德）拉伦茨

在进入最高人民法院后，学霸王林清继续读了中国社会科学院金融学博士后，又读了中国人民大学经济学博士后，成为**全国政法系统首位“双博士后”。**

![](https://i.loli.net/2019/01/17/5c40a4f6e77be.jpg)

从法学跨越到金融学，再跨越到经济学，这种跨界，充满智识上的挑战，既艰难，又刺激。智识上的进步，与手上正在办理的各种疑难案件相互呼应，即便收入微薄，一切都是值得的。

嗯，学霸您好。从在《人民法院报》上发表的个人心得来看，王林清充满自信：

**他要当顶级的法律人**：“法官对法律知识必须有超乎律师、当事人和普通群众的广泛涉猎和精深理解。”

**不止于案例，他还要创立规则**：“法官应当善于研究审判实践中的新情况新问题，善于从个案中发现一般原理，通过实践积累经验，从而发现和创立新的规则。”

**不止于规则，他还要上溯精神**：“审理案件是通过解释将蕴涵着法律精神和法律理念的裁判规则与案件事实相结合而生成……裁判规则的引用反映了法官对法律精神、裁判理念、思维方法和价值追求的动态演绎，判决就是法律思维的产品。”

**不止于精神，他还要落基平台**：“法官在法律帝国的平台上，要正确处理好事实判断与价值判断、个别正义与普世正义、形式合理与实质合理、程序公正与实体公正的关系，除了有深厚的法学理论功底，还需要有丰富的其他学科的知识奠基。”

他用了“**法律帝国**”这个名词。这是很罕见的措辞。这四个字，也是牛津大学法理学教授德沃金的一本名著书名，主题是法律解释——王林清这一类法官最为向往的工作。

王林清很快就获得了官方的肯定。作为法治社会改革进程中的重要角色，最高人民法院需要一些象征着突破性的人才，也愿意给予奖掖。2012年，王林清被评选为全国法院办案标兵。当年，最高人民法院仅有三人获得这个荣誉，全国也仅有200人获评，各个省份，少的只有两个，多的也才十个。最高人民法院的表彰决定文件中，对这批人的评价是：“政治素质高、业务能力强、办案数量多、审判质量优、社会形象好。”号召全国法院广大干警要广泛开展向这200人学习的活动。

2014年，王林清获得第三届“中央国家机关青年五四奖章标兵”，这个荣誉也不小，在京各个机关，总共才10人获得。

他走在了同辈的前面。

何况，他开始涉足进入创制法律规则的领域。负责起草了劳动争议司法解释（三）、劳动争议司法解释（四）、民间借贷司法解释。他还参与了建筑物区分所有权、物业服务、城镇房屋租赁、旅游纠纷、食品药品纠纷、网络侵权、民事诉讼、物权法适用、消费民事公益诉讼等多部司法解释的研讨制定和书籍编纂工作。 

最高人民法院的司法解释，对各级人民法院的审判具有约束力，是办案依据。在实务界，最高人民法院和最高人民检察院的司法解释，简称两高解释，因为极强的针对性，他们对判决影响力，有时比法律还要大。 

**什么样的人握有最高权柄？制定规则的人。**看起来，王林清渐渐摸到了门边。此时，王林清入职最高法院不到10年。

有此便利，大多数普通人身边遇到的事情，王林清都认真从规则的高度琢磨过。与此相关，他先后出版了《金融纠纷裁判思路与裁判规则》《民间借贷纠纷裁判思路与规范指引》（上下）、《房地产纠纷裁判思路与规范指引》（上下）、《劳动争议裁诉标准与规范》等9本书。

无疑，他得到了一个很好的环境，如鱼得水。各地纷纷邀请他去讲座。春风得意马蹄急，**一切都是他最喜欢的那个样子。**

但是，他不可能想到，自己会以更加震撼性的方式，重复昨天的故事。

\[**5**\]

> 法律的真正目的是诱导那些受法律支配的人求得他们自我的德行。
>
> ——（意）阿奎那《神学大全》

有一个事情，令外界颇为不解：虽然获得无数荣誉，但是，王林清一直是一位“助理审判员”。 

很奇怪，不是吗？ 

在中国法院系统序列中，正式称呼是“助理审判员”和““审判员”，都可以称为法官，但有区别：审判员由人大常委会任免；助理审判员由法院任免，协助审判员工作，由本院院长提出，经审判委员会通过，可以临时代行审判员职务。体现在判决书上，助理审判员最多只能署名“代理审判员”。 

他的真正考验，在他被评为全国办案标兵差不多时候，也到来了。

矿资源大省山西，出了一个“侵犯出资人权益纠纷案”，标的物是一个铁矿。大意是，A把矿权转让给B，但是发现是个富矿，然后又把矿产转回来。双方冲突。在山西高院作出一审判决后，案件来到最高人民法院，分到了王林清手里。

在2019年新年的第一个工作日，网络上一则王林清的自述视频，讲述了他当时在这个案件中的经历。具体的案情，比较复杂，我们先放一边，等官方声明后我们会更加清晰。

我们可以从法院在官网公开文件中确定的事实是：

2012年12月4日，王林清所在的合议庭做出（2012）民一终字第65号民事判决。2014年6月16日，最高人民法院做出一个民事裁定书（2013）民申字第979号：中止原判决执行，另组合议庭，再审山西案。

根据王林清自述，2014年6月17日，王林清被上级派到江苏省沐阳县给江苏省的法官讲课，当晚，在沐阳宾馆，法警将其拘捕，次日押回北京，再然后又被释放。 

最高法的纪检将王林清控制又释放，这说明王林清本身清白经得起查，同样也说明纪检坚持了尊重事实。

仿佛与矿有了奇缘。王林清还遇到一个矿权案：陕西榆林一家公司和西安地质勘察院的合作勘查合同纠纷。这个案件涉及的煤矿资源，据称价值千亿，利益纠葛纷纭复杂，我们暂且不提，单说发生在王林清身上的“案中案”：当他写判决书时，忽然发现，厚厚一摞子的一审案卷都在，而二审的一本正卷和一本副卷竟然不翼而飞了。“这个案件多么的重大，如果这个案卷一丢，我可能就会被开除了。” 王林清的办公室，有两个监控摄像头，监控录像能够显示出王林清带着卷宗回到了自己的办公室，但是，摄像头坏了，后面的就不清楚了。“**坏一个也不可能两个都坏呀**。”王林清着急了。 

一个陕西，一个山西。都是矿，都是故事。

前一阵，呦呦鹿鸣的鹿鸣君和一位朋友吃饭，聊起了山东：山东人的文化密码，是藏在文字中的，比如，山东为什么简称鲁呢？ 

“鲁”，上鱼下口，意思是这里的鱼很好吃。因为远古时期这里入海，鱼多，美味，所以把这里简称为鲁。后来，人们发现，这个地方的人，耿直，直率，人们就把这种性格，称为鲁的性格。于是，“鲁”就有了直的意思。鲁直，成了一个词组。也正因为如此，先贤造字之时，给鲁加上木的偏旁部首，“橹”代表摇船的木浆。因为船桨需直的，而鲁地的人，就代表直。一直以来，“直”，这就是山东人的本色。

在更远古的时候，山东是东夷人的所在。传说中射日的后羿就是东夷人。 许慎《说文解字》：“夷，平也，从大从弓，东方之人也。“夷”字形象就是一身材魁梧的大汉在腰部佩带一张弓。东夷，被殷宋后人孔子称为“君子不死之国”。

**射日的勇敢和鲁直的性格，才是传统山东人的底色**，而不是现在流行的煎饼卷大葱。目前这种风格，多是元末明初移民的一种新文化。

“你等着吧，早晚有你的好果子吃。”一个败诉的当事人曾经这样威胁王林清。

他不明白，王林清更接近于一个传统的山东人。远古的山东人后羿连太阳都敢射，今天的山东人，莫非连个案子都不敢判？ 

无论是山西矿案，还是陕西矿案，王林清所在的合议庭做出的判决，都得到了最高法院的支持。

王林清录下了一个视频，“为保护自己，免遭不测，留下一些证据。”把它托给亲友。东夷，“君子不死之国”。君子不死，法律不亡。

\[**6**\]

> 人的法律，是生活的一种方策，使性命与国家皆得安全。
>
> ——（荷）斯宾诺莎 《神学政治论》  

王林清的法官身份，越来越尴尬了起来。

这些年，全国政法系统正在推进“员额制”改革。法院工作人员，将被分为三类：法官、司法辅助人员、司法行政人员，只有入了员额的法官才可以独立办案；同时，实行法官单独职务序列及工资制度，拉开薪酬。入了员额，才是真正的、完整意义上的法官，没有入员额的人，包括助理审判员，不能独立办案，将逐步过渡，转为“法官助理”或者行政人员。 

它并不为一般大众所关心，却是中国司法史上的大事件。 

2016年9月14日，王林清给国家通讯社新华社旗下的新华网网评栏目写了一篇文章《牵紧司法责任制这个“牛鼻子”》： 

> 司法体制改革已是“开弓没有回头箭”。要**动自己的“奶酪”，就要动得彻底**；敢啃“硬骨头”，就要啃得坚定；甘当“**燃灯者**”，就要有无畏的担当。长期以来的那种“零敲碎打”的司法改革之所以收效甚微，很大一部分原因就是责任落实不到位不彻底而没有达到改革的目的。  

员额制改革，意味着凸显法官的审判地位、待遇、责任，也减少审批、上级干预，符合世界潮流，也是中国向法治迈进的一大步。

只不过，具体到王林清个人，随后呈现的现实，却是尴尬的。

2017年7月，最高人民法院首批367名法官入员额宣誓，名单中没有王林清。2018年11月，第二批40名员额制法官名单，也没有王林清。

最高人民法院对员额制改革的评价，和王林清的网评文章意思很接近，甚至措辞都有重叠：

> 法官员额制改革是对法院工作人员利益格局的重新“洗牌”，涉及每一位干警的切身利益，是**一场动自己“奶酪”的“自我革命”**，因此，被视为司法体制改革中**“一块最难啃的硬骨头**”。
>
> ——《把最优秀的人才吸引到办案一线——人民法院法官员额制改革综述》（2018年3月6日《人民法院报》） 

对照之下，不禁令人唏嘘。

首批367名入额法官中，有98名是相对年轻的法官、助理审判员，王林清没有入首批员额，已经“落后”了，没有入第二批，又“落后”了。

2018年10月26日，第十三届全国人民代表大会常务委员会第六次会议修订了《人民法院组织法》，删除了“助理审判员”这个制度设计。没有入员额的原助理审判员王林清，走到了体制的边缘。如果在未来一个时间段仍然没有入员额，他将成为了那个被新的利益格局洗牌掉的人，成为那个被“革命”掉的人。

将来的王法官，还能不能叫做王法官？这是一个问题。按照目前情势，在最高人民法院，有超过四百人比王林清更加优秀，更有资格当法官。 这就是王林清所要面对的现实。

王林清，被戏称为“员外郎”。他仍然有法官的尊称，但是，他已经不在名单内。在目前“最高人民法院内设机构主要人员”网页上，有所有审判员的名字，每个庭室都有，五百人左右，也没有王林清的名字。

在全国层面，目前，全国法院法官总体数量约为21万人，已遴选产生12万余名员额法官（包括最高法院367名）。王林清，是那不能入员额的约9万人，不再能独立办案。  

2017年8月25日上午，最高人民法院第五巡回法庭举办“每月一讲”集体学习第九讲，王林清被邀请为主讲人。参加者包括五巡审判团队全体主审法官、法官助理、书记员，综合办公室及诉讼服务中心有关同志参加学习，巡回区内重庆、四川、贵州、云南、西藏五省（市、区）三级法院从事民商事审判工作的干警通过视频会议系统收看收听。

以“民间借贷法律适用前沿问题”为主题，王林清围绕民间借贷案件的受理依据、管辖争议处理、主体资格认定、刑民交叉问题、事实审查、夫妻债务、法律适用、债券担保、P2P网络借贷、利率与利息等十一个大问题依次展开，众多疑难问题，条分缕析，逐一阐述。

![](https://i.loli.net/2019/01/17/5c40a4f992df9.jpg)

讲座持续至中午一点结束，第五巡回法庭副庭长刘竹梅说，民间借贷案件具有类型新、难点多、涉及面广等特点，王林清法官作为民间借贷司法解释执笔人，对民间借贷纠纷案件法律适用有着深入的研究和独到见解，尽管对一些争议问题仅代表个人观点，仍如**“及时雨”、“雪中炭”**一样，对五巡及辖区内法官办理此类案件有很大的启发和助益。讲座过程中，一些法院的法官发来信息，告知讲座内容非常精彩，收获非常大，**以至于忘记了吃饭。 **

热衷智识的人相遇，每每会因为智识而忘记时间和头衔。正如两个吃货相遇，每每会因为美食而忘记体重和贫穷。

只有有心人才会注意到，在一个月前隆重举行的首批员额法官宣誓仪式上，并没有王林清的身影。

\[**7**\]

> 小恶不容于乡，大恶不容于国。
>
> ——(宋)苏轼《策别安万民六》 

2018年底、2019年初，中国舆论界出了一件怪事。 

早在2010年，陕西千亿矿权案已被《中国新闻周刊》封面报道，被《中国青年报》整版报道，但在2018年年底，在央视报道之后，报道的中心从矿权转移到王林清身上：崔永元在社交媒体爆料；《中国经营报》报道了最高法丢卷事件；《华夏时报》调查部公众号爆出了王林清的第一段视频，谈到了丢卷事件；凤凰周刊头条号爆出了王林清第二段视频，谈到了山西案。 

这个视频发布出来，意味着王林清搭上一生的“前途”。一直处于判决和规则背后的王林清，被推到前台，成为新闻主角。

如今正是凛冬时刻，而视频中，王林清身着短袖说：“真的有一天遭受了不幸，我要通过别人，把视频向社会公开。”

**这是遗嘱式的自述**，本意是在遭受不测时保持清白的声名。 但是，此时的王林清，并未遭受不测。视频是如何流出的？又是为何流出呢？ 

丢卷的这个“陕西千亿矿权案”本身，已判决原告胜诉，最高人民法院的审判无可指摘。而关于各个“案中案”，因为信息流动并不充分，反而产生诸多悬疑。王林清，一个后来者，变成了风暴中心。

![](https://i.loli.net/2019/01/17/5c40a4fc37ef2.jpg)

回头看，2016年，王林清还在迈着人生的大坎。 

2016年，王林清获得第二届“首都十大杰出青年法学家”提名。 

在法学界，有一个指标，CLSCI，全称“中国法学核心科研评价来源期刊(China Legal Science Citation Index)”。这是中国法学会下属部门，结合论文发表情况，综合学术质量指标所建立属于法学共同体的评价体系。其中，“CLSCI高产作者榜”非常难上，在2015年度、2016年度榜中，来自最高人民法院的有且只有王林清一人，其他多来自各大高校。2017年，王林清没有上榜，最高人民法院也无一人上榜。 

就此，鹿鸣君的观感是，**王林清是这两年最高人民法院最有学术产出能力的法官。**

如今，他短暂消失于榜单之中。

“**书读多了，不懂人情世故。**”这是是对王林清最大的恶评。这句话曾经被一个人用于当面斥责王林清，远比“员外郎”的调侃来得恶毒。

其实，一个起草民间借贷司法解释、劳动争议司法解释，参与过租赁、旅游纠纷、网络侵权、物权法适用、消费民事公益诉讼司法解释的人，一个办了无数民事争议案件后定纷止争制定规则的人，恰恰是对“人情世故”进行了最深刻琢磨的人。

所以，他当然懂得所谓的“人情世故”。 

在《天龙八部》中，萧峰为避免宋辽战火，自杀于雁门关外，这是小说史上最壮烈的牺牲之一。他的自杀，并不是因为自己的无能，而是因为身世，是因为世人对血统的偏见，是因为他太正直而遭到了马夫人这批贼人的嫉恨。可惜，即便自我牺牲，他仍然未能获得众人的理解。众人围在一起叽叽喳喳：“他虽于大宋有功，在辽国却成了卖国，他这是畏罪自杀。”“两国罢兵，他成了大功臣，却用不着自寻短见啊。”……耶律洪基心下一片茫然：“他到底于我大辽有功还是有过？他苦苦劝我不可伐宋，到底是为了宋人还是为了契丹？他和我结义为兄弟，始终对我忠心耿耿，今日自尽于雁门关前，自然就不是贪图南朝的功名富贵，那……那却又为了什么？”

然后，阿紫尖叫道：“走开，走开！大家都走开。**你们害死了我姐夫**，在这里假惺惺的洒几滴眼泪，又有什么用？”

政治智慧高分的金庸，借阿紫之口，道破了天机：正是这周遭的世人，那些充满偏见、充满嫉妒的自私自利与“世故”，害死了萧峰，让他无法存活于世，甚至在偏僻的女真部落安静地打猎放羊都不可得。

世间最大的悲剧，莫过于此。

当然，王林清并没有真的消失。2017年8月，在东交民巷27号，最高人民法院所在的办公地，他默默地写下一篇书稿的跋：

> 本书从写作完成至今，进行了五次及修改、完善和审稿。回想初稿刚刚完成的那个没有阳光的下午，一场纷纷扬扬的大雪瞬间弥漫了整个首都，给这座久旱枯凋的古老城市涂上了厚重的银装素裹，为饱经雾霾浓锁的树木花草带来了片刻清新。尽管这场久违的初雪有些姗姗来迟，甚至在2017年早春时节降临或许来得有些不是时候，然而，它毕竟来了，它终于来了，涤荡了尘埃，催促了花开。而今，时光又步入了秋季，物华丰实，硕果累累。是的，**人生无处不精彩，只要精神昂扬、目标坚定和行动果敢，苍天必定给你一个蓬勃的答案。**

这个时候，距离烟台人王林清考入被援建的烟台大学法律系，已接近26年。大批的法律学子，步入了社会。无论时代多么跌宕，从法制到法治，社会已经在不可逆转的趋势之中，“法”越来越被尊重，越来越多的人认真对待自己的权利。此时此刻，尚未进入舆论中心的王林清，已经录过了视频，给社会留下了以防万一的交代，他无疑曾经内心灰暗过，但仍然鼓励自己精神昂扬、目标坚定、行动果敢，并相信，苍天一定会给自己一个蓬勃的答案。

王林清这一代法律人，学习成长的所有时刻，都伴随着商务印书馆一套“汉译世界学术名著丛书”。其中，有一本伯尔曼的《法律与宗教》。这本学术名著反复讲的，不过是一个非学术的信念：“法律必须被信仰，否则形同虚设。” 

呦呦鹿鸣的朋友们，我知道你们中的许多人，经历比王林清更加曲折，只是，请相信时间的力量，所有事，不论是对谁，到最后都会是好事，如果还不是，那它还没到最后。

**PS：**以下法律类公众号未经授权抄袭呦呦鹿鸣之前关于王林清的原创文章，尤其是里面还抄袭出一些行文错误，无法更正，请自行删除（法律号违法，肯定不合适，也很危险）：法律研社、法言之旅、法律指南、法苑参阅、律动达人、法律前言、法治简报、律法小兵、天天法律在线、劳动法研究、法务之音、法律唯你、今日说法评论、普法聚焦、法治讲坛……等等。没有关注呦呦鹿鸣的朋友请扫描上面这个二维码☝
