---

layout: post

title: 铁幕背后：美国为何要开启“新冷战"？

categories: Archive

date: 2018-10-11

tags: 新冷战

image_feature: https://i.loli.net/2018/10/13/5bc141b987a1b.jpeg

description: 2018年10月4日，美国副总统彭斯在哈德逊研究所针对中国发表了一番言辞激烈的演讲，除了贸易战这个大背景，还直指中国干预美国内政和选举、扩大军备支出并非和平崛起，被纽约时报称为“新冷战”的征兆。

---

原文来自微信号「赵丹赵丹喵」：~~[铁幕背后：美国为何要开启“新冷战"？](https://mp.weixin.qq.com/s/pjqBW-c1xp_8M9tC2IQxlg)~~

2018年10月4日，美国副总统彭斯在哈德逊研究所针对中国发表了一番言辞激烈的演讲，除了贸易战这个大背景，还直指中国干预美国内政和选举、扩大军备支出并非和平崛起，被纽约时报称为“新冷战”的征兆。

![luosifu](https://i.loli.net/2018/10/13/5bc141b987a1b.jpeg)

铁幕徐徐降下，中美关系降到近几十年来的最低点，我们每个人都站在时代的拐角，见证着身后和眼前两个逐渐分离的世界。

自从特朗普政府上台，跟中国打起了贸易战，美国内部鹰派对中国其他领域的指责也越发强硬，大小摩擦不断。这一系列现象的背后都指向一个深层动机：**美国在挑事，故意跟中国过不去，因此不断在寻求打击中国的办法并正当化自己打击中国的行动。**

这便不得不让人进一步思考：美国到底跟中国有什么深仇大恨？如此周密部署全方面的攻击，所求似乎不仅仅是短期的经济利益和中国的暂时让步，而是不惜动用一切资源全面狙击中国的发展。

综合美国经济和外交领域近些年的一些观点，对于中美之间的根本矛盾，有这样一种解释的思路：

1. 中国过去30年经济发展的奇迹不是偶然现象，而是基于其发展体制和模式的一种必然结果。
2. 美国由于国情和历史原因，不可能采取与中国同样的发展体制与模式，这就导致了目前的全球化格局必然对中国的经济发展更有利。
3. 美国单方面认为，随着经济力量的进一步增长，中国必然威胁到美国的国家安全。
4. 国家安全作为深层恐惧，支配了美国对中国发展模式的表层谴责：这种模式不公平、违反了贸易精神、违反了现代民主自由的价值观、甚至会导致混乱和对人基本权利的践踏。
5. 因此，从手段上，美国的一切行为都服务于“**不能让中国以这个模式继续发展下去**”这个唯一目标，短期而言不惜牺牲自己暂时的经济利益，长期而言在国际上寻求盟友、在国内不断用“铁幕演说”这种价值攻击来获得民众的支持，争取国内国外，上下一心来对抗中国的发展。

这篇文章仅代表就我目前的知识储备而言，对中美冲突和世界格局的一种认知结构，必然存在不够完善和有所偏颇的地方，因此欢迎一切讨论与指正。

## 经济模式的冲突

自从中国入世以来，WTO框架下的全球化格局让中国如鱼得水，实现经济发展的奇迹，在美国等西方国家却不断激发社会矛盾，发展迟滞，造成保守主义上台、开启全面收缩的全球化战略。

这种现象的表层原因，如同美国一直以来的指责，是中国这种“**集中国家资源来发展经济**”的模式，与自由主义经济下政府应该扮演的角色背道而驰。

至于更深层的原因，我非常认同哈佛肯尼迪学院教授Dani Rodrik提出的一种“黄金不可能三角”理论。Rodrik在2012年写过一本书，叫T**he Globalization Paradox: Democracy and the Future of the World Economy** (《全球化的困境：民主与世界经济的未来》)。这本书远远写在特朗普上台和贸易战开始之前，却超前的提出了美国这种经济模式的发展困境，其理论框架更是可以用来分析中国经济发展奇迹的根本原因。

![896ae96a172894f68bf719162ff37ecc6d7d20ed](https://i.loli.net/2018/10/13/5bc14295e79fe.jpeg)

<figcaption>(购于美国亚马逊，貌似台湾有出过繁体中译版)</figcaption>

什么是黄金不可能三角呢？就是**全球化(globalization)、民主(democracy)和国家自治(national sovereignty)**三者不能共存，必须舍弃其一。

![537c71d0aeb74e19bd7a138c4120e8758dccc064](https://i.loli.net/2018/10/13/5bc142c38ab06.png)

## 全球化与民主

全球化与民主的冲突，**在于对外贸易必然会造成一国内部利益分配不均的问题**。自从亚当.斯密和李嘉图提出“相对优势”(comparative adavantage)的概念以来，与其他国家进行贸易 = 两个国家都能赚钱，作为全球化和现代经济的根本逻辑已经深入人心。

然而，一个国家内部并不是铁板一块，从贸易中所获得的经济利益往往属于一个群体，且以牺牲另外一个群体的利益为代价。

拿美国举例：有一种历史学说认为，美国南北战争的一个重要原因在于南北方的州在对外贸易上经济利益的冲突，在一定程度上，废除奴隶制只是导火索，是正当化战争而必须采取的政治策略。

在美国建国初期，南方的种植园经济历史悠久，在世界市场上具有优势，主张打开国门进行出口。然而北方州的工业处于刚起步阶段，无法与英国等老牌工业帝国竞争，主张暂时提高关税，给国内的工业喘息的时机。

一个国家不可能有两套关税政策，你限制他国进口的工业产品，就必须得接受他国对于你农业产品出口对等的限制。在民主制度下，在国会占稍多数席位的北方州掌权，推动了贸易保护政策，而征收来的关税又用来建设北方的基础设施。南方的州丝毫利益都得不到，还要面临其出口的农产品在国际上因为高关税而面临的更艰难的竞争。

这是一个典型的不可能三角：**南北方对于全球化的策略和立场截然不同，在民主程序下，多数党只会闷头推行己方利益而不会顾忌少数派的叫喊，根本冲突无法解决，只能导致国家自治崩盘，触发战争。**

近几十年年来，美国在全球化的发展过程中制造业不断衰退，使得这一代铁锈州(rust belt)蓝领工人的命运发生了翻天覆地的变化。制造业的不景气让这批人大量失业，曾经收入稳定的社会阶层需要依赖政府的救济金才能生存，也因此滋生了吸毒和犯罪。这批人对一力推行全球化的民主党丧失了希望，铁锈州也成为了2016年大选中特朗普最坚实的票仓。

特朗普上台后，兑现承诺，先是撕毁TPP和NAFTA这种民主党主导的国际贸易协议，再是放手与中国互加关税打贸易战，美国的对外经贸政策整体上从自由走向保守。

**根据黄金不可能三角，在国家自治的前提下，民主国家不可能一直持续推进一个开放的全球化战略**。因为全球化所带来的社会利益分配不均问题，在正常的民主程序下，迟早会让利益持续受到剥削的群体再次掌权，开启一轮贸易收缩的政策周期。

这种周期的存在，让民主国家不可能持续通过对外贸易来发展自己的经济——当社会矛盾积累到一定程度时，民主国家必定通过执政党的轮换，关起门来重塑自己的贸易政策，即使因此暂时损失了社会整体的经济利益也是避无可避。

## 全球化与国家自治

全球化与国家自治的冲突，在于全球化进一步发展，必然要求各国对于资本流通和实体行业的监管规则趋于一致，以扫清贸易的最大壁垒。

想象一下，形成一个无任何贸易壁垒、自由交换的统一市场需要什么条件？美国或中国的国内市场，跟全球化平台上的世界市场，有什么区别？

除了零关税之外，很容易想到的三个必要条件为：**(1) 统一的货币作为结算工具，(2) 统一的金融市场方便资本流通，(3) 统一的针对所有实体行业的监管规则。**

为了进一步推行全球化和世界贸易，在推动各国降低关税之外，在这三个必要条件上也必须同时推进。

### 01 统一的货币

一战以前，世界各国实行的是金本位规则，虽然没有统一的货币，但各国货币均直接与黄金挂钩，兑换方便稳定，不存在现代经济汇率浮动所带来的贸易风险。

然而，固定汇率加上自由的资本流通，所带来的直接结果便是各国的货币政策无法起到调控经济的作用。

比如说，中国和美国都将自己的货币设定为与黄金1：1的兑换比率，利率为3%。美联储觉得美国经济运行过热，需要提高利率以应对通胀，将利率提高为5%——借美元利息变得更高了，但是借人民币利息依然是3%。这时，因为两个国家货币的汇率是固定的，投资者会用手里的资金大量借人民币(3%的利息)，购买美元后再以5%的利息放出去，以赚取差价。

因为投资者会为了套利而大量购进美元，在固定汇率下，即使美国政府提高利率，依然无法降低市场上的美元供应，更无法用来减少通胀，调控过热的经济。

这就是国际金融市场上版本的“黄金不可能三角”，即一个国家不可能同时允许**资本自由流通(free capital mobility)、拥有固定汇率(fixed exchange rate)和独立自主的货币政策(independant monetary policy)**。

![ddf71f2220e924f76502f202b8171cb6ff0ca443](https://i.loli.net/2018/10/13/5bc145e297912.png)

如果一个国家想要实现零门槛的贸易市场，固定汇率和自由流通的资本会让贸易变得容易许多，大大降低了风险。商品跨境买进卖出，不管你用人民币还是美元结算，都无需担心汇率浮动而可能造成的损失。没有了资本流通的限制，贸易参与者可以自由的储备、兑换不同国家的货币用来结算贸易。

这种结算自由带来的代价却是贸易政策的无效化，使政府对本国经济控制力大大减弱，也丧失了国家自治的一个重要工具。

### 02 金融一体化

自从布雷顿森林体系崩塌之后，上世纪以WTO为核心的新一轮全球贸易体系一直致力推动**全球金融一体化(financial integration)**。

为什么要推动金融一体化？贸易的本质还是实体经济下商品在世界市场上的交换，那贸易的进一步增长就必须要依赖金融资本的流通——企业通过借贷来扩大生产，用增加的利润的一部分来偿还借贷的利息，理论上，把这个增长模型扩张到世界市场上，让资本在国际间自由配置，只会更加促进贸易流通和经济发展。

现代金融市场，能为企业提供融资的主要平台为银行、资本市场和各种不同目的的基金。设想一个创业公司，早期发展时从一个创投基金手里拿到了第一笔资金，规模扩张、有了稳定的现金流和资产后，向银行贷了一大笔钱继续扩张，在市场上做的小有名气了之后，选择到资本市场上市。

**所谓金融一体化，就是企业在经营和扩张的过程中，不仅能拿到来自本国的融资，还可以很容易接触到境外基金、银行和资本市场**。理论上，金融一体化可以让投资者分散风险，也可以让企业融资扩张变得更加容易，是促进经济增长的双赢局面。

各国的金融行业都有严格的准入制度，针对银行、证券、基金这些主要板块，更是有各自对应的监管机构，除了监管本国市场、防范系统性风险之外，更是会从国家安全和市场稳定的角度控制外资的比例。

如果一国允许的外资比例有上限，监管机构复杂且不透明，企业融资和“资方”供资的成本就变得很高，资本的流动性和其对贸易交换、经济增长的促进作用也就变小了。

因此，过去几十年，主要发达国家一直在全力扫清金融一体化的最大障碍：**资本管控和各国间不同的金融监管体制**。

事实上，上世纪的最后十几年，金融一体化的程度已经在飞速提高了。正当人们以为形势一片大好，准备高歌猛进的时候，20世纪末从拉美到亚洲的经济危机接踵而至，给了金融一体化致命一击。

主流经济学家们似乎到这个时候才意识到：**高度流通和盘根错节的资本能否会促进经济增长先不提，但首先带来的一定是一个一荣俱荣一损俱损的世界经济**。甚至由于全球的资本都入场成为玩家，一旦危机露头，加了杠杆的资本会如泄洪之水疯狂撤离，让一国经济面临雪上加霜的局面。

于是，各国政府都得面临一个这样的难题：如果提高金融监管的透明度和国际化程度、对资本流通又不设限的话，本国企业和银行的资产负债表上就逐渐积了越来越多境外的资金和债务，危机时被境外市场波及甚至拖垮的概率也大大提高了。

深入追求全球化和金融一体化，就会导致国境线在金融和经济领域几乎不起作用，市场彼此联通，风险和繁荣共生，政府治理自己国家的能力也因此大大降低。

### 03 针对实体行业的监管

假设你是中国的一个牛肉生产商，把牛肉卖到海南跟出口到美国有什么区别？你的牛肉需要符合的标准可能不同。

作为主权国家，需要监管的领域不仅仅是金融和资本市场，而是涉及国计民生、商品经济的方方面面。一国向另一国出口商品，自然需要满足进口国内部的质量标准。

但是，WTO规则下的贸易仲裁体系，允许一国政府在国际仲裁庭挑战另一国政府对实体行业的监管这种“内务”。

比如说，美国禁止巴西向其出口牛肉，理由是牛肉不符合美国的食品安全标准。巴西将美国告上WTO的国际贸易仲裁庭，说根据某项WTO条款，美国虽然可以援引食品安全标准而限制进口，但必须给出足够的理由。WTO的仲裁庭经过裁决后，审议了一番美国食品药品管理局对其食品安全标准的认定，得出结论说**美国政府在制定标准的时候没有给出足够的科学依据，太过武断仓促，因此不能根据这种标准来限制进口**。

类似的案例比比皆是，WTO的许多成员国，尤其是发达国家，都在贸易仲裁庭里跌过跟头，不得不修改自己本国对于实体行业的某些监管规则，或放弃对不符合监管标准的进口产品的限制。

也正因如此，过去20多年来，**WTO这种权力在发达国家内部引起了广泛争议**。按照美国这种民主国家的逻辑，民众依照宪法规定的选举程序，将治理国家、设定行业安全标准的权力赋予国会这种民主选举产生的立法机构。因此，美国国会制定的法律代表了美国人民的间接批准，可以用来约束美国境内事务。

WTO的整个体制却并非一个世界级的民主政府，而是各国间的合约和协定，性质可类比于两个私人主体之间的合同契约。**那为什么依照契约设立的一个仲裁庭，为什么可以直接否决一国内部根据民主程序产生的行业准则？**

这就好像公司的高管代表公司签订了一个处置公司重要资产的协议，对方拿着协议要求公司转让资产，但公司的实际所有者是股东，根据公司章程，高管并无权在未经股东许可的情况下处置资产。

因此，当贸易流通作为终极目标时，全球化与国家自治的根本矛盾就愈发尖锐。面对进口国与出口国对实体行业的两套监管标准，基于国际条约产生的WTO即使做出裁定，也难以让败诉国的利益相关方真正信服。

## 两条道路

Rodrik这套“黄金不可能三角”的理论框架，用来回顾历史和解释眼前的事件，都能得出非常有意思的结论。

人类的近现代世界经济史，贸易的繁荣与停滞，不同阶段的全球化模型，背后都可以归结出一条“在不可能三角中求平衡”的主线。

**全球化和民主能共存吗？**能，前提是国家自治和主权边界不断被蚕食，**甚至逐渐放弃国家边界而过渡到区域或世界政府(regional or global governance)**。上文提到过，用WTO下的争端解决机制来平衡各国监管制度与贸易政策之间的冲突，最大的问题就是WTO作为“私法契约”的性质，无法正当化其对民主国家内部事务的干预。

但是，如果扩张民主国家的边界，将这种政治体制折射到更广阔的地理区域，则有可能建立起一个更高层面的民主政府和民选机构，实现统一的货币和金融监管体制，也能更好的平衡新的疆域内不同群体的利益。

比如说，美国企业将制造业从铁锈带州转移到成本更低廉的墨西哥，引起铁锈带工人阶级的强烈不满。但如果墨西哥变成了美国的一个州呢？一个企业将工厂从肯塔基挪到了俄亥俄，并不会造成大批量的工人下岗——搬家就是了。

听起来有点像天方夜谭，但过去三十年，美国主导的世界经济格局正是小心翼翼往这个方向迈进。

二战后的世界经济重建期过去，西方国家的主流思想逐渐意识到，进一步用贸易来推动经济发展的最大阻碍在于各国之间，尤其是发达国家和发展中国家之间**监管和治理水平的差距**。生产关系对于解放生产力至关重要，为了发展经济，采取西方国家“先进”的全套体制是必经之路。

因此，**美国等西方国家开始了浩浩荡荡三十年的意识形态输出运动**——帮助发展中国家建立民主政府、提高监管水平、经济上打开国门、促进贸易交换和资本流通。国际上通过国际组织来推动全球统一的指导、标准和惯例，比如银行监管领域大名鼎鼎的针对风险管理的"巴塞尔协定"。与此同时，欧盟这种区域经济一体化的尝试也是不断在突破“放弃国家主权，保留全球化和民主"这一方向的可行性。

这条路走的通吗？跌跌撞撞，勉强在前行。真正世界政府的建立要面临大量历史、政治、社会文化上的冲突，西方国家在推进这个方向的同时还要面临既定民主程序下来自国内的压力。过去这几年，特朗普上台，英国退欧，欧洲保守主义政党卷土重来，都可以看作是不断推动宏观上的“世界政府”之后来自民主程序的反击。

先不谈这条路本身前景如何，中国的存在，让“保留全球化与民主，但是放弃国家自治”这条路，彻彻底底变成了不可能。
**建立世界政府的前提，是每一个选择加入的经济体，都愿意遵守同一套权力产生的政治体制：民主**。30年前，美国等西方国家张开双手拥抱中国加入WTO，就是对这个人口庞大的古老东方国家寄予厚望，希望其在市场和经济不断开放的时候，也能逐渐接受美国这一套政治体制，变得更加民主和自由。

现实给了美国沉重的一击。在“黄金不可能三角”的悖论中，中国改革开放走的路是放弃了民主，但守住了全球化和国家自治。由此带来的经济奇迹也证明了一个道理：**在非民主国家，依然可能产生类似于西方世界的自由主义市场经济，而且这种经济形式在国际贸易市场上有天然优势**——执政者一心以发展贸易、提升经济为终极目标，不需要面对民主程序下换任选举的压力，而且有灵活充足的手段来弹压和平衡国内因为贸易而受到冲击的利益群体。

## 对抗与冲突

这两条全球化道路，有哪一条更具有天然优势吗？

长远来看，其实不必然。目前中国和美国的经济都面临各自不同的问题。中国改革开放30年以来的房价泡沫让债务天平岌岌可危，贸易战下出口疲软，房市又死死拖住了居民的消费能力。政治体制的特色虽然可以让中国在对外贸易政策上有极大的灵活度，但因此产生国内的社会矛盾，不能通过民主程序解决，总是要寻得手段消化掉的。

美国自从特朗普上台后，实际上是暂时放弃了“全球化+世界政府”的战略，搁置全球化，通过民主程序来平息国内的社会矛盾。自从开始打贸易战，更是彻底放弃了其30年前亲手建立的WTO体系，转而通过减税来给经济添一把油，试图对冲贸易战线全面收缩而带来的经济损失。然而经过了08年后十年的经济不断增长和债务累积，主流观点均认为美国又来到了一个经济周期的末期，下一次危机可能近在眼前。

两条道路的“优越性”不分伯仲，但本质上却必定是一个水火不相容的状态。

单看过去的30年，美国为了推行自己“全球化+民主”的战略，积极帮助中国建立起市场经济，并殷殷期盼着拿下中国这个重要同盟。眼看着中国经济不断发展，但政治上丝毫没有更加开放的趋势，美国也只是通过TPP协定进一步深化“全球化+民主”的框架，试图通过孤立围堵的策略让中国弃暗投明。然而，**中国的体制和文化都异常坚挺，借着美国推动全球化这股东风，明修栈道，暗度陈仓，以一条截然相反的“全球化+国家自治”的战略打开了自己的路，实现了人类历史上经济发展的最大奇迹**。

二战之后初期，美国的经济总量占世界经济的50%。在1980年，美国占**22%**，中国占**2%**。中国经过了30年改革开放的经济腾飞，在2016年经济总量占到了**18%**，美国则进一步跌到了**16%**。按照中国目前的发展趋势，再过20年，中国的经济总量可能会达到**30%**，美国则仅占**11%**。

从长期来看，美国已经彻底放弃了让中国走向“全球化+民主”的希望，无法成为同盟便是敌人，拉不到自己这条路上来，只能全力阻击对方在相反路上的发展壮大。

特朗普上台后，美国表面是暂时放弃了“世界政府”的战略，退出TPP，主动跟中国打贸易战，**但民主和国家自治，中国和美国道路到底要选哪一个，历史迟早要做出选择**。

虽然特朗普上台后全球化战线全面收缩，**但根植于美国历史和价值观的长期路线是无法转移的：美国只能继续走全球化+民主这条路**。如果按照现在的路线，暂时放弃全球化，走民主+国家自治，那等减税的红利期过去，经济迟早要进入迟滞，实质上是把全球化这个领域拱手让给中国，让其用全球化+国家自治的道路毫无阻碍的继续发展自己的实力。

因此，当美国通过民主程序下执政党的轮换，不得不暂时搁置全球化政策的时候，短期内便要全面狙击中国的进一步发展：**我这条路现在走不通，你也别想抄近道赶到前面去**。

在没有爆发科技革命的前提下，人类经济的持续增长和繁荣，取决于市场流通和贸易交换。但很可惜，想要通过全球化而实现经济增长，民主和国家自治必须得放弃一个。

为什么说中美贸易战打到现在，其实实质上是体制之争呢？因为这背后是两条不同全球化道路的本质矛盾：**是要全球化和民主，还是要全球化和国家自治**。两个国家都在各自的道路上越走越远，已经回不了头了。

## 模式冲突的背后：价值冲突

为什么在“不可能三角”中，美国会选择民主，而中国会选择国家自治？

大概这三十年来，美国人一直在不停的问自己这个问题。
上世纪美苏争霸，美国胜出后对自己的体制优势坚信不移：**开放的政治会导致开放的经济，开放的经济等于繁荣的经济。**

因此，当中美恢复建交，中国这个曾经的社会主义国家要进行改革开放，想加入WTO时，美国如一只刚打赢仗的雄狮，骄傲的点点头收下一个小弟，谁不知是让身后跟了一条狐狸。

中国改革开放的30年，实际上是在不停实验一条人类历史上从来没有过的体制：**不开放的政治能不能导致开放的经济，这样开放的经济是否会是更繁荣的经济？**

在30年前的美国人眼里，政治开放和经济开放互为充分必要条件，互相促进，不可分割，构成了一个强大而发达的社会和经济体。美国的骄傲和自信让其从来没有认真了解过中国，以为后者选择了经济开放就迟早要迎来政治开放，却没发现狐狸学了狮子的本事，摇身一变披了一张豹子的皮，灵活而强壮，有自己的一套攻守策略。

人类组成的社会是如此复杂，有着个体永远无法探究和掌控的宏观规律，当你以为你发现的规律是人类社会运行颠扑不破的真理时，现实总是狠狠打你的脸：在古老广袤的东方土地上，一个有着截然不同历史、人口庞大的国家，实验出了一条新的规律。

于是，近些年，美国国家安全和经济战略领域的专家们，纷纷开始花大力气研究中国，主要命题有三：(1) 中国是怎么做到切断经济开放和政治开放之间的相互作用的？(2) 中国为什么非常顽强的选择了国家自治，而从未接受美国这一套民主战略？(3) 中国道路的未来是什么，是会和平崛起还是会威胁到美国的国家安全？

最近看了几本这些领域的书，看着美国的专家们绞尽脑汁的研究这片华夏大地到底特殊在哪里，从孙子兵法、秦始皇、三国时期一路研究到中国的近代史，试图提出一套完整自洽的观点来解释中国这上下五千年，倒也觉得这百家齐放的观点背后真的是在"on to something"。

最近看的几本这个领域的书，按照对中国的理解的靠谱程度由高到低排序：

1、**_Haunted by Chaos, China's Grand Strategy_** by Sulmaan Wasif Khan

2、**_Destined for War_****_, Can America and China Escape Thucydides's Trap?_** by Graham Allison

3、**_On China_**, by Henry Kissinger

4、**_The Hundred-Year Marathon, China's Secret Strategy to Replace America As the Global Superpower,_** by Michael Pillsbury

美国人后知后觉的开始研究中国，逐渐意识到这样一个事实：**中国有着漫长悠久的历史、独成一脉的文化、和极其顽强的价值观，这样一个国家的人民，与他们终究还是不同的。**

我试着总结一下美国人觉得这些“不同”在哪里，觉得主要在于一点——“**大一统**”。中国由于其独特的历史和文化背景，对领土的统一和完整非常执着，经历过几千年强大的中央集权政府，对于推进一种“国强则我强”的民族主义情绪有天然的土壤。近代史更是不断固化和加深了这种情绪——只有强大的主权国家才能免受侵略，永保安宁。**荣耀感和安全感因此催生了一种对“国”的强烈认同。**

与“国”相对的概念，则是“我”。现代意义上的“国家”是独属于人类社会的一种政治组织形式，而深入到哲学范畴，个体如何看待自己与“国”的关系，往往决定了政权产生的形式为何——**是“国”强大最为重要，为此“我”可以牺牲自己的利益？还是“我”的权利最重要，因此“国”的权力应该受到选举的制约和分权制衡？**

美国人发现，中国人有一种他们理解不了的集体观：**为了集体的强大、和谐与统一，“牺牲小我、成全大我”是一种值得鼓励的精神**。美国人则恰恰相反：**个体的权利，“人”的价值才是这个世上地位最高的事情，“国”的存在不过是创造稳定的市场环境和基础设施，为“人”的幸福发展提供环境，因此“国”的权力天然不被信任，必须受到严格的限制**。
这背后的原因，自然是根植于工业革命时期东方和西方两段截然不同的历史的。

欧洲国家从中世纪宗教至上过渡到对个人权利的尊重和信仰，经历了漫长的革命和战争。美国作为被殖民的新大陆，无需这个推倒重建的过程，轻轻松松便接受了这一套在200年前让现代经济腾飞的核心价值，但也因此将这套价值天然化与正当化，认为天下都该如此——关于民主制度历史根源和本质属性的一些想法，我在一年前写过一篇文章《[一场重点全错的毕业演讲风波](https://mp.weixin.qq.com/s?__biz=MzI4NjEyMzcxMg==&mid=2650550748&idx=1&sn=d2ec553756df891fa45d328c73ebf1f7&chksm=f3e92273c49eab653003defd7933cdbaac8dfd44a18d1767e688878ca4ced8eaa2b80c209c0e&scene=21%23wechat_redirect)》，现在看来，这两篇中的逻辑和观点倒是接上了。

## 结语**

对于未来，我的想法是悲观的。中国韬光养晦，借他人东风养自己实力的30年已经过去。苏联解体后世界平静了三十年，是因为美国以为就意识形态和体制设计而言，谁胜谁负已经有了答案。时至今日，一切转移视线、拖延时间的战术都已用尽，美国也肃清了国内矛盾，齐心协力将中国视作头号对手。别无选择，避无可避，谈无可谈，因为哪一方都不可能放弃自己的体制和道路，只能正面对抗。

成长在90后的这一代人，人生的前30年是中国入世后，经济飞速增长、世界更加开放的30年，然而未来的30年，不管对于中国还是美国，道路必然都不是平坦的，我们的经济和社会也不再会是直线发展。冲突、矛盾、失望、困惑才更有可能是这个世界新的常态。

不过，乱世有乱世的活法。能在“盛世”之后站在人类历史的转折点，也是我们这一代人特有的人生体验吧。

**文末硬广**

**利益相关：自己的课**《[来啦！丹喵课堂正式上线，一套带你走入新世界的学习指南](https://mp.weixin.qq.com/s?__biz=MzI4NjEyMzcxMg==&mid=2650551335&idx=1&sn=3aba9c86d15c165e2078199ca08af3dc&chksm=f3e92788c49eae9e5a237de90cba248e0fdfd89b2617c418406e8a19c73366110cc5456ee86b&scene=21%23wechat_redirect)

![a29c9cd2b0a8a7fab50068c233635c99c71c6558](https://i.loli.net/2018/10/13/5bc145183e49d.jpeg)
