---

layout: post

title: 老田：寿光洪灾真相！世道人心是如何被出卖与收买的

categories: Archive

date: 2018-08-31

tags: 寿光洪水

image_feature: "https://i.loli.net/2018/09/02/5b8b140bce493.jpg"

description: 水库防洪库容运用方面是否受到过局部利益的扭曲？

---

原文来自微信「一颗土逗」：~~[老田：寿光洪灾真相！世道人心是如何被出卖与收买的](https://mp.weixin.qq.com/s/TBoygrK4XnNoxNFI0Wg-TA)~~

---
![一颗土逗.gif](https://i.loli.net/2018/09/02/5b8b13a69e65e.gif)

![寿光水灾-1.jpg](https://i.loli.net/2018/09/02/5b8b140bce493.jpg)

> 作为一个自然事件，寿光洪灾也正检验世间的人心百态。各路人马面对这个事件，表达出种种思考和追求，值得仔细回味。目前看来，洪灾期间，有两种搭便车心理遭遇到一起了：弱势群体想要对外转嫁成本，政府和资本想要借机创造收益。双方“搭便车心理”，处于一种相互反对状态，因而忽略了如何在现有条件下提升减灾能力的真问题。

作者 \| 老田

编辑 \| 王乐天

美编 \| 黄山

微信编辑 \| 侯丽

8月29日，山东省政府的新闻发布会称，这次灾害，“国家防汛抗旱总指挥部办公室专家组认为，一周内连续2次超强降雨是造成洪涝灾害的主要原因，潍坊市水库调度做到了提前预警，最后一次预警较洪峰到达提前6小时，使受威胁群众能够及时转移，水库调度符合调度方案规定。”

寿光市历年平均降水量为591.9毫米，且五六十年代后还呈下降趋势。这次一周内两次强降雨，降水量超过全年三分之一，确实会诱发超标洪水。所以，省政府发言人的看法可能是成立的。不过，这个发言并没有回应早先的传言，特别是没有回应传言背后的问题，未能与传言实现真正的观点交锋。

早先传播链条中接受度最高的传言，是怀疑上游水库为了蓄水卖钱而未能恰当地履行防洪职责，另一个传播度较高的传言是说洪灾正酣时期水库为此大量泄水加重了灾情。**这两条传言合起来，透露出这样一个问题意识和焦虑：水库防洪库容运用方面是否受到过局部利益的扭曲？**

洪灾究竟如何救？实际上有多少救灾能力？救灾能力如何产生及其所引发的成本谁来负担？这些背后的问题，虽然没有被明确提出来讨论，但是在各路人马的自我表现及其推荐方案中间，潜在问题意识，都没有缺席过。

---

### 寿光历史上的洪灾与“保险费支付意愿”

---

此次洪灾最严重的灾情出现在弥河流域诸县，寿光最严重，其次是青州和临朐。整体上看，算是一个小流域的超标洪水事件。

一般而言，小流域较容易出现局部暴雨诱发的洪灾，此种洪灾相较于大江大河灾情，更为集中和难于处理。有一句增广贤文说“易涨易退山溪水”，很贴切地讲述了此种洪灾的问题，前述“一周之内2次超强降雨造成”的说法，对于小流域而言是常见的。

本次洪灾最为严重的是弥河两岸，弥河“全长127.5公里，流域面积3863平方公里。上、中游位于山丘地区，为窄深山谷河道，下游入寿光县境为弯曲宽浅河槽。”据《寿光县志》记载，弥河危害寿光历史上就很严重，“历史上弥河多次改道，所以有‘寿光县，弥河串’的俗谚。现在依稀可辨的古弥河道有6条。”这当然符合大多数河口冲积平原的形成原理。

正因为洪灾频繁，损失很大，所以，减灾工程特别值得投入，这与保险事业有类似之处：对各种频繁造成损失的灾害，人们更愿意支付保险费。

据《山东水利志》记载，“从1840年到1990年的150年间，共发生大的泛滥决口13次，造成严重灾害。”其中，“建国后1956、1957、1963、1974年均决口成灾。1974年8月9日，7天连续降雨302.6毫米，冶源水库溢洪1800立方米每秒，弥河两岸决口18处，494个村庄被水包围。”因险情经常发生，人们支付保险费的意愿就很高，各类减灾工程投入就开始成龙配套。1949年之后，在弥河上游修筑水库，在中下游整治河道并发展灌溉事业，尾闾因为行洪能力差所以开辟了分洪河道，这样多管齐下，才使得弥河两岸应付洪灾能力有显著上升。

1958年以后，得益于乡村三级政权的完善，以动员劳动力密集投入活劳动的方式修筑防洪工程，大规模展开。据《山东水利志》记载，“从1958年开始，在河流中上游，先后兴建了峡山、牟山、墙夼、高崖、三里庄、青墩子、石门、于家河等大中型水库18座，大量拦洪蓄水，削减河流洪峰70％以上，河流洪水显著减少。从1951-1990年，尽管先后遇到了1957年、1960年、1974年等较大和特大洪水，均保证了安全。”

其中，弥河上游修建了冶源大型水库和丹河、嵩山、黑虎山3座中型水库，蓄洪能力最强，这“4座大、中型水库共控制流域面积1164平方公里，总库容3.15亿立方米。在寿光县境两岸修建引水涵洞14座，设计灌溉面积10.8万亩。”

支付保险费的意愿高昂，除了上游修筑水库控制洪水的工程措施之外，中下游河道治理修筑堤防并增加泄洪能力，发展灌溉事业，也是很重要的关联部分。据《山东水利志》，“1951年，寿光县组织民工自张建桥到周疃村培堤36公里，国家投入工赈小米100万公斤。当年又自中营村向北开挖分洪河道29公里，分洪1000立方米每秒。次年又于半截河村北向东挖分洪道15公里，并建排水涵洞18座。1958年培修加固鹿家庄子至周疃村段长14.5公里的两岸堤防。1964年，对张建桥到半截河村28公里的两岸堤防培修加固。1975年，培修堤里村到半截河村两岸堤防43公里，同时先后做险工护岸37处，共长11941米。”

这些都是集体农业时期减灾工程的进步。而其后的衰败，内在体现了减灾投入的先决条件的变化。

---

### 世道第一变：减灾工程投入的管理结构之变

---

寿光历史上洪灾严重，由来已久，由此所激发的修筑减灾工程“支付保险费”的意愿一直很高。但是，具体支付保险费进行减灾工程，大规模的洪灾治理事业，主要集中在1949年之后，尤其是在1958年之后，这不是没有原因的。

**从县志记载的减灾工程修筑过程看，最主要的减灾工程投入，是活劳动的密集投入，这就给减灾工程投入施加了一个先决条件：必须要有能够有效组织剩余劳动力投入的管理结构，而集体农业时期的乡村三级政权恰好能够满足这个先决条件。**

集体农业时期的管理结构，能够较好地反应“保险费投入”需要，所以，各种减灾工程规划和落实，就能够大规模展开。据《寿光县志》记载，减灾工程投入中间，劳动投入数量极大，资本物品的投入就很微薄：

“1951～1983年，用于治理弥河投资47.35万元，完成土石方432.43万立方米，投入工日297.28万个，治理长度总计280.9公里；用于护岸工程投资111.66万元，完成土石方2.21万立方米，投入工日40.22万个，护岸长度11.94公里。”（《寿光县志》）

另外一条重要河流，丹河在“建国以来，丹河治理7次，治理长度达237公里，国家共投资92.44万元，完成土石方424.3万立方米，用工日193.2万个。”此外，县境内的小清河也得到系统的治理。

同时，在寿光北部沿海地带，结合治理低洼地带的盐碱地，曾经进行了系统化的沟渠排水规划，挖沟取土以增高台田，极有利于排除渍水能力的提高。

> “自1974年始，县农田建设指挥部制定了农田基本建设的统一标准。规定台田筑高20～30厘米，台田沟上口为8～10米，沟底宽为2～4米，沟深1.8～2.2米，台田宽50米，长300米；条田宽50米，长300米，条田沟上口为5～6米，沟底宽1米，沟深1.5～1.8米；并提出了‘沟、渠、林、田、路统一规划，合理布局，旱、涝、碱、潮综合治理’的方针，对全县土地统一规划。”（《寿光县志》）

这项工作从1950年代中晚期开始，70年代形成大规模潮流，其后果很有利于渍水排泄，降低涝灾的持续时间和损失，但在1986年之后，就完全停止了。

![寿光河道水系图.jpg](https://i.loli.net/2018/09/02/5b8b18eab44f4.jpg)

<figcaption>经过集体农业时代30年，寿光县境内水系得到较大改造</figcaption>
<figcaption>图片来源：《寿光县志》</figcaption>


因为减灾投入主要依赖活劳动投入，而活劳动投入的先决条件又是集体农业时期的管理结构——农村三级政权对于劳动力的合理调配，结果，集体农业瓦解之后，这个管理结构就难于长期存在而陷入逐步瓦解中。

不过，在三十年的集体农业时期，寿光的水系治理和抗旱除涝条件，得到了显著改变，从地图上看，变化之大，很有点“誓把山河重安排”的感觉。

---

### 世道第二变：很难筹集减灾投入的个体农业

---

大体而言，对减灾工程的密集投入，主要发生在集体农业时期，等到1980年代分田到户之后，农村曾经能够有效动员剩余劳动力的管理结构，逐步趋于衰败。1988年是最后一次培修弥河大堤，差不多的时期还搞过一次排碱工程，这是因为当时老的管理结构依然还发挥作用的“惯性作用期”之内，此后就不再有投入减灾工程的安排了。

应付自然灾害，需要投入相应的工程措施，没有这样的工程措施就很难控制洪水和及时排除渍水。在一定程度上，减灾能力与工程措施的投入之间互为因果关系。哪怕是减灾工程已经完成，由于排水工程多为土渠土沟，会年年月月发生淤积，这就需要组织人力进行周期性的再投入，去加以维护，否则其排洪能力会跟着淤积状况发展而逐年下降。

恰好，在集体农业解体之后，减灾投入的合适管理结构瓦解，而原有的工程措施就陷入逐年退化，四十多年来减灾工程方面“欠账”过多，使得减灾能力不足以应付本次规模的洪灾，因此，超标洪水带来灾害就有了必然性。与此同时，单位面积上的人口和财富密度又大幅度增加了，使得同等灾情条件下的灾害损失数字，也大大增加了。

**拿本次灾情最集中的寿光来说，地形是接近河道入海口的平原地带，河道洪水宣泄能力远小于过洪量，导致河堤漫水致灾，这是成灾原因。同时，河堤漫水结束之后，各地渍水排泄能力不足，至今依然有村庄被渍水淹没，这又成为灾情持续与扩大的因素。**

较不为人们注意的灾情扩大的潜在因素，是分田到户之后个体农民合作自救能力过低，有限的救灾设施和能力未能集中合理运用，以至于未能避免损失扩大。

寿光作为全国最著名的蔬菜种植基地，有近60万亩大棚蔬菜，这在全国农村中间带来显著的不同，绝大多数青壮年劳动力均在村里从事蔬菜种植业。如果不是集体农业时期的管理结构瓦解得相当彻底，有那么多劳动力在家，如果能够结合强有力的领导起作用，团结起来进行自救努力，保住大棚肯定比较困难，但应该有些村庄能够保住，不被水淹。

对照毛时代基层组织完善时期的成功案例，可以看到管理结构缺失带来的灾害放大作用。据五公大队村史记载，1963年海河流域特大暴雨期间，河北饶阳县五公村的社员，在干部带领之下，不仅保住了村子，还奇迹般地保住了3000多亩庄稼：

> “一九六三年，五公大队遭到了涝灾，滂沱大雨直泄而下，一连下了七天七夜，降雨量远远超过了正常年份全年的降雨量，雨大水猛，再加上滹沱河上游洪水爆发，洪水雨水汇流成河，吞没了眼看要上场的三千多亩庄稼。在这严重的自然灾害面前，五公人民没有垂头丧气，在党支部的领导下，他们和洪水展开了英勇的搏斗，保住了全村集体和社员的财产及生命安全。”

在自救行动能力超强的情况下，自信就有了依据，“上级给五公拨来了一笔数目不小的救济款和救灾物资，……他们又一次谢绝了国家的拨款，并满怀激情地提出‘生产自救，节约度荒，同舟共济，支援兄弟队’的口号。他们白天冒烈日，晚上披星星，排出了地里的积水，扶起了冲倒的庄稼，修好了冲平的田埂，并通过加强灾后的作物管理，使粮食亩产达到四百一十斤。在这大灾之年，五公大队不仅保证了社员的口粮和种子、饲料，而且还主动完成了全年八万五千斤粮食的征购任务。此外，还拿出五万斤蔬菜、三万五千斤粮食、上万斤饲草，支援了重灾的兄弟队。”这当然是那种高超自救能力的一曲颂歌，也是对照自救能力为零的合适参照。

从本次寿光灾情发展状况看，农民群众在分田之后缺乏集体协同能力，不仅导致减灾工程投入的终止，也导致抢险救灾能力和自救意愿的极度下滑。有限的救灾设施不能够集中有效地运用，结果救灾效果奇差，有些有条件保住的村子，因为缺乏团结自救的努力，最后还是被淹了。

![寿光水灾-3.jpg](https://i.loli.net/2018/09/02/5b8b19a119788.jpg)

<figcaption>左图：救灾机制过于分散，无法取得成绩</figcaption>
<figcaption>右图：村庄在有效自救下应该能保住</figcaption>


本次灾情最重的口子村和南宅科村，没有保住大棚是可以理解的，这是超过村庄自救能力的过高目标，但是，还有部分村子是有条件通过自救而保住的。但没有人为此发起过集体努力，试图去保住村庄，这说明集体农业瓦解之后，人们要进行集体努力的能力，跟随管理结构的瓦解而近乎下降为零了。

在有预警时间的情况下，基层管理结构因其极度衰落，缺乏组织自救的执行力，只履行了一个通知人们及时转移的最低职能。

---

### 人心第一变：自主救灾能力下降之后的“等靠要”心理

---

人们看世界的自信和理性态度，往往与自己手边掌控的投入与产出的相互匹配关系紧密相关。一个目标或者产出，所需要的投入数量，远大于自己能够控制或者可及的数目，那么，自己行动起来达成目标的意愿就会相应地低落，对外部转嫁成本和风险的意愿就会高涨。

1949年之后，人们对历史灾害的记忆激发了较高的减灾投入意愿，这是有效的管理结构之外的重要驱动力量。自1974年之后，四十多年来太平无事，侥幸心理就日渐累积下来了。分田之后原有的管理结构瓦解，这固然制约了减灾投入能力，但是，太平无事的历史记忆，会促进风险防范意识下降，甚至对减灾投入的支付意愿也肯定会相应地下降，侥幸心理会相应地上升。

侥幸心理的上升，会带来对减灾成本支付的拒绝，会不自觉地促成关于减灾投入和成本分配的模糊认识，会自动地催生各种“搭便车心理”——期待减灾成本由某个外部主体承担，潜意识地认定减灾成本与自己无关了。

正是因为这种普遍心理，才会有一个水库防洪库容调度是否合理的疑问，以及洪灾是否人为的失误造成的。**“追查外部责任人”与“自我责任为零”的扭曲想象互为表里，由此进一步产生了局部利益是否妨碍公共利益的质疑。当然，水利改革的市场化方向选择——这是肯定局部利益优先的思路，也应该时刻担当这样的合理质疑。**

从逻辑上说，如果可以证明某个人或者特殊主体应为洪灾单独负责，那么，自己之于洪灾的共同责任就被“摘掉了”，这种认识中间潜在地推荐了一种“减灾成本别人负担”的成本分配观念。

应该说，侥幸心理的作用是普遍的，不仅民众如此，水利管理机构亦然。作者曾在十年前实地看过青州境内的弥河河道，河道不仅主泓散乱，河床随处坑坑洼洼，明显是长期失修的结果。因为河道来水不足，就无法通过径流冲刷自动维护河道平衡，又未曾得人工的合理修复，各种偶然的破坏因素留下的印记，都在降低河道行洪能力。

也就是说，河道自己不行了，人们也不觉得需要去帮一把，这种情况由来已久了。在这样的大背景下，水库防洪调度如果没有达到最优，并不奇怪。

在某种程度上，自己可及的投入不足，就看不清产出或者目标如何达成的有效路径了，由此，就开始潜意识地减少自身的责任并且不愿意承担减灾成本了，就有了搭便车的心理，这种心理多了，就会潜意识地催生各种对“神仙流”的想象——某个单独主体足以控制一切。正是因为如此，在寿光洪灾中间，很少人追问如何才能够实现有效减灾，历史上成功的经验和失败的教训又有些什么。

---

### 人心第二变：各路操作寿光洪灾题材的力量

---

民众的“等靠要”心理上升，会过度追究官方和其他强大主体的责任，各种想象会因此产生并的得到快速传播，结果，这肯定会遭遇到另外一波“人心不古”的情况，形成极其有趣而鲜明的对照。

政府、资本和其他基于利润追求的事业，比普通民众更能够发出自己的声音，这些声音除了网络传播渠道之外，还能够占据主流媒体的空间。结果，就有人在网上抱怨，说官方宣传总是“把祸事当做喜事说”，目的当然是为了突出领导有方、政绩卓然，结果，认真总结经验教训的工作，就没有人愿意去做了。

作为全国最著名的蔬菜种植基地，寿光大棚数量超过16万个，是典型的资本农业的“高投入”状况，因此，才使得灾情带来的损失极为严重，尤其是对个体农民家庭打击特别大。农民的忧患和损失，结果有催生了另外一拨人出来表演了，有人趁机想要向农民“卖保险”，就趁机发声说农业保险如何如何重要，现在灾情损失和灾后困难，都是因为农民不重视投保的缘故。

**在信息传播中间，如果知识与资本利润紧密关联起来之后，就发生这种信息传播上的重大扭曲，遮蔽真正有效的“保险费支付”模式——对减灾工程的投入，欺骗性地确立农民对于保险业的信赖，目的当然是为了把农民及其生产条件，纳入保险业的经营和利润创造链条，提高农民参保缴费的意愿。**

应该说，把洪灾损失与农民参保意愿低落联系起来，这是把农民“往沟里带”的宣传。保险业基于“大数规则”而成立，像水灾这种“一淹一大片”的灾害，不符合大数规则之下的险情概率发生机制，不属于保险业的常规经营范围。而且，保险赔款只是一种事后的货币补偿，与灾后救济所要求生产和生存物资需要，并不能够完全吻合。所以，水灾无论是从险情发生状况，还是从灾后补偿要求来说，都不是保险事业能够涵盖的。

寿光的农民正在悲伤自己的损失，北京控制蔬菜渠道的资本，则认为出现了一个超好题材，是一个难得的发财机会，他们可以借机炒作一把，据网络信息有人想要借此把某些蔬菜批发价格提升百分之四百，这就成了一种特殊的“人祸”传递机制了。

![寿光灾区市场.jpg](https://i.loli.net/2018/09/02/5b8b1a5d94a0e.jpg)

<figcaption>探访寿光灾区市场 图片来源：cqcb.com</figcaption>


从蔬菜市场供需状况看，不要说寿光这个灾情，哪怕是灾情扩大十倍，依然不会改变蔬菜市场上“供大于求”的事实。依据第三次农业普查资料，截至2016年12月31日，全国大棚种植面积高达98.1万公顷（其中东部477.4、中部18.6、西部21.5万公顷），此外还有温室33.4万公顷。寿光大棚蔬菜种植面积确实占据重要地位，“全市蔬菜生产基地发展到60万亩”，但仅占全国总面积3%左右。由于该行业早已经供过于求，且严重过剩到超出市场容量一倍以上，所以，从真实的供求关系来说，损失一半的蔬菜供应，还不足以真正撼动供需平衡关系。

**在严重供过于求的中国蔬菜市场上，资本还常常能够表现出自己的能耐和追求，全国人民对此早就不陌生了。从前些年“蒜你狠”“豆你玩”“姜你军”等各种资本主持的成功价格操控事件，早就窥见其本质。**虽然这次洪灾并没有真个改变蔬菜的供求关系，但是，掌控蔬菜批发渠道的资本力量却足以控场，相应地，基于洪灾题材的炒作和提价早已经开始了，而城市居民的买菜价格上升看来也在所难免了。

---

### 一个小结：理性的相互反对，抵消状况如何终结？

---

经粗略对照之后，不难发现，普通民众由于合适的管理结构瓦解，组织自救能力下降，也会漠视减灾成本的合理支付要求，迫切希望对外“转嫁成本”，这也符合理性选择的要求——自己背负不起来的高成本，肯定要想着转嫁给背负能力强的人。网络传言中间，各种普通民众发言和质疑，无不体现这个搭便车心理。

**同时，强势群体在寿光洪灾期间，其主要追求是借机“创造收益”，不管地方政府宣传中间“把祸事当做喜事说”，还是突出农业保险的重要性，都是为了创造新的收益。**而蔬菜批发资本依仗垄断渠道供应的强势地位，则选择借机涨价。从政府到资本的努力也都体现了充分的搭便车心理，但他们的强势地位，使得他们可以借机拓展出新的收益空间。

看起来，还是罗伯特·西蒙的看法比较准确，组织能力除了对于人力物力资源的集中规划使用之外，还有很重要的一点在于：可以把个体理性提高到组织理性，更切近于客观理性。但组织理性达成本身是有条件的，需要相应的管理结构去提升人们的行为能力，更高的行为能力还能够支持更高的理性思考，在可及的投入数量足以支持产出目标时期，客观理性最容易达到。所以，追求政府与民众的合作与协调，仅仅依靠说教其作用是有限的，这迫切需要在组织理性方面，构建更多的实质性沟通和相互提升。

我们目前看到的，是一种局部理性的相互抵消和反对状况，是民众的搭便车心理，反对政府的搭便车心理，前者想要据以转嫁成本，后者想要借机创造收益。很可能的一种后果是：双方都无法实现自己的指望，而且双方能够实现指望的程度，由于其相互抵消，都会小于实际所许可的潜力。



参考文献：

[1]  山东省政府：超强降雨是洪灾主因，潍坊市水库调度符合规定，
网址：[https://www.guancha.cn/society/2018_08_29_470160.shtml](https://www.guancha.cn/society/2018_08_29_470160.shtml)

[2]  《山东水利志》，网址：[http://lib.sdsqw.cn/bin/mse.exe?seachword=&K=b7&A=1&rec=289&run=13](http://lib.sdsqw.cn/bin/mse.exe?seachword=&K=b7&A=1&rec=289&run=13)

[3]  《潍坊市志》，网址：[http://lib.sdsqw.cn/bin/mse.exe?seachword=&K=b7&A=1&rec=132&run=13](http://lib.sdsqw.cn/bin/mse.exe?seachword=&K=b7&A=1&rec=132&run=13)

[4]  《寿光县志》，网址：[http://lib.sdsqw.cn/bin/mse.exe?seachword=&K=c7&A=10&run=12#0](http://lib.sdsqw.cn/bin/mse.exe?seachword=&K=c7&A=10&run=12#0)

[5]  南开大学历史系五公大队村史编写组《五公人民的战斗历程》中华书局1978年，第115-116页

[6]  《北京部分蔬菜批发价涨400% 新发地换产区补货供应》，网址：[http://www.sohu.com/a/250244801_384516](http://www.sohu.com/a/250244801_384516)

[7]  国家统计局：《第三次全国农业普查主要数据公报（第二号）》，网址：
[http://www.stats.gov.cn/tjsj/tjgb/nypcgb/qgnypcgb/201712/t20171215_1563539.html](http://www.stats.gov.cn/tjsj/tjgb/nypcgb/qgnypcgb/201712/t20171215_1563539.html)
