---

layout: post

title: 袁隆平神话

categories: Archive

date: 2018-08-21

tags: 袁隆平

image_feature: "https://i.loli.net/2018/08/25/5b80f35764039.jpeg"

description: 杂交水稻之父是怎样升起的？

---

原文来自微信号「黄章晋」：~~[袁隆平神话](https://mp.weixin.qq.com/s/aTxhnKdIfFmQ-ihjfNleog)~~

---

杂交水稻之父是怎样升起的

![dafb8fc893c007a90f9abc485ad501be6b079186](https://i.loli.net/2018/08/25/5b80eb1e3255a.jpeg)

十多年前，有次听一位长沙官场上的老同学无意中说，有位年轻水稻科研人员被袁隆平打压，不但经费批不下来，甚至东躲西藏弄块试验田都搞不成。当时，袁隆平是神一般人物，我对此并未往心里去。

后来有两件事让我对袁隆平感兴趣，一个是2007年12月福建农科院研究员谢华安当选中科院院士，再一个，是网上有人实名举报打着袁隆平招牌的隆平高科涉嫌腐败（袁本人并未被指控牵涉其中）。回头找老同学帮我介绍采访对象，自然是百般推脱。

隆平高科被举报的上市时的腐败事项，随着时间推移，已极难查证，后来我们报道袁隆平时，发现它即便当年有圈钱嫌疑，也没太大的报道价值，而当年的举报者，有的去世，有的则兴致了了。

值得一说的是谢华安。当年谢刚当选中科院院士，就有人向方舟子的新语丝举报，谢华安论文涉嫌抄袭。新语丝虽然让谢华安丢尽颜面，但对我来说，扒谢华安的老底，却有为其恢复荣誉的意味。因为我这才知道，中国除了有个「杂交水稻之父」，还有个「杂交水稻之母」，「杂交水稻之母」不是别人，正是这位谢华安。

以前，我只是从媒体报道中得知，袁隆平的杂交水稻让中国水稻亩产提高了20%，多养活了7000万人，这次才知道，袁隆平当年培养的杂交水稻，刚推广没多久，就因大面积爆发稻瘟导致颗粒无收，这时，谢华安培育的杂交水稻「汕优63」及时救场，谢的「汕优63」，在播种面积上，连续16年位居第一。

谢华安当选院士变成丑闻，不免被闲话和翻出各种旧账：袁隆平、谢华安在学术理论上的建树远不够申报中科院院士，更适合工程院院士，而谢华安屡屡落选工程院院士，不免让人猜测是因为袁隆平在工程院的缘故。

我当时的工作经验，对中国媒体之不靠谱早有深切体会，尤其是官媒，但我从没怀疑过袁隆平头上的那些神圣光环是不是被严重夸大。

2012年初，因为袁隆平团队和谢华安团队先后创造超级稻纪录，总算有系统梳理一下杂交水稻与袁隆平话题的机会，我记得为写这个稿子，《凤凰周刊》记者杨桐花了近一个月时间采访，在今天能见到的相关报道里，它应该是梳理得最翔实准确的。

因为文章不上网，但这组报道几乎没有任何影响。不过，我并没有因为一万三千多字的报道，就对此话题丧失兴趣。当时虽有方玄昌等擅长科技报道的同行帮助，那组报道依然留有遗憾之处，很多东西并没真正梳理清楚。

关于袁隆平，今天讨论和争议最多的，是袁隆平是否是杂交水稻之父，当年我们记者报道的重点之一，就是挖掘出在杂交水稻上一大批公众并不知晓的专家。以我今天的看法，袁隆平到底是不是真正的「杂交水稻之父」，不值得作为重点，因为这件事，很可能并没你想的那么重要。

## 谁让我们不饿肚子

我们之所以觉得袁隆平是否是杂交水稻之父，很大程度上在于，我们对这样一个说法有深刻印象，即中国人民吃饱饭主要靠两平：**一个是代表政策的邓小平，一个是代表技术的袁隆平，也就是说，包产到户+杂交水稻让中国人不再饿肚子**。

包产到户对农业的影响，在那段历史转折年代生活在农村的人，应该会有深刻的记忆。而且，家庭联产承包制其实到1982年的一号文件开始，才正式在全国范围内被允许的，所以，在1978-1982年期间，留下了大量政策对比案例，它足以证明制度激励的作用，这个以后有机会可单独再说。

那技术上的那一半呢？

中国粮食单产的提高，主要贡献是育种技术和化肥施用。我们先不提育种，如果只看化肥的话，半个世纪来，中国化肥施用量与粮食产量的关系，会让你得出这样一个结论，**中国的粮食增产，就是靠化肥堆出来的。**

![粮食&化肥](https://i.loli.net/2018/08/25/5b80eb7a20fdf.jpeg)

有人甚至将1978年以后中国粮食产量高增长直接归结为1973年代初，中国决定向西方国家大规模进口成套设备的「四三方案」（它得名于引进的设备技术总价为43亿美元），因为该方案引进的大型成套设备提高了中国的化肥产量。

用「化肥论」看上面的表格，你确实会觉得数字相当完美，其他因素可以认为完全无足轻重。但是，这种完美的化肥论，很可能只是一种巧合。

如果化肥是唯一的决定性因素，那么就无法解释苏联的现象：**1970年代末苏联化肥产量就超过了美国，但苏联的粮食缺口反而不断增大，苏联解体后，化肥产量下降，粮食反而开始出口了。**

「四三方案」其实有多么的不靠谱以后再说，但你也许会注意到，1984年后，中国的粮食增长速度迅速放缓，甚至出现下降，而化肥则始终高速增长——化肥的施用增长速度一直远超过粮食产量增长速度，化肥的边际效益逐渐降低。

1984年后出现的这种奇怪的波动，用化肥产量是完全无法解释的，但它和粮食政策却能找到某种对应关系——1985年，国家不再下达指令性收购计划，而是以「合同定购」方式来收购国家需要的粮食。

另外，杂交水稻最先推广的洞庭湖地区，并非一直是低产稻种。两湖及苏浙地区，曾遍植一种叫农垦58的稻种，有些人在回忆中称，它比今天的泰国米、东北米还好，这并非毫无根据的妄言，农垦58是农垦部长王震1950年代初访日时引进的优秀稻种。

在苏浙地区试种四年才大面积推广，大饥荒结束后的1962年的统计数据应该是比较可信的，农垦58的亩产是370公斤（千亩试种）。但农垦58在退出历史舞台前的整个六七十年代，从没有真正发挥过它的高产潜力。

农民普遍不喜欢这种上面压下来的稻种。除了口感不习惯外，主要理由，仔细梳理一下其实都是偷懒的理由：农垦系列收割、脱粒时，比较费事，它是一种对肥很敏感的稻种，只要一偷懒产量就往下掉。

前面这七百字简单概括就是：**激励制度、化肥和育种技术对提高单产都很重要，都有效用的边界，但在当时，育种技术相对是不那么重要的。**

在讲杂交水稻对中国吃饱饭的贡献时，我们容易不自觉地默认：粮食=水稻，因为中国是口粮中稻米比例高于小麦的少数国家。但是，粮食主要分玉米、水稻、小麦、薯类、豆类这五大类。

而1980年以来，中国粮食结构的变化，是曾为中国人不至于饿死做出巨大贡献的薯类甚至南瓜之类，迅速从主食序列中退出，谷物成为绝对主力。谷物当中，今天产量最高的是玉米，其次是水稻，再次为小麦。

最近十年来的变化趋势是，玉米、小麦的产量逐渐上升，稻米的比重相对下降，在谷物的比重，基本在略超过三分之一的位置。

![表1](https://i.loli.net/2018/08/25/5b80ebeb4a5f1.jpeg)

所以，今天谈粮食基本上可以只谈谷物。

杂交水稻提高单产20%，多养活了7000万人这个说法，会让人产生一个错觉，其他谷物不曾像水稻一样，因为育种技术进步而大幅提高单产。

玉米和小麦，是否有过育种技术带来单产的大幅提高？

当然有。

先说玉米。

1950年代初，中国的玉米亩产大约是在70公斤左右，到了1960年代中后期，亩产提高到了115公斤左右。接下来，从1960年代中期开始，中国在玉米育种上经历过六个阶段的技术进步，玉米亩产量稳步上升（文中所有亩产都是指单产）。


| 阶段 | 年份 | 亩产 | 重要品种研究单位 |
|---|---|---|---|
| 第一阶段 | 1960中-1970初 | 140KG | 新乡农科所、中国农科院 |
| 第二阶段 | 1970初-1980初 | 205KG | 丹东农科所、河南农科院 |
| 第三阶段 | 1980初-1990初 | 303KG | 丹东农科所 |
| 第四阶段 | 1990初-1990末 | 325KG | 莱州农科所 |
| 第五阶段 | 1990末-2004前 | 320KG | 河南农科院、中国农大 |
| 第六阶段 | 2004后 | 382KG | 河南农科院 |

今天，中国玉米单产约在360公斤（2016年），为1950年代初的70公斤的5倍。

那么小麦呢？

小麦因为品种改良，单产提升同样惊人，见下表

| 阶段 | 年份 | 单产水平（公斤/亩） |
|---|---|---|
| 初代 | 1950年 | 50公斤 |
| 第一阶段 | 1950-1957年 | 58公斤 |
| 第二阶段 | 1958-1978年 | 123公斤 |
| 第三阶段 | 1979-1999年 | 263公斤 |
| 第四阶段 | 2000-今天 | 354公斤 |

小麦的单产成绩最让人惊异的地方在于，美国是农业生产技术最先进的国家，它的小麦单产，平均每亩174公斤，大大落后于中国。即使考虑到中国农产品的数字都需要打折扣，这也是非常了不起的成绩。

 中国大部分地方的谷物种植，都是靠劳动力高投入的精耕细作来提高产量，人工再加上土地成本，即使中国劳动力便宜，并且小麦单产大大高于美国，小麦成本依然高于美国。中国小麦每公顷的生产成本为13710元，而美国小麦每公顷的生产成本只有4770元。

写到这里，其实只是为了强调这样一个事实：

**中国粮食总量和人均消费量的增长，是所有谷物单产大幅提高的结果，而不只是推广杂交水稻的结果。在这三种作物中，按单产的提高幅度看，水稻反而是贡献最小的。**

![水稻单产](https://i.loli.net/2018/08/25/5b80ec4534a5c.png)

现在，我们该谈水稻了。

水稻分粳米和籼米，是两个不同的亚种。如果你无法记住两者的区别，可以简单地记为，粳米就是日本米，籼米就是难吃的普通南方大米。前者主要是在东北地区栽培，后者主要是在长江流域和东南沿海地区。

粳米和籼米是两种不同的稻米，**我们经常听到的杂交水稻，指的是用杂交稻育种这种特定技术培育的品种，它大都是属于籼型的**。另外，今天中国单产最高的水稻，其实是主要在东北种植的粳稻，而不是淮河以南水稻种植区的籼稻。

也就是说，**中国水稻单产的提升，同样并不全是杂交水稻的贡献。**

![fa80d57f2202fad1e5b4d5e722883faf96c77e72](https://i.loli.net/2018/08/25/5b80ec7aeebc5.png)

虽然我们一直能听到高产水稻的新闻，但实际上，**自1990年代末以来，中国水稻单产几乎就陷入停滞状态，虽然单位水田施用的化肥和农药依然在稳步增长**。单产始终保持稳步增长的，反而是一直不被关注的玉米和小麦。

水稻单产停滞的原因有二。

其一：中国农业效率极低，劳动力转入效率更高的行业是长期趋势，所以增产主要依赖水、肥、农药的投入，一般来说，水稻单产400公斤以下追加投入是核算的，要往500公斤靠近，就得不偿失。

其二：注重单产的杂交水稻，一直存在口感和品质问题，高产杂交水稻远没有品质和产量更均衡的稻种受欢迎。另外，杂交水稻单产进入瓶颈时，常规水稻随着育种技术进步，单产一直在缓缓上升，有些品种与杂交水稻的单产已没有明显区别。

其三、大量使用化肥以替代田间管理投入时间，导致地力不断下降，进而导致单产下降，不断迭代的新品种的增产潜力，很大程度上只是弥补了这个降幅。

另外，**虽然官方宣传杂交稻产量普遍比常规稻单产高20%，但实际上它只是在满足各项理想条件下，杂交稻和常规稻之间存在一种微妙的平衡：在施肥较少的同等条件下，常规稻产量要约高于杂交稻。同样施肥较多的情形下，杂交稻则产量更高。**

水稻不同于玉米、小麦，它在中国经历过几千年的栽培历史，各地的常规稻种，往往是数百年来选育出来，最能兼顾产量和品质，同时又适应当地气候条件。所以，常规稻也可以大面积高产，**在气候不好尤其是病虫害多的年份，常规稻反而可能有优势。**

因为杂交稻追求高产，需要高肥、密植、大群体，形成不易透风和高营养的环境，过去政府**大面积推广杂交稻，在气候环境适应性和抗病抗灾能力上，非常容易出现适应性的问题**。当年给总理上书的农村基层官员李昌平，就曾在公开信中对强行推广杂交水稻表示异议。

不过，**官方机构组织天然有杂交水稻的推广冲动，因为杂交水稻不同于常规稻种，农民不能自己留种，只能从种子销售渠道购买**，这和小麦、玉米也不一样。中国没有任何一种作物的品种，在舆论上获得杂交水稻这样的支持。

顺便说一句，今天还把养活多少人、粮食安全挂在嘴边，本质上是故意无视今天粮食生产早已经出现了剩余。世界粮农组织统计，1996年全球粮食产量足够提供人均2700卡的食物，这个数字大大超过一般人的需求。

另外，工业化程度的加深不断缩减人们的食物需求。印度一项研究发现，过去25年来，印度的人均食物热量消耗明显下降，城市居民大部分低于2100卡，农村居民大部分低于2400卡——这被认为是体力劳动者最基本的热量需求。

原因很简单，**技术的持续进步，导致我们日常所有活动的体力消耗都在减小，而且劳动时间也在减少，劳动人民节约出来的时间，越来越多地用在不消耗体力的看电视和闲聊发呆上，他们变得不像以前那么容易饿了。**

是的，洗衣机、自行车、燃气灶、各种家用小马达，以及让我们像土豆一样做在沙发上的电视机，让我们低着头不愿东张西望的手机，都对我们远离饥饿的威胁做出了巨大贡献。谁知道呢，也许张一鸣有一天该颁他一个节约粮食奖。

## 水稻育种的三个台阶

你应该注意到，**小麦、玉米的育种技术进步，都有过多个不同阶段，单产水平是像台阶一样逐级提高的，典型如玉米，不同阶段的技术进步，是由全国各地不同的研究机构取得，而水稻却是例外**，像是袁隆平取得一个决定性突破后，单产才大幅增长的。

 事实上，这是媒体报道形成的一种错觉。中国水稻育种技术，同样经过多个阶段的技术进步，并非只有「杂交水稻」这一个巨大而笼统的台阶。中国水稻育种技术对提高水稻单产，具有革命性的进步有三次。

 ![e989b69e586f3acc3595bc003ab26ed883ba81fc](https://i.loli.net/2018/08/25/5b80ed5aa2ca9.jpeg)

 也就是说，中国的水稻单产，从1950年代的150公斤，上升到今天的450公斤，育种技术上经过三个大台阶，不断迭代进步，而不只是一次飞跃。

第一次是矮杆革命。1941年7月，广西容县华侨甘利南从马来西亚回到稻种，当地人根据特性称之为「矮仔占」。1956年夏，广东潮阳人洪春利发现水稻自然变异矮杆样本，与洪春英合作培育出「矮脚南特」。这两个稻种，为黄耀祥等育种专家开发的矮杆稻种，提供了最重要的遗传资源。

第二次是我们熟悉的袁隆平领军开发出来的杂交水稻，其实严格的说法，应该叫三系法杂交水稻。第三次则是两系法杂交水稻，它在国家科技进步特等奖时，袁隆平的名字被排在第一位，但这更像是对袁隆平在组织领导以及江湖地位的致敬。

两系法杂交对中国水稻影响远不如前两次。因为此时水稻种植已经出现了很难改变的长期趋势：1、北方粳稻的播种面积不断增加；2、杂交水稻播种面积一直缓慢下降；3、常规稻种缓慢增长。有人认为，最终将各占三分之一。

 好吧，就算中国粮食增产并不只是水稻，杂交稻的贡献被严重高估。但是，毕竟中国是水稻的故乡，水稻凝聚了中国在农业技术上的骄傲。甚至说它是中国的第五大发明。「杂交水稻之父」袁隆平的技术突破是打破了洋人的教条，虽然不好吃，但产量高却是没问题的。

 媒体报道不会忘记提到这一点，改革开放初期，中国还向美国人传授了袁隆平的杂交水稻，还有美国学者说，中国的杂交水稻研究将世界各国远远留在身后，甚至领先美国20多年。如果有心，你也会看到印度、菲律宾等水稻种植大国，在水稻单产上与中国存在巨大落差的报道。

那么，单从高产来说，中国水稻处于世界最顶尖位置吗？从中国这里偷师的美国，他们的水稻单产水平如何？

![usa](https://i.loli.net/2018/08/25/5b80ed71b5858.jpeg)

美国不是传统水稻种植国家，不但面积少——只是中部和西部偏南几个洲有水稻种植，总面积约为2000万亩，以至于人们以为美国是不种水稻的。美国水稻很少用于本国口粮，完全是为海外市场出口，所以多为口感更具竞争力的粳稻。

比起中国的精细耕作，美国人种水稻时显得相当粗放缺乏耐心：水稻种植根本不存在插秧这回事，而是以狂野的直接播种的方式，美国水稻播种，一部分是用播种机，另一部分，干脆就是飞机空中洒播种子。

但是，**美国这个缺乏水稻文化的国家，最近几年水稻单产一直稳定在550公斤的水平，比中国的水稻单产高出近四分之一**。是的，中国水稻单产远非世界顶尖，甚至美国也不是单产最高的，而是澳大利亚这个同样不以水稻出名的国家。

看到这里，你大概也会这样认为，袁隆平是不是「杂交水稻之父」也许没那么重要，因为杂交水稻对粮食增产的实际贡献，至少和我们以往形成的印象有极大落差。它不是巨大的功勋是否被袁隆平一人独揽的问题，而是这个功勋是被大大拔高了。

 即使袁隆平是百分之百杂交水稻之父，又能怎样？中国玉米、小麦对中国粮食增产的贡献，不低于水稻，它们的育种成就，不低于水稻——唯一的区别在于，**我们从没听说过玉米之父或小麦之父——这是最值得细细思量的地方，它绝不是一种正常现象。**

## 杂交水稻的父亲母亲

在质疑袁隆平「杂交水稻之父」的资格时，最喜欢被拿出来的是美国人HenryBeachell。

Henry Beachell是洛克菲勒和福特赞助的菲律宾国际水稻研究所的研究员，1966年培育出奇迹稻 IR8，水稻单产10年间翻了一番。1996年Henry Beachell获得世界粮食奖。我以前也喜欢说，他才是国际上承认的「杂交水稻之父」。

![henry beachell](https://i.loli.net/2018/08/25/5b80edb8321d7.jpeg)

<figcaption>图：Henry Beachell</figcaption>

问题是，你要是去英文网站搜索，是找不到Henry Beachell有「杂交水稻之父」这个头衔的。

在这里，我特别**强调一下：争论谁才是国际上公认的「杂交水稻之父」，纯粹是掉进了中国人挖的坑**。其实，只要认真看到这里，你就该意识到一个问题，**照正常情形，无论是袁隆平、谢华安还是别的什么参与者，是不会被公众知道，更不会被称为父亲母亲的。**

真正理解到这一点，我这篇文章耗的几天时间才算没有白费。

没错，杂交水稻这项育种技术，**让袁隆平以「杂交水稻之父」成为老少皆知的超级明星，是由于种种时代的特殊原因，才被塑造成空前绝后的政治奇观。**

这个奇观的神奇之处还在于，1982年，袁隆平逐渐开始被称为「杂交水稻之父」，这个头一开，就没法刹车。袁隆平是中国籼型杂交水稻科研的开创者之一，既然不是唯一，那么袁隆平「称父」，就不能阻止他人仿效。

袁隆平是否算得上「杂交水稻之父」，同行私下有不同意见，甚或不服，但无人敢与袁隆平争这个头衔，余者只能称「杂交水稻之母」。对三系杂交稻贡献巨大的谢华安、颜龙安，当仁不让地成为「杂交水稻之母」。好在两位母亲倒也相安无事。

![xiehuaan](https://i.loli.net/2018/08/25/5b80ee452892e.jpeg)

<figcaption>谢华安</figcaption>

![yanlongan](https://i.loli.net/2018/08/25/5b80ee67ac9a1.jpeg)

<figcaption>颜龙安</figcaption>

袁隆平因三系杂交稻而被尊「父」，石明松在两系杂交稻上贡献最大，自然也有了加尊号的资格，尤其是石明松意外去世，未能享受应得荣誉。大家自不愿让他被袁隆平代表，而且他的两系法和三系法算是别开一脉，于是被尊为「亚父」。

![shimingsong](https://i.loli.net/2018/08/25/5b80eebde2424.jpeg)

<figcaption>图：石明松</figcaption>

与袁隆平同为工程院院士的周开达，江湖辈份和地位可与袁隆平分庭抗礼，周独立培育出冈、D型系列不育系及其杂交稻，与袁隆平山头几乎没有任何交集，有四川省政府的全力支持，他开发的稻种几乎独占西南地区，遂割据做了「西南杂交水稻之父」。

![zhankaida](https://i.loli.net/2018/08/25/5b80ef1ac9fb5.jpeg)

<figcaption>周开达院士</figcaption>

周开达院士在西南裂土称父，广袤的黑土地上当然也要一位父亲，而且那么多父亲母亲都出自籼稻产区，北方粳稻区不能一个父亲都没有。徐一戎为了黑土地上的粳稻奋斗一生，荣誉归于徐一戎实为众望所归，只是，到底是「寒地水稻之父」还是「北大荒水稻之父」，大家并未取得一致意见。

水稻育种圈称父封母之风而今已成惯例，三系、两系之后，又有了超级稻的概念，于是，最先提出此概念的杨守仁又被人称为「中国超级稻之父」。

![yangshouren](https://i.loli.net/2018/08/25/5b80ef8550eb4.jpeg)

<figcaption>杨守仁院士</figcaption>

最近，又有人称陈温福院士为「超级稻之父」，这样一来，东北地区一下也有了三位父亲，明显有后来居上的势头。不过，杨守仁用的「中国超级稻之父」显然更严谨，因为超级稻这个概念是日本人最早提出的。

若尊袁隆平为始「父」，执古礼，似当向上追溯，则黄耀祥当被追封为「矮杆水稻之父」，若向上追溯还可兼顾旁枝，那么，洪春英、洪春利就不该被漏掉，或可在前，加「广东」或「潮州」这样的前缀限制词。

![huangyaoxiang](https://i.loli.net/2018/08/25/5b80efe9450dd.jpeg)

<figcaption>图：矮杆水稻育种专家黄耀祥院士</figcaption>

虽然，前面一开始就讲到HenryBeachell不是什么国际杂交水稻之父，但是，以他或他供职的菲律宾国际水稻研究所对中国水稻育种的卓越贡献，他当个荣誉父亲或「义父」什么的，才算是不曾忘记人家恩义的表现。

当年杂交水稻研究，菲律宾国际水稻所为中国提供了大量恢复系的亲本，虽然媒体很少提这件事，但这段历史都明确记在稻种的基因里，下图是杂交水稻推广面积最大的稻种汕优63的谱系，那些以IR打头的，都是菲律宾国际水稻所培养的稻种：

![767033f2ad17192fa8e0f3a521245d1c261199be](https://i.loli.net/2018/08/25/5b80f02324297.png)

70年代国内的杂交稻亲本大多数直接取自国际水稻所，没有他们提供的优秀的水稻遗传资源，杂交水稻就不会有高产稳定的表现。并且，直到今天，菲律宾国际水稻所一直接纳和培养中国留学生。

如果称「父」之风从水稻育种界蔓延到玉米、小麦，有资格称父的候选者中，不少人在「之父」的含金量上——纯粹从技术和理论突破或创建而言，或许会比袁隆平更高。

小麦育种奠基者有金善宝、沈宗瀚、沈寿铨、戴松恩等，对小麦单产贡献巨大的远缘杂交奠基人，则被公认为李振声。袁隆平1981年获得第一届国家最高科学技术奖，李于2006年获得此奖，即使我们认为杂交水稻之功皆归于袁隆平，李的贡献也不在袁之下。

（提到李振声，有人说，李的小麦远缘杂交建树成果，主要来自留英归国的石声汉博士，因石出身不好，后由李振声转接石的工作。此说无法考证，聊备一格）。

<figcaption>图：小麦育种专家李振声</figcaption>

玉米，可与袁隆平同称父的，至少有李竞雄、戴景瑞等人。另外，如果你留意前面做的那个玉米育种迭代进步的表格，应当会发现，中国玉米育种的重要技术成果，近半出自河南。这大概是吴绍骙先生是中国玉米育种奠基人的最好注解吧。

![wushaokui](https://i.loli.net/2018/08/25/5b80f0a46fbeb.jpeg)

<figcaption>图：吴绍骙</figcaption>

吴绍骙是1930年代留美博士，长期任教河南农大，桃李半中国。吴的学术圈地位本非李振声、袁隆平等人可比，但吴因政治原因，叠遭风浪，数度中断科研、教学。吴的经历，实在是性格的必然，早年翻译李森科的《遗传及其变异》一书时，吴公然在译序中声称：「译者稍涉猎于遗传科学，对李森科院士所持之说，以所知甚少，不敢贸然赞同……」

好在，称父这个爱好只在水稻圈流行。因为袁隆平是独一无二的。

袁隆平的独一无二，不是理论上的突破和创建，也不是三系杂交研究中卓越的研究能力——最重要的几个环节都各有贡献者：育成第一个不育系及保持系的是颜龙安，发现第一个恢复系的是张先程，第一个提出亲缘学说指导三系配套的是裴新澍……

请想一下，我们听到杂交水稻这个词，难道不是因为袁隆平这个人吗？如果不是这个人，谁愿意去记住它的增产幅度、养活了多少人？除了引起恐慌的转基因玉米，有谁听过小麦、玉米、大豆的任何品种吗？更何况是与特定品种相关的具体研究者。

**如果没有袁隆平这个超级明星，人们根本就没法弄清杂交水稻育种中，不同的人扮演的角色和做出的具体贡献是什么，谁会无缘无故关心谢华安、颜龙安、黄耀祥的贡献大小？**

袁隆平的独一无二，在于文革结束后，他是农业育种专家中，唯一进入官方科学家宣传序列的一员，虽然远还不能与当时最耀眼的科学家们并列，但时间推移，当年的陈景润、华罗庚等人失去宣传新意，早已淡出公众记忆时，袁隆平在大众传播中热度不但始终不减，反而不断攀升。

![475c5eb9b9ba8d6867237e666d0613e582b773f1](https://i.loli.net/2018/08/25/5b80f1047d910.png)

统计出处：王春晓《话语视域下的袁隆平媒介形象研究》）

一个科研人员，知名度覆盖所有人群，今天的年轻人可以完全不知道三十年前的明星，但谁不知道袁隆平呢？不要说是在中国，放眼全世界，也找不到这样的例子。不夸张地说，**袁隆平就是独一无二的现世「科学家神」。**

这一切是不可复制的。

## 完美的「科学家神」

作为一个现世的「科学家神」，袁隆平在公众中呈现的形象，完美地符合中国人心中伟大科学家的形象。或者说，中国人对构成「科学家神」应该具有的基本要素，几乎全都能在袁隆平身上找到。

![yuanlongping](https://i.loli.net/2018/08/25/5b80f13c0e45c.jpeg)

今天公众对袁隆平的好感，真不见得有多少是因为他多养活了多少人，在最近十年里，多养活多少人这个话术，至少在对年轻人是失效的。公众对袁隆平的好感，很大程度上是公众形象的成功。

还记的前两年网上突然爆红的科学家李小文吗？

![xiaoliwen](https://i.loli.net/2018/08/25/5b80f1588aaec.jpeg)

看到李小文不修边幅仙风道骨的照片，就疯狂转发的网民，其实能有几个人看完后能准确复述「地物光学遥感」和「热红外遥感」这两个词呢？大家根本搞不清他是干什么的，更搞不清他在业界地位——这其实不重要，总之，这一点也不妨碍大家认为，李小文是真正的大师、大神。

原因很简单，李小文的身份和他的穿着打扮有强烈的形象反差，在大众传播上，形象反差天然容易引发传播——反差并不都是正面的，比如朱军和赵忠详老师，他们的形象是德艺双馨，自然就应该避免某些不好的强反差。

袁隆平外形是典型勤劳能干的南方农民，但他能飙英语、能拉小提琴，他身上这种农民与知识分子合一的混搭组合，不但极为罕见，而且对比度极为强烈，像他这样的人，你很难找到第二个。

袁隆平喜欢畅谈要养活更多人，心念天下苍生，但他绝不会让人觉得沉重而不可近，在媒体面前，他风趣、亲切，早几年，在记者团面前，有时会人来疯地拉一段小提琴，甚至拎起一桶冷水浇自己头上，让小姑娘们目瞪口呆地暗叫：额地个男神啊。

没错，**袁隆平的形象，完美到他的系统形象参数，哪怕修改任何一点儿，都会减分。**

比如，如果把他皮肤P白一些，他就不像一个随时会下农田的专家；胖一些，就会油腻中年——袁隆平同事的形象就非常吃亏；留个花白的大背头再戴副眼镜，虽然洋了点，但少了人民性；他要是穿着洋气点，就没了圣徒的影子；但如果一脸庄严，就少了凡人的可亲……

甚至你可以想象一下，**如果把袁隆平的小提琴改成二胡，会是什么画风？一个科学家喜欢锯二胡，和科学家喜欢盘核桃、盘手串儿一样，绝对是个减分项**，媒体记者是不会让你拿着二胡在镜头前反复摆拍的。

![80d1e8684d1351677ce0034c4becd7c173c4aaaf](https://i.loli.net/2018/08/25/5b80f1be07154.jpeg)

总之，中国人民心目中完美的科学家神，是淡薄名利不追求物质生活的，是一看就心里装着人民，亲切友善而不高高在上的，是有牺牲精神但又不过于远离人间烟火的，是能与老百姓打成一片又能与西方人谈笑风生的……

你把上述要求叠加在一起，要是刚好能同时满足这些期待，那这样的科学家神就应该长成袁隆平的样子。

我个人觉得，袁隆平最接近神的时候，其实是袁隆平1966年2月发表的《水稻的雄性不孕性》50周年纪念。

如果从不同时期的宣传重点来看，该文最有价值的是第一句和最后一句。第一句是「水稻具有杂种优势现象，尤以籼粳杂种更为突出」，最后一句是「通过进一步选育，可从中获得雄性不孕系、保持系及恢复性，用作水稻杂种优势育种的材料」。

第一句常被用来强调这是袁隆平打破西方「水稻等自花授粉作物没有杂种优势」定论或研究禁区的明确表述，突出的是袁隆平发明的意义；最后一句，说明三系杂交配套的设想是袁隆平最早提出来的，可证明他在这个发明中的地位。

![92300cb2ca57d2eacf2811469f32559b0cfcf93d](https://i.loli.net/2018/08/25/5b80f1d4770fa.jpeg)

为纪念论文50周年，特意出了一本专刊。这个专刊里，有两篇文章的安排值得一说，一篇是朱英国的《杂交水稻研究50年》，一篇是朱英国的《红莲型细胞质雄性不育的发现利用研究及展望》。

朱英国投入杂交水稻研究，比袁隆平稍晚一点，是湖北杂交水稻研究的领军人物。朱英国和袁隆平的地位差别，某种程度上证明了命运对袁隆平的特殊眷顾。

中国杂交水稻研究的转机，始于1970袁隆平团队在海南发现被为「野败」的雄性不育野生稻，它被分发到全国30多个科研单位，1973年培育出三系杂交水稻，中国大部分杂交水稻，都是「野败」系。

前面提到的杂交水稻的父亲母亲，大都是从「野败」系的研究中获得了江湖地位。中国杂交水稻的英雄叙事史中，野败被发现的地位，有点像是井冈山之于中国革命。

然而，朱英国证明了历史还有另外一种可能。1972年，朱英国在海南发现雄性不育野生稻「红莲」，并于1974年培育出红莲型细胞质雄性不育稻种。就是说，如果当年没有「野败」系，因为有「红莲」，它并不影响杂交水稻的技术发明。

![zhuyingguo](https://i.loli.net/2018/08/25/5b80f1ec5734b.jpeg)

<figcaption>图：朱英国</figcaption>

不过，1974年全国杂交水稻攻关大协作时，袁隆平是全国协作组组长，而朱是湖北协作组组长，大家当然都去攻关袁隆平团队发现的「野败」系，而朱英国团队的「红莲」系则被冷落。

中国杂交水稻的英雄叙事史，基本上是一个也「野败」系为中心的叙事史，朱英国撰写《杂交水稻研究50年》，相当于请张国焘写中国革命史，而《红莲型细胞质雄性不育的发现利用研究及展望》，则相当于请张国焘撰写伟大的四方面军革命史。

大哉，隆平。

## 被遗忘的领袖

但是，袁隆平最初出现在媒体时，并不是以今天这种完美形象登场的。

图：从方毅手中接过特等奖的袁隆平

袁隆平登上历史舞台的标志性事件，是1981年6月，中国农科院与湖南农科院申报的杂交水稻获得科委颁发的特等发明奖，在贡献突出的20余人名单中，袁隆平位列第一。

除了一个奖状外，他们还得到10万奖金，各单位转手分掉一点后，其余授予个人。排第一的袁隆平得5000元，排第二的颜龙安得4600元……这个奖金的分配，既体现了当时的平均主义，也体现了当时大家对杂交水稻中，各人贡献大小的看法。

袁隆平当时的地位，相当部分源自他作为科技攻关的政治协调贡献。

按照标准说法，1966年袁隆平论文发表后，引起国家科委重视，遂于1967年6月成立了袁隆平、尹华奇、李必湖三人组成的「水稻雄性不育科研小组」，得到600元科研经费……

袁隆平团队当时在中国水稻育种中处于什么位置？这个描述非常模糊。

英雄叙事中，许多背景信息异常模糊，比如，2001年袁隆平的讲话中，有「1970年以后，我们得到的支持更多了」、「1975年冬，国务院领导同志作出了迅速扩大试种和大量推广的决定」，这种主语模糊笼统的说法，明显少了什么。

事实是，后来成为英明领袖的华国锋，1966年文革爆发前后就知道袁隆平，1970年6月的湖南省农业科学技术经验交流会上，华点名让袁发言，1971年，华奉调中央，1975年冬决定推广杂交水稻的「国务院领导同志」正是华国锋本人。

「国务院领导同志」的推广，值得稍稍展开笔墨：

袁隆平1973年育成的杂交水稻，到1975年已推广试种到5000亩。当年底，袁隆平进京向农林部汇报，结果失望而归，湖南农科院副院长陈洪新急不可待，12月再赴北京，试图说服直接主管，大力推广杂交稻种，不获接见。

陈洪新立即给老上级华国锋写信，提出面见。华见老部下来信后，立即安排副总理、农林部长等一干人参与杂交水稻汇报会，听了两个小时后，华国锋立即决定拿出150万元用于推广，并由农林部立即在广州召开南方13省杂交水稻推广会议。

第一代水稻育种专家黄耀祥培育的几个著名品种，从稻种育成到播放面积的顶峰，都不少于12年，而袁培育的品种1976年才开始推广，1978年就达到最大面积。从袁隆平始，著名稻种从育成到顶峰面积，时间都缩短到4-6年。

袁隆平后来多次提到，当年湖南农科院副院长陈洪新对杂交稻功不可没，而陈本人也认为，他一生最大的成就，便是成功面见华国锋。

华国锋与袁隆平的特殊关系，是段隐没的历史。美国马萨诸塞大学历史系的西格丽德·施马尔泽，曾在《红色革命，绿色革命：社会主义中国的科学农业》一书中，研究了袁隆平在中国媒体报道中的形象变迁，下面内容，部分来自她的研究梳理。

![9c7ebe3c2387424c4cb1783b05d88403eac5ed47](https://i.loli.net/2018/08/25/5b80f238ae7ed.jpeg)

袁隆平研究杂交水稻，是中国当时全国各地「大规模杂交育种科学实验运动」的一部分，当时这项运动已在玉米和高粱方面取得了长足进步。群众运动式的试验对杂交水稻的早期成功帮助很大，它需要短期内对大量农民的种子生产培训。

华国锋在成为毛主席接班人之前，曾掌管湖南并负责全国农业，杂交水稻是少有的几个令人振奋的湖南农业大众科学的例子之一。湖南和袁隆平在杂交水稻中的地位，与华国锋的特殊地位密不可分。

1972年9月，农林部在长沙召开杂交水稻科研协作会议，主场优势使袁隆平开始成为领军人物，1974年，全国13个省区的科研单位被组织杂交水稻公关，袁隆平任全国协作组组长。

1976年成为新领袖的华国锋，面临着老同志们的权力挑战，尤其后者挥舞着尊重科学和技术的旗帜，很符合时代的呼声。强调和突出杂交水稻的成就，对华国锋提高形象有巨大帮助。杂交水稻就是在这个背景下被政治挑中的。

但是，华国锋时代坚持群众路线和集体主义，它往往强调群众智慧，宣传杂交水稻，主题依然是社会主义大协作好、群众运动威力无边。1981年以前，袁隆平的名字很难被注意到。

事实上，杂交水稻最好应该是由领袖发动群众运动的成果，而不是某个科学家的成功，它才对领袖是最有利的。

1976年12月，《人民日报》上袁隆平发表的《杂交水稻如何成功栽培》一文中，清晰地阐述了英明领袖当年对杂交稻的成功的决定性贡献：「鼓励科技人员对群众进行三系水稻研究，从少数专家的实验中发展到千军万马的新阶段」。

当时，官方在介绍这项成就的科学意义时，也带有那个时代的语言特色，比如它有力回击了「西方国家研究多年也没有成功，我们也不可能成功」的「洋奴哲学」，突破了美国专家Sinnott 和 Dunn在《遗传学原理》一书中「自花授粉作物（如稻、麦）自交不退化、异交无优势」的禁区。

不过，由对杂交水稻几十年来一直宣传这个理论禁区，施马尔泽特意检索了中国科学杂志，她发现，没有任何证据表明，这个只是一家之言的美国权威理论，在中国曾被人引用，另外，1960年代中期，杂交高粱这种自花授粉的作物已被广泛推广。

施马尔泽发现，袁隆平与李必湖和尹华奇早期合著的一篇文章中，宣称他们探索水稻「雄性不育的」内在原因时，是受毛主席《矛盾论》的启发，帮他克服了外国遗传学家的错误定论。他们研发的稻米新种，被称之为「革命稻米」。

![88454549f542319d6bbd0d171a75db80ddb17ec5](https://i.loli.net/2018/08/25/5b80f269c361f.jpeg)

<figcaption>图：sigrid schmalzer</figcaption>

在华主席的时代，杂交水稻的宣传调子基本不变，差别只是在开始否定和反思文革后，为了建立「坏人」（四人帮）与英雄二元对立的叙事构架，杂交水稻叙事中增加了造反派的干扰等要素。

1981年6月，袁隆平和华国锋同时迎来了命运转折时刻。华国锋退出权力舞台，而杂交水稻这个原来被视为群众集体智慧的产物，在强调科学工作者个人贡献的新时代，需要一个科学家来认领——于是，华国锋辞职20天前，袁隆平等20余人获科技发明特等奖，从此走上历史的前台。

退出舞台的华国锋，从此变成故人嘴里的「省里」、「国务院领导同志。
但是，袁隆平毕竟是袁隆平。

2006年6月9日，北京出差的袁隆平特意到华国锋家登门拜访，据说，两位老朋友紧紧握住对方的手长达半个小时。这次见面之后，袁隆平终于开始公开说，如果没有华国锋同志的支持，杂交水稻的大面积推广是非常困难的。

![69a3a59b732e8ef7e3a4ecf0b003f3304af2e773](https://i.loli.net/2018/08/25/5b80f2c64be25.jpeg)

临别时，在家练了几十年书法的华国锋，送给袁隆平一副字：隆平同志：贵在创新。它被袁隆平放在办公室显要的位置。

## 科学家神的进化史

顺应时代需求，故事又有了全新的版本：造反派的阻力被强化，袁隆平曾对毛主席的八字宪法提出过质疑——这差点给他带来厄运。而原来是科研主角的人民群众，现在又变成了激发袁隆平科研的动力：我忘不了饿死的老百姓。

文革结束前，曾比袁隆平耀眼得多的另外一些杂交水稻之父，比如李贞生，他的名字不但频繁出现在官方报道中，甚至还有专门的纪录片。他之所以成为那个讲究集体主义时代的个人英雄，因为他是个大老祖。

![e9824019d3c7ef2aef4722c4b8537525e99fb15d](https://i.loli.net/2018/08/25/5b80f2dff3df9.jpeg)

![dd4bd629a9a549f316373d8458fd3972429c833e](https://i.loli.net/2018/08/25/5b80f2ebd6931.jpeg)

李贞生发明出来的杂交玉米稻，不是寻找天然雄性不育的植株，而是用热水杀死雄蕊的方式去雄的。在那个鼓励群众，尤其是文盲群众搞发明创新的年代，这种骇人听闻的土法上马弄出来的新品种，在华国锋出面帮助袁隆平之前，推广得远比袁隆平更成功。

杂交水稻是1970年代群众路线搞科研中少数成功的案例，毛时代有些反智主义的精神遗产，今天还深刻地影响着中国人。譬如，相信地震可以预测，相信好多民间科学家成功预测了汶川地震但被官僚隐瞒不报，是当年中国大搞地震群防群测（有李四光不靠谱的贡献），全民接受了猫狗乱叫，青蛙乱蹦打雷闪电是地震前兆的科普。六〇后七〇后对此刻骨难忘。这个有趣的话题有机会单独另说。

杂交水稻新版本的故事中，强化宣传的重点，变成了大胆颠覆和突破西方科学权威的理论，这几乎是当时歌颂科学家的传奇故事中，必不可少的共同要素——报告文学中的李四光、陈景润、华罗庚，无不打上强烈的民族主义叙事烙印。

报告文学的兴起，显示出一个不同于以往的特征，一个科学英雄是否出名，不再是他的学术地位和他在官方眼中的地位，而很可能是文学家们的报道本身是否成功。徐迟的《哥德巴赫猜想》、《地质之光》是当时影响力最大的报告文学，让李四光和陈景润成为亿万人心中的偶像。

也许是袁隆平缺少动人素材，比如特别的磨难——毕竟批斗、游街、关牛棚、妻离子散这种受迫害知识分子的标准待遇，袁隆平一样没经历过，或者干脆就是袁隆平没有遇到一位好的报告文学作家，八十年代初，袁隆平并未成为家喻户晓的科学英雄，大众知名度不会高秦官属，这位林学家曾因为黄宗英的《大雁情》感动了一代人。

但是，今天回过头来看，这反而是一桩幸事，因为袁隆平没有被固定塑造成当时人们认为的科学家的样子。当时科学家一般都会被塑造成非正常人类，譬如陈景润是个典型的阿兹伯格患者式的书呆子，他缺少基本自理能力，地板上稿纸摞摞有三尺厚，走路经常会撞电线杆。

当时对革命审美疲劳的中国人，欣赏的口味一度剑走偏锋：陈景润收到了几麻袋求爱信，都表示愿意照顾他一辈子，帮他洗衣做饭刷牙生孩子。在校园里，聪明的学生见到老师走过，会立即被陈景润附体，低头着看书，然后撞在电线杆子上。

但是，袁隆平很快后来居上。

杂交水稻突破西方权威的理论禁区，那段文字无论写得多么通俗易懂，绝大多数人都无法复述，它只是说明一个人确实很牛，但是，多养活了几千万人，每个中国人都听得懂，尤其是，在刚刚吃饱饭的中国人心里，比较科学家的重要性，大家是很愿意把他们的贡献折算成可以养活多少人的。

而杂交水稻多养活几千万中国人这个说法，并非灵光一现的新提法，它是从杂交水稻产量高逐渐衍生进化而成的。改革开放初期，没有任何个人敢分享分田到户的荣耀，因为它是证明改革开放正确的第一成就，当改革开放的成就多到根本不太在意粮食时，才轮到杂交水稻的宣传机会。

但是，如果全民都不太在意粮食产量时，杂交水稻能多养活多少人这个提法，就不会被人在意，袁隆平的伟大也会被人忽略。这时候，有个大笨蛋及时跳了出来，这个人叫莱斯特·布朗，1994年，布朗写了一本报告，叫《谁来养活中国》。这个美国版的《货币战争》立即让全中国人都炸毛了。

![e4eaecb3895900e03e34bcb0f6fb0b00475d402a](https://i.loli.net/2018/08/25/5b80f3032605e.jpeg)

<figcaption>图：美国环境问题和农业问题专家莱斯特·布朗</figcaption>

所有中国专家学者以及政府官员对布朗的反驳，都不及袁隆平站出来的反驳更能给老百姓带来信心，他掰着手指头计算杂交水稻只要推广到多少亩就可以解决多少人吃饭，特别符合中国人民对这件事的理解。《谁来养活中国》这本书，意想不到地变成了袁隆平最好的宣传海报。

正是有了莱斯特·布朗这个笨蛋，中国人民突然醒悟，原来我们竟然拥有袁隆平这样真正的英雄。这年底，国家科委领导向李鹏总理汇报工作时，总理关切地问到了袁隆平：湖南的袁隆平为啥没被评为科学院院士？

打个不恰当的比方，《环球时报》特别喜欢转载《华盛顿时报》的文章，这份报纸特别容易让中国人民上火，但是，《华盛顿时报》这个名字看上去在美国特别主流的报纸，其实是1982年由美籍韩裔宗教领袖文鲜明创办的。莱斯特·布朗的《谁来养活中国》就是袁隆平的《华盛顿时报》。

这个时候出现在公众视野中的袁隆平，在形象上，早已把标准中国科学家远远地甩在了深厚，他呈现在公众的形象，一眼望去，境界上已与世界最顶尖的大科学家不远。

是的，袁隆平很早就表现出对境界的追求和热爱。

1983年，共和国第一演讲家曲啸，让中国人民知道了陶铸一句诗：心底无私天地宽。这为后来袁隆平追忆1970年代研究杂交水稻的种种，提供了更丰富的灵感启发，比如，袁的妻子问，你不怕失败被人扣大帽子吗？当时的袁隆平答：心底无私天地宽。

但是，人们很快发现，无私并非大科学家的至高境界。

通过各种文摘报纸杂志的教育，中国人民逐渐知道，爱因斯坦这种大科学家，不但不是成天苦哈哈的怪物，反而是会调皮地吐舌头，以及热爱拉小提琴的充满情趣的人。中国人民对大科学家的格调认识，又翻过了一座喜马拉雅山。

![ee8b2160cc1265b8db6aee37bb4a6df091125d25](https://i.loli.net/2018/08/25/5b80f33e833cf.jpeg)

袁隆平无意中挖掘出自己也有对小提琴的爱好——或许是记者敏锐的发现，总之，袁隆平越来越多地开始锯小提琴。我记得最初有脑子不够清楚的记者，竟然傻傻地问琴艺如何以及是否有爱因斯坦的影响，而袁隆平当时的回答，亦有一丝真诚的羞涩、谦逊和闪躲。

袁隆平的小提琴，经过无数次的迭代进化，到了2002年，在一个关于袁隆平的传记中，终于达到至高境界，已远远把爱因斯坦甩出了好几个身位。

爱因斯坦的小提琴，是出身有教养的家庭和有艺术修养的象征，而袁隆平的小提琴，则是在宇宙洪荒的天地之间，对自然，对生命，对人类孤独的命运，对自己内心的使命召唤，一种四海无人对夕阳的倾诉。

1973年的一天，袁隆平在辛苦劳作之后，拿出心爱的小提琴，他演奏的场地，不是灯火辉煌的舞台，而是一片无边无际的金色稻田，他挽着裤管，两条腿上全是泥，就这么一个人独自沉浸在舒曼的《幻想曲》中。

![dfd6389506e9932e6de770b7aa3849864437dfbe](https://i.loli.net/2018/08/25/5b80f35764039.jpeg)

<figcaption>图：记者们依然喜欢让袁隆平站在稻田里锯小提琴<centr>*

我没有研究过电视连续剧《袁隆平》，如果这部电视连续剧里，居然没有把1973年的那个傍晚，这人类历史中辉煌伟大的瞬间，完整地呈现在观众面前，让他们无法呼吸，我觉得，编剧和导演应该立即用拖鞋打死。

## 杂交水稻的江湖

今天，中国网民对袁隆平的魅力，几乎没有任何免疫能力。

![02da070c6cae37d99d8c12ea64cea5bfe604544b](https://i.loli.net/2018/08/25/5b80f38e89c24.jpeg)

刻意选择海拔、温度、湿度特殊的地方为创造纪录而创造纪录，这种五六十年代的锦标主义已经够离奇了，在沙漠里种水稻，在海水里种水稻，这种纯粹为争眼球不惜血本的搞法，换成其他什么人，也许早就被网民骂死了，但这是袁隆平，他的一切，都是当世神农不断展现他的法力而已。

 仔细留意下新闻，在中国，育种专家亲自上阵，不停地靠堆钱创造高产纪录的，全部是杂交水稻，而其他粮食作物和常规稻种，几乎就看不到这种奇怪的竞赛。原因或许很简单，常规稻种和杂交小麦之类，农民可以自己育种，做种子开发研究的，一个好种子自己只能卖一次。杂交水稻就不同了，必须每次都从我这里买。

不过，中国在制度上不利于激励育种研究的积极性。美国的育种研究主体是企业，而且市场上高度集中的，中国承担研究任务的主力是国家科研院所，如果你开发的杂交稻种特别受农民欢迎，你并不能从市场的反馈中获得足够奖励。

于是，隆平高科于2000年上市，它标志着农民低价获得杂交稻种的时代就此终结，而袁隆平和中国农民的关系，也早就不再是农民和帮助农民增产的人民科学家的关系，当时，湖南农科院和国家杂交水稻中心，居然变成连这家上市公司的科研基地。今天，隆平高科已成为中国杂交稻种市场最大的公司。

看到隆平高科上市，四川方面因为拥有西南杂交水稻之父周开达这块金牌，又有西南地区杂交稻种市场的基本盘，于是也开始筹划包装以周开达名字的上市公司，但尚未敲开资本市场大门，开达种业就因周院士去世而流产。

中国种业市场的特色是政企不分、条块分割，垄断与竞争交织，市场高度分散，产业规模极低。而杂交稻种市场，在集中度和产业规模上都有很高水平，但这并非竞争的结果，因为种业公司们占据的大都是本地市场，由于杂交水稻缺乏吸引力，稻种产能严重过剩。

市场证明，无论你高产试验田的产量有多高，杂交稻也好，超级稻也好，都是没有出路和潜力的。它能影响到的，只是国家的粮食政策以及研究经费的投入。

水稻育种在技术上唯一的突破指望，只能是转基因技术，而抗虫害的转基因技术已经非常成熟，可以明显节省农民开支。然而，袁隆平一直用含混不清的理由反对转基因技术应用。大概它会直接冲击他的种业帝国的市场吧。

说实话，在这一点上，袁隆平真的对不起把他当神一样看待的人民。

你可以认为我这个说法是一种偏见：水稻是一种更适合穷人的食物，因为购买同等热量的食物，稻米的价格只是小麦的一半。而近乎偏执地追求水稻单产纪录，则是穷人对饥荒恐惧的偏执。

但是，从生物特性上讲，作为一种粮食作物，水稻可供开掘的潜力，决定了它不值得花那么大的投入。水稻、小麦在光合作用的效率上，与玉米、高粱这样的作物存在着天壤之别。因为光合作用过程中的差异，水稻、小麦被称为碳三植物，而玉米、高粱等被称为碳四植物。

也许举个简单例子，这种差别就能有一个直观的对比体现：玉米、高粱、甘蔗其实和小麦、水稻一样都是「草」，但是由于它们极高的光合效率，以至于它们高大到一般不会被人认为是草的程度。

毫无疑问，玉米这种神赐之物，必然会成为人类食品产业最基础的砖石，它必然会对整个农业的面貌和格局产生深远影响。中国把精力大量花在水稻这种潜力有限，别人不愿玩的门类上，相当于人家在完善汽车，中国在完善马车。

2014年，我去参观美国农业时，拜访过美国转基因玉米专业种植户，对美国玉米种植竟然可以如此偷懒感到极为震惊：农户种植玉米，被简化到几乎只剩下播种和收割。不但没有除草、除虫之类的田间管理作业，甚至连深翻、犁田等基本的环节都省略了——这已经不能叫耕作了，因为不存在耕……

他们对转基因作物自然是非常欢迎，农民是转基因技术的最大支持者。我问及，你们是否担心过，使用转基因种子会加重对大公司的依赖，那户人家的主人答：它们能让我们挣更多钱，这有什么不好……

关于转基因，西方左翼人士反对转基因，主要是因为反对资本主义的大企业，而非转基因技术本身有什么问题，市场越集中，农户对大企业越依赖，他们当然看不过眼，而大企业在转基因研发上投入了巨资，他们当然要给它们制造麻烦。

从某种程度的实际效果看，左翼人士是大企业消灭市场弱小竞争者的帮凶。是的，他们成功地推高了转基因产品申报的门槛，给大企业制造了麻烦，但是，从事转基因研究的中小企业和大学里的研究机构，无法承受高昂的申报审批成本，最终只能把这个市场让给大企业
。
对了，前面虽然提到中国玉米的单产不断提高。但与采用了转基因技术的美国相比，就什么都不是了。中国的玉米单产约为400公斤，而美国的玉米单产约为800公斤，2017年，美国玉米高产竞赛创下了2269公斤的单产纪录。

水稻和玉米在潜力上的巨大差异，也许袁隆平早就意识到了。但是，他的本行是水稻，于是，子承父业的袁定阳找到了一个奇特的努力方向：通过转基因技术，把水稻彻底改造成玉米一样的碳四植物。

额地个神啊。

![ee410630fb3db306fefcb44f6db58df67fa03c7f](https://i.loli.net/2018/08/25/5b80f3b99037b.jpeg)
