---

layout: post

title: “纳民”模式退出上海青浦，流动儿童上学又成难题

categories: Archive

date: 2018-05-24

tags: 民办小学被拆除

image_feature: "https://i.imgur.com/ZH66KrD.jpg"

description: 曾被誉为国内最好的小学教育平等化模式，在上海青浦遭遇“猝死”

---

原文来自好奇心日报：~~[“纳民”模式退出上海青浦，流动儿童上学又成难题](https://mp.weixin.qq.com/s/g0wwL0_WbD9OJ8RJpGcBrA)~~，~~[好奇心日报网站链接也404了](https://www.qdaily.com/articles/53489.html)~~

作者：蒋亦凡

本文由[简悦SimpRead](http://ksria.com/simpread/)转码

---

![](https://i.imgur.com/ZH66KrD.jpg)

><big>曾被誉为国内最好的小学教育平等化模式，在上海青浦遭遇“猝死”</big>

“2018，我们一起坚守。”校长马思国办公桌对面的墙上，一块大黑板上写着一排大字。马校长说：“我们现在就是用这句话激励自己，老师们办公的微信群就叫这个名字。”

他是上海青浦区联合民办小学的创始人，学校开了18年，将在下月关闭。6月30日，这所接收外来务工人员随迁子女（或者叫“农民工子弟”）的民办小学，将与另外13所同类学校一同关闭。届时，目前在校的3000多名学生将另谋学校或失学，目前在职的两三百名老师也将另谋出路。与此同时结束的，还有上海从2008年启动的一段被誉为典范的包容性教育政策实验——把农民工子弟小学“纳入民办教育管理体系”——这也是“纳民”小学名称的由来。

青浦区联合民办小学看起来生机勃勃、井井有条。外面有塑胶操场，国旗飘荡；实验室里存放的实验器具的箱子码得整整齐齐，电脑教室、图书室里的门口挂着捐助企业的标志，党建室也没有落下，桌上堆满儿童读物，还有几件魔幻感十足的橡皮泥群雕；教室里，孩子们在专心听讲……但下一间教室，是空的，下一间，还是空的。

![](https://i.imgur.com/NLVcbsj.jpg)
<figcaption>2018年5月，位于青浦区华新镇的联合民办小学校门。</figcaption>

![](https://i.imgur.com/QUXX4pt.jpg)
<figcaption>联合民办小学的塑胶操场。</figcaption>

![](https://i.imgur.com/ZiFwtV6.jpg)
<figcaption>联合民办小学空置的教室。</figcaption>

![](https://i.imgur.com/rd4C0rj.jpg)
<figcaption>2018年5月，联合民办小学教学楼前，校长马思国的背影。</figcaption>

![](https://i.imgur.com/oBHhw33.jpg)
<figcaption>联合民办小学党建室一角。</figcaption>

“空的……空的……空的……”，马校长一边走一边说。向里张望，玻璃窗上已经蒙了灰，桌椅码在墙角，黑板报还在墙上。这所在高峰时的2006年曾经有1300名学生的学校，现在只有137名学生。2014年秋季学期，上海市的义务教育入学门槛骤然抬高，此后，像联合民办小学这样的“纳民学校”学生人数就持续下降，到2016年，媒体开始呼吁关注一百多所此类农民工小学将因为生源减少、政府按人头拨付的经费相应缩水而逐渐衰亡。

不过在青浦，这个“逐渐”的过程突然加快了速度。

2016和2017年，青浦区以清理“五违四必”为由，各拆除了4所学校。其中一些在被拆除时，尚有四五百名学生和数十位教师的规模。余下的14所学校目前普遍都还有一两百人的学生在校，在它们下月被关闭后，青浦将只剩下一所纳民小学因办学资质特殊而继续存在。

上海“纳民小学”的历史始于2008年。此前，上海在1998年开放外地人办学校，以服务于数以百万计并且越来越多的来沪务工人员子女就学问题，高峰时达到500多所。这些学校长期存在设施落后、教师素质不高等问题。2007年，时任上海市委书记习近平考察青浦区徐泾镇的一所农民工子弟学校——民主学校时，提出“要创造一个平等、良好的教育环境，要坚持多轮驱动，在政府加大投入的同时，鼓励民办教育发展”。2008年起，上海开全国风气之先，用三年时间在关闭位于中心城区和办学条件不合格的农民工子弟小学的同时，将剩下的农民工子弟小学“纳入民办教育管理体系”。

这意味着，政府把这些由个人举办的学校的硬件设施收购下来，同时根据学生人数向学校拨付办学资金，让这些学生享受和公办学校学生一样的免费上学待遇。到2010年底，上海市政府投入了103.8亿元，把159所农民工子弟学校纳入了民办教育管理体系，提供了12万个免费的义务教育学位（就学的位置）。原本在农民工子弟小学就读的大部分孩子，得以转入“纳民小学”。

直到如今，这种政府全埋单的“上海模式”，仍然被关注流动教育的学者和NGO认为是解决流动儿童就学的最佳模式。

体现在教育质量上，上海财经大学陈媛媛和暨南大学冯帅章的一项研究发现：在2010年到2012年间，由于政府投入的增加，上海民办农民工子弟学校学生的数学测验成绩与公立学校之间的差距缩小了一半。纳民小学的老师们也反映：在学校纳民之后，师资变得充足，教学压力降低，同时学习机会增加，让老师们得到了很大的提升。

但这种优越的“上海模式”在施行10年之后，即将在青浦区率先告终。

### 学生和他们的父母

“一提到孩子上学，我们头都大了！”

在香花桥街道包地种菜的常先生来自安徽，在青浦工作生活十年，孩子现在在新希望民办小学上四年级，他没想到自己会提前面对孩子如何在上海升学的问题。4月初，他从老师口中得知学校即将关闭，而且自己的孩子新学期是否能转入公办学校的五年继续就读，还需要经过教育部门对入学资质的“二次验证”。

4月1日政府指定的纳民学校管理委托方“青教师生服务社”向14所学校发出了一份一页纸的《通知》，告知因委托合同到期，学校将被关闭。但其中不包括任何善后方案。关于二次验证的要求，区教育局说：只要符合“稳定居住，稳定就业”就可以了。

如果通不过“二次验证”，那么常先生一家必须立即做出一个重要决定：要么放弃在上海的工作，陪孩子回老家上学，要么让孩子单独回老家，在全封闭学校就读，每逢寒暑假才能来上海与父母团聚。

除了本来将在6月30日毕业的五年级，以下各年级的学生家长，都将面对“二次验证”的命运裁决，据马思国校长估计，这些学生的人数在2500人左右。其中很多孩子的父母正在面临和常先生一样艰难，甚至更加艰难的抉择。《好奇心日报》此前通过电话向青浦区政府、赵巷镇和徐泾镇教育局咨询二次验证政策，一直没有统一、肯定的说法。5月21日下午，徐泾镇教育局工作人员在再次接受《好奇心日报》的电话咨询时肯定地告知：二次验证的标准与今年青浦区幼升小的标准一致。即父母一方符合以下三种条件之一：

一. 持有2018年之前申办的居住证；

二. 持有2018年以后申办的居住证的，须外加半年社保或连续三年的“灵活就业登记”；

三. 连续三年持有暂住证与“灵活就业登记”。

其中，光是一个居住证就足以让大多数家长为难。有多种因素阻碍着家长取得居住证。2018年以前，居住证的办理条件中包含连续缴纳半年社保，而很多单位不交社保，而且相对于打工者微薄的工资，社保也是一笔不小的开支，因此很多家长在若干年前为了让孩子幼升小时获得入学机会，一度缴纳社保，但在入学之后就停止缴纳，因而导致居住证失效。此外，住房不合格也办不出居住证，搬家也会让居住证失效。

从2018年起，申办居住证已经不再以缴纳社保为条件，但是对“合法居住”的要求依然严格。在青浦，合法居住的审核权被下放在各个村/居委会的人口办，且每个人口办的标准并不一致。《好奇心日报》致电徐泾镇多个村/居委会人口办，咨询合法居住证明的办理条件。各人口办统一的要求有：房子没有违建，提供租赁合同、房产证（商品房）/建房批复（农民自建房）、房东和租客身份证，以及在申办时房东陪同现场签字。有的人口办还要求出示“分房结果报告”（如果房屋是动迁安置房）、“房东责任制”、“外来人口登记本”，还有的甚至要求在每层楼公共区域安装摄像头和灭火器。这些，一方面要求房东有一定的专业度和配合度，另一方面也意味着更高的租房成本。

此外，在申请办理合法居住证明和拿到这张证明之间，还有长短不一的等候时间。有的人口办承诺在登记后一星期就给办出来，有的则要求登记后等候三个月，最长的，要求登记满半年。

4月初得知面临“二次验证”之后，很多家长立即申办了居住证，即便来不及在开学前领到居住证。上海市2018年居住证新政规定：新办居住证，先只能拿到《居住登记凭证》，半年之后才能正式领取居住证。4月申办的居住证，最快10月份才能拿到，届时新学期早已开始，更不要说二次验证的截止时间是8月10日。怀着一种侥幸心理，这些家长希望政府最终在验证中将《居住登记凭证》视同居住证，因为毕竟关校通知是4月1日才发出的，不是家长不配合。也有人希望，在10月份拿到证件后，政府还能网开一面让孩子插班入学。

即便他们以上种种愿望都能实现，包括不会遇到办理《合法居住证明》三到六个月的登记等待期，他们还是要面对缴纳社保的问题——因为虽然2018年申办居住证不再要求缴纳社保，但是今年的幼升小政策规定：持有2018年1月1日以后发放的居住证的家长，必须在6月30日之前一年内连续缴满半年社保。

而幼升小条件中的“灵活就业登记”，只针对医院护工、农业专业合作社从业人员、家政服务人员、无雇工的个体工商户和居家养老服务从业者五类职业，大部分外来务工人员不符合条件。

![](https://i.imgur.com/ZH66KrD.jpg)
<figcaption>2018年5月中旬，位于徐泾镇的民主民办小学下午四点的放学。</figcaption>

让学生父母们困惑的是：为什么没有更早地通知他们关校的事情。一位教育办工作人员在回答《好奇心日报》的电话咨询时表示，2017年区教育局曾通过学校发放过一份《告家长书》，告知关校和分流需要二次验证的事。但《好奇心日报》询问了多所学校的老师和家长，没人见过这份告示。

结果是终将只有一小部分在校生可以顺利转入公办小学。青安民办小学的孙本江校长估计，目前在校的80名五年级以下学生中，符合转入公办学校条件的可能只有20人。在叙中民办小学负责学籍管理的陈老师估计，该校60多名五年级以下的在校生中，能够留在上海继续就读的不过20人。位于徐泾的民主民办小学一位四年级学生的张姓家长估计，他儿子班上有六到七成的学生会因为居住证问题而无法通过二次验证。

至于无法被分流的孩子将何去何从，2016和2017年青浦区两轮拆除纳民学校之后的情形可以作为参考。当时对在校五年级以下在校生也做了“二次验证”，通过验证的孩子被分流进入公办小学和纳民小学。据明天民办小学教导主任李祥忠的观察：大约有50%的学生回了老家，20%转学到了邻近的江苏等地，不到30%被分流继续在沪就读，大约有5%的孩子当年辍学。

而回老家的孩子，则大多没有父母的陪伴。叙中小学学籍管理员陈老师在过去几年为离校学生开具转学证明的时候，都会和家长聊他们怎么安顿孩子。他发现，绝大多数的家长都是把孩子单独送回老家。这些孩子或由亲戚和祖父母照顾，或长期寄宿封闭式学校，只在寒暑假才回到上海自己真正的家，与父母团聚。这一观察与上海大学社会学系教授刘玉照在上海最大的外来人口流出地安徽的调研发现一致。

他们成为一个新的群体“回流儿童”，显然面对着不同于一般留守儿童的生活巨变与适应、心里落差，以及认同问题。上海财经大学教授、人口流动与劳动力市场研究中心主任陈媛媛的一项跟踪研究发现，这些“回流儿童”在完成学业后最终都将回到上海寻找工作机会。在上海执教18年、长期与毕业生保持联系的李祥忠也发现：歧视性的入学政策的确是把小的孩子赶走了，但是大的孩子因为受到歧视性入学政策的干扰而辍学早，在老家初中毕业以后就找不到工作，最后还是纷纷回到上海打工。在这个意义上，长期而言，“控人”并没有达到它的目的。

![](https://i.imgur.com/MUmGxT6.jpg)
<figcaption>本图表由上海财经大学陈媛媛教授提供。</figcaption>

一位长期关注上海随迁子女教育问题的资深教育界人士告诉《好奇心日报》，青浦是上海目前唯一“一刀切”关闭纳民学校的区县。事实上，市教委对关闭纳民学校的精神是：首先，要留下相当一部分纳民学校，并且要提高它们的办学质量；其次，如果要关，那么一定要平稳、妥善解决。至于青浦为什么走这么快，他表示“看不懂”。对于“二次验证”，他也很困惑——为什么就不能“新人新办法，老人老办法”呢？

### 校长们

马思国1969年出生于安徽淮南，1991年从淮北师专毕业，在老家做了一年代课老师之后来到上海。起初在一家台湾企业做人事管理，2000年辞职开联合小学之前，他是一家箱包厂的厂长。他发现，当时工厂招工歧视外地人，就想做一个专门培养流动青少年职业技能的技校。他开联合小学，为的是给技校做准备。2009年学校被“纳民”，初中部被取消，没法再做技校，他才专注于小学教育。

据马思国回忆，纳民时政府收购的评估价非常低，整座学校仅作价43万。他没有计较，因为政府说得非常好：“未来学校还是你们办，政府资助你们，是公助民办。”教育局领导在校长会议上经常说的话是：“你们好好干，以后你们的学校有希望纳入公办教育体系。”因此，虽然纳民合同是五年一签，但是他对学校的长期存在和发展抱有强烈的信心。

他认为，政府“纳民”给学校带来积极改变，同时纳民小学也为上海的教育和社会稳定作出了贡献，节约了大量的财政支出。纳民之后，学校的收入主要来自于政府根据学生人头拨付的教育经费，生均经费从一开始的每年2000元，逐步增加到目前的6000元——虽然与公办小学生均补贴超过每人2万元相比还要少得多，虽然补贴少，老师收入也要比公办小学老师少至少一半，但马思国觉得，纳民小学提供的教育服务并没有比公办学校差太多。

![](https://i.imgur.com/7eIjuyF.jpg)
<figcaption>2018年5月，联合民办小学校长马思国办公室墙上的文字。</figcaption>

马思国认为，如果大势所趋必须关停纳民学校的话，那么应该在上一轮签协议时就明确。好让校长们有一个过渡性计划，并逐步减少对学校的投入。2013年，他花了70多万建了新厕所、音乐教室和会议室。

在6月30日学校关闭之后，来自政府的生均补贴和房租补贴都会终止，同时学校的电脑、桌椅等国有资产将被政府收回。村里的说法是学校停办以后，房租就要上涨了。要涨到多少还不知道，但马思国知道，旁边建材市场的租金是每天每平方米3到4元。

他现在还不知道6月之后自己会做什么。从7月起，他就将失去一份不到八千的稳定月薪。他的一个想法是把小学转型成幼儿园，但尚不知学校的房屋、设施条件是否满足政府对开办幼儿园的要求，但如今开幼儿园似乎不是长久之计。他最近接触了一家教育机构，想探讨加盟，但是对方觉得这里位置不好，眼下还没有下文。

不过他从4月初有了一个新的公益身份——老家安徽淮南市驻上海流动人口区域服务站的副站长，职责是为来自老家的随迁子女和务工人员开展法律和健康教育。结束与《好奇心日报》记者的会面之后，他就要接一位医生去宝山一所学校开展一个关爱随迁子女教育的活动。

新希望民办小学校长李国兰是安徽寿县人，2000年来到上海，在虹口区的一所农民工子弟学校当老师，2003年，学校被拆，她和当时在跑运输的老公花了40万买下了青浦徐泾镇的一所学校。但是学校才开了一年，遇到徐泾镇整体规划，学校被关，40万买的学校，装修投入了十几万，结果只拿到28万赔偿。2004年，她来到青浦区更远离城市中心的香花桥镇，租下了因为撤点并校而空置多年的红星小学。

2006年，新希望小学开始招生，学费一年1000元，不仅中午管饭，还免费提供课本。这年，她招到了300名学生，两年后学生超过了600名，2009年纳民后也保持着这个数字。

她的丈夫负责学校后勤，儿子是体育老师，一家人住在学校。几年来，学校发展出武术教学特色，几乎年年能在市级竞赛中获奖。

![](https://i.imgur.com/fGQOIc5.jpg)
<figcaption>新希望民办小学的傍晚，一名学生降下国旗。</figcaption>

2014年秋季学期，区政府取消了纳民学校的自主招生权，统一平台招生，政府集中审核后向学校分配生源。从此新希望就再也没有新生入校。目前学校只有四五两个年级146名学生，由于学生少，李国兰去年辞退了六位老师。

而现在，李国兰自己也面临失业。她今年52岁，社保只交了6年，在老家没有土地，现在担心养老的问题，打算和老公回老家开一个饺子摊。

教室过道上方一块褪色的标语牌上写着：“成绩是昨天的句号。”

习近平在2007年考察过的民主小学也将在6月30日关闭，目前学校还有四个年级、250名学生。它的新址位于徐泾镇谢卫路上，校门两侧的商铺，前两天才被水泥封上，路对面一片尘土飞扬的瓦砾，不久前还是一排门面房。

创办人和校长张从金在电话中告诉《好奇心日报》，现在政策不允许搞教育，自己对下一步也还没有方向。

### 老师们

“我把青春都献给了上海”，在一所纳民小学担任教导主任的王国强说，他的学校也将在6月30日关闭。

他今年51岁，1992年从江苏一座师范学校毕业后，被分配到当地一所村办学校当代课老师。代课老师待遇低，在干了五年后他来到上海，在宝山一家化工厂做化学分析师，在这里结婚生子。1999年他在工厂合并中被裁员。第二年，他来到青浦，加入刚成立一年的明天民办小学，并在四年后成为教导主任。

他告诉《好奇心日报》，目前老师们对安置方案的疑问，首先是工龄该怎么算。目前，青教师生服务社对老师的补偿方案是：以学校纳民那年至今的工龄乘以该教师在过去12个月（一说是过去两个学期）中的平均工资之积。照这样的算法，老师最长的工龄不过8～10年，乘以他们一般三、四千元的工资，补偿款只不过3到4万元。

但是王国强已经在学校工作了18年，很多如今年届五十的老师普遍都已经在学校工作了15年以上。青教服务社的方案，抹掉了纳民前的大段实际工龄，让补偿金额大打折扣。

他和其他老师共同关心的另一个问题是：青教师生服务社从未给非上海户籍的老师们缴纳过住房公积金，在老师们的要求下，它目前同意仅为城镇户口的老师进行补缴，而农村户口的仍被排除在外。此外，青教服务社一直以最低缴费基数而非老师的实际收入缴纳社保，这除了降低老师的保障水平，有年轻教师反映，也降低了他们的居住证积分，影响孩子就学——在上海，居住证积满120分对随迁子女进入公立幼儿园、在沪初升高和参加高考意义重大。

即将失业，让51岁的王国强开始提前担心养老的问题。虽然“纳民”是2008～2010年的事，但青教师生服务社从2011年才开始为老师们缴纳上海市城镇社会保险的（之前是外来从业人员综合保险），因此至今王国强只缴纳了6.5年的养老保险，他希望尽快找到一个单位把金交上。他于是问附近一家公办学校的校长自己能不能去当代课老师，对方直接说：你年纪太大了。

他说最近应该要开家长会了，说学校关闭的事情。“但我该如何安抚家长的情绪呢？”他问道。老师的去向都还没有着落，但是作为老师首先要安抚家长。“我的失落感真的好强烈！”他对《好奇心日报》说。

![](https://i.imgur.com/6rqdySF.jpg)
<figcaption>新希望民办小学里的一块标语，“成绩是昨天的句号”。</figcaption>

这种强烈的失落感，很大程度上来自今昔巨大的反差。王国强回忆，纳民之后，学校获得了各方大量的支持，让老师们觉得学校从此不一样了。当时，老师们先后接受了“共享阳光”、“放飞希望”教师培训，参加区里的星级教师、骨干教师评选，每年好几次外出观摩，与附近公办学校结对，获得后者从专业到物质上的大量帮助。2012年，当时上海市委书记俞正声考察培英小学，2013年，青浦区长考察自己所在的明天小学。

在2010年最高峰的时候，全校有1200名学生和26位老师。但是到2015年，学生突然少了300人，此后每学期减少五六十人。到了2016年，老师原先每年都有的近三千元的节假日费就没有了，老师也不再受邀参加区里的星级教师和骨干教师评选。

1963年出生的李荣侠在去年关闭的育才民办小学工作了15年，2011年曾荣获南都公益基金会旨在表彰全国打工子弟学校优秀教师的“新公民园丁奖”。如今55岁的她也在为退休金发愁。

2014年，她发现青教服务社不再为她缴纳社保，理由是她当时年满50，已经退休。但是，在她的劳动合同上明明写着，退休年龄为55岁。青教师生服务社是从2011年开始为老师交社保的，因此她当时只有4年的社保。交涉无果，她把社保转回了老家蚌埠自己买，每个月613元。要领取社保，到目前为止还得继续买8年，她届时已经63岁。她觉得现在没有收入，每月交600多元实在太贵，所以正想把社保转为农保，即便这意味着未来领到的养老金会变少。

关学校的时候，当时54岁的她被告知据说由于自己已过退休年龄，因此没有任何劳动补偿。她和十几位遇到类似情形的中老年女教师一起，一整个冬天冒着严寒到处奔走，最终在2018年3月通过劳动仲裁拿到了4万多元的劳动补偿款，虽然那里面只给她算了9年的工龄。

![](https://i.imgur.com/Bnq8VYH.jpg)
<figcaption>2018年5月，面临关闭的东方红民办小学的校门，墙上的“先进单位”铜牌在“纳民”之前由农民工流出地政府颁发。</figcaption>

来自安徽的钟老师2007年加入马思国的联合小学，2017年10月因为学校学生减少、经费紧张而被解聘。他回忆，在2009年学校被纳民之后，因为政府规定了一个强制的师生比，老师人数增加，教学压力大大减轻。再加上当时老师们有大量的学习机会，因此都觉得“我们快和公办老师一样了”。

他今年39岁，1999年师范中专毕业，在家当了5年代课老师，辞职时月薪150，一位老师告诉他上海当时农民工子弟学校的月薪能达到850，于是来了青浦。

为了评星级教师，他在2010和2015年分别各考了一个本科和大专学位，每个都花了他两年的业余时间，总共花了不下两万块钱。评上星级教师工资只涨250元，但他看重的是长远的发展。2014年，35岁的他放弃了最后的考安徽的国家教师编制的机会，虽然当时准考证都已经打印了出来，因为他觉得在上海的民办学校发展才是长久之计。

而如今，他仍然没有找到正式的工作，做课外补习每月赚三千多元，妻子工作的饭店随时可能被拆，孩子在老家读书，他不知下一步该怎么走，觉得彷徨、迷茫。

![](https://i.imgur.com/efrRNup.jpg)
<figcaption>2018年5月中旬，民主民办小学对面的一排商铺刚被夷平，上海的“拆违”减少了大量流动人口就业岗位。</figcaption>

有一些老师正在面对自己尴尬的双重身份——既是即将失业的纳民小学教师，又是孩子无法在上海就读的家长。

许春红已经在叙中小学干了13年了。她的学校也将在6月底关闭。她相信自己能在上海找到工作，现在更令她焦急的，是儿子的上学问题。她的儿子今年5岁，本来打算春天在民办的彩虹桥幼儿园上大班。那天她带着孩子去报到，发现幼儿园被很多协管员围了起来，不准学生报到。不久幼儿园就被拆了。于是，她这学期不得不带着孩子上课。

她还有个17岁的女儿，4岁起在上海上幼儿园，念到初二，因为许春红的居住证积分不够，而不得不回到老家念初三准备中考。她说自己也努力过，为了凑满那120分，她年年献血，两分、三分地攒，最后却还是差了十几分。在有了儿子的时候，她打定主意不让他与自己分离。

“我可能快开学时就离开上海了”，许春红告诉《好奇心日报》。她和老公已经决定，留老公在上海赚钱，自己带着孩子回老家安徽宿州，让小的上公立幼儿园，并照顾考上了省重点高中、明年即将高考的女儿。至于工作，可能会在女儿的学校当一名宿管员。

### 政府的“教育控人”

青浦区教育局一位工作人员在接受《好奇心日报》的电话咨询时表示：关闭纳民学校，也是为了能让随迁儿童更好地接受公办教育——因为这样他们可以进入老家的公办学校就学。

无论老家的公办学校是否就更好，孩子是否会顺利进入这些学校，所有人都明白政府关闭纳民小学的真实目的与控制外来人口的大目标有关。青浦区政府办公室的一位工作人员在电话里告诉《好奇心日报》：区政府已经将“二次验证”的审批权下放到了各街镇，标准的宽严，取决于它们各自的教育资源多寡和“人口调控的目标”。

长期跟踪研究流动儿童教育问题的上海财经大学教授、人口流动与劳动力市场研究中心主任陈媛媛认为，2014年“教育控人”以前的纳民模式，依然是国内迄今最好的模式。但长远来看，流动儿童的教育的终极解决方案，还是应该通过加大政府投入，把他们纳入公办学校就读。

政府似乎在朝着这个方向走。2008年，上海计划建造两百多所公办中小学，提高流动儿童在公办学校中的就读比例。但是，陈媛媛认为：只要“教育控人”政策在，“就读比例”提高就不意味着政策在迈向更大的平等，因为更多的孩子已经被迫离开。她最近的一项研究发现：2014年以来大城市的“控人”政策，确实导致了农民工流出地留守儿童的增加。

而另一方面，她认为，虽然眼下城市都在抢高端人才，但在五到十年内，它们就会意识到低技能劳动力的重要性，当经济弊端显现，到时候城市间“是个劳动力都会抢”。

（应受访者要求，文中王国强为化名；感谢上海联劝公益基金会郑依菁为本文采访提供的帮助。）

摄影：蒋亦凡/好奇心日报
