---

layout: post

title: 区块链存“禁文”，受够 404 的人们还有一千种办法

date: 2018-04-26 15:36

categories: Archive

tags: "404"

description: 从拒绝遗忘到对抗 404

---

~~[原文地址](https://a.xiumi.us/board/v5/3FG0L/86113710)~~

作者 \| 陈一拾、小白

---

![](https://i.imgur.com/5m8x9kj.gif)


4 月 24 日，有人在维基百科词条“区块链”的应用项目中加了一条：“网络信息防删除”。

这指的是，北大学生因申请信息公开被学校约谈而发出的公开信被上传到了公共区块链平台——以太坊 (Ethereum) 当中。在北大学生被约谈风波中，互联网上有关的关键词成为了“敏感词”，讨论的文章大多遭遇“被删除”。

![](https://i.imgur.com/kYl0Au9.png)
<figcaption>微博上搜索结果截图</figcaption>


### 区块链没有 404

那份上传了北大学生公开信的“区块 5490403”，目前已有250个评论。评论大多都是支持的声音。有人写到：“历史性的一刻，区块链没有404……”。

出现 “404”，意味着访问的网站页面已丢失。**“区块链没有 404”，也就是说通过区块链上传的信息永不丢失。**

半个月前，原华语媒体端传媒总编辑张洁平就宣布创办内容平台《Matters》，其宣传中强调其使用区块链技术。张洁平在接受台湾媒体《报导者》专访时提到：

> 一旦上了区块链，所有的内容、钱包还有信息，都是**公开、可追溯、不可窜改**，所以这是一个很重要的信任机制，让你的用户信任你这个平台。你钱包里的钱不会有什么变化、权重也不会被后台随便改，不像 Facebook 随时调一个算法，你也不知道是怎么回事。

区块链的特点不仅仅在于其记载信息的永久性。维基百科上给出定义，把区块链类比为一种分布式数据库技术，还具有“点对点传输、加密算法，去中心化”的特点。关于“区块链”具体的原理，目前网络上已经有不少文章进行阐释。

资料显示，“区块链”的概念最早出现在2008年中本聪写的《比特币白皮书》当中。区块链技术最先应用在金融领域，而如今已经在不同领域有所应用。

不过，作为一种信息记载的技术，人们之前没有想象到它能够用来对抗“信息封锁”，直到这次事件。文章《岳同学，区块链在支持你》（*岳⭐是被约谈的学生*）的作者路向 NGOCN 表示：“实际上，本来互联网就是让所有人方便且廉价的获取信息的途径，但（目前）这种途径也被控制，现在看来，技术上也只有区块链可以实现。**采用区块链，恰恰是对付 404 不得不的方法。”**

更让大家兴奋的是，运用这个从文字定义上难以读懂的“区块链”技术来备份文章，**只需要下载一个浏览器插件，而且网上已经有出现对应操作教程帖子。**

<figcaption>点击下面图片，了解“通过区块链上传文章”操作方法</figcaption>
<a href="https://mp.weixin.qq.com/s/b-ahM8RLi4-pJBDTKd0QTg">
<img border="0" src="https://i.imgur.com/htxzC4o.jpg" />
</a>

对于区块链技术记载信息具有难以被删除的特点，也有人表示忧虑。独立媒体人赵思乐提出：**“想象一下，如果你有一个疯狂的技术达人前男友，然后把写你的抹黑黄文写进了区块链，那怎么办呢？”**

《区块链技术指南》一书中在“关键问题和挑战”中亦提到：

> 公有区块链所有交易记录都是公开可见的，这意味着所有的交易，即便被匿名化和加密处理，但总会在未来某天被破解。安全界一般认为，只要物理上可接触就不是彻底的安全。……**作为一套完全分布式的系统，公有的区块链缺乏有效的调整机制。一旦运行起来，出现问题也难以修正。**

### 反屏蔽的“猫鼠游戏”开启

不过，区块链技术目前在信息传播上发挥的作用有限。微信公众号“区块链新探”作者 M 告诉 NGOCN：**“以现在的区块链技术并不能做到对抗信息封锁，例如信息检索，跨链等等功能都没有非常好的实现，只要管束信息向链外世界的传播渠道还是能被封锁。”**（*注：区块链新探 24 日发布文章《岳⭐，我们把你的信写在了区块链上了》*）

根据观察，在 4 月 24 日发布的三篇关于“北大学生公开新写到区块链”的微信图文，目前均显示“此内容因违规无法查看”。**而“区块5490403”以太坊的网页链接也已被微信屏蔽。** 有悲观者认为，公共区块链平台——以太坊 (Ethereum) 网站有可能会被防火墙屏蔽。不过，在M看来，“技术的发展是不能被阻止的，愈反抗愈进步。”

除了区块链技术，还有人尝试用其他技术手段来备份文章。就在这次北大学生被约谈的风波中，有人就在开源代码社区 GitHub 上建立了相关的代码仓库：**sikaozhe1997/Xin-Yue**。（*注：用户可以在GitHub通过建立“仓库”的方式建立开源项目，通过 issue、project等功能进行讨论、共享、协作等。*）

不少人在这个代码仓库上发布了本次事件的主要的且被删除的文章，并整理出事件发展的时间线。有程序员评论：**“这个向来远离舆论漩涡的程序员们自娱自乐的地盘，成了封杀大棒下，最后的一块自留地。”**

截至 4 月 25 日下午 18 时，这个代码仓库已经得到超过 5000 个表示认可的“星”，成为 GitHub 的热门榜首仓库。

![](https://i.imgur.com/RRnXxp0.jpg)
<figcaption>sikaozhe1997/Xin-Yue</figcaption>

在 GitHub 上，还有人建立了被删除文章备份的开源项目仓库。目前，这个开源项目已经对武汉理工研究生自杀事件、北大性骚扰风波、上海环卫工人罢工等一系列公共事件的报道和评论文章做了存档，并在项目介绍中详尽地说明备份文章的具体操作。

D 是这个项目的主要参与人之一。Ta 跟 NGOCN 说：“我看到近期事件‘和谐’太严重，决定参与这个基于 GitHub 的文章备份项目。”如今，D 已经养成了一种敏感：“像现在这样和谐速度特别快的，得时刻盯着，跑在时间前头。”最近一段时间，D 几乎每天花五六个小时在这个项目上。

D 观察到，近两三年时间内 Ta 先后尝试过 Evernote 国际版、Pocket、Google 等工具，但这些工具先后被屏蔽，不适用于微信的封闭环境。在 Ta 参与的这个备份文章项目中，提到了好几种“保证文章传播阅读持久有效性”的方法：阅号菜单栏的非正式群发、订阅号小号、文字保存为长图片、借助有道云笔记。

![](https://i.imgur.com/WRVljke.jpg)
<figcaption>有微信公众号作者用代码来传播内容</figcaption>

除了上面提到的方法，还有层出不穷“民间智慧”：利用其他符号文字代替所谓的“敏感词”；把内容做成长图传播，在长图被屏蔽后，在上面涂抹东西干扰屏蔽。

宾夕法尼亚大学传播学博士候选人、“新闻实验室”创办人方可成把这比作成**“猫鼠游戏”**。他评论道，“我们已经看到了挺好的做法，其实就是不放弃地死磕、见招拆招。最重要的，就是当信息被屏蔽的时候，总会找到一个方法去反屏蔽了，这是一种坚持和韧性。”

![](https://i.imgur.com/BFpiiAj.png)
<figcaption>知乎内容“被掉进荒原”</figcaption>

### 区块链适合这么用吗？

有人认为用区块链来备份文章“太麻烦了”、“成本太高了”。类似的声音也出现在 GitHub 社区的仓库中。对于这个问题，有 GitHub 用户留言：“不可否认，发在 GitHub 上传播效率确实低。但是在国内大部分社交媒体受限，国外传播效率更低的情况下。发在 GitHub 也是一个选择。并且该 repo 本身也不是一定要起到某种传播效应，**我个人认为更可以是表示某种姿态。这种姿态本身也是非常重要的。” **

另外，那份上传有公开信的“区块 5490403”交易手续费使用 0.0007787 个以太币。按照最新市值，才 3 块钱左右。

GtiHub的开源特点更为用户所认可。"sikaozhe1997/yuexin"仓库的一位贡献者表示，“作为本科生的发起人，并没有义务和精力维护一整个页面，**像 Facebook 或者 Twitter 这类非协作式的社交平台并不合适，现在这样有二十多个 contributor**（*共同参与编辑者*）**是分担压力的最好方式”。**

但在GitHub社区上，也有人说：“这些信息不应该发在这里。这是程序员的净土，我们只想敲代码。”

![](https://i.imgur.com/SHDDY40.jpg)
<figcaption>反对的帖子</figcaption>

**方可成分析，更多的反对者实际上是反对把涉及政治的内容发布在无关的平台上**。他认为，目前权力部门与行动者力量和地位都严重不对等。做出“不发布”的选择实际上就是**“帮助权力方面的力量，削弱 activist，也没有中立”。**

也有 GitHub 用户写到：“GitHub 作为世界上最大的开源文化的集中地。我认为这种**维护个人权利，挑战公共强权的事，是绝对不和这种文化相冲突的**。并且 GitHub 自己本身也有对抗公权力的行为。”GitHub 的社区条款中也确实没有不允许发布政治内容。

文章《岳同学，区块链在支持你》作者路有自己看法：“技术运用在什么地方，是由使用它的人决定的，不是你强行界定出来的——更何况，现在法律都没有界定这个。这种自我阉割算什么，说不定区块链更适合做这些呢？”

![](https://i.imgur.com/niEsdAA.jpg)
<figcaption>公共区块链平台——以太坊 (Ethereum) 的公开信</figcaption>

<https://etherscan.io/tx/0x2d6a7b0f6adeff38423d4c62cd8b6ccb708ddad85da5d3d06756ad4d8a04a6a2>

---


<figcaption>扫码订阅CN的邮件</figcaption>
<figcaption>这是我们对抗404的方式</figcaption>

<div style="text-align:center">
<img src="https://i.imgur.com/Rw8BiZz.png" alt=qrcode>
</div>

![](https://i.imgur.com/8BXbN8l.jpg)
版权声明：如非特殊说明，公号文章内容均为NGOCN原创，转载请联系后台
![](https://i.imgur.com/rJmFun1.gif)
