---

layout: post

title: 让高校信息公开与学生管理回归法治轨道

date: 2018-04-24

categories: Archive

tags: 声援岳昕

description: 我实在没有理由不向前走；我实在没有理由仅为自己而向前走。

---

转载自微信公众号“清律”文章 [清育 \| 让高校信息公开与学生管理回归法治轨道](https://mp.weixin.qq.com/s/6EjLdr6dh9wHEarJaaFUxg)

作者清律郑厚哲

---

因二十年前发生的一起教师师德问题，在高校已经公开对涉事教师的处分决定后，多位学生向高校申请信息公开，要求进一步公开当时学校讨论该问题的会议记录、公安局的调查结果通报及涉事教师公开检讨内容等信息。

学生称高校答复意见如下：1. 会议级别不够记录；2. 公安局调查结果不在学校的管理范围里；3. 公开检讨的内容因院系工作失误也没有找到。

有学生称在申请信息公开后被高校约谈且不断施加能否顺利毕业、找家长等压力，甚至于午夜被强制要求删除相关信息、承诺不再介入此事，后被家长带回家中无法返校。该学生以公开信对高校处置表达激烈抗议。

高校院系随后公开发布《情况说明》，介绍高校出于关心和爱护学生联系的家长等情况。


基于长期为高校提供法务支持的经验，笔者认为：**这一事件信息公开申请本身是一个相对成熟的法律技术问题，也完全可以通过法律技术解决**。遗憾事件的发展却颇为诡异地让一个技术问题逐步放飞一发不可收拾。本文通过技术角度分析并基于对高校管理的粗浅理解妄加评述，也期待事件早日回归法治的轨道上来。

## 高校信息公开申请答复并无不当

很多观点旗帜鲜明地站在所谓「弱势」和「正义」一方，而先入为主地认为高校的答复不符合信息公开要求涉嫌违法。这类观点并不站得住脚。针对三件信息公开事项逐一分析：

### 会议记录

首先，高校答复因会议级别不够记录而不存在，并无不当。尽管在二十年后的今天该事件引发了热议，但在当时高校的处分的确为警告，并未留存会议记录具有合理性。**请注意，我说的是基于警告前提而未留存会议记录的合理性，而对警告处分本身是否正当未作评论。**

其次，更重要的是，即使留存了会议记录，相关信息也不应公开。**会议记录作为形成行政行为的过程性文件，并不对外产生直接约束力，属于高校应当保密的内部信息**。如果这样的信息可以公开，那么与会人员势必难以畅所欲言，而影响行政决策的科学性。正如于艳茹vs北京大学信息公开案判决论述：「**公开此类内部信息，将导致相关人员难以坦率地表达及交换自己的真实想法，从而对意见表达的中立性造成不当损害，进而影响行政决定的正确作出，不利于实现政府信息公开条例第一条促进依法行政的宗旨。因此，上述内部信息不属于政府信息公开条例所指应公开的政府信息。**」

### 公安局调查结果

该信息显然为公安机关掌握而不由高校掌握。高校答复公安局调查结果不在自己管理范围内没有任何问题。

### 公开检讨的内容

校答复因院系工作失误没有找到，情有可原。

其一，基于前述，考虑高校仅作出警告处分，在当时认为并不严重，要求高校时隔二十年找到关于警告处分的相关公开检讨，对于高校档案管理提出了极高的要求。

其二，更要充分考虑到，**二十年前尚无《政府信息公开条例》，更无论《高等学校信息公开办法》，当时整个社会对于公共信息的保存和公开意识还都停留在相当原始的阶段。拿今天的标准去衡量二十年前的信息公开水平，对高校过分苛责**。

学生当然有权提出信息公开申请，也有权对高校的答复表示失望甚至不满，前者属于申请人的法定权利，后者属于申请人的表达自由。但无论申请人的主观满意度如何，高校这次信息公开答复内容本身并无问题。

## 申请信息公开与学生毕业无关

除了信息公开本身，还有大量报道提及学生被约谈，甚至被施加顺利毕业压力等。如果相关描述属实，高校的相关处置恐怕没有任何依据。

关于约谈，高校与学生就某些问题进行平等交流并无法律障碍，但如果约谈频繁且选择深夜，很难说学生是自愿而非被迫参加。从学生单方披露的沟通内容看，对话双方已经存在强烈的不信任感甚至对立情绪。

关于毕业，2017年刚修订的《普通高等学校学生管理规定》要求很明确，即「**学生在学校规定学习年限内，修完教育教学计划规定内容，成绩合格，达到学校毕业要求**」。当然前提是学生在毕业前没有退学或被处分开除学籍。而关于退学和开除学籍也有严格的法律规定限制，高校裁量空间很小。即便高校真的施压对学生进行处分或对毕业制造障碍，现行法律对于学生有充分的救济保障。坦率讲，我不相信隔壁会犯如此明显而低级的错误，特别是于艳茹案还殷鉴不远。

需要强调的是，除了退学或开除学籍，学生是否毕业以及是否获得学位，应基于对学生学业与学术水平的评价，这与信息公开是两个完全不相关的事务。**不能因公众事件对学生毕业制造障碍，当然也不能因公众事件对学生毕业放松标准**。

## 高校有权谨慎联系家长

学生对「找家长」具有天然的反感，特别是年满十八周岁具有完全民事行为能力，自我意识日渐膨胀后尤其如此。但现实情况毕竟是，绝对多数在法律上已经独立的学生在经济上和生活上并不独立。

学生的独立精神当然是高校应当鼓励和培养的。记得我在大一时对于法律（大一主要学习民法）的理解凝练为两句话：「自我负责」和「契约精神」。这两句话对于我此后的人生也产生了莫大的影响。但我也理性地认识到，如果一边喊着独立自主，一边让家里汇钱那是双标。

不出事时家长、学生拒不配合高校工作，出事后把责任推给高校的案例并不鲜见。考虑目前高等教育和传统家庭关系等现实情况，高校与家长的良性互动有利于学生成长，高校也有权利与家长直接沟通。

**在特定情况下，高校不但可以与家长沟通，且应当与家长沟通**。比如发生校园危机，发现学生存在精神障碍甚至有自杀倾向，行为能力受损的；比如发生校园信贷诈骗、校园伤害等突破学生通常学习生活范围之外的突发事件等。

但是，如果高校将「找家长」理解为对学生施压的手段，不但没有任何依据，还构成对学生、家长权利的侵犯。挑拨家长与子女这种最为亲密的关系不但十分不智，其效果也犹如抱薪救火，扬汤止沸。

## 依法处理高校与学生的关系

现代社会的师生关系和高校与学生的关系，早已不再是「师道尊严」和纯粹「管理与被管理」的关系。学生的独立意识、权利意识空前强大，获取的信息、思考问题的深度广度早已今非昔比。

学生「不服管」让高校疲于奔命，简单粗暴的管理手段效果越来越差。**高校要做的是积极适应现代教育发展理念，适应依法治校、依法治教的时代背景，切实落实《全面推进依法治校实施纲要》和《依法治教实施纲要》。对于学生的「异类」行为，也应当有更多的包容。这是社会对于高校的期待，也是对于北大的期待**。

学生有表达诉求的权利，有申请信息公开的权利，甚至有犯错的权利。不要说学生没有犯错，即便犯错，学校的立场应当是帮助教育而不是弹压。学校正是教育人的地方，如果已经教育好了还来学校干什么呢？

指点江山，激扬文字，书生意气，挥斥方遒。为公共利益鼓与呼而不是成为精致的利己主义者，这样的学生正是高校应当和希望培养的学生。这样的意气之举即便不鼓励不提倡，至少也应当保护。

显然百廿年校庆前夕的这一插曲给北大造成了损失。这损失不是申请信息公开的学生造成的，而是处置严重失当造成的。于是我们看到一个本可以通过理性对话解决，印证百年名校风骨甚至为校庆献礼的「事迹」，被一步步地搞成了「事故」。于是我们也看到，对于传统高校管理而言，法治是一个看似成本较高的方式，但是本事件恰恰证明很多时候，法治是成本最低的。
