---
layout: post
title:  "戊戌 120 年祭"
date:   2018-02-22
categories: Archive
tags: 戊戌年
description: 又是一个戊戌年。
---

### 一

元朔二年（前 127）正月，漢武帝頒布推恩令，令諸侯王分封子弟為列侯，並將王國封地分給自己的子弟。這直接引致了尾大不掉的各諸侯王國的分崩離析，大一統的中央集權正式建立。自此，由共主或中央王朝給宗族姻親、功臣子弟分封領地和相當治權為特徵的封建制，在中國這塊土地上銷聲匿跡。取而代之的，是長達兩千多年、幾乎看不到盡頭的對專制集權的反覆爭奪與循環更替。

元和二年（公元 85 年），漢章帝下令在全國推行干支紀年，並一直延續至今。與西方公元紀年的絕無重複不同，干支紀年每 60 年會重新一個輪迴。

我們這個民族，最鮮明的底色與烙印，在幾乎兩千年前就已定型，之後只是一輪又一輪的輪迴而已。

這，算不算一種冥冥中的宿命詛咒？

### 二

1898 年 9 月 28 日下午四時，北京宣武門外菜市口刑場，烈日高照下的刑場上人山人海。這是中國近現代史上頗為悲壯黑暗的一個日子，譚嗣同、劉光第、康廣仁、楊深秀、楊銳、林旭等 6 位維新變法人士在這裡被處斬，圍觀的上萬百姓興奮地向他們身上扔著白菜幫子！這一年是中國的農曆戊戌年，史稱「戊戌六君子」。而由他們主導的那場比日本明治維新晚了 30 年的變法，史稱「戊戌變法」。

![01.png](https://i.loli.net/2018/04/26/5ae1c08c5aed8.png)

<figcaption>戊戌六君子</figcaption>

這場變法的大背景，是中國已經停滯了近千年的社會與羸弱不堪的競爭力。儘管 GDP 一度達到過全球的三分之一，但清王朝其實在「康乾盛世」最頂峰時就已開始脫離世界發展主流，開始走向衰敗的不歸路了。除了物質財富產出效率被工業革命后的歐洲越拉越大外，清王朝頂峰時期的 18 世紀，人類真正的進步是政治制度文明。乾隆十三年（1748 年），孟德斯鳩發表了名著《論法的精神》。乾隆四十一年（1776 年），美國的清教徒們在這一年發表了「人人生而平等」的獨立宣言，一個幾乎一無所有的叫美利堅的新國家誕生。乾隆五十四年（1789 年），法國爆發資產階級大革命，提出「主權在民」原則。乾隆退位后的第二年（1797 年），華盛頓宣布拒絕擔任第三任總統，完善了美國的民主政體。

18 世紀，世界文明大潮的主流，是通過立憲制和代議制「實現對統治者和權力的馴化，把他們關到法律的籠子里」。而在地球的另一端，滿清皇帝們積幾代人上百年的努力，完成了中國歷史上最縝密、最完善、最牢固的專制統治，把民眾關進了更嚴密的專制統治的籠子里。

史書上津津樂道的「康乾盛世」，其實只是以空前的政治穩定，養活了數量空前的人口，奠定了中國今天的版圖。然而對比 18 世紀世界文明的發展，康乾時代是一個只有生存權沒有發展權的家天下，也是中國歷史上民眾權利被剝奪得最乾淨、意志被壓製得最靡弱的時代之一，是一個基於少數統治者利益最大化而設計出來的盛世，其給中華民族精神上造成的永久性創傷，遠大於這一時期的成就。

亞當·斯密在巨著《國富論》中是如此刻薄地批評彼時的中國的：

「中國長期處在靜止狀態，其財富在多年前就已達到該國法律制度允許的最高限度。如果改變和提高他們的法治水平，那麼該國的土壤、氣候和位置所允許的限度，可能比上述限度大出很多。」「富人和大資本家很大程度上享有安全，而窮人和小資本家不但不能安全，而且隨時都可能被低級別的官僚借口執法而被強加掠奪。」

這種對平民財產的肆意剝奪，有的時候是一種個別行為，但更多的時候則是一種專制集權基礎上的政府行為。由於私人財產得不到有效保障，中國成了世界上財產繼承與創造都極為低效的國家。

但這其實不是康熙乾隆們的錯。於他們而言，不受制約的專制集權，就如同壯年男人面前的春藥與後宮，斷無主動放棄的可能。

世紀之交的 1799 年，華盛頓在大洋波岸去世，他給世人留下了一部三權分立的憲法，以及一個蒸蒸日上的現代國家。同一年，乾隆去世，留給他子孫的，是一個看似龐大，實則羸弱不堪，一推即倒的「泥足巨人」。

100 年後，飽受鴉片戰爭及甲午海戰羞辱的康乾子孫們，推動了那場沽名釣譽式的變法。

「我自橫刀向天笑，去留肝膽兩崑崙」的譚嗣同並非「根正苗紅」的革命者，某種意義上，他甚至屬於「既得利益者」。其父譚繼洵為晚清重吏，於京城戶部任官十六年，后調任甘肅任省按察史，光緒十五年調任湖北巡撫，嘗兩次兼代湖廣總督，為正一品封疆大吏，累官贈光祿大夫。

但譚嗣同是少數看清了中國千年輪迴癥結的人，而 1895 年甲午海戰的慘敗與中日《馬關條約》的簽訂，則讓他開始對這個腐朽沒落的專制王朝絕望，所以他要「廢君統，倡民主」，指出「數千年來統治者皆大盜也，實為民賊！」，這也是「蒙幸」被光緒帝徵召入京，參與變法新政后，他的激進主張最終會觸痛「專制君權」這個慈禧太后底線的原因，加之維新派荒唐的「圍園劫后」計劃觸怒慈禧，1898 年 9 月 21 日，慈禧太后發動宮廷政變，將光緒皇帝囚禁於瀛台，並下令逮捕維新派人士。

事實上，維新派所謂的「激進」主張里，甚至連「君主立憲」都未列入——一旦涉及到最核心的「專制權利」，就沒有任何商量的餘地，所以這場在史書上「轟轟烈烈」的變法，其實是一場幾乎一開始就註定會失敗的帝后權利爭鬥而已。

但這絲毫不會黯淡譚嗣同的光芒。他如同一顆劃過暗黑夜空的流星，留下一道異常耀眼的軌跡，引導、激勵著一個又一個不自由、毋寧死的熱血兒郎，在為了自由理想的道路上衝鋒陷陣，不畏生死！

作為封疆大吏的兒子，他本來也可以和梁啟超那樣出逃保命。但為了中國變法自強的大業，譚嗣同選擇留了下來，試圖用自己的鮮血來喚醒麻木的國人。在刑部獄中他給梁啟超的絕筆書中寫道：「嗣同不恨先眾人而死，而恨後嗣同死者虛生也。嚙血書此，告我中國臣民，同興義舉。」

「壯矣，維新欲殺賊而未回天，終成國恨；快哉！喋血屹崑崙以昭肝膽，長醒吾民」——這是後人撰於譚嗣同故居上的對聯。

只是從 1898 年 9 月 28 日菜市口刑場上萬人同嗨的現實，以及那個戊戌年後中國近百年令人唏噓的詭異走向，「有心殺賊，無力回天」的譚嗣同是否真「死得其所，快哉快哉!」殊未可知。

### 三

一個有趣的設問是：如果 120 年前的那場變法並未中斷，中國能自強嗎？

這個問題，在戊戌變法兩年後，慈禧和光緒都問過自己。

1900 年 8 月 14 日，假義和團之亂而起兵的八國聯軍攻入北京，京城完全陷落，一手扼殺了戊戌變法的慈禧倉皇出逃，一路狂奔到西安——這個出逃行為被清政府取了個很唯美的名字：「兩宮西狩」。

1900 年 8 月 20 日，慈禧假光緒之口，發布帝國的《罪己詔》，皇家文件的豪華文采全不見蹤影，像極了一篇小學生因為小錯而寫給老師的悔過書。一百多年後的今天，不讀不行，讀之生厭。

《罪己詔》，把罪過一股腦推到了「愛國者」義和團身上，下令對義和團「痛加剿除」：淶涿拳匪，焚堂毀路……妖言邪說，煽動愚人……膽敢紅巾露刀，充斥都城，焚掠教堂，圍攻使館……天下斷無殺人放火之義民，國家豈有倚匪敗盟之政體？

![02.png](https://i.loli.net/2018/04/26/5ae1c08b4e5ed.png)

<figcaption>（1900 年，清政府抓捕的義和團）</figcaption>

「天下斷無殺人放火之義民，國家豈有倚匪敗盟之政體？」——不知道那些被炮灰了的「愛國者」看到這兩句文縐縐的「愛國成賊」的評判，會作何感想？或許利用過後，碾做炮灰，就是他們的宿命？

慈禧假光緒之口發布的《罪己詔》中有一句頗值得玩味的話：「即無拳匪之變，我中國能自強耶？」

在整篇《罪己詔》中，只有這句反問，像是皇帝自己的話。

可是，話是問的不錯，問題是：問誰呢？整個大清帝國，誰有這個視野和見識，能回答這個問題？

被史書奉為「睜眼看世界第一人」的魏源其實是沒有這個能力的，他其實只是史學家雕琢出來，用以反襯滿清當權者多麼眼光狹窄短淺的一尊吉祥物而已。魏源賴以成名，並提出「師夷長技以制夷」的著作《海國圖志》是在南京城西清涼山下烏龍潭邊，在林則徐主持編譯的《四洲志》的基礎上「編撰」而成的。

換句話說：世界你都沒觀過，哪來的世界觀？

在一個國家向現代國家轉型的過程中，一批知識分子到發達（歐美）國家親眼觀察並引進先進的思想與制度，至關重要。如果不直接地觀察對比，僅僅通過閱讀了解，常常是隔靴搔癢，甚至斷章取義，走向極端。

與魏源形成鮮明對照的，是與他同一個時代的福澤諭吉：前者留下了一本夾生熟的書，而後者在遊歷歐美后，以思想為武器，直接引致了整個日本的現代化。

客觀地說，慈禧是有視野和魄力的。她不反對變法，據費行簡《慈禧太後傳信錄》載，早在變法之初，慈禧太后即對光緒帝說：「變法乃素志，同治初即納曾國藩議，派子弟出洋留學，造船制械，以圖富強也。」「苟可致富強者，兒自為之，吾不內製也。」沒有慈禧的支持，戊戌變法根本不可能推行。而百日維新后慈禧扼殺變法，無它，只是因為變法最後在試圖拿走她的權杖，完全架空她。

慈禧一點也不排外，甚至對西洋器具情有獨鍾。1861 年咸豐駕崩，20 多歲的慈禧，沒有像 20 多歲的武則天和孝庄那樣用陪睡換江山，而是直接發動政變上台。慈禧在奪取大清統治地位之後的前三十多年裡，只做了一件事，就是選擇了中國幾千年歷史上「第一次大規模引進西方科技」的洋務運動。她果斷啟用了曾國藩，李鴻章，左宗棠，張之洞等外向進取的漢人，並提升李鴻章為洋務總工程師。洋務運動快速發展了大清的經濟：火車鐵路，兵工廠，紡織廠，電報局，北洋艦隊，機械化露天煤礦，煉鐵廠等等行業企業第一次出現在封閉千年的中國。洋務運動只用了短短三十多年時間，就把一個等同於唐漢時期農業經濟體的國家，帶進了近代經濟體的大門——這在幾千年中國歷史上實屬開天闢地。

但作為全球最大專制集權政體制的最高掌權者，對權勢的戀棧，將令慈禧排除任何可能引致統治風險的選項。這是一種無法醫治的，骨子裡的排外——排斥的不是外人，外面的技術，而是任何一個可能根本上動她權杖的事物，無論是人，還是制度。

但只靠洋務運動一條腿發展起來的大清，很快就跌倒了。就算大清的歷史沒有甲午戰爭的慘敗，只發展經濟的洋務運動也註定保不住大清。一位學者如是論述：因為西方的科技進步和經濟發展，是同體制配套使用的結果。大清只引進科技，就像買手機不要充電器，待機時間再長，也會沒電的。

歷史也並不是沒有給清王朝機會。當時最見多識廣，視野最闊的，算是李鴻章了。他是中國第一位專門與「洋夷」打交道的人，也是大清第一個外交家。如果說慈禧是「洋務運動」的總設計師，李鴻章就是最堅決的踐行者。

1896 年，七十有四的李鴻章開始遊歷歐美，歷時近 7 個月，行程 9 萬里，先後遊歷了俄、德、荷蘭、比利時、法、英、美、英屬加拿大等。在這些國家，他受到了熱情款待，會見了俾斯麥等各國政要，也參觀了工廠、報社、學校、礦山、電報局、銀行，在德國還專門請醫生以「電照法」即 X 光檢查了年前馬關談判時被日本憤青小山豐太郎行刺時仍留在臉上的子彈。

![03.png](https://i.loli.net/2018/04/26/5ae1c08a36792.png)

<figcaption>（大清裱糊匠李鴻章與俾斯麥）</figcaption>
</div>
<br/>

可惜，搞了半輩子洋務運動的老頭，仍然只發現了歐美的器物之美，發現不了器物之後的東西：用楊小凱先生的術語來講，根源還在於「后發劣勢」。

李鴻章旅遊到英國，對英國的一架縫紉機都能著迷，並不惜重金，給老佛爺購回一台。但卻（刻意？）忽略了最不應該忽略的一件東西——他在代表西方政治制度的英國下院為他特設的席位上旁聽了議員們的辯論，覺得那是一窩蜂似的吵架，說：「無甚可觀。」

「無甚可觀」——四個字，代表了當時整個民族的視野。

### 四

60 年後，戊戌重回，又一個輪迴。

1956 年，國際共產主義大家庭形勢驟變。赫魯曉夫上台後作了批判斯大林的秘密報告，在波蘭、匈牙利則爆發了知識份子領導的民主運動，匈牙利脫離華沙條約組織，而赫魯曉夫的秘密報告也在中國悄悄流傳。

為順應形勢，1956 年 4 月 28 日，中共中央政治局擴大會議提出了「百花齊放、百家爭鳴」的雙百方針，發動群眾向黨提出批評建議。但在大鳴大放後期，出現一些對黨和政府批評相對尖銳的言辭，比如民盟中央副主席羅隆基、光明日報社總編儲安平等「DANG 天下」的發言：「這幾年來黨群關係不好，而且成為目前我國政治生活中急需調整的一個問題。這個問題的關鍵究竟何在？據我看來，關鍵在『DANG 天下』這個思想問題上。我認為黨領導國家並不等於這個國家即為黨所有；大家擁護黨，但並沒有忘記了自己也還是國家的主人。」這讓毛澤東等領導有了政權被「復辟」的疑慮和恐懼。

1957 年 5 月 15 日，毛澤東撰寫了《事情正在起變化》一文，要求認清階級鬥爭形勢，注意右派的進攻。6 月 8 日，中共中央發出《關於組織力量準備反擊右派分子進攻的指示》，同日，《人民日報》也發表了《這是為什麼？》的社論。從此，中國開始了大規模的反右鬥爭。

而該鬥爭的高潮年，1958 年，恰好是中國農曆戊戌年。

![03.png](https://i.loli.net/2018/04/26/5ae1c08a36792.png)

<figcaption>（1957 年國慶的反右遊行）</figcaption>

1957 年底，《甘肅日報》編輯部召開黨外人士座談會，主持座談的一位副總編輯滿臉堆笑，一次又一次親切地動員年輕的王景超發言。此時的王景超，絲毫不知道，毛澤東關於「誘敵深入，聚而殲之」的指示，已在半個多月前在黨內一定範圍內傳達。他也不知道，他的一篇雜文，已被內定為毒草。最終，王景超被打成右派，並且劃為極右，開除公職，遣送農場勞教。受丈夫牽連，其妻和風鳴也被劃為右派。

一九五八年四月下旬，王景超、和風鳴與報社其他四名右派一起，從蘭州乘上了西行的列車，分別前往位於甘肅西北部的夾邊溝農場開始其勞教或監督勞動的生涯。當王景超先於其他五人在酒泉下車前往夾邊溝農場時，和風鳴絲毫也沒有想到，她深愛著的丈夫正在走向死亡之地。

夾邊溝勞改農場位於甘肅西北部的酒泉，土地貧瘠，鹽鹼化嚴重，天氣寒冷，冬天氣溫可以到零下三十多度，且常刮大風。將右派分子發配到這樣一個地方，帶有加重懲罰和折磨的意味，不僅讓右派們參加繁重的勞動，而且使他們長期處於飢餓之中。

不讓右派們吃飽飯是有意為之。夾邊溝農場並不缺糧，即使在一九六〇年冬天的大飢荒中右派們大批餓死時，農場仍然囤積了不少糧食。夾邊溝農場禁止右派家屬們寄糧票，因為有了糧票，右派們就可以去縣城的餐館吃飯，或向附近的農民換取食物。

長期在飢餓中參加繁重勞動，右派們的身體都垮了下來。當一九六〇年十一月，在大飢荒席捲全國，夾邊溝農場再度大幅削減人們的糧食配給，而寒冬又開始降臨的時候，夾邊溝的右派們就開始面臨滅頂之災。躺在冰窟一般的「地窩子」里，食不果腹、全身浮腫的人們知道自己正一天天走向死亡，但卻毫無辦法。他們無力出逃，也無處可逃，只能靜待死神的降臨。一位右派用手指向難友比劃出「坐以待斃」幾個字，不久后咽了氣。

在餓到發狂的情況下，甘肅的許多農場都出現了煮食死亡難友人肉的事情。人食人，中國史書上有記載，但是，知書達理的知識份子一次次地噬食自己同類的屍體，恐怕是中國歷史上有記錄以來的第一次。

一九六一年一月，由於各農場死人太多，甘肅省允許在農場的右派回到原單位。此時，夾邊溝農場的兩千八百多名右派中，僅剩了六百多人。由於當初屍體掩埋十分草率，致使屍骨不斷從掩埋處暴露出來，至二十世紀八十年代，累累白骨綿延竟長達一公里以上。如此密集地躺在荒漠曠野里的白骨，以一種慘烈的方式展現著由野蠻的政治權力製造的人間慘劇。

據 1978 年平反右派過程中的官方統計數據，在 1957 年的「反右運動」和 1958 年的「反右補課」中，全中國抓出了五十五萬名「右派」絕大多數都經歷了比較悲慘的命運。在經歷過反右、文革等一系列整治運動后，活到 1978 年平反的僅有十萬餘人。

這些右派中，就包括了 1958 年被劃為右派並開除黨籍，20 年後才平反的前國務院總理朱鎔基。

1957 年開始醞釀的反右，對後來中國的影響極大。它標誌著執政黨的政策重新回到以政治挂帥，強調階級矛盾和階級鬥爭的路線上來，意識形態鬥爭的重要性從此徹底壓過了經濟建設。

更關鍵的是，知識分子再也不敢批評執政黨及其政府，各個民主黨派方面，經歷過從「言者無罪，聞者足戒」到「引蛇出洞」的驟然轉變，各黨派在政治生活中不敢發聲，造成這些政黨一步一步愈發邊緣化，執政黨的權力約束不再，政治路線從此嚴重左傾，以致「大躍進」、「四清運動」、「文化大革命」運動蜂起，爭鬥慘烈，革命吞噬革命，人民專政人民。

這種狀態，一直持續了 20 多年——這幾乎是一代人的時間，才得以逐步修正、改善。

而同期，「亞洲四小龍」的香港、台灣、新加坡、和韓國，以及我們的近鄰日本，都開始了經濟騰飛。

兩千年前秦始皇的焚書坑儒早已失去了恐怖色彩，人們更多只是當做一個趣味史料。但在人類已經開始邁向太空時代的五十年代，反右這樣古今中外罕見的大規模迫害知識份子，近乎野蠻、原始、蒙昧的政治鬥爭，為什麼還能夠在中國發生？

僅僅歸咎於無可奈何的歷史輪迴？

### 尾聲

2 月 20 日大年初五那天，一早起來，滿屏都是接財神的，我也湊個熱鬧，送了大家三個財神。

財神一：最大美元百元大鈔上的頭像不是總統，而是著名科學家、金融家、政治家富蘭克林，《獨立宣言》的起草人之一。

![04.png](https://i.loli.net/2018/04/26/5ae1c08c6d7e6.png)
<figcaption>富兰克林</figcaption>

正是《獨立宣言》中以下最經典的兩句，保證了美國在短短 243 年的時間裡，創造了人類歷史上最大的財富，且完全沒有停歇的跡象：

We hold these truths to be self-evident, that all men are created equal, that they are endowed by their Creator with certain unalienable Rights, that among these are Life, Liberty, and the pursuit of Happiness.

我們認為這些真理是不言而喻的：人人生而平等，造物者賦予他們若干不可剝奪的權利，其中包括生命權、自由權和追求幸福的權利。

That to secure these rights, Governments are instituted among Men, deriving their just powers from the consent of the governed.

為了保障這些權利，人類才在他們之間建立政府，而政府之正當權力，是經被治理者的同意而產生的。

財神二：日元最大面額上是一個出身平民、終身未仕的教育家、思想家，他叫福澤諭吉。

![06.png](https://i.loli.net/2018/04/26/5ae1c08bd0d21.png)

<figcaption>福澤諭吉</figcaption>

他是日本明治維新時期的啟蒙思想家、教育家，著有《勸學篇》、《文明概略論》、《脫亞論》等，主要思想是反對封建專制、崇尚自由平等，呼籲日本脫離東方愚昧文化，學習西方。雖然他是一介平民，終身未得一官半職，卻主導了 19 世紀後半葉以後整個日本的思維改造與國家走向，讓日本從一個比滿清還封閉落後的島國，一躍成為全球強國。

財神三：我們自己的財神，想了很久，無疑是 2 月 19 日滿屏紀念的這個人。

![07.png](https://i.loli.net/2018/04/26/5ae1c08cb9658.png)

<figcaption>（邓小平）</figcaption>

是他強調「我們落後的關鍵還是我們從五十年代起，不抓經濟而抓階級鬥爭，搞一大二公的社會主義。我這裡不是說社會主義搞錯了，但我也不能說我們完全搞對了。」「發展才是硬道理，成天去爭論什麼資本主義、社會主義有啥意思？你搞得清楚嗎？反正我是搞不清楚。」他是名副其實的，真正讓大多數中國人一年到頭有錢大吃大喝、消遣娛樂、滿世界旅遊以至於讓春節都失去了年味兒的「財神」。中國（經濟）在 70 年代末基本頻臨崩潰，沒有他，我們極可能仍如朝鮮一樣饑寒交迫，更惘談看世界。三十年來不斷有把他印到更大面額人民幣上去的傳聞，但最終他的形象還只是出現在《時代》周刊之類的媒體封面上。人民幣大鈔從 10 元漲到了 100 元，印的還是那個讓我們憑票證過年才能吃點兒好的、穿衣服新三年舊三年縫縫補補又三年的大救星。

一國之貨幣，就是該國財神的祝福禮物。但遺憾的是，不是所有國家都把帶他們走上富裕道路的人如富蘭克林和福澤諭吉都印在紙面上……

正好今天股市開盤，與一個做跨境投資的哥們再次聊及美聯儲的加息及特朗普驚世駭俗的大減稅，他發來如下一段話：政治家的偉大，從來都是做出來的，而不是吹出來，捧出來的。只要美國贏了，輸了全世界又如何？特朗普癲狂的行事作風後面是真正的高瞻遠矚！大規模減稅，這是特朗普的一小步，但卻極可能是美國的一大步！！體制，才是美帝永恆的優勢。我們常犯的錯誤是，只看它的制約與低效，而忽視它的反省、糾錯、持續，這才是美帝自信之本。持續與輪迴，你告訴我，兩者誰能勝出？

多歧路，今安在？

下一個戊戌年，我們在哪？
