---

layout: post

title: 中国特色的种族歧视：黑脸给中国的春晚“抹黑”

date: 2018-02-21

categories: Archive

tags: 春晚评论

description: 小品中没有提到中国获得的经济收益。往好听了说，这是对国际关系的片面描述，往难听了说，这个小品是在新年里贬低非洲人民，抬高中国观众。

---

信息源自Black Lives China： ~~[中国特色的种族歧视: 黑脸给中国的春晚“抹黑”](https://blackliveschina.com/2018/02/21/中国特色的种族歧视-黑脸给中国的春晚抹黑/)~~

Hannah Getachew and Runako Celina Bernard-Stevenson联合撰写, 翻译： Tiffany

---

![春晚](https://i.imgur.com/zWGg6AN.jpg)

“黑脸”事件使2018年春节联欢晚会的名声变得不太好，这一事件在网上不仅引起了中国和世界其他地区的非洲人和非洲裔群体的热烈讨论，而且也吸引了中国人甚至西方媒体的加入。约有8亿人在屏幕前观看到了这一情景：一名中国女演员扮演一名非洲妇女，她涂黑了脸，并穿上了夸张的假臀和假胸。正如许多人知道的，这个小品讲述了这样一个故事:

一名刚刚18岁的非洲女孩，被她的妈妈(把自己涂成黑脸的中国女演员Lou Naiming)逼着结婚。她不想这么年轻就结婚而是想到中国去留学。在小品中，她的人设是一名对中国充满热情，为中国着迷的非洲女孩儿。因此，她让她的中国朋友假装是她的未婚夫，让她的妈妈相信她会很快和这个中国人结婚，以蒙混过关。得知女儿打算嫁给一个中国男人，这位非洲妈妈大喜过望，不停地告诉观众她是多么感激中国为非洲所做的一切。然而，当这位“假女婿”真正的未婚妻(一个中国女人)穿着婚纱出现在舞台上，准备说“我愿意”的时候，这个把戏就露馅了。

当她的女儿解释为什么她谎称要结婚，并坚持要到中国留学时，这位母亲似乎忘了她想看到女儿出嫁的愿望。相反，她深情地凝视着观众，并不断地说“我爱中国人民”，“我爱中国”。

在这个小品中，那个猿猴的角色也充满了争议，到目前为止还没有确切的消息证实，猿猴的扮演者是否是一名非洲裔演员。

正如开场一样，小品在歌星Shakira那首著名的南非世界杯主题曲哇卡哇卡的动感旋律和非洲舞者热情的舞蹈中结束了。

### 不同非洲人的不同声音

在小品中，多次提到“非洲”，将非洲大陆简单的视为一个整体。事实上，非洲大陆上有55个国家，其面积是中国的三倍。在这个小品中表现的非洲仅仅是撒哈拉以南的非洲，不能代表全球的非裔移民文化，甚至不能代表北非国家的文化。非洲很大、很复杂、很多样化，不能简单的用任何单一的词语来代表。

这一原则同样适用于这篇文章。我们并不认为这篇文章的观点能代表全部非裔人对这个小品的看法。如果有任何一篇文章声称能代表全部非裔群体，那你都应该持怀疑态度。

在非裔群体中，有些人觉得这个小品无伤大雅，有些人觉得有意思，还有些吃瓜群众觉得无感。对他们来说，小品中出现的元素是真实的，斑马、狮子和猴子都来自撒哈拉以南的非洲国家。有些人很享受小品中的非洲音乐和舞蹈，情不自禁地伴随着舞台上的鼓点打起了节奏。

还有一种声音则认为这个小品的出现要从经济背景去分析。他们认为，这种对非洲带有歧视色彩的描绘，是源于中国与非洲之间悬殊的经济实力水平，尤其是，中非之间的经济投资及其失衡。如果非洲国家在谈判中能够根据自己的情况，向中方明确表达优先需要什么，而不是被动的接受，中国对非洲种族歧视将会逐渐消失。以上列举的是非裔群体对这个小品的几种不同的看法。

### 是否是种族歧视?我们的看法

大家的评论中，出现最多的质疑就是，这个小品，尤其是非洲妈妈这个角色是否存在种族歧视或者种族主义倾向。

对许多人来说，小品中关于非洲人的呆板的造型，是历史上出现的种族主义以及人类早期一些对黑人的犯罪行为的再现。例如当时欧洲人把南非妇女Saartjie ‘Sara’ Baartman锁在马戏团的铁笼子里，供人参观她的曲线十分明显的躯体。

这张黑脸让人想起19世纪的一种拿黑人取乐的表演，演员有意的拙劣模仿黑人，夸大黑人的身体特征来取乐。非洲人——不管是自由人还是奴隶——在各种表演中被肆意的丑化，甚至不被当人看，人们不遗余力地从各个角度证明‘黑人低人一等’。把这样的黑人形象与欧洲人放在一起以便突显欧洲人‘天生的优越感’。这种被丑化的黑人形象甚至在30年前的美国节目中仍能看到，比如1978年的黑白歌手秀。

![黑白照片](https://i.imgur.com/dQGLXXM.jpg)
![黑白照片2](https://i.imgur.com/k0RcjFC.gif)

### 猴子看，猴子做——中国只是在模仿美国的种族主义吗?

在详述这段历史时，我们还应该记住，种族主义显然不是中国的发明。虽然不能简单地说中国只是从西方学习了种族主义，但中国在历史上确实没有或者说很少有参与一些种族主义(或种族不敏感行为)的表现。

曾几何时，美国企业通过风靡一时的“黑人牙膏/Darlie”，把种族主义带到了中国的土地。这个牙膏在更名之前被称为“Darkie”。这个品牌在中国变得家喻户晓，而和它品牌拥有者，美国的高露洁公司却试图把自己的品牌与这个容易引发争议的“黑人牙膏”拉开距离。这个带有黑脸的牙膏标志无疑是从美国进口的。这个例子证明了西方是将种族主义带到中国的罪魁祸首。

但这个理由足以使中国将种族歧视的责任推卸的一干二净吗？

![黑人牙膏](https://i.imgur.com/5Axe105.jpg)

有人说，中国人对黑脸的历史背景缺少认识，对种族歧视的了解更是少之又少。因此，春节联欢晚会的小品不是种族歧视，也没有种族歧视的意图在里面。作者将在下文中分析这个小品背后的创作意图，但需要注意的是，种族歧视的发生不依赖于人的意图，而是人的行为对他人或某一群体是否产生了实际的影响。此外，无知不能成为种族歧视的挡箭牌或减轻种族歧视行为的实际影响。因此，无知不能成为种族歧视行为的辩护。

有人认为中国对种族歧视完全没有概念…但是一些事例使这种说法站不住脚。尽管中国没有长期被称为“黄脸”的历史，他们仍然对某些特定的“中国人形象”感到非常敏感，觉得受到冒犯。事实上，针对中国人的种族歧视，已经引起了一些中国人及海外华人的强烈反应。

### 如果受到类似待遇，中国人将有什么反应？

即使中国人不太了解黑脸的冒犯性，但别人不恰当地模仿中国人的身体或面部特征的做法，也常会引起大部分中国人的不满。

就在几个月前，网民们联合抵制维密天使吉吉•哈迪德，因为她眯起眼睛来模仿中国人的眼睛。甚至有传闻说在网民的讨伐下，她被从2017年上海的维密秀名单中除名了。

与此同时，亚马逊和易趣网在上个月晚些时候，因销售儿童服装时让模特做“斜眼”造型而受到指责。据说，这张图片已经在中国人中形成病毒式传播，有人觉得这张图片“完全不能接受”。

![亚马逊](https://i.imgur.com/lOJ3OTg.jpg)

别忘了在今年一月初，一所法国幼儿园在学校的一本书中收录了一篇题为“张，我的中国小伙伴”的诗，这首诗里有“张蹲下来吃米饭”、“他的眼睛很小，非常小”、“他的头像个乒乓球一样摇摆”这样的诗句。在微博上，中国网民发表言论称，“我们对诋毁民族尊严的言论零容忍”，“如果他们继续教育和传播这种仇恨和歧视，孩子们就不会健康地成长”。

![张](https://i.imgur.com/fZGPtdO.jpg)

这么看来，重点不是理不理解种族歧视的问题，而是，在不是针对自己的时候，一些人便不承认或不关心它的存在(或者对个别人来说，种族歧视满足了他们的心理)。

上面列举的三个例子中没有一个来自官方机构，也没有一件事有超过8亿人在同一时间目睹。然而，它们仍然被认为是冒犯了中国人，需要被除名、删图和公开致歉。

### 谁该对此事负责?

中国中央电视台(CCTV)是中国最权威的三家媒体之一，另外两家是中国国家广播电台和中国国际广播电台。而中央电视台是这三家中唯一的一家电视台。

中央电视台隶属于国家广电总局，受国务院监督。鉴于春晚对中国人民重要的文化意义，我们相信，春晚这五小时表演中的每个细节都经过了相关部门的审查。

除广电总局之外，中国四达时代传媒集团需要为这次事件负有最主要的责任。四达时代是非洲大陆领先的电视供应商，在非洲的30多个国家拥有1000多万用户。在这里我要对对相关权威机构没有意识到小品中的种族歧视元素的说辞指出一点漏洞，四达时代公司的高级管理层在与非洲大陆的国家做生意的过程中，一定对这片大路上的种族意识有更深刻的理解。他们为什么不直接指出小品中存在的问题?为什么他们明知道这个小品有种族歧视色彩还要花钱制作这个节目呢?

![四达时代](https://i.imgur.com/vdaWfXe.jpg)

### 黑人/非洲人演员共同参与

在中国，非洲学生的生活有时很艰难，为了追求“成功”，有些人愿意妥协，而忽视了其所作所为也应该考虑到他们所代表的群体。事实是，在这个小品里的大多数演员都是非洲人。舞者是非洲人，火车乘务员是肯尼亚人。一些主要人物也是非洲人，他们肯定比其他演员都更清楚这个小品中存在的种族歧视问题。作为非裔与非洲人群体，我们必须问，发生了什么?他们中有谁向制片人提出了他们的担忧吗?他们和大使馆联系了吗?或者，他们采取任何表达不满的行动了吗?在这次事件之后，我们也必须在我们的群体内部进行反思，非洲演员的表现和中方的制片人一样让我们不能接受。

### 这样做的目的是什么呢?

现在暂且把种族主义放在一边，让我们来分析一下，这个小品的创造意图。

从官方的角度来看，这个小品是为了表达中非之间的友谊，小品中提到的蒙巴萨和内罗毕之间的铁路建设项目就是证明。然而，也有一些不那么巧妙的线索，暗示了这段关系的本质——或者说，是中国希望它的人民看到中非关系。对于看了《战狼2》的人来说，这种叙事套路似乎相当眼熟。最终，中国成为了非洲的救星，非洲人变得依赖中国并且对中国感恩戴德。

有趣的是,当中国媒体推进以双赢为主导的叙事风格时，经常遭到西方媒体的批评，因为在这场交易中，非洲演员“赢得的”并没有中国多。小品<同喜同乐>完全摒弃了这种双赢的叙事。在这出戏中，中国是无私的捐助者，支持非洲的基础设施、教育和医疗。小品中没有提到中国获得的经济收益。往好听了说，这是对国际关系的片面描述，往难听了说，这个小品是在新年里贬低非洲人民，抬高中国观众。

### 我们现在该怎么办?

非洲人群体与非裔群体应该从这次事件中反思的一点是，我们要用更强有力地行动消除偏见。不光是消除偏见，而是要讲述我们自己的故事——准确地展现非裔群体的形象，这对我们的来说还有很长的路要走。感谢OPOPO、黑人在中国和Conscious Africans Network等群体，他们已经开始进行这方面的工作。

尽管事件已经发生，但我们仍希望能得到中央电视台的一个迟来的道歉。尽管比尔·考斯比(Bill Cosby)有一些个人作风问题，但是为了确保自己的节目《科斯比秀》中不会出现对黑人的负面刻板印象，他从哈佛大学聘请了一位非裔美国精神病学教授，对每一集《科斯比秀》都进行了检查。中央电视台应该考虑采取类似的行动。非洲人和非裔群体现在需要的是一个保证此类事件不会再发生的明确表态。

我们不应在让中非关系的议题中被当做棋子来利用。随着我们进入地缘政治的新时代，我们必须时刻保持警惕，捍卫我们所热爱的大陆。有一些掌握主流话语权的团体，利用中非关系发展过程中出现的摩擦，煽风点火，企图从中渔利。自春晚播出以来，一些西方媒体纷纷抓住这个机会，用他们准备好的说辞解释这次事件。非洲需要将自己从这些团体的干预中隔离开来，并将重点放在与中国建立互惠互利的关系上。

归根结底，我们要用我们的行动来推动我们的目标。这样我们也会修正人们对非洲人和非裔群体的歪曲。为了做到这一点，我们必须清楚我们要做什么，以及我们打算如何做。在这起事件发生后，让我们问自己一个问题:我们希望看到中国媒体采取哪些具体行动，以确保不传播带有种族歧视色彩的内容?

Black Lives China呼吁中央电视台和中国其他媒体机构中添加非裔媒体高级顾问这样的角色。这些顾问负责制作一些节目来向观众介绍与非洲人和非裔群体相关的一些种族歧视的表现。中国必须对种族歧视充满警觉，对媒体制作的节目中可能出现的种族主义要更加敏感。考斯比秀能在整个八季中坚持这一原则，中国也能。
