---
layout: post
title: 疫情之下，诸众联合的新可能性：在市场–国家的对立之外，我们还应看到什么？
categories: Archive
tags: 新冠肺炎
image_feature: "https://i.loli.net/2020/02/22/l5fPZXOG19Uwn4M.jpg"
date: 2020-02-21
description: "本文原标题为《疫情之下，我们需要另一种声音》，非 Philosophia 哲学社原创、转载自公众号「互啄的日常」（已被删，链接为备份）；总计约一万两千字。本文可视作对我社前一段时间发布的《结构性反思》的补充阅读乃至回应和批判，强烈建议各位读者阅读并存档。"
---

原文来自「疫情之下，诸众联合的新可能性：在市场–国家的对立之外，我们还应看到什么？](http://206.189.252.32:8088/)~~

普声 Philosophia 哲学社 今天

---

![](https://i.loli.net/2020/02/22/l5fPZXOG19Uwn4M.jpg)

本文原标题为《疫情之下，我们需要另一种声音》，非 Philosophia 哲学社原创、转载自公众号「互啄的日常」（已被删，链接为备份）；总计约一万两千字。本文可视作对我社前一段时间发布的《结构性反思》的补充阅读乃至回应和批判，强烈建议各位读者阅读并存档。

### 从「健康的社会 不能只有一种声音」谈起

距 2 月 7 日李文亮医生感染新冠肺炎去世已有数日，他的离世令人扼腕痛心，但我们仍然需要面对他远去的背影带来的巨大质问。李医生病逝消息发布当晚，围绕其人其事的哀思和反思在互联网上形成了巨大声浪，这不仅因为一位一线医护工作者的离去让人揪心，更是因为李医生在此次新冠肺炎疫情中的特殊身份：最早向身边人发出医学警报的医生之一，因发出警报而被当地警方惩戒的所谓「武汉八君子」之一。舆情迅猛，官方反应亦不算含糊：各级相关部门向李医生哀悼、致敬，当地迅速为李医生完成工伤认定……

「事后」的迅速反应，反衬出「事前」的迟滞。如果各级部门在应对疫情时有足够警惕、足够效率，在疫情爆发初期迅速采取有力措施，全国人民此刻的生产生活状态都会是另一副模样。讽刺的是，当地不但反应迟缓，没有及时核实并公开信息，反而以造谣为名处罚了「吹哨人」，这不但充分显示出我国的公共应急管理体系存在结构性障碍，而且凸显出以官方口径为「事实」准绳的媒介报道现状。李文亮事件揭示了这一现状的不合理性：对真相的每一次隐瞒和迟报都会在被公众发现后成为政府公信力的毒药，成为「官方媒体」的伤疤。

![](https://i.loli.net/2020/02/22/9RT5Mjw76lzOvVp.jpg)

<figcaption>李文亮（1985-2020），男，武汉市中心医院眼科医生。在新冠肺炎疫情工作中感染，经全力抢救无效，于2020年2月7日凌晨2点58分去世。</figcaption>

因此，对该事件的反思走向了这样的表达：「我们需要保护调查记者，需要完善的新闻法，需要的是真正能行使监督权、与公权力抗衡的媒体，才能从结构上确保信息不受垄断。」（此论述出自我社文章）一方面，这种意见似乎毋庸置疑地处在李文亮医生「遗愿」的延长线上，因为他在感染后接受采访时曾经表示「健康的社会不能只有一种声音」；另一方面，由于人们普遍把李医生的个人悲剧当作本次疫情中官方消息缺位问题的缩影，这种呼吁「新媒体」的意见便似乎合情合理地成为了反思李文亮事件的重要成果。

我们应当充分肯定此次疫情中社会力量和社会声音的作用，他们越来越成为信息传递的可信桥梁，并在官方媒体效度受到广泛质疑的时刻越来越成为一种看似与之对位的势力，承担重要的社会监督职能。然而，抽象谈论「官方」和「非官方」的对位，以为存在一种独立于国家机器的社会政治实体，同时又将国家机器想象为有着一致利益与协调行动的「一块铁板」，可能是李文亮事件后最大的幻象。厌倦官方空谈的人们转向「非官方媒体」，期待它们发挥制衡作用，愿望虽美，但或许实属一厢情愿。其根本原因在于，对所谓「非官方媒体」的根源和运行逻辑缺乏必要的再反思。在这一层面上进行再反思后，我们才得以发现：当下看似「对位」的声音，实则共享相同的结构；看似扰攘喧哗各得其所，实则缺少了一种幽灵的声音。本文接下来的部分，便希望展开上述论点，让无形的幽灵发出自己的声响。

### 疫情下的中国，后末世还是市场进行时?

2月3日，斯洛文尼亚哲学家齐泽克发表了一篇评论，[1] 文中将武汉「空荡荡的街道」描述为「现实版后末世电影」(a real-life, post-apocalyptic movie set) 与「非消费主义世界图景 (a non-consumerist world)」。齐泽克虽正确表达了对中国受疫情危害人民的支援与对西方国家种族主义防疫政策的抨击，但对处于非常时期的武汉所做的描述则须另当别论。若对武汉的新闻稍加关注，就会发现防疫的现实压力虽然悬置了相当一部分市民的日常生活，但远没有悬置市场的运作。

实际上，现在武汉的街道虽然称不上热闹，但也不是绝对的「空荡荡」。在财新博客的一篇文章所公布的调查数据指出，现在在武汉有 11.46% 的人仍然在坚持工作[2]，但对这些人的职业没有提及。可以想见，这些人中自然有在官方媒体中广受赞扬的医务人员，也有为了保证城市公共服务而坚持工作的水厂电厂、公务警务人员。除了这些人之外，坚持工作的 11.46% 中也一定少不了快递和外卖的送货员。尽管目前没有媒体报道还在武汉市内工作的物流从业者的总人数，但根据饿了么平台的统计，2 月以来平台送货员单日的跑腿距离总和是过去的三倍多 [3]，大量市民出于隔离或避免暴露风险的考虑更多使用外卖送货，但是这就增加了送货员自身的暴露风险，很难想象这些送货员在卫生用品奇缺的武汉能获得充分的防护。

![](https://i.loli.net/2020/02/22/xTphPDV1ALqulg8.jpg)

<figcaption>正在消毒的配送员，图片来源网络。</figcaption>

随着疫情日益严峻，武汉几乎关闭了所有小型社区型的菜店或小超市，以便集中供应武商、中百等大型超市。于是，超市成了武汉人流量最大的地方，出门采购也常被描述为「像打仗一样」。据武汉滴滴医疗队志愿者曹先生所说，「超市十点开门，十点半货架就空了，进超市就要排一个半小时。」[4] 而 G-Super 武商区绿地缤纷城店的店长李惠洁也表示，「每天开门两个小时，肉就抢完了。现在大家不是按需购买，有些顾客一次买肉的量就是十几盒。」[5] 因此，与其说看起来「空荡荡的街道」呈现的是「非消费主义图景」，不如说正是前者掩盖了大型超市里人们或是出于恐慌心理的消费狂热。

与超市互为补充的，是2月以来武汉组织营业的露天马路市场，截至10日中午已开放了14个市场。[6] 将目光投远，可以发现在全国范围内，虽然线下零售业遭受了巨大损失，但网络电商的同比销售总额却再创历史新高；尤其是每日优鲜、盒马鲜生、叮咚买菜等配套有网购与送货服务的「新零售平台」，订单出现爆发式增长。数据显示，叮咚买菜近来每日新增用户多达4万人，每日优鲜的交易额在春节期间实现 3-4 倍的增长，京东到家在除夕至正月初三期间，全平台销售额同比去年春节增长 540%。[7] 可以预见的是，这些在大资本把持下的「新零售平台」，一定也能利用疫情逼迫抗风险能力低下的个体小商户破产的机会大肆扩张，在未来的零售行业中占据更多的市场。

![](https://i.loli.net/2020/02/22/azIuG8lt6xHRjFW.jpg)

<figcaption>戴口罩排队的超市顾客，图片来源网络。</figcaption>

同时不可忽视的是，虽然充满了「战时动员」的意味，但这些社会必需服务仍然是依托劳动力市场在雇佣劳动的框架内提供的。同样，也没有官方与社会媒体关心这些工人是否获得了公正的薪酬：虽然人社部已于7号印发了《国家协调劳动关系三方就做好新型冠状病毒感染肺炎疫情防控期间稳定劳动关系支持企业复工复产印发意见》，但许多企业陆续复工，有关《意见》落实情况的报道却很难找到。

市场在这一特殊时期非但没有停摆，反而借由其他方面的纷纷悬置格外凸显其重要性。正如有些疑惑的市民所表达的那样，「就算再囤，一家总会有需要一个人出门采购生活用品和食品的，为什么还不由各大超市划区分配物资进各小区？」可见在疫情期间，仍旧是市场这只「看不见的手」将厂家和人员配合在一起，组织起了庞大的消费系统。在生活必需品和医疗用品严重「供不应求」情况下的抢购狂潮，恰恰说明了在疫情之下市场逻辑不但没被摒弃，反而得到凸显。物资分配高度依赖于市场，哪怕是辽宁省与山东省支援武汉的蔬菜，首先也不免通过市场机制来进行分配，尽管大量人员集中到少数市场中抢购商品有让其他防疫举措付之东流的风险，但除此之外的某种更高效、全面、公平的分配机制似乎已经无法被想象，或者被认为无需想象。

现实的疫情威胁带来了停滞的愿望，然而与消费一样无视这种停滞要求的还是资本主义生产方式下的生产活动。江苏南通通州区一纺织厂在2月1日提前复工，随后被当地政府叫停，老板被拘留，这也是全国首个因提前复工被行政拘留的案例。但并不是所有急着节后复工的企业都未能如愿以偿，据新浪美股报道，华为已于2月1日恢复了包括消费产品和运营商设备在内的产品生产，而其相关生产部门所处的广东省则要求2月10日才复工。此外也有一些互联网公司不甘寂寞，早已以线上工作的方式进行复工。在疫情压力仍旧不减的情况下，自2月10日起韵达、百世、中通等快递公司陆续复工，而此前早已有部分物流公司复工，京东、顺丰等物流甚至一直正常运营。

![](https://i.loli.net/2020/02/22/ECv91jiBn6OZAXN.jpg)

除了重新启动生产流程，一些企业还公开招募「志愿者」作为有益的补充。如松江口罩厂曾于公众号上公开招募志愿者（该推送已删除），在提供方便面为宵夜的情况下，欢迎各志愿者参与无偿劳动。许多口罩厂和医疗物资生产商都提供了这种良好的机会，有的志愿者表示，看到自己参与生产出来的上万只口罩立马打包发往客户，觉得仿佛为抗疫前线尽了一份力，心中踏实了许多。一些新闻媒体对此均有相关报道，只是报道中并没有谈及这些由志愿者无偿劳动生产出的口罩是否也会无偿地提供给防疫治疗的一线工作人员。

不单是一些大企业、大厂，地方上的中小型超市、药店、餐饮业、服务业等也陆续有返工的情况。据发改委表示，全国口罩企业复工率于 2 月 11 日已达到 76%。农业部则表示，全国饲料企业复工率已经达到 50% 以上，广东、山东、湖南饲料等大省开工率已达到 70% 以上，一些大型集团化企业达到 90% 以上 [8]。据58部落的调研结果，截至2月5日，参与调查的人群中外卖员和司机等行业，复工比例超过50%，售货员、保安的复工率分别为 54% 和 63%。可以说，在一段时间的延期与隔离后，一股大而全面的返工潮流将势不可挡。

![](https://i.loli.net/2020/02/22/uvTHxmZ7fj352t1.jpg)

<figcaption>图为口罩厂生产线，图片来源网络。</figcaption>

尽管有关部门曾表示，关乎防疫等重要方面的企业可以提前进入生产，在资本主义大返工中最急着开工的企业却并不都是生产防疫用品相关的（比如华为）。哪怕是防疫相关厂，此时也出现浑水摸鱼的行为，像口罩厂的免费劳动力空降兵，他们的生产能达到怎样的技术指标、作业规范、产品质量和收益水平，不能不让人多想几分。「防疫」作为一个理由并不能无限延伸、扩展以解释当前的生产高潮，同时与防疫的相关度也并不能真正解释这些生产单位对于复工乃至以各种方式推进生产的急切态度。这也正是最令人费解之处。

尽管「支援防疫」是一个很好的旗号，但在这一旗号下急于生产的企业却未必真是为了支援防疫：这并非一种阴谋论。事实上，无论何种情况下，一个资本主义企业应做且不得不做的事情只有赚取利润，否则就是其自身的消亡，生产与销售不过是通往利润的中间环节罢了——这也是对华为等企业急于复工根本的解释，也是唯一的解释。诡异之处在于，这种单方面对利润的渴望甚至与迫切的防疫需求产生了张力，当许多复工返京的人因租住小区的防疫工作而被拒之门外时，这一张力显现的再分明不过。而不仅社会媒体对这种情况不事声张，连一些地方政府也多少予以配合，力求恢复生产。虽然任何人都知道开工导致的人员流动与聚集存在着传播病原的风险，也不难想到整个从生产到消费的链条里将增加无数病毒流通的机会，「生产」「开工」这些字眼背后却有一种危险的魔力，吸引各大企业趋之若鹜。资本逻辑与疫情防控之间的张力，正是一个根本矛盾的表现。

### “积累啊，积累啊! 这就是摩西和先知们 !”

正是在社会的生产领域，我们发现了与官方的科层制官僚与非官方的社会媒体间的对立完全不同的另一组对立：一边是生物-医学层面上完全现实的阻止疾病传播的欲望，另一边则是政治经济学层面上同样现实的资本积累的狂热。防疫的现实要求尽可避免人员的流动与聚集，而后一种现实则要求人口与商品跟随资本的指挥棒在外围与中心之间不停穿梭，以求得资本最大的积累效率。前一种现实要求的是停滞的时间节奏，而后一种现实则要求加速流动的时间节奏。

在资本的现实之中一切都可以停下，唯独市场不可以停下，这也就意味着唯有包括劳动力商品在内的商品交换无法终止，它深深渗透在生活之中。即便是在当前这样的情况下，以赚取利润为导向的资本逻辑依旧坚定地充当着社会的基盘。这无关于生产者的主观意愿在道德上持有怎样的态度，资本逻辑下的一切生产方式都必须通过盈利来维持自身的存在，以市场来达成主观上的目的。而市场的存在总是向资本展现出盈利的空间，这既是所谓「发国难财」之人的行为动机，也是急于复工的企业的生产动力。谁能在这个特殊的时期抢占市场，投放产品，谁就可能抓住机遇。而作为同一硬币的另一面，无法在这一特殊时期进入市场的生产者，则纷纷告急，大哭破产。资本逻辑对社会生产的决定性把握、其主导的市场竞争的丛林状态、社会维系对其的依赖，在此一览无余。或许一些有关无关的企业的确是抱着实业救国的心态早早投入了生产，然而荒谬的是，其越是以强力的姿态投入生产，就越是制造现实疫情防治的对立面。

![](https://i.loli.net/2020/02/22/MPkZRp5DX3V6dYv.jpg)

<figcaption>两种逻辑对人的拉扯与撕裂，图片来源网络。</figcaption>

跟随着这种荒诞的悖论，我们看到了急迫的防疫运动之下的现实被两种相互矛盾的逻辑所撕裂，如果我们违背了一种就要面临失去性命的威胁，而违背了另一种则要面临利润下降，投资减少、经济活动萧条、生产与交换停滞的威胁。对于有血有肉的真实生命来说，显然前一种威胁更加恐怖，但对于在资本积累的世界中患得患失的「经济人」来说，生命未必一文不值，却也是可以标价计量的「风险成本」，可以在得利的巨大诱惑前择机抛弃。

因此，瘟疫的降临暴露了一个被小心遮掩的事实，即：我们脚下仿佛坚实的社会现实并不是单一逻辑一以贯之的完整大地，而是在自然的逻辑与政治经济学逻辑的撕扯下支离破碎的动荡板块。我们通常无法察觉这种分裂只是因为资本的现实已经通过它野蛮的商品化进程将自身的外部吞入内部，将全部生命、自然与一切「神圣情感的发作」通通「淹没在利己打算的冰水之中」：资本已经将自身伪装成社会成员必须共享的唯一至上原则。正如马克思在《资本论》中所冷嘲热讽的那样「积累啊，积累啊！这就是摩西和先知们！」而此次新冠肺炎所造成的大规模疫情的特殊之处就在于，它通过生物-医学威胁站在了自然现实的一方，以资本现实毫无准备的严厉姿态站到了社会面前，打破了资本逻辑实施单一宰制的幻梦，提示着社会与资本，它们永远是只能在自然之内而不是自然之上放置自身的位置。但是就像我们在前面所看到的那样，资本的逻辑不会轻易地退场，反而急于重整旗鼓，试图再次将自然危机的爆发纳入内部，继续自身的统治。于是对于社会中的一切组织、团体甚至个人来说，他们的命运就只能被自然与资本的对立所贯穿，不得不被相悖的两股力量反复拉扯。

而当我们重新考虑官方与非官方，或者说是国家科层制官僚与市民社会的对立时，仍然将不得不把自然逻辑与资本逻辑的对立纳入考量。而结果则是前一组对立就在我们的眼皮底下如太阳下的积雪一样缓缓融化了。这里需要回到的是马克思的分析：现在国家与法已经被市民社会的逻辑死死钳制；然而与自由主义者的分析不同，这里的市民社会不是独立媒体与结社，而是资本主义生产方式与市场商品经济。这样一种在社会之中历史性地形成的现实生产方式，成为了制约在人类一切社会活动的绕不开的幽灵。

![](https://i.loli.net/2020/02/22/5XAsT2CSkJ8ozV1.jpg)
<figcaption>“一个幽灵，一个...的幽灵...”</figcaption>

具体来说，这个互相对抗机制的落脚点正是现实的雇佣劳动力，即无产阶级。在疫情的逻辑下，每一个受雇佣者都是潜在的病毒携带者与病毒受害者，因此必须要减少聚集，依托延缓复工、分流上下班等各类措施降低病毒传播的风险；在资本的逻辑下，每一个雇佣劳动力都是利润的来源，因为剩余价值的获取能且只能来源于雇佣劳动力的剩余劳动，所以必须要尽快复工以维持企业的运转。春节结束后的受到节制的返工潮流和中小企业纷纷支持不住的消息，都证明了劳动力而非供给关系影响了企业的运转。

拿西贝莜面村为例，该企业支持不住的消息闹的沸沸扬扬之后，盒马鲜生依靠自身生产方式将无法在餐厅上工的劳动力转移到自己手中，并和原餐饮企业签订协议保证企业度过困境。在这个过程中，变化的只是生产模式，而不变的是劳动力的上岗工作，它减缓了所谓现金流的压力，实际上只是产生的劳动价值能够超过工资价值罢了。

![](https://i.loli.net/2020/02/22/P7tUwhOoxEkI8Hg.jpg)

当然，「共享员工」的模式必然不能长久，这个模式本身还忽视了劳动力的流动问题。病毒的流通是自然的客观现实，劳动力流动却是社会的客观现实。进一步来说，雇佣劳动力及其流动只能是当社会由历史性形成的生产方式和社会集团支配时才会产生的冲突焦点。就形式上来说表现为雇佣劳动制度，就内容上来说表现为一方是掌握了资本的社会集团，另一方是除了自己劳动力之外一无所有的被雇佣者。在这个背景下，流动便是劳动力的必然属性，但是这个流动并非自由流动，而是在资本统治下的具有明确方向性的流动。如果我们简单考察一下春节后的返城浪潮就足以认识到这一点：那个躲在汽车后备箱的外乡人，全然不是什么自由流动的人，而正是被资本指挥流动的雇佣劳动力。

![](https://i.loli.net/2020/02/22/lHizpx7TK43sBPu.jpg)

<figcaption>图为复工返程的人群，图片来源网络。</figcaption>

而在官僚系统方面，如同我们前面所看到的那样，在这个过程中并不直接代表某种逻辑，而是在两类社会现实之间疲于奔命。有人或许会质问，人总是要吃饭的，如果不安排复工和劳动，饿死就变成了现实的问题。但是正如上文提到的，为什么我们今天的复工必须是按照如此强制的浪潮完成的？为什么人们为了复工不惜躲入后备箱？只有在特定的生产关系下经济生产才具有如此巨大的地域特征。同时正是这种生产关系，在使得经济飞速增长的同时，也使得资本越来越多地集中到了北上广深等经济中心周围，更使得劳动报酬占中国国内生产总值比重在二十余年间连续下降，而这种极大的地域与阶级的不平衡发展是官僚系统没有也不愿去加以处理的。

市民社会内在维系市场经济的倾向早为科层制官僚打上了烙印。不仅仅是科层制官僚正常的评价体系中就重点评价「发展经济」的能力；在这次的防疫行动中，科层制官僚也无法脱离资本与市场行动，更是不得不牺牲防疫而满足资本对利益的需求。官僚系统的防疫行动仍然要依托于基本的市场资源配置，所有物资的调动遵循着市场的逻辑而不是动员的逻辑。一月底开始，上海松江、金山、奉贤等地的口罩厂开始招募「工厂志愿者」以应对劳动力不足的情况，根据报道志愿者一时间大量涌入，机器达到了 24 小时不间断运作的状态。这其中虽然政府采用了「统一买断」和部分超经济行为（例如海关、高速公路拦截征用），但是工厂仍然掌握在私人手中，政府是以市场方法购得口罩的；而反过来虽然工厂采取的也是超经济行为（没有工资的非熟练劳动力），但是这种超经济行为只会更好地提升其利润水平。

![](https://i.loli.net/2020/02/22/5MSmp2CJAv9wgdV.jpg)

然而与其他一切的社会实体一样，科层制官僚体系在这次疫情危机前，同样被自然与资本的对立无情地分裂、并做出了一系列自相矛盾的动作。一方面，官方在居民社区做出大量的防疫努力，但另一方面，随着政府开始允许各地企业分批复工，返工人员则开始无视防疫需要进行高风险的流动聚集。不仅如此，正如前面所展示的新闻所表明的那样，在分批复工问题上，官方立场也常常是厚此薄彼，越是与全球生产链条深度整合，越是能为社会提供大量就业，越能保证税收与经济增长的企业，就越可能在提前复工上得到政府开出的「绿灯」。就连国际组织也不得不参与进这种荒唐的自我分裂，世界卫生组织的官员一方面称赞中国所做出的包括隔离在内的果断防疫行动，另一方面却在恳求其他国家不要对中国设置旅行限制，在其背后维护世界市场中自由商贸活动的意图不言而喻。

![](https://i.loli.net/2020/02/22/BENPIlW9qHRrdGf.jpg)

在这个层面上，我们可以理解为什么自由主义者会得出官僚与媒体相互制衡的结论，而不是提出两者中一方最终会战胜另一方。因为事实上两者脚下都踩着资本与市场的基石，双方都无力将其踢开。在共同维护资本与市场的利益方面，两者恰不是对抗而是合谋与相互补充的。不能忘记的是，当代因独断专行而丢尽颜面的这个官僚制，很大程度上是在后革命的市场改革中得到强化的。它不是凌驾在「市民社会」之上与之对立，而是「市民社会」中「工厂政体」的庞大翻版。如果说「工厂政体」的目的在于超越一切限制，根据资本自身的要求精确控制原料、生产资料以及劳动力的运动，以镇压性的手段保证无产阶级与生产资料的顺利结合——那国家官僚机构的职能，也不过就是以发展主义的名义在社会整体层面，同时在生产与再生产方面保证同样过程的正常进行，继续不平衡不平等的发展。如果国家官僚机构与市民社会之间的关系表现为对抗性的，那也只不过因为这个市民社会本身就是对抗性的社会，市民社会最终从国家官僚那里收回了自身的真理。在这个层面上，工厂政体与国家官僚试图超越并非只有单纯的自然限制，更有无产阶级对资本主义生产方式的此起彼伏的反抗。

早在自然灾害的介入之前，社会与国家就都已经是镇压与斗争的场所，是统治阶级推行霸权与被统治阶级反抗霸权的战场，而不是贯彻某种单一理念的完整机械实体。无论是「意识形态功能」还是「镇压功能」，它们作为「机器」的一面在于「拼接装配」而不在于「理性设计」。资本与不得不向资本妥协的国家官僚系统所试图政府的对象，不仅仅是自然力量通过瘟疫的爆发，也有为了在瘟疫下保全生命而试图逃离工厂与大城市的劳动者，此时自然就是一种对劳动者的隐喻，他们同样有待于被权力与资本的力量所征服。

当前防疫行动下浮出水面的种种悖论，是资本主义生产方式所制造的多重矛盾交织汇合的结果，而这些悖论最终也只能在多重矛盾的对抗爆发中寻找到突围的可能。

### 再论自发性

通过前面的论述，我们能够理解市场是如何在无视疫情的冲动下运作，而官方又如何不得不被市场与资本的要求胁迫，骑虎难下。似乎社会中不再有可靠的力量能够对抗疫情的威胁。但这样的图景显然过于悲观，因为在市场与官僚的力量之外，我们仍然能够寻找到无数挺身而出对抗疫情的「防疫主体」：接下来我们需要将分析的焦点转向他们，来寻找一种与众不同的社会建设性力量。

首当其冲的，是始终坚守一线的医护人员。吹哨后的虚假宁静被打破之后，医护人员率先被动员起来应对疫情，高危环境、物资匮乏，医护人员作出了巨大的贡献和牺牲，中国的医生本就是日常高负荷运转的群体，疫情之下，身体疲惫自不用提，高负荷工作之外，被感染的恐慌以及自身在某种情况下成为需要被隔离的「武汉人」失望也带给他们异常的精神压力，在此等前提之下始终坚守岗位的医护人员无疑是当仁不让的防疫主体。而当我们将目光重新转回市民社会中去、就能看到，在物资筹措与运输过程中，市民与网络志愿者使我们看到了自组织的庞大能量。

在武汉官方下令封城之后，官僚体制一刀切逻辑所引发的公共交通停转为疫情防治制造出新的难题，出租车拒载与停运使得一些奔波一线的医护人员甚至需要徒步往返。此时，武汉街头涌现出一批自发组织起来为武汉市的医务工作者们提供后援支持的「摆渡人」[9]，自发组织起来接送医护人员 [10]。在疫情公布后，武汉各大医院发布医疗物资告急信息，社会各类民间组织与个人纷纷通过各种渠道为武汉防疫募集物资，并且有众多货车司机挺身而出志愿为诸多医院输送应急物资 [11]，还有为医护人员提供住宿 [12]，还有无数的私人募捐，此类事迹不胜枚举。

![](https://i.loli.net/2020/02/22/tu9gZbmcpFLQVSE.jpg)

<figcaption>运送物资的车队，图片来源网络。</figcaption>

当然还有一些无法被看见的人，比如环卫工，比如外卖小哥，比如快递员：城市的运转不能离开他们，但是可以选择忘记。当全国人民响应国家「宅居」政策之后，大量的生活垃圾不会被龙卷风带走，下单采购的生活用品不会从商店穿越到家里，人们也不会因为疫情而放弃快递小哥的电话：离开了他们的劳动，「宅」何以实现？

而仅就环卫工这一群体而言，他们毫无疑问是全民防疫战中的一线工作者，但主流媒体的报道寥寥无几。在不少自媒体的调研文章中，我们看到绝不在少数的环卫公司不仅没有发放达标的口罩 [13]，甚至还加紧了对环卫工人流于形式的监督，环卫工人不得不在没有有效防护措施的前提下劳动 [14]，主流媒体与市场的合谋再次显露。

事实上，对底层劳动者的忽视由来已久。在这次疫情中，各类自媒体对于底层劳动者群体的深入报道、早已映照出主流媒体在面对底层劳动者时的失语与话术的单一。在见诸各媒体报道中的零星的片段里，工人们永远被塑造为一种受奉献精神感召而活跃的群体。主流媒体既要呈现众志成城，集体抗疫的景象，又要小心翼翼避免触及底层劳动者恶劣的工作条件以免引起公众的不适和担忧。尤其是在报道医护人员这一备受瞩目的群体时，媒体更是要格外凸显他们的任劳任怨与无私奉献(护士作为医院的基层劳动者，始终未在媒体与公众领域取得独立形象)，而被媒体的高光掩盖住的真实却是超额劳动与紧张的工作节奏，这些易为人知的内容就和底层劳动者的无言劳动一样被媒体与公众有意无意的忽视了。

![](https://i.loli.net/2020/02/22/NiRKXFJpHu3BVTG.jpg)

<figcaption>图为使用棉布口罩的环卫工，图片来源网络。</figcaption>

公众和媒体的这种忽视并不是毫无缘由的，审查机制或可作为一种理由在此提出。无论是自媒体还是主流媒体，均要受到审查机制的钳制。其差异在于，国家审查机制内嵌于主流媒体之中，对自媒体而言，审查机制效力稍弱且具有后发性，网友们从主流媒体获取的疫情资讯往往是国家审查制度自律之后的结果，而来自自媒体的资讯也会由于内容真实性、热度与敏感度受到审查机制 404 的关心。同时，自媒体平台也拥有自己的审查机制，自媒体平台为维护自身利益而对审查制度的贯彻比起主流媒体也是不遑多让，市场与国家合谋，从传播内容到传播渠道，都对网友们对资讯的获取联手做出了限定。

在这次行动中，群众高涨的自发性可圈可点，却也由于组织力度有限存在着不少问题。我们可以看到，自发性力量难以在大范围内对物资进行调配和使用，不少自发力量在防疫过程中缺乏组织经验，很快便销声匿迹难以存续，如果说我们要在一场事件中持久发挥作用，那么增强我们自己的组织力度是必不可少的一环。群众自发筹集物资，组织交通队伍，奔波劳碌，坚守岗位的形象已深入人心，但在全国防疫战中涌现出的地方保护主义也必须予以批判，在各地，武汉人仿佛成了病毒的化身，闻之则骂，见之喊打，人人自危，狭隘之心暴露无遗。与此同时，各地跟风封城的举措不仅加重了人们恐慌情绪的蔓延，同时为支援物资的运输制造了阻碍[15]，不仅有医护人员下车清理路障的事情发生，还有残疾儿童鄢成在隔离中由于照顾不周死亡的事例 [16]，封城封路，网友们的援助始终未能抵达最后一公里。盲目的自发性是任何群体都必须加以防范的东西。

![](https://i.loli.net/2020/02/22/rgLsVFZf4byKetj.jpg)

不过在除了简单地赞美或是批评群众的自发行动，我们仍然需要谈一谈自发性力量困境的社会历史背景究竟是什么。归根结底，这次疫情中的自发性力量 / 自组织是作为公共服务的补充而出现的，公共服务的缺失使得自组织成为防疫行动中不可或缺的一部分。伴随着全球新自由主义背景下中国特色政治的形成，中国的社会公共服务开始逐步市场化，随之而来的一个恶果便是公共服务的不均衡与缺失。当公共服务顺应资本的逻辑运转，随着经济的分化加之资本的逐利本性，公共服务资源就会不断向着经济中心集聚，城乡与地域之间的公共服务差异日益两极分化，经济水平鸿沟对位医疗资源鸿沟。

这类问题在此次疫情中有不同程度地显现，黄冈市作为湖北省人口第二多、打工人口第一多的城市，成为武汉之外的疫情重灾区。在早期救治中，黄冈市因无力确诊最后一道病原学检测，检测验能力不足造成大量疑似病例无法确诊，防护物资始终紧缺。类似的情况还有很多，中国许许多多二三线城市的医院在疫情肇始均陷入口罩、防护服等必备医疗物资紧缺的困境，许多城市甚至没有满足收治条件的医院。而在满足收支条件的一线城市医院也由于床位爆满开始纷纷被迫通过各种手段减缓收治，不在少数的患者只能在家中自行隔离，许多家庭被集体感染的风险陡然上升却束手无策。某种意义上，地方群众的无论是有益的还是有害的自发行动，都是对这种医疗资源不平衡配置的合理反应：中小城市与村镇的医疗资源缺乏破坏了居民控制疫情的信心，以至于做出过激举动，封闭进出道路，在社区中组织仅有的微薄力量进行防疫工作。

![](https://i.loli.net/2020/02/22/JbVfDPSO2Ny39Bg.jpg)

一场疫情在此揭起了中国医疗卫生事业的遮羞布。九十年代以后，医疗卫生事业被推向市场，政府在卫生总费用中的支出节节下降，截至03年非典之前一直如此。2003 年，中国医疗总费用占 GDP 的 5.6%，其中政府负担 17%；相比之下，欧洲发达国家医疗费用占 GDP 的 10%，其中政府负担 80~90%。居民个人负担越来越重，看病贵看病难早已成为许多人的普遍感受，只要我们看一看世界上其他国家卫生总费用中的政府支出占比就会明白，美国是世界上医疗高度市场化的国家，政府支出也占到卫生总支出的 45.6%，更不必提许多国家实行的免费医疗制度了。

大多数发达市场经济国家仍旧避免让市场力量支配医疗卫生领域，莆田系医院以及各种天价药的存在足以让我们看到市场在在医疗卫生领域的失灵。非典之后，政府在公共卫生领域的缺位饱受诟病，医疗总费用中政府支出占比出现回升，截至 2012 达到 30%，而根据18年数据，政府支出占比达到 28.3%，我们不难看出，即使在情况有所改善的今天，中国医疗的市场化程度在世界范围内仍是首屈一指，可惜这并不是什么值得夸耀的事。

![](https://i.loli.net/2020/02/22/hCRU64IYdAzyfBe.jpg)

![](https://i.loli.net/2020/02/22/lF8PVvsdJtiukxO.jpg)

80 年代之后，中国医疗卫生工作的重点从农村移向城市、从「重预防」移向「重医疗」，从低成本移向高科技-高成本。虽然政府口头上仍强调「预防第一」，但实际上，城市的医疗才是第一 [17]。长期的城乡二元结构使得卫生费用的 60%~80% 集中于城市，同时医院将大量的资金用于购置设备，从而减少了用于其他方面的资金，开展疾病预防、检测等所需的经费总是很紧张，防疫部门没有足够的财政拨款，无力购置新的检疫设备，在中西部广大农村情况更是如此。而这，正式检疫设备、防疫物资欠缺的问题在这次疫情中格外凸显的一个重要原因。

仅仅罗列疫情最为严重的武汉省的状况，就可以清楚地理解现有的医疗资源分配状况是何其不均。列出的七个城市里除武汉外的六个城市户籍人口均高于常驻人口，这意味着平时劳动力从这些城市向外流动，因此在平日里边缘城市的医疗压力相对较小，但春节期间由于返乡压力便会增大；另一方面疫情使得人群不得不固定在自己的城市，这种医疗资源，尤其是定点医院的不足就更为明显。

![](https://i.loli.net/2020/02/22/slOQfUgo57iPpVJ.jpg)

而当定点医院床位不足时，为其买单的只能是个人与社区。众所周知，中国的社区医院一直处于门可罗雀，「叫好不叫座」的尴尬境地。缺人、缺钱、缺资源，感冒发烧可以，防治新冠病毒绝无可能。「分级诊疗」启动后，社区成为了防疫一线，一个社区住户数千，社区工作者却只有寥寥数十人，工作人员往往超负荷工作，防护物资短缺带来的感染风险更不用提。封城之后，社区基层开始承担交通、物资运输等各种职能，工作者们还要定期排查住户发热情况，成为个人与医院的中介者。社区没有能力满足居民的医疗需求，患者与医院的矛盾被转嫁到社区工作者身上，社区基础服务的供需冲突藉此被放大数倍，这并不是社区工作者们 996 就能解决的问题 [18]。

因此，如何评价群众自发防疫行动的功过是非，就同样不是一个抽象的问题：因为群众也只能在一个不平衡发展的市场化环境中展开自身的行动。然而群众自发性力量与国家力量的区别在于，群众中的一部分能够提出超越市场逻辑的需求，也能够开展超越市场逻辑的行动。这不是因为他们代表着某种天然的道德与正义，而是因为在市场之中找不到他们的利益，同时市场却不得不依靠他们的劳动来延续资本积累的狂热之舞。虽然在当代，这些人的声音在种种力量的围追堵截下已经难以听闻，他们的名字对当代纷繁庞杂的言说也已经显得十分陌生，但重点不仅仅在于取回他们的声音与名字，更在于取回他们的行动。

正是在这一次对抗瘟疫的积极自发组织之中，我们也不时可以看到他们利用手边为数不多的有限资源相互帮助，在市场与其他权力的重压之下聚集起勇气与耐心坚持斗争。这些环卫工人、运输物流工人，产业工人与医务工作者一起，在危机之中提示了一种超越市场逻辑与其带来的社会分裂的可能。当前这种可能性尚未壮大到冲破种种阻碍实现自身，只能作为徘徊的幽灵在充满灾难的世界之上游荡。这并非提示着绝望，而是提示着一种沉重的责任，提示一种历史对当代人的质询，要求我们立即团结并行动起来，不是去寻找，而是去生成一种比市场与国家更加有效的集体，不仅仅是克服一次瘟疫，更是去自由地劳动与生活。/

参考资料：

[1] Žižek, Slavoj. “Clear Racist Element to Hysteria over New Coronavirus – Slavoj Zizek.” RT International, www.rt.com/op-ed/479970-coronavirus-china-wuhan-hysteria-racist/.

[2] 龚冰琳. “口罩该不该涨价？政府应该做什么？-香樟经济学术圈-财新博客-新世纪的常识传播者-财新网.” 香樟经济学术圈, cec.blog.caixin.com/archives/220726.

[3] 外卖数据下的武汉：普通人的封城十日生活, baijiahao.baidu.com/s?id=1657859773700046864.

[4] 让武汉和全国一切如常 疫情下的卖菜人http://news.gzw.net/IT/2020/0208/1444966.shtml

[5] “我在武汉开超市：‘每天开门两个小时 肉就抢完了.’” 亿邦动力网, www.ebrun.com/20200210/372720.shtml.

[6] http://www.mzyfz.com/html/1434/2020-02-10/content-1418007.html

[7] 疫情下买菜APP的新考验：盒马携传统餐饮自救 叮咚、每日优鲜运力"捉襟见肘", baijiahao.baidu.com/s?id=1657883555581666077.

[8] 节后复工趋势调研：外卖、快递复工率超50%，部分企业延长假期_疫情. 5 Feb. 2020, www.sohu.com/a/370819109_313745.

[9] 北青深一度 . “武汉街头的‘摆渡人’：每分钟处理1000条信息，不是不怕感染，停了医护人员怎么上班: 深度报道.” 微信公众平台, mp.weixin.qq.com/s/fUtAhkgUZvpLHEAvX6O-Tg.

[10] https://mp.weixin.qq.com/s/AnXfMKhWMRa3XCNNOnfP-wO

[11] 剥洋葱 . “绿色通道、通行证、医院证明：医疗捐赠物资出入武汉记.” 微信公众平台, mp.weixin.qq.com/s/R-iXDgYd3ZZLBLiLEzxH9g.

[12] https://mp.weixin.qq.com/s/Ofp2WglnapOlldcw1V453A

[13] Lifeforfight. “肺炎疫情下的城市环卫工：单位发纱口罩/自己买口罩/洗了继续用.” 豆瓣, 29 Jan. 2020, www.douban.com/note/750355159/.

[14] 口罩深圳-实地调查, shimo.im/docs/WHXdVygrYDKx93kW/read.

[15] 剥洋葱 . “为家乡医院筹口罩.” 微信公众平台, mp.weixin.qq.com/s/Mknh3AVvWcjOSaNPJXFduQ.

[16] 董冀宁 陈璐 . “父亲被隔离6天后，17岁脑瘫少年的死亡.” 微信公众平台, mp.weixin.qq.com/s/U_cBuM7CtPJKWAJFM10MiA.

[17] 王绍光. 中国公共卫生的危机与转机, baijiahao.baidu.com/s?id=1656437622925416585.

[18] https://mp.weixin.qq.com/s/y5DTcfJ4Gurhlg-mqAabCQ
