---
layout: post
title: 秦晖：不能真把「防疫」当作「战争」
categories: Archive
tags: 新冠肺炎
image_feature: "https://i.loli.net/2020/02/16/rH2DE6CIlidkpfR.jpg"
date: 2020-02-16
description: 尤其在高传染性疫疾的防治中，让医生护士在缺乏防护的状态下进行一线医护工作，不仅是对医护人员的生命不负责任，而且是对医护对象、对患者和对全社会的不负责任。
---

原文来自「秦川雁塔」：~~[秦晖：不能真把「防疫」当作「战争」](http://206.189.252.32:8088/)~~

---

![](https://i.loli.net/2020/02/16/qwgQt4GyhUZJsTV.jpg)

最近全民抵抗新冠疫情，媒体乃至网络上都不断传出各种战争用语，诸如“战时状态”、“战时措施”、组织抗疫“敢死队”、打一场对抗病毒的“人民战争”，尤其是“不惜一切代价，打赢防治新冠这一仗”之类的提法，不一而足。

这些说法如果只是为了表达决心、鼓舞士气、团结民众，或无不可。但如果真的用战争状态下的一些做法来对付严重传染病，那是要谨慎考虑的。

无疑，严重传染病疫情与战时状态有相似的一面：情况紧急，需要采取一些平时不宜实行的“紧急状态”做法。但是，人类对抗严重传染病，毕竟在本质上不同于战争状态下的人与人对抗，即便都要实行“紧急状态”措施，这两种紧急状态也不是一回事，混淆二者会造成严重后果。

这本来属于常识，但是鉴于很多情况下常识被遮蔽，所以还是要说一说。

传染病抗疫与战争的第一个不同，就是抗疫并没有打赢打不赢之说，而战争则“胜败乃兵家常事”。

古今中外从黑死病到流感，人类经过很多规模、严重程度不等的瘟疫，损失难以计数，但只要人类挺了过来没有被灭绝，就都可以说是“战胜了”瘟疫。这就如当年海城地震伤亡很少，自然是我们的“胜利”，而唐山大地震那种伤亡惨重的灾难，最终也还是我们夺取了“抗震救灾的伟大胜利”一样。

极而言之，即便并非自然灾变而是人为的“细菌战”、“病毒战”，所谓胜败也只是就一方的人是否屈服于另一方的人而言，并非是就屈服于细菌、病毒而言。细菌病毒在这种场合也只是一种武器，并非战争的一方。

![](https://i.loli.net/2020/02/16/KQRGc4Ealkvy9gU.jpg)

这就如1860年英法联军之役中，清军在洋枪洋炮下伤亡惨重，最终被迫签订了北京条约，你可以说大清败给了英法，却不能说是败给了枪炮一样。几十年后的抗日战争为什么我们却是胜利了呢？就是因为日本人投降了嘛。尽管中国军民在日寇火力下伤亡远比在英法联军之役中更加惨重，但胜败总是对人（英法与日本）而言，不是对人所用的武器（无论冷兵器、热兵器和生物武器）而言的。

而疾病如果并非人为的“生物战”，就没有这种意义上的胜负可言。或者换句话说，如果把抗疫比喻为“战争”，则人类永远是这种“战争”的胜者——除非未来人类真被某种疾病所灭绝。

然而尽管在历史上所有的抗疫斗争中，人类都是胜者，但人们对某次抗疫的成功与否，还是会有褒贬很不同的评价。这评价的唯一标准，其实就是“代价”，基本就是指人命损失的多少。

所以，“不惜一切代价”去打赢抗疫“战争”是一种无意义的说法，如果这个代价是指人命，甚至可以说是极为荒唐的说法。这就是抗疫与真正的战争的又一大不同。

![](https://i.loli.net/2020/02/16/KgwkzOZ5LGmPSJ6.jpg)

人们从事战争，就是宁可付出一定代价（包括人的牺牲）也要争取得到某种结果。邪恶的战争往往不计人命，甚至发动战争可能就是为了残杀无辜——如希特勒为灭绝犹太人而发动的战争一样。

正义的战争中，保护更多的生命可能是目的之一或最终目的，但也有很多“正义之战”是为生命以外的“伟大目标”——诸如自由、尊严、荣誉、领土、主权等——而打的，所以才会有“不自由，毋宁死”这类豪言壮语。

但是抗疫就不同，尤其是针对恶性传染病的抗疫，除了保护生命之外，还能有什么其他目的吗？为了所谓“政治安全”不顾一切代价的做法能够用于抗疫吗？

无论多重的疫情总会结束，人类不可能向病毒割地赔款，称臣纳贡，更不会与病毒签投降协议或“不平等条约”，在疾病和自然灾害面前个体的受害者可能成千上万，但人类总是胜者，而作为胜者的人类既不可能向病毒要“自由”，也不能从病毒那里获得赔款与领土。

如果不能尽量多地保护个体生命，人类抗疫抗灾的努力还有什么意义？“不惜一切代价”如果是指人命的“代价”，赢得那种反正不会失败的“胜利”又有什么价值呢？“把代价降到最低”难道不是评价抗疫的唯一标准吗？

当然，抗疫与战争一样，存在着紧急状态下“群己权界”的调整问题，存在着个体与整体的损益关系。对于那些为了整体利益而甘愿自我牺牲的个体英雄，人们都要赞扬和褒奖。但是，对于以整体的名义要求、乃至强制要求自己以外的个体作出牺牲的行为，抗疫却与战争大有区别。

对于战争而言，赞扬英勇牺牲的将士和谴责昏庸自私、腐败无能的统治者，都比较容易做到。例如甲午战争的失败已经是公认的国耻，人们不会以邓世昌等将士的英勇献身为慈禧脸上贴金。

不是说“烈士”越多，老佛爷就越伟大。之所以不会，就是因为慈禧把自己的“政治安全”摆在第一位，导致攻守失宜，战和两输，使邓世昌这样的英勇将士饮恨疆场，“不惜（臣民付出）一切代价”的结果，只换得可耻的马关条约，丧权辱国，留下千古骂名。

这与邓世昌的千古英名反差强烈，但两者毫无矛盾。

![](https://i.loli.net/2020/02/16/JHnOZdkRfpzKGxX.jpg)

但是如果这场战争打胜了呢？就像斯大林最终打赢了希特勒，尽管他刚愎自用，草菅人命，战前联手纳粹瓜分弱邻，滥杀将帅亲痛仇快，战初指挥失当丢盔卸甲，丧师百万失地千里，致使苏联虽然最后惨胜，但军民死亡大大超过了德国，很多“代价”并非难免，由此斯大林也招致大量批评，不过因为最终战胜，他得到的评价与慈禧就大有不同，正如他自诩：“历史是不会谴责胜利者的。”

这类事例史不绝书，我们的古代先贤对此曾有过“一将功成万骨枯”、“为求恩幸立边功”等抨击。不过平心而论，从人类文明角度讲，法西斯必须打败，却不能说必然能被打败，斯大林在这方面还是有功的，他得到与慈禧不同的评价，也确实有合理的一面。
　　
然而由于抗疫与战争有前述的区别，即使蠢如慈禧，让她抗疫也会有胜无负。如果照搬战争胜负的评价，来评价抗疫，慈禧与斯大林甚至与华盛顿还有什么区别？而“饮恨疆场的邓世昌”们越多，慈禧就会越英明伟大？这不但违背人们的常识理性，更违背人类的基本道德。
　　
所以抗疫是不能“不惜一切代价”的。其实严格说来，战争也不能真的不惜一切代价，但抗疫就更是如此。纯从逻辑上讲，如果把疫区都变成奥斯维辛，患者都塞进焚尸炉，抗疫很快就可以“胜利”，但是这样的代价我们能够付吗？我们又能接受这种毫无人性的“胜利”吗？
　　
在抗疫行动中，自愿的舍己利人、利他、利公者当然是应当称赞的。并非自愿，而是强制一部分人为整体利益付出代价，如强制治疗、强制隔离、封城封村、禁足之类措施，如果是抗疫所必需，当然也要做。

但与战争不一样的是：行使例外的权力者，必须接受例外的问责；失去寻常的权利者，应当获得非常之保障。

一般疾病的自愿医疗可以是自费，而对疑似烈性传染病的强制医疗不仅必须落实医疗责任，而且必须是公费（不能仅是确诊后才公费，更不能为省公费而拒不确诊）。

自由人可以自己谋生，而当自由谋生的权利被剥夺时，政府就要承担“从摇篮到坟墓”的全方位保障责任，而且必须接受与此有关的全方位问责。
　　
处在抗疫一线的“白衣战士”们，他们的献身精神和无畏勇气应当与战争中火线上的战士得到一样的赞扬。但对他们的强制征用，则必须与战时规则判然有别，绝不能轻言所谓的“战场纪律”。

尤其在高传染性疫疾的防治中，让医生护士在缺乏防护的状态下进行一线医护工作，不仅是对医护人员的生命不负责任，而且是对医护对象、对患者和对全社会的不负责任。

道理很简单：战争火线上的战士伤亡固然也应当痛惜，但他们至少不会传染别人。所以在有些国家，战场上用督战队来强迫士兵冲锋是可以设想的。但即使是这样的地方，有点理智的当局也不会强迫没有防护的医生“上阵”去处理高传染性疫疾。

![](https://i.loli.net/2020/02/16/rH2DE6CIlidkpfR.jpg)

因为医护人员如果受感染，威胁到的就不仅是他们自己的生命。

要知道一线医护人员不仅是最易感群体，而且一旦感染也是最强感染源：

其一，他们每日“聚集”工作，无法禁足。

其二，他们大量接触的来院人群中，只有极少数就诊时确患传染病，但绝大多数都有疑似症状、其他疾病和各种不适，属于脆弱易感人群，医护如不能保证自身未感，还让其工作就不知是治人还是害人了。

其三，他们如果感染，传染面必然大概率地集中于同行的医务人员群体，这在疫情严峻、医疗资源尤其是医务人力资源稀缺的时期，无疑是灾难中的灾难，不是抗灾而是造灾。

所以，让医务人员缺乏防护地在一线处理传染病，岂止是用“不负责任”几个字可以轻描淡写的。

![](https://i.loli.net/2020/02/16/VaAz3YMW4tNHSZL.jpg)

近来报载香港医生工会要求管理者必须提供足够防护，这种理所当然的事竟然遭到我们这里一些人的嘲笑，这些人还夸耀我们这里要求医护人员冒险上阵的惊人“动员力”！真不知这些人的脑子是怎么想的。

就因为这种做法，导致我们一些地方医务人员感染率高得惊人，乃至远远高出前来就诊者：武汉市第七医院ICU病房三分之二的医护人员都被感染。

医生严重缺乏防护，“明摆着会感染也必须上”，受访者称为“裸奔”行医。武汉中南医院仅1月1日至28日期间收治的138名新冠肺炎病人中，院内感染就有57人，其中40人为医务人员，感染率达29%。而武汉协和医院、武大人民医院和市第一医院医护人员被感染的更分别多达262、194、125人。
　　
应该指出，这种把医疗政治化、在医疗中随意套用战争规则的做法在上个世纪的中国曾一度广泛流行，并造成很大危害。

典型的例子是，曾有人断言，深刺延脑附近的哑门穴可以使聋哑人喊出“毛zx万岁”（其实哑门穴名虽有“哑”字，传统中医指的却是脑症如中风、癫痫等所致的语言障碍，即所谓“舌急不语”、“寒热风哑”，与一般所说的聋哑根本就不是一回事，而且中医都指出此穴危险，不能深扎），于是便由解放军出面，鼓吹“不怕死”、“闯禁区”，在传统医书和现代解剖学都认为此穴进针应以1寸余为限的情况下，进行2.5寸深扎，还引用战争时代的“语录”，说是“在需要牺牲的时候，要敢于牺牲”，后来曾多次发生严重乃至致命事故。

当时曾有人体解剖学教师讲课中说到，“针刺哑门穴位时，要注意延脑的关系，若针刺不当，刺到正脑就有生命危险”，报纸上居然就刊出奇文《要抓讲台上和课堂上的阶级斗争》大骂教师散布“活命哲学”， 并发动该大学对教师进行无理批斗。

医学院竟然要批判“活命哲学”，难道治病不是救人活命，而是要把人弄死吗？这就是典型的把医疗当“战争”了。

幸好当时针对的还不是传染病，深扎哑门“不怕死”伤害的还只是当事人，如果鼓吹医生“不怕死”而无防护地处理高传染性疾病，那就更加过分了。
