---
layout: post
title: 哈佛科学家预测新冠肺炎将全球大流行 美国还没做好准备 下个月至关重要
categories: Archive
tags: 新冠肺炎
image_feature: "https://i.loli.net/2020/02/14/9iQc1zHdhXOWDMJ.jpg"
date: 2020-02-14
description: "随着美国确诊第15例新冠肺炎，在香港、新加坡、日本等国家地区开始报告社区传播病例，越来越多的研究者担心，这场疾病可能发展为全球流行病，如果疫情真的在美国爆发，我们的医院和医疗体制或许并未做好准备。"
---

原文来自「纽约华人资讯网2」：~~[哈佛科学家预测新冠肺炎将全球大流行 美国还没做好准备 下个月至关重要](http://206.189.252.32:8088)~~

■ 纽约华人资讯网主笔  詹涓

---

这两天，美国卫生部门的动作很快，向外界传递的声音和制订的政策也在迅速发展。

周三疾控中心(CDC)主任罗伯特·雷德菲尔德博士(Robert R. Redfield)在媒体通气会中给出了以下观点：**美国境内将出现更多人传人的案例，有可能在社区爆发，但美国仍有机会阻止这种冠状病毒(COVID-19)的广泛传播**。

周四上午，卫生和公共服务部长亚历克斯·阿扎尔(Alex Azar)在参议院财政委员会听证会上表示，CDC将与五个城市的卫生部门合作，开始使用国家流感监测跟踪系统，对出现流感样症状的患者进行冠状病毒检测。另据美国药监局(FDA) 前局长、美国企业公共政策研究所(AEI)研究员斯科特·戈特列布(Scott Gottlieb)推文透露，这五个城市应为旧金山、洛杉矶、亚特兰大、芝加哥、纽约。

这是一个重要而谨慎的步骤，有助于更早地确定疫情。而对于任何流行病来说，早发现、早隔离都是成功控制疫情蔓延的首要步骤。

随着美国在周四确诊第15例新冠肺炎，在香港、新加坡、日本等国家地区开始报告社区传播病例，越来越多的研究者担心，这场疾病可能发展为全球流行病，如果**疫情真的在美国爆发，我们的医院和医疗体制或许并未做好准备，而医疗资源更为匮乏的东南亚和非洲，则面临更加危险的前景**。

### 01 “COVID-19在国际上广泛传播只是时间问题”

对于新冠肺炎的发展，全球科学家勾画出了两种前景，其一为遏制，其二为大流行。遏制是最为乐观的情形，但它的成功将部分取决于疫情控制在中国本土。现在，越来越多的科学家认为，一场大流行可能不可避免。

哈佛大学陈曾熙公共卫生学院(T.H. Chan School of Public Health)教授、传染病流行病学家马克·利普西奇(Marc Lipsitch)对纽约华人资讯网表示，**世界正处于COVID-19病毒大流行的早期阶段，在国际上广泛传播将只是时间问题**。

他说：“我认为，这种病毒的发展基本上和2009年的流感差不多，但是会更严重。最大的问题是有多严重。”

利普西奇认为新加坡值得一看。这个城市国家拥有非常强大的公共卫生系统，是2003年非典爆发期间遭受打击的地方之一，并从那时起大大加强了疫情应对能力。

截至发稿时，新加坡已经确诊了58例，其中超过半数与中国没有联系，属于在当地社区人传人。

新加坡总理李显龙(Lee Hsien Loong)在全国讲话中承认，这种冠状病毒“可能已经在我们本国人口中传播……如果这个数字继续增长，在某种程度上，我们将不得不重新考虑我们的战略。”

![](https://i.loli.net/2020/02/14/9iQc1zHdhXOWDMJ.jpg)

此外，利普西奇认为，这次疫情最让它担忧的部分在于，**这种病毒可能比SARS更难控制，因为它可能在没有出现症状、或者症状非常轻微之前传播——因此，仅仅隔离确诊病例很难阻止传播**。

美国东北大学传染病建模师亚历山德罗·韦斯皮尼亚尼(Alessandro Vespignani)也指出了同样的问题：很难甄别和隔离尚无症状的人，因此，如果这类人群能够传播疾病，“ COVID-19就很难止步于中国。随着时间的推移，我们知道的越来越多，我们可以做的越来越好。不幸的是，这头野兽移动得很快。”

以一名英国商人为例，他于1月底在新加坡的一次会议上被感染。随后他前往法国阿尔卑斯山，在那里他将病毒传染给了一起滑雪的一家五口。一直到他在英国确诊时，他的症状都非常轻微。

在德国，一名中国女性出差到巴伐利亚州的公司总部，引发了14起病例。她至少感染了几个同事，这些人又传染了一些家人。之后流行病学家在追踪病例时发现，这名中国女性也只是表现出了咽痛、疲惫等轻微不适，不足以令病人和医疗系统产生足够的警惕。

![](https://i.loli.net/2020/02/14/qQoEFeYp7MCTGNx.jpg)

周三在媒体通气会上，CDC主任雷德菲尔德博士的态度较前段时期显得更加紧张，他表示，“我们还会看到新的病例。我们可能会在美国境内看到人传人，到了一定的时候，我们很有可能会采取公共卫生策略来缓解感染问题，例如采取关闭某些公共设施等‘社会距离’措施来限制被感染的数量。我们不可能阻止这种病毒进入这个国家，但我们确实通过尽可能延长控制阶段来争取时间。”

雷斯菲尔德还称，一旦美国开始在国内多个地方出现四代感染病例，CDC可能会得出现有控制病毒手段已经无效的结论，到那个时候，“就需要采取全面减灾策略”。

### 02 “下个月至关重要”

戈特列布昨天在参议院国土安全与政府事务委员会发表声明称，冠状病毒在中国的流行传播，以及在新加坡、香港和日本的社区传播，令美国遭遇大流行传播的风险大增。更糟糕的是，这种新型冠状病毒可能会成为地方病，演化为每年传播并感染人类的季节性病原体中更危险的一员。

戈特列布指出，下个月至关重要。模型显示，从病毒在中国首次发作（目前怀疑发生在11月某个时候）到疫情在中国蔓延大约为10周。而当时全球社会对此都毫无认知，因此，在12月底或1月初进入美国的约25万中国公民或许已经播下了社区传播的种子，中国的经验表明，如果病例在1月初输入美国，而且仍未被发现，那么我们可能仍处于向更广泛疫情发展的早期阶段。最终，疫情可能会在美国爆发。

戈特列布提出，美国有能力控制小的疫情，但需要保持警惕，做好准备。但在他和其他很多公共卫生专家看来，美国的准备并不充分。

波士顿大学医学院传染病副教授和特殊病原体医疗主任纳希德·巴迪里亚(Nahid Bhadelia)有着丰富的流行病防控经验：埃博拉疫情爆发时，她在西非当临床医生，H1N1疫情爆发时，她在纽约市的医院当医生。现在，她在波士顿工作，为COVID-19急性呼吸道疾病的潜在病例做准备。

![](https://i.loli.net/2020/02/14/Rm3UeXoygtCdaQT.jpg)

她在《自然》(Nature)杂志撰文说：现在美国面临的许多挑战与此前疫情暴发时面临的挑战相同，都要解决一个同样的问题：当大批人因怀疑感染一种不熟悉的疾病而前来求医时，你该怎么办？而这当中，又以快速识别受感染的人并加以隔离至关重要。

美国CDC直到最近仍然建议只对那些有明确和已知风险因素的人进行检测，比如到过中国旅行或与感染者和/或接触者密切接触的患者。患者还必须表现出发热和气短等症状。

这一策略将错过潜在疾病爆发的情况，如果病毒悄无声息地在与中国没有联系的人群中传播，而且只有一小部分病人患上了肺炎，那么可能需要几十个感染病例才能注意到疫情的爆发。到那时，流行病将很难预防。

巴迪里亚强调，现在是时候开始对更多的人进行检测了，即使他们没有去过中国，也没有接触过感染者。简而言之，现在COVID-19既不是武汉的病毒、也不是中国病毒，要考虑这种病毒与世界的联系。

CDC将开始在美国5个主要大都会区对出现流感样症状的患者进行普遍的冠状病毒检测，这较原先的初筛手段大大前进一步。那么，还有第二个问题要考虑——那就是筛查能力。

![](https://i.loli.net/2020/02/14/YDkjB4IbiqPAomr.jpg)

流行病的防控重点永远是早确诊，早隔离，避免社区散播。目前CDC的检测需要大约36个小时才能得出结果，而且CDC昨天已经承认，他们的试剂盒出了问题，问题似乎来自试剂中的某个成分；**此外中国的大量经验表明，没有出现症状的人体内可能没有足够的病毒，接受试剂检查时会出现假阴性结果。种种问题令许多医院的传染病部门感到焦虑**。

值得安慰的是，科学家们正在以创纪录的速度收集信息、开发技术。譬如香港理工大学11日宣布，该校成功研发一个呼吸道传染病快速测试系统，可于一小时内同时检测30至40种病原体，包括COVID-19、禽流感、非典病毒和中东呼吸综合征等。


### 03 “我们的急诊室连星期六晚上的高峰期都没准备好”


CDC已经就如何应对COVID-19流行给出了指示。

根据CDC在其网站上提供的“医院准备清单”，医疗中心应立即“确认并隔离COVID-19患者，并通知关键设施工作人员和公共卫生当局”。

它们还必须限制提供治疗的患者数量，但也要准备好在病例数量激增时做出相应反应。

医院被要求简化内部和外部的沟通，并监测医护人员是否有感染病毒的迹象。

一些医生认为，情况或可审慎乐观，原因跟美国已经经历了H1N1和埃博拉病毒两次实战训练有关。

十年前H1N1流感开始传播时，美国医院里挤满了病人，这场在2010年宣布结束的大流行导致近27.5万人住院。当时，肺科医生尤其担心呼吸机和ECMO设备的潜在短缺，这两种设备都用于治疗急性呼吸窘迫综合征(ARDS)患者，ARDS是一种导致液体在肺部积聚的严重疾病。许多医院只有为数不多的ECMO仪器，用于将血液泵入体外并为其提供氧气——这些机器是为接受心脏手术的患者保留的。

![](https://i.loli.net/2020/02/14/ZOaJnYj39i1HWUD.jpg)

之后2016年埃博拉疫情爆发，CDC在全美指定了10个“区域埃博拉病毒和其他特殊病原体治疗中心”，这些医疗中心除了大量兴建隔离病房，也为其他医院提供行动指导。

现在，美国医院在面对呼吸道传染病方面，软硬件发生了许多变化。ECMO机器更常见。许多卫生部门和专业组织已经更新了指导方针，指导如何在危机中分配像呼吸机这类有限的资源。一些医院还制定了新的应急计划，详细列出了从如何对病人进行分流、何时取消择期手术，到如何将病房和侧翼改造成专门用于照顾受感染病人的区域等各种细节。

“从很多方面来说，我们的处境更好了，但还有更多的工作要做，”印第安纳波利斯卫生系统埃斯肯纳兹健康中心(Eskenazi Health)的内科主任威廉·格雷厄姆·卡洛斯(William Graham Carlos)博士说。

其中一项工作便是解决人员不足的问题。COVID-19的病情特殊性可能会令美国的医院和急诊室更加不堪重负。《美国医学会杂志》(Journal of the American Medical Association)上发表的一篇文章讨论了武汉138名住院冠状病毒患者的临床特征，其中包括两项令人深感不安的发现。

![](https://i.loli.net/2020/02/14/nvZa7sJEX8U1YTe.jpg)

首先，138名患者中有26%需要进入重症监护病房，这是一种在人员和物资方面资源高度密集的治疗手段。这些患者最可能需要机械通气、有创医疗设备等。需要重症监护的病人总体住院时间更长。研究还发现，大约41%的病例是由于人们在医院里暴露而感染的。

波士顿大学医学院的巴迪里亚教授提出：**她在纽约市处理H1N1期间的经验表明，多达60%的临床医生都被感染，而这些医生又可以传播疾病给病人和同事**。随着越来越多的卫生保健工作者生病，医院和诊所将更难应对疫情。而自2008年以来，美国的地方卫生部门已经流失了约5.8万名工作人员。

加州圣贝尼托和圣克鲁斯两县的急诊医疗主任戴维·吉拉杜奇(David Ghilarducci)也提出了人员配备的问题。他说：“我们绝对没有准备好迎接一大波上呼吸道疾病患者。病人会来到急诊室，那里通常挤满了寻求常规护理和紧急护理的人。他们将被护送到用布帘隔开的房间，或者躺在走廊的轮床上。

事实上，急诊室是病人能去的最糟糕的地方之一。我们还没有为大流行做好准备。嘿，星期六晚上是急诊室的高峰期，我们根本忙不过来，连对这种时候都没准备好呢。”

### 04 前景未卜

像美国这种富裕国家尚且可能难以妥善应对COVID-19，现在全球公共卫生界更担心的是在卫生保健系统较薄弱的国家，如东南亚和非洲的某些国家，可能很快就会被当地的疫情所击垮。

根据两项分别由英国南安普敦大学和哈佛大学所做的研究，在东南亚，印度尼西亚、泰国和柬埔寨目前报告的病例低于预期，这可能是因为当地检测能力有限，也可能因为感染者可能在被发现之前就已经康复了，但这都为进一步传播撒下了种子。

**另一个令人担心的区域是非洲，大量中国劳工在非洲工作，他们在中非洲之间的旅行可能是传播途径**。

巴黎皮埃尔·路易斯流行病学和公共卫生研究所(Pierre Louis Institute of Epidemiology and Public Health)传染病模型专家维多利亚·科利扎(Vittoria Colizza)说，埃及、阿尔及利亚和南非是风险最大的非洲国家，但这三个国家应有能力对疫情做出有效反应。

她和同事们最担心的是尼日利亚、埃塞俄比亚、苏丹、安哥拉、坦桑尼亚、加纳和肯尼亚这七个国家，这些国家进口病毒的风险不大，但是它们薄弱的卫生保健系统、较低的经济地位和不稳定的政治局势使它们极易受到感染，而非洲大陆频密的人员往来意味着任何国家都不可能独善其身。

直到上周，许多非洲国家还没有能够诊断新型冠状病毒的实验室，但形势正在迅速变化，根据世界卫生组织的数据，非洲大陆已经从仅有两个有能力确认该病毒的实验室（一个在塞内加尔，一个在南非）发展到现在至少有8个。这当中有3个实验室设在了尼日利亚，目前该国卫生系统还在应对病毒性出血性疾病拉沙热的爆发。

![](https://i.loli.net/2020/02/14/raf5V8v3WUwqYoM.jpg)

<figcapiton>图为非洲机场</figcapiton>

一些学者认为，2019-nCoV可能会发展成流行病或地方病，就像其他四种人类特有的冠状病毒一样，每隔一段时间卷土重来一次。你可能不知道它们的名字，因为它们主要引起感冒，是在感冒和流感季大量聚集在我们周围的病毒之一。（它们分别是OC43、NL63、229E和HKU1。）虽然川普认为冠状病毒疫情会随着温度升高而消失，但并非所有疫情都随着天气变暖而平息，而这次疫情在几个方面仍很神秘。

“虽然有些冠状病毒感染是季节性的，但只有时间才能告诉我们新型冠状病毒是否会这样，”美国CDC前主任汤姆·弗里登(Britta Lassmann)博士说。

范德比尔特大学医学中心(Vanderbilt University Medical Center)的预防医学教授威廉·沙夫纳(William Schaffner)博士也对这种病毒的不可预测性提出了警告。

![](https://i.loli.net/2020/02/14/8pkX7U25drm6wGN.jpg)

<figcapiton>范德比尔特大学医学中心</figcapiton>

沙夫纳警告说，不要指望新的感染会随着春季的到来而减缓。“季节的变化会对病毒有影响吗？只有上帝知道，我们唯愿如此。人类冠状病毒多数会受季节影响，但这是一种流氓病毒。”
