---
layout: post
title: 新冠肺炎“次生灾难”正在发酵，要预防社会出现系统性崩溃
categories: Archive
tags: 新冠肺炎
date: 2020-02-06
description: 因为工厂停工，物流受阻，中国的公私事业都受到了很大的影响。社会无法正常运转，武汉市封城，湖北省几乎等于全省封省。民生问题受到了很大的影响，虽然新闻媒体一直在报道乐观的消息，但是在疫区确实出现了人道主义灾难，这个问题不能回避。
---

原文来自公号：~~[周志远](http://206.189.252.32:8083/%E6%96%B0%E5%86%A0%E8%82%BA%E7%82%8E%E2%80%9C%E6%AC%A1%E7%94%9F%E7%81%BE%E9%9A%BE%E2%80%9D%E6%AD%A3%E5%9C%A8%E5%8F%91%E9%85%B5%EF%BC%8C%E8%A6%81%E9%A2%84%E9%98%B2%E7%A4%BE%E4%BC%9A%E5%87%BA%E7%8E%B0%E7%B3%BB%E7%BB%9F%E6%80%A7%E5%B4%A9%E6%BA%83.html)~~

---

新冠病毒继续蔓延，已经引起了人道主义灾难，次生灾难也正在发酵。前两天有新闻报道，湖北省黄冈市下属的黄梅县有一个癌症患者，因为疫情的影响，无法就医，母女俩徒步走到九江长江大桥，希望过桥去江西治病。

随着春节假期的结束，这种情况会越来越多。很多的其他病人需要就医，但是现在不但武汉因为医疗资源匮乏而无法开展正常的医疗活动，其他城市的医院同样很难在短期内恢复正常。尤其是在各地的医院都相继发生了聚集性疫情，而防护服又普遍不足的情况下，医疗秩序更是难以恢复。

因为工厂停工，物流受阻，中国的公私事业都受到了很大的影响。社会无法正常运转，武汉市封城，湖北省几乎等于全省封省。民生问题受到了很大的影响，虽然新闻媒体一直在报道乐观的消息，但是在疫区确实出现了人道主义灾难，这个问题不能回避。

有些灾难现在看来，已经是不可避免的了。因为新冠病毒的传染性实在是超出了很多人的预料，短期内防控工作难以放松，否则的话，随着情况的进一步加重，整个社会有可能会发生系统性的崩溃，后果将更为严重。

从公开的流行病学调查信息来看，新冠肺炎的传染能力实在太强。现在的防护政策可以减缓疫情爆发的速度，但是可能很难阻挡新冠肺炎大范围的蔓延。

我们最后可能只能祈祷在天气的帮助下，2019-nCoV能放过我们人类。我国暂不工作的居民有必要提升自我防护级别，延缓新冠肺炎全国大爆发的速度，与时间赛跑，待气温升高后，疫情会好控制很多。

去年湖北是个暖冬，而且去年湖北属于大旱之年，2019年湖北的干旱在过去的几十年都很少见，整个夏天都没有下过什么雨。所以今年湖北会否出现倒春寒，会否出现一个较长的梅雨季，还很难预料。以我自己在湖北多年的生活经历来看，湖北省如果上一年干旱燥热，下一年一般都会雨水多，天气湿冷。

如果出现了倒春寒和梅雨季，湖北省的疫情会雪上加霜。刚刚出来的新闻报道中，专家称在空气湿度达到40%，气温20度的条件下，2019-nCoV能生存五天。

而这个空气湿度和温度，恰好是湖北省清明节前后的空气湿度和温度。病毒生存期越长，越难控制。如果今年长江中下游流域的洪水季提前到来，后果将不堪设想。

我们以为能封锁病毒，病毒也许会回报我们以无情的嘲笑。我有种直觉，2019-nCoV的全球爆发可能在所难免。它正由星星之火向燎原之势发展。人类太傲慢了，很久没有受过这么大的教训，大自然在教我们谦卑与谨慎。

纵观我们人类的发展史，人类祖先从非洲大陆走出后，到欧亚大陆，再跨过白令海峡到达美洲，我们人类每到一处，那里便要发生动物大灭绝。我们把灾难带给了动物界，动物也借病毒之手回报我们以同样的灾难。动物是病毒的宿主，病毒是动物复仇的工具。

今年如果雨水增多后，病毒会随着雨水四处蔓延，也会随着江河湖海跨省传播。如果发生人畜共染，后果更严重。生化部队应该未雨绸缪，提前对此做好准备，深入到湖北省的每一个基层村庄和城市去，大面积的消毒杀菌。

不但湖北省会这样，临近的湖南省、江西省、安徽省、河南省、四川省和重庆市的气候特征也与湖北省相近，甚至长江中下游流域的江苏省和上海市，也会因为带有病毒的污水流入长江而受到波及。

从地域上来说，这些省份也挨得近。湖北省的疫情严重的话，即便能继续封省控制人类的活动，也控制不了飞禽走兽的活动。这几个省的防疫部门应该提前在这方面做好准备。

刚刚过去的一个春节，消耗掉了大量的防疫物质，几乎耗尽了我国的物资储备，接下来的这场战役需要更多的物资。工业生产不尽快恢复是不行的，全体国民只能戮力同心，共体时艰，在做好个人防护的前提下，把物资生产搞上去，搞不上去我们这场仗是打不赢的。中国作为世界工厂，中国的工业停止运转了，靠其他国家外援我们是不现实的。

自古打仗都是一要战士在前方冲锋陷阵，二要后方钱粮能供应上。防疫也是如此，一方面需要前方的医护人员救治病人，生化人员全面消毒，另一方面也需要后方的物资供应有保障。

我初步的判断是，2019-nCoV的传染力强大，我对我们能否靠现在的办法控制住它表示存疑。但囯难当头，无论最终结果如何，我们都只能鞠躬尽粹，死而后已，因为不努力的结果会更糟。

如果多个大城市失守，中国的医疗资源将会全面吃紧。虽然目前除武汉外的其他城市的死亡率并不高，但是这主要是因为目前其他城市的感染人数少，医护人员足够，能够应对。如果其他城市的感染人数也继续上升到一定的数量的话，医疗机构将有可能全面的崩溃。

我从新闻报道中的一些实际的例子和数据来分析2019-nCoV的传染能力，并分享我个人对局势的判断。

2月3日，天津疾控中心公开了一项流行病学调查。该调查显示，天津宝坻区某商场内发生了一起聚集性疫情。商场内的一位员工在外地进货时感染上了新冠肺炎，一位顾客在该员工的店内购物后，又去另外两个店铺购物，总共在商场内逛了三个小时，就完成了被感染到继续感染另外两个人的过程。这么快的传染速度，说明这种病毒的传染能力已经非常强。

2月3日，在北京市疾控中心新闻发布会上，西城区副区长也介绍了一例发生在复兴医院心内科重症监护室内出现的聚集性疫情，共确诊了9例病人，其中医护人员5例，住院患者4例。初步调查显示是个别医护人员受感染导致。

商场、超市、菜市场和医院都是城市人不得不去的地方，如果新冠肺炎的传染能力如此之强的话，那么我们现有的防控工作可能只能延缓它在全国范围内的大爆发，要想控制它在全国各地的大爆发，需要进一步升级个人防护级别。

目前湖北黄冈和浙江温州都在中心城区实行每户每两天只能有一个人出门买菜的政策，这种政策应该尽快在全国各地推广，而且应把间隔时间从两天改为三天至五天，尽可能的减少聚集性疫情发生。菜市场和超市要限制人口密度，提醒居民在购物时保持足够的距离，即便戴了口罩也应如此。

我们宁可把疫情想得严重一些，也不能因为太乐观而麻痹大意。我们当然希望出现最乐观的结果，但却要按照最悲观的可能来备战。

世界最权威的医学杂志《柳叶刀》刊登了香港大学学者的研究论文，根据香港大学的最新模型研究估计，截止到2020年1月25日，中国武汉市可能有多达75800人感染了2019年新冠病毒，感染人数翻倍时间为6.4天。如果真是这样的话，湖北感染数就太恐怖了。

1月2日，中国工程院李兰娟院士再次率队到武汉参加重症救治，李院士到武汉了解到实际情况后表示，武汉检测试剂不够，不是每个人都能得到检测。这意味着武汉的大量病人确实没有被确诊，目前公布的数据偏离事实。全国已有近万医护人员支援武汉，武汉仍然是一床难求的状态，确诊数上升后就更紧张。

以我实际接触到的武汉市内的居家隔离治疗的新冠患者来看，武汉的患者仍然没有得到及时的救治和良好的照顾。

一些患者为了不传染给家人，独自一人隔离治疗，生活上很困难，高营养高热量的食物仍然缺乏。药店里能治疗感冒的药都已经售空，病人即便得到了处方，也只能望药兴叹。

一些轻症患者本来可以在早期得到治疗，不至于发展成重症患者，但是这样一拖再拖也很容易拖成重症患者。这是我有生之年所见到的最严重的人道主义灾难。

2月3日，军队已经进入武汉，并为武汉市民的生活提供物质保障，此举可以改善武汉市民的生活状态。头一天，武汉市也宣布对四类人员进行集中收治，这也可以改善武汉市感染者和疑似感染者的状况。相信接下来国家还会在医药上支持武汉市民。

但我担心的是武汉市的药店只要一有药，又会被恐慌的市民抢购一空，囤积起来，真正需要用药的患者反而没有药可用。我也担心在四类人员之外，武汉市还存在大量的无症状的病毒感染者，他们仍然是游离于隔离政策之外的传染源。希望下一步这种状况可以得到改善。

武汉作为一个集约型的大城市，市民管理成本相对较低，武汉市本来也有足够的医疗资源，加上这么多的外援，武汉市的情况或许不至于太糟糕。

但是武汉周边的城市如黄冈、孝感、荆州、黄石等地方，人口分散，当下大量人口分散在农村。这种分散型的人口居住模式，导致这些地方救助起来很困难。基层医疗资源匮乏，很快就可能上演过年前武汉市几近崩溃的局面。

我担心疫情已经在湖北省农村地区蔓延开了，只是大多数患者都处于未发病状态。

我对湖北省农村地区很了解，湖北黄冈也就这几天突然一下子紧张起来了，此前从政府到民间，都对新冠病毒轻敌了。还有很多人嘻嘻哈哈的聚集在一起打牌，农村人大多嘲笑城里人怕死，以一种无所谓的状态继续聚集娱乐。

这些爱打牌和娱乐的人会把病毒带回他们的家庭，在未来的一段时间里出现大量的农村家庭聚集性疫情。

因为农村现在也封路了，这些病人一旦发病，求医问药比城市居民更难。估计一周到十天后，随着大量的农村人发病，农村地区才会紧张起来。农村的资源远不如城市充足，一旦出现这种局面，难以收拾。而且湖北的农村大多是聚族而居，不排除会因为疫情蔓延出现群体性事件。

令我更忧心的是另一则报道，法新社2月3日报道，法国卫生部长表示，上周日一架从武汉前往法国的航班上，254名从武汉撤回的海外人士中，有36人出现了新冠肺炎的症状。不知道这36人中最后会被确诊几人。

这个比例高于此前从武汉撤侨的日本人感染的比例。当然，我们也不能排除法国撤侨的飞机上发生了聚集性疫情。

武汉市民近期都被隔离在家中，如果疫情发展仍然那么迅速的话，即便武汉市现在有大量的外援，可能也会应对乏力。

虽然新冠病毒本身致死率不高，但是因为医疗资源的缺乏，一些重灾区缺医少药，治疗被延误，死亡率还是会居高不下。

国家应该对医药资源实行战时管理制度，不允许私人再抢购各种药材，因为目前我国国民在各种资讯的带动下，大量囤积各种药品备用，导致90%以上的并不真正需要药物的人占用了非常宝贵的医药资源，而真正需要这些医药帮助的病人却买不到药。他们得不到治疗，就会成为新的传染源。

在人人自危，人人自私的采取自我保护的情况下，医疗资源的配置会更加的不合理，人道主义灾难会更严重。

另一方面，社会是一个非常复杂的大集体，并不是所有人的思想认识都一致。很多危险份子漠视疫情的严重性，继续聚众娱乐或不遵守防疫秩序，扰乱正常的防疫工作，占用有限的公共资源。

对于基层社会和城市里的中老年人来说，他们只有见到了自己身边的人一个个的因为新冠肺炎去世了才会提高警惕。今天我去北京的菜市场购买了全家人够吃一周的菜，打算买完菜后全家人这一周都不再出门。

但是在买菜的过程中，还是发现一些老年人互相凑得很近，防范意识特别差。而且这些老年人还比较顽固，不太能听得进年轻人的意见，他们总以为年轻人过度紧张。以北京菜市场人流的密度，我担心的是即便有口罩防护，仍然会发生传染。

以前我看过一些人类学著作，根据人类学家的观点，人类性格中的一些因素，比如警惕、节制、愤怒等，均是在大自然中生存时习得的生存经验，经不断进化而成为人类的一些共性。新冠肺炎疫情发生，我有机会从现实中验证这种观点。

瘟疫也是大自然在促进人类进化的一种形式，凡是警惕性不高和身体孱弱的人，会在瘟疫中被淘汰，人类种群的生存能力也就得到了增强。

现代文明让人类对自己太过自信，所以人类麻痹大意的时间太久了。2019-nCoV是大自然给我们的一次新警告，它在提醒我们敬畏自然，在大自然面前谦卑一些。

人类的免疫系统，除生理上的免疫力之外，还有人类对危险的警惕性，而且后者更重要。缺乏足够的警惕性的人，是不适合在危险的自然界生存的。如果我们整个种群都缺乏警惕性，我们就会从地球上消亡，像屡次的生物大灭绝一样。

这也是“适者生存”的自然法则在发挥作用。所以从好的一面来说，瘟疫可以改良人类基因。

令人欣慰的是，这个病毒可能不是那么难对付，泰国和美国的患者都取得了良好的治疗效果，部分患者治疗一两天后即已恢复。中国中西医结合治疗新冠肺炎的效果也很好。现在救治成功率比刚爆发时要高。

2月4日，李兰娟院士的团队和科技部也都对外公布了找到了有效药物的消息。美国的新药也正在中国开展临床实验。

相信在全球医生共同的努力下，我们很快就会找到治疗新冠肺炎的更有效的方案。到时候新冠病毒或可能会被当作一种新型的流感病毒对待，以后它或许每年都会造访人类。疫苗被研发出来后，我们就离战胜新冠病毒不远了。

企业界应尽快投放机器人参加抗疫大战，目前的社工、行政人员和志愿者的很多岗位可以用机器人代替，减少这些人受病毒感染的危险，这也能避免他们成为新的传染源。

我从大学出来后，在国家图书馆读了二十多年的书，可能已是中国视野最宽，最能思考的人之一。我本以为自己可以在阅读中安享一生的清福，但万万没想到的是会在我有生之年碰到这样的一场灾难。

而且需要在这场灾难中挺身而出，结束我安逸的书斋生活，以一个思考者的身份，投入到这场抗疫之战中去。天下兴亡，匹夫有责，但愿我们这些思考者看起来也许有些杞人忧天的思考，能引起人们的警惕。

我已很难判断新冠肺炎疫情继续发展的方向，只能继续观察这个病毒的流行特点，持续更新自己对它的认识。

我会不间断的分享自己对疫情进展的判断，希望对各位同胞有所帮助。

同时也希望各位同胞能够提升防护级别，继续减少外出的次数，在每一个细节上注意，避免中招，不被感染即是给国家、家庭和医生们减轻负担。

本文放弃版权，所有个人和媒体都可以不经我本人同意转载。想转载者请自行转载，不必和我商量。我很忙，请勿打扰！

周志远 2020年2月5日凌晨完稿于北京

公众号：zhouzhiyuan360
文章已于修改
