---
layout: post
title: 武汉肺炎50天，全体中国人都在承受媒体死亡的代价｜大家
categories: Archive
date: 2020-01-29
tags: 新冠肺炎
image_feature: "https://i.loli.net/2020/01/29/OzhFcu7eWanCq91.jpg"
description: 是谁杀死了媒体，又是谁在承担这个代价
---

来源｜[腾讯大家](http://206.189.252.32:8083/%E6%AD%A6%E6%B1%89%E8%82%BA%E7%82%8E50%E5%A4%A9%EF%BC%8C%E5%85%A8%E4%BD%93%E4%B8%AD%E5%9B%BD%E4%BA%BA%E9%83%BD%E5%9C%A8%E6%89%BF%E5%8F%97%E5%AA%92%E4%BD%93%E6%AD%BB%E4%BA%A1%E7%9A%84%E4%BB%A3%E4%BB%B7%EF%BD%9C%E5%A4%A7%E5%AE%B6.html)

原创 陈季冰 大家-腾讯新闻

---

在我动手写这篇文章之初，一团沉重的阴霾正向我和家人头上压来。

我目前居住的上海市长宁区某居住小区公寓楼里有一户人家是武汉籍，共有五口人。一对老夫妻（外公外婆）不久前带着小孩子回武汉过年，大约是看着形势不对，**在武汉封城的几个小时前（23日晚，也就是俗称的小年夜）连夜返沪**。

开头两天还比较平稳，大年初一（25日）下午起，外公开始出现发烧症状。

此刻，一家人已自行去附近的医院就诊。

左邻右舍们都惴惴不安，不知接下来会如何？

![](https://i.loli.net/2020/01/29/OzhFcu7eWanCq91.jpg)

<figcaption>医务人员带领重点地区来沪人员入驻宾馆，进行医学观察。中新社记者 张亨伟 摄</figcaption>

### 1

我是一个拥有近30年新闻工作经历的媒体人，自然对这场仿佛“突然之间”席卷神州大地的疫情中的媒体角色格外关心。

纵观新闻媒体对这次“新型冠状病毒肺炎”（以下简称“新冠肺炎”或“新冠病毒”）大爆发的反应，**1月20日那天是一个非常鲜明的分水岭**。

![](https://i.loli.net/2020/01/29/tmPDdrQfJVhx3c9.jpg)

<figcaption>1月20日晚，国家卫健委高级别专家组组长、中国工程院院士钟南山接受央视新闻采访</figcaption>

在1月20日之前，关于绝大多数关于“新冠肺炎”的报道来自武汉和湖北当地的官方媒体。这些报道大多服从一个主基调，用一句话来概括就是：病毒“危害有限”，并且是“可控的”。比如说，有专家言之凿凿地称，这种新病毒不能“人传人”等等。

期间还发生了8位武汉市民因在社交媒体上“造谣”而被谈话的事情。

虽然第一例患者的出现是在2019年12月8日，但之后的40多天里，可以说新闻媒体对受众发挥的一直是“**安抚**”功能。

自然地，别说是全国其他地方，就是在武汉当地，气氛都是一派祥和。

武汉市卫生健康委员会的第一则通报则是在2019年月12月31日发布的。我觉得，倒不能因此过多责怪武汉市卫健委在这方面反应迟缓。**一种人类以前从未遇到过的新病毒的发现、分离、筛查和确认，确实需要一定的时间**。

![](https://i.loli.net/2020/01/29/Q1ZKzqGdtAcBSou.jpg)

<figcaption>2020年1月1日，华南海鲜市场公告休市整治</figcaption>

不过，武汉市卫健委此后又零星发布过几次语焉不详的通报，当地新闻媒体也都在很不重要的位置做了报道。简单总结，患者人数略有增加，但不严重。而在1月5日到11日之间，通报干脆停止了；1月13日至18日，通报恢复，但都是无新增病例，无病例死亡，只有治愈出院病例。

![](https://i.loli.net/2020/01/29/LCdYArIJ65TEZgp.jpg)

<figcaption>1月19日新闻，专家称武汉冠状病毒肺炎总体可治，当地媒体的报道方式极为乐观</figcaption>

有人发现，那两段时间恰逢武汉市和湖北省的“两会时刻”。他们因此戏称，这个“新冠病毒”真是爱国又讲政治。为了欢度春节，武汉还在1月18日举办了百步亭社区万家宴活动，并在1月20日向市民开放20万张文旅惠民券免费预约……

**但在1月20日之后，形势急转直下**。

从媒体报道开始出现大规模感染病例，到武汉“封城”、求援，直至全国许多省市启动重大突发公共卫生事件一级响应（更具讽刺意味的是，湖北省政府启动一级响应竟然晚于浙江、广东等省份），中间只有3、4天时间。

从1月20日开始，新闻媒体对这场“新冠肺炎”疫情的参与进入我所说的第二阶段。这一阶段的显著特征，用一句官方常用的话来说就是，舆论的主战场转到了武汉和湖北之外，当地官媒的声音被更加强势的全国性媒体连篇累牍的滚动报道所淹没了。

不过，不出我所料，这一阶段的媒体报道大多服从另一个主基调，就是表决心和讴歌好人好事。简言之，自1月20日以后，中国媒体对受众发挥的主要功能从之前的“安慰”变成了“鼓劲”和“感动”。

这么说吧，1月20日前后的媒体反应的确有很多不同之处，但有一个共同点：**它们做的基本上都不是合格的新闻媒体应该做的事情**。

![](https://i.loli.net/2020/01/29/KaqfbFTGWcps3N1.jpg)

<figcaption>1月22日，广州南站，很多旅客都戴上了口罩。南方日报记者 吴伟洪 摄</figcaption>

### 2

这些日子里所有人都在说，**信息公开是最好的疫苗**。

有报道说，华盛顿大学的两位教授通过真实案例建构的一个数据模型显示，当媒体的报道量增加10倍，SARS和“新冠肺炎”这一类严重危害公共健康的传染病的感染数将会减少33.5%。这种社会学定量研究的科学性和准确性究竟能够达到什么程度，圈内外人士见仁见智，但高质量的自由的新闻报道是预防疾病传播的一个有效手段，这个结论毫无疑问应当成立。

诺贝尔经济学奖得主、印度经济学家阿玛蒂亚·森说过，**新闻是灾难的救助者**。

这次的“新冠肺炎”疫情发生后，世界卫生组织也一再强调了信息透明的极端重要性。所以，央视主持人白岩松也在他备受瞩目的对话节目里重复了这一点。

![](https://i.loli.net/2020/01/29/lwP1HWNuhc2FTbY.jpg)

<figcaption>央视主持人白岩松在节目中说，“在没有特效药的情况下，信息公开是最好的疫苗”。在这次疫情中，白岩松与钟南山的对话，在民众中极受关注。</figcaption>

我在这里就不说什么“不可剥夺的公民权利”之类大话了，对我们来说，这话过于宏阔、遥远而无当了。仅从技术层面功利地看，**保证信息透明畅通对于缓和危机、化解矛盾、解决问题，进而对于社会稳定乃至为政者自身的利益都是有莫大好处的**。

这其中的一个根本原因在于，人都是理性的。任何社会主体，不论是个人、家庭、企事业单位、社会组织……等等，面对一个事件作出一项行动选择，无非都是基于自身所掌握的信息。只有信息越充分，人们作出的决定才越符合他们的个体理性，从而也就越有利于社会公共利益。

英国帝国理工学院的全球传染疾病分析MRC中心立足于境外“新冠病毒”确诊病例数量，再依据这种传染病的潜伏期等病理学数据建立的一个传播扩散模型推测，在1月12日那天，武汉市潜在病例数应为1700例多一点（不确定范围为190-5341）；到1月18日那天，武汉市表现出症状的潜在病例总数应为4000例左右（不确定范围为1000-9700例）……

我不敢说这类研究推测结果一定多么准确，但至少具有一定的科学权威性，也与后来的疫情发展态势吻合。如果类似这样的信息都能全面及时地传递到尽可能多的中国读者、特别是武汉老百姓那里，那么就不会出现直到1月20日武汉大街小巷上绝大多数市民连口罩都不戴、依然在欢快地到处聚会的“盛况”了。而如果湖北省和武汉市政府之后应对疫情的所有决策都事无巨细地通过媒体发布给全国读者，那么，以中国目前的生产和物流能力，也就不会出现“封城”后武汉市内各种物资严重短缺、医院人满为患、医疗工作者不堪重负，而各地民间捐赠都被堵死在仓促关闭的交通要道中的悲剧了。

![](https://i.loli.net/2020/01/29/nQeqBM9Zs6b2Y5V.jpg)

<figcaption>1月23日，航拍下街头空空荡荡的武汉。中新社记者郑子颜 摄</figcaption>

除了有利于在微观层面让尽可能多的社会主体对危机作出及时正确的反应（其中最重要的是自我保护）之外，信息透明公开的另一项重要贡献在于能够极大地提高全社会对于一个危机的参与程度和参与效率，从而通过广泛、充分和深入的讨论，推动决策者在宏观层面形成一个最优的应对方案。

如前所述，武汉的“新冠肺炎”是去年12月8日首次发现的。仅在一个月之后，中国的科研工作者就确定了病毒原因并且公布了病毒基因组序列。**就连国际同行都称赞说，这是世界顶尖的科研效率**。

![](https://i.loli.net/2020/01/29/8KoMZjhurIFU2We.jpg)

<figcaption>2020年1月16日新闻：中国疾控中心副主任国家卫健委专家组专家冯子健说，经过中国疾控中心，中国医学科学院等多家机构和湖北省、武汉市卫生健康部门的密切合作，目前发生在武汉的“不明原因的病毒性肺炎”病原体初步判定为新型冠状病毒，它不是SARS，也不是MERS病毒，它是个新的冠状病毒，它们的病毒基因序列差异比较大。</figcaption>

![](https://i.loli.net/2020/01/29/cUSR7nIpQ2EVx9v.jpg)

<figcaption>2020年1月16日新闻：世界卫生组织驻华代表高力说，公共干预措施控制住了疾病的发展。</figcaption>

其实不仅医学科学，以中国人的聪明才智和今日中国雄厚的经济实力，可以从一开始就帮得到武汉的地方，还有许许多……

然而，疫情发展到眼下这个地步，真可谓“**手握一把王炸，结果打成了末家**”。

### 3

可能还有比“手握一把王炸，结果打成了末家”水平更差的玩家。

除夕那天（1月24日）下午，正在武汉采访的财新记者王和岩发了一条朋友圈，称自己和同事为了核实一家医院医护人员感染“新冠肺炎”的情况，辗转联系了数名医生，均被告知疾控中心有令，医护人员不得接受媒体采访，不得对外泄露疫情。哪怕承诺匿名，承诺保护信源，也不受访……

当天下午还有人称，路过这次病毒的源头华南海鲜市场，顺手拍了张照片，立刻有四名保安围上前来，大声呵斥，要求删除照片。甚至有动手抢手机的，说是“**昨天一名日本记者来拍被抓到派出所去了……**”

![](https://i.loli.net/2020/01/29/qo2whly3FPfUi9I.jpg)

大年初一（25日），武汉《长江日报》在它旗下的新媒体“长江融媒”上发表社论《你的每一句谣言，都在制造无谓的恐慌》，继续严厉指控谣言，称它比瘟疫危害更大，决不能放任不管。“新型肺炎治好了，走了也就走了，但谣言不是，它的危害更大，对城市的伤害更持久。”

![](https://i.loli.net/2020/01/29/VA6LXdxeZUCQu15.jpg)

这一天，还发生了湖北某报资深名记者因微博受处分的事情。

显然，有些人仍然理所当然地认为，安抚人心是当下最重要的事。不然，他们不会在到处缺物资、缺人手的这一刻，把这么多人力布置在华南海鲜市场周边以作监视之用。

因为他们也是理性的。

你确实可以说，这是陈旧思维导致的恶果。那么，为什么许多管理者会形成这样一套“不让或少让全社会知道真实情况总不会错”的错误思维和行为模式呢？大多数人都将其归咎于“不求有功、但求无过”的因循保守的官僚主义作风。但我并不这么看，**我可以举一个鲜明的例子来反驳这种推理**。

我们知道，目前各地官员对招商引资、发展经济的热情可谓空前高涨。但是，仔细想想，外资大规模进入一个地方也是会引起很多麻烦、甚至社会问题的，比如动拆引起的居民对立、环境污染等等。还有，你怎么了解这些外来资本的底细，也许它们主观上怀有（或至少客观上会造成）某些意识形态方面的“不和谐”。

然而，我们很少看见过官员因为胆小怕事而尽量想办法将可能带来“麻烦”的资本拒之门外的情况。相反，他们总是想出许多门道热心帮助这些外来资本，引导他们在国家的政策允许范围内获得发展空间，某些极端情况下，甚至有人为此而明目张胆地违反国家的法律法规。同样的管理者，在招商引资、做大本地GDP这件事情上，怎么一点也不因循守旧？

因此，问题的关键在于对官员考核的导向——经济发展是改革开放40年来从中央到地方的各级党委和政府最主要的追求目标，这就导致对官员的考核也以是否对经济发展作出贡献为最重要的标准。在这一前提下，官员为了赢得光明的仕途，只要是有利于加快发展经济的，他就什么风险都敢冒，因为“经济发展”这一俊可以遮其他百丑。

发展经济需要有稳定的社会环境，许多官员心里并非不明白，社会稳定归根结底要靠缩小贫富差距、建设公平正义的法治来实现，但这是一件投入大而见效慢的异常困难的工程。相反，GDP的提升是有可能立竿见影的。当然，社会稳定的确是至关重要的，也是中央一再强调的头等大事，但到了许多地方官员那里，它的目标就很自然地降低为只要不出事就好。鉴于中国的官员是被上级而不是被本地民众考核的，于是所谓“不出事”在官员那里就被进一步定义为“不被上级得知出事”。沿着这个逻辑，在许多地方，“社会稳定”=“报纸版面（或电视荧屏）上的稳定”，其最终的结果自然是凡事先“不得报道”再说了。

这套类似于掩耳盗铃的做法的代价是，将越来越多的社会矛盾积累和沉淀下来，最终一次次通过“新冠肺炎”这样的重大危机爆发出来。更严重的是，这种管理模式不仅没有起到稳定的作用，反而一手制造了许多本不该有的社会冲突。所有的事件等到揭开和爆发的时候，往往已经造成了难以挽回的惨痛后果。

![](https://i.loli.net/2020/01/29/us9tXTmdJ6Mar2B.jpg)

昨晚，很多人都因为一场新闻发布会而陷入群嘲，对个人责任的追问成为主流舆论，但是我们应该看到，即使个人承担了必要的责任，只要行政思维不变，我们就很难期待下一次考验的安然通过。SARS的惨痛教训并不远，但人类最惨痛的教训，难道不是从未从历史中吸取任何教训吗？

《尚书·泰誓》有言：“天视自我民视，天听自我民听。”

**耳目闭塞也是一种传染病，没有谁能幸免**。

### 4

再来看看这枚硬币的另一面，**新闻媒体**。

除夕那天下午，看见我的老东家《文汇报》的几十位老同事所在的一个微信群里的聊天。

一位上世纪80年代就在全国大名鼎鼎的《文汇报》著名记者，也是我最为尊敬的前辈同事，感慨说，这次的新型肺炎疫情，应该是《文汇报》大显身手的时候。

我不知趣地打岔说：首先，今天的《文汇报》已经不是他那个时代的《文汇报》。总体上说，今天的新闻媒体也不是他那个时代的新闻媒体。其次，话说回来，今天的中国读者也没有谁在乎《文汇报》发表了什么。**没有人期待像80年代那样从《文汇报》上获知什么有价值的重要新闻，因为长期以来《文汇报》也没有在乎过中国读者的关切，这是一个互为因果的过程**。

末了，我还特地加了一句：我这么说，并没有责怪谁的意思。我这辈子服务过很多新闻出版单位，其中《文汇报》是我大学毕业后的第一个工作单位，也是我工作过最长的一个单位，所以也一直是我最有感情的一个单位。

将近两年前的这个时候，我曾经在本专栏发表过一篇文章，题目是《[真正的新闻正在死去，更可怕的是无人在意](http://mp.weixin.qq.com/s?__biz=MjM5ODIwNDIwMA==&mid=2652692426&idx=1&sn=a97418e0702503721ee5941d43eb2bff&chksm=bd26398d8a51b09be72103201fd65f97dec50616552784e7417a882ca4afcf8d15bcced08684&scene=21#wechat_redirect)》。我曾哀叹，今天的新闻媒体在对涉及重大公共利益的事件报道方面的能力，已经衰退到了何种地步！并且以“盲人骑瞎马，夜半临深池”这个隐喻来形容没有了优质新闻媒体的社会。

**我当时怀着强烈的忧虑写道：“以今天的这种舆情状况，若是真的再面对一次SARS，后果简直不堪设想。”**

**不幸一语成谶，还不到两年！**

![](https://i.loli.net/2020/01/29/XWPfz5SrANTkdVJ.jpg)

我现在的心态依然像两年前一样，我不想指责这是谁的责任，更没有雄心和抱负去为现状提供一个解决方案。然而我觉得，当我们看到了危险一幕后，我们总是应该大声指出来。只有更多人关注了，重视了，参与了讨论，事态才会有一线希望。那篇文章在“腾讯·大家”的平台上获得了超过100万的阅读数，证明了读者对这个严峻的现实问题的关注。这是我聊以自慰的，说明希望犹存。

文章发表以后，我还在与“腾讯·大家”专栏编辑的对话（《[专访陈季冰：“新闻已死”刷屏，戳中公众哪些痛点](https://mp.weixin.qq.com/s?__biz=MzIyMzAwMTg2Nw==&mid=2649980250&idx=1&sn=dc64b87293e18ebd6294901259c63e17&scene=21#wechat_redirect)》，）中说过，传统媒体没有能够向受众提供我所谓的“真正的新闻”；但雨后春笋办崛起的新媒体也没有能够如一些人曾经乐观预期或希望的那样，弥补上传统媒体在这方面的严重欠缺。相反，由于新媒体的诞生使媒体市场里的信息海量增长，而受众的注意力又总是有限的，它们反而“稀释”了过去传统媒体偶尔会做出来的一些高质量的新闻。

在本文中我没有讨论到新媒体，但我觉得，看看这些日子以来新媒体对这场“新冠肺炎”危机的反应，大家应该一目了然了。按理说，SARS过去的17年里恰逢移动互联网蓬勃发展，今天的信息和新闻传播技术应该比那个时候进步了一大台阶。然而，我们看到的情况**并没有什么改善**。

需要补充一点：在这次的危机中，新媒体提供了汗牛充栋的观点和情绪，它们中有些很中肯，有些可能没什么道理。但是，**新媒体几乎都没有提供任何有价值的一手信息，这是基本事实**。

![](https://i.loli.net/2020/01/29/apTORjn4Vd9o2JU.jpg)

当然，我也丝毫没有责怪它们的意思。其中的原因，我已经在两年前的那篇文化以及其后的访谈里详尽阐述了。

但不管怎么说，看到极少数像财新这样负责任的传统媒体以及像丁香医生这样具有专业水准的新媒体在这次的疫情危机中作出的贡献以及赢得的声名鹊起，我还是很感欣慰的。说一句本不该在本文里说的话，作为一个与财新多少有一些渊源的媒体人，我为它感到骄傲。

### 5

既然讲到了新媒体，或曰社交媒体，最后我终于还是忍不住想谈一下对所谓“谣言”的看法。

谣言，轻则令人心烦意乱，重则造成各种损失。因此人们憎恨谣言，官方出于各种各样的考量，也经常积极地打击谣言。

然而，就像世界上许多其他事务一样，未经审慎的程序和审查，仅凭善良愿望的行动往往不能达到善良的初衷，有时甚至很容易走到它的反面。随意惩治“谣言”就是这样，它会造成意想不到的严重后果。

所谓谣言，就是**事后被证明虚假（不正确）的信息**。从这个意义上说，谣言无时无刻不伴随着我们的社会生活。气象台发出预报，说今天下午3点某地会有暴雨，结果这场预报中的大雨没有如期而至……这也可视为一个“谣言”。那些因为担心暴雨而改变了原计划的老百姓或企业也会由此蒙受的实际损失，至少，这一则误报会给他们造成不便。

我之所以要特意在“不正确的信息”之前加上“事后被证明”，是因为一句判断性或预告性的话是否正确，总是要在事后才能得到确认。

在我看来，动辄呼吁严厉打击“谣言”的人犯的是“事后诸葛亮”的毛病，他们往往依据一件事情终结以后才搞清楚的结论，不假思索地想象成似乎当时就已经是一清二楚的。

在一个开放社会里，不安全因素如影随形。在当今这个全球化时代，大规模传染病和恐怖主义等“非常规”安全隐患尤其突出。**一个好的社会应该鼓励公民积极参与涉及重大公共利益的治理，而不是让大家冷漠地躲得远远的**。

![](https://i.loli.net/2020/01/29/LU1YIeCvHoxMpNQ.jpg)

想象一下，如果一个乘客在熙熙攘攘的车站大厅里看到一个可疑的黑色塑料袋，观察好久也不见它有主人的样子……如果他是一个关心公益的热心人士，或者哪怕仅仅是一个“好事者”，就有可能打电话向公安消防部门报案。

如果他不知道报案热线号码，或者打过去正好无人接听（这种情况难道不是常见的吗？），他也可能会用手机拍一张照片，上传到微博和微信朋友圈，并加上他自己的几句猜测性话语。

如果他的这条微博和微信被广泛转发，则可能造成不小的恐慌，而且这条信息在多次传播过程中还可能以讹传讹，不断地被升级、加码，最后变得面目全非。

经验告诉我们，类似的情况大多数事后都会被证明是虚惊一场。也就是说，这位乘客发布了“谣言”，且造成了严重的社会影响。按照我先前已经批评过的“事后诸葛亮”的逻辑，他应该受到严厉追查和惩处。

**但一个社会总是以这样的方式去对待那些“好事者”，长此以往，热心公益的人士就会越来越少，所有人都会“理性地”选择多一事不如少一事的不惹麻烦的做法**。

他们在车站里看到了任何可疑物品的第一反应就是尽快离开那片是非之地，并且绝口不向他人提起。但是，哪怕100起报案中只有一起是真实的，忽视它所造成的不可估量的人身财产损失，也是99次白忙活所无法弥补的。

**绝大多数普通公民并不掌握准确判断和正确处理交通事故、易燃易爆物品、地震海啸、伤病急救等所需要的专业知识，他们只能通过第一时间传播信息来参与这一类公共事件**。相信这就是那8位武汉“造谣”市民的初衷，但事实证明，他们的哪怕是猜测，如果得以传播，对社会的影响也多半是正面的。

正如我已经说过的，他们发出的这类“报警”信息中的大部分可能事后被证明是虚假的。但如果混淆了故意的造谣和正当的猜测，那么就**堵死了社会获知安全隐患的信息通路，这终将造成比“谣言”本身更加严重的危害**。

正如我们在这次的武汉新型肺炎疫情发展中已经看到的那样。

![](https://i.loli.net/2020/01/29/L8V2rfMsmaqhDSG.jpg)

<figcaption>春节期间空荡荡的北京地铁。中新网图片</figcaption>

我当然绝不是主张社会应当对谣言听之任之，事实上，的确有许多人在利用谣言谋取不法私利，并对他人乃至全社会的利益构成了威胁。他们理应受到惩处。

但我想要对此表达一个观点：在打击“谣言”的问题上，应当采取被动（消极）的立场，而不是主动（积极）的姿态。所谓应当采取被动（消极）的立场，意思是说，不应该在尚未产生可见的具体后果之前就轻率地裁决某个信息是“谣言”。

这是因为，“谣言”之所以是“谣言”，必定会对社会中的某一些人造成损失，不管这种损失是物质的还是精神的。如果有具体的社会主体认为某些“谣言”危害了自己的利益，给自己造成了损失，他们应当被鼓励用法律手段维护自己的权益。他们可以向法院状告“造谣者”，要求他们赔偿损失，法院会经过一系列调查和辩论程序作出自己的裁决。如果“谣言”的后果严重到一定程度，检察部门也可以介入，对“造谣者”提起刑事诉讼。

**不要忘了，“谣言”之所以需要被惩处，是因为它造成了后果**。如果我在家里对妻子编了一个耸人听闻的谣言，而她根本就没听进去，也没有对任何他人讲过，那么，我的这个所谓“谣言”充其量只是一个无关紧要玩笑而已。

法律意义上的“后果”都是已经呈现出来、并且可以证明的，而不是无法证明的“潜在”可能性。一个人在社交媒体上发了一条可能存在虚假信息的帖子，假如那些有可能因为这个帖子而蒙受损失的对象自己都没有站出来主张自己的权利，那就说明，不管它是不是谣言，它都没有造成什么实际后果。

这时候，如果官方轻率地站出来严惩“造谣者”，这就违反了基本的法治原则。

### 结语

这篇文章花了我整整两天时间，为的是及时追踪最新的信息。

就在结束本文的时候，我公寓楼武汉籍邻居的血清化验报告出来了：阳性。

也就是说，他已被确诊为上海市新增的一例“新型冠状病毒肺炎”患者。目前，有关部门让这户人家的其余几人（未有发病症状）继续自行在家隔离。左邻右舍们更加惴惴不安，更加不知接下来会如何？

得知这一确诊消息后，我内心的第一个念头是：如果他们的老家武汉不是把很多力气花在“打击谣言安抚民心”上，而是尽早公开所掌握的一切真实信息，那么，他们显然不会再考虑回武汉过年……接下来我们公寓楼里的一切事端（包括往后还有可能发生的一系列潜在事端，甚至原本和睦的邻里之间的无端责难和纠纷等等）也就不可能再发生。这个小区现在会呈现出一派祥和稳定，真正的祥和稳定。

整个社会又何尝不是如此呢？

写于2020年1月25-27日。
