---

layout: post

title: 孙立平：垃圾分类中的运动式治理

categories: Archive

date: 2019-08-20

tags: 垃圾分类

image_feature:

description: "可能在很大程度上是给人看的、给人听的，给谁看？给谁听？我想，在很大程度上应该是给上边看、给上边听的。"

---

原文来自「孙立平社会观察」：~~[孙立平：垃圾分类中的运动式治理](https://archive.li/p7Udi#selection-21.1-213.121)~~

---

前一段时间，上海垃圾分类引起了社会舆论的广泛的关注和议论。而且，也有消息说，像北京这样的城市，也很快就要按照这样一种模式来推行。

首先来说说我自己对垃圾分类的基本看法。第一点，现在的垃圾问题确实是成了一个不得不认真对待的问题。有的朋友还能记得，在五月份的时候，我曾经转载了一篇文章，说人类为什么在近两个世纪突然富了起来，对这个问题的答案可能各不相同，但是在最近这两三个世纪，生产力快速的发展，财富大爆炸，应当说这是一个不争的事实。在这样的情况下，人类创造出来的垃圾也越来越多，甚至从某种意义上来说，这些垃圾现在已经快接近地球能够容纳的极限。

第二，在处理垃圾的时候，垃圾分类是一个非常重要的环节。当然也有朋友讲，说世界上有一些地方，有一些国家，他们并不强调垃圾分类，但是可以看到，这样的国家要么是没有能力来处理，要么是它地广人稀，填埋垃圾所需的空间还比较大。但是中国的情况有点不一样，中国虽然幅员辽阔，但是人口众多，人口密度大，如果仅仅靠填埋的话，可能已经无法处理这么庞大数量的垃圾。在这种情况下，经过分类对垃圾进行无害化处理，甚至变废为宝，像一些地方开始进行用垃圾发电，我觉得这可能也是一个势在必行的事情。

第三点，我们现在垃圾的问题，和我们多年来形成的不良习惯是有关系的。有时候，特别是我们到一些很好的风景区，你都能看到，垃圾，尤其塑料袋、塑料包装的那些东西随意乱扔，完全没有一点公益环保的意识。所以有时候我们看了也觉得很生气。这样的不良行为是多年来养成的，在这种情况下，完全靠教育，没有一些强制的措施，比如像罚款等等，可能还真的不行，这个我也都是同意的。

概括来说，第一，科学处理垃圾这是一件好事情；第二，垃圾的分类也是必要的；第三，这当中采取某种强制性的措施，可能也是不得已而为之。我想，上面这几点我们都事先先说清楚。

问题是在于，这样一种本来应当说是利国利民的事情，为什么引起那么多的非议、调侃和批评呢？我觉得和我们推行这些事情、做这些事情的方式有直接关系。概括说，就是大张旗鼓、惊天动地、整齐划一、突然启动、不管不顾、强推重罚。或者换句话来说，这些特征都彰显了一种运动式的社会治理模式。

垃圾分类，本来是一个普普通通的事情，是城市治理当中的一项日常工作。即使原来在这方面抓得不好，抓得不紧，现在要认真抓这个事情了，而且为了把这个事情真正落到实处，要采取一些强硬的措施了，都是正常的。但是就是这么点儿事，给弄成了这么惊天动地的一件大事情。

最近这几年我们做事情的时候，好像就有这样的一个特点，要的就是这样一种效果，要的就是一种惊天动地、引人注目的效果：注意啊，我现在要做什么事情了。为什么会这样？可能在很大程度上是给人看的、给人听的，给谁看？给谁听？我想，在很大程度上应该是给上边看、给上边听的。也就是通过这个，来彰显自己的一种执行力。其实，无论是这次的垃圾分类，还是所谓整治匾牌、招牌或者是改地名，都是日常生活当中常规性的事情，完全可以用一种常规化的、有条不紊的方式来推行，但是在这种运动式的治理方式当中，它往往就给你搞成了一场惊天动地的运动，惊天动地的活动。这是运动式治理的一个首要特征。

还有一个特征，就是突然启动、整齐划一。最近这些年，我们做的一些事情往往都是很突然，有时候，头一天都很难想象到他要做这样的事情。比如说改地名，谁头一天能够想到突然之间把改地名当作一件很重要的事情在整个社会当中来推行呢？完全想象不到，即使是再有想象力的人，也很难能想象到这一点。而且它事先也没有什么这方面的蛛丝马迹，也没有这方面的信息。

然后，这种突然性还表现在一开始就整齐划一。像垃圾分类这个事情，要按照现在这样一个标准来做，其实是有相当的难度的。而且，客观条件也是一个限制。从有关的报道看，上海垃圾日产量是15600吨，根据它的规划，到明年，上海市的垃圾处理能力才能达到每天7000吨，差不多也就是一半还不到。在这种情况下，假如说把这个事情分步来做，在一两年的时间里把最有回收价值的那些垃圾解决它的回收问题，或者是把最有害的那些垃圾分离出来进行集中处理，这当中有个逐步的过程，其推进的难度也许就会小很多，效果也会好很多。但问题是，如果你这么做，就看不出来是在做事情，而只有那种大张旗鼓、轰轰烈烈的方式，才叫做事情。

这种运动式治理的第三个特点，就是不管不顾，不管客观的条件怎么样，我想做就得做，做的方式就是强推重罚。从这里面我们能够体会到一点，就是这个权力现在非常的任性。我就这么做了，我就想这么做，我不用告诉你理由，你不用跟我说对错。如果一时推行不下去怎么办？就是强推重罚，执行不利的就撤职。这次人们把上海的垃圾分类叫做有史以来最严厉的垃圾分类，就是这个意思。但问题是，这种靠强推重罚的方式所推进的事情，最后究竟能不能够坚持下去，是一个很大的问号。

为什么这种运动式的治理方式不断凸显出来，这时候我不由得想到福柯的一个概念，叫“权力的技术”。这样的一种运动式的社会治理方式，无论对权力系统本身还是对社会，其实都是一个训练的过程。训练什么呢？一方面是训练权力的执行力，另一方面是训练人们的服从。
