---

layout: post

title: 996 惹怒程序员之后，他们的抗议引发了全球关注

categories: Archive

tags: 996ICU

image_feature: "https://i.loli.net/2019/04/05/5ca717c0ed9a4.jpg"

description: 最初是一个人的抱怨，但现在已经是一个16万人社区的事，以开源软件开发的方式协作。

---

原文来自「好奇心日报」：~~[996 惹怒程序员之后，他们的抗议引发了全球关注](http://www.qdaily.com/articles/62652.html)~~

作者：唐云路 罗骢

---

![0e4feaf9eaf3c8a8eaf8091f4d5538f1d4fab083.jpg](https://i.loli.net/2019/04/05/5ca717c0ed9a4.jpg)

> 最初是一个人的抱怨，但现在已经是一个 16 万人社区的事，以开源软件开发的方式协作。

一场关于劳工权益的抗议在过去一周里爆发，让中国互联网公司习惯的 996（早九点、晚九点、一周六天）加班时间成为中国乃至全球关注的焦点。

有程序员发起了一个抵制 [996 工作制的项目 996.ICU](https://996.icu/#/zh_CN)。讨论从技术社区开始，在互联网公司的微信群流传开来，蔓延到豆瓣、知乎，很快上了微博热搜，在百度的搜索热度[达到平日的十倍](https://archive.li/o/wzCW6/index.baidu.com/v2/main/index.html%23/trend/996?words=996)。《中国青年报》、《南方日报》的报道被项目发起人标注进了项目的说明页面。

一周下来，事件的影响在海外逐渐升温。最早跟进报道的英文媒体是关注中国的[《南华早报》](https://www.scmp.com/tech/start-ups/article/3003691/developers-lives-matter-chinese-software-engineers-use-github)，它在 3 月 29 日对此事的报道被 Python 之父  [Guido van Rossum](https://twitter.com/gvanrossum) 转发并附上一句评论：“996 工作制是不人道的。”

和前两年以悲剧方式获得全球关注的中国制造业从业者不同，程序员看起来是最不容易为工作环境走向对抗的一个群体。外界对他们的印象主要是收入高、习惯天天加班、办公室放着行军床、生活简单就想着买房结婚。一个典型的中产阶级行业，而中产阶级往往被认为是革命中重要但同时也是阻力最大的阶层。

但不同于其它也要日常加班，强度更大收入更少的行业，程序员有一个说话的渠道。

### 1

http://996.icu 网站的域名最早由一个年轻的程序员注册。

在技术论坛 V2EX 上，这位程序员曾在一个关于工作薪酬讨论的帖子里提到自己毕业于北京一所 211 大学，在一家与百度、阿里、腾讯同级的大型互联网公司工作，刚转正没多久，每月薪酬在一万多元。

之前，他都在论坛里发帖讨论技术，讨论同一个公司不同的团队之间为什么薪资会有差别。但最近，他所在的公司开始实行 996 工作制。

3 月 20 日，他在论坛的域名推广版宣布注册了一个域名 996.icu，因为“工作 996，生病 ICU”。

3 月 26 日后，他在一个职场话题下回复道：“我才感到 996 多么毁人，除了工作就是休息，跟家人沟通都少了。”在那个回帖里，他再次推荐了 996.ICU 网站。

[996.ICU](https://996.icu/#/zh_CN) 就是一个网站，自上而下分成 996 介绍、十七条劳动权益相关法规和相关事件报道三个部分。这三部分自第一天就在，虽然内容在过去一周日渐丰富起来。

![](https://i.loli.net/2019/04/05/5ca71120c4e92.jpg)

<figcaption>http://996.icu</figcaption>

网站作者还在介绍后面加上了一句“Developers' Lives Matter”（开发者的命也是命），模仿美国对抗种族不平等运动的“Black Lives Matter”（黑人的命也是命）。

它的影响力并不来自这个网页。而是来自同样[在 3 月 26 日上线的 GitHub 项目](https://github.com/996icu/996.ICU)。

项目由一个叫 996icu 的匿名 ID 发起，和域名持有者的关系不得而知。但从每天对最多 260 个建议的快速处理来看，这个账号即便是那位年轻程序员创建，现在很可能也不是他一个人在用。

![](https://i.loli.net/2019/04/05/5ca7112188b3d.jpg)

今天，软件开发已经不需要凡事都重新发明一个轮子，用开源的代码可以快速完成一个功能。

而 GitHub 就是存放这些代码的最大平台。程序员们在 GitHub 上管理自己的项目，发起讨论、提交修改建议。

目前 GitHub [有三千万程序员用户](http://www.sohu.com/a/276484595_671058)，托管了大约 8000 万个代码仓库，平均每秒创建的存储库就有 1.6 个。2018 年，[微软宣布 75 亿美元收购 GitHub](https://techcrunch.com/2012/07/14/what-exactly-is-github-anyway/)。

GitHub 上之前也有关于中国互联网公司加班问题的项目，两个月前一个主题是[“程序员找工作黑名单”](https://github.com/shengxinjing/programmer-job-blacklist)的项目上线，这个黑名单在两个月内获得了超过 18000 次“加星点赞”（Star）。

但这看起来更像是程序员在找工作时的一份操作指南。而 996.ICU 则更直接、更简单，从一开始就是一份反 996 工作制的宣言。

这让它迅速引起共鸣。

996 一直没有好名声。最早可以追溯到[2014阿里巴巴怀孕员工加班回家后大出血去世](https://it.sohu.com/20140405/n397797427.shtml)的新闻报道。2016 年，[58同城就因为对 2 万多员工强制 996](https://finance.cnr.cn/gs/20160901/t20160901_523105136.shtml)遭到不少抵制。

今年 1 月，[杭州有赞 CEO](http://www.linkshop.com.cn/web/archives/2019/418163.shtml) 在公司年会上突然宣布全公司强制执行 996，有赞高管表示如果工作家庭不好平衡，可以选择离婚。

更近的，京东 3 月初开始执行 995 工作制度。面对质疑，[京东公关总监刘力回应不会强制要求，但鼓励员工全情投入](https://tech.163.com/19/0312/13/EA2QGIOK00097U7R.html)。

中国互联网公司加班不被认为是特例，但以往有高回报盼头。2017 年，软件业平均薪资 13.3 万，连续两年超过金融业成为全国最赚钱的行业。阿里巴巴纽交所挂牌上市，一夜之间产生了 1 万多名千万富翁。

2018 年开始的上市潮没能重现另一个阿里巴巴。小米 2014 年估值达到 450 亿美元，2018 年上市前预期公司市值能有 800 - 1000 亿美元，四年老员工手中股票价值有望翻倍。但等到 2019 年年初员工可以卖股票的时候，小米市值缩水至 315 亿美元，股票价值也比 2014 年缩水 30%。

而小米已经是过去一年上市公司里表现很好的。[蘑菇街直接以稀释员工股权的手段将员工持股价值缩水为 1/25](https://www.jiemian.com/article/2703824.html)。

甚至工作也不一定能保证。互联网行业早几年有大量风险投资涌入。互联网公司不在乎利润，可以开更高薪水来挖人。但整个 2018 年，中国 VC/PE 募资规模 341.12 亿美元，[同比骤降 74.59%](https://36kr.com/p/5150552)靠烧钱做大规模的互联网公司即便上市也要面对盈利问题。裁员成为一个普遍的做法。

去年 8 月，美图、拉勾网各裁员 20%。10 月，锤子科技解散成都分公司，为它从北京搬去成都的程序员失去工作。11 月，趣店裁员 200 人，不愿从北京搬去杭州也得走；斗鱼裁员 70 人。12 月，知乎裁员 20%，300 人被要求当天离开公司；科大讯飞裁员 20%，回应为末位淘汰；摩拜裁员 30%，称正常调整。今年 2 月，滴滴裁员 15%，2000 人离职；京东先裁员 20% 员工，2 月又裁员 10% 副总裁级别高管。3 月，腾讯中层裁去 20%，[腾讯总裁刘炽平称](https://m.kanshangjie.com/Index/Show?id=161549)为年轻化主动革新。

高强度的工作变得强度更高、曾经可以指望的上市故事愈加渺茫，甚至能工作多少年也在大裁员背景下变得难以确定。

在这样的背景之下，996.ICU 项目上线一小时内就收获了超过 2000 颗星星（GitHub 上的点赞），一天内加星数超过一万，登上了 GitHub 实时热门榜。

更多人注意到了。

### 2.

Anony 就是在 3 月 26 日 996.ICU 上线一小时的时候开始关注的。他自称是一个普通的码农，平时喜欢逛 GitHub。他说自己平时逛 GitHub 就“类似于你们刷微博”。

尽管 Anony 所在公司没有实行 996 工作制，他还是持续对这个项目的进展保持关注，也参与了修改措辞的工作。

在 996.ICU 的讨论区（Issues 区）里，加星即将破十万前，有人留言说，没想到以这种方式参与了大型开源项目。

在社交网络上人们分享自己关于 996 工作的经历、见解以及解决方案。但在程序员社区里，一切都按照程序员们开发开源软件的方式推进着。

想象一栋充满无数会议室的大楼，每间会议室里的白板上写着一项软件的所有代码。GitHub 可以让程序员走入其中开放的会议室，观看白板上的代码、点赞，并按自己的想法进行修改。

但随意修改会扰乱白板上的代码，Github 方便用户将白板上的代码库整体复制到自己账户下，修改不影响项目代码。修改完成后，程序员可以提交“拉回请求”（Pull Request）给项目维护者进行合并，将自己的修改加入项目。

这是目前开源软件在线协作的工作方法，而 996.ICU 的进化过程完全遵照此方法进行。

GitHub 上最初的[996.ICU项目很简单](https://github.com/996icu/996.ICU/commit/87de776ac2c22174cbb3a554e89a0ff2a1fadcc5%23diff-04c6e90faac2675aa89e2176d2eec7d8)：一段 26 行的 Markdown 格式网页文档。

一段段劳动法摘录、五一国际劳动节的由来、国际歌歌词、英文版本是最早的一批更新。

996.ICU 项目的补充、完善，都是由参与者以提交“拉回”请求的方式推进，逐渐成为今天的样子。

这和在论坛留言不一样，如果一个人看到代码就产生不适感，那就无法在这里提出修改请求。

各种细节被快速完善。有人提交请求，称主页面上的案例之一京东的英文版本如果直译 JINGDONG 无法让外国投资者理解，要改成 JD.COM。

大小写、空格、错误链接、全角半角符号错用等问题都被更新，放进 Markdown 格式的文档里，还有人上传了自制的 Logo。

法语、德语、意大利语、日语、韩语、葡萄牙语、巴西葡萄牙语、泰语、繁体中文、越南语、俄语、希腊语等主要语言版本翻译都在项目上线第二天提交。还有人写了[颇正式的文言文版本](https://github.com/996icu/996.ICU/pull/16430/files%E3%80%81)：“996”事制，即日早九至岗，直至晚九点事，每周工作六日。2016 年九初起，续有网爆料称，58同城行全员 996 事制，且周末加班无文……

3 月 28 日是进展飞快第一天，项目有了两个关联项目：[996公司黑名单](https://github.com/fengT-T/996_list)和[955公司白名单](https://github.com/formulahendry/955.WLB)。

黑名单上都是实行了 996 或过度加班的公司，国内的大互联网公司基本在列，京东以超过 1200 票遥遥领先。作者还提出建议，希望在提名的时候加上部门、省区、工资范围，总之给出的信息越详细越好。

黑名单的作者原先将投票设置在一个论坛上，并没有考虑到会有那么多人参与投票，以至于网站太卡，人们只关注到了排名在前面的大公司。目前，这位作者正在建设新的网站，他在项目说明里写道：“因为太卡大家都只关注到了前面的大公司，希望大家能够注意到 996 的群体实际上很大，不仅仅有 BAT ，还有很多小公司。”

而白名单上的公司更多是外企。

955 公司白名单作者 formulahendry 在上海一家大外企做程序员，他的 GitHub 页面有超过 600 个关注者，还坚持用英文写过一段时间技术博客。

像几乎所有外企一样，formulahendry 并不需要 996。他对《好奇心日报》称，996 就完全没有个人的生活时间，最近这个现象越来越普遍，并不是一个好的趋势，他反对 996 的理由与许多人类似：比起一周工作 40 小时，一周工作 72 小时的 996 单位时间的产出不高。

注意到 996.ICU 之后，他觉得与其吐槽 996，不如看看有哪些公司实行 955（一周工作五天，朝九晚五） 的公司。 

项目上线第二天，他创建白名单投票，项目的名字 WLB 是他自创的缩写，意思是 Work Life balance，即生活与工作的平衡。WLB 一天内加星数超过了 1000，上线第二天上了 GitHub 实时热门榜。

投票的雏形是基于 formulahendry 对上海 IT 公司的了解，在接下来的几天里，他利用下班在班车上的时间以及周末的时间维护着项目更新。

虽然 formulahendry 建了白名单，但是项目被创建出来之后就不再是他一个人能决定的事：一切都得按照 GitHub 的方式来。

996 公司黑名单则吸引了更多的参与：一个公司被添加到黑名单的方式与开源项目代码审核没什么太大区别，每个人都可以提交论据，只是提交论据的方式对非程序员来说有一定门槛。论据包括媒体报道、知乎讨论、公司官网公告等。

华为和[字节跳动等公司](https://github.com/996icu/996.ICU/pull/24767)是否能够上榜都引发了众多讨论。在要求“删除黑名单字节跳动”的请求下有 51 组对话，要求删除的人和不同意删除的人各自举证。

发起删除请求的用户给出了两点理由：1. 公司虽然下班晚，上班也晚，算上午饭、晚饭后的休息时间，实际工作时长并没有一天 12 小时；公司实行大小周，但是小周周日加班给加班费；2. 猝死事件的程序员是刚从腾讯跳槽到字节跳动不久，不能武断归咎于字节跳动加班。

反驳方指出“说的好像 955 的公司不午休不吃饭一样。”接着还有反驳者给出加班费计算方法的猫腻，比如周日加班按 1.2 倍工资而不是 2 倍工资计算。

一个请求能否通过，实际上是以一种简单的投票实现的。删除字节跳动的请求有 8 人支持，269 人反对。最后 996.ICU 项目负责人拒绝了删除字节跳动的请求。

虽然项目负责账号可以对请求作出判断，但由于开源项目的可复制性，如果项目发起人背离社区大多数人的诉求，程序员们可以很容易转而支持另一个在这个基础上分出来的项目。

从一个个人项目，演变为社区项目之后，决定项目发展的就不再是发起人，而是所有参与贡献的人共同决定的结果。这些都是开源软件开发的基本方式。

就像比如 Linux 系统最早是 Linus 一个人的作品。但随着全球开发者的加入，有 1.5 万开发者和超过 1400 家公司添砖加瓦。现在 Linux 远不是 Linus 所能控制的，它的管理由一个专门的基金会所负责。

996.ICU 也没什么区别。不论是谁启动了这个项目，现在它已经不再是一个人决定的事。

### 3.

讨论变得敏感，是从 3 月 29 日项目的[issues被关闭开始](https://github.com/996icu/996.ICU/issues)。

仓库下的讨论区（Issues）突然被关闭，也引发了不少讨论，比如 issues太多（过了十万）、太多广告，还有人贴出白宫请愿的号召截图怀疑是政治原因。几小时后，作者贴出解释称是主动选择关闭。

不过这对讨论没有太大影响。项目上线之初，有人发出各地微信群的二维码，与此同时就有人回应说程序员应该用程序员的工具，而不是用 QQ、微信来沟通。于是程序员常用的即时通信工具 Slack、游戏即时通信工具 Discord 都被用起来、国内不能直接访问的通讯工具 Telegram 上也出现了 996.ICU 讨论组。

996.ICU 的 Slack 讨论频道在五天内吸引了 1000 多名成员，成员自发将 Slack 群组划分成了公告、招聘、讨论、中文、英文、城市等数个频道。在 Slack 频道里讨论最多的，是劳动权益受到侵害之后如何维权。

[一名拥有二十年经验的程序员陈皓](https://www.zhihu.com/question/317847010/answer/636013957)在知乎回答了问题：“如果想抵制 996，除了利用 GitHub发起抗议，还有哪些巧妙的方案？”，提出通过法律手段、政府信访、集体抗议等途径。

在 Slack 群组讨论中，他的解决方案遇到了不少阻力，一些成员质疑劳动仲裁的效率，还有一些成员则担忧信访手段可能招致政府机关的强制手段。

在完善了措辞、不同语言版本和黑名单、白名单之后。996.ICU 从上周末开始的最大进展是“反 996 软件授权协议”从想法到落地。

3 月 27 日，[一个想法被热切讨论后采用](https://github.com/996icu/996.ICU/pull/15642)：设计一种关于劳动保护的软件授权协议——996ICU 协议，如果这个协议被兼容进各个开源项目的授权协议，实行 996 工作制的公司不得使用该开源项目，就可能给公司带来实际的约束作用。

劳动法一直在，但执行是问题。大互联网公司往往为一个城市解决数万就业，有些还提供数十甚至上百亿利税。理论上地方法院，比如深圳当地法院应该公平对待腾讯、华为和它们的员工，但这是理论上。

而软件授权协议是软件行业内的一个约束。简单来说，软件授权协议就像是一本书的版权声明。在项目开发中开源软件的使用不可避免，使用开源软软件不需要付费，但是需要遵守作者写在授权协议中的条款，如果公司或个人使用了开源代码，但是没有遵守条款，作者可以据此提起诉讼，要求赔偿、停止使用代码。

这个想法被上千人点赞，400 多人参与了该协议的讨论。

但协议怎么写还没人想好，一开始只有这样三行：

1.   The 996ICU License (996ICU)
2.   Copyright © 2019 <copyright holders>
3.   <wait to be filled...>

3 月 30 日晚间，伊利诺伊大学厄巴纳 - 香槟分校法学博士 Katt Gu 花了一夜时间起草了授权协议。这个版本在常用的 [MIT 开源授权协议基础之上](https://github.com/kattgu7/Anti-996-License/wiki)改编。协议一共三条，在所有协议都会有的惯例版权声明条款，Katt Gu 增加了两条内容：

> * 个人或法人实体必须严格遵守与个人实际所在地或个人出生地或归化地、或法人实体注册地或经营地（以较严格者为准）的司法管辖区所有适用的与劳动和就业相关法律、法规、规则和标准。如果该司法管辖区没有此类法律、法规、规章和标准或其法律、法规、规章和标准不可执行，则个人或法人实体必须遵守国际劳工标准的核心公约。
> * 个人或法人不得以任何方式诱导或强迫其全职或兼职员工或其独立承包人以口头或书面形式同意直接或间接限制、削弱或放弃其所拥有的，受相关与劳动和就业有关的法律、法规、规则和标准保护的权利或补救措施，无论该等书面或口头协议是否被该司法管辖区的法律所承认，该等个人或法人实体也不得以任何方法限制其雇员或独立承包人向版权持有人或监督许可证合规情况的有关当局报告或投诉上述违反许可证的行为的权利。

Katt Gu 关注新技术立法，也著有关于中国[特定领域法律与实践鸿沟](https://scholar.google.com/citations?user=PTcpQwcAAAAJ&hl=en&oi=ao)的论文。

3 月 29 日晚上，Katt Gu 的丈夫，[一直关注软件版权演进](https://www.qdaily.com/articles/23804.html)的创业者 Suji Yan 在看到 996.ICU 之后催促她起草一份协议。Gu 回忆说最初她并不愿意。

“因为我本人是一个工作狂，但是仔细想想这是一个关乎自愿选择的事。”Gu 对《好奇心日报》表示，她的顾虑还来源于专业，这份协议起草涉及 IP 法、劳动法以及国际公约等领域的研究，她从未有过相关经验。

起草协议之前，一位律师告诉她，要做好这份协议，得先研究十年劳动法、再研究十年 IP 法，或者在几个涉及的领域各找十个专家来讨论、研究，再拟定草稿。

但是 Katt Gu 觉得协议的实用效果远小于宣传效果，今天最重要的那些开源协议一开始也不是以那样的立法方式做出来的。

经过一夜研究，她决定以最简单的通用法（Common Law）为基础，草拟一份协议草案。而起草的模版则是简单且应用广泛的 MIT 开源协议。

这份协议以及协议期待产生的效果，都是相当理想化的。

根据 Suji Yan 所设想的最理想状态，协议可以对中国互联网公司有一个约束。他的逻辑是今天软件开发基本上已经不可能不用开源代码——微软一度都是开源软件的最大贡献者。当足够多的开源项目用了 996ICU 协议，企业强制 996 就等于自己的产品违反协议，开源代码拥有者就可以起诉该公司。哪怕在中国大陆起诉艰难，这些公司基本都在香港或美国上市，也可以在其它地区发起诉讼。

不过解释完之后，他自己也说“这当然是一个极其理想化的设想”。

“本来觉得我们不做会有别人做，但是现在觉得还是需要更多人关注。”Katt Gu 说协议公布之后收到一封感谢邮件，“感觉就像看医生收到那种‘妙手回春’的锦旗。”

对协议约束力持怀疑态度的人很普遍，而反对者也不少。比如目前 GitHub 上第三大项目的创作者尤雨溪在微博上表示自己个人反对和谴责 996，但是也反对在开源项目许可证中包含 Discriminatory Clause（禁止部分用户使用的条款），或是利用开源项目做任何形式的政治博弈。

“我个人有个人的看法，但项目是中立的。Vue 的许可证不会禁止任何人使用，现在不会，以后也不会。”他在微博上写道。Vue.js 是一个开发网页用户界面的框架。

但添加反 996 许可证的项目[在不断增多](https://github.com/996icu/996.ICU/blob/master/awesomelist/projects.md)。目前已经有 75 个开源项目添加了许可证，其中大部分是个人开发者维护的项目，但也有多个点赞数在四五千以上，有一定规模、被很多公司使用的开源软件项目加入。而和 Vue 相关的数个插件项目也加入了反 996 许可协议——任何项目开源扩大之后，就不再是作者一个人决定的了。

Katt Gu 称接下来自己的协议修改要它与更多的主流开源软件协议兼容，这样才有希望被更多开源项目所接纳。

“我自己只想把这个协议写好，写好估计就没有我啥事了，如果要写细，可能要花两三年。”Katt Gu 说做完这个应该就不会管了。Suji Yan 则补充了一句：“还给社区。”

社区有一个大目标。4 月 1 日，有人号召把反 996 协议加入 GitHub [官方收录协议](https://archive.li/o/wzCW6/www.qdaily.com/articles/ChooseALicense.com)当中，这样新开源项目就可以很容易把协议加入项目。

更长远的目标是让它被 GitHub 高亮显示，这样任何项目在创建选择协议时都有机会看到它。

这些都不容易，尤其是在主页高亮，需要超过 1000 个公开项目使用该协议，3 个明星项目使用、OSI 和 GNU 批准。

作为开源软件的推动力量，理查德·斯托曼（ Richard Stallman）在 1985 年发表《GNU 宣言》，提出所有软件都应该贯彻自由软件的精神——运行、复制、发布、研究、修改和改进该软件的自由。

但从一开始，这个运动就没有停留在技术或者免费用软件的层面，发起者认为大众都能接触到的应用都应完全掌控在用户自己手中。如果 996.ICU 的贡献者们计划成功，这将是开源软件届第一个被认可的约定劳动权益的协议。

一周不到，对 996.ICU 的反击已经来了。

没有公司敢直接攻击 GitHub。2015 年的持续攻击[没有成功](https://www.qdaily.com/articles/7938.html)。现在它是微软的财产，商业公司攻击它就更不明智。

攻击者们用了自己最习惯的手段，屏蔽。

3 月 30 日开始，Slack 讨论群组中开始有人报错：北京地区微信内无法打开 996.ICU 的 GitHub 页面，更多的测试显示，这不是孤例。

QQ 浏览器称这个唯一公开诉求就是让公司遵守劳动法的网站包含欺诈信息。微信显示的理由则是“该网页包含违法或违规内容，为维护绿色上网环境，已停止访问”。阿里巴巴旗下的 UC 浏览器和 360 浏览器都将该页面认定为包含违法信息的网站。最独特的猎豹浏览器打开这个页面会弹出提示称“网站含有大量淫秽色情信息”。

使用百度搜索 996，中文版搜索结果里找不到 996.icu 网站和对应 GitHub 页面的链接。

和以往不同的是，这一次它们并不能直接封杀 996.ICU 的存在，也没法让讨论它的渠道消失。

题图来自 [phil41dean](https://www.flickr.com/photos/phild41/6297709618/) on [Visualhunt.com](https://visualhunt.com/re3/0ba960cb)/ [CC BY](https://creativecommons.org/licenses/by/2.0/)
