---

layout: post

title: 让世界变得好一点，这是我的做法和思考

categories: Archive

tags: 媒介素养

date: 2019-03-31

image_feature: "https://i.loli.net/2019/04/02/5ca2428617000.jpg"

description: 在这个年代控制信息的一个主要方式其实就是消耗注意力，让你在各种信息中疲于奔命，无暇去辨识。

---

原文来自订阅号「新闻实验室」：~~[让世界变得好一点，这是我的做法和思考](https://mp.weixin.qq.com/s/3GurWG5qvqEJXJQ4Ex5XhQ)~~

---

![01.jpeg](https://i.loli.net/2019/04/02/5ca243ad8d299.jpeg)

>【按】2月20日，在香港浸会大学兼职教课的张洁平邀请我以Skype连线的方式和同学们做一次分享。在分享中，我回顾了自己在过去几年中做的一些主要的事情，以及背后的一些思考。这对我来说也是一次很好的整理。今天与各位分享我修订之后的分享实录。录音稿的初稿由蒋玮琦同学协助整理，在此致谢。
>
> ——方可成

![02.jpeg](https://i.loli.net/2019/04/02/5ca243d15d2d6.jpeg)

<figcaption>远程连线课堂现场</figcaption>

## 让更优质的信息指引我们作出更明智的决定

谢谢洁平。大家好！因为时差的缘故，我今天起了个大早来参与这次远程分享。这是一次很好的机会和大家交流，我自己也可以做一些梳理和思考。听说你们最近在讨论翟天临事件，讨论到知网，讨论到知识民主化，洁平跟我说：你做的那么多事情和这些都可以串起来，来课上讲讲自己的学思历程吧。

她刚说的时候我内心是拒绝的：这三四十分钟能讲完我目前为止的人生么？

但后来我自己又仔细想了一下，可能差不多真的可以。不管是我的主业还是副业，我当时为什么要学新闻，为什么去《南方周末》工作，为什么到宾大来读博士，为什么做政见，为什么做新闻实验室，甚至为什么前段时间写了《[搜索引擎百度已死](https://mp.weixin.qq.com/s?__biz=MjM5NDEwNjQ0MQ==&mid=2654281772&idx=1&sn=e6458c0f92121b67c8d3345e7d8fa2ba&chksm=bd4d5d0a8a3ad41cfcbbe1ba22bc438bc9efa14a4a71e41b0d5c0ba4d0fdb560da0cece46eef&scene=21%23wechat_redirect)》这篇文章，可能都可以串起来，都可以用一个大的关键词来解释。

这个词就是**informed citizenry**。我最早看到这个词是十年前的时候，2009年，当时奥巴马刚刚上任美国总统，他到中国访问，只接受了一家媒体的采访，那就是《南方周末》。

其实采访本身是很乏味的，问题都是审过的，但是采访完之后奥巴马和编辑记者亲切合影，还写了一段话，我觉得他的那段话也可以很好地解释我在做的事情：

[![](https://i.loli.net/2019/04/02/5ca242821b4b8.jpg)](https://archive.li/qGf3u/0584829c8317c00fe3a7cddc406ce8c0c2ac9545)

> _To the Southern Weekly and its readers–_
>
> _I look forward to continuing the ties between our two countries, and congratulate you for contributing to the analysis and flow of vital political information. An educated citizenry is the key to an effective government, and a free press contributes to that well-informed citizenry._
>
> **致《南方周末》及其读者，我希望继续维护我们两国间的关系，并祝贺你们在传递关键的政治信息和分析上的贡献。受过教育的公民是建立一个有效率的政府的关键，而自由的媒体对这一知情的公民群体大有助益。**

这段话说得非常好。这种“知情”（informed）非常重要。**我们每个人每天在这个世界上都会做很多决定，作出决定的基础就是我们是否能充分掌握信息**。比如中午去哪里吃饭、要不要去香港读研究生、要不要和某个人谈恋爱、选择从事怎样的工作，等等等等，我推荐大家都在尽量知情的情况下作出决定。

除了个人生活的决定，还有公共参与的决定——你要不要在网络上发言，你要怎么发言，你是否参与小区的业主委员会，是否要给某个公益项目捐钱，是否要参与提倡低碳环保的活动，等等，这些也都要以知情为基础，不是闭着眼睛决定的。在西方民主国家，这些决定还包括选谁当总统。美国人上一次的决定可能做得就是糟糕的，这在一定程度上是因为选民在做出决策的时候对候选人的政策不够了解，受到了很多虚假信息的误导。

所以对我来说well informed citizenry是一个非常重要的线索。我们都希望这个世界变得更好，那么如何让它变好？有很多具体的方式。比如你可以给社会创造更多的财富，让更多人脱贫，或者可以开发更便捷的日常用品，或者创造更多的艺术作品。而**对于我来说，让世界变得更好的方式就是让大家更加知情，让大家拥有更优质的信息，同时这些信息能够被接受和消化，这样我们的社会作为一个整体就会作出更明智的、更有利于人类发展的决定，我们就能拥有更多的共识和宽容、更少的割裂和仇恨**。

可以说，这就是目前的我对自己在公共生活中的角色的一个比较基本的定位。

刚刚说到我是2009年看到这句话的。其实inform citizenry是一个英文表达，在中文里没有直接对应的说法，翻译过来都蛮费劲的。但我会想到在那之前的五年，也就是2004年的时候，我进入北大新闻与传播学院读书，其实很大原因也就是这个。我为什么学新闻？为什么做记者？因为记者的职责是挖掘和传播真相，让大家对这个世界更加了解。这样看来，我走上新闻这条路的原因也就是朝着informed citizenry去的。

![](https://i.loli.net/2019/04/02/5ca2428319c81.jpg)

<figcaption>记者的职责是挖掘和传播真相，让大家对这个世界更加了解</figcaption>

2013年，我离开业界进入学界，开始研究传播，其实也是沿着这样的路径。我现在的一个研究领域是政治传播，这是传播学和政治学的交叉。政治传播的研究有一个基本的假设，就是我们刚才说到的：知情的公民是一个民主社会运转的基础。

中国官方的一些宣传经常会说西方的民主制度有很多问题，一个经常被提及的说法是：“民主不是选主。”虽然这是带有目的性的宣传，但这句话本身是有一定道理的。民主确实不是选主，把民主等同于选举投票，是一种过于简单的理解。**选举要能运行，它背后有一个非常重要的假设是：大家投票的时候真的是知情的、是经过思考的**，你需要知道这个候选人当选之后准备干嘛，你需要知道谁当选对你是有好处的，你知道谁当选是对世界有好处的，这时候才能做出更好的选择。

也就是说：民主制度在选举之外，还需要有一套机制来支持，这些机制包括对公民基本权利的保护，也包括如何保证选民的知情。

![](https://i.loli.net/2019/04/02/5ca24283d3d2b.jpg)

<figcaption>美国国父之一杰弗逊说：知情的公民是健康民主机制的核心。</figcaption>

我们回头来看一下奥巴马那段话的最后一句——他强调的是自由媒体的作用。他说，自由的媒体对知情的公民大有助益。

的确，自由的媒体是达到well informed的重要条件。但十年之后回头看，我不知道如今的奥巴马本人会不会想在这句话后面加点什么，尤其是在经历了2016年被假新闻淹没的大选之后。我们看到美国仍然有言论自由，而且这种自由更多强调的是“不去干涉就好了”。但是，这种“不干涉”的理念现在却面临着假新闻的挑战，很多传播假新闻、阴谋论和仇恨言论的人高举的大旗就是“言论自由”。待会儿我会具体说到，现在大家可以先想一下：奥巴马这句话是否需要加更多的东西在上面？除了自由之外，我们还需要些什么才能保证informed citizenry？

## 将学术界的思想资源引入大众视野

说回我自己做的事情，在学校和报社之外做的事情。2011年下半年的时候，我发起了政见CNPolitics这个团队，这个和大家最近讨论的知网是直接相关的。

发起政见的时候我还在《南方周末》工作，最初有这个想法的人其实不是我，是我的编辑马昌博。他后来去了《壹读》做主编，现在做一个叫“视知”的科普视频项目。他在《南方周末》提出做政见的想法之后就跳槽了，当时我觉得自己可以来接手这个，因为这个项目的基本定位是：把学界对于中国政治和社会的研究用通俗易懂的的方式介绍给读者。我为什么有兴趣来做这个呢？因为我一直觉得，学界的思想资源和大众在媒体上看到的言论文章之间存在着严重的不平衡。

一方面，学界有很好的研究在那里，但是往往在英文写成的几十页的论文里，很难被普通人看到；另一方面，大众媒体上的观点文章质量参差不齐。特别是之前有一种文体非常流行，叫做时评，我不知道大家是不是需要看这些，或者新闻课要不要写。我觉得时评在一定程度上启迪了民智，但我后来对这种文体的评价其实蛮低的，因为那段时间看报纸上经常出现的时评作者可能翻来覆去就那么几个人，而那些人写时评的方式就是看到一则新闻后，就把新闻套用在他们之前常用的几个框架里面去，快速地在一天之内炮制出来，甚至一天可以炮制很多篇。我觉得这些新闻只是用新出现的材料（这些材料还是记者采访到的、并不是时评作者贡献的）套到大众喜闻乐见的框架中，看完之后大家可能“爽”了一下，但是没有更多的启迪，因为这些时评中没有什么新的思想。

当时的时评作者还往往是中年男性，其中有些人在某些议题上的观念其实相当落后，相当油腻。最典型的例子，就是这两年暴露在大家眼前的五岳散人的性别歧视、侮辱女性言论。你们可能不知道，在当年，五岳散人可是时评界的一个鼎鼎有名的存在，占据着相当多报纸的时评版面。

![](https://i.loli.net/2019/04/02/5ca2428531640.jpg)

<figcaption>五岳散人，油腻的“时评家”</figcaption>

这些就不多吐槽了，反正当时我想解决的一个事情就是：**一方面有好东西在那里，但是大家看不到；另一方面，在大众媒体上大家能看到的东西，其实很多是质量不太行的。**

所以我想做的就是把好的东西引进到稀缺的平台上来。政见做的就是这样一件事。后来正式做起来的时候，因为一些原因，并没有设在《南方周末》里面，而是做成了一个独立团队。

洁平给大家看了[我当时写的关于政见的理念的文章](https://mp.weixin.qq.com/s?__biz=MzI3MDE0NzI0MA==&mid=402025265&idx=5&sn=51dc53a3d6b0f7de2f0b607d3fd8afd3&scene=21%23wechat_redirect)，里面提到了Aaron Swartz这个人。他的自杀在美国是引发强烈震动的一件事。他做的事情和我上面说的这些有一定的联系，他的基本理念也是有那么多好东西大家看不到，这些学术出版商收很多钱，你下载一篇论文最少十几美元，贵的可能要几十美元，这算什么道理？所以他就去大学图书馆把这些论文都下载下来，然后免费开放给大家使用。

这是他的基本理念，有人觉得这是在违反规则、侵犯学术出版商的利益。其实，这里面有一个重要的问题就是：这种暴利是否公平？是否正义？

学术出版商的利润率很高，赚的钱夸张一些说是无本万利的。因为大家看我们写学术论文，发表在学术期刊上，是拿不到任何稿费的。而且在论文发表的过程中，还需要多位匿名审稿人的审稿——也就是说，你给期刊投稿后，期刊需要找两三个该领域的专家来仔细评审。审稿人的投入也很大，但也是没有任何收入的，也是完全的义务劳动。在这个过程中有编辑和他们的助理，也许从出版商那里拿到非常少的补贴。但整体来看，在整个论文的出版流程中，出版商基本不在里面负担什么成本。

那么论文的成本是谁负担的？其实是纳税人负担的。

学者写论文、审稿，拿不到稿费，但我们总要活下去对吧。那我们无非就是拿着大学的钱，大学养着我们来写这些东西，或者是我们从政府申请到的课题经费来支持我们写这些东西。政府经费对于开展研究来说尤其重要。

所以说，**学者的知识生产基本上是一件由公共财政支持的事情。**不管说你是写还是审还是关键的研究环节，基本都是公共财政支持的。但是当你写成了论文发表之后，公众要去看你的研究成果的时候，却需要花费很多钱去看，这本身就是一件非常不公平的事情。

![](https://i.loli.net/2019/04/02/5ca2428617000.jpg)

<figcaption>Aaron Swartz</figcaption>

Aaron Swartz做的事情，就是要让这些由大众支持的研究，可以被大众免费看到。我很支持这样的想法，但是我觉得这还不够。我们可以做一个极端的假设：**如果****全世界的论文都免费下载了，这个世界就会变化很大么？**我觉得会有些变化，但是可能也不是会太大。

可能某个国家的神童，上中学的时候就把这些期刊上的论文免费下载下来看过一遍，然后发明了一个火箭什么的。这种事情是有可能的，但是往往只出现在那些最有学习能力和学习意愿的人当中。绝大部分人还是不会去看这些论文的，即便是免费的。特别是在中国，你要去看英文的期刊是很困难的，[你连英文的媒体都不愿意去看](https://mp.weixin.qq.com/s?__biz=MjM5NDEwNjQ0MQ==&mid=2654281730&idx=1&sn=c1e673ac64c4b8ee6b8a5210a22427a2&chksm=bd4d5d248a3ad43242a9056b9b8c567d72c0cead764531692778ec7601e25cf2ee50472fc892&scene=21%23wechat_redirect)，何况是英文论文？

所以即使免费，中间还是有一道墙在那里。**即使没有任何的钱的问题，但是也有意愿和能力的问题**。所以政见团队想做的实际上就是解决后面这个问题，如何让大家能够在现有的阅读能力和意愿的基础上尽可能吸收学术界的思想资源。

这件事在国外也有一些人在做。一个比较有名的项目叫做Monkey Cage，是一群政治学家自己发起的通俗博客，后来被《华盛顿邮报》买下来了，所以现在是《华盛顿邮报》的专栏。还有一个叫The Conversation，是一个非营利媒体，就是来介绍学术界的研究成果，有时候是学者自己写，他们也有记者去报道这些成果。还有一个叫Jstor Daily。Jstor是一个学术的数据库，Jstor Daily是学术出版商自己做的事情，它等于是一个推广，用Jstor里面的论文为基础，邀请一些作者把里面的观点介绍出来。

国外的这些项目，要么是非盈利的，要么是出版商支持的，要么本来是自娱自乐的事情后来有了金主的支持。政见团队则是志愿的、非盈利的运转模式，因为我们没有出版商、基金会或其他金主支持，这样很自由，但也会出现很多问题，比如团队如何来维系。如果大家长期关注政见会发现最近的更新频率也下降了不少。确实一个完全志愿的团队维持了这么多年之后想再继续下去就是一个挺难的事情。[欢迎新鲜血液加入我们！](https://mp.weixin.qq.com/s?__biz=MzI3MDE0NzI0MA==&mid=402053026&idx=5&sn=c7603f7041907db7e75122063f26b329&scene=21%23wechat_redirect)

![](https://i.loli.net/2019/04/02/5ca242868c521.jpg)

<figcaption>创建政见的时候，这个世界上还没有微信</figcaption>

一个解决方式可能是商业化，但我们一直不想去尝试，因为这中间就会涉及到度如何把握的问题。中国尝试做学术通俗化的除了政见之外，还有一个项目叫做浪潮工作室，包括大象公会的一些文章也有这个意思，也是基于学术界的一些研究来写的。这些项目的一些文章写得很好，但也有一些文章呢，学界的一些人并不是特别赞赏。因为他们是商业化运行的，并且本身不是学术圈中人，有时候选择的内容不太可靠，中间还涉及到很多标题党的推广方式，选择做更能有卖点的内容。这样你当然能大量地提高传播度，但是中间你可能会形成某种程度上信息的扭曲。它们都没有达到像Monkey Cage或The Conversation那样的水准。

这当然是一个艰难的平衡。因为如果你做得太谨慎，是会影响到传播度的，最后没有多少人看到，比如政见现在就有点类似这个状态，看我们的更多还是学术界的人或者学生，没有到达更广泛的大众。但是如果扩大的话我们势必要在内容上做一些妥协，中间如何把握是一个一直需要考虑的事情。

## 培养大家分辨信息的能力

下面我再来说一下新闻实验室这件事，新闻实验室是我做的一个公号，它的主要定位是普及媒介素养，也就是获取和使用信息的能力。

这个就会联系到我之前说的一个情况，那就是现在互联网上有大量丰富优质的信息。一个没有上过大学的人，如果善于利用互联网的资源，是有可能通过自学达到甚至超过一个大学毕业生的水平的。

但问题是：**发现这些优质信息的能力不是每个人都具备的。这个年代的信息爆炸，可能更多是垃圾信息的爆炸**。大家生活的这个年代可能很难想象2000年左右洋溢着的非常乐观的情绪：我们接上了信息高速公路，接下来是一个信息唾手可得的时代。大家可能很难想象信息匮乏的时代获取信息多么困难，然后出现了被称为“信息高速公路”的互联网，大家非常乐观，觉得之后一定会越来越好，因为信息极大丰富了。但我们现在能看到，是的，信息丰富了，但我们看到更多的可能是垃圾信息。

**信息爆炸之后，反而更难选出更优质的信息。**大家学新闻传播，肯定会听过“数字鸿沟”（digital divide）的概念。“数字鸿沟”有两个阶段，第一个阶段是：你有没有条件上网？之前这是困扰很多人的问题，因为之前大部分人都没有设备。但现在基本上所有人都有智能手机了，这个鸿沟已经基本上不存在了。

那么第二个阶段的数字鸿沟就是：**你有没有技能去使用互联网？能不能让互联网最有益的那一面为自己服务？**现在，站在数字鸿沟这头的人，可以充分利用互联网的优质信息，实现自我成长；而站在数字鸿沟那一头的人，则很容易陷入垃圾信息当中，每天花很多个小时在手机上，却基本上一无所获，甚至获得了虚假的信息。

![](https://i.loli.net/2019/04/02/5ca24287c2f2d.jpg)

<figcaption>现在大家基本上都有可以上网的设备了，使用设备的能力差别就成了现在主要的数字鸿沟</figcaption>

新闻实验室想做的就是提高大家的信息获取和使用能力。也就是说，**政见更多是想要生产更多的好内容，而新闻实验室是在消费者一端，帮助大家提高辨别能力。**这种能力并不是天生具备的，它是需要后天学习和培养的。

比如新闻实验室会有“[媒体食谱](https://mp.weixin.qq.com/s?__biz=MjM5NDEwNjQ0MQ==&mid=2654281665&idx=1&sn=b6b0f19474409e529a48c32b33555051&chksm=bd4d62e78a3aebf1f586ab79232fbe3a7b159e36f01e9c66cdf7d3ef88bc7f133cca3633ed90&scene=21%23wechat_redirect)”这样的栏目，邀请那些在获取信息方面非常有心得的人分享他们是怎么获取和使用信息的，他们是根据什么原则来筛选内容的。目前已经请了十几个人来分享。

在很大程度上，提高媒介素养的过程就是一个不停地和人的一些固有的劣根性去斗争的过程。我们为什么愿意接受错误的信息？为什么会被错误的信息欺骗？是因为我们脑子有问题——也不是说脑子有问题，是说我们脑子有从几百万年前遗传下来的固有的认知偏见。比如我们对负面的信息特别敏感。这可能是因为我们在远古时代为了生存下来，一旦有风吹草动就认为有野兽出现就赶紧要逃走。现在虽然早已不是那个时代了，但是我们固执的偏见还是写在脑子里面。再比如我们喜欢接受简单粗暴的逻辑，而不愿意接受复杂模糊的解释，这可能也是因为远古时代的我们需要快速行动，没有时间去考虑事物的复杂性。

所以，加强媒介素养是要和我们自身的种种偏见去作斗争的，这个是需要主动努力的事情，不是那么简单能发生的。而且可能需要从小普及，所以[一些欧美国家可能从小就会有媒介素养课](https://mp.weixin.qq.com/s?__biz=MjM5NDEwNjQ0MQ==&mid=2654281801&idx=1&sn=ef94f0adc051c4b27f02110279d730ae&chksm=bd4d5d6f8a3ad47957b3df5eac5d67e49d24b5456039d22ec5f29d45ec87efe9f4805ffeeb2c&scene=21%23wechat_redirect)，从小普及如何来分辨信息。到大学之后再做，说实话已经有些晚了，但做总比不做好。

## 让真理胜出，平台需要主动负起责任

政见和新闻实验室都在继续做，但我也越来越意识到：**无论是从生产端努力，还是从消费端努力，都有它的限度在那里**，我们可能还要从其他角度来思考如何提高信息质量，如何拥有更知情的公民。

去年，[《科学》杂志发表了一篇论文](https://mp.weixin.qq.com/s?__biz=MjM5NDEwNjQ0MQ==&mid=2654280679&idx=1&sn=388015d108a38a738f4e987dbb173e18&chksm=bd4d66c18a3aefd7459952a18f2a15312906a1971c8cd502b212d350cc0844aed44c1377f008&scene=21%23wechat_redirect)，研究Twitter上面的真新闻和假新闻谁能传播得更广。结果是：假新闻比真新闻跑得快多了。这也是一个符合我们日常的社交媒体使用体验的发现——**之前我们说“造谣动动嘴，辟谣跑断腿”。其实不光是跑断腿，而且是“然并卵”**，因为辟谣文章的传播量一般都是大大低于谣言的传播量。

这个现象就给我们此前的一个基本的理念提出了一个挑战，这个理念叫做“观点的自由市场”。它的基本假设就是：我们让所有观点自由竞争，真理就会自然胜出了。只要不去干涉言论，大家就可以自然而然地获得好的信息，就更加知情了。

这种理念是一些经典著作，比如《论出版自由》里面提出的。弥尔顿在《论出版自由》里面是这样说的：

_“虽然各种学术流派可以大量传播，然而真理已经亲自上阵，如果我们怀疑它的力量而进行许可和查禁，那就是伤害了它，让它和谬误交手吧，谁看过公开的交手时失败呢？”_

谁看过呢？不幸的是，你我都看得太多了！我觉得现在的情况是：**“谁又看过真理在自由而公开地交手时胜出过呢？”**

为什么“观点的自由市场”这种理念在这个年代可能过时了？为什么我们需要重新思考呢？这里面有一个重要的问题：**观点的自由市场中有一个核心的假设，就是我们信息太少了**，所以要反对压制信息的人，我们要保护自由的信息来加入竞争，这样才能越辩越明。

但是今天，在这个信息爆炸的社交媒体年代，**我们现在稀缺的不是信息，而是注意力。**[现在互联网运转的基本模式就是注意力经济](https://mp.weixin.qq.com/s?__biz=MjM5NDEwNjQ0MQ==&mid=2654280336&idx=1&sn=d1f9e242bd499b1c4b3b3b3d2df46af0&chksm=bd4d67b68a3aeea0dbe9be9d7771116f2b04cd25bd1449c9262910b35e6625581623617b6bbc&scene=21%23wechat_redirect)。信息一直在那，但注意力是有限的。只有注意力投放到优质的信息上面，真理才真的能够胜出。

![](https://i.loli.net/2019/04/02/5ca24289c25e7.jpg)

<figcaption>注意力经济制造的大量信息垃圾消耗了我们的注意力</figcaption>

我很喜欢的学者、作家Tim Wu说：**曾经，说话很难；现在，让自己被听见很难。**我觉得这是一个非常有洞察力的说法。回到之前的线索，曾经影响公民知情是因为我们没有更多的信息。现在当然在中国大陆的某些方面还有这样的问题，但是现在更大的问题是被听见的困难。其实，这个年代控制信息的主要方式并不只是删帖，包括中国也是。加州大学圣地亚哥分校的助理教授Molly Roberts去年出版了一本书叫做《Censored》，里面提到了中国政府的审查策略有好几种，不仅包括删内容，还有制造更多信息来转移注意力。所以，**在这个年代控制信息的一个主要方式其实就是消耗注意力，让你在各种信息中疲于奔命，无暇去辨识。**

在一个信息爆炸、注意力稀缺的年代，纯粹的观点自由市场是行不通的。那么怎么办呢？就需要去干预这个自由市场。在爆炸的垃圾信息面前，市场的那只手可能失灵了，那就需要去干预。所以现在全世界一个非常重要的话题就是：怎么去干预对信息传播起到关键作用的互联网平台？奥巴马本人之前就受到很多假新闻的困扰，比如说他不是在美国出生的，这些假新闻很多在Facebook上传播，那么Facebook是否应该把这些假新闻删掉呢？还是让它留在那里和辟谣文章去进行“公开的交手”？

我对这种“公开的交手”是不抱什么乐观期待的。**在这个年代，提升信息质量，让公民更加知情，互联网平台需要主动做更多事情。**

所以我越来越从平台这个角度来思考问题。比如，一个资讯app如果仅仅以提高用户数量和活跃时长为目标，那就可能大量呈现吸睛但无营养的内容，就可能对虚假消息睁一只眼闭一只眼，因为这类消息更能吸引点击。在这种情况下，真理可能根本都不会被人看到，何谈胜出？包括我写百度这个事情，因为百度是中国人了解信息的一个重要入口，甚至大家写论文也都是从百度搜资料的，但是如果百度搜出来的信息很差的话，[就会导致大家整体的认知都会下降一个层级。](https://mp.weixin.qq.com/s?__biz=MjM5NDEwNjQ0MQ==&mid=2654281777&idx=1&sn=e2fd9e6772980ce412e9f760ccc8aa90&chksm=bd4d5d178a3ad401f4f57b89d847f6f64bc7182d20a900ed2529a924647b93a036ed2ccbfb98&scene=21%23wechat_redirect)

在观点的自由市场失灵的情况下，要怎么去更好地要求这些平台发挥主动的角色，提供更好的机制让真理胜出，这是我现在非常关注的话题。这个事情很多时候不能寄希望于政府，因为政府在中间会夹杂私货，更多要有公共的力量来做这件事情，比如**是否能有一种来自公众的对平台监督的压力**。比如我之前写百度，引发很大的公众反响，这就是一种聚集公众压力的方式。再比如，**是否有一种进行倡导工作的、监督科技平台的组织**，在欧美就有不少这样的公民社会组织。我觉得这些力量才是更值得依靠的。

所以接下来，在新闻实验室，我也会对这些影响信息质量的平台做更多的监督和评价，也希望所有的人都能关注到这个问题，**希望你关注到手机上的各种APP，它们可能都会在相当程度上影响我们。**这不光是平台自己商业的问题，更是广泛的社会问题。

![](https://i.loli.net/2019/04/02/5ca2428ae2e4a.jpg)

<figcaption>在欧美，科技巨头处于公众、媒体和议员持续不断的监督之中</figcaption>

回到我最开始说的，我为什么关注这些问题，因为我觉得世界变好的一个方式就是让大家更加well informed。我在生产内容，在做媒介素养的普及，这两件事情都很重要但可能都还不够，还有需要倡导更好的互联网平台来承载优质信息的传播。我也很希望能有更多的公众参与到这种监督当中来，一起发声，一起为自己争取一个更好的互联网、更优质的信息环境。

基本上，我在这半小时的时间里回顾了自己最开始做的事情到现在更关注的方面，确实像洁平指出的，我可以用一个线索把这些事情梳理下来。谢谢大家！

---

> **希望能有更多的公众参与到对科技平台的监督当中来，一起发声，一起为自己争取一个更好的互联网、更优质的信息环境。**
