---

layout: post

title: 人口列车是怎样失控的｜大象公会

categories: Archive

tags: 计划生育

date: 2018-09-15

image_feature: "https://i.loli.net/2018/09/16/5b9dba4665b97.jpg"

description: 2000年之后许多年，我国的总和生育率都「稳定」在1.8。2018年，人口和养老危机成了中国社会最焦虑的问题。

---

原文来自订阅号「大象公会」：~~[人口列车是怎样失控的](https://mp.weixin.qq.com/s/-WNniFIm0jzKlwAO838APQ)~~

---

![title figure](https://i.loli.net/2018/09/16/5b9dba4665b97.jpg)
​​​
**组织行为学原理，怎样让一个「早有准备」的政策酿成严重的养老危机？**

作者｜刘喜

2018年，人口和养老危机成了中国社会最焦虑的问题。

不过，今天的担忧，党中央早在40年之前就已料到。1980年发布的《中共中央关于控制我国人口增长问题致全体共产党员、共青团员的公开信》，精准的预测到「人口老化」问题可能在四十年后到来：

![公开信](https://i.loli.net/2018/09/16/5b9dba8c3b2ac.jpg)

**●《中共中央关于控制我国人口增长问题致全体共产党员、共青团员的公开信》**

四十年后，80年代后出生的一代人已经站在了供养老人的风口浪尖。人们忽然发现，劳动人口已经少到不足以支撑社保体系，但早应该在2010年甚至更早前就启动人口政策转向，却来得太迟太迟，人口「老化」危机已经来临。

是什么让「计划生育」变成了一辆失控的列车？

## 列车发动的时刻

1949年内战决胜的前夕，美国国务院发表了《中美关系白皮书》，将国民政府失败的责任全部推给了蒋介石。与此同时，国务卿艾奇逊公开表达了对新中国的不信任，认为新政权「无力解决庞大人口带来的吃饭问题」。

这封信对毛泽东触动很大。他在《唯心历史观的破产》中反驳艾奇逊：「在共产党领导下，只要有了人，什么人间奇迹也可以造出来。」

毛的说法奠定了新中国初期的人口政策。加上战后生活稳定带来的补偿性生育，当时的中国家庭有三四个小孩都是很正常的事情。

![爸爸上工我们上学](https://i.loli.net/2018/09/16/5b9dbacc66716.jpg)

**● 50年代的宣传画里，普通城市工人家庭里往往有三四个小孩**

新政权禁止流产，打胎需要夫妻双方签字，还要得到医生同意和机关首长批准。1952年，卫生部明文规定「非疾病不得进行绝育手术及人工流产」。

普通家庭求避孕而不得。《宁波日报》在1951年报道过一名叫做林怀堂的中医。他因为给生活陷入绝境的工厂妇女开堕胎药方，而被「送到法院严办」。

![宁波日报](https://i.loli.net/2018/09/16/5b9dbaf6419c3.jpg)

人口的激增带来担忧，激起了关于节育的大讨论。刘少奇、邓小平都是节育的支持方，学者邵力子、马寅初等人也大力鼓励节育。

![不要随便服蝌蚪避孕](https://i.loli.net/2018/09/16/5b9dbb0fc348c.jpg)

**● 邵力子建议服用蝌蚪避孕。这一被不少妇女实际应用的方法无效且有害，且造成当年农田里的青蛙大量减少、害虫增多**

然而，支持节育的人口学家们很快在整风运动中被打倒。「计划生育」的口号也被搁置，从大跃进到文革漫长的十多年中，中国人口实际处在无序增长的状态里。

到1970年代，国务院终于下定决心实行「有计划地增长人口」。

那时的口号是「晚、稀、少」，倡导晚婚晚育、间隔生育、最多二胎。处罚方法以扣工分为主，除此之外，还有「开展人口理论培训班」「中学增设晚婚节育课程」和「避孕药具免费提供（甚至送上门）」等措施。

![计划生育记公分](https://i.loli.net/2018/09/16/5b9dbb3b4bcf4.jpg)

**● 计划生育记公分**

![免费供应避孕药具](https://i.loli.net/2018/09/16/5b9dbb5d02069.jpg)

![计划生育考柜](https://i.loli.net/2018/09/16/5b9dbb79bb7b7.jpg)

**● 为革命实现计划生育，免费供应避孕药具**

时至今日，都有人认为「晚、稀、少」是计划生育「最好的时光」。这一生育准则并非强制，但显示出惊人的效力：

1970年的总和生育率（妇女一生中生育孩子的平均数量）为5.81，到1979年已经降到了2.75，比正常的世代更替水平2.1高不了太多。

然而，「十年少三个」，对于「中国速度」来说还远远不够。1978年，十一届三中全会把计划生育提到国策的高度。1980年1月，党中央下发文件，提出「计划生育，要采取立法的、行政的、经济的措施，鼓励只生一胎」。

计划生育由此变成摆在各级官员面前的一项重要政治运动，而一场造部门运动，也随之展开。

## 一场造部门运动

在70年代末期的中国，「十二亿人恐慌论」一度非常流行。

社会普遍认为，中国人是一个热爱生子的群体，如果不采取更严厉的措施，人口总量将很快上升到十二亿之上，而这个数字会迅速拖垮上升中的经济。

1978年，新一届国务院计划生育领导小组召开第一次会议。当时的组长是时任副总理的陈慕华。此前，她长期任职于对外经济联络部，负责中央对外经济工作。

陈慕华将计划经济的工作惯性沿用在了计划生育上。她做了一道数学题：

要心中有数，要做工作，要把多胎控制住，鼓励生一胎，把人口降下来。我算了一下：一年如果只生 700万到800万，比现在再少生1000万，扣去死亡600多万，一年净增100到200万，事情就比较好办了。现在一年出生1700万到1800万太高了。

![陈慕华](https://i.loli.net/2018/09/16/5b9dbbd6da88e.jpg)

**● 前国务院副总理陈慕华，1985年，兼任中国人民银行行长、党组书记**

陈慕华算出的目标，是在一年内把出生人口从1700万降到700万，这谈何容易？方法只有一个：让一对夫妻只生一个孩子。

1979年，陈慕华在《人民日报》发表文章，呼吁实施「一胎化」：

……必须大力提倡和推广一对夫妇只生一个孩子。这是使人口自然增长率降低到零的主要办法，也是群众可以接受的办法。

陈慕华的强硬态度，推动了计生政策从「鼓励只生一胎」变成了「用经济的、行政的和法律的手段限制居民的生育」。

1981年，中国成立「计划生育委员会」，陈慕华兼任计生委主任、书记。计生工作从卫生系统中分离出来，从省、到市、再到乡，各级行政单位都成立了专门的计生部门，开始有专门的办公地点和办公人员。

班子成立了，就要依事争权，自证合法性。

在陈慕华等人的努力下，1982年9月，「计划生育」被定为基本国策，同年12月写入宪法。

1983年，新上任的卫计委主任钱信忠继续扩充事权，发起一场史无前例的「大结扎」运动。

运动的口号是「一胎上环，二胎绝育」：对计划外怀孕者一律实施人工流产或引产；生育两个子女以上的夫妇，男女一方必须采取节育手术。

![钱信忠](https://i.loli.net/2018/09/16/5b9dbc178cedc.jpg)

**● 钱信忠早在1964年就负责在上海、北京、天津等地搞计划生育工作试点，曾历任卫生部部长兼书记，计生委主任兼书记，获得1983年联合国第一届世界人口奖**

一开始，引产绝育的工作主要和卫生部门合作，由当地医院执行。有医生回忆，当年的医院总结报告里，「院长个人一天最高完成结扎手术88例」。

医生做不过来，计生委便扩充其业务部门「计划生育指导站」参与引产结扎。由于手术量大，指导站的专业能力又不如基层医院，以至于引发了不少肌纤维断裂、膀胱破裂、肠管粘连等不少术后问题。

![强行引产](https://i.loli.net/2018/09/16/5b9dbc3d173c7.jpg)

**● 计划生育人员在基层执行计划生育国策，强行带农村妇女引产**

![手术](https://i.loli.net/2018/09/16/5b9dbc50e33db.jpg)

**● 指导站人员在简陋条件下做手术**

钱信忠带领计划生育团队创下多项记录。1983年，女性结扎1640万例，男性结扎426万例，人工流产1437万例。按照人口学家梁中堂的说法，这一年里，全国总共1.4亿的适龄妇女有3000万被结扎或人流。

![计生手术数](https://i.loli.net/2018/09/16/5b9dbc7c0012b.jpg)

**● 全国计生手术例数（1977-2010），1983年的数据一骑当先**

钱信忠于1983年年底卸任，但「运动式引产」的工作方式却被保留了下来。计生部门时不时就搞「计生突击」，全体干部一同抓计生、找产妇，县乡的一切工作都要给计生让路。

除了中央新设部门无比积极的能动性，基层政府为了实行好新确立的基本国策，也开始了种种政策创新。

1983年，全国计生工作的榜样典型是山东荣成，以采取「经济限制、人工流产、突击活动」等措施，计生成绩显著而闻名。

湖南常德澧县派人到荣成学习经验后，创造性的提出了「一票否决制」，把「一票否决」首次纳入党政目标管理。

1988年，常德推行的计划生育「一票否决」作为一种成功的经验被湖南省委推广全省，并继而获得中央承认，成为通行全国的做法。没做好的地方政府和官员不得被评为先进，党政一把手不得提拔重用，如果造成人口失控还要降职、免职甚至撤职。

在「一票否决」的巨大压力下，基层干部们对违规生育行为报以强硬手段。「该扎不扎，房倒屋塌」「逮着就扎、跑了就抓，上吊给绳、喝药给瓶」，就是农村计生政策执行状况的众生相。

![标语1](https://i.loli.net/2018/09/16/5b9dbcb07503e.jpg)
​
![标语2](https://i.loli.net/2018/09/16/5b9dbcd2391a8.jpg)

![标语3](https://i.loli.net/2018/09/16/5b9dbce168bfe.jpg)

**● 一些计划生育标语**

与此同时，计划生育相关部门，尤其是计生委，则因这一政策的推行受益良多。

计划生育成为各级政府中心工作之一，这些部门随之成为各级政府实权部门。计生工作往往由各级党委常委专人主抓，不惜调动巨大的政治经济人力资源完成考核。

牢不可破的部门利益，由此开始成型。

## 消失的「社会抚养费」

计生工作形成部门利益的核心，除了上文提到的官员晋升的「一票否决制」，另一项法宝是「社会抚养费」。

社会抚养费原称「计生罚款」，到1990年代末，为了弱化惩罚意义，才改为这个名目。社会抚养费由县级计生部门作出书面征收决定，可以委托乡（镇）人民政府或者街道办事处征收，属于预算外收入。

通俗来说，这笔钱县乡「分成」，不纳入政府预算管理，对地方政府来说，具有极大的自由度，因此也具有了特别的意义。

![社会抚养费收据](https://i.loli.net/2018/09/16/5b9dbd05b2c11.jpg)

**● 一名基层计生人员晒出来的社会抚养费收据**

这么多年来，中国一共征收了多少社会抚养费？国家计生委和地方计生部门皆不愿透露。

仅据一位内部人员透露，二十一世纪初，河北某县一年征收额就达到4000万元，这还不包括被各乡镇截流的部分。

2002年出台的《社会抚养费征收管理办法》，将社会抚养费的具体征收标准交给省、自治区、直辖市规定。在这一规定下，各省市、甚至各区县的征收标准都不一样。

超生界名气最大的当属导演张艺谋，他由于超生交纳了748万的「天价罚款」。普通人如中国青年政治学院的副教授杨支柱，原本是研究计划生育的民法学者，因为生二胎被强行缴纳24.06万元的罚款，一度丢了工作，小女儿也成为「二胎、黑户」。

![杨支柱](https://i.loli.net/2018/09/16/5b9dbd317f1c3.jpg)

**● 「超生教授」杨支柱和他的两个女儿**

据人口学者何亚福推算，从1980年到现在，如果平均每个超生人口实际被征收的超生罚款为一万元，那么1.5亿至2亿超生人口的超生罚款总额是1.5万亿至2万亿元。

2013年底，有24个省公布了2012年度社会抚养费征收额，总数为200.98亿元。根据这个数字来看，全社会每年社会抚养费的征收额可能达到250亿元甚至更高。

![吴有水律师](https://i.loli.net/2018/09/16/5b9dbd7563b2e.jpg)

**● 申请社会抚养费相关信息公开的浙江律师吴有水**

**这么多钱用在了哪里？不知道。**

2013年9月，国家审计署调查结果显示，从2009年到2012年间，甘肃省等9省市下属的45个县上报的计划外生育人口不实，违规向征收单位和计生部门拨付社会抚养费16.27亿元，违规向乡镇「返还社会抚养费」。

这45个县未按规定上缴国库的3.19亿元社会抚养费，大多被当地截留挪用、坐支，最终为各种津贴奖金、招待费、交通费买单。

作为预算外收入享有较大支配自由度的社会抚养费，甚至成了经济欠发达乡镇财政收入的重要部分。基层计生人员为了罚到更多钱，不惜「放水养鱼」，鼓励群众超生。

山西基层政府流行一句顺口溜，「村干部吃树，镇干部吃肚」。村里靠卖树挣钱，而乡镇一级要增加收入，就要靠社会抚养费。

![乱收费](https://i.loli.net/2018/09/16/5b9dbdb1b8ee8.jpg)

**● 内部人士通过第一财经爆料社会抚养费乱象。根据他的介绍，给专武干部购买统一服装的费用，也从社会抚养费中出**

南京大学的张晔和刘志彪老师，因为提出设立「生育基金」引发舆论哗然。人们往往忽略的是，他们随后还建议「妥善利用社会抚养费的存量资金」，但根本不知去向的社会抚养费，让他们的建议完全像是在痴人说梦而已。

## 努力续命的计生委

进入2000年代，随着计划生育政策所导致的中国人口结构变化，计生委的口号和提法，早已不适应实际情况。

2000年，中国进行了第五次人口普查，得到的总和生育率低得出乎意料，用原始数据计算出来的总和生育率只有1.22。而「低生育率陷阱」理论认为，总和生育率一旦降到1.5以下，就很难回升到2.1的正常水平。

计生部门的态度颇值得玩味。他们指出，很多超生孩子不报户口，人口统计有很大的漏报，不承认人口普查的数据。

在「做了一些人口学的回归分析和模型换算，应用一些数学方法」之后，计生委给出了自己的生育率数据：1.8。

如果计生委是对的，那么2000年人口普查的漏报率高达40%。然而，这一匪夷所思的数字却被计生委一再坚持，不仅2000年，之后许多年，我国的总和生育率都「稳定」在1.8。

![生育率异常稳定](https://i.loli.net/2018/09/16/5b9dbe063b830.jpg)

**● 各种来源的数据中，只有计生委的生育率异常稳定**

1.8的总和生育率，说明中国的生育率还不够低，掩盖了中国人口问题逐渐抬头的严峻现实。

在「控制低生育率水平」的掩护下，计生干部们继续穿行在大街小巷间，检查辖区居民有没有「超生」。控制人口的政策方向还没有到需要转变的时候，「计生委」这个组织也便可以继续存在下去。

但计生委也并非一味掩耳盗铃，也在积极探索「转变职能」的其他可能性。

2003年，第十届全国人大启动首轮大部制改革，国家计生委主动请缨，自愿成为改革试点。然而，更名为「国家人口和计划生育委员会」的计生委，并没有能力协调处理好中国的人口问题。

比如，基于流动人口管理的「准生证」政策，事实上只是给中国的小两口们带来了无穷无尽的麻烦。《计生证》《准生证》《流动人口婚育证明》等诸多证明让人一头雾水，各地方、各机构规定不一，经常相互矛盾，「办准生证难」的报道屡见报端。

![流动人口婚育证明](https://i.loli.net/2018/09/16/5b9dbe25747d8.jpg)

**● 和「生育」有关的证明非常多，各地规定不一，给要生孩子的年轻人们带来了很大麻烦**

人口计生委还试图在「优生优育」「生殖健康」甚至「0-3岁婴幼儿教育」这些领域，拓展自身生存空间。然而由于业务能力不足，以及与卫生及教育系统的严重冲突，这方面的努力也效果不彰。

说到底，这些问题都牵涉错综交织的政策领域，需要协调公安、民政、卫生、社保、人事、教育以及工青妇、残联等许许多多的政府部门和人民团体，而人口计生委无论从体量还是专业能力来说，都不足以调动这些资源。

由于生育率常年稳定在1.8实在不能服众，人口计生委在「监测人口和计划生育发展动态」这一本职工作上的能力也受到了各方怀疑。

最终，一些计划生育工作者开始组织给更年期后的妇女摘除避孕环。「上环部门」，最终开始给人「取环」。

![取环](https://i.loli.net/2018/09/16/5b9dbe4660920.jpg)

**● 为母亲们取环，「这个痛一辈子忘不了」**

某种意义上，计生委与中国计生政策的变迁，只是再次证明了组织学中的「帕金森定律」：

行政组织会自我膨胀。尤其是计生委这样任务导向的组织，总会用各种方法夸大任务的重要性、延缓任务的完成时间、不断扩张业务，以自证合法性，实现自我延续和攫取资源的目的。

2013年的大部制改革中，计生委和卫生委合并，「单独二孩」启用；2016年国家开放全面二胎。

然而，中国已经进入了1980公开信中所说的「老龄危机」时间点，信中所说的「想办法解决」仍丝毫不能令人放心。1.047的超低总和生育率，真的能走出陷阱吗？

> 主要参考资料
>
> 张凤阳.(2015).任务型组织的生存逻辑——以计划生育委员会为例. 中国行政管理,1,018.
>
> 刘骥, & 熊彩.(2015).解释政策变通:运动式治理中的条块关系. 公共行政评论,8(6), 88-112.
>
> 杨发祥.(2004).当代中国计划生育史研究.浙江大学博士学位论文2004年.
>
> 第一财经.(2016/04/19).透析社会抚养费：揭开那些少为人知的真相. 第一财经专题. <https://www.yicai.com/topic/5004966​​​​>
