---

layout: post

title: 车浩：寻衅滋事罪是用来打流氓而非耍流氓

categories: Archive

date: 2018-08-19

image_feature: "https://i.loli.net/2018/08/22/5b7d6d6fd1a10.jpg"

tags: 寻衅滋事罪

description: 最近，一位因上访被判寻衅滋事罪的八旬老太，申请保外就医被拒，于是，近年来通过寻衅滋事罪处理信访的做法，再次浮出水面，被舆论关注。对此，不展开长篇分析，简单谈几点看法。

---

本文转自微信公众号：「中国法律评论」

作者：车浩

~~[车浩：寻衅滋事罪是用来打流氓而非耍流氓](https://mp.weixin.qq.com/s/dt7cI1t0sB-sUC-09BMWlQ)~~

---

当表达内容本身并没有涉及到反动色情，处在法治和政策允许范围之内时，表达形式就不必做严格限制。这才是一个健康完整的公共生活，也是对刑法保障的公共秩序的正确理解。

我把那种出现一个社会现象，就主张立（或废）一个法条的观点，称之为“现象立（废）法”。它断章取义地回避了社会治理的复杂性，不去正视驱动司法的深层逻辑，而是习惯于把法律文本的不完善，简单地想象成问题的症结，以为修法就是一劳永逸的药方。理想主义者的善良和天真令人感动，但也是省劲而无用的。

## 目次

一、寻衅滋事罪的适用

二、废除寻衅滋事罪？

三、用刑法对付信访？

四、打流氓与耍流氓

---

最近，一位因上访被判寻衅滋事罪的八旬老太，申请保外就医被拒，于是，近年来通过寻衅滋事罪处理信访的做法，再次浮出水面，被舆论关注。对此，不展开长篇分析，简单谈几点看法。

![01.jpg](https://i.loli.net/2018/08/22/5b7d6d6fd1a10.jpg)

<figcaption>图片来自网络</figcaption>

## 寻衅滋事罪的适用

我们今天已经生活在移动互联网时代。个案申诉内容的发表，究竟是在大街上发材料，还是在微博或者微信上发朋友圈，在传播效果和影响上，其实已无实质差异。

如果今天，一个人在微博或微信上发了个申诉状，因为内容不涉及反动、色情或造谣而未被删除，能够得到现行法秩序允许，那么，他在大街上散发同样内容的材料，也应当得到容忍。即使多几个人围观，这种内容和方式的个案上访，形成维稳者担忧的那种秩序冲击和政治动员，可能性极低，实不需要如临大敌，更无必要动用刑罚。

**此外，刑法第293条第四项规定，“在公共场所起哄闹事，造成公共场所秩序严重混乱的”，构成寻衅滋事罪。对公共场所秩序和起哄闹事的理解，必须严格限制，不能滥用。**

“公共场所”不是一个建筑的、空间的概念，而是一个文化的、规范的概念。它不是一个由水泥砖瓦组成的静态空间，而是由一群人的社会生活交织而出的动态的秩序。每一个公共场所，都有它特定的、具体的秩序类型。例如，在公园里，一群人跳广场舞唱红歌，没毛病，但在美术馆跳，那可能就近乎起哄闹事了。

所以，问题的关键，在于涉案的特定行为，是否合乎相关场所中特定类型的公共秩序。表达信访意见的最正当场所，当然是法律规定的接待上访者的机构。除此之外呢？在其他场所申诉，是否就都无法为公共秩序所包容？

我觉得，这里就要结合具体个案进行分析了，无法给出一个一般性的回答。但至少，在我看来，公共场所的秩序功能，是由民众的具体需求所决定的。如果说，一个场所允许人们在那里聚集，就某些事件表达支持、拥护的言论而不被认定为“起哄闹事”，那它就具有了容纳公民表达意见、开展政治生活的功能，而政治生活必然是多样态的，这种场所也应当允许人们表达不赞成、委屈和申诉。

**至少，当表达内容本身并没有涉及到反动色情，处在法治和政策允许范围之内时，表达形式就不必做严格限制。这才是一个健康完整的公共生活，也是对刑法保障的公共秩序的正确理解。**

## 废除寻衅滋事罪？

对于因个案而主张废除寻衅滋事罪的声音，我并不赞成。

寻衅滋事罪有特定的规制对象和范围，只要民众不受那些无事生非、随意挑衅的流氓行为侵扰的利益值得保护，寻衅滋事罪就有存在的必要性与合理性。

如上所说，如果严格解释和适用寻衅滋事罪，一些上访行为本可以排除在外。法治的安定性是一个基本价值，如法律的解释空间仍能榨取，就不应轻言修法。从建言成事的成本和概率来看，若澄清法律的适用都暗卡重重，清除修法的障碍更是谈何容易。因此，如果不能正确司法，需要反思的是深层阻力何在，而不是简单地主张修法。

显然，真正的问题，不在于刑法规定了寻衅滋事罪，或者寻衅滋事罪的语义模糊是口袋罪，而是因为，决策者想要动用刑罚惩治上访行为，所以才有这个罪的滥用。今天，就算真的因规定不明确而废除了寻衅滋事罪，将来还可以再出台一个语义明确的专门打击缠访的罪名，那时又能奈何？

**我把那种出现一个社会现象，就主张立（或废）一个法条的观点，称之为“现象立（废）法”**。它断章取义地回避了社会治理的复杂性，不去正视驱动司法的深层逻辑，而是习惯于把法律文本的不完善，简单地想象成问题的症结，以为修法就是一劳永逸的药方。理想主义者的善良和天真令人感动，但也是省劲而无用的。

以信访治理为例，如果不能从根本观念上变化，废了此法，亦有彼法。

在2013年之前，对付上访者最严厉的手段是劳动教养，劳教废除时，学界一片欢呼，似乎人权保障的春天就此到来。但实际上呢？就像汪庆华教授在一篇文章中显示的那样，原来被劳教的那些上访者，现在都被处以更严重的寻衅滋事罪了。“才出虎穴，又入狼窝”。

![02.jpg](https://i.loli.net/2018/08/22/5b7d6d76d70bc.jpg)

## 用刑法对付信访？

信访制度的利弊得失，就不在这里讨论了。但至少有一点不能否认，很多进京上访行为，内含了基层民众对中央政权的合法性和权威性的承认和想象，甚至可能成为对政府信心的最后一根稻草。对此，必须慎用刑罚手段。

即使客观上出现信访权利被滥用的场合，也应当结合个案具体分析、区别对待，特别是审慎认定缠访、滥访人的主观动机。其中的支配性因素，究竟是为了寻求救济和权威信赖，还是借题发挥甚至无事生非。（这也是寻衅滋事罪之所以强调主观上的流氓动机的必要性）

如果一律反向打击，特别是简单粗暴地动用刑罚，会摧毁上访者的权威信赖，甚至将其彻底推向政权的对立面。

水能载舟亦能覆舟。治水之道在于疏通而非封堵。通过定罪解决信访问题，是用刑法强行封堵疏通管道。较轻的后果，是不可能终结信访，反而增加信访动因，形成恶性循环。严重的后果，是逼涨不满情绪，积蓄决堤风险，以短期维稳的方式，埋下长期紊乱的种子。

无论哪一种后果，与用刑罚回避一时的上访压力相比，都是得不偿失的。这种只求回避眼前责任、危机不断后推的懒政表现，不是为国分忧，而是为国增压。

一定会有人说，你不知道那些缠访滥访的人有多麻烦，有多影响稳定。可是，这世界上任何人为制造的麻烦，把人抓起来关几年，都是最快捷有效的手段。随地吐痰、酗酒抽烟、闯红灯……都可以这么治理。问题是，不顺眼的人都进了监狱，海晏河清的太平盛世里，还能剩下几个顺眼的人呢。

![03.jpg](https://i.loli.net/2018/08/22/5b7d6d6ce3293.jpg)

<figcaption>图片来自网络</figcaption>

## 打流氓与耍流氓

最后再说几句。如所周知，寻衅滋事罪是从流氓罪分解而来。在众多子嗣中，寻衅滋事罪具有最纯正的流氓血统。聚众斗殴的，未必都是流氓；但是能被称作流氓的，往往都会寻衅滋事。随意殴打、追逐辱骂、强拿硬要、起哄闹事，刑法第293条的规定，就是大众心目当中的“流氓”形象的一幅速写。

很多人总拿流氓罪是口袋罪说事儿，可是，在我看来，流氓罪这一母罪，恰恰是指导寻衅滋事罪正确适用的关键。

因为，基于这种修法背景，在对寻衅滋事罪展开解释时，司法者脑海中应当先有一个为构成要件所包含的典型的“流氓”形象。只有实施了构成要件行为的行为人符合该典型形象，才能将其归入该构成要件。

这种类型化解释的关键，在于看具体的行为能否符合解释者心中的那种典型的行为人的行为方式；不相符合的，就可以排除出去。面对类似于寻衅滋事罪这样被认为语义模糊的犯罪，可以采用这种特殊的限缩解释的方法。

总之，司法者在认定寻衅滋事罪时，不要忘记，这个罪是专门打流氓的，所以不妨反复琢磨一下，行为人所作所为，是否符合一般民众心目中的“流氓”形象？

像这起被关注的案件，那个因为反映家里林地被占和女儿被判刑的情况，而多次上访的八旬老太，她的行为，就算制造了影响，也让执法者不厌其烦甚至厌恶，但，她能不能被社会公众评价为一个“流氓”？

目光反复往返于规范与事实之间，才能正确适用法律。我想，司法者肯扪心自问的话，心里还是有数的。

此外，与这样一个以“打流氓”为旨归的犯罪打交道，有时候不小心的话，也很容易沾染上流氓的气息。

因为，流氓行为，本身不是像杀人放火强奸那么猛烈和典型，而是一些无事生非、随意找茬、任意挑衅的举止。它不像杀人放火那样触及人的良知底线，倒是很容易激发执法者烦躁、厌恶和被冒犯的心理情绪。

有个东北话的段子流传很广。说的是甲和乙在饭馆杠上了。

> 甲：你瞅啥？
>
> 乙：瞅你咋地？
>
> 结局是，乙被甲暴打一段。

乙像不像流氓？他乱瞅人家，可能让人不舒服，这毛病是不太好，而且还很不服气，有对抗情绪，但要说这就是流氓，好像还差点劲儿。

甲呢？一开始是被瞅者，总被人盯着是很烦躁，但他如此地不容冒犯，动辄饱以老拳，树立了“不得随便瞅我”的规矩，维护了人人低头吃饭、默然听话的秩序，这种做派，似乎更具有流氓气质。

那些事出有因的缠访者，就像那些随便乱瞅的人，可能是会让人感到不愉快，给朗朗晴空带来一些麻烦，但是，用寻衅滋事罪的名义说他们是“流氓”，恐怕执法者自己，心里也未必能够真正接受。

所以，需要时刻警惕的是，没有必要因为那些明显不是流氓的人所制造的一些轻微的治安侵扰，就感到法秩序受到了严重冒犯，以至于祭出刑罚。毕竟，动辄就觉得别人在挑衅他，然后就把人家暴打一顿，这本身就有点近乎耍流氓了。

回顾修法史，正视上访者，每一个法律人都应当记住：

> 寻衅滋事罪，是用来打流氓的，而不是用来耍流氓的。
