---

layout: post

title: "问答两则：MeToo运动违反「无罪推定」原则吗？会导致冤假错案泛滥吗？"

date: 2018-07-26 13:37:55

categories: Archive

image_feature: "https://i.loli.net/2018/07/28/5b5bf1722c5b3.jpg"

tags: MeToo

description: MeToo运动违反「无罪推定」原则吗？

---

原文来自「林三土」：~~[问答两则：MeToo运动违反「无罪推定」原则吗？会导致冤假错案泛滥吗？](https://mp.weixin.qq.com/s/8sFOe4q-ps7AuamzW_-YHQ)~~

---

![01.jpg](https://i.loli.net/2018/07/28/5b5bf1722c5b3.jpg)

## 1.  MeToo运动违反「无罪推定」原则吗？

在对MeToo运动的反对声中，『违背程序正义』、『践踏无罪推定原则』是常见的说辞。但是这类说辞，其实是建立在对程序正义、无罪推定原则的误解之上的，需要相应的澄清。

先说**无罪推定**（presumption of innocence，或ei incumbit probatio qui dicit, non quinegat）原则。在使用这个原则时，一定要首先强调，它有着相当特定和狭窄的适用范围：这是一个专门用于对【**刑事**】案件的【司法】审判的原则。其中说的『有罪（guilty）』与『无罪（innocent）』，都有司法意义上的特指、关系到**是否要遭受法律规定的刑罚**，而不是日常语境下的泛泛之论（比如『舆论把xxx定罪了』，这里的『定罪』严格来说只是一种比喻）。

许多人忽视无罪推定原则的适用范围，将它不加区分地应用到对**民事纠纷**、甚至**公共舆论**的评判上，既不合理，还可能导致自相矛盾的结果。

在任何的纠纷中，我们要想判断争议各方的是非，至少要从三个步骤着手。一是对**举证责任**（burden of proof）的分配，二是对**证据标准**（standard of evidence）的选择，三是考察**既有证据的效力与强度**是否达到既定标准。

比如A声称p，B声称非p，我们作为仲裁，首先要确定：p和非p这个议题的性质究竟是什么，是应当由主张p的人先举证，还是应当由主张非p的人先举证，或者由双方同时举证？

然后，假设我们判断，这个议题应当由主张p的人（在这个例子里是A）先举证，那么接下来要考虑的问题是：当A出示证据时，哪些类型的证据是有效力的、可以被允许使用的，哪些是不当的、无效的？当A给出的有效证据强到什么地步时，我们可以认为她满足了举证责任的要求、举证责任发生转移，该轮到B来举证非p、试图将举证责任再转移回A的身上？

确定了这样的标准之后，我们最后才来考察A（以及条件符合时B）实际给出的证据里哪些是有效的、这些证据的总体效力有多强，并最终在双方证据强度对比的基础上做出自己的判断。

无罪推定，就是一个关于特定类型的争端（刑事指控的司法裁决）之中，指派特定【举证责任】与【证据标准】的原则。

一，无罪推定包含的举证责任原则：在刑事诉讼中，举证责任首先落在原告方，而非被告方；换句话说，当原告指控被告犯下某某罪行时，第一步应该是由原告来出具被告犯罪的证据，然后被告针对这些证据的可靠性与有效性进行回应，而不是要求被告首先出具自己无罪的证据，然后由原告来给这些证据挑毛病。

二，无罪推定包含的证据标准原则：在刑事诉讼中，裁决者（法官或陪审团）对事实真相的判断，或者说对原告方满足举证责任与否的判断，要求原告方给出的证据必须满足极高的置信标准。在英美法系中，这个专门用于刑事案件的标准称为『排除合理怀疑（beyond reasonable doubt）』。

『排除合理怀疑』具体该怎么定义，一直是很有争议的事情，而且这个词本身也常常引起误解；如果形象一点（但是牺牲定义的严谨度）来说的话，它相当于要求事实裁决者：『基于原告被告给出的质证，我认为，被告确实犯下该罪的可能性超过99%』。

【无罪推定 = 原告举证责任+ 排除合理怀疑】。亦即：『在刑事诉讼中，应由原告主动出示证据证明被告犯罪，被告只需对原告所示证据的有效性加以反驳；在经过这番质证的证据显示被告犯罪的概率超过99%之前，司法裁决者就应假设被告无辜。』

注意，无罪推定的这两个方面（尤其是证据标准方面），只适用于【刑事诉讼】，却不适用于【民事诉讼】，或者其它纠纷。

一来，不同法律体系对民事诉讼的举证责任分配不尽相同，有些国家要求原告先行举证，但很多国家是要求原告被告同时举证；

二来，在证据标准上，民事诉讼一般采取的是『证据优势（preponderance of evidence）』原则，就是对比原被告双方的证据，哪方证据较强即胜出。换句话说，这时候裁决者做出有利于原告、不利于被告的判断标准，并不是说被告犯错的概率超过99%，而是被告犯错的概率超过50%（也就是原告正确的概率超过被告正确的概率）。

在美国的司法体系中，除了『排除合理怀疑』和『证据优势』之外，还有其它千奇百怪的适用于不同情况的证据标准。比如在衡平法诉讼中，用的是『明确可信证据（clear and convincing evidence）』标准，对原告方的要求高于『证据优势』、却又低于『排除合理怀疑』（大致相当于『当且仅当被告犯错的概率超过75%时，判原告胜、被告负』）；在行政复议中用的是比『证据优势』还低的『实质证据（substantial evidence）』；逮捕嫌犯时用比『实质证据』要求还低的『可靠原因（probable cause）』；警察拦路搜身则可以用比『可靠原因』要求更低的『合理怀疑（reasonable suspicion）』标准；等等。

具体这些标准的合理性，可以再讨论，这里只是指出，不同情境下适用的证据标准，存在差异是很自然很正常的事情。

不妨再举一个更日常的例子：假如你的朋友今天特别难过地找你倾诉：『我被劈腿了，呜呜呜。』你会对朋友说『且慢哭诉，对于你对你男/女朋友的指控，我必须采取无罪推定原则；由于你提出的证据没有达到排除合理怀疑的标准，所以认为你的指控不成立，你的男朋友/女朋友并没有劈腿』吗？

当然不会。单单朋友的难过倾诉这件事，已经足以让你（初步地）相信他/她的说法了，也就是说对你而言，举证责任这时已经落到了被指控劈腿的人那边。

随之而来的问题是：为什么要对不同情况采取不同的证据标准？干嘛不一刀切地采取排除合理怀疑标准、无罪推定原则？

这就涉及到刑事司法和其它情境的区别。

刑事司法有什么特点？首先比较容易看到的一点，是其后果的严重性（或者可以加上由公权力背书的严肃性）。刑事罪名一旦成立，被告将被判入狱、丧失自由，在有些国家甚至可能被处以肉刑或死刑；同时，被告身上将背负犯罪记录，（根据法律和社会规范的不同而）不同程度地、但往往很严重地影响到后来的生活。后果的严重性，显然是谨慎对待证据、尽量避免伤害无辜的一个重要考虑。

但光有后果严重性这点，恐怕还不足以将刑事司法与其它情境完全区别开来。比如有人会说：假如有无辜者被公共舆论千夫所指，丢掉工作，无以谋生，流落街头，这种后果不可谓不严重吧？那么凭什么说公共舆论不应该和刑事司法一样采取无罪推定原则？

这里还需要考虑（刑事）司法过程的另一个特征：相关惩罚的严格单向性。

作为刑诉结果的司法制裁，是单向的而不是双向的：如果法官或陪审团裁定被告B有罪，B就会遭受法律惩罚；如果裁定B无罪，B不会遭到法律惩罚，但原告A同样并不因此而遭到法律惩罚。只有当被告B反诉原告A（造谣诽谤、侵犯名誉权、精神伤害等等），启动一场新的诉讼，A才有可能遭到法律惩罚，但这时B已经从被告变成了原告，而A则从原告变成了被告。

在很多国家的刑事司法体系中，这种单向性又以一种更特定的方式体现出来：刑事诉讼是一种公诉过程，原告方总是国家（或者其它能够代表公权力者），被告被指控的罪行，不仅仅是针对作案受害人的，而且是针对全体人民的。

比如在英国，刑事诉讼的形式是R(x)v. y，其中R是王室，x是呈情要求诉讼的受害人，y是被告，R(x)的意思是『王室应x的请求对y提起诉讼』。美国的刑事诉讼也是类似，比如The People of Illinois v. xxx什么的，意思就是由伊利诺伊州检察官代理受害人提出公诉。为什么『公诉』得以可能？前提之一就是刑事诉讼的单向性：『国家』这个抽象实体不会因为败诉而遭到法律惩罚。

反过来，对于双向的民事诉讼（严格说来，民事诉讼中不存在『罪』[guilt]，只有『责』[liability]），举证责任就是双方共有的；同时，既然司法后果是双向的，当然『证据优势』原则是最直观合理、不偏不倚的标准。

公共舆论的后果，同样是双向而非单向的。假设A站出来指控B性侵。如果大家（或者至少B所在的社区与工作单位）普遍相信A、认为B确实性侵，并据此对B进行道德谴责和（非司法意义上的）惩罚，比如开除其工作——这当然是B承受了公共舆论的后果。

但反过来，假如大家（或者至少A所在的社区与工作单位）普遍地不相信A、认为A是在诬告B，或者甚至即便相信A、却仍然因为文化观念而看不起A，那么A就会反过来承受被排挤、被耻笑、被开除等等遭遇。

在判断的后果是双向而非单向的情况下（和场合里），对是非的判断、以及相应采取的态度与行动，在保护一方的同时，是必然伤害另一方的，这中间没有超脱的办法。

比如现在A向媒体指控B做了某件坏事，列出证据一二三。作为旁观者（而不是司法裁决者），如果你说『我对B采取无罪推定；B不需要做任何回应，只要A的指控没有排除我的所有合理怀疑，我就拒绝相信A的证据和指控』，意思其实就是说『我对A采取有罪推定；除非A的指控排除我的所有合理怀疑，我就认为A在造B的谣，并据此对A采取相应的态度和行动』。

刑事司法之所以能够采用（且应当）采用无罪推定原则，除了司法惩罚的严重与严肃之外，其单向性是不可或缺的关键，因为正是单向性让其得以摆脱上述的这种两难。

不过就算对于刑事案件，也只是案件的裁决者（法官、陪审团）才需要采用无罪推定；对于没有参加裁决的旁观公众来说，每个人心里仍然可以保留各自判断。辛普森杀妻案被判无罪，不妨碍其他人心里面仍然相信他是凶手。我们也可以换个说法：司法判决和惩罚，只是从整个社会互动中划出的、一个有着严格边界的过程和领域。

以上只是说到刑事司法为什么要采取更加严格的【举证责任】和【证据标准】原则（而反过来其它领域的判断就不必如此），尚且没有说到【实际证据考察】这一点。

仍以刑事司法为例：『刑事司法应当采取无罪推定（排除合理怀疑）原则』这个说法本身，并没有告诉我们怎样算是『合理怀疑』，并没有告诉我们怎么去估算被告作案的概率、到底什么样的证据能让我们确定其概率超过99%（假如我们把『排除合理怀疑』约等于『嫌疑人作案可能性高于99%』的话）。尽管刑事司法由于其惩罚的严重性、严肃性与单向性，在【举证责任】与【证据标准】这两个原则上必须保持高度谦抑，但是这并不影响法官和陪审团在【实际证据考察】步骤的具体推理。

特别是在性侵案件中，以往人们常常用『你当年如果被性侵，干嘛不当时就报警』；『你既然愿意孤男寡女同处一室，谁知道你是不是主动』之类说法来抹黑（discredit）受害人的证词。

但是心理学、社会学的研究，让我们对性侵受害者的行为模式有更多了解，知道现实社会的各个方面，比如男权文化对女性言行举止的规训、旁观者的不作为与和稀泥、执法人员在立案审讯过程中对受害者的二次伤害等等，是如何普遍而系统地阻碍着受害者及时反抗、及时报警。换句话说，前述常见质疑的合理性与有效性，已经被这些研究在很大程度上消解了。

这样一来，我们对于受害人证词【默认可信度（default credence）】的判断，就应当有一个较大的调整；由此导致的结果就是，性侵受害者的控诉在整体上更有可能达到排除合理怀疑的标准而成立。比如当陪审团知道性侵受害者常常因为创伤后应激障碍（PTSD）而无法记清过程中的某些细节时，其『数次口供中对某个特定细节的描述前后不一致』这一点，就不应该想当然地认为光靠这一点便足以证明其口供不可信；又比如当法官知道『荡妇羞辱』不足取之后，就不应当再允许辩方律师将受害者『私生活不检点』作为呈堂证供。

同时，对【默认可信度】判断的这种调整，是和社会文化的整体观念（比如『强奸文化』的强弱）相联系的。而这种文化改造，正是MeToo运动的重要面相之一。

## 2. MeToo运动会导致冤假错案泛滥吗？

> 『如果结合MeToo运动在中美发展中出现的一些实际情况，请教您如何看待在舆论热潮裹挟中，大众对情绪的诉求远远盖过对必要的逻辑和证据的重视？换言之，司法过程有制度性的安排来保障程序正义，但大众舆论并无中心化的权威来协调与管理，大众舆论与民事诉讼在此处的不同是否重要？我们应该如何考虑去防止狂欢式的、非理性的『媒体审判』？进一步说，如果举报成本低（比如匿名）、效果好（可以直接诉诸舆论让对方身败名裂）、撒谎报假案没有惩罚（媒体没有或者无法事实核查以及无人对撒谎者究责）。会不会造成很多冤假错案，让许多人的职业生涯、人格尊严毁于一旦？』

多谢你的问题。我觉得在目前（以及可预见的未来）的社会/文化/技术条件下，对『MeToo运动导致舆论狂热和冤假错案泛滥』的担忧，是不必要地过虑了。这并不是说，在【逻辑】层面，冤假错案的可能性不存在。而是说，给定【我们所处的经验世界的约束】（这些约束有例外的时候，这个我下面会说），像你所说这种被MeToo运动整个毁掉名誉和人生的冤假错案，充其量是极个别的情况。

我们不妨从迄今为止MeToo运动的后果看起：迄今为止，反对者能否举出哪怕一例，由MeToo运动导致的、毁掉被指控者名誉与人生的冤假错案？至少我到现在还没看到这样的情况发生。

相反，我们倒是可以看到如下两种情况：

一是『试图诬陷（或钓鱼）但无人问津或者被迅速识破』。比如美国共和党参议员候选人Roy Moore恋童丑闻曝光后，其共和党的支持者曾经试图通过钓鱼手段来为其扳回一城：由某女性假装是Moore的受害者、主动向华盛顿邮报的记者『爆料』，希望记者上钩后写出没有根据的报道，从而损害批评Moore的主流媒体的信誉。但是当记者要求该『爆料者』提供证据时，后者马上左支右绌、被记者识破。

类似的情况，在这几天章文性侵丑闻曝光后也有发生。在最初几名女性站出来指控章文以后，网上很快开始小范围流传一幅声称章文有各种不堪性癖的截图。但是截图内容马上被章文前同事指出不实，极有可能是章文的支持者企图借此把水搅浑，在成功『钓鱼』之后令其它真正的指控一并无人相信。

二是『事出有因但小题大作、虽然掀起一时风波但很快平静下去，没有造成多大影响』。比如某位和演员Aziz Ansari约会的女性，匿名指控他在约会时不够尊重女方意愿。帖子发表后，大多数评论者都指出，Ansari的做法虽然不妥，但和MeToo运动揭发出来的大多数事情，严重程度上绝对不可同日而语；Ansari在事发后迅速道歉，此后风波也就平息了下去，对他的职业生涯并没有造成什么太大影响。

所以至少到现在为止，MeToo运动的『命中率』高得惊人，『误伤率』却几近于零。

当然，这时候我们可以做两类追问。一是：现在确实没有冤假错案，但是怎么保证将来不会有？怎么保证MeToo运动不会逐渐走样？

这就要求我们进一步去考察，一个类似事件的曝光和引起反响，具体的机制是什么？比如，你在提问中担忧媒体去中心化、匿名指控的后果，但是我们反过来想一下，假如现在reddit上（或者百度贴吧上）突然出现了一个匿名帖子、指控某某名人性侵，公共舆论会如何反应？是会不假思索地、不需要任何进一步证据地相信吗？

当然不是。不管出于媒体的市场需求，还是出于涉事方面及利益相关方的利己考量，还是人们对真相（八卦）的热衷，接下来都会有人去挖掘匿名爆料者的身份、去推敲爆料帖中的细节是否可靠、去质询被指控者的身边人对他/她的观感、去悬赏寻找其它潜在的受害者，等等。

也就是说，不管舆论去中心与否、不管初始爆料者匿名与否，最终一次爆料能够转化成『实锤』、能够形成针对被指控者的谴责和处罚呼声，都依赖于后续的证据补充。否则在网络时代新新闻不断压倒旧新闻、注意力不断转移的时代，这样无以为继的匿名爆料马上就会淹没在碎片讯息的狂潮中了。

另一方面，实际案件的爆料，其实远远没有想象中那么去中心化。因为一般而言个体受害者既担心报复，又缺乏足够的影响力和渠道，所以要想掀起声势，往往需要有经验、有资源的人作为中介，征集、筛选、发布爆料。而这些中介人为了自己的信誉起见，不能不对爆料的可靠性先做一些判断。比如前面提到的Roy Moore丑闻中的华邮记者；又比如最近沈阳事件中的王敖教授、张鹏事件中的黄雪琴记者等等，还有这些年在曝光美国学界性侵丑闻中扮演重要作用的『feministphilosophers』平台运作团队等等。所以绝大多数时候，就算爆料人对旁观公众来说是匿名的，但她们的身份对于这些中介者和组织者来说却是非常清楚和有保障的。

以上说的是基于经验层面的条件约束，为什么我们不必担忧MeToo运动变成大肆迫害无辜的舆论狂欢。

不过这些条件约束在特定情况下是可以被打破的。什么特定情况呢？就是表面上的『公共』舆论，其实只是当权者操纵下迫害特定群体的工具，而缺乏真正的公共性（即允许卷入争议的各方及其同情者公开地参与到相互质证的过程中）。比如文革，就是这样的一个例子，大字报上喊着要打倒谁，其实只是最高领袖个人意志的反映。再比如种族隔离时代的美国南方，黑人男青年常常被无端指控『非礼白人女性』、不经正当程序就遭到白人暴民的私刑；表面上看这是南方白人『民主意志（多数暴政）』的体现，但我们如果仔细看历史细节就知道，当时南方对黑人、以及对同情黑人遭遇的白人，从言论权到政治参与权上设置了种种限制，一切以维护种族隔离、将黑人踩在脚下永世不得翻身为最高目标，这种情况下的『舆论』，一开始就排除了特定群体的参与，当然不能以『公共』视之。

我觉得我们现在应该能够比较有信心说：当代美国不会出现上述的情况，所以MeToo运动不会沦落到类似的境地。中国的体制当然有极大缺陷，有些人也许可以担忧政府会借着MeToo来选择性地清除异己（比如选择性的开除性骚扰学生的自由派教授、却对同样性骚扰学生的亲政府派教授网开一面），或者借机大搞『高校师德整风』之类运动。但一方面，我不认为当今政府对民间舆论有如此完全的操纵力，更不认为政界在这方面干净到让他们敢于借机行动而不怕引火烧身；另一方面，就算政府真有心如此鸠占鹊巢，也仍然不等于MeToo运动本身在制造冤假错案。

对『命中率』与『误伤率』的另一类追问是：用『命中率/误伤率』的高低来进行评价，这种『效用主义』式的计算方法本身，难道是恰当的吗？就算只是『误伤』了一个无辜者，也是对这个人的声誉与人生造成了不可估量的伤害啊！难道我们不应该『宁可放走一千，不可冤枉一个』吗？

这就又回到了前面提到的『双向性』问题上。社会舆论相信与不相信一个指控，受到影响的并不仅仅是被指控者（嫌疑作案者），同样还有指控者（嫌疑受害者）；尤其在性侵问题上，一个指控被周边人拒绝相信，对受害者打击的毁灭性，绝对不逊于错误指控对受枉者的打击。仅仅强调『误伤』对被指控性侵者的打击，而拒绝同样严肃地看待『纵容作恶』对实际性侵受害者的打击，等于是将被指控者的权益天然地摆在指控者的权益前面；这本身恐怕就反映了男权社会的某种偏见。

注意我这里并不是说：指控者的权益反过来天然地高于被指控者的权益，所以我们完全不必考虑如何保障被指控者不受污蔑（前面也说到，MeToo运动的实际运作情况，很大程度上正是对这方面的保障）。而是说，将『命中率/误伤率』纳入考量，是在平衡两方面权益时不可避免的一个步骤。我们不可能完全抛开这种概率考量、空谈对嫌疑人权益的保障而忽略对受害者权益的保障，只能是尽力将这个平衡取舍的步骤做得更好。而这其中的关键之一，就是通过对性侵心理机制、『强奸文化』等社会现实的更多了解，来不断修正我们以往对证词『默认可信度』的错误预置，争取提高最终判断与实情吻合的概率。

![02.jpg](https://i.loli.net/2018/07/28/5b5bf17294a41.jpg)
