---

layout: post

title: 木田：我们到底要怎样的高考作文教育？

categories: Archive

date: 2018-06-09 17:51

image_feature: "https://i.imgur.com/Hqye1DC.jpg"

tags: 高考作文

description: 对高考作文题目的批判过后，我们想要的，是何种解决方案呢？我们的种种解决方案，真正追求的又是什么呢？

---

> 本文由 [简悦 SimpRead](http://ksria.com/simpread/) 转码， 原文来自微信「木田无花」：~~[我们到底要怎样的高考作文教育？](https://mp.weixin.qq.com/s/tQd1HYLMgbB06GgAmflvqw)~~
>
> 作者：木田无花

---

![](https://i.imgur.com/Hqye1DC.jpg)

面对2018年的高考作文题，我本来有很多话想说。

比如说，**近年来高考作文立意限定越来越窄，不利于独立思考与批判性表达。**

本世纪头几年全国卷的话题作文，如「诚信」、「心灵的选择」、「感情亲疏和对事物的认知」，给考生发挥的空间很大，每位考生都有话可说，但套作成功率也很高。2006年，全国I卷与全国II卷开始出现材料作文，材料本身开始出现倾向性。2006年全国I卷作文材料中，乌鸦羡慕老鹰俯冲抓羊，但无论怎样拍打翅膀也飞不起来。牧羊人说：「这是一只忘记自己叫什么的鸟」；牧羊人的孩子摸着乌鸦的羽毛说：「它也很可爱啊」。**乌鸦凭借个人努力，已很难超越阶级固化的社会现实，它不得不接受自己「叫什么」，并且内化它**，孩子眼中的「可爱」也并不能改变什么；但至少，这个题目还留给考生从「孩子」角度思考的空间。而到2018年，题目材料本身已完全「一边倒」，除了对「改革开放」与「新时代」的歌颂，考生很难再表现出任何其它思考——**如果说以往是「揣摩题意，不敢冒险」，那么现在就成了「题干所限，不能冒险」**；毕竟作文跑题直接三类起评。

再比如说，**高考作文选材愈发城市化、中产化，对偏远地区、工农家庭考生不公平。**

2012年的全国大纲卷作文材料中，尚且会出现**「回家帮着干农活」**，「脱了外衣和鞋袜」「挑担子」的经历，考生可以根据自己对现实的理解，以「担子」、「外衣和鞋袜」做不同的比喻。2015年的全国I卷作文材料，变成了**女儿举报「在高速路上开车时接电话」的老爸**。这在当年引起了很大的社会争议，因为能在「高速路」上「经常开车」陪女儿的父亲，大概率开的是私家车，且经常自驾游，有着一定的社会经济地位。而到了2017年的全国I卷材料**「中国关键词」**，则更引来了强烈批判：没坐过「高铁」、没用过「移动支付」、没见过「大熊猫」的偏远农村考生，即使字面上读过这些「关键词」，又如何感同身受？

上面的任何一个角度，都可以单独拎出来写一篇评论文章。但这一次，我想直面更难的问题：**对高考作文题目的批判过后，我们想要的，是何种解决方案呢？我们的种种解决方案，真正追求的又是什么呢？**

![](https://i.imgur.com/L4IVtyw.jpg)

批判性思维的培养，对工农家庭考生的公平，哪个我都想要；从2015年开始带作文课以来，我也一直希望能做到二者的结合：**一方面，尽可能将追问与反思意识融入每一堂课，同时通过对接公益机构，使课程视频尽可能辐射到更多乡村学生；另一方面，在课堂问题设计中，融入更多对劳动者现实的关注与分析。**

并不能说，这样的努力一点效果都没有；也的确有学生由此反思户籍制度与新移民等问题，写出了很有思想深度的作品。然而从乡村中学的反馈来看，作文教育中「思想性」与「公平性」的兼备，并不是仅仅通过教学材料的公益分享就能实现的。尽管我有意在课上讲缝制牛仔裤的童工、早上连米汤都不敢喝的女工媛媛、北五环汽配城被逼迁的家庭，**整套课程依然是以大城市中产家庭孩子为中心设计的，以「他者」的视角看待工农的苦难，很少呈现工农的斗争；尽管当时的我没有意识到**。再者，受地域差异所限，部分中西部省市的阅卷负责人很可能不像北京阅卷负责人那样，注重所谓「自由表达」与「独立思考」；听话乖巧的学生、华丽辞藻的套作，的确更容易得高分。

于是，我们必须要面对：**如果在现行框架内讨论高考作文命题与教育，那么批判性思维的培养，与对工农家庭考生的公平，两种追求之间就是有很大的矛盾甚至对立之处的**；即使力求兼顾，也只能优先择其一。

一部分知识分子优先选择了前者；在对中国高考作文题目做出「不自由」、「不清晰」、「意识形态色彩过重」的批判后，很快就转向了对「法国高考作文」与「美国SAT/ACT写作」的热情赞美。**在这一部分评论者看来，法国、美国等西方国家的高考作文题目，可以作为中国高考作文弊病的解决方案**，因为它们能充分考察学生的「批判性思维（critical thinking）」，且具有足够的「开放性」，无关政治倾向。

如果「批判性思维」在这里，更多指一种全面处理信息、论证观点的能力，那么这种能力在一定条件下，的确可以为不同社会群体所用。然而，**这些评论者所指的「批判性思维」，不仅包含事实维度中的信息处理与论证能力，更包含鲜明的价值维度**：「自由民主」社会中的公民美德；在一些知识分子对「批判性思维」的定义（Linda Elder, 2007）中，甚至直接加入了「知识分子的正义感与同理心」，要求同时消除「自我中心」与「社会中心」倾向，以**追寻纯粹「理性」与「自由意志」**。

可以说，**这样带有价值维度的「批判性思维」，是建立在资本主义个人框架内，以知识分子为中心的价值观，它同样在进行自己的意识形态灌输，绝非其所声称的那样「价值中立」**；因此，站在这一立场上，哪怕对高考作文题目进行「意识形态色彩过重」的批判，都是无力的。

另一方面，**这种以知识分子为中心的价值观，也在影响着「高考作文」题目的材料选择**。以法国为例，作文题目以哲学为主，围绕「理性」、「权利」、「美」等概念本身进行抽象理论思辨；评卷人在《世界报》上给出的应考建议，也更多是「引用一些哲学家的话」，论证有条理，而非在举例与讨论中关照社会现实。这样的考评体系，与「公立大学-大学校」的双轨制一道，**服从于精英主义传统，把家庭出身更为优越的、「有资质」的下一代「筛选」出来**；工人家庭的孩子则更有可能被打上「资质有限」的标签，提前分流到职业高中，实现工人阶级的再生产。

![](https://i.imgur.com/XSo6YBx.jpg)

前文说到，在现行框架内，「批判性思维的培养」与「对工农家庭考生的公平」很难同时兼顾；而分析到这里，我们又会发现，这部分知识分子提出的第一种解决方案，不仅**使「批判式思维」的能力进一步局限于少数有产阶级家庭后代头脑中，无法真正为全民培养相应能力，走向了自身的反面**，更通过相应的筛选机制，使富人愈富，穷人愈穷。所以，更为合理的解决方案，当优先选择后者，更多促进工农家庭考生的公平。

**然而，对我们工农家庭的考生，包括更广泛的城乡劳动者家庭的考生而言，什么样的解决方案才算得上「公平」呢？**

这又有两条路线：

第一条路线，如果现在问一个劳动者家庭，希望从教育中获得什么，更大概率的答案或许是，希望自己的孩子走出农村，走出县城，走出大山，考上北大清华，实现**「阶级跃升」**，成为人中龙凤。这落实到作文教学中，则是希望自己的孩子接受真正能提高分数的作文教育，也就是**服从当前主流意识形态规训的教育；哪怕这种主流意识形态是背离劳动者根本利益的**。

这条路线在实践中，就是**教育改良者的方案**：一方面，从大城市的精英学校中抽调出部分教师，到偏远乡村或打工子女学校进行短期支教，**提高当地学生的应试能力**；另一方面，在高考作文卷面上，尽可能减少偏题怪题，以及需要更强灵活性与思辨性的题目。**这种解决方案，追求的与其说是高考面前的「公平」，不如说是「现行框架」内的「阶级和解」。**这种和解是暂时的，局限性也很大，获得所谓「公平」的「鲤鱼跃龙门」者永远是少数，**少数人的上升，很可能以多数人受更深重的剥削为代价；另一些人却一出生就在龙门上面。**

另一条实践路线，则是**教育革命者的方案**：彻底改变课程设计，以媒体、公益组织等多种可能形式传播，**让劳动者家庭的孩子们看到高考作文命题的本质，看到出题人是如何一年年地缩紧允许表达的范围，看到作文材料是如何背离普通劳动者**，与此同时，锻炼孩子们的批判、思辨与表达能力，以各种孩子们身边的材料教育他们，**和他们一起结合现实写作，在斗争中写作。**
**孩子们的教师上街讨薪，就带他们一起上街，描写自己的老师被强行上手铐的情景；**

**孩子们的亲友是转业军人，就与他们一起给亲友写信，询问老兵有着怎样的待遇，又怎样团结起来维护权益；**

**孩子们身边的农田被强征破坏，厂区环境污染严重，就和他们一起查资料，了解如何向国土资源厅申请信息公开，分析回复中「无法告知」的背后，是怎样的违法事实……**

不可否认的是，这样的方案，无疑会占据孩子们大量原本可以用于刷题提分的时间。然而从另一个方面讲，在理解了「刷题提分」的本质，获得了基于现实的思考写作能力之后，无论希望继续拼「跃龙门」的一线机会，还是希望投入更多精力在写作中斗争，**选择权依然在孩子们自己手上。**

**教育革命者跳出「现行框架」，最终追求的，也是打破「现行框架」，将教育的主权重新夺回到劳动者手中；只有这样，才能实现真正的「教育公平」。**

![](https://i.imgur.com/DrETGmb.jpg)

![](https://i.imgur.com/dVDwmSc.jpg)

![](https://i.imgur.com/DGd40Co.jpg)


**防失联，请关注木田君的另一个家：木田君的镐头（mutianpickaxe）**

![](https://i.imgur.com/OX9ksoG.jpg)
