---

layout: post

title:  声音计划 | 儿童节：川震十年，“我们的娃娃”还在等一个答案

categories: Archive

date: 2018-05-31 23:30

tags: 汶川地震

description: 2008年的儿童节，与汶川大地震相隔十九天。超过五千名学生在地震中遇难，五千多个家庭失去了孩子的笑声。

---

原文来自微信公众号「声音计划」，~~[原文](https://mp.weixin.qq.com/s/i83JrKnJYWDesIg4eqrJZg)~~

本文由“声音计划”支持

“声音计划”是一个旨在支持关注现实社会议题的非虚构写作项目

---

明天是六月一日，儿童节，一个以保障儿童权益为主旨的节日。2008年的儿童节，与汶川大地震相隔十九天。超过五千名学生在地震中遇难，五千多个家庭失去了孩子的笑声。

那一年，绵竹市富新二小的家长，在坍塌的校舍前办了一场“天堂里的‘六一’”，失去孩子是一种伤痛，孩子的死因得不到说法，则是另一种伤害。整整十年间，遇难学生家长也不曾停止过追问，只是声音越来越不被听见。

十年了，“我们的娃娃”还在等一个答案。

### 一、父亲

“爸爸，我们要去救灾。”

最先提议去灾区的是谭作人的两个女儿，地震后的第二天，一家人带着整车的矿泉水从成都开往灾区。去汶川的路已经塌荒，只能停在都江堰，在往都江堰市区的路上，谭作人经过了新建小学，它的教学楼垮塌，师生伤亡严重，而周边一些建于上世纪80年代的老楼却没有倒塌。

这个日后因调查地震死难学生而与汶川地震紧紧绑在一起的作家、环保工作者，在当时还不知道灾区里，都江堰校舍坍塌的惨况并非孤例。

同样滞留在都江堰的还有全国各地的媒体，整体坍塌的校舍成为报道焦点。**后来的统计数据显示，都江堰仅中小学就死亡超过800人，超过都江堰总死亡人数的四分之一**。

![01.jpeg](https://i.loli.net/2018/06/01/5b112c8fc1678.jpeg)

2008年5月16日，谭作人第一次进入倒塌校舍现场——北川中学。北川县是汶川地震中受灾最严重的地区之一，可统计到的遇难者人数超过1.5万人，县城大面积被毁。**县里唯一的高中北川中学，也是整场地震中伤亡最重的学校，遇难师生过千人——接近全校人数的一半**。灾后重建时，县城劫后余生的北川县城居民被政府安置到23公里外的新城，“老北川”则建起地震博物馆，街道和建筑也被保留下来作可开放参观的地震遗址。

北川中学的两栋教学楼原本有五层高，地震后整体下塌，余下在地面上的不足两层高，谭作人形容成了一堆碎片。旁边的却有旧建筑“奇迹般”没有倒下。

“**遍地都是去的书本、压碎的笔……唉，遍地都是，那个对我的震撼、对我的冲击，比那种到处都是尸体还要厉害。**”十年后的谭作人回忆。当时，54岁的他穿着墨绿色短袖衬衫，外套绑在腰间，胸前挂着白色口罩，蹲在北川中学碎成一地的砖块上，把缝里的笔捞起来。

与谭作人一同到北川中学的媒体记者，跟他作采访。他向着镜头说：“**对着这些学生、上千学生的亡灵说一句话，我一定对得起你们用过的笔**。”说到“上千学生”时，他几乎要哭了出来。

那天，他刚走出北川中学，有一个男人走过来。他是北川中学的老师，女儿已罹难在教学楼的废墟之下，他详细地描述了一遍地震当日的情形，并提到地震后不到10秒钟，教学楼摆了几下，就整体塌下来。

同一天，官方媒体人民网在其“强国论坛”上，请来了住建部、教育部、建设部的领导与网民在线对话，**由网友提出的18个问题中，有8个都与学校坍塌有关，以致人民网编辑直接以“教育部、建设部、地震局官员学者谈震区校舍倒塌”为标题**。有网友提问查不查豆腐渣工程，时任教育部发展规划司司长韩进的回答是：“对工程质量的调查也要进行，如果确实存在问题一定严肃查处，绝不姑息，会给社会一个满意的交待。”

也是在那一天的清早，北川中学高一学生陆芳的遗体被抬出废墟。她的父亲陆世华是最早质疑北川中学校舍质量的家长，那时他已经在学校守了四天。地震当日，从外地回来的陆世华和女儿一起吃午饭，没人会料到，那是这个16岁女孩的最后一顿饭。

那一天，陆世华没有看到慷慨陈词的谭作人。他看到女儿的遗体后，已经虚脱了，躺进了救灾帐篷里。

陆世华在帐篷醒来时，往老家片口乡的路还未通，弟弟带着他先到绵阳。休息几天后，他走进了一家打印店。

“致512北一中各位伤亡学生家长的倡议书”传单一张张从打印机里吐出。这张正好铺满一版A4纸的倡议书，直接写道“劣质的建筑才是造成重大伤亡的主要原因”，他倡议全体家长在7月1日集中到学校公祭死难者，并要求有关部门给出合理解释和家属安抚安排。**从绵阳回片口的路上，陆世华沿路派发传单。很快，他就遇到“麻烦”了**。

![02.jpg](https://i.loli.net/2018/06/01/5b112c90a65e2.jpg)

<figcaption>倡议书，图片由受访者提供，原图有一处电话号码，故作马赛克处理</figcaption>

但这些“麻烦”没有达到成效，接下来的几个月里，陆世华给省领导写公开信，想尽办法要去讨说法。那时候没有人能拦住，陆世华觉得自己死都不怕了，他告诉前来阻拦的人，如果女儿能回来，他可以立刻把身上的肉一刀一刀割下来，直到死去。

像陆世华这样提出校舍质量问题的家长并非少数，有人在十年后的今天依旧在上访。与家长行动对应的是“封锁”，地震发生约一个月后，一些重点灾区已经派人把守，外人尤其是媒体难再进入，遇难学生家长无处诉说。

这段时间，谭作人加入了探险家、环保人士杨勇组织的龙门山地震带地质考察队。他们开着带有中科院字样的车进灾区，很少受阻。“**别人（遇难学生家长）一看到来车了，就兴奋地围着我们的车，七嘴八舌地讲。**”谭作人知道，在外界看来事情已经过去，看似风平浪静，但内里却是个“火药桶”，家长依旧以泪洗面，这事情过不去。

汶川地震百日祭时，谭作人发出了一篇《龙门山，请为北川孩子作证》，其中直接提到了天灾里的“人祸”。

2008年中秋节前夜，看过这篇文章的陆世华，把他的公开信和倡议书用短信发给了谭作人。那时候一条短信大约能承载70个汉字，这1300多字的内容，被分割成18条短信。收到短信时，谭作人正坐在汶川县映秀镇的百花大桥残端上，喝着闷酒。地震之后，他随着考察队频繁进入灾区，在灾区的晚上，不喝点酒无法安睡。

过了一阵，陆世华的电话直接打来了：

“谭老师，短信收到了吗？”

“收到了。”

“我们好苦呀。”

“我知道，早点睡吧。”

“几个月都没有睡好觉了，你要帮我们反映情况呀”

“我也没办法……”

电话挂断时，已经是凌晨三点，下着细雨，谭作人独自在山里走，想着此刻龙门山另一端的北川，是否也下着雨，这雨里还有多少个绝望的父亲？在灾区的日子里，谭作人已经听过太多类似的倾诉：乖巧的孩子死在垮塌校舍里，追责的家长反被“控制”。

这通电话，连接了两个素未谋面的人。他们有两个共同的身份：**四川人和父亲，此刻同因地震陷入痛苦，一个无法为死去的女儿讨回公道，一个听过太多倾诉，目睹了北川中学的惨状，却“没办法”**。

### 二、“我们的娃娃”

2008年，绵竹市的富新二小是舆论的漩涡中心，据当地遇难学生家长回忆，学校教学楼是周边唯一整体倒塌的建筑，有127个学生葬身此地。

绝大多数被质疑是“豆腐渣”工程的学校都已经找不到责任方，家长想找到有力的证据更是难。但富新二小是“证据确凿”的，**当年的施工者多次接受媒体采访，直言工程图纸是一张邻乡学校图纸的复制图，施工时临时加了一层，又把矩形梁变细**。

追责却没有因此而更顺利。五月中旬，家长在学校废墟前架设灵堂，在操场的黑板上、灵堂前都写着“人祸”的字样，但他们觉得领导并没有重视学生的“冤情”。

5月25日，家长们决定自己找领导，他们计划徒步到德阳市政府——那是管辖绵竹市的上级政府。家长队伍里拉起一条高约八十公分的长白布条，上面用黑色大字写着：“我们坚信党和政府会还冤死的孩子一个公道！”。路上多数家长都手捧着孩子的遗照，在黑色相框里的都是六到十三岁之间的小学生。时任绵竹市市委书记蒋国华想把家长劝返，四次下跪，但队伍就径直从他身边走过。

陈丽那天也拿着儿子的遗照，那是一张放大了的证件照，小男孩戴着红领巾。她指着照片，反问跪在地上的蒋国华：“跪了，我儿子能回来吗？”

市委书记下跪成了网络热点，加上校舍施工者接受了采访，富新二小的报道量自然高于其他学校。美国电视台HBO以富新二小为主线拍摄了纪录片《劫后天府泪纵横》，后获得了奥斯卡记录短片提名。

陈丽回忆5月25日当天：“我们有一百多个家长，围观的有很多人，还有很多志愿者，一起去的记者，当时的记者特别多。”

![03.jpg](https://i.loli.net/2018/06/01/5b112c90c841f.jpg)

<figcaption>2008年地震后，富新二小遇难学生家长聚集在学校门前，图片来源：苹果日报</figcaption>

一年之后，《唐山大地震》的作者、传媒研究学者钱钢分析了川震校舍倒塌报道被禁始末。他指出中宣部关于校舍报道的第一道禁令早在5月15日下发，但显然这如同一张废纸，连人民网都没依从这道命令。在全国哀悼日至6月初，更出现了接连三波的报道潮。

**报道潮里，大量倒塌校舍的问题随之曝光**：都江堰的聚源中学在选址和预制板质量都有问题；都江堰的向峨中学在修建时就评为危房，却依旧修完并投入使用；青川县木鱼中学曾在2006年递交危房自查报告，却毫无回音；绵竹的富兴二小施工图纸是复印过来的，还擅自改动结构，工程问题百出；绵竹的东汽中学教学楼早已年久失修，但改造计划却一再拖延直至地震倒塌……

但在震后第一个月之后，稍微“擦边”的内容都遭到严厉批评，校舍坍塌报道几乎销声匿迹，这与愈加严格的禁令直接相关。与此同时，禁令也激发起民间的记录行动。

广州学者、纪录片导演艾晓明动身去灾区时，是同年的6月。在救灾热情最高涨时，她撰文说，不必每个人都要去汶川，做好身边的日常事也是一种“救灾”。但现在，她必须去了，灾区校舍的报道已经消失在报端，**传媒销声促使她要亲身去看看，到底发生了什么事？**

出发之前，艾晓明的目标很明确，就是要拍“校难”。后来成了纪录片《我们的娃娃》。

什邡市的红白镇，艾晓明跟拍了一位母亲办理女儿小兰死亡证明的过程，小兰生于1994年，遇难时14岁。**那个司法所只是一个帐篷，电脑里有500多张遇难者的脸部遗照，其中绝大部分是学生、幼童**。这位母亲一张接一张地往下翻，要找出女儿的遗照，大多数的照片里，孩子的脸都被砸得血肉模糊，难以辨认。她最终定到了编号412的照片，“这个就有点像我女儿，头发都已经打乱了”，她一边说着一边把手伸向电脑显示屏，用左手小指做出帮孩子拔头发的动作。

这个片段在《我们的娃娃》里再现，艾晓明对此印象特別深：“因为太难受了，对于我们为人父母的，我们是不能承受自己的孩子在肉体上受到这么巨大的伤害，这样痛苦地离开世界。”

![04.jpg](https://i.loli.net/2018/06/01/5b112c9062910.jpg)

<figcaption>《我们的娃娃》视频截图，截图来源：youtube</figcaption>

长约一小时的纪录片中，家长拿着孩子生前的照片、校园表演的录像、母亲节的祝福短信、留在手机里的语音信息讲述曾经的日常，往日回忆穿插着瞬间塌成废墟的教学楼，“掏娃娃”的呼喊声、撕心裂肺的哭声、校舍质量的追问声。最后，一条滚动字幕走过，是汶川地震垮塌校舍名录，总共63所，跨越了幼儿园到高中。

一年后，官方给出了遇难及失踪学生的统计人数：5335人，这一数字在公民调查的统计中是5679人。足见承受着如此伤痛的家长有上万人。

### 三、十年，放得下吗？

失去孩子是一种伤痛，孩子的死因得不到说法，则是另一种伤害。郭光荣承受着这双重伤痛。

2008年，郭光荣的独生女在富新二小遇难，此后十年里，他一直在维权。他翻开手机，家长群里随手便能翻出他们上访被拦的图片和视频。上访正变得越来越难，很多时候，他们根本到不了目标地就被遣送回家。坐在公园里，郭光荣不时警惕地往后看，接受访谈是一项被禁止的事情，而且郭光荣清楚知道自己的手机和微信都是“透明的”——被有关部门监控着，这种情况在积极维权的家长中并不少见。

在地震八周年前夕，遇难学生家长尝试用法律诉讼来维权。当时一同递交民事诉讼的家长有数十人，最后法院只接纳了郭光荣递交的诉讼材料，他要起诉富新二小的建筑承包商和学校法人，**这份诉讼中并没有经济赔偿要求，只是要求赔礼道歉**。事实上，这也是多数遇难学生家长最基本的诉求：为孩子讨得一个公道。

但法院最终没有予以立案，在立案庭里，法院工作人员告诉郭光荣，这案不属于他们管，应该去找政府，而不予立案的书面回执也不能给他。这结果与2008年时一样，当时富新二小家长起诉了建筑承包商、校方、绵竹市教育局、镇政府，总索赔金额是768万元，同样没有予以立案。

不只是无法立案，他们的案件也找不到代理律师。郭光荣曾到过当地的法律援助中心，对方一听说诉讼内容，就说不敢接。

“你看，这是16年，在绵阳市政府。”

“这个在德阳，去找德阳。”

“你说不要起诉，去找政府，那就找吧。”

郭光荣又一次翻出手机里的视频，说起自己“找政府”的经历，结果都不外乎是被赶走。

当年下跪截访的市委书记蒋国华，后来接受媒体采访时说，自己下跪不是心中有愧，是为了避免群体性事件。在同一篇报道里，这位书记的朋友评论说，这体现了官员所承受的心理压力，“稳定压倒一切”的压力。

不过，在下跪当天政府领导给富新二小家长的承诺：一个月内给出校舍质量调查结果，并没有兑现。“我们被骗了！”十年后，陈丽愤愤地说。

谭作人认为，**在灾后重建阶段，以稳定为重是可以理解的，但在灾后重建已经完成八年后，还不处理校舍问题，那就是“赖账”**。而且，校舍问题的存在本身就是一个影响稳定的因素，给家长一个调查结果，那么稳定才能回来。

今年49岁的郭光荣，理着一个寸头，头上的白发特别明显。在地震一年后，他和妻子再生了一个儿子。今年初，郭光荣妻子的身体出了状况，四肢无力难以工作，但检查也查不出病因，他自己也无法外出打工，经济压力不轻。

他把9岁的儿子送到城区里上学，每天接送得花不少时间，但他觉得城区教育更好，而且富新二小是他的伤心地，再也不想去了。如今的富新二小，叫作顶新小学，“顶新”是一个财团名字，财团在地震后捐资一千万元原地重建了这所学校。校门口竖着的校名柱上，有两块“校园重建碑记”的铜牌，其中一块以此八字结束：“勒石立碑，永志铭记”。

![05.jpeg](https://i.loli.net/2018/06/01/5b112c90a0127.jpeg)

<figcaption>在富新二小原地重建的顶新小学，拍摄：陈四格</figcaption>

问到郭光荣，妻子不会劝他放弃维权吗？在外人看来，停止维权的原因是显然易见的：得不到结果、被监控、养育小儿子的种种现实压力。

他说妻子不会劝，接着没有继续说这个话题，而是开始讲他已去世的女儿，她是一个学霸，一个“太听话”的娃娃，每天把饭菜做好等他们下班，把地拖得干干净净，洗衣服都是自己洗。**说到最后，他留了一句：“放得下吗？”**

### 四、遇上了，就不能转身逃避

谭作人把北川中学学生的笔带回家，一直保存至今。

2008年5月到12月，谭作人一直在等——等别人发起遇难学生和校舍质量的调查。他没有直接解释为什么要等别人来做。**十年后，在谭作人家中，谈及调查过程时，他突然长呼了一口气，缓缓地说出“其实我很不适合做这个工作”**，他把烟捏到烟灰缸里，烟头与玻璃摩擦之间，烟灰由灰转黑，“我会受他们（家长）的影响，会沉浸在他们的描述里面”。

他也曾经在《龙门山：请为北川孩子作证》里写道：“在校舍问题上，我沉默了两个月，不是不敢写，而是写不出来。”

并没有等到“别人”。谭作人形容自己是阴差阳错卷入到校舍问题里，但既然遇上了，就不能转身逃避。

![06.jpg](https://i.loli.net/2018/06/01/5b112c90a641f.jpg)

<figcaption>2018年，谭作人在成都家中，拍摄：陈四格</figcaption>

2008年12月，谭作人的调查开启：**调查的重点放在了死难学生的具体数据和真实死因上**，当时关于死难学生人数出现过好几个不同版本，且数字差距不少。也是相近的时间，在北京的艺术家艾未未也开始统计遇难学生名单。

谢贻卉是谭作人的调查伙伴，两人在成都读书会上认识，她后来成为了纪录片导演。两人划分出三个调查范围，计划分三期进行。

川大西区49号邮箱被谭作人租用，专门接收家长的问卷和表格。家长版的调查问卷总有十个问题，涉及到对师生死亡人数的了解和对死因的看法，赔偿的满意度，政府宣传的信任度等等，而另一份表则是详细的伤亡师生名单表。

![07.jpg](https://i.loli.net/2018/06/01/5b112c90e3c0c.jpg)

<figcaption>谭作人家中仅存的几份调查问卷，拍摄：陈四格</figcaption>

在2008年12月到2009年3月中，**两人用了16天时间作入户调查，往返10个重点受灾县市七次，累计里程近三千公里**。调查的三个多月里，谭作人和谢贻卉也遇到一些问题：在调查点被阻拦、租下的邮箱无法正常收件，甚至电脑被盗，但调查仍然按部就班地进行——包括谭作人在被约谈时，似乎用道理说服了相关人员，至少调查没有被叫停。

![071.gif](https://i.loli.net/2018/06/01/5b112e563ba91.gif)

<figcaption>调查线路图，制图：卢皓龙</figcaption>

2009年三月开始，公民调查的消息随着网络征集行动而进入公众视野。谭作人借用同在成都的作家冉云飞的博客发出《关于建立5.12学生档案的倡议书》，这份倡议呼吁网民参与到调查中，最后共建起一个得到死难学生家长认可的“512学生档案”和网络墓园，同时附上了他们设计的统计表和问卷。

此时，艾未未也开始在博客上更新公布志愿者调查所得的遇难学生名单，他和志愿者在当时还未“被墙”的 Google Group 上共享资料，里面现在还存有253个主题贴，都是调查日志和志愿者申请信息公开的资料。**艾未未继续用网络公开征集更多志愿者来参与这项行动**。

那是一个网络行动活跃，相信“围观”改变中国的时期。在倡议书文档的页眉写着“**哪里有网民，哪里就有公开和公平。中国网民们，来为孩子们做点事吧！**”。

3月25日，谭作人第一次汇总各个学校的资料，写了一个手稿，这些资料存在U盘里，交给了谢贻卉。三天后的早上，谭作人在家中被警察带走，连同电脑、大批一手调查资料被没收，这时距离原定调查结束还有六个月，但原始资料已经丧失，调查被迫止步在“初稿”。

在谭作人家中，当年由家长填写的问卷只剩下五份了，里面有两道问题，五份答案完全一致：

**——你对依法维权有没有信心？**

**有信心**

**——如果依法维权困难，你是否准备放弃？**

**不放弃**

![08.jpg](https://i.loli.net/2018/06/01/5b112c906536a.jpg)

<figcaption>家长填写的问卷，拍摄：陈四格</figcaption>

### 五、失独

大概在2011年，李红对调查结果就不再抱有希望了。

地震后，她拿到了一份儿子所读学校的建筑采样和分析表，但这表格跟鉴定结果还有一定差距，里面没有明确的建筑质量结论。现在，她形容它们为两张“废纸”，称当年的领导为“大骗子”。

“小腿能赢大腿啊？”，“**到现在我们也想要一个结果啊，想是想，但是它不现实的……只是我们一厢情愿。**”李红觉得，要结果已经没戏了。但在今年512前夕，她还是连续发了几个朋友圈，贴出当年的分析表，并问这两张保存了将近十年的“废纸”还有没有用？

2008年，李红的儿子到了绵竹市城区上初中，也是那一年，夫妻两人决定一同到浙江打工。

地震那天，这个14岁的男孩随着教学楼断掉的栏杆一同跌落，李红失去了她唯一的孩子。在老家的弟弟来电话时说，孩子受了重伤，让她回去。隔天，工厂帮李红夫妻买了机票，原本一直很平静的李红，突然开始哭，“我当时说不清楚心里怎么想的，反正一直从那天上午到11点到家，真的哭得受不了”。

那年之后，李红夫妻再没离家打工。

映秀地震遗址里，建了有一块碎裂的大钟，时间停在14：28——地震发生的时刻。李红的时间就如同这个钟一般，停止在儿子去世的时刻。

![09.jpg](https://i.loli.net/2018/06/01/5b112c90e50cb.jpg)

<figcaption>汶川地震灾区中的一块钟，图片来源：新华社</figcaption>

现在，年过五十的李红穿着打扮整洁时尚，戴着细边框的眼镜，能说一口流利标准的普通话，光看外表很难联系到她的遭遇。她早年在杭州和上海交界处打工，十几年前的日子怎么过的，假期去哪里玩，上哪买衣服，她都记得清清楚楚。**但谈到最近十年的生活，她反复用着简单的四个字来概括：行尸走肉**。

前段时间，李红失眠得很厉害，到医院开了药，她在地震后患上了抑郁症。当地领导曾说过可帮她安排心理咨询，但她觉得当地医院的咨询师不靠谱。事实上，她也不想做咨询，孩子走后，她就把自己封闭起来，不想再向人敞开心扉了。

“看着邻居都是欢天喜地的过节，我们都是孤苦伶仃的，又没有孩子，想想孩子在的话，也挺热闹的，不想出去也不想看。”大多数的节日，李红和丈夫只会把自己关在家里。她觉得，孩子走了后，生活彻底失去动力，她也曾想过再生，但一直没怀上。

四川省什邡市是全国最早试点“一胎化”计划生育的地方之一，而全省的计划生育也执行得相当严格。**据四川省计生部门的统计，汶川地震中有子女死亡或伤残的独生子女家庭近8000个**。

李红是在网文上知道失独母亲这个名称的。那是一篇沈阳失独妈妈的帖文，那一刻李红忽然意识到：“原来我是失独家庭”。在这之前，她从不知道“失独”这个概念。买了智能手机后，李红让侄女帮她安了一个聊天软件QQ，开始自学——为的是加入失独家庭的聊天群。

2016年6月15日，李红第一次参加失独家庭的维权活动。**她对失独家庭的身份认同度很高，她朋友圈里，基本只有两类内容：失独家庭的资讯和外出游玩的图片**。

现在，失独补助金和养老金是李红夫妻的主要收入来源，加起来每人每月有1450元，在镇上生活没多大问题，令他们担心的是以后的医疗和养老支出。李红说道：“关于死了以后怎么，我也不管，管他随便往哪一扔，我只关心活着的时候，养老医疗给我解决了，我也不多想。”

512前夕，李红给我发来了遇难学生家长们的诉求：

![10.jpg](https://i.loli.net/2018/06/01/5b112c9159d6d.jpg)

<figcaption>制图：卢皓龙</figcaption>

### 六、记录的责任

“提笔就死”，这四个字谭作人说过两次，一次在他的文章《龙门山：请为北川孩子作证》里，另一次是在纪录片《公民调查》里，坐在北川县城的废墟上，面向着堰塞湖。**“提笔就死”的大意是，哪怕会死，也要把真相写出来**。收到导演艾晓明发来的文稿后，他都不记得自己有说过，看完片第一反应是“我哪有这么高大上的东西啊？”

没有人料到，那天谭作人说的那句“判个三年五年”竟是一语成谶。

回想这段经历，谭人多次强调自己不是那么“高大上”的人，所做之事全是为了自己良心好过，“**自己既然遇上了，不应该转身逃跑，转身逃跑的话，我会一辈子看不起自己，一辈子活在后悔中间，今后日子就没法过。**”

他的这段话，让人不禁联想到辩护律师夏霖为他写的辩护词：“其所思所想，所求所愿，所作所为，无非‘作人’二字而已！”

2009年4月30日，谭作人正式被批捕，罪名是“煽颠”——一个他认为过于“高大上”的罪名。来自民间的512遇难学生调查并没因此噤声，甚至引起了更大的关注。4月15日，谢贻卉把初稿整理成的《四川地震死难学生调查报告（征求意见稿）》公布到网络上。

![11.jpg](https://i.loli.net/2018/06/01/5b112fcea7eed.jpg)

<figcaption>谭作人家中所保存的调查报告封面，拍摄：陈四格</figcaption>

艾未未工作室的“512公民调查”小组的统计仍在继续。2009年9月，“512公民调查小组统计出五千多个遇难学生名单，其中能核对确认姓名、年龄、班级、学校、地区和家属的名字有4851人。**这4851个名字被制作成一部1小时26分钟的影片，在黑色的画面中，学生名字按照姓氏首字母逐一排列，长长的名字在画面中央向上滚动，没有旁白也没有图像，只有名字**。艾未未看重有名有姓，因为那些死去的孩子都是“有血有肉”的生命，不该只有一个笼统的遇难人数。

在艾未未工作室，墙壁上贴着数张大白纸，密密麻麻的都是遇难学生的名字。那时候，在灾区调查的风险正在增加，2009年512前后去往灾区的第三批志愿者中，有十数人曾被拘留，甚至在现场被抢包、被打，他们把这些过程记录下来，又接着前往下一个地点。

拍摄纪录片时，艾晓明遇到了很多艾未未工作室的志愿者，大多是年轻人，她并不认为他们在开始参与调查时，会觉得这是一件危险的事。汶川地震发生后，志愿者精神得到极大鼓励，人们捐钱捐物，甚至到前线救灾，**艾晓明觉得这提供了一个践行公民责任的途径，并激发了大家的责任心，而公民调查志愿者和其他类型的志愿者没有本质差别**。

艾晓明也发起了一个“365封信艺术行动”：把孩子生前留下的作文和书信，父母的信件，网友给孩子家人的回信，都整理好发布到网络上，做成一个系列。萌生这个想法是，艾晓明留意到很多家长保存了孩子生前的资料，把这些作文、书信发出来，是想传递孩子们的声音，同时也希望公众都能如实履行公民责任，去推动解决这个问题。

但这个行动最终天折——艾晓明的博客被封了，“你还是花了很多心思去写，去配图，但一下子被封了之后，很多人就看不到了，而且再往后写也会被删嘛，我就不愿意做这种无用功了。“现在，网络里还能搜到一些当时的博文，信件的更新停在了第十九封。

从博客时代到移动手机端，刪文封号的管制手段依然在继续，**艾晓明觉得，如此让人白白耗费精力，实质是一个精神上摧残的过程**。

去年，艾晓明重发了其中的一封信《映秀小学生马冯艳的一份公民建议书》。马冯艳遇难时，是映秀小学六年级学生，在她的作文本上，有一封写给校长的建议书，落款是2008年4月1日。**她说学校屋顶有漏水的问题，还担心被雨泡过的墙会塌下，建议校长找教育局拿经费或者让当地公司捐钱，来修好这个屋顶**。

![12.jpg](https://i.loli.net/2018/06/01/5b112fcee8ee9.jpg)

<figcaption>马冯艳(左)和妹妹，两人都是映秀小学学生，均在地震中遇难，图片来源：《映秀小学生马冯艳的一份公民建议书》</figcaption>

看完这封信，艾晓明很感动：“孩子这么小，真的有公民的责任心，写了这么一封信，后来变成了遗书。”

这篇重发文章的末尾，艾晓明写道：“这说明，我们是多么需要更新我们的记忆，记住，我们才会不懈地承担社会责任。“在去年512当天，她把纪录片《我们的娃娃》上传到百度云盘上，那是市面最常用但管控严格的网络云盘，被删除是可以预料的结果，不过她说：“但我不管，我做了我自己能做的。”

2010年2月9日，谭作人案开庭审理，这时他已经被囚禁了318天。判决结果是有期徒刑5年，剥夺政治权利3年。四个月后，四川省高级人民法院作出维持原判的终审裁定。

2月10日，谭作人案审理结束的次日，艾晓明独自走在四川大学里，她准备去见艾南山——川大的地理学者，也是谭作人案的证人。**她提着行李、摄像机、脚架，两年多的拍摄里，从未如此的孤单，一起调查、拍摄的同伴此时不是已被限制自由，就是被严密监控，现在只剩一个人了，还拍什么？**

“我走不动了。”艾晓明知道，这个系列就到此结束了。

谭作人案审理的经过，拍成了纪录片《国家的敌人》。这是艾晓明川震系列作品的第五部，也是最后一部，五部作品贯穿了震后两年的变化，围绕校难所发生的一连串事件：家长的哀伤与追责、公民独立调查、灾后变迁、谭作人案。问到艾晓明，拍摄川震系列不是想推动问题解决？她说不排除有这种想法，但自己也不觉得一定能有用，因为困难来源自一个僵化体制。

**“不意味着我们就不去记录。”她又着重地补上一句。**

艾晓明认为，记录本身就很重要，更是我们应该承担的责任。当然，她希望观众通过纪录片知道这些事情：“**知道发生了什么，具体情况是什么样的，家长们是怎么想的，孩子们是怎么死的，我希望整个社会的公众，来回应这些。**”

### 七、“他们的情况不是外人能懂的

今年清明节，有市民自发到北川地震遗址祭奠，纪念地震十周年。

陆世华没有去拜祭女儿，他知道，如果自己在这些“特别”的时间点出现在北川遗址，会有“麻烦”。**他明白到这一“生存之道”，包括5月12日这天，女儿的死忌，他都不会到墓地里拜祭**——2011年北川中学遇难学生的骨灰被政府统一安置到集体墓地里，墓地就在“5·12”汶川特大地震纪念馆的旁边，而纪念馆位置则是北川中学原址。

清明节里，陆世华做了一件整整十年都不敢做的事：整理女儿陆芳的遗物。“**掉了一下午的眼泪，还好女儿和老婆都不在。”说到这里时，他眼眶也有了泪光**。

一同整理出来的，还有“遇难学生家长承诺书”，“承诺书”是伴随着三家基金会募集到的6万元救助金下发的，承诺内容包括自觉维护社会稳定、投入到恢复生产和重建家园的工作中。陆世华没有签字，他觉得这太可笑了。

地震彻底改变了陆世华的人生轨迹，他再婚了，之后又有了一个小女儿。这样的组合家庭，在地震伤亡最重的北川很普遍。

![13.jpg](https://i.loli.net/2018/06/01/5b112fcf6a2db.jpg)

<figcaption>2018年，陆世华在家中，背后墙上贴着一张世界地图和小女儿的奖状，拍摄：陈四格</figcaption>

**陆世华的人生有过两次“切割”。**

1992年，他的妻子在诞下女儿后去世，此后近两年他陷入消沉，有时候夜里睡不着，得喝两瓶酒，工作也很糟糕，1994年打工回家，口袋里只有30块钱。之后几年，他磕磕碰碰在全国各地跑工程，干包工，女儿都由奶奶带着。2005年，女儿上初中，考试全年级第一名，看到女儿的成绩，陆世华下了一个决定，把对亡妻的思念做一个切割：“我决定我不再很想老婆了，把精力放在女儿身上。”

片口乡是北川县北部山区的小地方，上世纪80年代才通车，地震后才铺了水泥质的盘山公路，现在由片口乡开车到老北川县城都还需要近两小时，沿路都是注意飞石的警告牌。**陆世华很在意孩子的成绩，心里也有一个下一代能“走出大山”的憧憬，考入北川中学后，父女俩商量着考大学的事情，最后共识是北京师范大学——师范专业的花费比较少。**

所有的计划都被突然的地震推翻了。

那一年陆世华39岁，他很在意中国传统意义上的“男人的责任”——消沉和悲伤都是“不该有的”，维权无望后，更现实的问题是怎样活下去？他接受了来自成都高校团队的心理治疗，再后来，他决定要再做一次“切割”，把今后的生活和对女儿的思念做一次切割。

2010年，陆世华的小女儿诞生。“**我的生命能够得到延续，但是有很大很大的压力**。”陆世华的父母已高龄，女儿还小，

自己的身体也开始老去。现在，陆世华一家与父母同住在一栋三层的房子里，一楼出租给人做店面，地震后周边多了一些建设工程，陆世华就到附近工地打工，但近两年基本都完工了，没有活的时候，他就摘山上的野菜卖。

小女儿今年八岁了，在乡里上小学，家中墙上贴着她幼儿园时的奖状。陆世华得意地说，她期末考试得了“双百”(两个100分)，他专门拿出一个文件夹，保存女儿上小学以来的奖状。小女孩知道自己有一个去世了的姐姐，自三、四岁开始，就跟着父亲一起去拜祭姐姐，有时经过老县城，她会主动提议去“看姐姐”。

关于过去地震的事，陆世华跟小女儿说得不多。复杂的家庭组织方式和地震的敏感问题，都不好跟这个八岁的孩子解释，他只希望尽可能地让女儿健康快乐地长大。

不再高调地为去世的孩子“讨公道”，是陆世华对现实的妥协。清明节时，他写了一段话，开头是这样的：“**我们无力为冤死的孩子们讨还公道……只有在祭奠时弱弱的问一声：十年了，孩子们你们还好吗？天堂可有不垮的教室？**”

这段话，陆世华已经可以一字不差地背下来。他也曾经想过，呼吁在北川中学遇难学生集体墓地上建一块纪念碑，后发现不可行。

“十年来在政府的‘鼓励’、‘帮助’下，许多家庭都再生育了子女，其中不乏病孩，他们举步为艰，生活困难……做为’5.12’的直接受害者，再生育家庭，他们是社会问题？政府问题？总归是家庭问题。他们缅怀冤死的孩子，同样为生计而劳苦，夜静常思：我们拿什么让再生育孩子成人？拿什么让他们成材？”那段话的下半部分，陆世华继续写道。

陆世华还是想做点事，随着小女儿的长大，他开始关注再生家庭的状况。在片口乡，外出打工多年的陆世华比多数同乡都能说会道，**四月份他走访统计了乡里五户再生家庭的情况，并一一记录下来**：

刘庆(8岁)就读片口义校二年级，住校，距学校约十五里，步行往返。

爷爷向兴富(86岁)双目失明。

爸爸向明坤(49岁)，务农。

妈妈：刘兆玉(46岁)，务农。

二哥：向正俊(21岁)，外出打工。

大哥：向正华(高一、七班)北川中学遇难。

王兴顺(8岁)就读片口义校，住校，距校约40里地，摩托或步行往返。

奶奶：何志芳(78岁)双足残级。

爸爸：王应龙(53岁)多病，务农。

妈妈：扬明秀(49岁)务农或打短工。

姐姐：王雪莲(北川中学高一十班)遇难。

……

陆世华曾经联系过公益组织，想为再生家庭的孩子办公益活动，**但最后都没有成，他说当地也没多少公益组织关注**。

他细细地数出片口乡再生家庭面临的种种问题：父母子女的年龄差约为40岁、片口本是山区，走山路接送孩子的艰难、务农为生的家长身体衰老带来的压力。和陆世华告别时，他摇着头，咳了一声，又重复了一遍再生家庭的问题，那天下午他已经说过不下五次，最后陆世华用这句话来结束：“**他们的情况不是外人能懂的。**”

### 八、冻结时代

失去自由的日子里，谭作人反复在问自己一个问题：“我错了吗？”

“**没有，我相信错的不是我**。”这是他的答案，和他在上诉书中所写的一致：“我无罪，我不服，我抗议，我上诉！”

在狱中，谭作人一直计划着出狱后启动一个更大规模，且得到官方机构认可或协助的调查。他认为自己的公民独立调查受限于个人能力和物质条件等，不可能是一个很完整和权威的调查，只是一个抛砖引玉的作用。出狱后，谭作人联系过“最不怕事”的艾未未，找过艾晓明、范晓等过去有一同调查的学者，还想通过他们去联络体制内的专家学者。

“我说我们来做一次合作，不分体制内外，也可以说完全民间的，也可以是民办官助的，甚至批判我这个都可以，**做一个更规范的、更完整的512学生报告，一个正式的作品，送给国家有关部门**。“谭作人说着自己当时的想法。

事实上，谭作人并不是一个异议者，他从来都是一个乐于与有关部门沟通的建议者，这个形象还得到过官方认可——四川省人大采纳了他提议的《大熊猫保护管理条例》、主流媒体把他评为“成都市文明市民”。他建议石化厂该选更合适的地方，建议政府不要为小部分的“豆腐渣工程”背黑锅。被捕之后，他还在反思自己发起调查的时间和方法是不是有欠妥的地方。

早年的环保工作经历令谭作人明白，有些事情光靠民间力量是无法完成的，而民间可以做的，**是迫使政府入局——用事实令政府无法回避问题**。没料到的是，原本计划首先递交给政府参考的512遇难学生调查，因他被捕而提前在网络公开。

**更没有料到的还有2014年后的社会环境，竟然比五年前要更加紧缩**。朋友劝说他：“别做这些事了，还没受够罪啊？”

艾晓明没有积极回应谭作人的新计划，她说主要有两个原因，一是不在四川本地，不太容易找到参与的形式。二是公共参与的空间已经大大缩紧了，自己也变成社区维稳监控对象，行动有困难。**当年在做512校难调查的时候，调查计划可以在网络上公开发表、传播，年轻人可以表达意见，并且参与其中，但现在不行了**。

“还有一个，热点特别多，现在需要回应的事情也特别多。“艾晓明补充道。

事情特别多。就在谭作人出狱未足三个月的时候，他当年的辩护律师、赫赫有名的浦志强被捕，同年年底谭作人案的另一位辩护律师夏霖在家中被带走，这两位常年代理维权案件的律师，各因不同案由而获刑：浦志强在被羁押一年多后，被判三缓三，律师执业资格也被吊销；夏霖被判10年，至今仍在狱中。自2015年以来，有类似遭遇的维权律师不在少数。

律师们的遭遇被作家野渡评述为“冻结时代的开端”，即进入到一个严格管控、社会活力和空间都大大受限的时代。

艾晓明认同这个判断，但她也认为，**社会运动是有潜流在的：“好像这个河流，你看着表面是冻结的，但是你不可能是冻到深层的，冰下面是有活水在涌动的，或者有时候在冰比较薄的地方，它就会爆发出来，奔涌出来。**”自2018年初以来，中国高校爆发出的反骚扰“MeToo”行动便是一个佐证，艾晓明把“MeToo在中国”看作是一种社会运动的形式，同时也是社会运动往前推进的证明。

“你看到了牺牲，但牺牲也不是没有结果的。“在2015年3月，五名女权主义者因策划在公交车派送反性骚扰卡片而被羁留三十多天，此事被称作“女权五姐妹事件”。艾晓明看来，如果没有“五姐妹”提出性骚扰的问题，以及由此激发出的讨论，也就没有现在的“Me Too”。

**时至今日，谭作人依然在为512校舍问题追一个答案**。2016年他递交公民建议书，送给了多个政府部门，包括中纪委和全国人大常委会，结果都是石沉大海。今年，他又再次寄送公民建议书，结果似乎更坏了，有的快递直接被拒签，而他自己也把的期待值降得很低：“**十周年，我还是想再努一把力吧。也许按照他们的惯例，一直拖，能拖一天是一天，拖一年是一年，我都不知道会不会有这个力量一直坚持下去……但我觉得还是应该做的，不管有用没用。**”

他补充说，其实每一个人都可以写公民建议书。

不管是2008年底发起的512遇难学生调查，还是现在的公民建议书，谭作人都在强调法律的重要性，也多次回应过对中国司法信任度的问题，他觉得不是自己有多相信法律和正义，而是“这是寻求公正的唯一途径”。**他还提炼出一个行动原则：和平、理性、合法、有序**。

“上中下形成活力，下面家长们坚持，在司法轨道上解决问题，中层，社会的各种力量，特别是媒体、律师，去介入这个问题，最上面，如果下面和中间这两个层面都有了，最上面不会完全无动于衷的。”在这十年，经历过天灾人祸、调查、入狱、监控后，谭作人关于行动改变社会的想象似乎并未改变。

应受访者要求，陈丽、李红均为化名

作者 \| 陈四格

制图 \| 白皓龙

校对 \| 张子尤、许乐
