---

layout: post

title: 周保松：面對高牆，如何成為一枚有力量、有尊嚴的雞蛋？

categories: Archive

date: 2018-05-21 13:00

tags: 周保松

image_feature: "https://i.imgur.com/KTGbgmt.jpg"

description: 高牆並非鐵板一塊，作爲雞蛋的我們也並非無能爲力，只要仍保有一定的自主意識和道德意識，即使在最惡劣的環境，也能活得生機勃勃。

---

> 本文由 [简悦 SimpRead](http://ksria.com/simpread/) 转码，原文地址来自[端传媒](https://theinitium.com/article/20180523-opinion-zhoubaosong-egg-with-dignity/)
>
> 「端传媒」是华语世界里很不错的独立媒体，喜欢、支持端传媒的读者，可以[购买会员](https://theinitium.com/subscription/offers/?utm_medium=paywall)阅读更多深度报道、参与讨论。
>
> 文章最初发布于微信 ~~「[微思客](https://mp.weixin.qq.com/s/uPaOVCG6TU63eG4_H2zo-A)」~~
>
> 微思客网站[原文](https://wethinker.com/2018/05/21/18860/)

---

![](https://i.imgur.com/KTGbgmt.jpg)

> 我們活在世界之中，不是世界之外。我們認真生活，我們執着是非，我們身體力行，不僅在改變自己，同時也在改變世界。這些力量也許一時看來微弱，但只要有陽光有泥土有水份有意志，說不定某時某刻，水泥地上也能長出花。 攝：林振東 / 端傳媒

**【編者按】** 本文是香港中文大學政治與行政學系副教授周保松接受中文知識社群「微思客」（WeThinker）的訪談。微信公號原文已被刪除。端傳媒經作者授權轉載，以饗讀者，文字有小幅修訂，原題為「做一隻有尊嚴的蛋」。

周保松先生在為端傳媒版本的按語中寫道：「這篇訪問是去年做的，微思客編輯最近將初稿傳我校訂時，我發覺由於時局改變，我的想法和心境已大大不同，遂將訪問重寫了一次，以期和許多處於困頓中的年輕朋友分享一點感受。很可惜，它在微信上僅僅存活了一天，便已被消失。它的命運，正印證了時代的肅殺。謝謝端傳媒，讓它能夠保存下來。」

今年一月，脱口秀演員李誕在接受《十三邀》主持人許知遠採訪時，提到自己在《南方人物週刊》實習時的一次幻滅經歷。在那之後，他認清了世界運行的規律，並選擇迅速地加入其中，力求讓自己在最短的時間內完成「社會化」的進程。這期節目一播出便引起熱議，有人繼續批評許知遠的不合時宜，也有人將靶子對準了李誕這樣的年輕人。

如今似乎是這樣一個時代：退居小我的人越來越多，且這一現象呈現出日漸年輕化的趨勢，不僅中年人在社會的重重壓力下愈發現實，年輕一代也變得日趨精緻而冷感，對稍有歷史感的事物感到興味索然，更不要說警惕「房間裏的大象」了。與此同時，社會和輿論本身也正在製造並迎合這種趨勢，我們不禁想問：這背後的原因是什麼？如今的社會是一個適合年輕人自由發展的環境嗎？

在「迫不得已」變得利己的青年們背後，有一些背棄初心、擁抱建制的知識人。這些在學術界享有極高聲望和龐大資源的學者們紛紛轉向，背後的原因和造成的影響值得我們認真對待。

即便如此，面對充斥着諸多不公而令人沮喪的大環境，明辨是非的人不應感到氣餒。日本作家村上春樹曾以高牆和雞蛋來比喻體制和個體，乍聽起來十分鼓舞人心，但在香港中文大學任教的周保松老師看來，這一比喻本身有許多值得進一步深思之處。高牆並非鐵板一塊，作為雞蛋的我們也並非無能為力，只要仍保有一定的自主意識和道德意識，即使在最惡劣的環境，也能活得生機勃勃。

> 如果權力以粗暴方式將公共生活的門徹底關上，那就意味着在最根本的意義上，我們被迫從人的社會性中異化出來，難以活出完整的人生。

**微思客：現在大學校園裏普遍存在的一種現象是：聽講座是為了湊學分、好畢業，似乎那種依然懷有理想主義的年輕人變少了，大家變得越來越只關心個人層面的東西，以前對於家國天下的那種擔當感不多見了，您覺得在當下這種責任感如何能在學生群體中確立起來呢？**

周保松：這個問題真是說易行難，尤其在目前的大環境下，那些有正義感且付諸行動的人，往往要付出很多代價。這些年來，我接觸到的年輕人，許多都正直善良、關心社會，並有很強的參與公共事務的願望。但我們看到：在許多公共議題上，即使是非黑白十分清楚，你也很難真正發聲，甚至有時候，你關心它，還會給自己帶來不少麻煩。

在這樣的環境下，年輕人轉向「小確幸」，將生命退回到個人的小世界，追求安全穩定的生活，並對公共事務持一種戒懼、懷疑、嘲諷以至漠然的態度，其實都可以理解。說句老實話，每每見到那些勇敢站出來卻遭受嚴厲打壓報復的年輕人，我總是有說不出的難過。

我們的時代，是公共生活嚴重缺失的時代，而這並非我們的選擇。我們須意識到：長期被排斥出公共生活，我們將活得極不完整，並失去生命中許多重要之物。為什麼這樣說呢？我們一生下來，就活在社會中，並在不同領域和不同的人建立各種社會關係。家庭、學校、教會、工會、公司、自治團體、網絡社群，以至國家，都是一個個社會領域。我們在這些領域中吸收營養、發展自我，並通過各種實踐去建立身份認同和尋找生活意義。

換言之，這些領域不是可有可無，而是一個人完整發展的重要條件。只有通過參與和投入公共生活，人才有機會建立各種社會聯繫，藉此發展我們的能力，使得我們成為心智健全的社會人 (social beings)。

如果權力以十分粗暴的方式，將許多公共生活的門徹底關上，並把人困在一個極度有限的空間，那也就意味着在最根本的意義上，我們被迫從人的社會性中異化出來，無法體驗和實現公共生活賦予人的種種價值，我們因此難以活出完整的人生。

以大學為例。如果大學生被嚴格限制參與公共事務，他們就無法通過公共參與去發展他們的理性反思和道德實踐能力，也就無從培養出他們的公共關懷。長期活在這種封閉的狀態中，久而久之，人們或會視之為理所當然，並無法體會這種生活對自身帶來多大的傷害。但我作為教師，看着許多年輕人因為制度的原因而無法活得自由完整，實在覺得很可惜。

所以回到你的問題，我覺得我們不宜將所有責任簡單地歸咎於年輕人，甚至輕省地稱他們為精緻的利己主義者，然後要求他們時刻心懷家國。因為問題的根源，主要不是出在他們身上。年輕人不是不想關心社會，而是根本沒有這樣的條件。如果他們當中有人真的坐言起行，各種警告就會隨之而至，要求他們立刻退回個人的小世界，不要「多管閒事」。這樣的大環境不改變，我們很難苛責年輕人缺乏社會責任感。

> 只要我們稍稍清醒，當會見到表面的繁華背後，我們的文化，早已沈痾遍地；我們的社會，早已危機四伏。

**微思客：聽起來有點令人沮喪。但在這樣的大環境下，個體可以如何自處？**

周保松：這是很難回答的問題。理想來說，如果我們每個人都能出一分力，都願意站出來對不合理不公正的事情說不，這自然最好。因為大的制度環境不改變，活在其中的所有人都會受到影響。可是我們也知道，這種想法在現實中很難實現，因為我們無法找到一個機制，確保大家願意共同承擔參與社會改革的成本，因此難以解決囚犯兩難（編者注：Prisoner's Dilemma，是博弈論的非零和博弈中具代表性的例子，反映個人最佳選擇並非團體最佳選擇）和坐順風車（編者注：指坐享其他成員的功勞）的問題。

所以對許多人來說，最理性的做法，是完全順從既有的遊戲，並期望自己能在遊戲中玩得比別人好，從而獲取最大回報。至於遊戲規則本身是否公正，他們並不在乎。不僅不在乎，甚至會想盡方法去維持這個規則，因為這樣對他們最有利。

我們由此遂明白，一個明明極度不義的制度，為什麼還會得到那麼多人的擁護。有的時候，確實是因為人們不知道自己在做什麼；但更多時候，人們是清楚知道卻選擇視而不見，並相當有默契地去為現狀辯護。說得直白一點，這是共謀。

在這種情況下，那些對社會還抱有希望，對是非對錯還有執着，並且不忍心見到社會中的無數弱者受到各種各樣的剝削和欺壓的年輕人，面對這樣殘酷的現實，他們會有怎樣的感受？

他們一定會非常非常的失望、憤怒和怨恨。他們的心越善良越敏感，便越痛苦，越難忍受這個世界變成這樣。這些年來，我遇到太多太多這樣的年輕人。在香港，在大陸，在課室，在網絡，我常常聽到他們的呼喊和哀鳴。

他們最後會走向哪裏？大部分走向絕望，並不得不向這個世界妥協，讓自己的心變得堅硬冷漠，一點一點放棄原來的信念，一步一步融入既存秩序，變得務實、世故、玩世不恭、失去同情心、崇拜強者鄙視弱者，並最終接受用金錢和權力去衡量世間萬物的價值和意義。

這實在是很悲傷的故事。

是誰使得這些悲傷的故事天天在我們身邊發生？是誰令無數純樸善良的年輕人無法活出正直有愛的人生？

說實在話，在任何社會，特立獨行都不容易，但在中國卻是加倍的艱難，因為容許這種可能性存在的社會空間實在太小，而為之付出的代價實在太大。你的憤怒，你的痛苦，你的理想，你的追求，只要不為主流所認同，便會受到各種各樣或明或暗的打壓。

既然如此，一個明智的人，為什麼還要走這樣的路？有年輕人甚至這樣問過我：既然這樣，人為什麼還要獨立思考？──如果明明知道獨立思考會給人帶來那麼多痛苦。

「未經反思的人生是不值得過的。」蘇格拉底如是說。但如果高牆牢不可破，現實如此醜陋，我們睜開眼睛，直面真實，豈非令人活得更加痛苦？反思過後，我們又從哪裏找到勇敢活下去的力量？

這是異常嚴肅異常艱難的問題。

最為諷刺的，是我們的教育，我們的大人，某種程度上正是希望年輕人變成這樣：不要質疑，不要挑戰，只須聽話和服從。我們的社會，我們的時代，實在辜負了太多太多年輕人，沒有提供一個稍稍像樣的環境，讓大家可以自自然然快快樂樂地做個善良正直的人。

出路在哪裏？我想稍有常識的人都知道，除了制度改革，沒有別的出路。

制度如何改變？必須靠人。制度和文化，不會無緣無故自己變好，而是必須靠人的努力，而且不是靠一兩個悲劇式的英雄，而必須靠許多許多人意識到問題所在，了解到自己的責任，然後願意承擔起這個責任，並共同努力去推動社會變革。

這裏的許多人，不是指一代人，而是好多好多代人。我不知道我的同輩中有多少人有這種自覺，但我自己確實是這麼想。我這些年在教學上、寫作上以至公共實踐上所作的努力，也許作用十分微薄，但卻很少氣餒，因為我一開始便清楚，前面的路還很長，而且極為艱險。我及我這一代人所做的，最多也就是在學術、教育和公共文化上，做一點點鋪路除草的工作，讓後來者不要走得太吃力。也許我們每個人的力量很微小，但只要大家都願意付出一點點，情況就會不一樣。

這個過程會很緩慢，途中會遇到許多挫折，但我們只能如此，也必須如此。

有人或會說，你實在太悲觀了。我們正活在一個偉大的新時代，國力強盛，經濟繁榮，人民安居樂業，對國家充滿自豪。我也希望如此。但只要我們稍稍清醒，當會見到表面的繁華背後，我們的文化，早已沈痾遍地；我們的社會，早已危機四伏。

中國要變得自由公正，就必須有更多的人清醒地認識到這些現實，並在不同的位置努力，合力推動社會轉型。就此而言，獨立思考、批判精神、重視社會正義和人文關懷，不僅沒有過時，而且更為迫切。

> 過去這十年最令我遺憾的，是目睹許多我曾經十分敬重的學術界前輩和同輩，放棄讀書人的基本立場，背棄最初的信念，改為全面擁抱建制。

**微思客：但若回歸現實，馬上就會有人提出這樣的疑惑：你說的都有道理。但正因為太有道理，當權者也深明這個道理，所以才千方百計地使得你所期望的不會出現，才會用盡各種手段遏制獨立思考和自由發聲，而那些成熟世故的學者才會那麼懂得辨別風向，聰明地用各種學術包裝為既存秩序搖旗吶喊。既然那麼多知識精英都已如此，年輕一代難免心灰意冷。**

周保松：我明白你的感受。最近這些年，中國知識界獨立性和批判性的日益缺失，確實讓人擔憂。不瞞你說，過去這十年，最令我遺憾的，是目睹許多我曾經十分敬重的學術界前輩，還有不少同輩知識精英，一個一個放棄讀書人的基本立場，背棄最初的信念，改為全面擁抱建制，成為我不再認識的國家主義者和反自由主義者。

這些朋友的選擇，也許有不得已的苦衷，也許有別人無法知悉的盤算，但如此大規模的整體性的轉向，仍然是個觸目驚心的現象。那些在中國重點大學位居要職，享有極高學術聲望以及擁有龐大學術資源的前輩，為什麼會有這樣的轉向？他們難道一點不在乎自己的學術人格和歷史評價嗎？這是值得嚴肅對待的問題。

如果我們對此視而不見、又或見而不當一回事，我認為是不負責任的，這會助長越來越多的人棄守底線。我這樣說，並不僅僅是要站在某種價值立場做一個道德批評（雖然這無可避免並且十分必要），也不是要針對任何特定學者。只是如果中國知識界的許多重要人物都放棄了基本的學術底線，例如對真理正義的堅持，對言論思想自由的捍衞，對極權專制的批判，那麼知識界就會喪失自己的靈魂，因而無法承擔起本應有的社會責任：從人的價值和尊嚴出發，以獨立理性的態度，對制度、權力、習俗、成見、壓迫、奴役、苦難、不義，作出持續不懈的反思批判，藉此啟迪民智，累積資源，推動社會進步。

也許有人會覺得這種想法早已陳舊落伍，甚至嘲笑我這種仍然自稱自由主義者的人不識時務，但作為一個讀書人，在這樣的時代，不去守護思想自由，不去捍衞人權法治，不去關懷弱者，不去批判專制，卻天天圍着權力打轉，並用盡各種方法操弄和包裝一些貌似高深難明、實質毫無具體內容的所謂大理論大論述然後以此曲學阿世，又有什麼值得我們嚮往和效法？難道我們從近代史中得到的教訓還不夠多嗎？

我雖人微言輕，但還是不得不在此對這些我曾經敬重的前輩及同道，懇切地表明我的態度：為了中國長遠的政治和文化建設，為了給年輕一代做個不那麼壞的榜樣，當然也為了自己的名聲，請珍惜自己的羽毛吧。

> 我們許多時候覺得無力，甚至虛無，固然是由於外在壓力太大，但同時也是由於自己的知識和道德積累不夠深厚。

**微思客：一個困擾許多年輕人的問題是：面對這樣無奈無力的大環境，我們是否真的仍有理由，在這樣不公正的社會努力做個公正的人？我們這樣做，真的不是傻瓜嗎？**

周保松：這是相當根本的存在之問。我相信，凡是認真對待生活，對世界仍有要求仍會憤怒的人，都曾經在生命某個階段被這個問題折磨──無論最後活出怎樣的答案。

這個問題很重要，也很難，我恐怕沒有能力給出一個大家滿意的回答，但我願意分享幾點個人體會。

第一，要活得有力量，能認真地、較真地思考很重要。要思考，就得讀書，而且要帶着對現實的關懷去讀。我們許多時候覺得無力，甚至虛無，固然是由於外在壓力太大，但同時也是由於自己的知識和道德積累不夠深厚。

一時的激情容易，持久的堅持卻很難。要堅持，就須清楚知道自己為什麼是對的，堅持的理由是什麼，而現實中種種制度之惡為什麼是惡，並在什麼意義上踐踏人的權利和尊嚴。

這些問題，需要嚴肅認真地思考。我們想得越深，理解得越充分，便越有信心守住自己的信念，不會那麼容易一遇到挫折便退縮，以及不會被許多似是而非的大論述忽悠。在此意義上，思想本身，就是一種不妥協，就是一種抗爭，並會給人帶來力量。

第二，村上春樹在 2011 年那篇有名的耶路撒冷文學獎演講辭中，有個大家都很熟悉的關於「雞蛋和高牆」的比喻。高牆說的是體制，雞蛋說的是個體。村上然後說：「以卵擊石，在高大堅硬的牆和雞蛋之間，我永遠站在雞蛋那方。」

這個說法很動人也很鼓舞人心，因此廣泛流傳，但我認為有幾點值得商榷，並能從中得到一些回應上述問題的啟示。

首先，在村上筆下，體制似乎是完全負面的，純粹是用來壓迫人、奴役人、剝削人，甚至碾碎人的。若果真如此，人的自由和解放，也就只剩下一途：就是所有雞蛋聯合起來推翻一切體制。

但一開始為什麼會有體制？村上承認，體制是由人創造的，而體制本來的目標，是保護我們。既然如此，體制並不必然是惡的。我們真正要爭取的，不是要推翻體制本身，而是爭取建立公平的民主的體制，使得每個雞蛋都受到保護，都能有尊嚴地生活在制度裏面。

這個概念區分，看似微不足道，實質卻很重要，因為牽涉到我們如何理解政治以及政治為何必要。如果體制本質上就是惡的，那麼人的解放只能通過否定政治來達成。如果制度是人與人組成聯合體共同生活的必要條件，那麼人的解放便是通過改變那些壓迫人的高牆，重建更好的制度。因此制度本身不是我們的敵人，邪惡的制度才是。也就是說，制度本身不一定就是與個體為敵的高牆，不義的制度才是。

其次，村上又說：「我們每個人都擁有獨特而活生生的靈魂，而體制卻沒有。」在這種想像中，體制必然是非人的，和人對立的，並以冷酷、有效率和系統化的方式去支配和宰制個體。

可是如果我們多問一句：誰來運作體制？是人。沒有人，體制便無法運作。

雞蛋的一方是人，高牆的一方也是人。因此，壓迫的本質，是一些人藉着體制去壓迫另一些人。如果某個體制是惡的，我們不僅需要問這個體制出了什麼問題，同時也要問，為什麼村上所說的那些獨特而活生生的靈魂會選擇加入體制，並對另一些獨特而活生生的靈魂作出壓迫和奴役。如果我們不好好正視和反思這個問題，並使得更多的人意識到高牆之惡，然後不再站在牆的一方，那麼就很難有真正的改變。

> 我們每一個人，雖然看似是雞蛋，有時也會成為高牆的一部份。高牆不僅可以豎立在外面，也可以生長在人心。

更重要的，是我們也須意識到，我們每一個人，雖然看似是雞蛋，有時也會成為高牆的一部份。在工廠，某位男性工人是資本家的雞蛋，但一旦回到家，卻可能立刻成為妻子眼中的高牆。人類壓迫的複雜性，遠超雞蛋與高牆這種比喻。每個個體在社會制度中都擁有多元混雜之身份，可以同時是白人、男性、工人、基督徒和同性戀者，因此可以使得同一個人既受壓迫同時也享有特權。

更重要的，是高牆不僅可以豎立在外面，也可以生長在人心。人基於國家、種族、宗教和性別而來的各種「意識形態」（ideology），往往成為人心中的高牆，並在生活中不自覺但卻極其粗暴地碾壓其他雞蛋。這是更深一層、因而也是更難應對的內在於不義社會的高牆。通過無所不在的各種意識形態宣傳和以教育之名的政治規訓，活在其中的個體幾乎無可避免地內化了許多高牆的語言和價值觀，因而或多或少也成了其中的一部分。

我們因此要常懷謙卑和警惕，意識到要走出人壓迫人的制度，要建立公平公正的社會，不是簡單的 how 的問題，更是複雜的 what 和 why 的問題；也不是純粹的善良個體對抗複雜的不義體制的問題，更是個體如何充分意識到體制以不同方式形塑、影響及支配我們的思想、情感和行動的問題。

要回答這些問題，我們需要發展和充實我們的反思意識和道德意識，需要對人和社會的複雜構成有深切認識，然後在公共討論和公共實踐中逐步形成底線和共識。我們每個人都身在其中。我們需要批判，需要反抗，同時需要自省。這是艱難的漫長的學習過程。

最後，我們要知道，高牆絕對不是村上想像的那樣鐵板一塊和牢不可破。既然維持高牆的是人，而人就其本性而言，是會思考、有同理心和是非心、脆弱、且有各種基本需要的獨立個體，那麼只要有越來越多的人意識到這些本性，且重視這些本性，體制便會出現各種裂縫。人的自主意識和道德意識具有強大的生命力，即使在最惡劣的環境，也會頑強生長，並努力守護人之為人的基本尊嚴。人的善良本性，是黑暗中的光。

我們活在世界之中，不是世界之外。我們認真生活，我們執着是非，我們身體力行，不僅在改變自己，同時也在改變世界。這些力量也許一時看來微弱，但只要有陽光、有泥土、有水份、有意志，說不定某時某刻，水泥地上也能長出花。

我們要有這樣的信心。
