---

layout: post

title: 动辄约谈，心存防范，高校信息公开还要迈过几道坎？

date: 2018-04-25

categories: Archive

tags: 高校信息公开

description: 尽管时隔两年，一些研究者提起高校信息公开时，仍记得2016年发布的《中国高等教育透明度指数报告》中一个戏剧化的结果：北大清华双双跌出前50名。

---

原文来自 ~~[中青报深度](https://kuaibao.qq.com/s/20180425A1EION00)~~

作者：中青在线记者 卢义杰实习生 杨慧彩 贾天荣

---

尽管时隔两年，一些研究者提起高校信息公开时，仍记得2016年发布的《中国高等教育透明度指数报告》中一个戏剧化的结果：北大清华双双跌出前50名。

“当时有很多议论，一些高校也不服气，认为自己是很好的学校，透明度怎么低了呢。媒体也来问我们。”项目组成员、中国社会科学院法学研究所研究员吕艳滨说，这些高校没公开教育部要求主动公开的一些事项，做得确实不到位，“可为什么还有异议呢？”

这是一个与传统的高校评价体系不同的世界。在吕艳滨看来，建设世界一流高校，必须改变唯教育质量、唯科研成果的评价机制，“我们也要比拼治理水平，看能不能、敢不敢在别人眼皮底下做管理、做教育”。

**应该是“重要”并且“正常”的**

10年来，吕艳滨和同事们与信息公开打了不少交道。2008年《政府信息公开条例》施行，社科院法学所此后发布了《中国地方政府透明度报告》，那时已有人注意到，条例提及，教育等与人民群众利益密切相关的公共企事业单位，在提供社会公共服务过程中制作、获取的信息的公开，参照该条例执行。

一项如今才满8岁的制度产生了。2010年，教育部出台《高等学校信息公开办法》（以下简称“《办法》”），4年之后列举了《高等学校信息公开事项清单》（以下简称“《清单》”）。社科院法学所的法治指数创新工程项目组，随即选择了115所高校，将透明度评估也投向高等教育。

几乎与此同时，21世纪教育研究院也进行了同类的评估。两家机构的调研结果都显示，教育部直属高校的公开程度普遍好于其他高校，不过，一些传统顶尖名校反而不“顶尖”了。

吕艳滨说，这个现象事关一种治理理念：“大学是不是把学生教好了就行？”

在他看来，如今评判高校多看教育质量、科研成果、师资等，但忽略了高校治理水平。其实，公开透明是高校治理、社会治理非常重要的手段，“如果不公开透明，就可能有不规范的行为，或者虽然行为是规范的，但也容易引起质疑、影响其公信力”。

作为两家机构的评估标准，教育部的《清单》包含10大类50条应主动公开的项目，小到奖学金申请规定，大到学术不端行为查处机制，甚至 “涉及学校的重大事件的调查和处理情况”，都位列其中。

根据《办法》，除了这些，公民、法人和其他组织还可根据自身学习、科研、工作等特殊需要，以书面形式向学校申请获取相关信息。事实上，向高校依申请公开的数量并不多。有研究者曾以部属高校中的74所为样本分析，发现他们2012~2013年度仅受理了99个申请，2014～2015 年度也只有354个，平均每个学校不到5个。

中国青年报·中青在线记者进而统计这些高校2016~2017年度的信息公开年报发现，74所高校的受理数量仅为267个，有9所高校为零申请。

多名研究者对记者分析，这并非民众缺乏信息需求，而是不少人不知道有这项权利，并且，在实践当中，少数申请者或是已和学校“闹得比较僵”，或有时被误解：他是不是和学校对着干？他是不是“刺儿头”？

于是，制度“很重要”，权利行使“很正常”，成为受访高校信息公开制度研究者口中不约而同的高频词。

21世纪教育研究院副院长熊丙奇观察到，这几年，推进高校信息公开前进的主要力量，不是师生和普通民众，而是政府部门对公开的要求，以及媒体的不断呼吁。

吕艳滨把高校信息公开与政府信息公开作了比较：在过去，许多人不知可申请公开，有的政府部门遇到突发事件、安全生产事故也捂着盖着；但现在，公开是常态、不公开是例外，政府越来越勇于公开了。

“这需要转变过程。”他感到，尽管高校信息公开有诸多不足，但整体发展仍然向好。

![](https://i.imgur.com/cllkPjL.jpg)
<figcaption>图片来自网络</figcaption>

**部分高校被指仍有防范心态**

这个新生的制度激发了诸多研究者的兴趣。2017年前后，与熊丙奇同在上海交通大学工作的副研究员喻恺，一度向397所高校递交了申请，要求公开学校年度受捐赠财产的来源、金额以及支出情况。

这是一项同时列入《办法》和《清单》的内容，理论上高校应当主动公开，但陆陆续续收到的答复让喻恺和他的学生感到意外。

喻恺在一篇论文里透露，397所高校当中，仅有101所给予了答复，其中同意公开的有96所，若再去掉未按《办法》要求在15个工作日内答复的高校，则只剩下92所。严格意义上，这次实验得到的公开率大约是 23.2%。

社科院法学所遇到的情况稍好一些。2015年，他们申请公开的是高校毕业生就业情况、校领导社会兼职情况，这同样是《清单》中应主动公开的内容。不过，179所高校里也只有将近一半予以答复。

吕艳滨向中国青年报 · 中青在线记者回忆，当年寄出信息公开申请之后，有的地址无法寄达，有的寄到却无人查收，有的学校收了之后追问 “你为什么要申请公开这个”，很多学校索性不答复，或答复了但回答得不理想。

喻恺的经历也类似。他撰文批评部分高校“过度收集申请人信息”，比如，黑龙江某高校要求他们出具所在单位对申请人身份的证明，北京某高校的要求更多，包括告知研究的项目（课题）名称、编号、级别、批准单位及项目（课题）负责人等，而且还须加盖学校或学院公章。

另一些高校的处理同样不规范，比较典型的是，山东某高校仅回电进行了口头答复，广东某学院要求喻恺团队来现场办理，而厦门某学院拒绝公开信息，理由为“无意参与研究”，并未意识到信息公开是一项义务。

事实上，397所并非喻恺团队全部的调研样本。他们调研高校的数量是 1219所，但在相关网站中提供了申请信息途径的仅397所。其余822所高校中，有627所未设立依申请公开栏目，195所虽设立了但链接无法访问。

这些原本应主动公开的信息却屡请不出，熊丙奇分析称，原因之一在于部分高校带有“防范意识”。他认为，既然这些信息已是按规定必须面向所有人公开的信息，那就应该推定“没有任何申请人是别有用心的”，“申请是他的权利”，不该再纠结于申请人是谁、有何目的。

“申请公开本身就很正常，但如果追问‘你想拿这个来干吗’‘想拿来做文章吗’，这不就异化了吗？大学出现了学术不端，你去申请信息公开，学校问‘你是不是对我们学校有意见’，一旦问你的动机，这同样也异化了。” 熊丙奇说，这暴露了一些高校没有保障师生、社会公众充分的批评权利。

![](https://i.imgur.com/jUUziT9.jpg)
<figcaption>图片来自网络</figcaption>

**申请背后的 “私下沟通”**

中国青年报·中青在线记者发现，在申请受理之后，不少高校会提前分析和研判信息公开之后的影响，当出现敏感或负面事件的申请时此情况尤甚。一些教师还曾尝试在受理前后与申请人接触，但效果不一。

一名在校大学生告诉记者，自己申请过学校某次“重大事件的调查和处理情况”的信息公开，包括处理时的会议记录、政府部门的通报等。这无疑触动了学校敏感的神经，事后，负责学生工作的教师找他谈话了。

“老师问我，为什么会作出这样一个选择，是什么样的考虑，我说了我的想法，他也谈了他的看法，说学校可能会有什么顾虑。他还记了我对学校工作的建议。”这名学生回忆，谈话是在一个相对轻松的场合，教师没反复纠缠，最终，公开申请也没被要求撤回。

另一些大学生的境遇则很糟糕，有的教师与其长时间谈心到凌晨两点，有的则“邀请”家长到校商讨。这些做法迅速引起争议，反对者认为，这或将给学生无形中施压，暗示其应取消申请，一些长时间谈心还有变相限制人身自由之嫌。

“作为老师，与学生进行沟通，了解其思想的波动、生活的状态，这也无可厚非，老师也有这个权利、义务和责任去做。” 一名学者对记者分析，教师在合理限度内的关注或者适当引导，可以理解，但更重要的是，须切记申请信息公开是公民正常行使的权利，应该得到正常的回应。

被谈心的不只是学生，一名曾举报并申请人事、财务方面信息公开的高校教师说，在他行动以后，学院有关负责人时常找他谈话，希望能在组织框架内解决问题，接着，学院还为他争取了一些项目进行“安抚”。

不过，一些高校已开始重视前述“沟通”问题。某外语类院校校长办公室工作人员告诉记者，对学生的合理诉求，他们通常按流程向相关科室索要信息，之后直接给学生答复，“不会联系学院老师的”。

但仍有部分高校的工作人员，试图将申请“降格”。得知学生申请可能涉及敏感信息时，有工作人员建议：“平时可以自己去××部门问一下。”

吕艳滨认为，私下沟通可能停留在个人关系层面，而依申请公开是通过正规渠道获得准确、权威的答案。有的高校“如临大敌”，可能是因为过去的管理不规范，有些决策过程、结果按照现在的标准不敢拿出来晒。

在他看来，这不是学校特有的问题。过去，政府信息公开也存在类似现象，但现在政府意识到要公开，所以各方面开始努力做得更规范一些，“这是个阵痛，对高校也是”。

“公开不只是揭家丑。”吕艳滨说，每个机构都可能面临各种各样的问题，关键是怎么应对，“高校按照现有条件，处理好各方的关系，找到不足，甚至开诚布公地向师生、学生家长、社会说‘我有什么问题’‘我会怎样处理问题’‘我有哪些困难’，各方都会看到学校的自信和坦诚，反而有助于提升公信力。”!

![](https://i.imgur.com/tsJD7JI.jpg)
<figcaption>图片来自网络</figcaption>

**学者呼吁建立现代大学制度**

尽管是信息公开，但其实，一些申请者得到的答复，距彻底公开仍差最后一公里。一名大学生申请者告诉中国青年报·中青在线记者，学校最终只口头宣读了答复结果，不提供纸质文件，并希望此事限定在申请者中知晓。

受访的多名高校校长办公室工作人员则意见各异。有的坚称，不建议或不允许将得到的答复发布到社交网络上，更多的人对能否将其再传播表示不太清楚。

部分校方的谨慎态度让这一举动更显敏感。“公开的，基本是没什么问题的信息；不愿意公开很详细的，肯定是经不起推敲的信息。”熊丙奇认为，久而久之，师生也会发现一个潜规则：能公开的都公开了，不公开的就是有难言之隐，再去申请，就是去触动它。

局面慢慢微妙起来。熊丙奇分析，师生可以申请公开，但现实中，这个合法的程序有时会受到很多因素影响，比如，学校对师生的考评权，就会让部分师生心存顾虑，不能放手行使权利；一些个别极端案例中，甚至反过来调查申请者，“这就完全异化了”。

“这里有制度的问题。”熊丙奇说，国家出台了诸多规定，高校信息公开比以前好多了，但是，通过行政部门推动的信息公开，虽有进步，但完成程度还是不够好。到最后，还是要实行现代大学制度，促进教授治校，“行政治校的情况下，师生申请公开的权利无法真正得到保护，因为是行政主导对你的各种评价、考核”。

吕艳滨发现，目前对答复采取的救济方式还不够明确。比如，若对答复不满意可以向上级教育部门投诉，但能否申请行政复议，这就存在一点问题，“高校只在高等教育法等授权范围内才具备行政主体资格，面对信息公开申请，其究竟是否具备行政主体资格，目前还不能说十分明确”。此外，一些法院也曾受理高校信息公开的案件，但属于民事纠纷还是行政纠纷，也有一些争议，下一步亦需在立法上完善。

“更重要的是高校的评价体系：除了科研、教学、师资，有没有考虑到信息公开做得好不好，有没有把治理能力作为评价的要素？”吕艳滨说，如果行政管理部门评价高校的导向不改变，高校重视信息公开的程度也很难有实质性改变，“要让高校认识到‘管理水平高，才有可能成为好学校’，而管理的基础是公开，要让师生参与管理，实现共管共治，而不是管理层单方面的管理”。

一名学生申请者也期待，通过申请信息公开能让学生和校方进行公开的良性互动，一起面对事件，“并不是逼校方说话”。同时，希望让更多人把这个制度当真，免于对参与公共事务的担心。

中青在线北京4月25日电