---
layout: post
title: 王睿恒：「遏制战略之父」乔治·凯南的中国观
categories: Archive
date: 2020-04-15
tags: 乔治·凯南
description: 凯南眼中的中国虽然历史悠久、文化灿烂，却是一个"自大排外""自私冷酷"又"不讲原则"的古老民族。
---

[王睿恒："遏制战略之父"乔治·凯南的中国观](https://archive.li/wRF2t#selection-41.64-41.86)

作者：王睿恒，南京大学历史学院副教授

来源：《美国研究》2020年第1期

---

【内容提要】乔治·凯南是美国冷战初期“遏制战略”的缔造者和苏联问题专家，对美国外交决策产生重要影响，特别是在他担任国务院政策规划室主任期间。但是，由于对中国社会和历史缺乏全面而深入的了解，凯南眼中的中国虽然历史悠久、文化灿烂，却是一个“自大排外”“自私冷酷”又“不讲原则”的古老民族。这种负面的中国印象直接影响了乔治·凯南对 中美苏三国关系的定位以及冷战时期美国外交政策。乔治·凯南的文化教育背景、好友小约翰·戴维斯的影响及其信奉的现实主义政治理论是影响他的中国观的主要因素。

乔治·凯南(George F.Kennan，1904~2005)是冷战初期美国对苏联阵营实行“遏制政策”的提议者和设计师，在1947年至1949年担任国务院政策规划室(PolicyPlanning Staf)主任期间管对美国外交政策产生直接影响。此后，虽然乔治·凯南离开了国务院，但作为重要智囊并凭借著书立说，他始终活跃于美国的对外政策舞台。

国内外学者对乔治·凯南的研究已相当深入，形成了所谓的凯南学(Kennanolo-gy）。但是，关于“凯南的中国观”的系统研究并不多见，部分著作仅把它一笔带过。其中比较重要的是乔治·华盛顿大学客座教授保罗· J.希尔(PaulJ.Heer)在2018年出版的著作中研究了乔治·凯南对美国东亚政策的影响，对其制定的中国政策做了专门探讨；北京大学国际关系学院张小明教授也管著文分析1947年至1949年间影响乔治·凯南对华看法的因素及其对华政策主张；波士顿大学历史系的大卫·迈耶教授(David Mayers)和圣母大学历史系的威尔逊·D.米斯坎贝尔教授（WisonD.Miscamble)都强调了"中国通"小约翰·戴维斯(John P.Davies，Jr.)对乔治·凯南的对华认识产生过重要影响；此外，还有一些学者在讨论战后初期美国的遏制战略和对华政策时，提及乔治·凯南的看法。然而，学界对乔治·凯南中国观的研究仍是不全面的，进一步探究其对中国的整体看法有助于理解冶战时期美国对华政策的思想根源和现实主义外交思想的内在逻辑。

本文主要依据乔治·凯南的回忆录、日记、著作、访谈、传记以及美国政府外交档案文件集，着力探讨他对第二次世界大战后的中国的看法，特别是乔治·凯南对中国人性格的整体看法、对中美苏三边关系认知的演变及其中国观的由来。

### 一、关于中国的民族性格

乔治·凯南不懂中文，对中国没有长期而深入地接触。他第一次来到中国已是1980年，短暂停留数日。可以说，在乔治·凯南的脑海中，中国长期以来只是一个空泛而笼统的存在，没有具体的图像。他管多次强调"我并不了解中国"。关于中国知识的贫乏正是乔治·凯南中国观的主要特点之一，这常常导致他偏激而片面地看待中国，进而影响他对中美苏关系的判断。这首先体现在他对中国的民族性格的看法上。

1946年2月22日，含有对苏联民族性格经典论断的长电报成为乔治·凯南一生的重大标志。这封电报的布局，首先是剖析苏联对战后问题看法的基本特点和形成背景，然后提出政策建议，即后来所谓的"遏制政策"。乔治·凯南在这封长电报中从历史和传统两个角度剖析了苏联人的心理，认为苏联自以为生活在"资本主义包围之中"，不可能与西方世界保持永久的"和平共处"，而这种"神经质"的世界认知来自于"俄罗斯传统的、本能的不安全感"，他们"唯恐俄国人知道外界的真相，或外国人了解俄国的内幕后，会产生什么后果"，因此必须"彻底地置对手于死地"，而美国就是苏联安全的最大威胁。对俄罗斯民族性格及其世界观的深入感知，是乔治·凯南处理苏美关系的大前提。可见，他非常重视一个国家的民族心理对其外交行为的影响。这种认知模式同样适用于乔治·凯南对中国的认知。在回忆冷战初期美国的东亚政策时，乔治·凯南鲁对中国进行过评价。

首先，他认为中国是一个伟大的民族，是一种文明的创造者，具有高度的智慧和才能，但中国人和美国人是完全不同的。首先，中国人"天生自大而排外"。乔治·凯南眼中的中国人永远认为自己是"天朝上国，"而其他的国家不过是蛮邦"。表面上，中国人文质彬彬甚至严肃庄重，但他们"从内心排斥外部世界"，对外国人和外国事务时刻保持戒心，特别不容易同非东方的外国人推心置腹。乔治·凯南还常拿同属东方民族的日本和中国作比较，日本人虽然在人际交往中"笨手笨脚"，没有中国人那般"世故老道"，但他们对待外部世界，特别是美国"更感兴趣"，且富有"高尚真挚的良心和责任感"。这使得乔治·凯南一直对日本更有好感。在他看来，俄国是由于"自卑和不安全感"反对西方，而中国是因为"自大和怀疑排斥西方"。因此，中国和美国不可能建立类似西方国家之间的那种亲善关系，就连中国和苏联之间也不可能存在长期的亲密关系。这是他坚信中苏矛盾不可避免的重要依据。

其次，乔治·凯南认为中华文明"局限于表面"。他直白地批评中国人"表面上文明有礼"，可一旦利益受损，就会"翻脸无情"。虽然中国人具有很多优秀的品质，如勤奋、诚实经商、务实精明、政治敏锐，但在乔治·凯南眼中，中国"严重缺乏"西方基督教的两大精神"恰悯之心和赎罪意识。"正因如此，中国人在他眼中变得"难以应对"。显然，乔治·凯南的这种判断先人为主地捋西方价值观及基督教伦理作为评判是非曲直的标准，文明之间的区别被他视为中华民族的"性格缺陷"。

再次，乔治·凯南认为中国人"不守规矩"。基于他对中国有限的观察，他认为，中国人通常"不会以书面形式确定实际的协议"，某些已经达成的协定会因为不符合自己的利益而"随意篡改"，并且"他们从不会在原则问题上做出让步"。中国人总是"认为自己理论上永远是对的，别人都是错的。"这种"自大自私"的表现，是乔治·凯南认为中国"很难与外国发展良好关系"的重要原因之一。

最后，乔治·凯南痛恨中国人对美国人的"腐化"。无论是19世纪美国传教士和商人的在华经历，还是在美国为蒋介石政府游说的院外援华集团，都被乔治·凯南视为"腐化"和"愚弄"美国民众的典例。回顾19世纪到20世纪上半叶的中美关系史，乔治·凯南甚至为中国革命驱逐西方人而鼓掌称道，因为自此之后中国人手中再没有可做"人质"的美国人了。乔治·凯南将少数人的行为一股脑地当作中国人的普逼特点，认为中国有"腐化"美国社会的危险，美国必须和这样一个谋求"面子"和"威望"的国家保持距离，以保护自身的纯洁不受污染。的确，贪污受贿、腐化堕落、不守规则都是中国旧社会的痼疾。但是乔治·凯南对中国人性格的看法过于片面和消极，没有看到其积极的一面，如中国人的礼义、仁爱、孝悌、坚韧和勤劳等。

概言之，乔治·凯南对中华民族性格的总体认知是：一个"自以为是""疑外排外""肤浅冷醋""不守规则"且"腐化堕落"的东方古老民族，鲁有辉煌而文明的过去，却"无光明而强盛的未来"，无论是美国还是苏联都不可能与之建立长久亲密的关系。乔治·凯南对中国的评价建立在实力和西方价值观的双重标准上，从冷战初期到20世纪末，他对中国的总体印象并没有发生质的改变。乔治·凯南在1996年的日记中依然写着类似的判断，中国人"与人交往时一旦利益相悖则极为无情，实际上这是源于对外国人的恐惧"我看不到与这个国家建立更亲密的政府关系能带来什么好处"。

### 二、关于中美苏三边关系

乔治·凯南对中国的整体看法，影响了他对中美苏三边关系的判断。在乔治·凯南看来，中美关系、中苏关系和美苏关系三者环环相扣，但重心是美苏关系，中国是两极格局中的一枚"棋子"。随着世界形势的变化，乔治·凯南的看法有所变化，但他对中苏之间隐含矛盾的论断不管改变，并反对中美建立更为紧密的关系，这是乔治·凯南思考美国外交战略的基础。乔治·凯南对中美苏三边关系的认识体现在他对如下几个重大事件的反应和应对上。

#### （一)中东铁路问题

乔治·凯南对中国历史的了解始于他对中东铁路问题的研究。从1896年李鸿章签订《中俄密约》给予俄国在中国东北修建铁路权开始，俄日在东北地区的利益争夺持续了半个多世纪。作为一名苏联问题专家，这段历史是他了解中苏矛盾和中美关系史的一个窗口，他意识到"东亚是俄国和西方开始产生利益冲突的战场之一"，莫斯科与西方的关系将受到它与东方国家交往经历的影响。

乔治·凯南对中东铁路归属问题的基本认识是：俄国革命之前，中东铁路是俄国政府控制中国东北的工具。1919年新生的苏维埃政权宣布废除不平等条约，归还中东铁路，是为了防止中国给予高尔察克海军上捋援助。一旦沙俄的残余势力在内战中落败，苏联就开始反悔当初的慷慨，再次与日本对中东铁路经营权展开激烈争逐。中国的东北、外蒙和新疆是俄国自我保护的完美屏障，中俄交界带长期以来都是火药味弥漫的地方。因此，乔治·凯南清楚地认识到中俄领土之争不仅是两个国家难以解开的历史心结，还会不断被牵扯到未来的两国关系中，成为中苏关系的障碍。俄国的大国沙文主义作风不只是中国民族主义情绪高涨的原因之一，也是新中国成立后中苏矛盾的潜在根源。在冶战中充分利用这一矛盾，必将使美国从中受益。

与此同时，乔治·凯南对美国在中东铁路问题上秉持的"门户开放"政策不以为然。他直白地批评该政策根本不适合中国的现实，美国政府根本无意履行维护"中国领土和行政的完整"的义务，反复宣告这一原则无助于解决各方的利益冲突"户开放主义"的含义"既不清楚又不精确"，很容易引发混乱的联想，从而引起俄日不必要的仇视。这种将美国国内的法律观念和道德原则移植到国际领域的做法，恰是乔治·凯南所坚决反对的外交方式。因此，关于中东铁路问题的认知，成为乔治·凯南判断未来中美苏三边关系的基础。

#### (二)中国内战

中国内战是乔治·凯南讨论最多的事件之一。特别是1947年至1949年期间，乔治·凯南作为美国国务院政策规划室主任，在其助手"中国通"戴维斯的帮助下制定了多项影响美国对华政策的重要文件，代表了这一时期国务院在对华问题上的主流意见。总体而言，乔治·凯南对中国内战的看法从属于他整体的遏制战略蓝图。在他眼中，战后初期的中国根本"无足轻重"，因为它积贫积弱。与管经试图扶植中国成为战后"四强"之一的罗斯福总统不一样，乔治·凯南鲁多次强调，中国"资源匮乏"，显然"不是一个强国"，而且在可以预见的未来也不会成为一个强国，这是发展中美关系的现实基础。在以实力论英雄的乔治·凯南看来，战后中国没有潜力发展"具有一定规模的两栖作战能力"，其军事影响力在短期内不可能超出"亚洲大陆之外"。

与同属远东的日本相比，后者在未来世界政治发展中的潜力将"远胜"中国。即使中国大陆"为共产党全部控制'"也不太可能一直处于苏联的控制之下"。在这样的认识下，中国一直都不是乔治·凯南设想的遏制政策的核心。在1946年至1947年的"长电报"和外交》季刊上发表的"X"文章里，乔治·凯南没有描画具体的遏制区域，只是概略地称美国应该"在凡是有迹象表明苏联人侵犯世界和平与稳定利益的腊和土耳其，但不包括中国。在他看来，中国属于美国可以完全放弃的地方，它"不会对世界整体和平造成悲剧性影响"，而援助其食物、衣物以解决它的社会问题，很可能要"超出整个世界全部资源的总和"。因此，乔治·凯南在1947年力排众议，建议美国政府削减对蒋援助。

1947年的美国，正处于是否更深层卷人中国内战的关口。马歇尔调停失败后，美国开始重新评估对华政策，国务院和军方的观点产生重大分歧。1947年6月举行的参谋长联席会议商讨拯救蒋介石政权问题，一致的看法是中共军队是"苏联政策的工具"，应该让杜鲁门主义适用于中国，扩大美国对华经济和军事援助。但从中国铩羽而归的国务卿马歇尔仍有疑虑，他捋此事交给乔治·凯南负责的美国国务院政策规划室研究，就是希望寻找一种新的中国政策。1947年11月3日，乔治·凯南在呈交马歇尔的备忘录中建议，不应在中国适用杜鲁门主义，因为中国共产党的胜利是美国一次严重的挫折，但"并非一次重大灾难"。杜鲁门政府应该只扩大必要的援助以抚慰那些国内的批评者，防止国民党政权的即刻崩溃，但不应超出这一临界点。乔治·凯南的这一建议得到马歇尔和总统的认可。1948年初，杜鲁门要求国会拨款5.7亿美元非军事援助给国民党政府，这一数额经国会削减后，最后变成了4.36亿美元，远低于国民党政府及美国军方的要求。国会表决前，马歇尔在参议院对外关系委员会上的一番陈词显然受到乔治·凯南的影响"我们无论是在经济上还是军事上，都不可能接管中国政府正在持续的败局，这将浪费我们在更加重要地区的力量。"1948年4月，美国国会最终通过了中国援助法》China Aid Ac)。可见，在减少对蒋援助这一美国对华政策的关键性转折上，乔治·凯南不顾美国军方和院外援华集团的坚决反对，发挥了重要作用。

对乔治·凯南而言，一个政治分裂、经济混乱的中国不可能对美国造成威胁，美国甚至可以彻底抛弃蒋介石。1948年2月，他在为马歇尔写的一份综合回顾美国承担责任的报告中称，美国执迷于重塑中国的理念太久，在亚洲大陆上已经"大规模的过度扩张"，以致目标远远超越了它的手段，政策规划室的任务就是决定东亚到底哪些地区"于我们的安全绝对关键"。显然，中国不在乔治·凯南画下的核心圈内，而日本才是他心中可以稳定东亚局势的基石，他在扭转这一时期美国对日政策从惩治日本转向扶植日本的过程中，亦发挥了关键作用。

时至1948年下半年，随着中共领导的解放战争节节胜利，美国决策者开始认真考虑转变政策，逐步从中国"脱身"，但在具体如何调整问题上依旧存在分歧，美国军方仍坚持要求挽救蒋介石。在这种情况下，1948 年6月底发生的苏联主导下的共产党情报局公开谴责南斯拉夫共产党事件，让乔治·凯南关于"共产主义不是铁板一块"的论断迅速成为美国政府的共识。乔治·凯南开始利用铁托的"叛变"为其对华政策主张辩护，并预言中苏必将反目。1948年9月，他在美国国防学院的演讲中开始明确界定遏制重点的范围，即"五大工业一军事中心"：美国、英国、德国、苏联和日本。他认为，中国的"陷落"不会对美国的利益构成重大危害。这一战略判断，是乔治·凯南提出美国应从中国大陆逐渐"脱身"的政策根源。

1948年9月7日，乔治·凯南领衔的美国国务院政策规划室提交了名为《重新审查和制定美国对华政策》的PPS/39号文件。文件声称，蒋介石政权失败的原因，是由于日本的军国主义、国内共产主义革命和国民党无力解决的中国政治经济问题，与美国没有关系。继续承认蒋介石政权只会拖累美国。乔治·凯南拒绝继续援蒋的理由主要有二：其一，美国武力直接干涉将加剧中国人民的反美情绪，，掀起民族主义浪潮，并迫使中间派和传统仇外的中国人加人到中国共产党阵营；其二，美国实力有限，美国政府不可能、也不应该把美国有限的资源和威望都用在蒋介石政权身上，后者的消失不过是一个"时间长短的问题"。更为重要的是，乔治·凯南认为苏联并非真心实意地支持中共，美国应该伺机在中苏之间打进"楔子"。在他看来，苏联根本没想到，也不想看到中共能够这么顺利地"控制"全中国。铁托同志启发性的逃学"，已经在克里姆林宫领袖的心中播下怀疑的种子，与铁托相比毛泽东掌控中国最高权力的时间十倍于他"，更有可能也更有希望带领中国独立于苏联。因此，不应过高估计苏联对中国的支持程度。1948年11月，美国国务院政策规划室撰写的PPS/39/1号文件也认为，中国共产党人在大陆取得胜利的主要因素在于"中国中央政府的弱点与腐败"，然后才是莫斯科的道义支持与意识形态鼓励，苏联对中共政权的实际帮助并不大。正如中国社会科学院荣誉学部委员资中筠所说，从此时开始乔治·凯南提出的对华政策目标发生了"微妙的变化"，从"尽力阻止中共在中国取胜"，转变为"尽力阻止中国变为苏联的附庸"。

在这种情况下，乔治·凯南提出等待"尘埃落定"的"脱身"政策，建议美国政府耐心等待世界局势更加清楚的一天，特别是中苏关系的明朗化。在此之前，美国的对华政策都必须是灵活且富有弹性的。未来的中国将动荡不安，美国不能再"选边站"，而是要"及时止损"。乔治·凯南的建议得到杜鲁门政府的重视。1948年10月13日，PPS/39号文件演化而来的NSC34号国家安全委员文件印发给相关部巾讨论。然而脱身"政策遭到美国国会同情蒋介石政府的议员和院外援华集团的围攻。国防部长詹姆斯·V.福莱斯特(JamesV.Forrstal)严厉批评乔治·凯南放弃中国的政策等于"美国没有对华政策"，它将导致西方在远东的立场彻底地翻转。考虑到国内激烈的反对意见，马歇尔没有立刻向杜鲁门递交乔治·凯南草拟的总统声明，宣告"目前中国发生的事情不会因为美国实际能够提供的任何援助方式而发生变化抑或是受到实质性的影响"，但他保留了进一步对此事进行研究和探讨的空间。

1949年初，国民党的溃败在即，乔治·凯南尝试说服刚刚接替马歇尔担任国务卿的迪安·艾奇逊(Dean Achesomn)相信，中共的胜利未必就是克里姆林宫的胜利。

艾奇逊在乔治·凯南的谏言下，也寄希望于"铁托主义"能够在中国生根发芽。1949年2月底，他提请杜鲁门批准基于PPS/39撰写的NSC34/2号文件，让美国"通过政治和经济手段"利用中国共产党人和苏联之间以及斯大林主义者与中国共产主义体制内外的其他因素之间的"任何一条裂缝"。该项政策最终得到杜鲁巾的批准。

作为国共内战的产物，台湾问题在乔治·凯南心中的地位却与大陆不同。乔治·凯南对台湾的看法从属于他的"环形防线"(defensive perimeter)战略。他认为美国的实力有限，不可能四面出击，因此应该利用其海空军力量在远东建立"环形防线"，通过防守冲绳和菲律宾等具有重要战略意义的沿海岛屿，同时避免承担大陆义务的方式来"保障美国在西太平洋的利益"。至于中国内陆，美国没有实力也没有必要出兵干预。1949年7月，乔治·凯南管单独提交备忘录讨论台湾和澎湖列岛的归属，提出美国应该带着"决心、速度、冶酷和自信"捋台湾岛上的国民党军队逐出，直接出兵占领，以防止位于"环形防线"上的台湾落人"红色中国"和苏联之手。显然，乔治·凯南的建议字《开罗会议》的精神背道而驰，很可能引起中美战争乃至美苏冲突。因此，表达该意见的PPS/53号文件以乔治·凯南个人名义提交，且在提交当天凯南就撤回了它。多年之后，乔治·凯南将这个主意归因于他的远东事务顾问戴维斯，可后者并不承认做过这么"疯狂的举动"。事实上，"在国务院、五角大楼、中情局和麦克阿瑟日本的指挥部里当时都鲁讨论过"关于如何赶蒋下台并策划一场台湾分离运动，这样既可以保住台湾这个战略要点，又不必卷人中国内战的泥潭。

只是到了1949年夏，美国国内的援蒋声音又甚嚣尘上，这个策略就显得不合时宜了。

这也从一个侧面说明，乔治·凯南对中国人的民族主义情感认识过于肤浅，他完全没

考虑到中国人——无论哪个党派——都不会容忍美国强占中国的领士同一时期，乔治·凯南和戴维斯还在国务卿艾奇逊的支持下，协助撰写了美国对 华政策转折的标志性文件：《美国与中国关系：着重于1944年至1949年时期》(以上简称《白皮书》)，于1949年8月5日发布。《白皮书》公布了数百份美国对华政策的绝密档案，旨在为美国失败的对华政策辩护。美国国务院在文中急于把"丢失中国"的责任推到腐败无能的国民党政府身上，表明美国政府对蒋政权的帮助已是仁至义尽，用艾奇逊《附信》中的话来说"中国内战不祥的结果非美国政府的控制所能及。"这些内容字措辞清楚地反映出乔治·凯南自1947年以来在中国问题上的看法，以及他所主张的"脱身"政策。事实上，早在1948年11月26日，乔治·凯南就管建议国务院出面整理、公布涉及中美关系的背景材料，以消除公众对中美关系的"困惑"与"误解"，取得舆论支持。因此，乔治·凯南在推动《白皮书》出台一事上扮演了重要角色。

《白皮书》一经发表，立刻遭到美国国会和院外援华集团的强烈抨击，乔治·凯南和戴维斯也成为被攻击的对象。一位参议员指责乔治·凯南忽视中共政权带来的"威胁"，并且有支持中共的意图。戴维斯甚至被麦卡锡指控为"亲共"，受到美国国务院忠诚调查委员会的审问，最终无奈地结束了外交官生涯。可是乔治·凯南生性固执，依旧坚持己见。他在回忆录里痛斥"国民党院外援华集团不负责任地干涉美国外交决策的行为，终将造成美国的重大损失"。直到1951年，他在递交国务院的备忘录中仍然坚称"失去中国"的主要责任在蒋介石本身"美国对中国事务插手越少越好"。迈耶教授管精辟地评价道"凯南的脾气和原则让他不可能妥协。他不会因需要而剪裁外交政策的模样来避免国内政坛的骚乱和积累大众的支持。"然而，朝鲜战争的爆发，让乔治·凯南从中国"脱身"的政策彻底失去了舆论与高层的支持，美国再次陷人中国事务的泥沼。

#### （三)朝鲜战争

1950年6月25日，朝鲜战争爆发，已经递交辞呈的乔治·凯南被迫留下来应对危机。但此时乔治·凯南已经脱离了国务院核心决策圈，作为政策顾问和苏联专家，他的观点常常得不到艾奇逊的重视。

1950年6月27日，乔治·凯南在向北约成员国大使阐释美国政策时，透露了他对朝鲜战争最初的基本看法，即美国派兵干涉朝鲜战争，"并不是因为那里有何等重要的战略意义"，而是如果美国袖手旁观"全世界的信心和士气会受到极大打击"。

他支持此时给予麦克阿瑟将军在朝鲜半岛的任何地方进行军事行动的自由，但是他对美国最终目标的界定是有限的——即"将世界格局恢复原状"，在半岛南部恢复韩国统治。与朝鲜相比，乔治·凯南此时更关心的是确保台湾"不落人共产党之手"，他没有捋台湾单纯当作中国问题的一部分，而是"整个远东地区问题"的一部分。这种战略上的主次安排，秉持了乔治·凯南一直以来对东亚"环形防线"的划定。朝鲜和中国大陆一样，都不是乔治·凯南的核心关注，因此他才建议艾奇逊把美国的战略目标限定在恢复朝鲜半岛原状，而"不是收复三八线以北的任何土地"。

1950年7月局势发生变化后，乔治·凯南开始进一步修正自己的观点，坚决反对联合国军越过三八线。他已经清醒地意识到，朝鲜的存亡关乎苏联人以及中国人生死攸关的根本利益，一旦美国带领联合国军队跨过三八线，很可能引起美苏的正面冲突，导致无法预料的严重后果。乔治·凯南鲁在一场新闻发布会上警告说"苏联不会坐视联合国军越过三十八度纬线"什么样的后果都可能发生"，包括苏联和中国共产党可能直接出兵帮助朝鲜。此外，乔治·凯南还和老友戴维斯、赖因哈特(G.Frederick Rcinhard)联名撰写备忘录递交国务卿艾奇逊，重申他们的立场。然而，约翰·杜勒斯(John Dlles）、戴维·迪安·腊斯克(David Dean Rusk)及军方都主张抓住这个机会，打到中朝边境和中苏边境，彻底解决朝鲜半岛问题。乔治·凯南的看法在国务院内只占少数。他多次向艾奇逊建言，却无回应。果不其然，联合国军跨过三八线后，中国志愿军即以实际行动应验了乔治·凯南的警告，渡过了鸭绿江。

朝鲜战争爆发后不久，美国政府内部还出现了是否支持新中国加人联合国以便在联合国框架下讨论和解决朝鲜战争问题的大讨论。1950年7月10日，印度政府提议联合国接纳共产党中国为其成员，并且通过扩大安全理事会(吸收中国)的方法来解决朝鲜问题。对此，美国政府的主流持否定意见，只有乔治·凯南等少数几人一反常态，支持中国加人联合国和安理会的提议。在乔治·凯南来，俄国人是故意"利用其在亚洲的追随者来对抗我们"，美国应该利用二者关系当中的弱点。乔治·凯南说服美国政府的理由有三：第一，深陷朝鲜战争泥潭不是美国真正的战略利益所在，美国必须想办法尽快脱身；第二，美国推动中国人常是离间中苏关系的绝佳机会；第三，中国早晚都会加人联合国和安全理事会，美国何不先行一步，取代苏联拉拢中国，同时还可以加速中苏矛盾的恶化。乔治·凯南在中国人联问题上务实灵活的处理方法，与20世纪70年代的尼克松有异曲同工之妙，二者都突破了意识形态上的僵化。只是这一方案在美国反共的国内热潮下无法形成共识。

与此同时，乔治·凯南也坚决不同意国务院内一些激进分子要求联合国通过决议谴责中国共产党为"侵略者"的做法。在他看来，美国政府不能把苏联和中国逼入死角，那会使联合国军内部，主要是英美之间的分歧越来越大。据乔治·凯南回忆，他在华盛顿期间管有效地阻止了这股力量，但他离开国务院后，联合国还是在美国的主导下于1951年2月通过了指责中国为"侵略者"的决议。

乔治·凯南对待中共相对和缓的态度并不代表他支持新中国。恰恰相反，乔治·凯南"对自己与中国人在观念和伦理上的根本性冲突心知肚明"，他对英国驻美大使奥利弗·弗兰克斯(Oliver Franks)说"站在西方国家利益的立场上看，中国是一个完全靠不住的国家"。但是作为一名职业外交官，乔治·凯南认为这些冲突都是可以通过"外交途径"去解决的。然而，美国的公众舆论与右翼势力并不能理解这样的政策，特别是后来的美国国务卿杜勒斯，扬言过去是他"高估了乔治·凯南"，现在在他眼里"凯南就是一个极度危险的人物"。这些批评让乔治·凯南非常沮朝鲜战争激化了冷战局势，为美国四面出击的全球遏制战略提供正当性，新出台的NSC68号文件与乔治·凯南当初提出"长期耐心而又坚定、警惕地遏制俄国对外扩张倾向的政策"已经相去甚远。在20世纪50年代初激烈的反共意识形态下，乔治·凯南的现实主义外交政策建议无法获得政府的采纳，反而被贴上同情共产主义的标签。1950年8月底，心厌意合的乔治·凯南离开了国务院，开始转型成为普林斯顿高等研究院的学者。

但是，离开华盛顿的乔治·凯南依旧对国务院具有影响力。在美苏讨论朝鲜停战问题时，艾奇逊授意乔治·凯南与苏联驻联合国大使马立克(JacobMalik)通过非正式渠道沟通，探讨停战方案。当时乔治·凯南向后者表达了美国愿意与苏联和中国和谈的意愿，并且从马立克的谈话中感到"苏联方面已经对朝鲜和中国共产党施加了压力，表明其愿意接受停火协议"。因此，乔治·凯南敦促国务院马上采取行动"直接达成停火协议"。在乔治·凯南看来，尽快和平解决朝鲜问题可以避免美苏陷人直接冲突，如果美军继续挺进，而不是积极促成停火的话，他担心"苏联方面除了亲自介人之外，别无选择"。乔治·凯南一直""对民主国家把武力作为推行外交政策有效工具的能力深表怀疑"。他一开始主张的遏制政策没有明确排除军事手段，但是军事手段在他的遏制理论中的重要性却越来越低。1948年苏南关系破裂、1949年苏联第一枚原子弹试爆成功两件大事让乔治·凯南的思想发生重要变化。当他看到苏联问题有希望不通过军事冲突解决时，他更倾向使用政治、外交手段解决冲突。因而，在朝鲜战争的和谈阶段，乔治·凯南积极推动美苏之间达成停战共识。

朝鲜战争结束后，美国国内的"恐华"反共"气氛有增无减，一些政策精英甚至认为中国是比苏联更大的威胁。强硬的反共分子杜勒斯成为新一任国务卿，在杜勒斯的鼓动下，共和党的外交战略从"遏制"转向"解放"，乔治·凯南也被新政府彻底抛弃。但是乔治·凯南对中国的战略定位并没有因朝鲜战争而改变，他始终认为中国不是一个工业和军事强国，参加朝鲜战争的中国军队仅有两到三年的经验，美国无需夸大中国威胁。虽然，乔治·凯南关于"中国大陆政权不可能持久"的判断为现实推翻，但是中国在他眼中依然只是"二等国家"，鼓励中国的"铁托主义"倾向才是遏制中国和苏联的重要手段。

#### (四)尼克松—基辛格的缓和外交

乔治·凯南对中苏矛盾的认知，使他成为最早一批看到中美缓和可能性的人。

经过赫鲁晓夫去斯大林化、波匈事件、中苏论战等一系列事件后，乔治·凯南更加坚信共产主义世界的多元化趋势。1964年，乔治·凯南撰写《应对共产主义世界》一书，深入探讨了利用共产主义世界内部分歧的可能性。他坚信中共与苏联的敌对由来已久，且在斯大林死后和1956年苏共二十大后逐渐表面化和激烈化。现在，原本"团结有序的一个社会主义阵营"已经变成了"相近的两大意识形态共同体之间动荡不安的联盟"，一方以苏联为首，而另一方以中国为首。

1965年，乔治·凯南在一篇研讨会文章中从历史和文化的角度，分析了中苏矛盾的来由及其对美国的影响。他认为，一方面，中苏两国历史上对待西方的态度就不一样。俄罗斯民族是一个东西方文明的结合体，因此对待西方的态度是爱恨交织。

而中国是一个自给自足的古老民族，在英国打开中国大门之前，中国受到西方文明的影响非常小，因此之后想要摆脱西方模式的欲望愈加强烈。乔治·凯南认为，这是苏联和中国在冷战中对待西方国家态度有所差别的一个重要原因。即使在冶战最激烈的时期，美苏之间都未管中断外交关系，相比之下，中国对待西方的态度更具"挑衅性"。另一方面，乔治·凯南认为中国人和苏联人也有共性'两者都在斟酌事宜时有绝对保密的习惯，都对内部安全事务有一种过度的敏感"，这就阻碍了中苏之间开诚布公地达成坚实可靠的谅解。也就是说，中苏两国间互不信任、"秘密外交"的特点，导致两个国家经常会沟通不畅或产生误解，以致原有矛盾进一步恶化。这是中苏矛盾复杂多样且不可避免的原因。

乔治·凯南还认为，从20世纪60年代开始，苏联领导人已经表现出了要和西方改善紧张关系的迹象，可是中国人"不愿接受"，反而做出更激进的反美姿态来"恐吓"苏联。中国人把苏联与西方改善关系的行为当作对马克思主义信仰的背叛，对共产主义道路的修正，质疑苏联的领袖地位。中共对苏联在共产主义世界的权威的"公然挑战"，一方面迫使苏联不敢和西方走得太近；另一方面，导致中苏矛盾的进一步恶化。乔治·凯南建议美国应该小心翼翼地处理中苏关系和"维持长期的、建设性的、健康的中美关系"。可以说，乔治·凯南对中苏矛盾的一系列论断及要求美国政府重建中美外交关系的建议，是20世纪70年代中美缓和的先声。与乔治·凯南同属现实主义外交家的基辛格，恰是抓住中苏交恶的契机，帮助尼克松打出中国牌。乔治·凯南即将基辛格1971年访华视为美苏关系缓和时期的开端。

然而，当尼克松真正打出"中国牌"制衡苏联之时，乔治·凯南又提出警告：美国政府在处理中美关系问题上一定要审慎小心，不能把这种关系推得太远太快。乔治·凯南对中国民族性格的偏见使他认为中国人肯定会在许多方面"有所保留"，所以"我们"也不能一开始就和盘托出。既然中国和美国是完全不同的两个国家，那么能合作就合作，不能合作的地方不必勉强。此外，，乔治·凯南强烈反对美国利用"中国牌"打击苏联，因为这会把美国卷人和美国利益毫不相干的中苏冲突之中。乔治·凯南秉持的现实主义原则是"同某一个第三国的关系不好，永远不应该、实际上也永远不会以牺牲另一政府对美国的友谊为代价；反之，也不应该把这种友谊作为(同第三国)关系不好的一种奖励或鼓励。"对美国来说，苏联的重要性远高于中国，因此千万不能窃喜于短暂的胜利，而损害美国的长远利益。

在乔治·凯南眼中，美国只要和中、苏两国同时保持适当的外交关系，坐山观虎斗，就能使美国的利益最大化。而尼克松一基辛格的缓和外交，正是一次这样的尝试。耶鲁大学外交史专家约翰·加迪斯(JohmCaddis)认为，乔治·凯南和基辛格在国际关系上的看法有诸多相似之处，他们都把美国的利益界定为在一个多元世界中维持权力平衡，都坚信美国的国家力量有限，必须区分核心利益字边缘利益，而中国的重要性被意识形态夸大了。在加迪斯看来，尼克松和基辛格对权力平衡的重视和关于世界多元化发展的论断，乃是某种程度上对20多年前乔治·凯南的五大中心理论的回归。正因如此，在基辛格担任国务卿一年之后，乔治·凯南感慨地说"亨利比国务院鲁有的任何一个人都更理解我的想法。"可见，乔治·凯南和基辛格在中美缓和的问题上有着高度一致的看法。事实上，基辛格担任国家安全事务助理与字国务卿期间，一直与乔治·凯南保持着不间断的联系。

中美关系缓和之后，乔治·凯南对新中国政府的评价开始有所变化。1977年，乔治·凯南出版了《当前美国对外政策的现实：危险的阴云》一书，把新中国手此前的中国政府相比，认为以往的美国传教士和商人都在旧中国走极端，不是毫无道理地对中国人冶嘲热讽，就是神气十足地感情用事，以恩人自居。在他看来"毛泽东时代的建设性特点之一乃是把这批美国人从中国社会中驱逐出去，并使我们之间的关系恢复到目前条件下最合适的状况：只限于政府间责任代表们的往来"。从冷战初期开始，乔治·凯南设想的中美关系理想状态就是剔除不切实际的情感和意识形态因素，维持正常的官方往来。

### 三、影响乔治·凯南的中国观的主要因素

与绝大多数生于20世纪初的美国人一样，乔治·凯南与中国直接接触的机会非常少，他对中国的了解是有限的、不全面的。作为一名职业外交官，乔治·凯南对中国的看法某种程度上代表了20世纪美国官员眼中整体的中国印象，即便他的知识面和洞察力超乎众人之上，仍旧摆脱不了那个时代文化字意识形态的局限。总体来说，乔治·凯南的中国观建立在西方价值观和自由主义精英教育的基础上，受其好友"中国通"戴维斯的影响，同时遵循着现实主义政治理论。

1904年，乔治·凯南出生于美国中西部的威斯康星州的一个典型的白人中产阶级家庭。他的家族具有浓厚的盎格鲁-撒克逊色彩。乔治·凯南鲁骄傲地称，家族里没有一个人不是纯正的盎格鲁-撒克逊血统。他的父亲是一名优秀的税务律师，严肃刻板。母亲早逝，因此乔治·凯南从小就性格孤僻，缺乏安全感，对外部事物异常敏感。与此同时，乔治·凯南又是一个清教传统家庭下长大的孩子，家中有大量藏书，家族里"没有粗鄙之人"，亲戚们大多知识渊博、见多识广，其中一位老乔治·凯南还是"俄国通"。用乔治·凯南的话说，他的祖上没有人是"雇佣工人，"因而对马克思主义的内涵无法产生切身的感知"。而自由、平等、民主这些西方主流价值观自然而然地成为他的意识形态底色。13岁时，乔治·凯南被送人附近一所军事寄宿学校，开始接受严格的封闭式教育。这所学校所倡导的勤奋、自立、虔诚的精神突出地体现在长大后的乔治·凯南身上。可以说，他的童年时代生活在白人中产家庭的精英梦里。

1921年到1925年，乔治·凯南进人普林斯顿大学学习，接受了良好的欧洲历史和国际政治教育。20世纪20年代的普林斯顿大学是一个东部富裕学生集中的私立大学，汇聚了美国社会未来的精英。从密尔沃基风尘仆仆赶来上学的乔治·凯南自然受到东部学生的排挤和歧视，多年之后，他管伤心地回忆道"我是没有希望的粗鲁的中西部人。我根本不知道该如何同那些东边来的男孩们打交道"。沉默的乔治·凯南在大学时代并不突出，但是通过约瑟夫·格林(Joseph Creen)教授的启发，他开始对气候、地理、人类文明的特征等问题表现出浓厚的兴趣。此后，乔治·凯南开始专注于国际政治的学习，他基于地缘政治和权力制衡的现实主义外交理论从此时打下基础。同时，孤独、受排挤的大学生活也塑造了乔治·凯南内向、固执、自傲而又自卑的性格特点。

大学毕业后，乔治·凯南在1926年考上外交官，成为"美国国务院第一批专门训练的俄国问题专家之一"。以1924年出台的《罗杰斯法》(Rogers Act)为标志，此时的美国正处于外交官职业化的新时代。19世纪的美国奉行孤立主义政策，外交队伍由东部上层人士组成，被称为老朽无能的"形式主义外交官"和"穿条纹裤子的毛孩子"。进人20世纪之后，随着美国国际地位的转变，以约瑟夫·格鲁(Josef Glew) 为首的一批上层进步人士开始寻求外事系统的改革，建立一支专业化的外交精英队伍。乔治·凯南既是第一批外交官考试通过的幸运儿，也是专业化教育的杰出成果。

第一次世界大战后的德国和革命后的苏联给乔治·凯南留下深刻的印象，他对极权政体的憎恶连带到对共产主义的态度。他认为，此时的苏联和欧洲共产党并没有把意识形态当作真知和至高无上的原则，只是利益和权力的幌子而已。1927年11月7日，乔治·凯南在德国汉堡的街头偶遇了一场声势浩大的游行，那些衣衫褴褛的示威者在他看来皆是"莫斯科的跟班"，受到"红色旗帜和革命仪式的欺骗"。这些人的"理想主义"热情虽值得同情，但就共产主义本身而言乔治·凯南无法产生认同。1928年3月，乔治·凯南参加了新成立的苏联问题专家培训班，在德国的弗里德里希·威廉大学和柏林大学学习俄语和俄国的历史与文学，并成为乔治·凯南家族的第二位"俄国通"。培训班的负责人是乔治·凯南在国务院东欧处的老上司凯利。凯利本人"对沙皇时代文化的热爱"反对布尔什维克的态度"及对苏联政权"意识形态策略的蔑视"，在很大程度上影响了他的学员们。三年学习期间，乔治·凯南首先要在爱沙尼亚首都塔林的领事馆和拉脱维亚首都里加的公使馆工作一段时间，这两处都是美国针对苏联的"监听站"——正如20世纪50、60年代美国在香港监听中国大陆。这让乔治·凯南对苏联体制有了更近距离的观察。他认为苏联制度和美国制度之间"不可能存在中间地带或妥协的余地"，它们"甚至不能共存于同一个世界"，一方的崩溃是早晚的事。1934年至1937年，乔治·凯南被调到莫斯科，目睹了"大清洗"运动后，更是叱其为"法西斯主义"。可见，乔治·凯南早期在欧洲和苏联的工作和学习经历，让他对共产主义运动形成了非常负面的看法，他那时就已经固执地认为资本主义与社会主义两种体系根本对立、无法共存，同时也观察到苏联与东欧国家之间关系的微妙，这些观点直接影响了乔治·凯南对新中国的看法。

职业外交官生涯还促使乔治·凯南成为"精英外交论"的主张者。在乔治·凯南看来，一个国家的外交决策者应该是一群超然、合静的政策分析专家，凭借职业外交官的"远见卓识和经验"，来准确把握国际事务的现实。这些理智的精英字情绪化、易受煽动、有偏见的大众形成鲜明对比。但是，乔治·凯南的"精英外交论"有一个错误的前提，即假定外交专家是一群"没有思想包袱的超人"，不受任何意识形态、传统价值、民族偏见和美国文化的侵染，不受国会和新闻界以及各种利益集团的影响，也不考虑党派利益与个人政治前途，仅把国家利益放在所有考虑的中心，外交决策不过是一个简单化的国家利益计算题。这显然脱离了现实。美国文化是影响美国人对国家利益界定的一个不可忽视的意识形态"透镜"。所有人的判断，，精英也不例外，都会受到文化和既有价值观的影响。完全的价值中立是不存在的。乔治·凯南自身也受到美国非正式意识形态的影响，比如美国自由民主价值观、白人种族优越论，以及对所谓的"极权主义"的痛恨等。这导致他对苏联的看法极其负面，对中国也抱有偏见。

另一方面，从教育背景和早期工作经验可以看出，乔治·凯南的研究重点是西方世界和苏联，他学习运用的外交理论也主要针对欧洲大陆以及俄国。1948年之前，乔治·凯南在日记中只一笔带过地提及中国一次，对于东方世界他既陌生，又缺乏兴趣。这种不均衡的知识结构造成两个后果：一是乔治·凯南考虑国际事务时会自然而然地陷入西方中心论的思维定式，重欧轻亚，忽视中国的重要性。以致他后来发表意见，只要提及中国，总会连带美苏，仿佛中国没有独立的外交思想和价值；另一方面，20世纪20年代的职业外交官训练所灌输的是威尔逊国际主义思想以及对共产主义的"仇恨"，年轻时期的乔治·凯南也毫无例外地接受了这一套意识形态。虽然，在苏联的外交经历与乔治·凯南信奉的现实主义政治观很大程度上纠正了这种夸大意识形态的错误，但他也只是将意识形态与现实政治在外交决策中的顺序加以调换，无法彻底丢弃他对共产主义和东方民族的偏见。而这种偏见，影响了乔治·凯南对中国认识的客观性和准确性。

除了教育经历和传统价值观的影响，乔治·凯南的挚友戴维斯是他了解现代中国历史的老师，也是他处理远东事务时最得力的助手。乔治·凯南关于中国的见解中，可以明显看到戴维斯的影子，而且这种影响成为乔治·凯南的中国观中不可分割的一部分。事实上，20世纪40、50年代美国外交决策者对中国的看法普逼受到那一代"中国通"和在华传教士的影响。

1908年，戴维斯出生于一个在华传教士家庭，幼年时期在中国四川度过，后来成为20世纪40年代美国政府内著名的中国问题专家之一。第二次世界大战时期，戴维斯鲁担任美国驻华领事馆和大使馆的外交官，以及盟军参谋长史迪威的政治顾问，并作为延安观察团的一员会见中共领袖。这段在华经历让他对中国的政治局势有了更为深入的了解。戴维斯字范宣德(Johm Carter Vincent)和谢伟思(John StewatServ-ice)等美国大使馆内的"中国通"一样，都痛恨国民党政权的腐败和反对美国单方面支持蒋政府。这一立场亦延续到战后。

1945年到1946年间，乔治·凯南和戴维斯共事于美国驻苏联大使馆，由此开始了他们两人一生的友谊。1947年，乔治·凯南人主美国国务院政策规划室后，戴维斯成为他的远东事务顾问。在冷战初期关键的两年，美国国务院政策规划室出台的中国政策基本都是两人合作的成果。迈耶教授认为，戴维斯和乔治·凯南在对华观点上相似之处颇多，比如两人都是现实主义外交支持者，认为欧洲和亚洲的均势是美国安全的最好保障，认为美国历史上的对华政策是感性的、优柔寡断的和不现实的；他们都看到中苏在边境问题上的冲突和中国的民族主义情绪，强调不要夸大苏联对中国的影响。乔治·凯南关于中国的这些看法，形成于他和戴维斯长期讨论和交流中。1947年，乔治·凯南在国家战争学院授课时，就已经认识到"共产主义中国并不一定是一个苏联的卫星国"，更可能的前景是"如果你让俄国人独自留在中国，那么他们会像数百年来的其他人一样在这个问题上遭到惨败。"这一见解就明显带有戴维斯的印记。

在麦卡锡主义最猖狂的时刻，戴维斯被指责为导致美国"失掉了"中国的祸手，乔治·凯南顶着巨大压力为其作证，称赞他是"一个有着广博、老练和批判性政治理解力的人，没有一丝一毫对共产主义分子的恰悯，并且在献身我们政府的利益方面不亚于任何人"。这也是乔治·凯南自身对华立场的最好总结。乔治·凯南看待中国，较之那一时期美国政府内的大多数人更加温和，但不是因为思想上的同情或是文化上的理解，而是出于一名美国职业外交官对美国国家利益仔细权衡的结果。1984年，80岁高龄的乔治·凯南仍对好友戴维斯的帮助心存感激，曾采访过他的北京大学国际关系学院张小明教授说，乔治·凯南对亚洲的了解都来自于戴维斯的指教。影响乔治·凯南的中国观的另一重要因素是其国际政治观，即把国际政治视为一种"现实政治"(Realpolik)，主张决策者以国家利益而非意识形态或道德因素作为国际政治的主要考量。乔治·凯南对现实政治理论的偏爱，源自他早期受到的大学教育和职业外交训练。他鲁学习俄语的柏林大学东方学院，即由俾斯麦创建，现实政治的观点非常流行，对乔治·凯南产生了终身影响。因此"现实政治"理论是乔治·凯南现实主义外交思想的基础，也是他思考中国问题时的理论分析框架。

乔治·凯南认为，美国的对外政策必须建立在国家利益和实力的基础上，依赖权力政治和维持均势实现外交目标。1951年，乔治·凯南撰写的《美国外交》集中阐述了他的现实主义政治观，被奉为美国现实主义政治家的"圣经"。该书认为，美国传统的对国际事务的处理方法，即"认为通过接受某种法规和制约的体制有可能抑制国际领域中各国政府一些混乱而危险的想法"，是脱离现实而且背离美国利益的。

这种方法假定国际社会由平等的主权国家构成，所有国家都对现有的国际边界和所处地位"相当满意"，且存在负责任的国际仲裁和能够对违反国际法的行为采取制裁，这是不可能的。美国人总是"拿自己的标准来衡量别人"，测试他国的政治制度是否符合"民主"概念，而不管其他民族是否适合美国式的民主。这不过是美国的一厢情愿，超出了美国的能力范围，只会伤及自身。因此，乔治·凯南主张应该使用有限的实力保证核心利益，不做不切实际的道德承诺，也不要奢望成为国际榜样。

乔治·凯南把他的现实主义外交原则同样应用在对中国问题的思考中。在《美国外交》一书中，他以19世纪末美国提出的"户开放"政策为例，严厉批判了美国历史上对华政策的理想主义倾向。在他看来，与美国在欧洲的孤立政策不同的是，美国对东方的态度总是缺乏自制。"门户开放"创造了在美国盛行半个世纪的关于东方事务的"迷思"(myth)，让美国人把自己当成"那个不如我们幸福、不如我们发达的民族的品德高尚的庇护者、恩人和导师"。乔治·凯南认为，该政策的错误在于美国"不愿意承认各国的现实力量和愿望的确定性和合法性"，"总感到有义务对它们做出道德的判断"。也就是说，美国在远东的政策关注点不是承认既有的权力分布现实，而是试图改变国际关系格局使之符合美国国内的道德标准。显然，这种"为实现美国人的观念所做的努力"，恰是乔治·凯南所推崇的现实主义外交所攻击的重点。

除了秉持现实主义的外交目标外，乔治·凯南还主张运用现实主义的外交手段——权力制衡———来应对新中国。乔治·凯南设计的遏制战略，即通过维持欧亚大陆的力量均势遏制共产主义势力的"进一步扩散"。他设想在远东建立防御地带，通过防守冲绳、台湾、菲律宾等关键性岛屿来制衡东亚大陆。他认为，美国没有实力也没有必要防御中国。乔治·凯南理想中的遏制政策不是全面出击型的进攻性防御，而是有重点的防守性防御。在他看来"在全世界范围内扩散美国体制将超出美国的能力"，而美国还"没有伟大和强大到如此地步，以至于仅凭我们自己就足以征服、改变或经久地臣服所有…··敌对的或不负责任的势力。"美国只需要利用有限的实力，控制日本和台湾地区来制衡苏联和中国，就能达到遏制的目的。他认为只要美国耐心等待，坚持不懈地支持中国的"铁托主义"倾向，就能把中国从苏联阵营中剥离出来，实现亚洲大陆的力量均衡。可惜，乔治·凯南寻求权力制衡的现实主义手段最终并没有为美国政府采纳，NSC68号文件旨在全球范围内对共产主义进行遏制，美军在朝鲜战争中越过"三八线"企图打破亚洲均势，干涉越南更是远远超出重点遏制的范围。这一系列决策都违背了乔治·凯南设计的"遏制战略"的初衷。直到尼克松一基辛格时期，美国重新尝试在亚洲建立均势，才回归乔治·凯南所坚持的现实主义外交模式中。

### 结 语

乔治·凯南被誉为"遏制战略之父""冷战之父"。美国国务卿艾奇逊鲁说"你 再也找不到第二个凯南"。外交政策专家威廉·邦迪(William P.Bundy)认为，乔治·凯南在思想上常常"比一般人要超前二三十年"。虽然直接参与美国外交决策的时间不过短短数年，但无论在朝还是在野，乔治·凯南的观点都不容忽视。特别是他离开国务院后，乔治·凯南对美国外交政策做出的充满智慧和远见的评论通过大量的著作、文章、演讲和采访在美国社会广泛传播，通过引导公众舆论继续影响美国政府。他一生撰写了近20本著作，两次荣获普利策奖，两次获得国家图书奖，同时还是美国历史学界最高奖项"班克罗夫特奖"的获奖者。因此，乔治·凯南的中国观不仅仅是美国外交思想史、特别是现实主义外交思想的重要内容，还很大程度上影响了冶战时期的美国对华政策，并间接影响了那个时代美国人心目中的中国印象。

教育文化背景、戴维斯的影响以及现实主义国际政治观是塑造乔治·凯南中国观的主要因素。乔治·凯南一生都在寻求现实，把国家利益、均势、权力放在考量的中心，力图帮助美国政府摆脱对华政策中的理想主义色彩。然而这样一个现实主义的保守派，依旧无法摆脱美国文化和自由主义意识形态对他的潜在影响。现实主义理论面临的最大悖论是，它必须承认一个"既有现实"，即美国本身就是一个富有理想主义色彩的国家"道德一法制"目标已然成为国家利益中不可分割的一部分。即使是外交精英，也无法摆脱这种文化传统的束缚。

在这些因秦的综合影响下，乔治·凯南对中国的看法比同时期的大多数美国人更为客观、实际，但依旧充斥着文化和意识形态偏见。这使他关于中国的认识过于肤浅，亦不全面，并大大低估中国的潜力及其对世界的影响。1980年短暂的中国之行，虽让乔治·凯南一度对改革开放后的中国刮目相看，还亲口承认中国是他"有关世界事务知识结构中的一个严重缺陷"。但是乔治·凯南对中国的看法并没有因此改变。直到1999年，他仍强调要把中国摆在"二等战略"地位上，不可太过亲近，他认为中国人"根本不喜欢"美国人。他对中美关系的未来也一直保持谨慎态度，称他"看不到中美政府间关系的加强会给我们带来什么美好的发展前景"，美国要尽量少与中国接触，特别是"不要低估贸易问题"，也不要使用人权问题向中国政府施压。显然，作为美国现实主义外交的代表与美国"最睿智"的人，乔治·凯南在看待中国时亦无法摆脱意识形态偏见和知识不足导致的局限。

---

荐书：《凯南日记——用一百年和美国告别》

本书从凯南8800多页日记中精选内容，真实再现了众多重大事件的幕后故事。作为美国最受关注的外交官和外交政策战略家，凯南在日记中展现了深刻的政治、道德见解和哲学反思。
