---
layout: post
title: 击鼓传锅进行时
categories: Archive
date: 2020-02-27
tags: 新冠肺炎
image_feature: "https://i.loli.net/2020/02/28/MflYXVmB7hUKc2G.jpg"
description: 关于“甩锅”这个话题，我今天为大家做一次最为详细的梳理。
---

![](https://i.loli.net/2020/02/28/3VMPIYlTn6ksUmQ.jpg)

新冠疫情至今，谁的锅？是公众最关注的问题之一。

2月26日，《财经》杂志推出了迄今为止关于此话题最为重磅的报道之一，他们采访了第二批去武汉的国家卫健委专家组某位不愿透露姓名的成员，文章数千言，核心意思就一个——我们北京去的专家组被蒙蔽了，当地隐瞒了人传人，锅不是我们的。

新闻要对比着看，信息得对比着分析，这样更容易抓住重点。

关于“甩锅”这个话题，我今天为大家做一次最为详细的梳理。

### 第一回 周市长拉开序幕

![](https://i.loli.net/2020/02/28/MflYXVmB7hUKc2G.jpg)

**1月27日**，武汉市长周先旺接受央视采访时的说法，被普遍认为是将锅甩给了上面——我上报了，但没权披露。而法律界比较主流的观点认为，依法披露疫情的责任主体是国家卫健委。他的原话如下：

> “披露不及时，这一点大家要理解，因为它是传染病，传染病有传染病防治法，它必须依法披露，作为地方政府，我获得这个信息以后，授权以后我才能披露，所以这一点在当时很多不理解。__后来特别是元月20日，国务院召开常务会议，确定了这个病作为乙类传染病，并进行甲类传染病的管理，而且要求属地负责，从这之后，我们认为我们的工作就主动多了。”

**评析**：

> 此说法还有个关键点，他什么时候获得了这个信息？是1月初还是1月中旬之后？他报了什么？个中区别，宜自行体会。

### 第二回 曾光的回应

![](https://i.loli.net/2020/02/28/XxOfdWMmSv5PRnb.jpg)

**1月30日**，中国疾控中心流行病学首席专家曾光接受胡锡进采访，其中一段对话可看作是回应。

曾光表示，武汉此次面对疫情行动有些慢主要是科学认识的问题，但也不排除一些决策上的犹豫，对自己是不是自信。公共卫生人员的决策考虑的就是科学性的问题，是一个科学的视角，但政府官员考虑问题并不单纯是科学的视角，这只是他们决策依据的一部分。

> “他要考虑政治视角，考虑维稳的问题，他要考虑经济的问题，他要考虑春节老百姓的天伦之乐，满意不满意的问题。__我们说的话往往只是他们决策中采纳的一部分。”

**评析：**

> 这段话其实点名了几个事实，一是承认自己的认知也有过程，科学原因是主因；二是做决策的是官员而不是我们专家；三是科学上的考虑只是决策的一方面；四是直言地方官员出于维稳等考虑有犹豫。
>
> 不过，有社会生存经验的朋友都知道，一个人点评时的重点，有时不是他主要说的内容，而是话锋一转后说的内容。

### 第三回 马书记的“愧疚”

![](https://i.loli.net/2020/02/28/mEQvhc5qaTWr3gJ.jpg)

**1月31日**，前武汉市委书记马国强接受央视采访时，承认采取管控措施晚了，其原话为：

> “我现在是一种内疚、愧疚、自责的心态，如果早采取严厉的管控措施，结果会比现在好，对全国各地的影响要小，也会让党中央、国务院少操心。”

这段采访中他还提到两个时间点：

* 一是12月30日、31日，武汉将情况上报国家卫健委。

* 二是1月12日、13日，泰国曝出第一例感染者后，武汉采取了机场测温、高铁站测温等措施。

**评析：**

> 承认管控晚了，不等于证实存在瞒报，通看这篇采访，马国强的核心意思是——我没有当机立断。不过，即使是14日启动的码头管控措施，也被很多媒体发现并不够严厉。
>
> 同时，12月30、31日武汉上报一说，也与一些信息矛盾，比如经济学家华生提到，中国疾控中心主任是在12月30日晚上网冲浪时注意到疫情，随后报告了卫健委领导。另外一则信息也可对比着看，1月22日，国家卫健委副主任李斌在新闻发布会上说，2019年的12月30日，国家卫健委获悉湖北省武汉市发生了聚集性不明原因的病毒性肺炎，第一时间派出国家工作组和专家组，这里的用词是——“国家卫健委获悉”。未说明主动还是被动。
>
> 而且，“上报情况”也不等于上报了人传人的情况。

### 第四回 现主任与前主任

![](https://i.loli.net/2020/02/28/M2ic37Jy6dsRnDF.jpg)

**1月30日开始**，随着疫情数据陡升，媒体纷纷质疑传染病防控的另一个系统——SARS后建立的疾控直报系统是否起了作用？但出现两种截然不同的说法。

** •**中国疾控中心原副主任杨工焕表示，中国疾控中心有专门监测系统，每天写分析报告，而且不是逐级报告，医院在网络系统中点击了报告病例，中国疾控中心就应该能收到。

** •**中国疾控中心现任副主任冯子健则说，新型冠状病毒（当时）未列入法定传染病，无法使用两个小时直达国家层面的网络直报系统。调整网络直报系统设置、人员培训需要一个过程。针对1月16日一些医务人员感染治疗的消息，他回应说，不是特别清楚CDC是否收到信息，他还说，数据上报层级很多，包括国家级、省级、市级、区级。“数据上报有个过程，这个过程我没有详细了解”。

**评析：**

> 从事后媒体披露的信息来看，武汉方面对医院上报病例限制了诸多条件，因而，不管这套系统是否运行，它最基础的环节可能就失效了。同时，地方疾控是向地方卫健委和政府负责的，而不是像海关一样垂直管理，这可能是需要理顺的地方。

### 第五回 王广发喊冤

![](https://i.loli.net/2020/02/28/iLWSR3hvwYjUOC2.jpg)

**2月2日**，舆论漩涡中的北京大学第一医院呼吸和危重症医学科主任王广发，回应了自己在1月10日引发质疑的“可防可控论”。

核心意思就两个，一是我们拿到的资料有限，二是判断也不是我一个人能做的。

王广发表示，我们掌握的资料是比较有限的，从有限的资料来看，当时我们没有看到明确的人传人的证据，当时给我们的资料是41例确诊病例，这当中有两起聚集性病例，我们请教过CDC的专家，没法得出“人传人”的结论，这需要流行病学专家来回答。当时我们确实没有证据，不是个人去判断疫情，而是集体一起研判，但是研判的资料，必须得是没问题的。原始的资料有欠缺，甚至有些信息根本没拿到，判断上就会失误。

**评析**：

> 这段采访的信息含量其实非常大。
>
> 先科普下，根据中国新闻周刊等媒体披露的信息综合判断，此次国家专家组一共三批：第一批是12月31日去的，组长是中国疾病中心传染病实验室徐建国，成员有北京地坛医院李兴旺、中日友好医院曹彬。第二批是1月8日去，16日回来的，成员有地坛医院的蒋荣猛、北大人民医院高占成、中国疾控中心副主任冯子健、原副主任杨维中等。第三批是1月18日去的，包括高福、钟南山等。
>
> 王广发是第二批去的，财经杂志2月25日晚的重磅报道，也源自对这批专家其中一位的采访，但肯定不是王广发，因为报道中提到这位专家1月底才离开，而王广发16日就回京了。
>
> 然而，对比王广发的言论和这位匿名专家的言论，可以发现互相印证但仍然迷惑的几个点。
>
> 首先，王广发表示我们也不是仅仅局限于一份报告，因为它是二手资料，主要是当地的CDC（疾控中心）和卫健委报上来的，我们也下去看病人。而在财经杂志专访报道中，专家们似乎被当地牵着鼻子走，大部分时候是靠汇报和材料获取的信息。那么，下去看病人时的详细情况究竟如何呢？
>
> 其次，王广发称，我看到发热门诊病人很多，有些病人肺部的CT片子是非常典型的新型冠状病毒肺炎，当时拥挤在医院的这类病人数量并不少，但是医院还能够应付，他表示，这是1月14号、15号我们了解的情况。于是专家组对有些单位提建议，不能让病人都淤积在发热门诊。这段话可能说明，第二批专家组至少在考察后期对可能存在的人传人应该是有一定认知的，而不是完全不知道的，那么他们采取了什么紧急措施？

### 第六回 钟南山再发言

![](https://i.loli.net/2020/02/28/k49VcMmjQ1zY6On.jpg)

**2月11日**，钟南山在接受路透社的视频专访中表示，当地政府、当地卫生部门工作做得不好，他们应该负上一些责任。因为已经发现了病原，出现了小规模聚集发病，但最终并没有控制住。他还表示，应该改善疾控中心的运作方式：

> “如果我们有更好的协调合作，我们就能更早发现它，更早查明人传人的情况，”

**评析**：

> 这是钟南山第一次谈及责任问题，也是唯一一次，他老人家已经说得很明确了——地方政府发现了但没有控制住，同时，没有更好的协作，我的理解是指卫健委、疾控、地方政府、基层医院、研究机构之间的关系。

### 第七回 高福的黑与白

![](https://i.loli.net/2020/02/28/MKnY5BENs7aAT18.jpg)

**从2月开始**，针对中国疾控中心主任高福的批评越来越多，众多自媒体将其视为疫情未能控制住的罪魁祸首，甚至发展到有自媒体造谣高福被查。

反对者认为：疾控系统未能提前预判到人传人，难辞其咎，高福本人言论多有失当之处。

而以华生为代表的高福支持者则认为：疾控在这套体系里根本没有啥实权，背不起那么大的锅，高福本人在前期病原确定上做了工作。

**评析：**

关于高福事件的前因后果，以及相关信息的评判，“媒体炸鸡”曾做过非常详细的梳理，欢迎[移步此处](http://mp.weixin.qq.com/s?__biz=MzA3MTY0ODAxNw==&mid=2652996846&idx=1&sn=d24489838deb68bdfafb104c06b98704&chksm=84ff7290b388fb866a75d93930d377ee4058a77578c1296e8ea81ff48d019ae14782ad40f6d3&scene=21#wechat_redirect)查看。

### 第八回 诊断上报标准之争

![](https://i.loli.net/2020/02/28/BzKRCxp5ZD8E93y.jpg)

**从1月底开始**，陆续有媒体报道此一问题。

在财新对武汉一线ICU医生的采访中，提到不少重要信息，比如1月初执行的诊断、上报标准中有“华南市场接触史”这一项，而在当时很多一线临床医生看来，这个标准过于苛刻，会漏掉病人——因为当时已经出现了人传人迹象，也有医护人员出现症状，还有非华南市场的疑似感染者。

这一信息在传播过程中，被很多认为上述标准是国家专家组制定的。但在2月中旬开始，包括中国青年报在内的媒体，陆续报道了进一步的消息：武汉市当地执行的标准，和省里面、国家专家组的标准不一致。核心意思是——国家专家组不背这个锅。

国家专家组的标准是，具备临床症状——发烧；发病早期白细胞正常或降低；肺炎影像学特征；抗菌治疗无好转，同时具备这四项可确诊为不明肺炎。而如果患者有华南海鲜市场暴露史，则不需要满足“抗菌治疗无好转”这一条件。

而武汉执行的标准中，除了临床标准与“国家专家组标准”基本一致，更重要的是要求同时具备流行病学史——去过接触过华南市场。

财新的报道中提到，一位接近湖北省专家组的人士称，国家专家组成员看到武汉标准后很生气，后来武汉重印了标准，但很多医院还是在执行市里的标准。

**评析：**

> 其实，如果认真看过上述媒体的报道，就不会对26日晚财经杂志的重磅报道感到诧异，因为他们都在说同一件事——武汉一级对疫情信息上报标准的严格控制。

### 第九回 国家专家组成员对湖北武汉的重击

![](https://i.loli.net/2020/02/28/GwEHtYjdfWq4Za8.jpg)

**2月26日晚**，财经杂志的重磅报道，不少朋友都看过了，这位匿名专家提到了几个重要信息，我再给大家梳理下：

** •**武汉提供的资料，没有医务人员感染。我们当时听说哪有医务人员感染，都会一个个打电话去问，结果最后得到信息根本不是。医护人员的感染区我们也没看到，谁知道他们在哪。这么大的院区，我们怎么去找呢？

** •**我们一直怀疑有“人传人”，但就是没有证据。他们没有告诉我们实情，从现在真实的情况看来，他在说谎。

** •**我们专家组一致的意见是，疑似的、确诊的都要报出来，我们临走前都说好了。但是第二天见报不是这样。新闻出来，地方上报出来的是41例，仅仅是实验室方法确诊的一批人。背后的那些事情，我就不懂了。

** •**我们听说（医护感染）消息，就联系院方，因为不知道具体是哪个医生，联系完了人家不跟你说，不跟你说实话。我们也没办法，因为很明确是属地管理，我们接到的这个指示是地方为主，国家专家组帮忙、指导、辅助。

** •**当时我们讨论的时候，我们让他如实报。卫健委的领导当场就说了，他说，“你们是不是怀疑我瞒报啊？”他公开反问我们，专家组的都在场。他都这么说了我们还能说什么？

**评析：**

> 财经这则报道与前述财新、中青报的报道有所不同，专家将矛头还指向了湖北省一级卫健委，因为他提到的发言的卫健委领导，正是后来被免职的湖北省卫健委主官。不过从舆论反应来看，除了对地方政府的指责，公众对这批专家组仍然是非常不满的——调研作风太过官僚。

### 第十回 指向卫健系统的病原检测之争

![](https://i.loli.net/2020/02/28/PlhZHeupa7AY6Mj.jpg)

**2月26日当晚**，就在财经推出报道后，财新也推出了一篇重要报道，这篇报道指向了另一个问题——对病原的确定时间是否因为某些原因推迟了。

财新的报道称，种种证据显示，在去年12月底之前，有不少于九名不明肺炎病例的样本被从武汉各医院采集，基因测序显示病原体是一种类SARS冠状病毒，这些检测结果陆续回馈医院并上报给了卫健委和疾控系统。但中国疾控中心确定病原是在1月8日。

这篇报道披露了两个重要信息。

** •**一是有基因测序公司人士透露，2020年1月1日，他接到湖北省卫健委一位官员电话，通知他武汉如有新冠肺炎的病例样本送检，不能再检；已有的病例样本必须销毁，不能对外透露样本信息，不能对外发布相关论文和相关数据，

** •**二是1月3日，国家卫健委办公厅发布了一份名为《关于在重大突发传染病防控工作中加强生物样本资源及相关科研活动管理工作的通知》，这份国卫办科教函（2020）3号文规定，未经批准，不得擅自向其他机构和个人提供生物样本及其相关信息；疫情防控工作期间，各类机构承担病原学检测任务所产生的信息属于特殊公共资源，任何机构和个人不得擅自对外发布有关病原检测或实验活动结果等信息，相关论文、成果发表须经委托部门审核同意。

相对应的，《新京报》也在前一日推出了类似报道——他们专访了上海公共卫生中心书记卢洪洲，卢先生表示，我们1月5日就提交了报告，敲了我们单位正式的章，不是随随便便的，这就说明了我们的重视，但不该发生的还是发生了。

在网络流传的截图中，那份报道清晰地写明了可能的病原，并建议在公共场所采取防控措施，并报送给了国家卫健委。

![](https://i.loli.net/2020/02/28/huZsJaNWEvy1BTD.jpg)

**评析**：

> 除了临床和流行病学证据，新型病毒的分离和基因测序，其实是判断病毒危害性的重要因素。从财新的报道来看，其实国家卫健委早在今年初对该病已经“高度重视”了，不过按照《传染病防治法》规定，病毒检测和病原确立是疾控中心的职责，也只有国家和省级疾控中心才有资格做。但实际上，随着基因技术的市场化应用，大量企业、科研机构已经具备上述能力，那么，在可能的重大传染病面前，是否也要把他们排斥在外呢？是基于什么样的原因没有采纳他们的信息？如果善加利用是否能争取更多时间呢？这又是媒体报道留给我们的新问题。


我相信，在看了上述信息梳理后，大部分人心中已经有数了。

说句正确的废话：一个问题的发生，一定既有个人的因素，比如那些已经被免的官员和还没被免的责任人；也存在某个体系的因素，比如上文中反复提到的传染病预防体系，至于那个因素起的作用更大，还需要更多信息来评判。

相信后续会有更多信息爆出，在疫情过后，国家层面的调查会给到公众一个回应。有一分证据说一分话，在此，就不再妄加揣测了。


1.独家|新冠病毒基因测序溯源：警报是何时拉响的.财新网

2.新闻1+1丨马国强：我现在是一种内疚 愧疚 自责的心态.央视新闻客户端

3.武汉市长周先旺接受央视专访：不怕在历史上留下骂名.央视新闻

4.马国强不再担任武汉市委书记，曾自责没有“早点决定、采取措施”.政知圈

5.国家卫健委副主任李斌：已开展相应工作防止疫情进一步扩散.人民网-人民健康网

6.中国疾控中心首席科学家曾光：武汉行动慢不排除决策上的犹豫.钛媒体

7.刘玉海.中国疾控中心原副主任杨功焕：SARS之后国家重金建立传染病网络直报系统，应关注其在这次疫情中如何运行.经济观察网

8.卫健委专家组成员王广发出院了，回答了我们8个问题.冰点周刊俞琴 黎诗韵.追问卫健委第二批专家：为何没发现“人传人”？. 公众号“财经E法”
