---
layout: post
title: 医院里新型冠状病毒肺炎检测试剂盒短缺，这是真正的原因
categories: Archive
date: 2020-01-24
tags: 新冠肺炎
description: 这一现象被外界简单解读为“供不应求”，但事实上，这一现象应从生产、市场准入、采购、使用等多个环节来解析，一句“供不应求”不足以还原问题的复杂面貌。
---
原文来自「界面新闻」：~~<https://web.archive.org/web/20200124143729/https://mp.weixin.qq.com/s/z9tk9f3iX-oT5lw55EIgaw>~~

记者：谢欣
---

> 多家生产企业均表示产能充足，但未获批上市的产品无法直接被医院采购，药监局仍在研究“特事特办”，试剂盒还需搭配检测仪器使用，诸多原因造成了医院里试剂盒短缺的局面出现。

新型病毒核酸检测试剂盒（以下简称“检测试剂盒“）作为本次新型冠状病毒感染的肺炎确诊的重要手段，目前包括武汉在内，各地均有反映院内检测试剂盒缺货的情况发生，而尤以湖北省内居多。

这一现象被外界简单解读为“供不应求”，但事实上，这一现象应从生产、市场准入、采购、使用等多个环节来解析，一句“供不应求”不足以还原问题的复杂面貌。

### 生产

针对检测试剂盒的供应问题，界面新闻记者采访了作为国家卫健委确定的三家生产企业之一，上海捷诺生物某负责人。这位负责人表示，目前在生产端供应是充足的。

据其透露，迄今为止，上海捷诺生物给武汉供应的检测试剂盒在5万人份左右。生产能力上，昨日（1月23日）生产了3万人份，今天（1月24日）可生产12万人份。尤为重要的是，该负责人表示，目前接到的所有疾控订单都及时交付了。

而对于物流问题，目前上海捷诺生物基本都是专线专人专送，而另一家生产企业上海辉睿生物方面此前对界面新闻透露，公司通过三地仓库就近发货，物流手段包括空运、人肉带货等等。

据此前了解，上海辉睿生物的产能则至少在生产2万人份，而国家卫健委确定的生产企业还有上海伯杰医疗，此外已有超过20家企业宣布研发成功了检测试剂盒，这些企业虽然并不是国家卫健委确定企业，但这些企业也可向地方疾控进行销售。

必须强调的是，虽然本次是新型病毒，且目前在临床上未有特效药物，但界面新闻此前曾报道，无论是检测人士还是生产企业均表示，在病毒基因全序列公布后，找到特异性片段，做出检测试剂盒并非一件高技术难度的事。

而在生产上，排除春节放假因素，某业内知名企业基因检测市场总监对界面新闻记者表示，每家生产企业有自己的工艺，最主要在于做出标准品，并判断其检测能力，此外需要与试剂如预混液配比，构成完整的PCR反应体系。目前超过二十家企业宣布研发成功，虽然目前并未有整体的产能统计，但产能是充足的。

### 市场准入与采购

从生产企业到疾控采购的这一过程，各方企业负责人都称没有出现供不应求的情况，为何又会出现湖北各地医院纷纷表示检测试剂盒缺货？

通过梳理整个流程我们发现，新型病毒检测试剂盒在院内缺货的首要原因在于，根据国家法规政策，各级医院目前无法直接采购新型病毒检测试剂盒。

根据相关药品、医疗器械的相关法规，一般情况下，在中国境内获批上市的药品、医疗器械应首先在各省、市级招采平台挂网，随后由医院进行采购。对于首次进院药品、医疗器械产品而言，往往还需要院方召开药事会通过才可采购。但在目前的疫情下，药事会与挂网窗口这两方因素的影响可忽略不计。

然而，尽管各家企业研发出了新型肺炎病毒检测试剂盒，但这些试剂盒并未获得国家药监局批准正式上市。

检测试剂盒作为三类医疗器械，一般情况下首先需要经过开展临床试验、随后向国家药监局提出上市注册申请，由国家药监局进行审评批准后方可以正式上市，才获得挂网招采机会，并且进入院内销售。而这一流程往往需要好几年。

上述市场总监表示，对于检测试剂盒的注册国家药监局有严格审评流程，临床阶段要有复杂的质量质控、研发，生产流程文件提供，需要抽检三批试剂。

对于临床样本数量不同的疾病，也有不一样的要求，有的入组人数需求多达几百、上千人。而仅仅是向国家药监局审评提交文件注册这一环，常规来看要一年时间完成。

因此，目前所研发出的新型肺炎病毒检测试剂盒，实际上作为未获批上市产品身份略显尴尬，都无法由医院端直接采购进行使用，而只能向疾控部门进行申请使用，这也直接影响了对疑似病患的检测工作。

### 疾控中心

界面新闻获悉，在疫情刚开始之时，研制新型冠状病毒诊断试剂的机构有四家，分别是中国疾控中心、中国医学科学院、武汉病毒所和军事医学科学院。

最终，四家科研机构经过多轮比拼，代表中国疾控中心的三家生物科技企业研制出来的诊断试剂最终胜出，并以与疾控科研合作的渠道，向疾控系统提供检测试剂盒。

界面新闻记者从多个信源独家获悉，目前国家药监局等相关部门正在开会研究，是否要针对检测试剂盒开通特殊上市渠道，以帮助医院提高检测诊断能力。

到目前为止，药监局仍在做产品筛选，尚未有结论性文件出台，有知情人士透露：“预计很快了”，并称“特殊渠道开通后，预计院内供应不成问题”。

不过，新冠状病毒感染的肺炎疫情在本周进入了一个严峻的阶段，从医生到病人，都有点“等不起”了。

业内人士指出，从逻辑上看，开放特殊上市渠道是会有助于解决院内缺乏试剂盒现象的，目前的疫情形势也需要一些政策推动来解决问题。

在大型公共卫生事件发生时对一些新研制医药产品开辟特殊通道并非没有先例，2003年“非典”时期便曾执行过类似措施。

但值得注意的是，生产试剂盒的企业方对界面新闻表示，尽管控制疫情发展迫在眉睫，也希望政策制定和产品筛选一定要谨慎，以免酿成不良后果。

那是否意味着，目前各地疾控在采购量上出了偏差，从而导致可以调配给医院的检测试剂盒出现紧缺？现有信息尚难以判断，但有业内人士透露，有些地方疾控出现了采购资金不足的情况。

1月23日，按照国务院部署，财政部紧急下拨湖北省新型冠状病毒感染的肺炎疫情防控补助资金10亿元，支持湖北省开展疫情防控相关工作。

### 检测条件

另一不容忽视的因素是检测条件。

武汉市卫健委1月23日曾表示，前期（1月16日后）对疑似病例样本检测流程是：首诊医院通过规范的预检分诊，结合临床检查、实验室检查和胸部影像检查；经专家组会诊后确认疑似病例并采样，由辖区疾控中心将样本转运到市疾控中；市疾控中心转运到省疾控中心，进行核酸检测。每天省疾控中心可检测样本200多份，从采样开始到结果返回，当前约需要2天左右的时间。

前述业内人士分析，这种看上去相当繁琐的办法，是卫健委考虑到现有的检测试剂盒都没有通过正式审评上市，为了谨慎起见，都由省疾控来检测。

事实上，并非有了检测试剂盒，医院就可以开展病毒检测。

本次3家试剂盒均为RTPCR法，需使用PCR仪器在PCR实验室中进行检测Z有业内人士分析，PCR仪器生产厂家多如牛毛，应该不会存在缺少仪器的问题，但是否所有医院都拥有规范的PCR实验室，这要打一个问号。

武汉卫健委1月23日的通报也指出，由于国家已将新型冠状病毒的肺炎纳入乙类传染病，采取甲类管理，对该类病原的样本检测，按照高致病性病原微生物（第二类）进行管理，相关样本的检测、运输等，必须符合生物安全管理的相关要求，病原相关实验活动应当在具备相应防护级别的生物安全实验室开展。

此外，也有一些更复杂的情况，如国家卫健委在公布三家试剂盒采购公司的同时也宣布，第三方检测机构为深圳华大基因科技有限公司。

对此，华大基因对界面新闻表示，华大基因作为检测机构所承担的责任在于：以上3家试剂盒均为RTPCR法，但如果遇到病毒持续变异或者宿主背景复杂，或者需要组装成病毒基因组，仍然需要用高深度测序。两种方法互相配合，即能快速判断，又能积累病毒基因组数据。华大基因本身也有对应试剂盒，但其他机构均无应急病原基因组高深度测序能力。有一个比喻：“RTPCR法是钓鱼，基因深度测序是一网打尽。”

由此推断，而一些不具备检测能力与检测条件的医院，自然也不会有检测试剂盒了。

业内人士分析，对于一般三级医院来说，PCR检测与实验室应该都是有多年操作经验了，基本不成问题，不过在目前医院病人爆发式出现的情况下，可能会有人力不够的问题。

但他也认为，如果病人越来越多，除了病毒分子检测，后续的影像、血清检测工作“不下沉到一线医院是不行的。
