---

layout: post

title: 胡泳：谣言作为一种社会抗议

categories: Archive

date: 2020-01-22

tags: 社会抗议

description: 谣言既是社会现象，也是政治现象。……‘官方’来源的概念就是政治性的，它取决于一种共识，这种共识阐明了谁拥有法律上的发言权，即便其缺乏道德上的发言权。
---

原文来自「传播学之思」：~~<https://2049bbs.xyz/t/2622>~~

作者 胡泳

---

**“谣言既是社会现象，也是政治现象。……‘官方’来源的概念就是政治性的，它取决于一种共识，这种共识阐明了谁拥有法律上的发言权，即便其缺乏道德上的发言权。**

**谣言是与当局的一种关系：它揭露秘密，提出假设，迫使当局开口说话，同时，又对当局作为唯一权威性消息来源的地位提出异议。****谣言在无人邀请的情况下自发地争夺发言的权力。它经常是反对派的发言：官方的辟谣并不能说服它，因为它感觉官方与可靠性并不是相辅而行的。**

**谣言令我们质疑当局，对‘谁有权对什么事发言’提出质疑。谣言提供的信息与官方信息有时是相左的，所以，****谣言构成了一种反权力，即对权力的某种制衡。****”**

——————假装是分割线——————

### 1 最古老的传播媒介

谣言是最古老的传播媒介。在出现文字之前，口传媒介是社会唯一的交流渠道。“谣言传递消息，树立或毁坏名声，促发暴动或战争。”（卡普费雷，1991：5）现代对于谣言的首次系统研究兴起于二战期间的美国，最初的着眼点是战争期间谣言的大量繁殖对军队士气产生的不良影响。无论是政府、媒介还是民间机构的意见领袖，无不把谣言作为腐蚀士气甚至产生破坏的一个潜在的源泉，谣言控制的想法也随之提上了日程。

谣言控制学说的代表人物是罗伯特·纳普、戈登·奥尔波特和利奥·波斯特曼等人。基于其二战期间在麻省公共安全委员会的工作，纳普分析了战争中流行的超过一千条的谣言，认为谣言是社会失序（战争就是失序的表现）的一个结果，是社会态度和动机的一种投射。他认定谣言主要反映的是人们仇视性和分裂性的冲动，这种冲动很难通过其他方式发泄出来。

既然谣言如此令人不安，就必须制止它的大量流传。纳普提出了五条“建议”，包括：应使公众对所有官方传播媒介予以无保留的信任，应使公众绝对信仰他们的领袖，有效地对工作和闲暇加以组织等（Knapp， 1944：22-37）。纳普的这些建议，令我们可以反推二次大战中美国的晦暗情境：人们对官方传播媒介缺乏信任，对领导毫无信心，官方对特定事件的信息讳莫如深，大众茫然无知，很多人失业，无以打发无聊的日子。如果说，在大战的背景下，一个民族理尚可被全体动员起来，实施上述的建议，那么，在和平时期重读这些建议，如卡普费雷所指出的，“就好像是在描写一个极权国家”（卡普费雷，1991：10）。

受惠于纳普的经验分析，美国社会心理学家奥尔波特和波斯特曼在二战期间曾对谣言问题进行过专题研究。两人合著的《谣言心理学》一书堪称对谣言的起源和散播的第一次科学的解释（Allport & Postman， 1947）。在研究中，他们关注的是谣言个体传播者的心理过程。他们给一个应试者一张图片，留出时间让他仔细观看。然后他被要求向第二个应试者转述他所看到的场景。第二个人再将他所听到的转述给第三个人，以此类推，到第五或第六个人的时候，信息的70％已然丢失，最终的叙述与开头的图片内容相去甚远。

这其实是把信息的口传视作一个线性的、凡俗的和预定的过程，经历多次累积必然导致信息的扭曲。但这种展示是不无问题的：彼此耳语的模拟实验与自然环境中的谣言运行是完全吻合的吗？对那些最后被证实为真的谣言又该如何论说呢？如果最后的扭曲不可避免，谣言又怎会在某些情况下完好地保存了正确的信息？

与纳普不同，奥尔波特和波斯特曼把谣言视为一种更加日常的行为，既在战争中也在和平年代出现，但值得注意的是，他们和纳普一样，举出的所有例子都是涉及危机情形的谣言。卡普费雷发现，这些研究人员所举的例子都是有倾向性的。“他们只是就那些毫无根据的谣言进行发挥，他们对谣言所下的定义，没有参考谣言所传达的信息中的任何真实性成份。……他们闭口不谈后来谣言核实的结果。”（卡普费雷：1991：7）这牵涉到谣言的定义问题。

### 2 谣言是一种社会疾病？

谣言的定义向来众说纷纭。一位学者在1998年所作的一次文献综述显示，心理学、社会性和传播学都有着各自不同的对于谣言的定义（Pendleton， 1998：69-86）。所以，在社会科学中，谣言是一个缺乏特定定义的概念。

尽管各执一词，谣言研究者们还是对作为传播媒介的谣言存有某些共同的认识。从上世纪40年代迄今，一些代表性的定义可以总结如下：

1．谣言是一个参照当前时事、旨在使人相信的命题，在未经官方证实的情况下广泛流传（Knapp， 1944）。
2．谣言是一个与当前时事相关联的命题，意在使人相信，一般以口传的方式在人与人之间流传，但却缺乏可靠的证据标准（Allport & Postman， 1947）。
3．谣言是一种在人与人之间流传的，对公众关注的事物、事件或问题的未经证实的叙述或阐释（Peterson & Gist，1951）。
4．谣言是在一群人议论过程中产生的即兴新闻（Shibutani， 1966）。
5．谣言是在社会群体中流传的有关当前时事的信息，完全通过口传，往往没有任何事实根据（Morin， 1969）。
6．谣言是一个未经证实的、广泛流传的命题（Rosnow & Fine， 1976）。
7．谣言是在社会中出现并流传的未经官方公开证实或者已经被官方辟谣的信息（卡普费雷，1990）。

依照这些定义，谣言具有自身的结构与逻辑，定义者们无不试图解释这些结构和逻辑。他们大多确认，谣言是一种信息或命题，它赋予与现实有关的某人、某事或某个条件一些新的因素。其次，谣言是口传的，且未经证实。再次，很多定义认为，谣言是为了使人相信。这些定义为我们勾画了谣言的轮廓，例如，它的传播方式（口传）、所传播的内容（谣言是有关时事的，这在某种程度上把它同那些琐碎的、私人的话题区分了开来，谣言因此被归入了公共范畴）和传播的目的（为了使人相信）。但是，在一些关键问题上——谣言所传递的信息的实质为何，以及谣言为什么会持续流传，众位研究者却莫衷一是。

有关谣言流传最广的定义把它当作这样一种命题：它没有清晰的来源，其真实性也大可怀疑，所传递的信息不能很快或从来也不能被证实。这种定义符合人们常识性的看法，往往导致一个简单化的公式：谣言＝虚假的信息。例如，中国学者周晓虹把流言和谣言作了如下的区分：虽然都是无根据不确切的信息，但严格说来，流言是无意讹传的，谣言则是有意捏造的（周晓虹，1998：427）。

如此定义谣言会导致两个窘境：其一，对那些起因于某个事实，在传播过程中被一群心存疑虑的人像滚雪球一般不断“兑水”和夸大的谣言，又该如何解释呢？其二，如果把谣言等同于不实之词，那么它就必然留下这样一种印象：谣言是病态社会的反映，是某种程度上的集体精神病。莫兰分析谣言时就使用了不少医学名词，如病菌、病理学、传染病灶、潜伏期、转移期等等，甚至把谣言直接称为“心理癌症”（Morin，1971）。

坚持谣言没有根据，就等于宣布那些信谣和传谣的人都是不理智和反常的，对谣言的解释因而只能从属于精神病学，或者是勒庞开创的对情绪化的群体行为予以蔑视的传统（Le Bon， 1982）。这种认知在中国存在巨大的市场，例如，随便阅读当下有关谣言的评论，不难发现如下的说法：

“谣言其实如同病菌一样，只有在阴暗潮湿的地方才能孳生。”\[i\]

“如今，通讯和网络的自由度让一些不负责任的话语、别有用心的言论都可能轻易传递，如瘟疫般迅速蔓延，最后成为洪水猛兽，直至淹没了事实的真相。”\[ii\]

“在这样的一个怪圈似的谣言生发漩涡里，人们心态各异，信息光怪陆离，谣言在发威，真相却暗自神伤。在这样一个悖论中，社会越发表现出一种对谣言病态的敏感。”\[iii\]

谣言未必全是虚假的，有大量谣言在后来被证明并不是失实的。事实上，谣言之所以有人相信，正因为谣言经常最终被发现是“真实的”。因而，如果单纯用“虚假”来概括谣言，显然有失偏颇。有学者用“未经证实”来修饰谣言。然而，这个“未经证实”其实也是经不起推敲的。首先，在日常生活中，我们很少去证实一下我们从他人处得到的信息。其次，证实的概念与假定进行证实的人是不可分的。人们常常根据向他们提供消息的人的信任程度，而不是原始消息来源的可靠程度，来判定一个谣传的可信度。在谣言的传播中，一个常见的有趣现象是，我们总是由朋友、同事或亲戚那里听到某个事件的发生，而他们往往并非他们所叙述事件的直接见证人，他们的朋友才是目击者。\[iv\]尽管这个见证的链条并非直接通到我们这里，但由于有目击者的存在，有朋友等对消息的背书，我们就会相信消息的证明。另一方面，如果我们对证实者心存疑虑，那么我们就会对被此人证实了的消息产生怀疑。证实的标准中包含着很大的主观性。

这样看来，以“未经证实的”，尤其是“虚假的”信息为标准而确立的谣言定义，都是存在很大问题的，“反映了对谣言的偏见以及劝人为善的意愿”。（卡普费雷，1991：11）这种偏见推到极致，就是如上所述把谣言视为一种社会疾病。

### 3 谣言作为一种社会认知和集体行动

涩谷保的定义与在他之前占统治地位的对谣言的认识很不相同。按照他的观察，谣言并非反常之举，而是一种日常的试图定义那些模糊然而关键的情境的社会行为。涩谷保的著作含蓄地批评了时人有关谣言的陈见：谣言具有高度的指向性，是非理性的和危险的；谣言是不准确的、扭曲的和夸大的；谣言威胁着社会秩序。他不赞同对谣言的心理学分析将谣言行为个人化的做法，这在上个世纪四五十年代的谣言研究中十分盛行。例如，弗洛埃德·奥尔波特和密尔顿·莱普金对有关战时美国国内配给谣言的研究得出结论说：“一个人获得的信息愈多，他的思考就会愈缜密，他也就更不可能被引导着去相信自己内心常常不为人知的冲动。”（Allport & Lepkin， 1945：3-36）又如，1942年一项有关战时谣言的传播与接受程度的研究计算出了一个“信谣指数”，指出不论是流传度还是接受程度，都是穷人比富人更高；45岁以上的人比年轻人高，犹太人比非犹太人高（这是因为犹太人对让人恐惧的谣言容易感到不安）（奥尔波特和波斯特曼，2003：5－6）。

谣言研究的早期奠基者们，无论是纳普还是奥尔波特、波斯特曼都假定，虽然有着鼓励谣言在一个群体的层面上存在的条件，谣言的实际运行却依赖于个人的主观偏见和谣言行为。这种研究范式建立在威廉·斯特恩和弗雷德里克·巴特利特的系列实验上。斯特恩采用图像测试和真实性实验来寻求有哪些因素影响观察者的描述。\[v\]巴特利特用一系列测试对象依次复述的方法，发现人们会给本来无意义或含混的东西赋予意义。由此，回忆成为一种创造而不仅仅是意识的复制（奥尔波特和波斯特曼，2003：31，33－36）。

斯特恩和巴特利特的想法为奥尔波特和波斯特曼所延伸。他们揭示了个体接受和传播谣言的动机和方式，强调了投射（个人意念、欲望等的外化）是使个体相信并传播谣言的重要的心理机制。他们还研究了谣言的内容在传播过程中的变化情况及其机理，比如削平和磨尖、同化作用、推断和歪曲等。他们后面的大多数研究者往往遵循着同样的路径，把谣言材料的转换与个人的统计学和认知学特征相联系。而涩谷保却认为，这种把谣言的盛行归因为个人内心冲动的控制度和教育赤字的做法，很难解释谣言的勃勃生机，以及谣言为什么会经常突破个人边界而成为一个“公共”的非正式媒介。

二次大战时很多日裔美国人在加州被关进了收容所，通过对收容所中流传的谣言的研究，涩谷保主张，谣言是社会群体解决问题的工具形式，而且是社会过程中的必要部分，让人们得以面对生命中的种种不确定。谣言因此是一种“集体交易”（collective transaction）之后产生的“即兴新闻”（improvisednews），它是“一群人的智慧的结果，以求对事件得出一个满意的答案”。因此，谣言既是一种信息的扩散过程，这对奥尔波特和波斯特曼的研究路径是一个有力的拨正。

涩谷保拒绝承认任何把谣言视作未经证实的、不可靠的或虚假的东西的命题。他把谣言过程视为社会生活中一个正常的而不是病态的部分，等于给谣言正了名。他设想谣言是一种集体行动，目的是为了给无法解释的事件寻找一种答案，这个过程是合作性的，在某种程度上也是功能性的。在这一点上，彼得森与吉斯特同涩谷保的看法相仿佛，他们在谣言的传递过程中看到的不是“削平”与“磨尖”，而是“滚雪球”效应（snowballing）或曰创造性的合作，即寻找谣言中可给人安慰的因素和细节，对这些细节进行添油加醋（Peterson & Gist， 1951：159-167）。涩谷保强调谣言总是处于“不断的建构”之中，谣言内容的变化不仅仅是对信息的歪曲，而是人们达成一致的过程的一部分（Shibutani， 1966：9， 16）。这样，涩谷保更多地把谣言看成理性行动的一种形式，而不是如奥尔波特和波斯特曼所说，它是一种“较少理性的社会活动形式之一”（奥尔波特和波斯特曼，2003：26），一种情绪的表达或投射。

### 4 谣言作为一种社会抗议

既然谣言被视为那些缺乏足够信息的人寻求解决问题的一种努力，那么，一个谣言的公式也就呼之欲出了：

谣言＝（问题的）重要性×（事实的）模糊性

这个谣言公式来自于奥尔波特与波斯特曼，在后来被广泛接受，也为涩谷保所承认。该公式是一个乘法关系而不是加法关系，即是说，假如谣言对个人生活的重要性为零，或者事件本身并非含糊不清，谣言就不会产生了（奥尔波特和波斯特曼，2003：17）。谣言的出现是因为同时满足了重要性和含糊性这两个条件，而它的传播的持久性也与这两个变量相关。

然而，倘若我们仔细地分析，除了重要性和含糊性，至少还有两个条件构成谣言的前提。其一是，一群人需要行动但却迟疑不决，期待身边的形势得到充分的界定；其二是，形势要求在一些基本的层面上群体成员必须共同行动而不是个人单打独斗。

在三种情形下，上述四个条件会同时具备，从而为谣言提供丰厚的土壤。首先，如果在一种社会秩序中，信息被当局严密控制，谣言就会非常激烈。假使对新闻的控制是一个持续而非暂时的行为，谣言就会变得定期化，成为日常生活的一个基本的组成部分。

其次，当发生的事件威胁了正常生活的理解基础的时候，谣言会不胫而走。一个大的灾难或丑闻都会引发这类挑战。同样地，在一个社会中，潜在的冲突对象或互相竞争的群体之间原有的适应和妥协如果被打破，惯常的行为模式也会受到影响。

第三，假如对一个有力的共同行动的推动受到阻遏，谣言也会生发出来。

从第一种情形来看，涩谷保指出，当对新闻的需求大于制度性渠道的信息供应的时候，谣言就会大量繁殖。“为了明智地行动，人们对新闻加以寻求，而谣言基本上就是一种新闻。”（Shibutani， 1966：17）把谣言与新闻并列，涩谷保为我们开启了一扇理解谣言的新窗口。它显示了，报纸和广播中的新闻也不一定是客观的和真实的，而是携带了很多价值观主导的意见和假设。在中央极权的社会，制度性的渠道控制了信息的散播，人们普遍寻求通过辅助渠道获取信息，有时会逾越官方主张的特权。这样，无论从谣言的意图还是从其结果来看，谣言都可能具有颠覆性。

卡普费雷对谣言的研究起始于涩谷保的观察，两人同样认定，谣言并非是某种“真实”的偏离，而是一种人们达成何为“真实”的一致意见的努力。涩谷保写道，谣言语境的存在，是在“对新闻的需求与集体亢奋的激烈度呈正向相关”的时候，此时谣言会大肆扩张来满足新闻无法满足的需求（Shibutani， 1966：17）。卡普费雷直截了当地指出：“谣言不是从真相中起飞的，而是要出发去寻求真相。”\[1\]这种寻求发生在权威的或官方的渠道之外，毋需对消息的正式证实，因而谣言很容易离经叛道。人们一般向当局或是媒介吁请真相，把证实的责任交付给它们，但谣言却打击了这一过程。这就是政府当局为何常常会控制或否认谣言，因为他们担心谣言会引发公众的动荡、恐慌或是不满。

再来看第二种情形。谣言活跃于特定的情景中，反过来又为该情景注入动力。这些情景往往与不确定、紧张和危机有关。猜忌、恐惧、仇恨、痛苦会因当下的冲突而进入集体讨论，并塑造和改变冲突本身。在这种情形下，“谣言和闲话是搜集他人信息的重要工具，从中发展出一种公议，这种公议是关于谁应为死亡、疾病、不幸、偷窃、‘不正常’的天气承担责任。这种过程是渐进的，直到它们通过某种事件和人们的解释催化之后显现出来。”（斯特拉森和斯图瓦德，2005：97－98）

此一过程中，谣言导致了人们交流中的不确定性，并与产生误解和冲突的可能性交织在一起。谣言在这些情景中试图让步于社会条件，或与社会条件协商。在极端情况下，谣言会产生社会和政治暴力，例如，用言说将人定位于特定的社会价值体系中，给某些人或某些群体贴标签，对被贴上标签的行为进行道德评判，寻找特定的替罪羊，甚而形成一种争取公众支持并用暴力惩罚肇事者的机制。“通过谣言，就像通过其他社会交流方式一样，冲突与延续共存，加强了生命中持续的斗争原则。”（斯特拉森和斯图瓦德，2005：102）

以上可以一般地解释谣言为什么会在动荡时期泛滥成灾——混乱产生谣言，谣言导致更大的混乱，差不多构成了一个“社会心理学的规律”，用奥尔波特和波斯特曼的话来说就是：“从未有一场骚乱的发生不带有谣言的鼓动、伴随和对暴力程度的激化。”（Allport & Postman， 1947：193）例如，在法国大革命中，中外研究者都指出谣言与革命相伴相生的状况，而对中国的辛亥革命，甚至有学者极而言之地称“武昌起义，在某种程度上就是被谣言激发的一场兵变”。

这些分析很容易把非理性因素同大革命的群众现象关联起来，即认为情绪、感情、信仰等非理性因素在很大程度上支配了人们的政治行为，这不仅使大革命的进程扑朔迷离、一波三折，也为谣言赋予一种独特的活力。然而，革命和骚乱只是社会运动的一种形式，除了大众的非理性造成局势失控的情形，还有一种社会运动是理性人的联合行动。这些行动有一定的策略，因为行动者缺少财力和权力，不得不调动另类的资源以对政治和分配进程产生影响。这些另类资源包括如下的集体行动：罢工，静坐，占领，示威，怠工，阻塞交通等。

由此进入第三种情形。詹姆斯·斯科特在观察抵抗的政治时敏锐地意识到，在沉寂不动和激烈反抗之间还存在着一个广大的中间区域，在这个区域中，“事物的限度常常被测试……上次事端的尘埃尚未散去，尝试收复失地的探寻可能就又开始了”（Scott， 1990：197）。谣言正是中间地带的抵抗中一种有力的手段，谣言武器在现代反抗者手中不像过往的革命者使用得那样强悍，但它又比斯科特曾经观察到的作为“弱者的武器”而发挥的功能更为强大（Scott， 1985）。

了解了谣言作为一种社会抗议的功用，我们才能深切地明白，何以卡普费雷对谣言的定义特别强调“官方的公开证实”或“官方的辟谣”。这是因为，

“谣言既是社会现象，也是政治现象。……‘官方’来源的概念就是政治性的，它取决于一种共识，这种共识阐明了谁拥有法律上的发言权，即便其缺乏道德上的发言权。谣言是与当局的一种关系：它揭露秘密，提出假设，迫使当局开口说话，同时，又对当局作为唯一权威性消息来源的地位提出异议。谣言在无人邀请的情况下自发地争夺发言的权力。它经常是反对派的发言：官方的辟谣并不能说服它，因为它感觉官方与可靠性并不是相辅而行的。谣言令我们质疑当局，对‘谁有权对什么事发言’提出质疑。谣言提供的信息与官方信息有时是相左的，所以，谣言构成了一种反权力，即对权力的某种制衡。”（Kapferer， 1990：14）

作为“反权力”的谣言，反抗的是经济上的剥削，政治上的压迫，以及社会关系上的不平等。

### 5 被“妖魔化”的谣言

从以上所述我们可以看到，需要对谣言的定义的细微之处加以仔细的辨别，方能全面认识谣言这一人类社会挥之不去的现象。但在中国的语境中，谣言却几乎一边倒地被视为没有事实根据的惑众之言，听信谣言者是受“蒙蔽”的、“不明真相”的群众，而谣言的初始传播者常常被指为“别有用心的一小撮”。官方一向视谣言为不稳定因素而大加制止和弹压，在很多时候，公民因为传谣信谣而而遭受训话、监视甚至拘捕。

不能不说，在谣言问题上学术视野的逼仄是造成和助长这种局面的原因之一。周裕琼统计说，中国内地从上世纪八十年代开始发表的近百篇相关论文，无不对谣言持否定态度（周裕琼，2008）。同一时间出版的传播学与舆论学著作，其中涉及谣言的内容也对其多给予负面的评价，甚至认为谣言就是谎言。例如，刘建明认为谎言是没有事实根据的假话，谣言也是缺乏事实根据的虚假消息，谣言和谎言都是虚的，它们的共同特点是都把假的说成真的，以假充真，以假乱真，以欺骗他人（刘建明，2001）。郭庆光认为流言是一种信源不明、无法得到确认的消息或言论，有自发产生的，有人为制造的，但大多与一定的事实背景相联系；而谣言则是有意凭空捏造的消息或信息（郭庆光，1999：99）。

姑且不论对流言与谎言的这种区别是否准确，我们看到，郭庆光在国内流传最广的传播学教材之一当中在给谣言下定义的时候，引入了一个更加富有争议的参数，即“动机”因素。除了传播学，谣言研究亦是社会心理学的基本内容之一，邓文初曾以两部影响极大的教科书为例，指出国内学者始终强调“动机”（特定意图）与“真实”（缺乏事实根据）两个因素。

由沙莲香主编的《社会心理学》是教育部“普通高等教育‘十一五’国家级规划教材”，其中对谣言进行如下界定：“谣言是某些人或团体、组织、国家，根据特定的动机和意愿，散布的一种内容没有得到确认的，缺乏基本事实根据的，通过自然发生的，在非组织的连锁性传播通路中所流传的信息。”（沙莲香，2006：283－284）

周晓虹主编的《社会心理学》是“普通高等学校社会学专业主干课系列教材”之一，其定义说：“根据传言制造者的动机不同，传言可以细分为流言和谣言，前者在很大程度上属于无意识传播，后者则是有目的地捏造，一般怀有恶意，为的是造谣生事。”（周晓虹，2008：236）

在这里，“动机”二字都直接进入了谣言的定义中，周的定义甚至还突出了“恶意”的目的。邓文初指出：“在这种溢出学术界之外的‘研究’中，以‘真实性’为标准，‘谣言’成了‘没有任何事实根据’的消息。依据‘动机’标准，谣言就不仅仅是‘有意捏造’而且成了‘毁谤中伤’。谣言定定义过程中的情感色彩进一步强化，学术的中性完全丧失，‘谣言’被完全‘妖魔化’了。”\[1\]

“动机论”在中国的传统文化中源远流长。由春秋曲笔生出的“诛心之论”，就是在批评对方之时，不针对对方的行为、语言谈问题，而是绕过行为、语言去指责对方此行为、语言的目的和动机。这种重动机判断（其后紧跟的是价值判断、道德判断）的思维方式长期成为桎梏言论自由和理性讨论的障碍。尤其在极左时期，“动机论”曾经是一根万能的棍子。把“动机论”应用在谣言上，极其容易将谣言涂抹上伦理色彩，视同捏造、挑拨、诽谤、诬蔑，进而产生一系列可见的恶果：

一是当权者常以此为标签，“妖魔化”反抗和持不同意见的群体，化解和打击对方的舆论攻势，抹杀抗争和质疑的正当性。

例如，2007年，在厦门市民对PX化工项目进行抵制时，政府控制的《厦门日报》、《厦门晚报》接连发表文章，称在市民中群发的手机短信所散布的有关PX危害的内容为“谣言”，\[2\]并把市民因在正常渠道无法获知与公共利益密切相关的信息而私下互相流通的传闻鄙视为“‘路透社’消息”，指责它们后面“有双无形的、肮脏的手在操纵”，“谣言制造者和传播者或蛊惑人心，或煽风点火，或惟恐天下不乱，总有着其不可告人的目的。”\[3\]

在这方面，官方已经形成了一整套“义正辞严”的话语，被一位知名博客讽刺性地总结为“情绪都是煽动的，真相都是不明的，群众都是一小撮的”。\[4\]2008年6月28日，贵州瓮安县城发生一起严重的群体性事件，新华网于6月29日发出的电讯即称，按照当地警方的说法，事件缘起于一名女学生溺水死亡，其亲属对瓮安县公安局作出的死因鉴定结果不满，“在县政府有关负责人接待过程中，一些人煽动不明真相的群众冲击县公安局、县政府和县委大楼”，其中，极少数别有用心的人的“煽动”被认为是事件的起因，群众的“不明真相”则是导致事态扩大的原因之一。\[5\]

这些词语和句式已被官方沿用多年，凡是出现社会运动就必然有“一小撮别有用心的人”、“不明真相的群众”和“不可告人的目的”。它们成为执政者处理公共危机时必不可少的话语策略，不是没有理由的。对于国家层面的执政者而言，这里关系到政权的合法性这一致命的问题。现存政治哲学的基础在于设定了一种能够代表人民根本利益的群体，在此基础上产生的政府也就顺理成章地具有了先验的正当性。然而，在实践中，这套正当性推理日益瓦解。政府既难以推行一个为广大民众所接受的国家赖以建立其合法性的价值观，又由于现存国家权力的合法性基础仍然是绩效型的而非法律－选举型的，难以确立国家镇压的合法性，只有使用一套“冷战”的话语策略才能勉强维系自身统治的合法性。在这套话语策略之下，任何对于政府的抗议，都会被用一种敌对的思维作出解读。

对于地方层面的执政者来说，这套话语则是官员追求利益最大化的一种必然结果。最近若干年里，中央实行重大责任事故负责制，一旦出现公共事故，当地领导人就很可能被撤职。其结果一方面促进当地领导人去防止公共事故的发生，但另一方面也促使他们在发生公共事故时，第一反应就是如何封锁事故的传播，争取时间和空间去自己处理、自我消化。在地方政府不需向民众负责、而是向上级负责的政治传统下，官员被激励去选择封锁消息。民间将此称做“惟上不惟下，瞒外不瞒内”。一旦瞒不住了，内部无法消化了，地方政府就会转而把社会运动说成是有计划、有组织的行动，甚至具有“反党反政府”的性质，这样政治上的“上纲上线”在构陷群众的同时，可以把上级党委、政府也绑架进来，从而掩盖地方吏治的极度恶化和自身的严重失职。

二是动辄动用法律手段，对一些有一定事实依据、但又不甚准确的说法，以谣言视之，强力打压，导致在重大社会和安全事件中，中国公民的言论具有极大的法律风险。

中国《刑法》第105条第2款、第181条、第221条、第291条第1款，分别对以造谣等方式煽动颠覆国家政权、编造并且传播影响证券交易的虚假信息、捏造并散布损害他人商业信誉和商品声誉的虚伪事实、编造和明知编造而故意传播恐怖信息等等行为作出有罪规定；《治安管理处罚法》第25条第1项规定，“散布谣言，谎报险情、疫情、警情或者以其他方法故意扰乱公共秩序的”，要承担罚款、拘留等行政责任。

就谣言在新媒体当中的发布和传播，2000年9月25日公布的《中华人民共和国电信条例》规定，任何组织或者个人不得利用电信网络制作、复制、发布、传播“散布谣言、扰乱社会秩序、破坏社会稳定”的信息；2000年12月28日全国人大常委会《关于维护互联网安全的决定》称，对于“利用互联网造谣、诽谤或者发表、传播其他有害信息，煽动颠覆国家政权、推翻社会主义制度，或者煽动分裂国家、破坏祖国统一”、“利用互联网编造并传播影响证券、期货交易或者其他扰乱金融秩序的虚假信息”、“利用互联网侮辱他人或者捏造事实诽谤他人”等行为，将依照刑法的有关规定，追究刑事责任；国务院新闻办公室、信息产业部2005年9月25日联合发布的《互联网新闻信息服务管理规定》要求互联网新闻信息服务中不得含有“散布谣言，扰乱社会秩序，破坏社会稳定”的内容。

这些条款，由于缺乏具体的判断标准而显得含糊不清。例如，要进行行政处罚，必须有“扰乱公共秩序”的后果，但怎样才算“扰乱了公共秩序”，始终是相关案件中的一个颇有争议的话题。而且，法律将散布谣言和谎报险情、疫情、警情等相并列，并涉及“故意”这样的主观因素，由此产生了一个问题：对于个人来说，如果他或她并非出于“故意”而发布或者传播了一些与事实并不完全相符的信息，是不是要承担相应的法律责任？

从2006年的“张志坚事件”，\[i\]到2007年的“红钻帝国”，\[ii\]再到2008年的“SS山地师”，\[iii\]各地接连出现因在网上“转载”或“跟帖”，当事网友被公检法机构逮捕或拘留的案例。另外一种情形是因短信而获罪，例如，2007年1月，北京警方称，发“病猪肉”谣言短信可判5年以上徒刑；\[iv\]太湖蓝藻污染期间，无锡市民丁某向130余人散发“太湖水致癌物超标200倍”的手机短信，被无锡警方处以治安拘留。

根据法律规定仔细辨别这些案例，不难发现，政府存在明显的滥用法律行为。首先，政府倾向于把凡是与事实不完全符合的传言都定性成法律意义上的谣言。“SS山地师”在转发帖子时，相关部门正在调查处理，信息庞杂，虽转贴伤亡人数有误，但仍可证明事故造成重大伤亡。事实上，在大的灾害事故发生后的较短时间内，即便政府也往往没有能力马上判断言论的真假。当局严重混淆散布谣言扰乱公共秩序与出于自身安全考虑传播小道消息的区别，后者根本不属于违法行为。在重大灾难之后，许多人都曾传播不知真假的小道消息，提醒亲友注意安全，从现行的法律体系来看，他们中几乎每一个都可能被抓起来。

其次，谣言是否“故意扰乱公共秩序”或足以“严重扰乱社会秩序”，而不是所散布的信息的真假，才应该是处理谣言案件的出发点。“红钻帝国”和“SS山地师”的帖子是转载和引述，虽然态度激烈，但是否构成“扰乱公共秩序”，则需要视帖子的影响面以及造成的客观结果而定，比如，帖子的传播范围有多广，是否激发了公众的心理恐慌，影响到正常的生产、工作、教学、生活秩序等。

特别需要强调的是，公众有权质疑、批驳任何报道乃至政府公告的真实性，公民发短信或者转发相关帖子，即使有不实之处，也应被视作自保或者行使监督权，政府部门只能用更加公开透明的信息来平息大家的忧虑，消除不实之言。一场灾难过后，人们尚未获知政府部门关于预警系统、抗灾能力和救援措施的检讨，却先发现普通市民因为参与灾难后果的讨论而被警方拘留，这不能不使网络民意的焦点集中在权力是否滥用、言论是否自由等问题上。

杨支柱指出：“基于保护言论自由的需要，判断一种言论是否扰乱公共秩序，应该采用‘明显而紧迫的危险’标准；因为允许政府因不明显的危险阻止或惩罚言论，将使言论者发表任何言论都胆战心惊，而非紧迫的危险是政府有时间采取措施避免的。”（杨支柱，2007）之所以要对媒体在灾难和事故方面的报道以及公民的关注采取宽容态度，非常重要的一个理由是这样可以及时避免更大的危害、抢救更多的生命，与之相比，“可能的恐慌混乱仍然属于较小的恶，是不得已的容忍”（顾肃，2006）。从补救措施上看，对于言论者可能产生的偏向，政府通过公布真相进行解释说明、揭露言论者散布虚假信息的行为就能消除影响，并不应因批评采用虚构方式就予以强力打击。

一方面，公权机关常常以扰乱公共秩序为由拘捕公民，另一方面，值得注意的是，在一些谣言案件中，诽谤罪成了公权打击私权的武器。2008年7月，在上海闸北袭警案发生后不久，网上就流传，犯罪嫌疑人杨佳因遭民警殴打导致丧失生育能力才伺机报复。7月14日，上海市检察院第二分院对编造、散布谣言的郏啸寅以涉嫌诽谤罪批准逮捕。检察机关称，郏啸寅于7月2日下午编造了题为《上海袭警事件内幕》的文章，虚构杨佳因被闸北公安分局民警打伤生殖器、丧失生育能力而萌生报复袭警等内容，在网上多次发布、张贴，并被其他网站大量转载。检察机关认为，郏啸寅利用互联网捏造事实严重损害了执法民警的名誉和公安机关的形象，其行为已触犯《刑法》第246条，涉嫌诽谤罪。

《刑法》第246条的规定是，“以暴力或者其他方法公然侮辱他人或者捏造事实诽谤他人，情节严重的，处三年以下有期徒刑、拘役、管制或者剥夺政治权利。”必须注意的是，此条规定放在刑法第四章“侵犯公民人身权利、民主权利罪”当中。也就是说，诽谤罪，是指故意捏造并散布虚构的事实，贬损他人人格，破坏他人名誉，情节严重的行为。这一犯罪侵犯的对象，必须是公民而不是企业、国家机关或者其他组织的名誉。不可否认，郏的造谣对上海警方和办案民警的形象造成了一定的负面影响，但并不一定就是应该动用国家强制力处罚的违法或犯罪行为。如果把对于公职人员的公权行为的评判以诽谤罪入刑，其结果必然是，任何人都不敢对公权实施监督，公民言论自由的崇高价值也无法得到保障。

言论自由天然包含了说错话的自由，尤其是质疑权力的自由。这就要求公共官员面对批评甚至夸大事实的捏造时，不能动辄以诽谤为由主张名誉权和隐私权，更不能以国家暴力机器来满足个人的私利。而一个又一个因发送短信、网络发帖获罪的案件，却多次显示一些地方长官借助手中掌握的公共权力资源，习惯性地把一切未经官方认可的信息当作谣言来打击，甚至不惜顶着挟私报复的恶名钳制言论，由此制造了一个人人自危的社会和舆论环境。

### 6 谣言与大众媒体的对立

2008年5月12日，北京召开会议全面部署抗震救灾工作，在会议要求中，“加强正面舆论引导”和“依法处理”谣言是在同一个句子中出现的，这也是官方长期一贯的做法。由于政府垄断着媒体资源，“加强正面舆论引导”往往是新闻封锁、新闻限制的同义词。毋宁说，正是官方“加强正面舆论引导”的行为，导致了官方信息的匮乏和不可信，才为“谣言”的传播培育了丰厚的土壤。官方一方面给谣言留下传播的空间，另一方面却又声色俱厉地打击谣言，从而令自身陷入一种难以破解的矛盾当中。

自2003年非典以来，突发事件中有关部门对媒体报道压制所造成的巨大损失和危机的扩大，一次又一次地证明着，媒体或者失语、或者成为强势话语的代言人，往往是造成谣言扩散、社会恐慌和危机加剧的主要原因。

2005年11月13日，中国石油吉林石化公司双苯厂发生着火爆炸事故。在发生爆炸的当天，吉林市环保部门就已经发现松花江水体受到污染，后来还递交了相关污染的监测数据。但几天内吉林市委、市政府仍未做统一安排去向公众进行解释与澄清；一周后，吉林省有关部门仍坚称没有听说吉林石化公司发生爆炸污染松花江水源的说法。甚至在下游的哈尔滨市于21日早晨宣布停水时，石化厂和吉林市仍然拒不承认苯流入江水对人和环境造成剧毒性危害。

哈尔滨市政府宣布停水的原因竟然是“对市政供水管网全面检修”。在这关键时刻，官员们采取了鸵鸟政策，拒绝回答媒体和公众的质询，甚至把环保部门的对外报道权也控制起来。居民们既无法从政府部门、也不能从当地媒体报道获得明确、真实和完整的信息，令哈尔滨市陷入了前所未有的恐慌，饮用水、啤酒、牛奶等统统遭遇抢购。小道消息不胫而走，甚至出现地震的流言，事情愈闹愈大，市政府才在十小时后不得不再出公告，解释停水原因是由于日前吉林化工双苯厂爆炸污染了松花江。

在“正确的舆论导向”之下，传统的主流媒体对重大社会政治事件实行选择性报道，选择的标准完全由他们来掌握，他们认为是反面的、消极的、添乱的、抹黑的就按下不表，确定为正面的、积极的、鼓劲的、添彩的就公开宣扬，而区分的根本标准，就是看其是否对抽象的社会稳定构成威胁，丝毫不管是否对民众的知情权造成损害，是否可能给民众的生命财产带来巨大危险。

当正常的社会传播系统功能被削弱，非常态的传播机制就会活跃起来。在松花江水污染事件中，有关“水污染”和“地震”的传闻多是通过口口相传、手机短信、互联网论坛等传播的，而且流传时间比报纸、电视、电台等传统媒体正式发布的时间早得多。人们与其相信报纸、电视等大众媒体的正式新闻报道，更倾向于相信来路不明的谣言，导致“新闻像谣言，谣言像新闻”的怪象出现。在政府的权力控制下，被行政力量扭曲了的传播手段在谣言广泛散布的环境里，最终取得了相反的效果。

观察新媒体事件中的谣言传播，很容易发现一种现象：政府习惯于在谣言四起的时候，四处删帖、封帖，但这样做反而立刻吸引了网上的注意。人们总是倾向于认为，被删被封的有可能是真相，于是就会想方设法搜索被删被封的东西。结果，被封掉的是国家控制下的喉舌，人们传播的反而是“别有用心者”的谣言。这样的事情一再重演，导致公共行政部门本身失信于民，危及其执政权威。

谣言与政府和政府控制下的大众媒体的对立，反映了一种严峻的社会现实：民众表达自己声音的正常渠道近乎完全被封闭。所谓谣言，最近几年似乎在成为一个越来越敏感的问题，这种敏感性往往与屡屡爆发的突发性事件和群体性事件相联系，而这些事件的产生，则非常多地是因为民众无法通过正常渠道解决利益攸关的重大问题。

在厦门反PX游行之前，各种正常渠道的上访、专家咨询会、全国政协会议提案等手段都未能有效地促成PX项目的公开、科学和全面的论证。为什么在游行前体制内的解决手段失效？现有地方政治权力过于集中是最重要的原因。舆论、司法、人民代表大会等正常渠道，在这种集权的情况下，要么工具化而沦为行政权力的附庸，完全服务于行政意图；要么干脆处于沉睡状态。当正常渠道不正常的时候，一旦发生矛盾和冲突，绕过正常渠道就成了民众自然的选择；谣言就是这种“绕道”的体现之一。而谣言之所以令官方感觉如此不舒服，正是因为权力无法完全控制这种渠道。

在信息制造、传播链上居于劣势的弱势群体，如果完全拒绝传闻类信息，他们又该从何处获知他们的处境、了解他们的？益所在，用什么方式宣泄他们的情绪、宣示他们的诉求呢？政府因知情而说谎，民众因不知情而造谣。在此意义上，谣言不仅仅是替代性的，而且是补充性的。

在很长的时间里，人们一直把谣言当做一个代用品：例如，《广州日报》负责人曾经撰文指出，在2003年2月蔓延广东全省的有关非典的传言和谣言，“不仅引发了广东历史上极为罕见的社会恐慌，也引爆了一场党报主流媒体与传言和谣言之间的遭遇战”，而“各种传言和谣言之所以能够通过人际传播的方式兴风作浪，主要是因为缺乏权威资讯引导的结果”（薛晓峰等，2003）。言下之意是说，通过大众媒体与官方对权威信息的发布，就可以中止或减少谣言的散布，有效杜绝危机的发生。

然而，卡普费雷却指出，大众传播媒介和谣言之并存证明了，“谣言是作为补充的传播媒介，传播的是另一种事实”（卡普费雷，1991：274－275）。这是因为，大众媒体总是处于一种自上而下的交流形式，从知情的人传到不知情的人。于是公众获知的是他人想对其灌输的信息。而谣言是小道消息，更近似于个人情绪感受的一种表达，罗斯诺称之为“夹杂了个人对这世界如何运转的主观臆测的公众传播”，表达了试图认知自身生存环境的人们的忧虑和困惑（Rosnow， 484-496）。由此来看，谣言并不完全只与信息有关。它也用来满足人们的心理和社会需求。甚至即便其事实基础被证伪，谣言也仍然会经久不息。

更重要的是，谣言会在沉默的人群中间诞生，会在那些为着自身的利益或是破坏反对者的声音而制造信息的群体中生发出来，作为一种政治传播策略而出现。何时大众传播媒介成为官方消息的唯一提供者，何时就会有谣言现身，提供与官方真实不同的真实。

正因如此，谣言不会是一种一时的、短暂的现象，大众媒介的兴起，也不会消除这种最古老的传播媒介。信息永远存在两个来源：一个是大众媒介所说的，另一个则是个人从他周围最直接的人那里、他的社交圈子里获得的。而后者就是谣言。谣言的扩散经常显示出一种对官方渠道消息的不信任，甚至对政府本身就缺乏信任。在2006年一度闹得沸沸扬扬的“广东高州物管打死考上清华学生”的网络谣言事件中，有网友在跟贴中写道：“大家宁可相信谣言，而不相信你们，因为你们不值得信任”。\[i\]在实行新闻管制的国家，在人们普遍不信任官方信息的情况下，谣言在某些时候甚至成为唯一的媒介。

这意味着，在一个缺乏信息自由的社会里，谣言这种媒介成长得最好。一个政府越是经常掩盖和操纵信息，谣言的力量也就越大。这种不受控制的现象意味着审查制度的无效，它揭开秘密和找到被掩盖的事实，表达被统治者的缄默愿望，给无声者以声音，告诉政府民众和国家之间横亘着一条公信力鸿沟。

谣言无法消除，只能削减。事实上，只存在一种消除谣言的办法，即禁止人民的相互交流。官方存在一种从自身利益出发看来合理的想法：只想让他们认为可靠的消息流传，这种想法在现实操作中，体现为种种“净化”舆论空间的努力，它直接导致新闻控制，进而导致侵害言论自由。2003年非典期间，就有文章称“谣言比瘟疫更可怕”，2008年汶川地震期间，又有文章说“谣言比地震更可怕”。其实，比谣言更加可怕的是对言论自由的剥夺。

既然纳普提出的使公众对所有官方传播媒介和政府无保留地信任的做法在任何实行民主和法治的国家都无法行得通，那么，无论是政府还是官方媒体，都必须修正自己落后的执政和传播理念，才能充分保证社会的健康和可治理。“把谣言和虚假联系在一起的这种消极观念来自工艺程序：只有可控制的信息交流才是好的。谣言却从反面提出另一种价值观：只有不受约束的信息交流才是好的，哪怕其可靠性受到影响。”（卡普费雷，1991：275）

### 7 谣言与新媒体

我们可以把媒介的发展史分成口传媒介时期、文字媒介时期、电子媒介时期、网络媒介时期。文字媒介的代表是报纸，电子媒介的代表是电视，两者共同构成了由中央广播者向外发布信息的大众传播方式。无论是报纸还是电视，都未能使谣言烟消云散。尽管有了大众媒介，人们仍继续以口传媒介的方式获取一部分信息。甚至在21世纪里，尽管交流手段凭借新媒体和新的数据传输技术已变得极其先进，直接的口耳相传仍然在散播信息的过程中发挥着关键作用。

新媒体最为典型的代表是万维网，作为一种不断变幻的对话，它与古老的口传叙事之间存在着更多的类似之处。它不像大众传播媒介那样恒定和固化，而是允许人们在信息流中自我选择，对信息加以改变和回应，并和他人一起创造信息。这种做法和人们曾经在篝火旁、茶馆里、集市上分享故事、新闻和民谣的情形是一样的，分享的过程从来没有两次完全一致。随着听众的不同和讲述故事的氛围的变化，故事会被重塑、变形和调整，而听众从来也不是信息的简单接收者，而是参与性很高的共同创造者。

从传播技术的角度来看，口传媒介和互联网的相似性要高于它们与大众媒介之间的相似性。然而，互联网毕竟是一种发展程度更高的传播媒介。如果将口传媒介视为一种被时间和空间条件严格限制的媒介，那么互联网则是一种借助信息技术完全打破了时间和空间条件限制的媒介。古代的口耳相传需要身体与身体的接近，其传播方式是单点对单点，在以往年代造谣生事能量相对有限；而网络传播把身体从地域之中解放出来，缩短了传播时速，扩大了传播范围，其传播的方式是单点对多点乃至多点对多点，大大改变了信息不对称的情况。网络传播所具有的即时、互动、匿名、缺乏过滤机制和跨国界等特性，使其成为谣言滋生蔓延的温床。

另外一种影响巨大的新媒体是手机短信。尽管中国的互联网普及率不断提高，但手机用户数仍然大大高于网民数量。由于操作简便、随时随地可以使用、接通率高、互动性好，再加上文化习惯上的原因，短信成为极为广泛的手机应用。由于手机短信具有信息转发功能，奥尔波特等人所提出的“信息失真”在谣言通过手机的传播中被减到了最小，大众能够在短期内被统一动员。其次，短信传播效率高，许多短信可以直接在网上群发，使信息的扩散远远超过了传统的口耳相传的范围。第三，手机短信的传播途径沿着扩展了的人际传播网络进行，具有较强的说服性，而且由于发送效率增加，一个信息接受者可能收到多人发出的相同信息，增加了信息的感染性。

经由新媒体的作用，谣言从经典传播模式（人与人之间的流言蜚语）裂变为网络模式，出现了新型的网络谣言。网络谣言往往发端于BBS讨论区、网站留言板、个人博客、即时通信和手机短信，但其起源通常无法查证，大部分谣言的信息来源不明，而网络特有的匿名作用，使得谣言来源不明的特性更加明显，上述的发端地可能也只是网络谣言传播的中继站。当网民和手机用户获知网络谣言后，基于不同的心理动机，除了利用网络媒体传播，也会通过人际传播的方式，将消息转告亲朋好友。如果网络谣言在网络上成为热门的讨论话题，可能成为大众媒体的报道对象，此时，网络谣言便从虚拟世界进入现实世界，成为新闻议题，许多不使用网络的人也可能得知消息，影响的层面更为扩大。由此可知，网络谣言的发展并非单一渠道传播，许多谣言都是多渠道传播。信息的发送方与接受方各自的人际网络产生交集，信息传播的速度爆炸性提高，而网络的快速传播，又反过来助长了谣言，使谣言如滚雪球一样越滚越大。

从近年发生的一些新媒体事件来看，谣言传播有一些明显的特点：

其一，信息来源莫衷一是，缺乏民众公认的“权威发布”。很多事件在发生之后，都会出现两个截然相反的版本，例如，在杨佳袭警案中，上海警方出面否定民间版本，并很快抓获了在网上发布民间版本的苏州男子郏啸寅。过去几年轰动全国的数起因强奸（虐杀）妇女而引发的群体性事件中，民间版本都是无辜少女+强奸致死+官权掩盖，而官方版本都是家人拒绝+不明真相的群众+少数别有用心的人的煽动。无论从事件参与人数、持续时间、冲突剧烈程度、造成的影响看，瓮安事件都构成了这类事件中的“标本性事件”，但在瓮安事件平息之后，“许多人虽已不信网上‘谣传’，但也不愿看官方公布的‘真相’”。

其二，尽管在传递过程中，信息经过传递者和再传递者的添油加醋，可能出现许多不同的版本，但对一些特定群体，在一种相互加强及情绪渲染的谈话情境下，群体成员可能会产生群体思维（groupthink），坚信群体所讨论的内容是真实的，看法是正确的。由于这群人对于需要什么、信仰什么、期望什么都很明确一致，所以经过流传、增益、删减、润饰之后的版本虽然可能？同于原始版本，却非但？会淡化、弱化或歪曲该群体的共同目标和诉求，反而有助于提高该信息的可接受性。例如，当上海警方第一时间在苏州抓获郏啸寅后，曾公开就种种谣言进行驳斥，而这时马上就有人说郏啸寅造谣本身就是谣言。杨佳在一些论坛中继续被追捧为“大侠”、“当代武松”乃至“中国佐罗”。

其三，信息内容在传播过程中的扭曲剧烈而多样，但万变不离其宗，矛头总是指向政府、指向公安部门、指向司法不公和政治腐败。如哈尔滨发生的两起新媒体事件虽然事隔五年，但舆论的指向存在惊人的一致。2003年苏秀文驾驶宝马车撞死农妇事件中，肇事人具有强大官方背景的谣言在民间社会迅速散布，引发极为激烈的网络讨论与道德愤怒，在新浪网上的评论达23万条，突破了开站以来发帖评论之最。搜狐网也有20万条，网易共计18万条。而在2008年10月哈尔滨六警察伤人致死案中，舆论因传言一波三折：最初，当“六警察打死大学生”的报道见诸媒体时，舆论几乎是一边倒地谴责警察，同情“无辜”大学生。随后，当现场视频被公开，尤其是死者林松岭的所谓特殊家庭背景信息——“林父是房地产开发商”、“舅舅是高官”、“已被安排到人事局上班”、“开着奔驰”被传上网络，关于此案的舆情几乎发生了180度逆转，几乎淹没了对现场视频是否被剪辑的质疑，最终汇聚成一个鲜明的标题——“六提辖拳打林衙内”。而等到黑龙江省政府新闻办召开发布会，哈尔滨市公安局官员称网上传言不属实、死者林松岭家没有高官背景，社会心理再次向死者倾斜，要求严惩涉案警察的呼声又渐次高涨起来。可以说，在多起新媒体事件中，“权势人物与老百姓的对立”谣言模式一再复制并引发骚乱，绝非偶然。谣言的散布传播反映出一个重要的群体共识，那就是，公权机关长期的所作所为让公众产生了不安全感，在每一具体事件中，公众下意识地将公权机关的代表看做是为政不仁、滥用权力、惯于隐瞒真相的暴力实施者，而普通百姓则沦为被欺凌、被侮辱、被侵害的弱势者。

其四，在“施暴者/受害者”对立模式中，谣言出现了新内容，即“性”主题的浮现。无论是贵州瓮安的李树芬，还是上海袭警案中的杨佳，谣传中的暴力行为一个是轮奸，一个是被殴打以致失去生育能力。这些谣言可以视作暴露了大众的集体无意识，如邓文初所说，谣言所传达的民众感受已经由“被欺凌”进入到“受侮辱”的层次。“在这种‘受侮辱’的民众‘想象’（姑且就算是想象吧）中，‘官民对立’的权力冲突已经转换为‘善恶对立’的道德冲突，在有的言论中，甚至转化为‘人兽对立’模式——只有畜生才干得出这样的事情！”在这样的绝对道德审判之下，人们对法律失望，对权力仇恨，对正义彻底失去信心。谣言作为社会舆论，其产生、接受与传播过程，也是群体共识的形成过程，当底层社会“被欺凌与受侮辱”的感觉成为一种广泛的共同感受、一种集体记忆的时候，每一次新媒体事件中，谣言都会引发大规模的抗议活动，就丝毫不足为奇了。

### \*原文附注：

\[i\]2006年3月，身为海口一家制药企业工作人员的张志坚，在制药领域的专业网站小木虫网站（http：//emuch.net）和丁香园网站（http：//www.dxy.cn）上转帖了一篇揭露浙江康力元投资集团与国家食品药品监督管理局原局长郑筱萸和原药品注册司司长曹文庄等多名国家药监局工作人员进行“官药勾结”的网文。康力元公司因此向海口警方“报案”，4月26日，海口市公安局以涉嫌损害商业信誉罪为由拘留了张志坚，6月1日，检察院批准将张志坚逮捕。2007年2月6日，检察院以案件事实、证据有变化为由撤诉，并准许取保候审。2007年4月12日，检察院以事实不清、证据不足，警方已撤案为由取消取保候审。2007年7月，在案发近一年三个月之后，被司法机关错误羁押的张志坚获得24000元国家赔偿。7月6日，张志坚转帖网文中的当事人曹文庄被判处死刑，缓期二年执行；7月10日，郑筱萸在北京被执行死刑。

\[ii\]2007年7月18日，济南特大暴雨，水位迅速上升的护城河完全没过银座购物广场的排水出口，这座济南最大最繁华的标志性商场成了一个巨大的蓄水池。数天后，银座发布官方消息，称“由于疏导及时，超市内无一伤亡”。这成了后来在网络上争议最大的话题之一。一个注册名为“红钻帝国”的23岁的女孩在济南舜网（http：//www.e23.cn）回帖参与论坛的济南暴雨讨论，声称听亲友说大水涌入银座广场而死了不少人。济南警方依据《治安管理处罚法》，以“散布谣言”为罪名对其予以治安拘留，认定她的跟帖“内容有明显的唬人噱头，营造了暴雨过后的恐怖气氛，里面有灾害造成多人死亡的虚假信息”。

当地一家媒体报道说：“暴雨可怕，谣言更可怕！”

\[iii\]2008年4月28日，一场近10年来中国铁路行业罕见的列车相撞事故在胶济铁路上发生。当天，21岁的山东高密网民“SS山地师”在百度高密贴吧转发了一条名为《火车相撞特大内幕！》的帖子，被当地公安机关认定为“内容严重歪曲了正规广播电视媒体关于4·28 事件的真实报道”，违反了《治安管理处罚法》第25条，“涉嫌散布虚假信息，扰乱公共秩序”，对其处以治安拘留。警方同时警告网民“不要相信网上的一些虚假信息，更不要散布虚假信息，特别是这种严重扰乱社会公共秩序的虚假信息，一旦发现散布这种信息的人员，公安机关将予以严惩”。“SS山地师”不仅遭到了治安处罚，还被当地电视台以反面事例曝光，以教育观众。

\[iv\]《北京警方：发“病猪肉”谣言短信可判刑5年以上》，《北京日报》2007年1月16日。

[2、纪念福柯逝世35周年丨读《疯癫与文明》](https://mp.weixin.qq.com/s?__biz=MzIzMjE5OTczNQ==&mid=2247484182&idx=1&sn=cde9e52f8c6cbacc943d1374075f5714&scene=21#wechat_redirect)

[3、民主，该如何是好丨读李普曼《舆论》](http://mp.weixin.qq.com/s?__biz=MzIzMjE5OTczNQ==&mid=2247484252&idx=1&sn=353a19403320ed14ea7e2e74cc57ab87&chksm=e899c004dfee4912df3c61d4f795bee984847817101974526d5445d8da506c8ce320c9b7a4cc&scene=21#wechat_redirect)

[4、《弱传播》：](https://mp.weixin.qq.com/s?__biz=MzIzMjE5OTczNQ==&mid=2247484117&idx=1&sn=a1e3b14c53e250a35a1994da0a4839ed&scene=21#wechat_redirect)[舆论世界的哲学？](https://mp.weixin.qq.com/s?__biz=MzIzMjE5OTczNQ==&mid=2247484117&idx=1&sn=a1e3b14c53e250a35a1994da0a4839ed&scene=21#wechat_redirect)

[5、灵韵的消失与革命的可能丨从本雅明《机械复制时代的艺术品》说起](http://mp.weixin.qq.com/s?__biz=MzIzMjE5OTczNQ==&mid=2247484272&idx=1&sn=025954c797647ee110ef0162d7fed729&chksm=e899c028dfee493ed2ad74155a628f5fc98c09a7f73552ebfb5f7a0226fbb2b98a4d8de60b48&scene=21#wechat_redirect)
