---
layout: post
title: 农村与城市化的缓冲阀：中国的社会结构是倒丁字型吗？
categories: Archive
date: 2019-11-20
tags: 社会结构
image_feature: "https://i.loli.net/2019/11/23/Uqep39s18iZIzbu.jpg"
description: 清华大学李强教授认为，当前中国社会结构是一种倒丁字型结构，其中构成倒丁字型结构底下一横的是巨大的农村社会阶层，而构成倒丁字型结构一竖的则更多是城市社会阶层。
---

原文来自「经济观察报书评」：~~[农村与城市化的缓冲阀：中国的社会结构是倒丁字型吗？](http://wechatscope.jmsc.hku.hk:8000/html?fn=gh_e1bb55b2ce3f_2019-11-20_2656647935_oZFKaIe6Gk.y.tar.gz)~~

---

![](https://i.loli.net/2019/11/23/YSiem4WcE5G1Jju.jpg)

> 作者=贺雪峰
> 
> 来源=《大国之基》

清华大学李强教授认为，当前中国社会结构是一种倒丁字型结构，其中构成倒丁字型结构底下一横的是巨大的农村社会阶层，而构成倒丁字型结构一竖的则更多是城市社会阶层。李强认为，倒丁字型结构是罕见的，与金字塔结构相比，倒丁字型所表现的阶层之间的界限更为突出，是直角式的，下层与其他阶层之间几乎完全没有缓冲或过渡，是非此即彼的。造成倒丁字结构的原因是中国的户籍制度。李强认为，倒丁字结构及其必然导致的结构紧张可以用来理解和解释中国社会的种种矛盾及问题。中国社会运行的巨大难题就在于，倒丁字型结构造成社会群体之间需求差异太大，社会交换难以进行，几乎所有的社会问题，都可以从倒丁字结构和结构紧张上得到解释。李强认为，如果想从结构紧张型社会进入宽松型社会，最根本的还是要完成社会结构的转型，即扩大中间阶级数量，改变倒丁字型结构，办法就是改革户籍制度与增加城市容纳力。

![](https://i.loli.net/2019/11/23/Uqep39s18iZIzbu.jpg)

> 《大国之基》
> 
> 贺雪峰/著
> 
> 东方出版社
> 
> 2019年10月


2015 年李强在《北京日报》上发表了《我国正在形成“土字型社会结构”》一文，认为通过全国第六次人口普查资料与第五次人口普查资料的比较，相对于2000 年，2010 年中国社会结构中，“得分值较低的底层群体出现了明显的向上流动的趋势。中间层的某些群体主要是中下群体有所扩大。但是，从总的社会结构图形看，大体上还是属于底层比较大的社会结构特征，基本上可以说还是类似于一种‘倒丁型社会结构’，当然，如果说形状是‘土字型社会结构’也可以”。


概括地说，以上李强关于“倒丁字型社会结构”的研究可以归结为以下几点：

1. 依据统计资料，当前中国社会已经形成了一种倒丁字型社会结构。
2. 形成倒丁字型结构的主因是户籍制度，核心是城乡关系问题。
3. 倒丁字型结构必然造成结构紧张，这样一种结构比金字塔结构还要糟糕。
4. 要缓解中国社会结构紧张状态就应当改变倒丁字型结构，根本办法就是进行户籍制度改革和提高城市容纳力，或者说就是要鼓励农民进城并为进城农民提供正规化的就业保障。

总体来讲，笔者不同意李强对当前中国社会结构的概括，更不同意他关于社会结构紧张原因的分析和解决社会结构紧张的主张。

## 中国不存在倒丁字型社会结构

当前中国社会结构是倒丁字型结构吗? 尤其是，倒丁字型社会结构造成当前中国社会结构的紧张、并因此成为中国各种社会问题的总根源了吗?

按李强的说法，依据五普六普资料，构成倒丁字型结构一横的是巨大的农村社会阶层；而构成倒丁字型结构一竖的则更多的是城市社会阶层。倒丁字型结构反映的是中国城乡分野的现实。换句话说，所谓中国社会的倒丁字型结构，核心就是中国存在一个家庭收入比较低的庞大的农民阶层，且这个农民阶层的地位处在倒丁字型结构最下面的一横中，即最低位置。正是农民阶层这个极为庞大的群体构成了下面长长的一横，才形成了李强所讲倒丁字型结构。而按李强的量表，构成倒丁字型结构下面长长一横的“23 分组占了全部就业者的63.2%，而组成该分组的职业群体基本上是农民，其中从事大田劳动的即中国传统意义上的农民占该分组的91.2%，占全部就业者的58%，另加上5.2% 的其他体力劳动者，共同构成了丁字型社会最下面的一个巨大的群体。该群体反映了中国的一个非常严酷的现实：社会下层比例过大”。

这里要注意，李强的量表是采用特莱曼与艾泽布姆、格拉夫提出的“国际标准职业社会经济地位指数”，是从个人职业角度进行的分类量表。

这里有若干问题需要讨论。

第一，任何一个非现代的农业社会，农业人口都要占到全部人口的大多数，从事大田种植的普通农民都要占到整个社会就业人口中的绝大多数，这些人群就都会成为社会结构底层的长长一横，也就必然形成任何一个前现代社会或未完成城市化社会的倒丁字型结构，中国就不是什么孤例，没有任何特殊，也与户籍制度和城乡分割关系不大。李强说过去没有人讨论倒丁字型社会结构，似乎是说中国社会结构中存在的倒丁字型结构是世界罕见的类型，这样的说法可能就不成立。

第二，按职业来进行统计并形成的量表与当前农民以家庭为单位进行劳动力再生产的现实之间存在着巨大差距，尤其是当前中国几乎所有农民家庭都存在着“以代际分工为基础的半工半耕”家庭模式。即年老父母留村务农，年轻子女进城务工，仍然种植大田作物的农民家庭，他们的子女进城务工经商，从城市获得务工收入，农民家庭在可以保留农业收入的前提下获得城市工商业收入，所以农民家庭收入获得了持续增长。将农民家庭收入分解为个人务农的职业收入与进城务工的职业收入，这样按个人职业进行分类制成的量表就完全反映不出农民阶层的实际情况。这样讨论问题所得出结果也就相当不可靠。

第三，中国农村经过社会主义改造形成了集体土地所有制，分田到户时，以村社集体为单位，农户按人均分土地，并因此形成了全国农村“人均一亩三分、户均不过十亩”的小农家庭经营格局，农户之间的农业收入相差不大。随着城市工商业的发展，到20 世纪90 年代，农村青壮年劳动力大量进城务工，全国统一的劳动力市场形成，进城农民工因此可以获得全国平均劳动工资。农户家庭收入之间的差距往往只与家庭中劳动人口占全部人口的比例有关，劳动人口多，农民家庭收入就高，消费人口多，农民家庭收入就低。总体来讲，农民家庭之间的收入差距不是很大，无论是农业收入还是务工收入都在同一档次，正是因此而形成了倒丁字型结构底下的长长一横。

第四，当前农民家庭的农业收入中有相当大的自给自足成分并未进入统计，比如庭院经济和捞鱼摸虾收入等。农民大都有自己的住房，而且往往都建得很好很宽敞，房前屋后栽有果树种有菜园，这些住房和他们在农村所获得的很多实物消费是没有统计在农民家庭收入中的，但这些却实实在在地支撑着农民的生活品质。正是农村这些现实的生活品质让农民在当前可以自由进入城市务工经商条件下，仍然没有全部进城。既然当前体制上几乎没有对农民进城务工经商的限制了，农民就可以在城乡之间自由选择，即进城可以有更高收入就进城去，留村具有更高品质就仍然留村。当前仍然有6 亿多农村人口留村，其中包括2 亿多农业劳动力，就说明留村仍有收入来源，以及留村仍有大量未被统计出来的有品质的生活条件。留村尤其适合那些在城市缺少就业机会的中老年人，这些中老年人与自家土地结合起来，在机械化条件下，可以相对轻松地从事农业生产，获得农业就业与收入，并从村庄熟人社会中获得各种生产生活支持和实现人生价值。村庄中的自给自足经济极大地提高了农民的生活能力，降低了消费支出，使农民在现金收入相对较少的情况下依然可以过较高水平的生活。这与漂泊在城市居无定所、惶惶不可终日的生活是不可同日而语的。

第五，中国社会主义制度中很重要的一个成果就是当前农村土地集体所有制，所有农户都可以从村社集体无偿分配到宅基地盖住房，可以获得稳定的土地承包经营权。因为土地承包经营权和宅基地使用权都是村社集体所有权派生出来的，不允许买卖，农民免费获得，无偿使用，不能交易，这就为中国农民保留了与土地结合起来的最基本的权利。因为土地是基本生产资源，是进城失败农民的最后退路，是农民的基本保障，所有作为村社集体成员的农民可以免费获得不准交易的土地承包经营权与宅基地使用权，这样就可以防止农民因为种种不测事件而变得一无所有，也就防止了赤贫和流民的出现。

同时，农村广泛存在的自给自足经济也可以有效缓解农民的赤贫状况。

也就是说，当前中国农村，农民可以与土地结合起来，从土地上获得就业与收入，农村自然经济成分又减少了农民现金支出的压力，而村庄熟人社会使生活在村庄中的所有人都有身体和心理上的安全感，这与漂泊在城市居无定所是完全不可同日而语的。

国家政策对农村的支持，包括扶贫与低保制度，又可以为农村贫弱群体应对各种意外事件提供保障。

这样一来，中国农村的农民虽然收入不一定很高，但却可以解决温饱，可以有发展的能力。有条件就进城务工经商，奋力一搏，成功就融入城市，不成功他们还可以退守农村。

因此，当我们进入倒丁字下面长长一横时就可能发现，这个长长一横中的农民阶层是处在国家的保护之下的，即处在不允许城市资本下乡侵占他们的土地与家园的制度安排之下，这一横与倒丁字上面的一竖根本就不在一个结构里，因为不在一个结构里，下面的一横与上面的一竖就不可能形成倒丁字结构，更不可能因为这样一个倒丁字结构带来结构紧张。因此也就谈不上倒丁字社会结构成为中国各种社会问题的总根源。

## 中国社会结构是发展中国家的例外

李强其实也很清楚所谓倒丁字型社会结构中下面一横与上面一竖不在一个结构里，他说：“实际上，中国是有两个社会分层体系，一个是城市社会的分层体系，另一个是农村社会的分层体系。这两个体系几乎是独立运转的，相互之间并不交融，虽然有巨大的农民工群体流动于城市和农村之间，但是，由于与户籍相关的一系列限制，多数农民工最终还是回到农村去，而不是融入到城市社会中来。”

实际上，2005 年李强提出倒丁字结构，中国户籍制度已经有了极大调整，决定农民工能否进城的主要障碍早已不是户籍而是收入，或者说是市场因素。只要农民有了足够的收入，他们就完全可以在城市买房生活。当前城乡二元体制仍然存在，不过，现在的城乡二元体制中，几乎所有限制农民进城的体制机制障碍都已清除或正在清除，而限制城市资本下乡的制度大多仍然保留，比如不允许城市人到农村买农民宅基地。之所以要限制城市资本下乡，是因为土地包括宅基地是农民的最后退路与基本保障，基本保障是不应该进行交易的。基本保障的交易对城市人来讲，也许只是多了一个每年两周到农村看星星的休闲去处，失去了土地的农民却可能在进城失败后无路可走。在这个意义上，当前的城乡二元体制是保护农民的体制。为什么要保护农民? 因为农民是中国最为庞大的弱势群体，他们的基本生产资源与最后退路，国家理应保障。

正是农民有农村这样一个退路，当农民家庭认为进城有更多机会时，他们会选择进城获取收入，而当他们难以在城市体面安居时，他们就退回农村。农民有农村这个退路，就避免了独立运行的农村社会结构与城市社会结构在同一个结构中存在“结构紧张”关系，正是有农村作为退路，进城农民就可以在城市一搏，同时，他们永远也不会失望而选择努力打拼，他们在城市获得的收入也许过不好体面的城市生活，却可以极大地改善他们在农村的生活。即使他们这一代人无法体面融入到城市，但他们仍然可以将融入城市的希望寄托在子女身上。中国进城农民工因此总是不绝望，总是积极进取，总是对自己子女的教育寄予厚望，总是要想方设法在任何一个地方打拼。中国农民工在城市化和现代化进程中所表现出来的主动性和主体性，可谓是举世罕有。

与中国不同的是当前世界上的其他发展中国家，比如拉美国家和印度等，这些国家没有进行过实质性的土地改革，更没有进行过社会主义性质的土地改造，农村土地私有，土地可以交易，地主占有制使土地高度集中，农民进城基本上是不可逆的，即当农民放弃土地进入城市后，无论成功与失败，他们都没有退路，不再能回到之前的农村。这些不可逆的进城农民中，有少数人通过个人努力加之运气很好，可能获得稳定就业和较高收入，从而在城市体面安居下来。大部分进城人口则难以在城市体面安居，却又不再可能返回农村，从而就成为漂泊在城市的流浪人，成为城市贫民窟的一员，成为城市中的赤贫人口。

因此，在一般发展中国家，城市普遍存在规模巨大的贫民窟人口，若对这些国家的城市家庭进行收入统计，则这些发展中国家几乎无例外都有底层长长的一横，而其上也一定会有高高的一竖，这样的倒丁字型收入与社会结构就不是罕见的，而是普遍的、一般的，是几乎所有发展中国家都存在的结构。

正是在印度与拉美的很多发展中国家，或是在广大的亚非拉发展中国家，由于农民进城不可逆，造成城市的贫苦人口，并因此形成城市内的倒丁字型收入结构和社会结构，这样一种在城市内的倒丁字结构就必然导致各种结构性的紧张，其中最典型的表现是，任何经济波动、社会危机都可能通过这个倒丁字结构被放大。广大的亚非拉国家频频发生的政治动荡及严重的社会冲突，与城市中存在的倒丁字结构所起到的放大作用是有密切关系的。

广大的亚非拉发展中国家城市内普遍存在的倒丁字型结构，与这些国家处于世界体系的边缘位置是相关的。作为世界体系中心的欧美日等发达国家有足够能力将自身危机转移到这些边缘国家，并通过不平等的国际规则从国际贸易中获利。发展中国家缺少足够资源来形成一个庞大的中间阶级，进城的大部分农民都无法在城市体面安居，是因为他们难以在城市获得稳定且收入较高的就业。

相对于一般发展中国家，中国是一个例外，具体来说，中国通过城乡二元体制尤其是农村集体土地制度，将一般发展中国家城市内普遍存在的倒丁字结构变成了城乡二元结构，这个城乡二元结构可以保障进城农民工在进城失败后返回农村，因此是一种保护型的城乡二元结构或城乡二元体制。我们一定要知道，农民进城是希望能过上城市中间阶级的生活，是希望能在城市体面安居，而不是落入到城市贫民窟，成为城市中居无定所的漂泊者。若不能在城市体面安居，进城失败的农民就宁愿回到农村生活，虽然这种农村生活不如城市中产阶级的生活，却要远远好于城市贫民窟的生活。

表面上看，中国社会结构中因为存在一个庞大的农民阶层，这个农民阶层处于社会收入与声望的底层，似乎农民阶层构成了中国社会结构底层的长长一横，从而形成了中国社会的倒丁字型结构。实际上，因为中国城乡二元体制对农村和农民的保护，从而使城市与农村成为两个相当不同的社会体系，也就避免了中国社会结构产生结构紧张。反过来，中国社会结构中因为存在着城乡的分离，从农村社会进入城市务工经商的农民就完全不同于一般发展中国家的进城农民，中国农民工进城是对农村生活机会的拓展，他们在城乡之间可进可退。这样一个农民工阶层也就不完全从属于城市社会结构，从而与城市社会结构有相当不同的行为模式与心理认知。

正因如此，中国城乡二元体制有效地避免了一般发展中国家城市内普遍存在的二元结构，也避免了一般发展中国家在城市普遍存在的结构紧张，以及这样一种社会结构紧张所放大的经济社会政治问题，从而使中国社会自改革开放以来保持了世所罕见的政治和社会稳定。这也是在全球化背景下中国可以成为最大赢家的重要原因之一。

## 允许农民进城，不许资本下乡

显然，当前中国并不存在所谓倒丁字型社会结构，也就不存在所谓倒丁字结构比金字塔结构更坏的问题。反过来，当前中国城乡二元体制，一方面农村不对城市资本开放，是中国在全球化背景下面取得巨大发展的重要原因。

这样一种体制之所以可以成功，其实很好理解，就是任何一个发展中国家都不可能为所有进城农民提供在城市体面安居的就业与收入机会。印度城市正规就业机会只有大约10%，这并非印度对劳工就业的保护不力，而是由印度在国际经济结构中所处的位置所决定的。广大的亚非拉发展中国家的情况无一例外。中国同样如此，但是中国的优势在于，通过保障进城农民在农村的退路而缓解了城市在保护农民工权利方面的压力。如果一方面不能为进城农民提供在城市体面安居的就业与收入条件，一方面又不能让进城失败的农民再返回农村，就必然出现城市倒丁字型结构，就必然导致社会结构紧张，这样一种结构就必然会放大各种危机。

既然城市无力保证所有进城农民体面安居，就要为农民返乡留下退路，返乡就是农民的基本人权和最后保障，这个基本人权和最后保障不能交易，即不允许城市资本通过市场化手段占为己有。为农民保留退路，并非一定要强迫进城农民返乡。一方面有相当一部分农民通过自己打拼具有了进城安居的能力，这部分农民就体面进城了。另一方面，有些农民即使无法在城市体面安居，也不愿回到农村。他们有自己的选择自由，当前保障农民返乡权利的城乡二元体制，是为农民提供返乡退路的体制性机会。而正是进城失败的农民可以返乡，才为那些即使无法在城市体面安居也不愿返乡的进城农民留下相对较多的城市获利机会。

将农民最后退路和保障的返乡权利强制性留给农民，不向城市开放，不向市场开放，不允许农民失去返乡权，这是中国作为发展中国家得以成功避免一般发展中国家存在诸种问题的最大经验之一。基本保障不允许交易，要靠国家力量来保证，这本来是一个常识，却常易被忽视。

## 中国社会阶层及其流变

在当前全球化的体系下，发展中国家不可能为所有进城农民提供在城市体面安居的能力，这是由发展中国家的经济发展阶段和在世界经济体系中的结构性位置决定的。正因如此，进城农民能否在进城失败后保持其返回农村的权利就变得十分重要。当前一般发展中国家，因为缺乏对农民土地权利的保护，在城市化背景下，以城市资本为代表的各种力量很快就鲸吞蚕食了农民在农村的土地，农民失去了返回农村的可能。从而造成了进城失败农民无可选择地落入城市贫民窟的悲剧。

中国城乡二元体制通过对农民返乡权的保障，甚至通过大规模财政投入来保障农民在农村的基本生产生活秩序，保证了农村以家庭经营为基础的一定的生活品质。农村生活本身并非倒丁字结构底下的一横，相反，农村生活品质虽然低于城市体面安居的生活品质，却要远远高于城市贫民窟的生活品质。

从进城农民的角度来看，在当前发展阶段，进城农民无非有两种结果：一种结果是进城并在城市体面安居，随着中国经济的继续发展，会有越来越多进城农民可以在城市体面安居。另一种结果是进城失败难以在城市体面安居，当前发展阶段，中国仍会有相当部分农民进城失败而难以在城市体面安居。难以在城市体面安居的进城农民，他们面临着是继续留城还是返乡的选择。返乡的生活品质越高，就有越多进城失败农民选择返乡，返乡生活品质越低，就有越多进城失败农民继续留城耗着。越多进城失败的人不愿返乡，农村留给返乡农民的机会就越多，返乡农民越多，留城耗着的农民就更有可能得到国家政策性支持。这样一来，在农民体面进城和进城失败之间还有一个广阔的可选项，即农民体面乡村生活的选项。农村生活并非最坏的，农村收入比较低，但消费也比较少。农业生产季节性强，每年农忙也就两个月时间，剩余时间就可以打打麻将、跳跳广场舞。尤其对于缺少城市就业机会的中老年农民，只要与土地结合起来，就比在城市混吃等死要有意义得多。因此，可以与土地结合起来的在村庄生活的农民群体，他们的状况就不再是倒丁字型社会结构最底层的长长一横，而成为介于有体面城市生活能力的城市上层阶层和难以在城市体面生活的城市底层之间的中间阶层（中下收入阶层）。因为进城失败农民可以选择返乡，所以中国在城市难以体面生活的城市底层就必定只有一个很小的规模，而城市体面生活的群体随着中国经济的不断成长而不断扩大。这个城市体面生活的群体也可以分为一个相对较小的高收入层和一个相对较大的中低收入层。在当前阶段，中国社会结构就因为底层比较小，以城市中低收入阶层与农村中间层为主的中间阶层相对庞大，城市上层也注定比较小，从而形成一种纺锤型结构。

这样一来，整个中国社会就可以分为可以相互交流的、达到了一定程度均衡的四大阶层，即城市高收入的上层，城市中低收入的中间阶层，农村中间阶层，以及城市低收入的底层。正是通过农民进城和返乡的调节，四大阶层尤其是后三个阶层之间保持了动态平衡。

中国的城市化和快速发展对中国社会结构的改变，是越来越多农村中间阶层向城市中低收入群体转变，从而将当前分化在两个不同结构中的中间收入群体通过结构性转移，最终聚合到一个结构里面来。只有当中国完成了现代化，由一个发展中国家变成发达国家以后，农村中间阶层才可能完成向城市中间阶层的转换，中国社会结构才可以统合到一个结构里面，从而形成与当前一般发达国家类似中等收入群体最大的纺锤型社会结构。由于大量农村人口已经转移进城，国家财政也有能力对城市少数下层群体进行一定程度的社会保障与救助，就使得之前用于保护庞大农民群体、限制城市资本下乡的城乡二元体制变得不那么重要，中国城乡也就有了一体化的条件。

## 农村的意义

在限制城市资本下乡和国家进行建设的条件下，农村成为中国城市化中的一个重要的缓冲空间，也就是我所说的，“农村是中国现代化的稳定器与蓄水池”。也许，全世界发展中国家的城市都有同样的故事：制度、市场等等。中国的独特之处恰在于在讲城市发展的市场故事的同时，又讲好了农村保障这样一个非市场的故事。

李强关于中国倒丁字型社会结构的讨论，最大不足在于不理解当前中国社会结构的性质，不理解中国社会结构内部的机制，从而将表面上的中国职业分层量表化形成的图式直接套用在了中国社会结构，并因此提出了错误的政策主张：通过改革户籍制度和提高城市容纳力吸引更多农民进城。而忘记了，没有经济的持续发展，城市就不可能具有使所有进城农民在城市体面安居的容纳能力。仅仅是改革户籍制度，通过强制性的城市社会保障制度改革，来让进城农民具有在城市体面生活下去的机会。这是倒果为因，缘木求鱼，也就是注定不可能成功的。

---

<center>经济观察报书评<br>eeobook<br>阅读有难度的文章，每天成长一点点<br>合作及投稿邮箱：eeobook@sina.com</center>

![](https://i.loli.net/2019/11/23/36TFQRoKiJtHdah.jpg)

欢迎来到纸城！文艺是深刻生活的开始。在这里，我们不提供鲜明的观点和立场，只有鲜活的感受和思考。我们试图通过阅读关注个人和世界，以及二者之间的作用和关系。我们试图在各种对于文艺的滥用和偏见中，重塑文艺的气质。我们诞生于当代，但不拘泥于当代。我们相信：What you read empowers you.

![](https://i.loli.net/2019/11/23/VkJe7Yo3lcMxRzS.jpg)
