---

layout: post

title: 【转载】穷人心理学：社会不平等如何影响你的人生

categories: Archive

date: 2019-11-16

tags: 社会不平等

description: "有时候，我们感觉贫困像是一个强有力的磁场或者黑洞，一旦掉入贫困的陷阱，我们便很难摆脱贫困？这是个人的特质造成的，还是环境、制度或结构使然？"

---

原文来自微信公众号「孙立平社会观察」，作者熊易寒：~~[穷人心理学：社会不平等如何影响你的人生](http://206.189.252.32:8081/gh_582a6f5f933e_2019-11-12_2247487659_yGLDIE0V6t.y.tar.gz.html)~~

---

来源 \| 比较（ID：comparative-studies）

不管一个社会的GDP总量如何之大，只要有一部分民众仍然衣食无着、低人一等，这个社会在本质上还是贫困的，只不过有一部分人先富起来而已；不管一个社会的文化产业多么发达，高等教育如何普及，只要大多数富人过着醉生梦死、为富不仁的生活，那么，这个社会的道德水准必然是低下的。

前些日子，有朋友转来《断裂的阶梯： 不平等如何影响你的人生》的出版信息，调侃说： “乍一看，还以为这本书是你写的呢！ ”

朋友之所以这么说，是因为我2015年曾经在《中国季刊》(The China Quarterly)发表过一篇论文，论文的正标题也正好是“断裂的阶梯”(The Broken Ladder)。

出于好奇，我便把这本书找来，看看这个与我“心有灵犀”的学者到底讲了些什么？一看还真是欲罢不能，一方面是作者的知识背景与我迥异，我对不平等问题的阅读主要集中在政治学、社会学领域，对经济学的相关研究也偶有涉猎，而作者基思·佩恩(Keith Payne)是一位心理学家，不平等和贫困不仅是一个社会结构问题，也会深刻地影响我们的心智模式和情感体验，这些恰恰也是政治学、社会学、经济学相对忽视的维度；另一方面，佩恩跟我一样，也是出身底层家庭，他的字里行间不仅充满了对底层的同情式理解，也不经意流露出“穷孩子”特有的那种敏感和敏锐——一个从来没有经历过贫困的人，是很难真正理解穷人的思维方式和行为逻辑的。

这就是为什么作者将“食堂阿姨经济学”作为第一章：小学四年级的佩恩因为家贫而选择免费午餐，这一切都是静悄悄的，因为食堂阿姨清楚地知道谁是付费的，谁是免费的；直到有一天换了一个新的食堂阿姨，破天荒地向佩恩收取饭费，而佩恩却身无分文，也不好意思说自己是吃免费午餐的，尴尬的佩恩从此在学校里变得沉默寡言。

### 一、贫困的地心引力

有时候，我们感觉贫困像是一个强有力的磁场或者黑洞，一旦掉入贫困的陷阱，我们便很难摆脱贫困？这是个人的特质造成的，还是环境、制度或结构使然？

一种观点是关注个体的能动性，穷人是懒惰的，没有责任感或者不够聪明；或者穷人有着自己的文化，这种文化不能促进他们拥有诸如努力工作、诚实守信、自力更生等“中产阶级价值观”(第53页)。依据这种观点，必须通过奖励措施驱动底层改善自己的生活。但佩恩提醒我们注意：穷人的行为其实由更为急迫的动因驱使。因此他们会试图用手头最好、最短期的危机管理方式处理这些日常危机(第180页)。

美国社会活动家芭芭拉·艾伦瑞克(Barbara Ehrenreich)的《我在底层的生活》一书可以作为佩恩上述观点的最佳佐证。1998年，芭芭拉伪装成一个只读过三年大学、急需工作糊口的离婚白人妇女，在三个不同类型的城市各工作一个月。她尽量寻找薪水最高的低技能工作，希望薪水足以支付廉价住所的房租。芭芭拉发现，即使身兼两份工作，薪水仍不足以支付房租。毫无疑问，芭芭拉的个人能力和工作积极性并没有因为“卧底”而降低，但即便是这样一个社会精英进入底层社会之后，也会变得举步维艰。

另一种观点认识到收入不平等和遗传劣势等系统性因素的重要性，他们发现：在贫穷成为常态的地方，贫穷很容易代代相传；但他们经常过于低估个人决策在人们命运中扮演的角色，从而陷入一种“宿命论”的悲观论调。虽然贫困是一种结构性的社会问题，但任何结构都不可能脱离行动者而独立存在，否则我们就无法观察到向上的社会流动。

为什么穷人往往是“活在当下”，缺乏长远打算？穷人为什么更容易选择酗酒、吸毒、未成年生子之类的自我毁灭性行为？

佩恩指出，面对不确定的未来，有两种不同的策略，一种是投资未来的“慢战略”；另一种是“快战略”，“快速生活，早早死去”。心理学家杰·贝尔斯基(Jay Belsky)发现：在充满压力或无秩序的艰苦环境中长大的女孩会更早生育小孩。当预期寿命降低的时候，女性的生育年龄也会相应降低。这就是一种典型的“快战略”，在极端不安全的环境中，如果穷人不急于结婚生子，可能就永远没有机会结婚生子了。

穷人未必不知道“长期投资”的重要性，而是因为“等不起”或“等不到”长期投资的回报。一个穷人可能辛辛苦苦通过打工攒了一笔钱，准备用于学习某项技能；然而，他可能遭遇各种各样的厄运，譬如父母亲得重病，自己失去工作，这些因素可能导致他试图改变自身命运的努力前功尽弃。中产阶级以上人群之所以能够进行长期投资，很大程度上是因为他们的抗风险能力远远高于穷人，可以立足长远，静候花开。

经济学家森德尔·穆来纳森(Sendhil Mullainathan)研究资源稀缺状态对人们思维方式的影响，结论是穷人的注意力被稀缺资源过分占据，导致其认知能力和判断力全面下降。穷人之所以穷，不是因为他们不够努力，而是因为长期贫穷，在巨大的经济压力下，他们把全部的注意力集中于如何挣钱，而忽视了更重要、更有价值的目标，造成心理焦虑和资源管理的“失能”。当一个人特别穷的时候，智力和判断力都会显著下降，陷入恶性循环。虽然穷人富人都有可能“利令智昏”，但贫穷会降低“利”的门槛，蝇头小利就可能让穷人失去理智。如果仅仅是简单地把钱分给穷人，穷人的思维模式也会导致其无法有效利用这些金钱，譬如有些贫困户将救济金用于挥霍、赌博，而不是用于购买生产资料或者投资于子女教育。

贫困绝不只是带来“人有我无”的相对剥夺感。贫困还意味着被排斥感，一种无法参与其中的羞耻感，譬如因为没有一双球鞋，你可能无法参与足球比赛；因为缺乏必要的财力，你可能无法参与社群的礼物经济，缺席各种红白喜事，于是成为社群里的边缘人。贫困还意味着丧失对生活的支配感，正所谓“一分钱难倒英雄汉”。

更可怕的是，贫困具有很强的代际传递性。富人家庭的子女可以接受更好的教育，拥有更加健康的身体，更为发达的社会关系网络，从个体的角度看，他们拥有较高的人力资本；从社群的角度看，他们处在一个更加友好互惠的社会位置。反观穷人的子女，他们不仅更有可能辍学，父母的离婚率也更高，甚至可能由未婚妈妈抚养长大，他们更有可能遭遇各种疾病的风险，却缺乏正式或非正式的社会支持。

对于真正的穷人来说，“短视”可能是一种生存策略。短期收益的风险低，而长远投资的回报周期长，不确定性也更高。对于有一定经济基础的人来说，长期投资的风险是可以容忍的；而对于真正的穷人，他们无法承受这种风险，甚至根本无力进行投资。

身处顺境中的人，往往居高临下地看穷人，认为贫穷是个人的禀赋或德性使然；但实际上我们所谓的“成功人士”取得的成就里，也有一部分“身份红利”或“平台溢价”，这部分溢价是我们的收益里超出人力资本(个人能力)回报的那一部分。譬如一位企业家因为进入人大、政协或富豪排行榜，而获得更高的授信额度或更多的商业机会，这就是“身份红利”；一位学者在知识付费平台授课的回报可能百倍、千倍于课堂授课的收入，这就是“平台溢价”。穷人不仅无法获得“身份红利”和“平台溢价”，甚至自身的人力资本回报也经常被打折扣。

### 二、“贫困感”：社会比较的力量

佩恩直言：从一个经济学家的视角出发，贫穷迥异于经济不平等。贫穷与一个人拥有和缺少的东西相关，而不平等则描述了金钱是如何分配的，表明了有产者和无产者之间的距离。然而，从一个心理学家的角度看，贫穷和不平等却是交织在一起的。

社会比较几乎是人类的一种本能。欲望的激发与满足往往与社会比较有关。一旦超越了温饱阶段，欲望与需要的界线就变得模糊。很多时候，不一定是我需要什么东西，而是因为我身边的人拥有这样东西，我就想要占用此物。在很大程度上，贫困是一种相对的状态。在一个相对平等的社会里，由于贫富差距小，对穷人来说，贫穷不是那么难以忍受的，因为大家都是如此；而在一个不那么平等的社会里，穷人会以富人的生活方式作为参照系，即便实际生活水平相比过去提高了，他们仍然会心怀不满。

我父亲经常怀念20世纪70年代末7毛8分钱一斤的猪肉，然而，7毛8分钱的猪肉他一年也吃不了多少次；现在猪肉价格虽然贵了很多，他可以天天吃，吃了还嫌油腻。我父亲并不是在怀念70年代的猪肉，他怀念的是相对平等的社会，即便在那个社会里他非常贫穷。

让贫穷与不平等交织在一起的力量，就是社会比较。一个人之所以感觉自己很贫困，是基于社会比较；而社会比较的过程会让这个人察觉和识别不平等的程度。不平等的程度越高，相当于社会等级的阶梯越长；而“贫困感”的强烈程度，取决于我把自己放置在阶梯的哪一级。阶梯越长，而自认为所处的等级越低，“贫困感”就愈加强烈。

改革开放以来，中国社会的贫困程度大大降低，但是有“贫困感”的人却越来越多，原因正在于中国社会的阶梯变得越来越长了。从1949年到1994年，中国社会实际上是一个扁平社会。之所以称之为扁平社会，是因为这一时期中国的社会分层较为粗疏，社会阶层的类别少，阶层之间差距小。1994年至今，中国社会成为一个“精细分层社会”，阶层划分越来越细致，阶层与阶层之间的界线越来越清晰。精细分层社会的主要特点是：收入和财产差距扩大；阶层之间存在居住隔离与消费区隔；跨阶层的社会流动变得更为困难。社会分层越是精细，就意味着阶梯越长，人们感受到的焦虑和“贫困感”也就更为强烈。

研究者发现，穷人往往更容易相信阴谋论。其实，不是贫穷让他们如此，而是不平等让他们这样。单纯的贫穷并不足以改变人们的思维方式和心智模式，但严重的社会不平等可以办得到：人们需要从“阴谋论”那里得到“确定”的答案。由于生活中面临更多的风险和不确定性，并且在面临外部风险的时候又具有较强的无力感，穷人比富人更渴望得到高度确定的、唯一的解释。相信阴谋论的人，往往在思想上更固化，固执己见，喜欢接受简单明了、非黑即白的信息，排斥模糊性和不确定性，试图用思维定式来应对一切未知状况和信息不对称。

### 三、为什么不平等比贫困更可怕？

佩恩指出，不平等影响着我们的行为方式，而行为上的差别又会扩大不平等(第180页)。人们在美国这种高度不平等的国家做出错误选择的频率，比在加拿大这种不平等程度较低的国家要高。这种导致穷人陷入堕落的恶性循环的力量，同样也是促进富人进入良性循环的力量。如果为了谋求未来更大的回报而牺牲眼前的利益，对于你来说显然是更好的选择，那么你很可能处于一个诚信投资能得到回报的环境之中(第181页)。

相对贫穷和不平等对贫穷循环的推动相比于对有产者和无产者的区分同样重要(第182页)。佩恩发现：一个人对自己所处社会经济地位的主观评价越低，就越有可能做出错误的决策，并在工作中发挥失常；他就有可能相信超自然的力量和阴谋论，面临肥胖、糖尿病和心脏疾病的风险也越大。低收入人群有更高的压力激素水平，其血液中的皮质醇和肾上腺素也更高。反应过度的免疫系统和更高的炎症水平更容易在低收入人群中出现。

经济学家安妮·凯斯和安格斯·迪顿(Anne Case and Angus Deaton，2017)的研究发现，尽管在过去几十年美国等发达国家的死亡率都在稳定下降，然而自20世纪90年代起，美国中年白人的死亡率却上升了。死亡率上升的部分主要集中在没有上过大学的白人男性群体。这个群体受到的伤害很大程度上是自虐造成的。他们死于心脏病和癌症的概率并不高，却往往死于肝硬化、自杀、慢性病以及麻醉剂和止痛药的过度使用。这在很大程度上可以归因于主观上的社会攀比，收入差距扩大和社会阶层流动性固化意味着这一代人很可能是美国历史上第一代财富不及父辈的人(第107页)，相对地位的下降让他们有着强烈的相对剥夺感。

高度不平等与高犯罪率、高压力相关的疾病风险和高度的政治极化相关(第193页)。在严重不平等的社会环境之中，底层为了维持生存，往往不得不从事一些灰色地带的活动甚或轻微的违法活动；更有甚者，在金钱的诱惑下铤而走险。穷人很难做到“延迟满足”，即一种甘愿为更有价值的长远结果而放弃即时满足的抉择取向，以及在等待时展示的自我控制能力，这在很大程度上是由穷人所处的恶劣生存环境决定的。“延迟满足”需要建立在一种长远规划和稳定预期之上，而穷人所处的环境常常是“有今天，没明天”，“今朝有酒今朝醉”。

佩恩指出，必须严肃对待不平等而不仅仅是物质上的贫穷，因为我们无法简单地走出当前面临的困境。不平等在健康、决策制定、政治和社会决策等领域影响深远，要解决不平等问题，光靠经济发展是不够的。要摆脱贫困，一个较好的办法是搬迁到相对富足或平等的社区。撤离贫困社区的家庭中，孩子变成单身父母亲的概率更小，而在学校上学并考上大学的可能性更大，成年后的收入也更高(第192页)。如果不能搬迁到更富裕地区，那么还可以考虑搬迁到一个更平等的地方定居。

然而，社会学家马修·德斯蒙德(Matthew Desmond)在《扫地出门：美国城市的贫穷与暴利》(Evicted：Poverty and Profit in the American City)一书中告诉我们，搬迁到更好的社区绝非易事；事实上，底层的人们能够维持住现有的住房，不被扫地出门就已经很庆幸了。通常情况下，一个人的房租不应该超过其收入的30%，然而德斯蒙德发现，对于低收入人群来说，房租占到了他们收入的70%乃至更高，这不仅让他们的生活难以为继，也意味着容错空间极小，稍有差池，譬如一次不明智的购物(在巨大生计压力下，穷人往往以一次性的挥霍来释放压力)，就可能让租客入不敷出，最后被房东驱逐。驱逐的后果是严重的，可能引发多米诺骨牌效应。例如，为了找到新住处而耽误工作，被老板解雇，生活雪上加霜，更加无力负担房租。更可怕的是，被房东驱逐会成为不良信用记录，未来租房更加困难，甚至租金也更高。

### 四、从断裂的阶梯到合作的阶梯

“断裂的阶梯”是一个形象的比喻，在收入高度不平等的地方，向上流动的可能性更小；不平等也降低了人们的合作意愿，撕裂了组织或社群的团结。

薪酬的高度不平等降低了底层员工的满意度，但也没有提升顶层员工的幸福感(第168页)。经济学家马特·布鲁姆(Matt Bloom)基于对“职业棒球大联盟”球队胜负情况的研究发现，薪酬不平等程度更高的球队比那些收入不平等程度较低的球队表现更差。最主要的原因在于：严重不平等会引起团队的不满，从而削弱团队合作。研究者还发现，主管与小时工之间的薪酬越不平等，小时工生产的产品质量就越低；底层员工会用磨洋工、偷盗产品、提高报废率等方式来回应不平等。

20世纪70年代以来，美国的收入不平等持续增长，美国最富裕的1%人群所占有的社会财富持续增加，2016年占有美国38.6%的财富，而占总人口90%的大众所拥有的财富和收入水平在过去25年里呈下降趋势。2017年美国最大的350家上市公司中，CEO平均加薪17.6%，平均薪酬为1890万美元，而普通员工的工资则停滞不前，同比增长仅为0.3%，CEO的平均收入比普通员工多312倍。而2010年发布的一项研究报告显示，美国人幸福感的拐点是75000美元，一旦年收入超过这个数字，金钱对幸福感的正面作用就开始下降。日益扩大的收入不平等碾碎了普通人的美国梦，却没有相应提高富人的幸福指数，不平等的加剧无疑损害了社会的总福利。

相对平等和社会流动可以在很大程度上修补“断裂的阶梯”。然而，在一个越来越稳定、成型的社会中，社会流动的机会往往呈下降趋势。不仅中国人有“阶层固化”的焦虑，以社会流动为核心特征的“美国梦”也在褪色。帕特南在《我们的孩子》一书中指出：从20世纪70年代开始，美国的阶层分化越来越严重，向上流动的机会越来越少，离婚率和非婚生子女的比例越来越高，单亲家庭的数量持续增长，性别和族群的歧视依然延续，社会不平等正在代际传递。如何在一定程度上“激活”社会流动，特别是让底层迈向中等收入群体的短程社会流动，扩大中产阶层的规模，避免M型社会的出现，是一个日益重要的全球性议题。

最后，我想用这样一段文字做结语：不管一个社会的GDP总量如何之大，只要有一部分民众仍然衣食无着、低人一等，这个社会在本质上还是贫困的，只不过有一部分人先富起来而已；不管一个社会的文化产业多么发达，高等教育如何普及，只要大多数富人过着醉生梦死、为富不仁的生活，那么，这个社会的道德水准必然是低下的。
