---

layout: post

title: “你永远不可能成为中国的朋友”

categories: Archive

date: 2019-10-28

tags: 戈德曼

image_feature: "https://i.loli.net/2019/10/28/DTC8ay9RbS5dfzm.png"

description: "一个聪明、体面的对手如何看待中国。"

---

原文来自微信公众号「观方翻译」：~~[“你永远不可能成为中国的朋友”](https://archive.li/Np2jB#selection-35.1-35.5)~~

---

瑞士《世界周报》10月16日刊登了对美国哲学家、经济学家、数学家、乐评人大卫·保罗·戈德曼的采访。戈德曼是香港英语媒体《亚洲时报》的联合拥有者，时常以“斯宾格勒”为笔名对西方危机大声疾呼（其笔名取自《西方的没落》的作者奥斯瓦尔德·斯宾格勒）。荷兰作家莱昂·德温特认为戈德曼作品有意思的程度排在世界前列。翻译本文的目的一是呈现一个有意思的视角，二是展现一个聪明、体面的对手如何看待中国，**不代表观方翻译同意其立场**。

译：Kris

![](https://i.loli.net/2019/10/28/DTC8ay9RbS5dfzm.png)

**《世界周报》：当前，美国正处于动荡之中。总统可能被弹劾，这是美国历史上第四次发生这样的事。你对此怎么看？**

戈德曼：对特朗普来说，真正的麻烦不在于弹劾，而在于中国和（美国国内的）经济问题。目前看来，特朗普政府跟中国的较量很像是在“自摆乌龙”。

**《世界周报》：****为什么说是“自摆乌龙”？**

戈德曼：因为关税给美国经济造成的影响至少跟它对中国经济的影响一样糟糕。美国的出口订单断崖式锐减。美国当前工业数据处于自2009年6月以来最弱的水平。美联储承认美国制造业正在衰退。美国工厂产量正在萎缩。2016年特朗普之所以能赢，是因为他拿下了宾夕法尼亚、俄亥俄、密歇根和威斯康星等制造业关键州。这次他犯下的错误可能导致他输掉下一届选举。与这种真实的危险相比，弹劾好比一场假面舞会，走走过场而已。虽然中国也蒙受了损失，但似乎损失不如美国惨痛。最关键的差别在于，特朗普需要操心2020年选举，但中国领导人不用。

**《世界周报》：你曾经把中国对美国的挑战比作1258年蒙古人对巴格达的围攻和征服。**

戈德曼：蒙古人靠自己没法突破巴格达十二英尺厚的城墙。但他们雇佣了上千名中国攻城工程师，后者三周之内便突破了城墙，然后蒙古骑兵冲进去进行屠城。

**《世界周报》：那么谁是今天要突破美国要塞的中国攻城工程师呢？**

戈德曼：华为就像是长枪的枪尖，因为在中国经济扩张以及发展成为世界经济强国的过程中，宽带网络是通往其他一切的钥匙。

![](https://i.loli.net/2019/10/28/Dy4uwTn2S9YgFEc.png)

<figcaption>围攻巴格达</figcaption>

华为是一家人才济济的公司。十年前，如果你问别人“你买了什么中国制造的产品？”，对方可能一个品牌都说不出来。但现在每个人都知道华为。他们生产的智能手机是全世界最棒的。他们毫无疑问主导了5G网络。但华为作为一家公司并没有很强的中国属性，反而更具有帝国性。

这个帝国公司比我们更优秀，因为它吸引了许多国家的人才。华为工程师有一半是外国人。他们击垮竞争对手，招纳对方的人才。他们有五万名外籍员工，而外籍员工负责研发工作的比例超乎寻常的高。

我是跟华为打过交道的。曾经有几年我在香港某个中资精品投行工作，当时我跟华为的工作人员有业务往来，帮他们跟外国政府牵线搭桥。华为对自己的目标非常明确。比方说他们会对墨西哥政府说，“你们的全国性宽带网络让我们来建。只要接入宽带，你们就可以开展电子商务和电子金融业务，然后我们可以提供配套的物流和融资方案，让你们融入世界市场。”

中国现在已经成为地球上互联互通程度最高的社会之一。当前，中国是全世界电商渗透率最高的国家，中国的电子支付系统和电子银行比任何其他地方都先进得多。

**《世界周报》：美国国务卿迈克·蓬佩奥今年夏天访问瑞士时接受了我的采访，他发出了强烈的警告：“瑞士应该远离华为。”美国人在欧洲四处传递同样的信号。那么到目前为止，美国阻止欧洲伙伴与华为合作的努力究竟有多成功？**

戈德曼：意第绪语（译注：戈德曼是德系犹太人）里有句话，叫做 *Soll ihr gor nischt helfen*（爱莫能助）。美国围堵华为的战役是一场耻辱的失败，实际上，这恐怕算得上美国有史以来最彻底的政策失败之一。

不久前，美国一名内阁级高官告诉我，在我们还没摸清门道的时候，中国人就已经遥遥领先了，但现在我们开始奋起直追了。他这个说法犯了两个错误。首先，他们仍然没有摸清门道。其次，他们并没有缩小差距。两年前，美国情报界意识到5G不仅将极大助长中国的经济实力——中国经济实力本身就是美国的国家安全关切——而且它还会在未来几年内瓦解美国在信号情报领域的优势。

**《世界周报》：怎么个瓦解，能解释一下吗？**

戈德曼：其实7月份我就在《亚洲时报》的文章里抛出了这个观点。许多其他媒体也就此展开了讨论。中国人在量子通信方面处于领先地位，这门通信技术利用远距离量子纠缠效应来产生通讯信号。量子通信系统有个特点，如果你以任何方式干扰它，通讯信号就会消失，量子态就会被破坏。就好比一封信，当你看到它的时候它就消失了。所以从理论上说，你不可能用技术手段入侵这种通信系统。5G带宽的无比强大之处在于，它可以在普通5G通信中引入量子通信并使其成为标准。

我们了解到，中国人已经在境内利用光缆使用量子通信技术传输敏感数据。若干个大团队正致力于将量子通信嵌入5G网络。韩国的SK 电讯、日本的东芝都在做这方面的努力。据说英国布里斯托大学的一个研究团队也取得了不错的成果。那么结果就是，两三年后美国将失去窃听其他人的能力。

**《世界周报》：尽管美国人反复告诫“不要用华为的5G技术。”但最终西方国家的客户还是需要5G技术的。对欧洲人而言，除了华为之外还有其他的选择吗？**

戈德曼：嗯，目前没有。这就是为什么美国喊破喉咙也没什么用。华为的某位高管曾经对我说：“我们搞不懂美国为什么不让思科去收购爱立信，给我们增加一个竞争对手。”为什么？因为那会拉低思科的股价，在美国，任何降低股价的事我们一概不做。

**《世界周报》：那么政策方面应该怎么做呢？**

答：正确的政策他已经说出来了，就是让思科和爱立信合并，让微软或谷歌参与其中。美国有很多公司可以有效地参与竞争。政府可能需求给它们一些补贴，税收补贴，或者直接对研发进行补贴。你得把各大公司的总裁们都召集到白宫椭圆形办公室，然后对他们说：“你们要实现这一目标，需要我们怎么配合？”我认为欧洲国家应该都更愿意跟美国而不是中国合作，哪怕这意味着5G网络全面铺开需要推迟。但问题是美国人拿不出替代方案，所以欧洲人只能干着急。

**《世界周报》：许多欧洲人的看法是，美国人对德国总理默克尔实施监听，而且根据爱德华·斯诺登的爆料，他们还从全球各地窃取数据。反正给美国人偷去也是被偷，给华为偷去也是被偷，那我们还担心什么呢？**

戈德曼：好吧，哈哈。中央情报局前负责人曾经对我说，问题的关键在于窃取大家数据的究竟是我们还是中国人。在我们和中国人之间，你们难道不是更情愿让我们把数据偷走？

**《世界周报》：大多数人应该会说：“我们不希望任何人侵犯我们的隐私。”**

戈德曼：好吧，不过我觉得这个问题本身已经没什么意义，因为加密技术——特别是量子加密技术——的发展反正都会瓦解美国的监听能力。我认为现在所发生的一切，只不过是美国情报机构的缓兵之计，想拖延5G网络铺开的时间，直到找出应对方案。他们现在只能在困境中挣扎。

要知道，我们每年向情报部门投入800亿美元。这笔钱绝大部分用于信号情报。（信号情报是指外国目标使用电子信号和电子系统所产生的情报，例如通信系统、雷达和武器系统。）而突然之间，美国国安局大大小小的屏幕都要关掉了，他们的权力将大大被削弱。

**《世界周报》：这样一来中国的全球影响力将迅速提升，我们得好好想想，这背后掩藏着中国的什么大战略？**

戈德曼：在过去一千年里的大部分时间，中国都是世界上占主导地位的制造业大国。直到大约200年前西方开始工业革命时，中国的地位才掉下去了。中国人认为这只是暂时的异常现象，他们想重新树立中国的卓越地位。他们认为中国只要在创新和控制世界主要市场方面建立起技术优势，就等于握住了通往繁荣富强的钥匙。

要知道，中国历史上有很多王朝因为饥荒、瘟疫和异族入侵等原因而覆灭。这个国家历史上不算很稳定。现在这些中国人是第一代不需要担心挨饿的中国人。这样一来，中国基本上消除了整个国家体制脆弱性的主要来源。而如今，中国把目光投向外部世界，开始在全球范围内行使权力。电信、物流、电子金融、电子商务以及人工智能等其他技术应用，都是中国扩张的手段。

中国人把每个智能手机都看作一个数据采集器。它将收集关于医疗健康、消费交易、环境交通等方面数据。所有这些数据都可以上传到云中，交给计算机处理，这会在工业控制、卫生系统、环境、城市规划以及社会和政治控制等领域给中国带来巨大的优势。

**《世界周报》：自公元800年以来，中国的边界几乎一直保持不变。我看不出中国人有什么扩张的打算。**

戈德曼：这一点我同意。

**《世界周报》：那么，他们的战略是什么？他们究竟想要什么？**

戈德曼：他们想让所有人向中华帝国交租。他们想控制关键技术、金融和物流，让大家都依赖他们。基本上，就等于把其他人变成佃农。

**《世界周报》：那他们现在进展如何？**

戈德曼：现在还属于很初级的阶段，现在中国想做的基本上就是用自己的转型方式改造其他国家。这不是件容易的事。你会遇到政治障碍、文化障碍。例如，中国在巴基斯坦这样的国家巨额投资，但这里文盲率接近50%，政治高度动荡，基础设施赤字巨大。短期内没人能把巴基斯坦建设成中国。又比方在像巴西这样的国家，中国在考虑建设全国性宽带网络。还有整个东南亚国家——越南、马来西亚、柬埔寨、泰国——它们都可能被改造成中华帝国的经济附属国。如果把印度尼西亚算在里面，东南亚地区就有6亿人口。

**《世界周报》：当中国人的目标实现之后，他们会在政治和意识形态上压迫这些“佃农”吗？**

戈德曼：我认为，中国人对蛮夷如何自治毫不关心，只要他们在经济和技术上都附属于中国。中国人是世界上最不讲意识形态的民族，他们是最务实的。

许多美国朋友跟我说，当下的问题在于邪恶的党压迫着善良的人民。我认为那纯属胡扯。在我看来，中共就是中国古代官吏体制的化身，而中国自公元前三世纪统一以来一直接受这套体制的统治。

拿俄国人做个对比，俄国人开设间谍学校，补贴（境外）地方共产党组织等等做了许多事，中国人对这些东西完全没兴趣。白邦瑞（华盛顿智库哈德逊研究所的中国战略中心主任）等批评人士过于夸大了中共的意识形态野心。但我这样说并不代表中国就不危险，也不代表它对我们不构成挑战。

**《世界周报》：亨利·基辛格是西半球最杰出的中国问题专家。他在《论中国》一书中说，中国人的行为模式就像是一种三维象棋，他们好像管它叫围棋。**

戈德曼：没错。

**《世界周报》：那岂不是说中国人有超级大脑？**

戈德曼：这样说未免太夸张了。中国之所以凝聚成一个国家，全靠官吏体制的雄心。历史上中国疆域内集结了许多民族、许多语言，它们之间差异非常大。中华帝国通过官吏体制从各省招募最聪明的人，使他们的利益与中央政府保持一致，以此维系整个国家。

**《世界周报》：你认为西方对中国最大的误解是什么？**

戈德曼：最大的误解是认为中国有着邪恶的政府和善良的人民。三千年来，中国的政府和人民一直在相互塑造。事实上，西方最接近中国体制的机构是西西里黑手党。它里面得有个 _capo di tutti capi_（头领中的头领），只要有他坐镇小头目们就不会自相残杀。他们自相残杀，因为他们是天然的无政府主义者，不喜欢任何形式的政府。他们忠于家族。所以皇帝是一种必要的恶。民主体制里面最根本的东西是公共信任和个体行事优先（subsidiarity）原则，而中国人对这些概念是完全陌生的。

**《世界周报》：现在已经没有皇帝了，究竟是什么力量把无政府主义者团结在一个国家里？**

戈德曼：上世纪50年代流传下来一个关于美国前总统艾森豪威尔和以色列前总理本-古里安的老笑话：艾森豪威尔对本-古里安说，“给美国2亿老百姓当总统真是太难了。”本-古里安则回答道，“给以色列200万个总理当总理才叫难上难。”

而中国，则是一个由14亿名皇帝组成的国家。每个人都想当皇帝。每个人都努力为自己和家族捞权力。他们不懂什么叫 _Res publica_（公共事务）。他们没有那种奥古斯丁式的共同的爱，所以国家不是靠友爱共同体团结在一起的。使国家团结在一起的是人们的抱负。因此，选贤任能制度务必做到公平公正，这是最重要的。

在中国，不论你是什么达官贵人，只要你孩子高考分数不够，北京大学的门就不会对你敞开。

**《世界周报》：只要中国精英还让子女去美国常春藤盟校念书，西方就还有希望，对吗？**

戈德曼：创新可能是我们唯一比中国人擅长的事。正如我所说，华为公司的创新非常依赖来自西方国家的外籍员工。我不是说中国人不会创新。唐朝被认为是中国艺术和文化的黄金时代，那时候中国人已经掌握了时钟、指南针、火药、印刷术等技术，几乎涵盖了发起工业革命的全部要素。然而，中国的选贤任能机制是以标准化考试为基础的，这并不是维持精英领导制度最好的办法。阿尔伯特·爱因斯坦当年就是因为谋求不到大学教职，才跑去瑞士专利局坐班的……

**《世界周报》：……然后他用私人时间搞研究提出了相对论……**

戈德曼：对。这在中国是不可想象的。如果你问中国人最担心什么，很多人会说：“为什么我们得不到诺贝尔奖？”其实已经有八名中国人在科学领域得到了诺贝尔奖，但他们大都是美籍华人。

中国的制度很难辨别筛选那些不合群的怪人，他们往往能做出根本性的贡献

，比如爱因斯坦。我们在这方面要强得多。西方人认为人类个体里有潜在的神性，这就是所谓的神圣火花，而这种概念在中国根本不存在。因此，我认为我们在与中国人竞争中还是有机会的。

**《世界周报》：美国总统唐纳德·特朗普一直说：“我们必须阻止中国人窃取我们的创新和思想。”他这样说对吗？**

戈德曼：这种说法既有对的地方，也有错的地方。中国的崛起当然对西方的繁荣与安全构成了威胁，特朗普呼吁西方留意自然没错。倒是前副总统乔·拜登出于维护自己儿子的利益，说无需对中国人多虑。这种说法非蠢即坏。我们当然得提防着中国人。如果中国人在下一波工业应用中占据了主导地位，我们的穷日子就来了，安全环境也会恶化。我们将对他们产生依赖性，我可不喜欢那样。

不过，我不认为中国人意图侵略我们，或者按中共模式在美国成立美国共产党。

**《世界周报》：你认为中美两国短期内不会进行军事对抗吗？**

戈德曼：我觉得不会。研究一下中国武装力量的配置你就会发现，它有点头重脚轻的感觉。中国单兵装备花费约1500美元，基本上就是一杆枪、一顶头盔、一双靴子。美国单兵装备花费18000美元。我们有强大的空运能力。我们的步兵技术含量非常高。中国陆军装备和作训水平还比较落后。他们的强项在于导弹、卫星、潜艇等方面，极其强大。

**《世界周报》：中国的军事战略核心在于控制国境线。**

戈德曼：控制南海。他们海军陆战队和机械化部队兵力可能达到10万，而且可能不久后就能部署在台湾。但除了维护领土完整之外，他们对其他东西没有表现出任何兴趣。当然，他们在吉布提有海军基地。未来中国可能会向海军投入更多资源，因为美国对波斯湾安全的兴趣正在减弱。我认为，中国在波斯湾的存在必然会增强，因为它要维护基本的经济利益。但这跟投射帝国军事力量完全是两码事。中国不是苏联。

**《世界周报》：有人认为美国跟中国对抗的策略是错误的，两个国家应该成为朋友。中国人对友谊看法跟我们一样吗？**

戈德曼：中国人没有朋友。作为个人没有朋友，作为国家更没什么朋友。

**《世界周报》：譬如中国农村的某个农民，你能说他没有朋友吗？**

戈德曼：我在中国工作时，当地同事告诉我，当你上小学一年级时，你左右看看同班同学们，他们都是你要甩开的对手。在中国人的观念里，家庭最重要，除此之外就是上级和下级。没有什么平级关系。没有人自发地聚集结社，以平等身份共事。一般而言，你有一个上级，几个下级。这里没有亚里士多德那种政治友谊的概念。

**《世界周报》：难道人与人之间不存在友谊吗？**

戈德曼：人们私下当然有朋友。但中国人没有西方那种政治友谊的概念，这种理念可以追溯到亚里士多德。中国讲利益不讲友谊。有个源于意大利南部的概念叫做“非道德的家庭主义”，人们以无关道德的方式与世界打交道，但在家庭内部又有另一套标准。这也很符合中国社会的特征。

**《世界周报》：中国在极力展示其“友好”的一面，这显然符合其利益。他们有庞大的公关战略，在西方媒体上购买栏位来宣传自己，力图让大家觉得中国是个友好的巨人。**

戈德曼：但他们外宣效果显然不怎么样。

**《世界周报》：为什么会产生这样的结果？**

戈德曼：因为中国人完全不懂得西方人的情感，所以很难以西方的方式进行对话。我最不担心的就是中国针对西方的外宣。他们在通过金钱和技术获取影响力方面倒是一把好手。

**《世界周报》：你的意思是他们无法赢得人心？**

戈德曼：对，因为对西方人而言中国体制完全是异质的，跟他们的需求和期望相差太远，以至于根本无法产生吸引力。

**《世界周报》：作家吉卜林曾写道，“东方是东方，西方是西方，两者永不聚！”现在看来这么说似乎也没错？**

戈德曼：西方和中国永远不可能成为朋友。当然，我们必须得和中国做生意。谁都不可能把聪明勤奋的14亿人隔绝起来，那太荒谬了。但是，西方要想成功地和中国打交道，自己必须处于实力地位上。

**《世界周报》：特朗普总统采取的策略是威胁对手和展示实力。这对中国人有用吗？**

戈德曼：就目前来看，我认为没什么用，因为他常常雷声大雨点小。伊朗就是个很好的例子。“填弹完毕，锁定目标，随时准备攻击伊朗。”这样的话你可以说，但实际上我们不会打伊朗。因为如果我们攻击伊朗，波斯湾石油供应将受到严重干扰。另一方面，中国人对美国这根弦绷得特别紧。有段时间史蒂夫·班农四处散布言论，试图动摇中国政治体制的稳定，中国很多高官都认为班农的言论代表特朗普私下的意思，其实根本不是这样。

**《世界周报》：你的意思是，特朗普在经济上对抗中国的策略很失败。**

戈德曼：我认为这是个彻头彻尾的失败。上次选举时我把票投给了特朗普，这次我应该还会投给他。我希望他能连选连任，但他最大的敌人可能是他自己，这也是令我感到苦恼的一点。

他号称要重振美国工业，这是他竞选的前提。制造业是美国经济最薄弱的部门。而特朗普能否连任取决于他拿不拿得下几个制造业关键州。由于关税伤害了制造业，他这次连任比较悬，本来可以更稳的。

而且，我前面也说了，美国说服其他国家不购买华为5G设备的企图已经完全失败了。今年华为的5G供应量是60万个基站，而且整个生产过程可以不使用任何美国组件。

我们发明了半导体，发明了显示器，发明了光纤网络，数字经济的每个组成部分都是美国发明的。结果我们的产量少得可怜，有些东西完全不生产，这是美国的耻辱。

因此，特朗普提出“不能再这样下去了”，他说的很对。但我认为他选择的方法是无效的，甚至适得其反。

**《世界周报》：美国输了吗？还能扳回来吗？**

戈德曼：当然可以。但怎么才能扳回来现在还很难讲。里根政府时期，我曾经给美国国家安全委员会做顾问。当时美国联邦政府斥巨资直接补贴研发项目，换做今天的美元相当于3000亿，约等于GDP的1.5%。每个大公司都有实验室，都聘有几千名科学家。为现代数字经济奠基的全部发明都来自五角大楼的一个项目。其影响之深远，大大超出了我们的预期。

1976年，美国国防部希望让战斗机飞行员能够在驾驶舱里进行天气预报。他们需要一种高速、轻便的计算机芯片。他们开发出来的产品被立即应用于俯视雷达。俯视雷达需要计算机成像，美国无线电公司实验室研制的芯片使这成为可能。国防部预料到了这一点，此项技术使我们在冷战期间对俄国人有了决定性的优势。

如果我们真能像过去那样调动资源，相信我们将取得高于预期的成果。目前的当务之急是恢复创新文化，动员人力和企业资源来实现这一目标。

**《世界周报》：什么样的战略能够使美国赢过中国？**

戈德曼：我举个例子。半导体是中国目前最大的投资方向。中国是世界最大的半导体进口国，每年进口半导体总值超过2000亿美元。中国今后打算大部分半导体都实现国产。因此，它对各大芯片制造厂商投入了大量资金。芯片制造昂贵得不得了，台积电新开一间工厂要300亿美元。现在有种制造半导体的自组装技术，芯片不用压，让它自己长出来。

如果我们能采用一些实验阶段的技术，并使它们发挥作用，这将抵消掉中国投入半导体制造工厂的1000亿美元。我建议瞄准关键技术，以创新引发行业剧变，抵消中国现有投资的价值。

**《世界周报》：你认为中国的弱点在哪里，什么会给它的未来造成实质性问题？**

戈德曼：中国好些弱点。首先，它的人口老化速度非常快。和所有老龄化国家一样，中国需要出口资本并雇用其他国家的年轻人，靠他们来支付本国人的养老金。德国也这样做。这算是中国部分战略动机。未来中国抚养老年人的负担将十分沉重，它希望通过自动化、高效医疗等方式来解决这一问题。

中国更大的问题是年轻人的抱负。中国每年有上千万人参加高考，其中三分之一读了工程学。这些学生期望未来获得机会。如果中国在技术上失去优势，落后于西方，那么政权稳定性将面临重大挑战。

不要指望靠在人权问题上指责中国来实现这一目标。美国当然会抱怨，但这毫无作用。中国人只尊重实力，而我们的实力在于创新。如果美国能在创新上赢过中国，在关键技术领域拉开差距，自然会取得政治优势。

（完）

![](https://i.loli.net/2019/10/28/ujdHfJlPUFyYk3N.png)
