---

layout: post

title: 南水北调工程其实已经完全失败：每吨水的成本高达1100元

categories: Archive

date: 2019-08-03

tags: 南水北调

image_feature: "https://i.loli.net/2019/08/04/dNIqFn7WS4Qij6b.png"

description: "现在根据各方的报道，不但东线和中线都是失败工程，并且还是惨败，一败涂地，无法交代，无法收场。"

---

原文来自公号「霹雳炮」：~~[南水北调工程其实已经完全失败：每吨水的成本高达1100元](https://archive.li/mKdEw#selection-21.1-24.0)~~

---

空前浩大，举世瞩目的中国南水北调工程东线和中线一期，至今已经耗资达约2500亿人民币，加上后续工程和维修养护运行管理费用，总共将耗资5000亿人民币。东线已经在2013年底宣告通水，中线也在12月10日正式通水。这样一项世界空前的建设工程，按官方说辞，功在当代，利在千秋。尤其是北方缺水，已到干渴难忍，不可持续的地步。南水北调若却能缓解北方干渴之苦，是莫大的功利，应该全国敲锣打鼓，大大庆贺一番。可是在官方媒体的宣传上，对南水北调建成的报道着墨不多，似乎是有意回避难言之词。各方重要决策者、建设者、负责者、指挥者，也不见纷纷出来邀功。到底是怎么回事呢？

我年前撰文，痛斥整个南水北调工程决策和实施是屁股决定大脑，罔顾起码的自然和科学原理，必败无疑。现在根据各方的报道，不但东线和中线都是失败工程，并且还是惨败，一败涂地，无法交代，无法收场。

## 南水北调怎样才算成功或者失败

继续讨论之前，有必要对南水北调这样空前规模的远距离输水工程，怎样才算成功，怎样算是失败，先下一个定义。没有定义，只要有一桶水流到了北京，他们都可以称为成功。任何工程都是投入工程成本耗费后，计算其所获得的社会经济效益，效益超过耗费，就算成功了。效益低于耗费，就是失败。南水北调耗费5000亿人民币巨款，其成功与否，端看能够调来多少水，值多少效益，和耗费相比合不合算。按照一般工程投资成本计算，全部投资额分摊到每年的成本耗费，大约应该乘以10%，也就是说一年消耗500亿人民币。那么按照原工程设计指标，东线一年调水100亿吨，中线也是一年100亿吨。如果真的能达到设计的年输水量，每吨水的成本约不到3元人民币。那么不算环境破坏的代价，可以算是工程成功的吧。反之，如果东线和中线调水远远达不到设计的指标，发挥不了效益，就算工程失败。我取一个基准线，设计调水能力每条线一年100亿吨，如果能达到75%就是75亿吨，我就算南水北调工程成功了。

![](https://i.loli.net/2019/08/04/dNIqFn7WS4Qij6b.png)

<figcaption>南水北调东线建成便已彻底失败</figcaption>

以每年调水75亿吨的评判标准来衡量，已在2013年底建成通水的东线，已告彻底失败。

根据报道，南水北调东线从2013年11月15日开始第一次正式通水，至12月10日通水结束，历时25天，共调3400万立方米的水。算起来水流量仅每秒15.75立方，一年四季365天连续输水，每天86400秒，算起来也达不到每年5亿吨的输水量，仅有设计指标每年100亿吨水不到5%。这是彻底失败。

东线第一次通水在12月10日宣告结束之后如何呢？照理，这样一个耗费天文数字建成的庞大工程，一旦建成，就应该昼夜24小时一秒钟也不停息地联系运行，以发挥其最大可能的经济效益，除非中间因为故障不得不停下来检修维护。可是我们看到的是各种关于北调的南水价格太高，各地用不起，不愿用的报道。事实上12月10日通水结束后，水渠就关闭了，没有运行，只是在晒太阳。因为东线需要用强大的水泵提升水位，把水从低处逐级抬高，才能往北流动。驱动水泵要耗费巨大的电力，谁来支付电费呢？没人肯支付。不但没人支付电费，况且调来的水太浑浊，污染太重，水价太高，没人愿意购买。而水费是按照分摊成本除以输水量算出来的，输的水越少，除法算出来的每吨水费越高，越是没有人要，这是一个恶性循环。因此，东线只能是建成之后即搁置不用了。

但是东线已经建成，一直晒太阳不用，也不是一回事啊。因此当局硬着头皮下达了东线今年的年度调水任务。根据报道，该次调水从5月7日至5月26日止，共20天，总共调了4550万吨水入骆马湖，“胜利完成”本年度调水计划。年调水量100亿吨的浩大工程，建成后一年只打算调0.455亿吨就算完成年度任务了，仅仅不到0.5%的利用率，而其他时间就晒太阳搁置不用了。几千亿的投资就当作打水漂了。我们再算，花20天调水仅4550万吨，平均水流量仅有每秒26立方，如果一年连续运行，也只有每年8亿吨，离每年100亿吨的设计输水量，差得远着呢。一年500亿的成本，若是满打满算调8亿吨水，每吨的成本分摊是60多元人民币。可是现在下达的年度调水计划仅有0.455亿吨，摊到每吨水的成本高达1100元人民币，每升污水1.1元，比瓶装饮用水还昂贵。这是惨败。

![01.jpeg](https://i.loli.net/2019/08/04/R3Zc4zsY6pvLFtr.jpg)

<figcaption>南水北调中线未完工便已注定失败</figcaption>

再来看看中线。水源地丹江口水库现在的水位仅有140米，离渠首147.33米的渠底还差好几米呢，连一滴水也流不进取水渠里，如何调水。如果老天爷不肯配合，再不好好下几场豪雨，把丹江口水库灌满，今年的中线调水计划就要落空了。

更糟糕的是，长期看来也不妙。丹江口水库历年大约每年来水400亿吨，若按照中线设计调走100亿吨，就是25%的调水量，已经是勉为其难，捉襟见肘。可是根据水文资料，从2000年到2010年，十年间丹江口水库的每年来水减少80亿吨，现只有320亿吨了。这很可能是因为水土植被破坏造成的长期性变化，丹江口水库的水，将来只会更少，不会更多。这样的来水量，如何让水库蓄满水，让水可以流入取水渠？如何可以一年取走100亿吨的水，但是又能够保持水库高水位，让水能够流得动？又让汉江的下游有足够的水？这个问题无人能够解答。

更不妙的是，中线一年调水100亿的设计指标，是按照一年四季不间断地输水算出来的。如果不是一年四季水一直可以流动，在枯水季节水库水位够不着取水渠底部，无水可调，只有在丰水季节，水库水位足够高，才有水可调，一年有那么两个月可以调水，其他时间得晒太阳，那么每年的调水量就要大打折扣，远远达不到设计指标的100亿吨。这个还是假设工程的输水速率可以达到设计要求来算的。如果输水速率再打一个大折扣，实际可以实现的年输水量，还要更低得多。

最最不妙的是，即使是在汛期，发洪水之后，水位足够可以流入取水渠，也不能够输水，而必须关闭大闸，因为那水太浑浊，泥沙会毁了输水渠道。只有等汛后一段时间，水沉淀变清，才敢开闸放水，因此一年之内能够输水的时间就更短了。关于泥沙问题我过去已经讲述过，在下面会再详细论述，解释为什么中线的水根本就流不动，泥沙沉淀会很快彻底毁掉中线输水渠道。

![03.jpeg](https://i.loli.net/2019/08/04/d6aL9TnISAZxvqh.jpg)

## 南水北调的决策过程和招标模式使其必败无疑

南水北调是个典型的先拍脑袋决策上马，再请专家论证其可行性的颠倒过来的决策过程，怎么能够不犯错误？犯错误是必然的。任何重大工程，对中央当政者和地方当权者来说，上马总是有利无弊，多多益善，上工程就有大笔的钱下来，无论对地方财政，各承包商，还是自己的腰包和加官进爵的门路，都是只有好处没有坏处，反之若不上工程，所有的好处统统没有，上下埋怨，不但腰包瘪瘪，自己的官运也不会长久。因此而言，永远只可能听到一面倒赞成的声音，绝不可能有人反对。一旦领导层决策，再来请专家们论证一番。专家们能说什么？能说不好吗？能够反对吗？反对也无济于事，该上的还是要上。反而会堵住自己的学术之路，院士评不上，科研资金得不到，一切靠边站。因此专家也只能一致赞同，反对声音鸦雀无声。上三峡工程的时候还有专家大声反对。上南水北调时候，再也没有人出面反对了。可是科学规律毕竟是科学规律，不会因为没人反对，科学就能屈服于威权了。违背科学规律的工程，受到惩罚是必然不可避免的。

再看南水北调工程的承包竞标模式，也是必败无疑。重大工程要进行竞争竞标投资，这在西方是很正常的运行模式，这激励承包商们拿出最好的工程效率，以最低投资，达到最优的工程效益，通过竞争提高效率。可是这要有先决条件。先决条件是竞标必须透明公开，竞争要公平诚实，事后的施工建设必须有严格的监管核查。这些在南水北调中，因为牵涉到各方私利，均无法实现。承包商们使用各种不合法，不诚实的手段，先拿到竞标再说。一旦拿到工程，承包商要赚钱，他的工程造价就一步步加上去了。而在成本费用上就得拼命压缩，偷工减料，能不能达到设计的质量要求，就顾不上那么多了，监管也形同虚设。

这就是为什么工程完工以后，肯定远远达不到设计指标。他承包商不可能达到指标，想达到指标，他的工程耗费就要比竞标价高好几倍，他就要亏得倾家荡产。可是如果当初竞标的时候老老实实地实算，他的要价就比别人高几倍，拿不到工程。所有必须先靠投机取巧拿到工程，再通过偷工减料拿到盈利，就是这么回事。全工程几千个承包商都这么干。

偷工减料偷在哪里呢？具体点讲就要讲到曼宁公式和曼宁参数了。

## 输水渠道流量计算的曼宁公式简介

南水北调中线从丹江口水库约150米高程取水，经1300公里输水渠道送到约50米海拔的终点北京，共1300公里的路途，纯靠一百多米的水落差驱动。水流坡降不到万分之一。这个坡降大约相当于三峡大坝之后的水位一直到长江入海口的平均坡降。

水在渠道中靠天然坡降流动的水流速度，可以用曼宁公式计算。具体来说，水速正比于坡降的平方，水力半径的2/3次方，反比于渠道表面的曼宁糙率。渠道越光滑，摩擦力越小，水流得越快。反之，渠道越粗糙，摩擦力越大，水流越慢。和曼宁系数成反比关系。

问题就出在用什么曼宁糙率数据来计算才合理。普通清洁的天然河道的曼宁系数约0.04，如果长上水草会更高，视河床状况而定。干净的打磨平滑光洁的混凝土表面，其曼宁系数是0.013。南水北调东线和中线所有设计施工，看来都采用0.013的曼宁系数。这对吗？




问题出在这里。理想条件下清洁而光滑的混凝土表面，曼宁系数才会低到0.013。可是，施工会有缺陷，打磨不会完美。工程建成通水的第一天，曼宁系数就会显著高于0.013的设计要求。一旦投入应用，渠底表面会有泥沙的沉淀积累，过一段时间后，与天然河道的泥泞底部就再无区别，因此曼宁系数会很快达到0.04，底部有泥，便会长出水草，会使得曼宁系数更高。而水流速度反比于曼宁糙率，糙率增加到三倍，水速便只有三分之一，而流量就相应只有三分之一，原来设计一年一百亿的输水量，便成了只有33亿。关于泥沙沉淀的问题，我下面再详细解释。

南水北调的设计施工者一切都按照最优条件计算，违背了工程设计里一切都考虑到最坏情况的基本设计原则。这是在欺骗自然规律和工程规律。最坏的情况，如果有可能发生，就必然会发生。最优的条件，如果未必能达到，就必然达不到。这是基本规律。南水北调的设计者假设一年365天都能按照最高效率输水，不管枯水季节还是洪水季节，他们还假设渠道永远保持清洁光滑，曼宁系数不会超过0.013。他们还假设水头分布的理论计算完全正确，输水渠道各段的水位，水速，完全和理论计算吻合。在所有一切保持完美无缺的，并且长期保持完美无缺的情况下，他们认为可以达到一年输水100亿吨的目标。

事实情况远没有那么完美，事实要骨感得多。

## 南水北调中线京石段的四次输水远未达到设计要求

南水北调中线的石家庄到北京段，已因北京奥运先期建成。至今已四次通水，效果如何？

四次通水累计输水16.1亿吨。第四次通水从2012年11月21日到2014年4月5日，共有500天，输水4.82亿吨。平均流量为每秒11.2立方，按此流量每年输水量为3.5亿立方，远远低于每年输水100亿立方，入京50亿立方的原定工程目标。而输水渠道的截面面积有60平方米，按照流量每秒11.2立方算，水流速度仅有每秒0.19米，极端缓慢。

再把数据和第一次输水对照。第一次输水，按照杨开林、汪易森的论文中实测数据，流量为每秒19立方，水速约每秒0.32米。相比之下，第四次输水的水速，流量和第一次比都要低很多，仅仅几年，工程效益已经几近报废。

再次重申，中线的工程设计目标是年调水100亿吨，入京50亿吨。就是平均流量要分别达到每秒320立方和160立方。现在看远远达不到这样的目标。

## 泥沙沉积将很快毁掉南水北调工程

天然的水流，即使没有任何污染，也并不是纯净的，其中携带有大量泥沙。这些泥沙会在输水渠道中积累，是水流缓慢，甚至完全停滞下来。泥沙沉淀是个非常严重的问题。但是在南水北调的论证和实施中，根本没有泥沙组的专家参与，因为他们知道泥沙的问题根本就无法解决。泥沙会毁掉南水北调工程。

我们先来看看一些数量级数据。丹江口水库每年入库水量为400亿立方，现在大概已减少到320亿，而入库的泥沙量有一亿吨。按百分比计算，泥沙含量0.25%，相当惊人。专家算因水库内水流相对缓慢，大部分泥沙留在库内，长久将淤塞库容，变成一个死水库。

再看看长江，每年入海流量约一万亿立方，携带入海的泥沙有五亿吨。这是约0.05.%的泥沙含量。长江下游的水速约每秒2.5米。在这样水速条件下，能够携带0.05%的泥沙。

水流携带泥沙，和水速关系很大。发洪水时，不但水极度浑浊，并且大块的石头都被水流推着走。可是枯水时节，即使很小的泥土颗粒都会沉淀江底，成为泥浆。这个水速和泥沙颗粒大小的相关关系很敏感。物理计算表明，这个相关关系是六次方关系，假如水速增加到两倍，二的六次方就是64倍，可以把64倍重的泥土颗粒从河床卷起来带走。反过来，水速慢到一半，就可以让六十四分之一的泥土颗粒在水底沉淀。

丹江口入库水流速度每秒3.5米，就能携带0.5% 的泥沙。长江下游水速每秒2.5米，是丹江口的72%。而72%水速的六次方是14%，携带0.5%泥沙就减少到携带0.07%，多余的泥沙便沉淀到江底了。因此，只要水流略缓，泥沙的沉淀是惊人的。

专家计算，98%的泥沙留在丹江口水库库底，那么还有2%的泥沙，也就是0.01%的泥沙留在水里，这已经假设水非常清洁。但是每年一百亿吨的水，携带0.01%的泥沙，就是一百万吨，分布到1300公里的输水渠，每米长度的渠道可以分配到770公斤的泥沙。那么这部分泥沙会不会沉淀下来呢？

假如每秒流速2.5米的长江水可以携带0.05%的泥沙，那么0.01%是五分之一的泥沙量，按照六次方根算，水流速度每秒2米的流速，可以把泥沙冲刷走。但是水流若只有每秒一米或者更低，那么这部分泥沙的98%都要沉淀下来。每米的渠道每年要沉淀750公斤的泥沙，这是非常惊人的沉淀速度。因此，输水渠道水速无论如何都不能低于每秒2米。否则泥沙问题很严重，无法解决。

可是实际数据已经告诉我们，京石段第一次输水时，水流速度仅有每秒0.32米，现在更是慢到每秒0.20米。显然，曼宁糙率增加了，水流得更慢，缓慢水流更加速泥沙沉淀，进一步增加曼宁糙率，使得水流更慢。这是一个恶性循环，直到变成一潭死水，流不动。

最新的报道，石家庄段开始充水试验。数据很不妙，文中叙述石家庄段全长123公里，设计入境流量为每秒220立方，出境流量每秒170立方。可根据报道，这段123公里渠道，水流从入境到出境总共花了整六天，平均水流速度仅每小时0.85公里，或每秒0.24米。按照这样的流速，流量不到每秒14立方，比设计的入境流量每秒220立方，出境流量每秒170立方，低了不止一个数量级。并且这样缓慢的水流，泥沙沉淀无可避免，工程因此被摧毁报废，是几年内无可避免的结果。

## 失败的南水北调工程后患无穷

南水北调中线渠道横跨中原大地，高悬于地，流经人口稠密的城镇。若是略有差池，渠毁水漏，滔天洪水，夺命无情！我们敢肯定不会出事吗？我们来拿沙河渡槽来算算。

沙河渡槽的箱式槽是两箱并行，输水截面加起来195平方米，渡槽的跨距是30米。也就是说每一跨光是算水的重量，就有5850吨，加上渡槽本身重量，有一万吨。我们经常会读到高速公路立交桥质量低劣，几十吨超载的大卡车开上去，就把桥压塌了。那么一个每段达一万吨的渡槽，会不会压跨？谁敢打包票？我认为没有人能够保证其质量不出事。

我可以保证的是，水中含有腐蚀性的无机盐分，在巨大重力压迫下，水泥是不抗拉的，必然开裂起缝，纯靠钢筋支持。而钢筋暴露在空气，水和无机盐中，日久腐蚀，无法耐久。

南水北调渠道若出事，必有突然性，沿途居民，绝难有逃生机会。

北方冬天冷，若遇极寒天气，渠道必然结冰冻结，胀破渠道。无法修复。这个问题无解。

失败的南水北调将如何收场？我实在难以想象。也许他们现在能够做出的最好选择，正如已经运行的东线一样，建成后就基本上搁置不用，成为一道中看不中用的风景线罢。

## 缺水的中国北方如何摆脱困局

中国北方极度缺水，干渴难忍。可是指望南水北调解决问题，是盼不上了。规划中的东线和中线各每年调水一百亿吨，是指望不上的。顶多每年有三亿多吨入京就了不起了。这笔天文数字的调水投资，确实是扔在水里了。

事实上，按照地理条件算，北方并不缺水。中国国土年降水量为六万亿吨。北半个中国的得到两万亿吨，平均年降水量约六百到七百毫米。相比之下，南水北调即使每年调水能够达到一百亿吨，和老天爷的赏赐相比，只是九牛一毛，无济于事。

北方缺水是人为的，环境污染，水土破坏，至无水可用。因植被被破坏，天下雨的水无法截留，直接变成洪水奔流入海。治理之道当保护环境，恢复植被，让雨水被植物截留，渗入地下留存。再不济拦坝筑人工湖蓄水。不能让洪水白白流走。

北方煤炭开采摧毁自然资源，大量摧毁地下水资源，必须悬崖勒马，不能无止境挖煤了。必须显著减少煤炭开采量，留些给子孙，让土地休养生息。不足的煤炭资源可以进口。

城市用水，不能依赖过量开采地下水了。地下水无非来自地面，绝不能作为常态的水源供应，只能作为特殊情况下的应急水源。城市用水，应该另辟来源，大量地开发海水淡化。同时大规模提高水价，让居民懂得水的珍贵，也可鼓励民间投资开发海水淡化。

北方农村在长期缺水中，为求生存家家户户建造水窖。这是一个好办法。再干旱的地方都会有雨下。不能让雨水白白流，必须积起来慢慢用。但是，每家每户自行修建水窖，耗资太高，规模太小。必须通过扩大规模来减少成本。水窖无非围一圈墙把雨水积起来。围住的雨水量正比于围住面积，修建成本正比于围墙周长。因此周长长两倍，能围住面积就是四倍，就有四倍的水。应该一个村庄建一个打水窖足矣。一个城市建一个特大水窖，或者说是人工湖，也足矣。年降雨700毫米，如果能够留存500毫米，一平方公里就是五十万吨的水。一千平方公里就是五亿吨水。围成圆形，只需顺势修112公里的围墙即可。利用地形灌入地下。北京乃至整个华北的水危机，如此可以化解也。

来源：5G信息网
