---

layout: post

title: 大兴火灾一周年：新建村见闻录

categories: Archive

date: 2018-11-16

tags: 北京驱逐

image_feature: "https://i.loli.net/2018/11/19/5bf24a6ae22d7.jpg"

description: 火灾发生后的这一年里，我去了新建村四次，只想留住新建村的最后一面。这个生于1956年的村子，62年之后，走到了它生命的尽头。在62年的生命之中，许多故事将被人们遗忘，无论悲喜。

---

![图片](https://i.loli.net/2018/11/19/5bf24a6ae22d7.jpg)

文章首发于微信公众号：豫广

>本文分三个部分：
>
>逃离新建村、重返新建村、夷平新建村
>
>共10626字，106张图片，阅读需30分钟。

还记得，2017年11月18日北京大兴火灾事故后的新建村吗？

火灾发生后的这一年里，我去了新建村四次，只想留住新建村的最后一面。这个生于1956年的村子，62年之后，走到了它生命的尽头。在62年的生命之中，许多故事将被人们遗忘，无论悲喜。

2017年冬，因为这场火灾，北京产生了“qinglididuanrenkou”的问题。与此同时，中国还发生着这样一些事：湖南肺结核事件，鲁炜落马，红黄蓝幼儿园虐童，宁波大爆炸，蔡奇三赴大兴区。

火灾后第三日，即腾退最后一日，我也奔赴新建村。那时北京刚入冬不久，寒风里数万人忙着搬离。撕裂的铁皮、砸碎的砖石、扭曲的钢筋、折断的木梁、破烂的泡沫，那些都是曾经构建起新建村的东西，此刻全然坍塌。

冬去春来的时候，我又去了新建村两趟，并在那儿住了四天。天气渐暖，村民和少量外来务工者竟然都回来了，新建村也渐渐热闹起来。五个月前，村子里撵走外来务工者，这时外来务工者又开始维持着村子的基本秩序。

但那种秩序，终究还是要被打破的。今年记者节的第二天，我又去了新建村，这时离大兴火灾过去将近一年。村子被两三米高的围墙封锁，差不多被夷为平地，只剩下一片废墟。

## 1 逃离新建村

2017.11.21，北京市新建村

新建村，在天安门正南略东约20公里处。

从北二环到南六环，我花了两个小时。兴19路公交到大兴三间房站的时候，已经是下午一点。这是致19人遇难的大兴火灾发生后的第三天，与此同时，数以万计的外来务工者正被迫从那里逃离。

穿过南六环的公路，是一条东西向的河，过河便是位于大兴区西红门镇的新建村。后来才知道，那条河叫凤河，1956年的雨季，河水疯涨，村子遭洪涝侵袭，受灾严重。那时，400余户农民从昌平集体搬迁至此，尚不足半年。

新建村地区，原归大兴县，历史上属于“南海子”，是历代帝王放马行猎之地。就像高密东北乡最初的样子，“蛮荒之地，一片大涝洼，荒草没膝，水汪子相连”。后来就成了农田旷野，再后来被征用建了这个四四方方的一个村子。

![图片](https://i.loli.net/2018/11/19/5bf24a723787e.jpg)

<figcaption>4月9日，村民提供的新建村房屋安置设计示意图</figcaption>

不久，民房便盖了起来，户型统一，都是具有时代特征的砖瓦房，门前还留有一片空地可当作菜园。1956年3月18日起，移民开始统一搬迁至此，村子也就渐渐形成。

据《大兴县志》记载，1956年春，因国家征用土地，昌平县水台、鳌峪、大水峪、王峪、水涧、跳梢、百峪口、白羊城等村400余户农民迁徙至此建庄，时称光华农业生产合作社。

孙大娘就是1956年春，坐着移民客车搬过来。那时候她还是个孩子，跟着家人坐在摇摇晃晃的客车上，“那时候家里穷，都没什么可带的”。对于从昌平山区搬到这里的人来说，他们并不知道这里曾被称为“南海子”，后来知道后当地村民戏称，这是“癞蛤蟆撒尿都能涝”的地方。

1956年夏季，移民安置刚刚结束不久，雨季来临。村南紧挨的凤河水势疯长，渐渐洪水平岸，水开始进入村子。刚落脚的村民的新生活，就要在洪涝灾害中度过了。村里老人回忆，当时刚建好的房子，风雨随便就打破了窗户，屋顶也淅淅沥沥地漏着雨。

这群从昌平山区搬来的农民，哪里见过这种情形，山里即便下再大的雨，也不会涝。而且这里雨季过后，“土地一脚踩下去就能冒出一碗水来”。有些村民难以适应这的生存环境，再加上安置房屋质量低，百姓意见很大。不少村民要求返回昌平山区。

村里老人说，鉴于此种情况，1957年，新建村的房屋展开工程大翻修。而要求返回的村民则在昌平又建一村，如今也称“新建村”。

![图片](https://i.loli.net/2018/11/19/5bf24a7e292da.jpg)

<figcaption>图中标记出的，呈长方形的区域即大兴区新建村地区</figcaption>

这个位于京城南郊的新建的村子，后改称“新建乡”，最初属于大兴县。据县志记载，1957年10月该地区曾划属北京市南苑区，1958年5月复归属大兴县，1981年改名为新建庄。

在其62年的生命里，这个新建村历经了人民公社时代、红星集体农庄时代、家庭联产承包时代、工业大院时代，以及现在的新时代。新建村地区，也从一片荒野变成有烟火气的村庄，继而借着京城南门的区位优势用了十多年的时间疯狂地发展成为繁华的城中村。

如今，62年过去了。一场火灾，村子就因此迅速腾退拆迁，继而成了如今的废墟。而我只想用些零碎的文字和图片，记录下这个新时代里，真实存在过，却又即将消失的村庄，和一群正在离去的人。所以就有了这些……

![图片](https://i.loli.net/2018/11/19/5bf24a81a2efb.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24a8403f5e.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24a8f289b0.jpg)

<figcaption>11月21日，新建村村西口，车辆出入频繁。</figcaption>

火灾发生后第二天，村里就贴出“腾退通知”，限期走人，否则强制搬离。我到新建村西口时，柴大爷正在路边儿打电话，让老乡来接他回河北老家。

从村里搬出来的物件，都堆在桥头。一台服装厂用的旧缝纫机，儿子在出租屋里装的空调，老旧的坐扇，孙女骑的自行车，还有几个包袱。柴大爷说：“回老家就不再来北京了。”但儿子儿媳还在村子附近的厂里打工。跟柴大爷道别后，我沿着河岸公路往东便入了村。

![图片](https://i.loli.net/2018/11/19/5bf24a91e1cf2.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24a969753c.jpg)

<figcaption>新建桥头</figcaption>

村子里来了许多收废家电的人，喇叭不停地在车前吆喝着进村后，随便找了条巷子我就往北走，路上碰到了正在搬家的高大叔。一辆原本用来盘砖拉沙的翻斗车，被他用来拉屋里最后的东西。他所在的院子，三个月里，就陆陆续续搬走了不少住户。因为这场大火，现在他也不得不提前搬离。

实际上五年前镇里的拆除腾退工作就已经开始了。据媒体2015年报道，2012年开始，西红门镇启动工业大院拆除腾退，同时进行产业升级改造。并计划用5年时间腾退27个工业大院，疏解流动人口10万人。根据西红门镇的规划，2017年拆除腾退完毕后，960万平方米的土地将按“二八开”比例分配，20%规划调整为集体建设用地，80%用于还绿。

但村民说，实际上新建村的拆除腾退工作一直没有实质性的进展。反而近七年，是新建村发展最为迅猛的时期。并且村里的部分土地早在2004年就以“每人、每亩、每年不低于1000元人民币”的流转费，集体承包给北京市五连环投资有限公司，土地承包经营权流转期限为30年。

虽然土地仍然为集体所有，但村民对土地早已失去了控制能力。随即有村民开始担心，这次拆迁之后，村民散落四方，原本集体的土地怎么办，拆迁赔偿又应该怎么算？巷子里的人们相互谈论着，无不和搬迁有关。有人吐槽，有人无奈，有人要逃离北京，有人已找到新的落脚之地，而不少人还在寻找着，也有人不知去留。

![图片](https://i.loli.net/2018/11/19/5bf24a9835ee6.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24a9c3ecaf.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24a9ef38ad.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24aa264497.jpg)

<figcaption>11月21日，村民仓皇离去，新康路上拥堵着搬家的车辆</figcaption>

走出巷子，是条东西走向的街道，这大概一条主街道，行人与店铺众多。足疗按摩店与大众餐馆都“关门大吉”，偶尔开着的，正紧锣密鼓地从店里往外搬东西。

后来再去新建村才搞明白，以这条街为分界线，村子被分为南北两个部分。村北为集中的工业大院和厂房公寓（发生火灾的聚福缘公寓便在村北），村南为居民楼。村民说，此前几乎每家每户的楼房庭院里都有一个两个服装厂房，一楼工人做工，二楼提供住宿，三楼自己住。

![图片](https://i.loli.net/2018/11/19/5bf24aaaa84aa.jpg)

<figcaption>11月21日，保安和辅警守在事发公寓附近</figcaption>

沿着街道转身往东走，身穿黑色制服的人突然进入视线。再继续往东走，警察、警车、警戒线相继出现。我想，三天前发生火灾的公寓应该不远了。

确实，火灾的中心区域，就在警戒线二十多米外的地方，但早已被封锁。围观群众还站在路边儿，交谈着火灾发生那天晚上闻到的奇怪的令人恶心的味道，以及看到的从事发公寓冒出来的滚滚黑烟。

不一会儿，警察开始驱赶聚在路边儿远望讨论着的人群，“看什么看，有什么好看的，赶紧离开。”我也就离开了，继续往东走，想看看是否有其他地方能看到事发公寓。未能如愿。

![图片](https://i.loli.net/2018/11/19/5bf24ab5b1be0.jpg)

<figcaption>11月21日，事发公寓外围被封锁</figcaption>

记得新华社19日凌晨的消息说，明火在燃烧近3个小时后被扑灭，火灾共造成19人死亡，8人受伤。事故原因尚待查明。在接下来的三天里，不断有各路媒体涌入新建村一探究竟，新建村之外，人们迫切希望知道这悲惨一幕为何会发生。但各家记者发回的报道要么“胎死腹中”，要么毙于网络。

下午两点左右，我兜兜转转走进了一座公寓，住户们正在门口讨论着房租退款事宜，不搬已经没有办法了，腾退通知已经贴到了公寓的门口。

这时几个城管执法者来催迁，身后跟着三名特勤。住户们说，这已经是今天来催第三次了。今天是腾退的最后期限。傍晚，拆迁将正式开启。

![图片](https://i.loli.net/2018/11/19/5bf24ac08c760.jpg)

<figcaption>11月21日，张贴在村子公寓里的“腾退通知”</figcaption>

![图片](https://i.loli.net/2018/11/19/5bf24acdb49c4.jpg)

<figcaption>11月21日，执法者前来催迁</figcaption>

大火过后，工厂、店铺、公寓都被要求在短期内迅速搬离。数万人打了个措手不及，这种毫无人情味的行政命令，让外来务工者在这个冬天感到身心皆寒。他们不得不辞掉工作，清空店铺，狼狈逃离。

村子里有一条南北走向的主干道，叫金服大街。街道上人群拥挤，秩序混乱，堆在路边的垃圾能淹没小腿。我挤过人群，发现这里应该算得上新建村的最繁华的区域，路两边儿是各式各样的店铺，饭店、服装店、大超市。但多数闭门停业。

张贴着“紧急转行回家放羊”的店铺也已经关门。那电线杆上留下的八个大字，仿佛是对此时此刻的北京的戏谑，但更多地透露着店家的无奈。路边儿的其他店铺也空空荡荡，一位大妈试图在满是泡沫板、塑料袋、鞋盒的服装店里寻些宝贝，寻不得，出门她又去了下一个店铺。

![图片](https://i.loli.net/2018/11/19/5bf24ad90b482.jpg)

![图片](https://i.loli.net/2018/11/19/5bf24adc773f8.jpg)

![图片](https://i.loli.net/2018/11/19/5bf24adf27ede.jpg)

<figcaption>11月21日，张贴着“紧急转行回家放羊”的店铺已关门</figcaption>

![图片](https://i.loli.net/2018/11/19/5bf24ae3c2a4e.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24ae6d5d9e.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24aee74d35.jpg)

<figcaption>11月21日，一个抱着孩子的女人从废墟旁路过。</figcaption>

街道的尽头是火灾之后便被立即拆除的楼房，和写着“新建村”与“出入平安”字样的仿古牌楼。此前，村里人的早餐就常在村口牌楼下的包子油条摊上解决。火灾之后，一切已经消失。

张驰从小就在新建村长大，他出生不久后便被父母带到北京，在这个城市里待了近三十年。如今看着这个伴随着自己童年一路走来的地方即将拆迁，他不知道该说些什么，只是静静地待在新建村口，坐在车里望着眼前发生的一切。

父母已离他而去，在这个城市，他除了记忆里的岁月，只剩下他孤身一人，“老家是回不去的，但北京真的又容得下谁呢？”

![图片](https://i.loli.net/2018/11/19/5bf24af638393.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24afae6ce6.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24afd5f4b6.jpg)

<figcaption>新建村北一片废墟</figcaption>

村口的废墟，被金服大街一分为二。废墟上杂乱地堆着铁皮、红砖、钢筋、泡沫板、木梁，那些曾经构建起新建村的东西，如今全然坍塌。未来，这里将规划建成的新区，又会以怎样的形式被认识，被熟悉，被淹没在茫茫帝都呢？

![图片](https://i.loli.net/2018/11/19/5bf24b015625f.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24b05b7c2a.jpg)

<figcaption>11月21日，站在村北俯瞰新建村</figcaption>

傍晚，我准备离开的时候，挖掘机伴随着隆隆的声响，从远处驶来。我骑着共享单车吃力地穿过街道，穿过村巷。黄昏中，路边儿店铺已经开始拆了，施工人员拿着锤子重重地锤烂招牌。我拿起手机要拍，旁边儿头戴安全帽的大叔呵斥道：“拍什么拍，手机不想要了！”于是，我按下快门，匆匆离去。

北京的这个冬天，有些冷。

## 2 重返新建村

2018.3.18

2018.4.6—4.9  北京市新建村

原标题：《大兴火灾140天后：新建村的外来务工者》

![图片](https://i.loli.net/2018/11/19/5bf24b107d5b5.jpg)

3月18日，一台疯狂工作着的挖掘机

大兴11.18火灾已经过去了140天。这个坐落在天安门南20公里的新建村，已经褪去了它昔日的繁华。北方的春天已经来了。事发公寓聚福缘东门，还留有烟熏火燎的痕迹，门前柳枝嫩绿，随风摇曳，而公寓内早已空无一人。

数万人的搬离，让新建村几乎变成了荒村。但140天过去了，新建村又渐渐热
闹起来。工业区拆迁中止，“棚改”一拖再拖。从冀、鲁、豫来的农民工在废墟上昼夜不停地忙活着。天气渐暖，村民回来了，少量外来务工者也回来了。

五个月前，村子里撵走外来务工者，如今外来务工者又开始维持着新建村的基本秩序。

拆迁区的外来务工者：眼见高楼起，转瞬成废墟

![图片](https://i.loli.net/2018/11/19/5bf24b13791eb.jpg)

![图片](https://i.loli.net/2018/11/19/5bf24b164d2d3.jpg)

![图片](https://i.loli.net/2018/11/19/5bf24b1a8c394.jpg)

![图片](https://i.loli.net/2018/11/19/5bf24b1f0b6cc.jpg)

![图片](https://i.loli.net/2018/11/19/5bf24b226ebea.jpg)

![图片](https://i.loli.net/2018/11/19/5bf24b25084a8.jpg)

![图片](https://i.loli.net/2018/11/19/5bf24b2b652dc.jpg)

![图片](https://i.loli.net/2018/11/19/5bf24b2e56fe1.jpg)

![图片](https://i.loli.net/2018/11/19/5bf24b31c18a2.jpg)

![图片](https://i.loli.net/2018/11/19/5bf24b35eda48.jpg)

![图片](https://i.loli.net/2018/11/19/5bf24b3891f9c.jpg)

![图片](https://i.loli.net/2018/11/19/5bf24b3b7d896.jpg)

<figcaption>3月、4月，仍然待在新建村的人们</figcaption>

![图片](https://i.loli.net/2018/11/19/5bf24b40e8e17.jpg)

![图片](https://i.loli.net/2018/11/19/5bf24b46ce733.jpg)

清晨的新建村，太阳渐渐从村北拆迁区的建筑上升起，阳光洒向废墟上两棵刚发芽的杨树。昼夜忙碌的粉石机还在隆隆作响，推土机驶过金服大街时，路面黄尘飞扬。

虽然已进入四月，清晨的温度仍低于10℃。37岁的河南人管国忠围着围巾，在工地上一夜未眠。因为灰尘很厚，他和工友不得不戴着口罩整夜忙活。来新建村的40多天，管国忠干了35个工，一个工200元，比他在老家还多50元。除了雾霾天停工，拆迁队的工作昼夜不停。

![图片](https://i.loli.net/2018/11/19/5bf24b4a46a71.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24b4dd63d5.jpg)

<ficgaption>4月7日，夜里，拆迁区仍然在忙着粉碎石渣</figcaption>

![图片](https://i.loli.net/2018/11/19/5bf24b518b88d.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24b54d8a4e.jpg)

<figcaption>4月9日，早晨，拆迁区已经开始忙碌</figcaption>

早上6:30，是夜班下工时间，太阳已升上聚福缘公寓的屋顶。山东人谢宝堂和其他工友正在吃早餐，饭后接替管国忠值白班，7点正式开工。谢宝堂会打开电机。挖掘机、推土机、粉石机，各司其职，从冀、鲁、豫多省来的农民工也各安其位。

谢宝堂说，火灾发生一周前，他在事发公寓地下室打地平。当时地下室的地面铺着保温材料，就是废墟上随处可见的黄色泡沫夹板。他和工友用近四天的时间在其上浇筑混凝土。那时，冷库已基本成形。然而谁也没想到，三天后，即11月18日的晚上，火灾突然发生。

火灾发生时，从河北邯郸来京的巩玉林在村东工地当保安。那天晚上，他的老乡拼了命才从聚福缘公寓爬出来，“逃出来时他浑身上下漆黑”。因为聚福缘公寓的火灾并没有明火，烟从地下室里蹿进二楼、三楼的楼道，许多没能逃出的租户，都中毒窒息而死。

![图片](https://i.loli.net/2018/11/19/5bf24b61490ec.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24b65e7a9e.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24b68db473.jpg)

<figcaption>3月18日，发生火灾的聚福缘公寓被铁皮墙围起</figcaption>

谢与巩的说法，均佐证了官方公布的起火部位与遇难者死因：起火部位系起火建筑地下一层冷库，遇难者死因均为一氧化碳中毒。事后谢宝堂说：“如果不是我们给他打地平，火灾可能更严重。”

其实在火灾发生的四个月前，北京市大兴区防火安全委员会办公室就下发了一份红头文件，通知要求：始终紧盯老旧小区、平房胡同区、城乡结合部村民自建房、工业大院以及出租房（群租房）、高层建筑、地下空间等居住场所，始终保持高压防控态势。然而这场火灾就是发生在群租公寓。

官方消息还称：火灾共造成19人死亡，8人受伤。且从遇难人员统计表中可以看出，以山东、河南、河北等省的外来人口居多。对于官方给出的遇难者数字，村里部分人并不相信，但谁也给不出具体的数字。

![图片](https://i.loli.net/2018/11/19/5bf24b6b88eb0.jpg)

<figcaption>图为官方公布的19名遇难者名单</figcaption>

至于起火原因，官方初步调查结果显示：系地下室内埋在聚氨酯保温材料内的电气线路故障。新修冷库的目的是为了出租和经营。但按照谢宝堂的说法，老板之所以修冷库是为了获得更多的拆迁款，因为“冷库比仓库赔偿更多”。

![图片](https://i.loli.net/2018/11/19/5bf24b6d8848b.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24b70133f9.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24b7280824.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24b7523bb6.jpg)

<figcaption>2013年，建设中的新建村（图片翻拍自百度街景地图）</figcaption>

其实在火灾前，拆迁的消息早已传遍新建。早在2012年，西红门镇腾退改造工作便已启动，但新建村的棚改工作直到去年9月末才开始，真正的拆迁被一拖再拖。而许多老板趁机加紧盖房。或直接在原建筑上加层，或扒掉旧房重盖。在村民印象中，近些年村里盖房一天也没停过。

但这场惊动高层的火灾，直接推动了拖延中的拆迁。事发第二天，村里贴出腾退通知，要求“公寓内所有住户强制搬出”。与此同时，挖掘机开进村北工业区，推倒新建牌楼附近的几栋建筑。

火灾发生后不久，谢宝堂接到大老板的电话，让他来新建村帮忙拆迁。三个月前，同样是跟着这位大老板，谢宝堂还在新建村盖房子，“一转眼就变成了扒房子”。他眼见高楼起，一转眼房子又变成了废墟。

虽然原本的公寓与厂房都变成了废墟，但在那里却藏着生财之道。石渣粉碎，可以卖掉；钢筋铁皮，也可以卖掉。因此，目前拆迁区的主要工作只剩下处理拆迁废物。石渣在被粉碎后被堆成小山，钢筋铁皮则由几位河南信阳的雇工清捡并装车。

![图片](https://i.loli.net/2018/11/19/5bf24b7d53406.jpg)

<figcaption月18日，村北的拆迁区一位河南妇女在捡钢筋</figcaption>

![图片](https://i.loli.net/2018/11/19/5bf24b7f070da.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24b80df7fa.jpg)

原则上，拆迁废物不允许雇工之外的人捡。但一早上，拾荒者王德栓就来了。他租住在七八里外的建新庄。这是他第三次来新建村“拾荒”。两天前的一个下午，他在这里尝到了甜头，找个不易被拆迁队发现的角落，不出三个小时，他便骑着三轮自行车满载而归。然后去收废站卖掉，“够每天抽烟喝酒”。像他这样的拾荒者，在拆迁区的废墟上每天都会出现。

这些拾荒者，也是巩玉林防备的对象。他在村东工地上值白班的时候，他每天的主要任务就是：防火防盗看场地。工地上不允许拾荒者进入，但村子其他地方出现，他则不去多管。村东的拆迁从去年10月最先开始。那时村东一半是厂房公寓，一半是荒地。如今厂房公寓变是了废墟，废墟上搭建着工棚，工棚附近停着四辆昼伏夜出的工程转运车。荒地里的杂草树木开始发芽。

![图片](https://i.loli.net/2018/11/19/5bf24b83f40cd.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24b8664aaf.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24b8ed8237.jpg)

<figcaption>4月6日，一台挖掘机在拆迁区停着</figcaption>

2017年的整个冬天，拆迁持续推进。直到除夕前两日才停工，年后正月初五左右又开工。2018年4月上旬，扒楼工作因部分厂房尚未谈妥已经中止。在拆迁区中心区域，只剩事发公寓与附近几栋尚有纠纷的楼房未拆。

事发公寓聚福缘被铁皮紧紧围着，墙上还挂着安全提示：公寓内仍有部分有毒气体，未经事故调查组允许，不得进入。距离事发公寓西108米处，就是尚有纠纷的宝驰年华网吧。火灾发生后，许多从公寓逃出来的务工者，直接在网吧过夜。当时，网吧主管胡廷贵正在网吧三楼的办公室坐着，直到许多人跑进网吧，他才晓得聚福缘起火了。

网吧因为证照齐全，在被强制搬离的三天里照常运营，夜夜爆满。直到5天后，也被要求撤离。看着周围的其他楼房被扒掉，胡廷贵和房东却一直就网吧装修补偿款的问题没谈妥。于是，火灾发生后的140天里，他一直守在新建村，即便是过年也没回东北老家。

![图片](https://i.loli.net/2018/11/19/5bf24b9634d36.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24b984635d.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24b9b5ad9c.jpg)

<figcaption>3月18日，胡延贵在楼下守着网吧</figcaption>

前两个月，他白天守在楼下，夜晚就在车里凑合着睡上一觉。直到1月中旬，他才在网吧正南的一条巷子里找到房子。早晨醒来，抬头透过窗户，他一眼就能看到网吧。胡廷贵想，至少把装修费要到，但房东只是口头上答应，不愿意签合同。他只好就这么一直守在这里，以免网吧被拆迁队突然扒掉。“房子在，至少有证据。”

村里又来了务工者：何时拆，何时走

火灾，已极少再被村民提及，更多的时候他们关心拆迁。如果在路上遇见，村民们总是谈论村子何时拆，如何赔偿才愿意拆？而外来务工者则更关心能租房吗？能摆摊吗？能住到何时？

清晨的新建村，街道上没什么人。阳光从楼房的间隙穿过，斜斜地撒在装满包头菜的塑料袋上。十字路口旁，江小梅的菜摊已经摆上了。早起上班的人，从各个巷子里走出来。送孩子上学的妈妈、遛弯的老两口儿、蹬三轮的大爷、背包的年轻人，陆续经过。孔令玲端饭碗从街边儿门面房里钻出来，站在路口吃着白面条。

![图片](https://i.loli.net/2018/11/19/5bf24ba3449b3.jpg)

![图片](https://i.loli.net/2018/11/19/5bf24ba43e07f.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24ba639ae5.jpg)

<figcaption>4月7日，夜幕降临，村北牌楼下有务工者卖熟食和水果</figcaption>

这时，刘明丽推着被西红门镇城管撵走的煎饼小车，从村北慌慌张张逃进新建村。就在前一天晚上，一位在新建牌楼下卖熟食的阿姨，被开着车的城管撵进了村子里。她骑着摆有鸡爪和猪头肉的电动三轮车，在满是灰尘的金服大街上狂奔。刘明丽一边儿把车子停在十字路口，一边儿抱怨城管不让她在牌楼下摆摊，还询问江小梅，村子里能不能租房子？

刘明丽不知道，去年冬天火灾发生后，虽然新建村几乎被清空，但村里还留有百十户村民没搬走，少数外来务工者也没搬走。村里不提供暖气，有些村民则自己填煤供暖。但是冬天买菜吃饭却是个大问题，居民不得不乘车到十里开外的黄村一次买一周的菜。这种情况持续了一个多月。

直到村民向村里反映买菜难的问题，村委会才决定，允许本村村民在村中心地带的“超市”经营“菜市场”。菜市场里，除了日常的水果蔬菜外，油盐酱醋米面馒头也能买到。就这样，留在村里的居民才凑合着熬过了2017年的冬天。

![图片](https://i.loli.net/2018/11/19/5bf24bad7011d.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24bb056984.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24bb29b334.jpg)

<figcaption>4月8日，村里菜市场在超市内营业，广场上村民下棋聊天</figcaption>

最近，北京刚下过一场罕见的四月雪，雪化后，外出租房子的村民开始返村。由于拆迁赔偿事宜依然没谈妥，村里又给了3个月的租房补贴，让签字的村民出去租房住。而未签字的部分村民，已经开始向务工者租房子。江小梅和丈夫就租住在村子里。她在新建村卖菜，已经快1个月了。因为村里有需求，而且需求正在慢慢增大。

新建村又开始热闹起来。

但与5个月前，已不可同日而语。那时的新建村，繁华得像一座小城，六所幼儿园，十四家公寓，三十八家大小型超市。村里挨街挨户皆是各式各样的店铺，大到超市商场、美食广场、农贸市场、台球旱冰场，小到洗脚店、两元店、成人用品店、镶牙店，再到包子油条豆浆早餐点儿，蔬菜水果猪肉袜子摊儿。

百度街景地图还显示，5年前，刘明丽停车的这个十字路口挤占着数家摊点，有人卖西瓜，有人卖袜子，有人卖烧饼，有人卖玉米，有人卖苹果，有人开超市。

![图片](https://i.loli.net/2018/11/19/5bf24bb5b8942.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24bb804021.jpg)

![图片](https://i.loli.net/2018/11/19/5bf24bbb4bffd.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24bbdc59dc.jpg)

<figcaption>2013年的新建村街巷里摊店林立（翻拍自百度街景地图）</figcaption>

但如今，他们已不知去向，店铺绝大部分都卷帘紧闭。极少有像江小梅和孔令玲这样的，已经开始在路口租房卖东西。虽然她们并不清楚村里到底何时会拆迁，但听村民说，至少7月前是拆不了的。即使拆迁，对她们影响也不大，何时拆，他们何时走。只是这里房子便宜，月租300元。

江小梅到村里来卖菜的时候，已是三月中旬。最初她穿着红棉袄，坐在路边儿的台阶上摆摊。后来，她和丈夫决定在村里租房子住下，专门在村里卖菜。房东知道后，将门面免费租给她临时存放货物。5个月前，这里是一家叫阿珍精剪的理发店。

![图片](https://i.loli.net/2018/11/19/5bf24bc951791.jpg)

![图片](https://i.loli.net/2018/11/19/5bf24bcc13020.jpg)

![图片](https://i.loli.net/2018/11/19/5bf24bcfc9084.jpg)

<figcaption>4月9日早晨，新建村街角十字路口</figcaption>

孔令玲在新建村已经住了14年，但她并不是北京人，她的老家在河南兰考县。14年前，她被老乡“骗”来新建村的时候，女儿就近在村子里上过小学，村子里那时还都是平房。如今，女儿已毕业工作，街道两边都变成了楼房。14年里，她看着新建村厂子越来越多，店铺和人也越来越多多，街道也越来越拥挤。可一场火灾之后，村子彻底清净了。

顾方程是火灾发生后才到新建村的，他在村北4S店当保安。透过街道上的被砸烂的门店招牌，他也能想象曾经这里是多么热闹。早上，他照旧穿着蹭了半胳膊灰的保安服，从村西往路口走。他个子不高，穿着公司配发的保安服，像是套了件黑色大衣。看样子还没吃早饭，准备在刚被城管撵进村的煎饼摊上买早餐。

昨天孔令玲和他闲聊了半天，今天见面第一句就问：“你老婆呢？找到工作没？”顾方程有些扭捏地挠了挠头答道：“还没呢。”不仅媳妇没找到工作，他自己也被公司“停工”，老板让他先安顿好老婆。即便如此，他的生活依然很窘迫，甚至连吃饭都成了问题。如今已穷得只剩下昨天刚借的80元。

如果算上这80元，他来北京已经借了2080块，并且分文未还。其中的2000块，是他前后分5次向公司预支的：第一次老婆买被褥借200元，第二次老婆辞职住宾馆借500元，第三次自己生病借200元，第四次给老婆交水电费借200元，第五次在新建村租房子借900元。

![图片](https://i.loli.net/2018/11/19/5bf24bd99c73a.jpg)

<figcaption>4月9日，清晨，顾方程走在新建村的街道上</figcaption>

![图片](https://i.loli.net/2018/11/19/5bf24bdcb1218.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24bdfdf8e9.jpg)

被“停工”的顾方程，每天在新建村转悠，有时站在村北路口，有时去附近找新工作，有时就和卖水果的孔令玲聊天。孔令玲敦促他赶紧找工作，但是对于他来说，身份证还押在保安队老板手里，找份新工作“顾忌太多”。

早上8:30，村里新雇的清洁工正在打扫街道，八位胳膊上佩戴着“首都治安志愿者”红袖头的男人路过街角。煎饼摊主担心会被再次撵走，孔令玲让她打消担心：没事，我刚开始来，他们没撵，我也没走。”治安巡逻队并没说什么，就往村东走去。

孔令玲端着饭碗钻进了出租屋。顾方程在街角待了近20分钟，吃完煎饼，一个人蹲在台阶上。孔令玲从出租屋出来时，拎着自己卖货找零的钱包，准备去给别人送馒头。顾方程也离开了，他想和老板商量商量，调换成白班，或者要回身份证。江小梅还在菜摊前等待着，再过半个时辰，村子里买菜的人即将向她涌来。

（文中管国忠、谢宝堂、巩玉林、王德栓、胡廷贵、江小梅、刘明丽皆为化名）

## 3 夷平新建村

2018.11.9 北京市新建村

进入11月，有天晚上我做了一个梦，梦见自己又去了一趟新建村，结果新建村全拆完了。有两个姑娘还没进村就被拦下了，说村子已经封锁了，不允许外人进

谁知11月8日记者节那天晚上，村民就告诉我，新建村“基本上都拆了，有十几户特殊情况的没有签字。外面所有的人都不允许出入。”

![图片](https://i.loli.net/2018/11/19/5bf24be31d31e.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24be693c79.jpg)

11月9日，站在南六环上远眺新建村

第二天，我带上相机着急忙慌地奔去了新建村。果不其然，和4月份我见到的完全不是一个样子，新建村被两三米高的水泥墙围得严严实实，即将被夷为平地，墙内废墟一片。不时，有飞机从新建村上空掠过，还有偶尔飞过的喜鹊，和一台在村北废墟上扒爬着的挖掘机。

4月份来的时候，村北工业区拆得差不多了，但居民区不知是何原因一直不见动静，村里的幼儿园和小学仍然在正常上课。村民也一直没见到具体的拆迁补偿政策，又陆陆续续搬回了村里，连买蔬菜、水果、饼干的小贩都回来了。但他们知道，村里的拆迁随时可能启动，我也知道拆迁肯定会来临，只是不知具体时日。

但现在我有些懊悔自己没早些来看看。不仅是因为没能够记录新建村拆迁的最后一面，也是因为有书要还。之前在村里住时，借了一位老人几本关于大兴的书，但现在村子已经拆了，还没来得及还他。所以我决定想办法进去再看看，也许有人认识他，也许能够间接联系到。

![图片](https://i.loli.net/2018/11/19/5bf24bed29ed4.jpg)

11月9日，被封锁的新建村

![图片](https://i.loli.net/2018/11/19/5bf24bf02faa1.jpg)
![图片](https://i.loli.net/2018/11/19/5bf24bf4cc73a.jpg)

村子一圈都被墙围着，村西、村北留有一铁皮大门，门旁的保安室里，都有三四名保安日夜值守，而且只允许本村人出示身份证进入，外村人一律不得入内。

但最后经过死磨硬泡，还是如愿从村北牌楼下进入拆迁区，但要被保安看着。我沿着曾经走过的路，逐渐步入新建村的居民区。拆迁已经步入尾声，绝大部分房屋已经被推倒，村子里堆起两米多厚的一层砖瓦土砾、断壁残垣，少几座没拆掉的民居和公家的房子，还伫立在废墟之中。

废墟上已经分辨不清原先的街道与宅基地了。我只好去找那些没搬走的村民，村民告诉我，我要找的那个人，他们也不清楚。只说居民区的拆迁从9月就开始了，半个多月前新建村圈起来围墙，自己没搬走是因为还没谈好。后来我又去找了村委会，不巧村委会也已经没人了。

![图片](https://i.loli.net/2018/11/19/5bf26cae4a736.jpg)
![图片](https://i.loli.net/2018/11/19/5bf26cb843332.jpg)
![图片](https://i.loli.net/2018/11/19/5bf26cc3387fc.jpg)

11月9日，新建村基本上完成拆迁，空留废墟一片

![图片](https://i.loli.net/2018/11/19/5bf26cca9a9bd.jpg)
![图片](https://i.loli.net/2018/11/19/5bf26ccf817be.jpg)
![图片](https://i.loli.net/2018/11/19/5bf26cd7e92c7.jpg)
![图片](https://i.loli.net/2018/11/19/5bf26ce357f98.jpg)

![图片](https://i.loli.net/2018/11/19/5bf26cf436d89.jpg)

11月9日，一棵树孤零零地留在废墟上

![图片](https://i.loli.net/2018/11/19/5bf26cfa9fc32.jpg)
![图片](https://i.loli.net/2018/11/19/5bf26cff0277d.jpg)
![图片](https://i.loli.net/2018/11/19/5bf26d0bacb79.jpg)
![图片](https://i.loli.net/2018/11/19/5bf26d1a4487b.jpg)

11月9日，新建村被围墙封锁

村子里确实很难见到人影了，除了偶尔巡逻的保安，傍晚归去的少数村民等。菜摊和水果摊早就消失了。听说，签字同意拆迁的村民大都搬往附近的其他地方，比如团河、孙村、瀛海等等。

村里还有几位被雇来捡钢筋的工人，他们从废墟上挑拣出钢筋铁皮之类的废弃物，扛或者拉到村中心区域的超市门前堆着，再装车拉走。废墟上还停放着几辆挖掘机和推土机，不停地在工地上捯饬着。

![图片](https://i.loli.net/2018/11/19/5bf26d2eef2dd.jpg)
![图片](https://i.loli.net/2018/11/19/5bf26d39ca325.jpg)
![图片](https://i.loli.net/2018/11/19/5bf26d3ee340b.jpg)

![图片](https://i.loli.net/2018/11/19/5bf26d4e59c1c.jpg)

![图片](https://i.loli.net/2018/11/19/5bf26d60ddb8f.jpg)

11月9日，新建村内废墟一片

天色渐暗，落日的余晖洒在废墟的断壁残垣上。一个村子，就这样倒塌了，而后村民渐渐离散。入夜之后，新建村显得更加寂静了，犹如一座“鬼城”。几家没搬走的居民屋里，陆续亮起灯来。

在我准备离开的时候，竟然发现那位从东北来的网吧老板胡延贵（化名），还住在这里。算起来从火灾发生之后，他在这里待了快整整一年。网吧在他的坚守下，仍然没有拆掉。不过他和原先的房东已经协商好了，再过几日就要走了。听保安说，这里剩下的拆迁到2018年年底也要结束了，那时候，原来的新建村就彻底“死了”。

![图片](https://i.loli.net/2018/11/19/5bf26d721d0d4.jpg)

![图片](https://i.loli.net/2018/11/19/5bf26d7892093.jpg)
![图片](https://i.loli.net/2018/11/19/5bf26d8083746.jpg)

11月9日，入夜，新建村内犹如一座“鬼城”，荒无人烟

![图片](https://i.loli.net/2018/11/19/5bf26d8bbe403.jpg)

11月9日，已经开工建设的“创业之家”集体租赁住房项目不过在村东，离聚福缘公寓不远处的地方，一个新的项目工地已经搭建起来：西红门镇“创业之家”集体租赁住房项目。11月7日，微信公众号“西红门在线”上发布了一则该项目正式开工建设的消息。

消息上说，这个位于新建地区的项目主要是从城市蓝领、应届毕业大学生和双创人员等人群的需求角度出发，希望能全方面地为“首都创业者”提供“方便、温馨、安全”的居住环境。

我想，这肯定比不远处的聚福缘公寓更安全些，只是那些逃离新建村的外来务工者是否还会选择住在这里，就不一定了。亦或者他们在北京会有比新建村更合适的地方住吗？不得而知。

我出新建村的时候，夜幕已经降临，兴29路公交车恰好到新建牌楼站，我赶忙上车离开了这里。心想，这或许也意味着，新建村的“重生”，只是代价有些惨重罢了。

图文：豫广

2018年11月18日

未经授权谢绝转载

邮箱：1481260297@qq.com

![图片](https://i.loli.net/2018/11/19/5bf26d8f2b985.jpg)
