---

layout: post

title: 过去的中国，为什么大师辈出？

categories: Archive

date: 2018-10-27

tags: 新学记

image_feature: "https://i.loli.net/2018/11/10/5be6df4fa24b2.jpg"

description: 真正的教育，既不是指鹿为马，也不是指马为鹿，而是指鹿为鹿，指马为马，鹿有鹿的美，马有马的善

---

原文来自订阅号「经济观察报书评」：~~[过去的中国，为什么大师辈出？](http://wechatscope.jmsc.hku.hk:8000/html?fn=gh_e1bb55b2ce3f_2018-10-27_2656644272_CL04HbWvzF.y.tar.gz)~~

作者=云从龙

---

十年树木，百年树人。教育对国家、民族之重要性，毋庸置疑。中国自周秦至近代，文明之火生生不息，最大的所赖，莫过于教育。以此为基，教育家辈出，亦是不争之事实。既有赞成“因材施教”、“暮春者,春服既成,冠者五六人,童子六七人,浴乎沂,风乎舞雩,咏而归”自由且多元的孔子，也有主张“弟子不必不如师，师不必贤于弟子，闻道有先后，术业有专攻”平等而宽容的韩愈，更有倡导“致良知，知行合一”内外兼修的王守仁。可以说，教育家代代相继，对文化之传承与发扬，居功至伟。当然，尊师重教之传统，也伴随着历史的发展而深入人心，成为民族精神不可或缺的有机体之一。不过，当帝国的铁幕徐徐落下，结束了长达一百余年的革命、再革命甚至是重复革命之后，中国开始缓慢进入现代国家轨道之际，教育却不再那么尽如人意，至少看上去十分令人焦虑，无论是“李约瑟难题”还是“钱学森之问”，都令人困惑不已。尤其对于后者，因其关涉当下，更有如芒在背、如鲠在喉之感。如何解答钱氏之问？今人多有商榷，因视角、立场、论据各有不同，结论亦不同，有人看山是山，有人则看山不是山，还有人则由此山看到彼山，以风景殊异，而发古今之别。笔者以为，与其在没有标准答案、见仁见智的世纪难题上纠缠，不如反其道而行之，考察“钱学森之问”的另一面：过去的中国，为什么大师辈出？在我看来，这个问题的答案，在傅国涌的新著《新学记——中国现代教育起源八讲》（以下简称《新学记》）中完全可以找到。

![](https://i.loli.net/2018/11/10/5be6df4fa24b2.jpg)

《新学记》

傅国涌/著

东方出版社

2018年9月

“新学记”者，傅国涌认为，当有与《学记》呼应之意，但我更愿意将其与“旧学”相对而论。所谓旧学，即传统教育，以科考进仕为根本目的，如傅国涌所说，是“几千年积累起来的那一整套跟世道人心、王朝统治相匹配的教育模式”。厘清这一点，也自然明白“新学”之所指，便是科举退出历史舞台之后中国所迎来的新式教育，以及由此发展、演变最终转型成功的现代教育。据此而论，所谓“新学”，似乎应当包含两个部分，即新式教育与现代教育，但就具体事实来说，二者之间又并无明确的时间与空间上的界限，它不如新旧之学的分野因科举的废止而显得格外清晰，只能说，在经历了自晚清-民国将近一百年的实践与探索之后，现代教育之花终于翩然盛开，哺育出了极为璀璨夺目的文明成果。诸如1870年代出生的梁启超、张伯苓、王国维、杨度、陈独秀，1880年代出生的鲁迅、汪精卫、蒋介石、蒋梦麟、张君劢，1890年代出生的陈寅恪、竺可桢、郁达夫、傅斯年、叶圣陶、罗隆生，1900年代出生的冰心、巴金、沈从文、萧军、胡风，1910年代出生的费孝通、钱钟书、萧红、季羡林、殷海光，1920年代出生的张爱玲、汪曾祺、杨政宁、许良英、张思之，1930年代出生的资中筠、余英时、李泽厚、钟叔河、钱理群，等等，都是“新学”的硕果。在此基础之上，傅国涌更进一步，以当代视野去勘察“新学”的成果，将梁启超、鲁迅、陈寅恪、冰心、张爱玲、资中筠诸人用代际来划分，称他们为“七零后”、“八零后”……“三零后”之属，沿着这样的脉络下去，便很容易看到一个触及根本的问题：“现代教育不是突然发生的，它是在一个相当长的过程里慢慢展开、逐步演变的”，是经历了几代教育家矢志不渝的努力以及社会制度的变革而最终形成的。更重要的是，对于当代读者而言，通过回观新学代际展开和演变的成果，会禁不住向自身的境况进行投射与类比，即19世纪的八零后、七零后们与20世纪的七零后、八零后们，20世纪的零零后、一零后们与21世纪的零零后、一零后们所接受的教育有何不同？这个对比可能因人而异，但却是直观而具象的，它让我们一眼就能看出经由前后三个世纪的“头”与“尾”所串联起来的教育变革，孰优孰劣，孰好孰坏，也能够在一定程度上回答上文所提出的问题——过去的中国，为什么大师辈出？但是，仅仅这一点仍旧不够。

对此，傅国涌有着极为细致的观察与梳理。在第一讲《传统教育》中，他重点梳理了科举废止前夜，以“三百千”、《幼学琼林》、四书五经为为代表的经典教育对读书人的塑造，从中我们可以看到，尽管传统教育在知识结构和视野范围等方面都极为褊狭，但其对人心的滋润和关怀仍无处不在。更重要的是，在这一时期，传统教育正在悄然接纳和传播前所未有的新知识，如张士瀛在1901年编写的《地球韵言》，虽使用的语言仍为旧式，但阐述的却是全新的地理知识，这正是旧学与新学的交汇融通。在此之前，传统士大夫们所接受的世界观一直是天朝上国，万邦来仪，可想而知，当新的一代人，诸如郭沫若、吴宓、王若飞、萧公权、包天笑等读到“今天下，五大洲，东与西，两半球”时，将会对他们重新认识中国与世界产生何其深刻的影响。在第二讲《新旧交替》中，上述印象再次得到加深，但作者所考察的对象已不仅仅停留在“传统”二字上，而是扩展到了来华传教士身上。新式教育从何而来？现代教育的第一缕曙光怎样返照在古老的中国大地上？自西方各国远渡重洋而来的传教士们扮演了“传薪者”的角色。在北京、上海、天津、登州、苏州、烟台、保宁、太原、温州、九江等地，传教士们开办的学校遍地生根，培育了最早一代具有全球格局的中国人。其中很多学校，都成了中国现代教育以及知名大学的奠基石。第三讲《留学潮起》，追随着传教士的足迹，早期的中国留学生进入作者的视野，从最早的马礼逊学堂的中国学生，到后来的留美、留欧、留日学生，这一文明交汇、师夷长技的潮流整整持续了半个世纪之久。所造就的最直接结果是留洋归来，反哺民族，缔造现代中国，在教育上则是教育家勃兴（第四讲《教育家兴》），新式的小学、中学、大学如雨后春笋般拔地而起，教育的力量在这个阶段开始崭露锋芒。一个重要成果便是催生了课本革命（第五讲）。在傅国涌看来，“现代教育兴起的过程中，有一个重要的标志就是出现了现代的课本”，也就是我们今天所谓的“教科书”。但和今天不同的是，在整个现代教育兴起的过程中，课本革命这一重要的标志性事件的出现、探索乃至最后的完成都是由出版社（如商务印书馆、文明书局、中华书局、世界书局）和教育家（如张元济、蒋维乔、杜亚泉、叶圣陶、朱自清、吕叔湘）共同肩负的，而很少看到政府的身影，甚至在很长一段时期内，政府连统一指定使用某一种教科书都不会作强制性要求，而是任由学校自由选择，出版社自由竞争，教育家自由编写，学生们自由吸收。

如此宽松、包容和多元化的教育环境，没有带来我们惯常思维中的思想混乱、人心涣散，相反却带来了文明再造（第六讲），德育、智育、美育、品育、群育的全面发展，在春晖中学，学生们既可以听到丰子恺弹奏的《月光曲》，也能听到卢绶青老师讲的《白马湖的秋色》，学生们对美的追求正是在这样的涓涓细流中滋润出来的。在东吴大学，学生们除了学习功课，还有精彩纷呈的课外活动，辩论社便是其中之一。在上海中学，学生们组建了自己的口琴队。在南开中学，徐剑生老师将海顿、舒伯特、勃拉姆斯、李叔同的歌带进了教室，还帮助学生组建了男女声合唱团。在学校的校庆游艺会上，她组织大家唱了一首悲壮的歌：“为国捐躯男儿幸事情……桂冠加额极光辉……”。在傅国涌看来，“如果说中国过去的文明史先秦时代已经奠定的，晚清以后的中国面临着一次再造文明的抉择”，他将这一过程视为一场静悄悄的真正的校园革命，尽管时至今日它都没有完成，“我们还无法给出清晰的画面”，但其“终将给中国带来深远的变化”。事实上，这种变化不仅是深远的，更是广袤的，几乎深入中国的每一寸土地。从北京、上海、杭州、太原、武汉、南京这样的大城市，到南通、集美、荡口、太谷、天龙堡、张家渡、垦牧乡、南开洼、石门坎、甪直、白马湖、湄潭、李庄、碧湖、沙坪坝、华西坝、古路坝、竹篙塘、花明泉、楠溪江、雁荡山等这些知名或不知名的地方，现代教育的种子都在生根发芽，茁壮成长（第七讲《教育地理》）。由此来看，教育家兴、课本革命、文明再造，这一系列化学反应式的教育变革，绝不是仅仅局限于一时一地，而是发生于整个中国，进而带来了一场弃旧扬新的“知识重构”（第八讲）。就传统教育而言，读书人的知识结构，即使博通古今，上晓天文，下知地理，也不过是在经史子集中反复转圈，两千多年来，从未有人能逾越此藩篱，但现代教育则彻底瓦解了这一禁锢，它带给人们全然不同的思维、视野、能力和智慧，让人们了解到世界上的知识，不仅仅只有经史子集，而且还有物理、化学、算学、几何、音乐、哲学、法学、农学、工程学、经济学、教育学、语言学等等，也让人们对读书这件事有了全新的看法，读书不再唯“封侯拜将”是，还可以成为科学家、化学家、工程师、诗人、老师、音乐家、政治家、律师、医生等等，这些职业每一个都要比“封侯拜将”高尚。正如作者引用杨绛在东吴大学年刊上所展望的那样：“我们中的有些人，在吸取了永恒美丽的精神后，将展现我们时代新的风采，将为宇宙增添新的魅力。有些人，以科学的方法，会揭开那未知将来的神秘面纱，去探寻未知的世界。有些人，将利用法律去处理灾难性的政治问题，利用这有效的工具，去保护人民和国家。还有些人，将以熟练的医道，用知识和爱心去救治病人和穷人。”

《新学记》有关现代教育起源的探索，涉猎视野之阔，涵盖范围之广，可以说触及了现代教育的方方面面，作者倾一己之力，反复向我们证明一个事实：自晚清时期发轫的现代教育革命对于中国社会的影响和改变，不是浅尝辄止的，而是深入肌理的；不是蜻蜓点水的，而是面面俱到的；不是一蹴而就的，而是循序渐进的。即使到了今天，这场教育革命仍在持续。比如就“知识重构”而言，傅国涌注意到了知识翻新对古老中国带来的变化，而在当下，是否也有一场静悄悄的“知识重构”正在发生呢？今天，对于大多数人而言，仅仅接受基础与高等这两个阶段的教育是远远不够的，更多的是永远在路上的“终生教育”。与此同时，今天的人们获得知识、接受知识途径已不再局限于书本与学校，互联网打破了技术壁垒，为终生学习提供了极大的便利。在这个过程中，经由过去漫长岁月而形成的认知误区正在得到修正，例如对于从小就津津乐道的“四大发明”，我们现在对它有了全新的认识：中国历史上不只有“四大发明”，还有远比其更辉煌更灿烂更值得大书特书的科技成果。又比如富兰克林没有在雷雨天做过测试闪电的实验，西晋时期的“五胡乱中华”并不是民族融合而是一场针对汉族政权的种族屠杀，等等。可以想见，在封闭的时代，这些知识不可能得到翻新以及广泛的传播，而在当下，互联网给了我们这样的便利，帮助人们逾越了知识垄断的高墙，看到了不一样的世界。从根本上说，“知识重构”就是一个启迪民智、启蒙思想的过程，也是教育的根本所在。一如傅国涌所说，《新学记》这本书，它希望读者能够“看见过去，看见自己，看见时代”，而看见过去与自己并不是最重要的，最重要的是看见时代和未来。“在这个时代里我们能做点什么，在一个充满了不确定性的时代，一个人还能做点什么？”就教育的使命与当但而言，这个发问是发人深省的。

最后，让我们再次回到本文开端，尝试为那个“反向思维”的问题给出一点答案——过去的中国，为什么大师辈出？事实上，这个问题的本质应该是：什么是真正的教育？《新学记》开篇，傅国涌就做过一个有趣的比喻，真正的教育，既不是指鹿为马，也不是指马为鹿，而是指鹿为鹿，指马为马，鹿有鹿的美，马有马的善，也就是说，教育的终极目标是追求真善美，它从来不应因世易时移而改变，相反应该在“不断变化中寻找不变的价值”。在此之上，社会应该给予教育足够的空间与自由，让懂教育的人去办学校，让爱学生的人去做老师，让有学问的人去编教材，只有这样，教育才能真正的深入人心，驱赶愚昧，为社会带来希望。

从过去到现在，我们从未排斥过真正的教育，从未放弃对真善美的执着。只是有些时候，“真正”二字，离我们很近，有些时候，离我们很远。反躬自省，现在，它离我们是远还是近呢？

* * *

经济观察报书评  

eeobook

**阅读有难度的文章，每天成长一点点**

合作及投稿邮箱：eeobook@sina.com

![](https://i.loli.net/2018/11/10/5be6df513ada1.jpg)

长按识别二维码

**纸城。有趣，但不低俗；严肃，却不正襟危坐。这里有一些拒绝无病呻吟的文艺生活，一捧拿得起放不下的审美趣味，或者再加一点无伤大雅的吃喝玩乐。欢迎入住纸城，让我们轻盈、透明地生活在别处。**

![](https://i.loli.net/2018/11/10/5be6df525ea99.jpg)

**长按二维码可识别关注paper-city**
