---

layout: post

title: “国进民退”引爆辛亥革命

categories: Archive

date: 2018-10-03 12:00

image_feature: "https://i.loli.net/2018/10/03/5bb4b6363acc7.jpg"

tags: 国进民退

description: 在清末“国有”与“民营”的斗争中，国家、政府的力量强如压卵之石，商民只能设法谋官才能维持自己的权利。而商一旦成了官，往往会如盛宣怀那样，反过来又以政府的力量为自己谋利。这样，官、商的界限便永难划清，腐败也将日甚一日。

---

原文来自「东方历史评论」，作者「雷颐」：~~[“国进民退”引爆辛亥革命](http://wechatscope.jmsc.hku.hk:8000/html?fn=gh_ff1623af2f0e_2018-10-03_2654515131_JvBPb7ySMu.y.tar.gz)~~

---

> 各位读者：
>
> 假期快乐。
>
> 东方历史评论除主力微信公号（ohistory）外，还运营着[几位学者的公号](https://mp.weixin.qq.com/s?__biz=MjM5OTA5MzAwMQ==&mid=2654508519&idx=2&sn=09c4590cb7df52a30f6f899d0ef4b82e&scene=21#wechat_redirect)。假期期间，我们将精选学者公号内容与各位分享，祝各位阅读愉快。

撰文：雷颐

《东方历史评论》微信公号：ohistory

甲午战争前，清政府一直严厉禁止私人创办新式企业，李鸿章采取“官督商办”的变通形式，使私人得以参与新式工商业的创办与经营。这是中国现代“民营”的起点，但毕竟又头戴一顶“政府”之帽，埋下了以后“产权不清”的隐患。

甲午战争中国惨败，引起了中国社会的巨大震动，一些有识之士认为应象日本那样发展民族私营企业才是强国的根本；同时由于清政府与日本签订了丧权辱国的《马关条约》，允许外国可在华设厂投资，于是不便继续禁民间设厂；再加上清政府此时财政极为困难，无力“官办”新式企业，清政府在危机面前不能不公开改变以前禁止民间办新式企业的政策，颁布了“饬令招商，多设织布、纺绸等局，广为制造”的电旨。

而1895年8月，光绪皇帝颁布诏书，敕令官办企业“从速变计，招商承办”，更开启了清末官办企业私有化之端绪。这些使中国民族资本主义较前开始有了较快件的发展，中国出现了一个民间兴办新式工业的小浪潮。

清政府虽然此时制定了种种政策、法规，成立有关机构以奖励、发展私营工商业，使私人企业这一阶段相对发展较快，但其内部其实一直又有股强大的力量反对私营企业。因此清廷这时的经济政策是对纺纱、碾米、造酒等等这类于“国计”影响不大的行业放开民营，而对航运、电报、铁路这类于“国计”有重大关系、原本“官督商办”企业则一直摇摆不定。

因为官督商办是1872年李鸿章为了突破官无资金、不会经商，而有资金、有经商才干的商人没有合法办近代企业之权的困境，“遇到红灯绕道走”想出的一个变通办法，简单说就是由政府出面，商人出资办近代企业，“官为维持”“商为承办”，即官府督办，商人自筹股资，并且具体经营。用今天人们熟悉的语言来说，就是“戴红帽子”。

这种企业一个天生的缺陷就是产权不明，对这类企业，清政府内部一直就有两种不同观点：一种观点认为这是国有企业，官家自可任意处置，因为本来就是以政府之名而设，而且在经营过程中得到政府的多种优惠待遇，甚至享有某种垄断权。更重要的是，他们认为私人资本强大之后，将削弱统治者的统治力量。

另一种观点则认为私人资本强大反会使国家富强，朝廷统治基础更加巩固，而且这些企业是商家出资经营，理应为商家所有，国家不应收回，如果收回，应给商人合理的补偿价格。两种政治力量斗来斗去，一时这派占优势一时那派占上风，直到甲午战后同意发展私营企业但对“官督商办”企业的“性质”仍无定论，结果必然是清政府在重大经济政策上的大幅度摇摆，最终成为清王朝垮台的导火线！

两种力量的激烈交量与斗争，集中表现在“轮电之争”和“铁路之争”。

## 1. “轮电”之争

“轮电”之争中的“轮”，是指“轮船招商局”。

1872年创办的“官督商办”轮船招商局大获成功，在此鼓舞下，洋务派又兴办了一批官督商办企业，有些官办企业后来也改为官督商办。但清政府内反对官督商办的顽固派依然十分强大，一直想将这些企业完全收归国有。

![01.jpg](https://i.loli.net/2018/10/03/5bb4b635d94cb.jpg)

<figcaption>轮船招商总局</figcaption>

1877年山西道御使董儁翰奏请“轮船招商局关系紧要，急需整顿”，提出要收归国有，由南北洋大臣统辖。招商局成立以来，参劾招商局的奏本便一直不断，此奏一出，更得到许多官员响应，纷纷要求收归官办，起码要加强政府的监督控制。

面对这汹汹群情，李鸿章立即坚决反驳，他提出办招商局是“为收回中国利权起见”，“商局关系国课最重”，如果任意干扰，“殊于中国商务大局有碍”。

在首先强调招商局对国家富强的意义之后，他接着辩解说招商局全是商股，创办时就奏明“盈亏全归商认，与官无涉。诚以商务由商任之，不能由官任之也。轮船商务，牵涉洋务，更不便由官任之也。”由于李鸿章的坚决反对，此次收归国有之议不了了之。

1880年国子监祭酒王先谦又上奏弹劾招商局，认为企业“归商不归官，局务漫无钤制，流弊不可胜穷”，再次提出要收归官办。这一次次弹劾，引起的呼应比上次要强烈得多。

李鸿章知道最为反对者忌恨、最为朝廷所担心的是这类企业对统治者的政权所起的作用究竟是巩固还是削弱，所以他首先详细列举几年来该局的成就，证明正是招商局使洋人在长江水运所得之利大为减少，因此强调“其利固散之于中华，关于国体商务者甚大”，当然使统治者的政权更为巩固。

有趣的是，李鸿章在此折中用得利的是“中华”而不用“华商”，说明他深知朝廷对“华商”等私人获取巨额利益仍心存警戒，所以刻意回避“华商”这种容易联想到私人的词汇。在激烈争论中回避朝廷敏感的字眼儿，当然更容易赢得朝廷的支持，而且华商得利确也可说是“中华”得利。一词之选，煞费苦心，反映了李鸿章写奏折的老练。

然后，李鸿章才从有关章程、规定说明政府应遵守早先订立的章程，如果“朝令暮改，则凡事牵掣，商情涣散，已成之局，终致决裂，洋人必窃笑于后，益肆其垄断居奇之计。是现成生意，且将为外人所得，更无暇计及东西洋矣！”

值得注意的是，他强调政府遵守章程必要性的立论基础主要不是政府也必须遵守条约的“契约论”，而是一旦违约、生意受损的后果将是洋人垄断得利这种“民族主义”话语。

因为他很明白，朝廷根本不会将政府与私人所订之约放在眼里，不会将此作为一个决策的参考因素，只有这种与朝廷根本利益有关的“民族主义”话语才是打动、说服朝廷的最有力的理由。所以，他强调一定要坚持“商为承办，官为维持”，如果开始垫有官款，则“缴清公款”后“商本盈亏与官无涉”。

当然，他又一再表明“并非一缴公帑，官即不复过问”，而是强调官仍要尽督管之责。其实，这类企业的问题就在于政府从未放弃管制，干预太多，只是顽固派要求国家所有制应纯而又纯、容不得丝毫私人因素才会认为“商”的权力过大。李鸿章的观点，得到权力越来越大的“总理衙门”的支持，轮船招商局仍维持官督商办，而未被收归官办或官商合办。

十几年后，即甲午战后的1896年，李鸿章因甲午大败为万民所指、被清廷投闲散置，大权尽失。这时，御史王鹏运认为时机来临，上奏请特派官员到招商局“驻局办事”，有些现在派“工作组”的意思，虽未明说，实际意图仍是收归官办。但“总理衙门”以“若无商局，则此利尽属洋商。是该局收回利权，实明效大验。”反驳了王鹏的建议，维持了官督商办原状。

所谓“电”，是指创办于1880年的“电报总局”。架设电线、成立相关机构对近代以来一直军情紧急的清政府本是重中之中，但与所有新事物在近代中国的命运一样，因顽固派认为这些是西方的奇技滛巧不能学而迟迟未有进展。

李鸿章于1879年在自己的辖区内试架短短一线，后又于第二年藉沙俄准备侵略新疆伊犁以“电报实为防务必需之物”上奏请敷设电线。在这种情况下，清廷才批准架线设局。1880年10月，电报总局在天津成立，标志着中国近代电讯业的诞生。

官办电报局经营未久，便面临经费严重紧张问题。在李鸿章的支持、筹划下，电报总局于于1882年春改为官督商办。改制后的电报总局，完全是商股商办。

或许因为轮船招商局创办在先，容易成为众矢之的，而成立稍后的电报总局命运则相对平稳，在1902年前未遇将其“收归国有”之议。

1902年秋，李鸿章病逝未及一年，新任直隶总督、北洋大臣的袁世凯开始设法要将轮船招商局和电报总局收归国有。袁以强硬著称，主张“强政府”，由政府兴办新式企业，所以想办“北洋”的官督商办企业都收归国有，增强政府、同时也增强自己的实力。此时，轮船招商局、电报总局的经营者盛宣怀父亲病故，袁世凯乘盛丁忧守制之机，夺去了盛宣怀的“督办”之职

刚开始，清中央政府想派人将轮、电二局收归“央企”，以利中央财政，对此盛宣怀坚决反对，错误地想争取“实力派”袁世凯的支持。袁世凯当然也反对将此二局收归中央，但他的真实想法是一定要将其收归“北洋”，即“地方国企”。

盛宣怀是个复杂异常的人。他是李鸿章的心腹幕僚，精明超常，本身即是官员，对官、商两界都非常熟悉，深谙为官之道与经商门路。李鸿章、乃至后来张之洞创办企业，都对他十分倚重。他于1885年担任招商局督办，与前任相比，他主政时的“官督”大为加强，官的色彩较浓；但与那些要完全官办的人相比，他又是“商”的代表，坚决反对“官办”。

这种亦官亦商的两面性，在他的官、商生涯中表现得非常明显。早在1894年2月初，他奉李鸿章之命接办官督商办的上海机器织布局时就担心企业办好后为官收回，向李建议道：“股商远虑他日办好，恐为官夺，拟改为总厂，亦照公共章程，请署厂名，一律商办。”以前的企业都是“局”，“局”乃官方机构名称，“厂”则是企业名称。

由“局”改“厂”，一字之易，却是大有讲究。李鸿章同意盛的方案，将其改为“华盛机器纺织总厂”。1901年，由于棉花价格猛涨，工厂亏本，盛宣怀串通两江总督刘坤一上奏称由于亏损严重，“自应准其另招新商顶替，改换厂名，再接再厉”。经清政府批准后，盛宣怀以原价买下自己股权占优、一手经营的企业，改名为“集成纺织公司”。

上海机器织布局――华盛机器纺织总厂――集成纺织公司，此厂终于从产权不明的“官督商办”经过逐步改制变成了产权明晰的盛氏“私产”。对他的这种改制是“合法”还是“非法”，是否“化公为私”或曰“侵吞国有资产”，一直争议不断。

![02.jpg](https://i.loli.net/2018/10/03/5bb4b635f36e2.jpg)

<figcaption>上海机器织布局</figcaption>

而吊诡的是这两种观点确实各有道理，正说明了在社会转型期造成了“制度灰色地带”，很难以简单的非黑即白来作判断。今天许多“戴红帽子”企业其实也是如此改制，盛氏百余年前的手法依然适用，历史何其相似乃尔！

由于早就担心这些“官督商办”企业可能被收归国有，盛宣怀在经营轮、电两局时就多次想法设法将盈利及各项收入转为商股，以便万一将来政府按票面价值将轮、电二局购归国有时，包括他在内的股东利益不至损失太大。

然而，此时“商人思维”的盛宣怀面对的却是“强政府思维”的袁世凯，他根本无意按股票票面价值将官督商办企业收归国有。1903年1月中旬，袁世凯被清廷派为电务大臣接收电报局。袁世凯以政府资金紧张、无法全付商股为由，表示商人仍可“附股一半”，而另一半商股则以大幅度煞价“购回”。

此法一出，商情哗然，但毫无办法。但此时清政府因要支付巨额“庚子赔款”连超低价的“价购”都付不起，在降旨袁世凯接收之时宣布：“该局改官办之后，其原有商股不愿领回者，均准照旧合股”，对这种完全的“商股官办”朝廷还说是在维护即有体制之中“寓体恤商情之意”。无论盛宣怀及众商人多么不满，想出种种办法，都无法改变收归官办的命运。袁世凯的基本思路是：取之于商，用之于官。

接收完电报总局，袁世凯紧接着就强迫盛宣怀辞去招商局督办之职，派自己的亲信杨士琦担任该局总理。这样，袁世凯通过将电报局收归官办、轮船招商局由他派人督办从而将这两个大型企业实际收归“直隶”所有。

以前有李鸿章作靠山，盛宣怀做事一直顺风顺水，现在靠山已去、且面对的是“强势政府”袁世凯，自然毫无招架之力，顿时败下阵来。他当然不甘就此作罢，于是暗中准备，窥测时期，以图夺回企业。

他本来就是亦官亦商，现在对“官”权之大的体会更深，于是在积极联络股东的同时又向大太监李莲英巨贿买官，终于在1908年3月授邮传部右侍郎。铁路、电报、航运和邮政都归邮传部管，盛氏顿时权力大增。

有了权后，他首先联络电报总局的入股商人与政府交涉，要求退还收归官办的电报总局的商股。经过一番讨价还价，清政府最终按每股180元的价格将全部股票从股商手中买回，股商挽回部分损失。

就在这年11月，光绪、慈禧相继去逝，政坛风云突变，袁世凯骤然失势，被贬归家，盛宣怀明白机会来临，于是开始努力夺回招商局。在被袁世凯收归官办的短短几年中，轮船招商局亏损严重，不仅未添几艘船支、未增加一处码头、栈房，反而不得不将上海浦东、天津塘沽、南京下关的码头卖掉。

盛宣怀以挽救招商局为理由于1909年8月在上海召开股东大会，会上“组织商办隶部章程”，“注册立案”，并选盛宣怀为董事会主席。会议上报后，邮传部（盛宣怀任右侍郎）复电承认轮船招商局“本系完全商股”，同意其设立董事会。招商局终于完全商办。

在“轮电之争”中，中央政府、地方政府和商人都尽力争取自己的利益，在“产权不明”混沌状态下，自然是谁的力量大，权益就归谁所得。

## 2. 铁路之争

铁路最开始引入时受阻力最大，但铁路的巨大利益终于显示出来，成为各方争夺的对象，因此铁路的“国有”与“民营”之争渐渐成为斗争的焦点。

修路耗资巨大，财政极为紧张的清政府根本无此力量，所以又不得不招商股，而更多靠举借外债。1905年秋，湖北、湖南、广东三省民众集股从美商手中收回了粤汉铁路利权，朝廷也曾下令这三省由商民集股兴建铁路。而1904年在成都成立的官办的川汉铁路公司也于1907年改为商办。

湖南、湖北主要是绅商集资，广东主要是华侨商人集资，而四川的股本来源主要靠“田亩加赋”，靠“抽租之股”。抽租的办法一般是随粮征收，值百抽三，带有强制征收、集资的性质，贩夫走卒，都被迫参与。这样，全川民众无论贫富，都与汉川铁路有紧密的利益关系。

而清政府一方面允许民间自办铁路，另一方面又于1908年任命调入军机处的张之洞为粤汉铁路督办大臣，不久又命其兼督湖北境内的川汉铁路，实际又企图把铁路改为官控，遭到这几省民众反对，领导者恰恰是清政权的统治基础地方绅士和富商。在地方强烈反对下，清廷于1909年末和1910年初又先后准许粤汉、川汉铁路民办，于是入股民众更多。

![03.jpg](https://i.loli.net/2018/10/03/5bb4b6363acc7.jpg)

<figcaption>粤汉铁路</figcaption>

然而仅仅一年，“立宪运动”已经风起云涌际，清政府却又不顾广大民众的强烈反对，于1911年5月在新任邮传部尚书盛宣怀的主张下悍然又宣布“铁路干线国有”政策。几年之内，于国计民生大有干系的铁路政策竟如此反反复复，清政府真是“自寻短见”。

一石激起千层浪，不久前还同意铁路民营、允许民众大量入股，现在突然宣布“国有”，广大股民认为这是政府有意设套圈钱，怒不可遏，轰轰烈烈的“保路运动”应声而起。使问题变得更加严重的是，财政极其困难的清政府根本无力给股民以合理（或者说让股民满意）补偿，而只能以折扣的方式，即以远远低于股民实际投资额的方式赎买股份。

清政府对湖南、湖北采取的倒是路股照本发还政策，由于绅商损失不大，所以最先兴起保路风潮的“两湖”却也最先平息。而广东路股，清政府只发还六成，不过由于广东股商主要为华侨，在备感愤怒之下一走了之，却也未有更大波澜。

对四川路股，清政府采取的也是“低价”政策。由于入股的中下层民众最多，所以四川反抗“铁路国有”的风潮最为炽烈，“保路运动”风起云涌。正是清政府派兵镇压保路运动，引爆了武昌起义，最终成埋葬清王朝的辛亥革命的导火索。

值得再次一提的是，当年极力维持商民利益的盛宣怀一旦就任邮传部尚书，观念即随地位的变化而变，成为“铁路国有”的主要策划者。因铁路属邮传部管，一旦铁路“国有”，邮传部的“地盘”、实力将大大扩充。在“国有”的名义下，实际是为了他的个人利益，并不考虑在各种矛盾已经十分尖锐激烈的情况下强行此项政策将危及整个王朝的利益甚至统治的根基。

在清末“国有”与“民营”的斗争中，国家、政府的力量强如压卵之石，商民只能设法谋官才能维持自己的权利。而商一旦成了官，往往会如盛宣怀那样，反过来又以政府的力量为自己谋利。这样，官、商的界限便永难划清，腐败也将日甚一日。

最先起来保路的“两湖”之所以最先平息，因为清政府对“两湖”实行的是路股照本发还政策，这也说明“民营”并非刻意反对“官营”、反对政府收购，只是政府也应尊重契约、尊重市场规则、尊重“等价交换”。而清政府秉承中国“强政府”政治传统，毫无契约意识，认为自己权力无限、强大无比，手操对民企的生杀大权，更可对其予取予夺。

正是在这种观念主导下，才可能做出以低价“收买”四川民营铁路股权的错误决定。它以为自己“低价收买”降低了成本，其实是付出了巨额代价，即以政府信用为代价，代价之高，难以想象，最终付出整个王朝作为代价。

导致清王朝灭亡的因素当然很多，从经济层面上说，先是为民营经济发展设置重重障碍，而后虽允许民营经济发展、但政策却又极不稳定经常大幅度摇摆，不能不说是重要原因之一。经常的大幅度摇摆，根本原因是清政府面对社会转型、面对从农业经济向近代工商经济转向这种深刻的结构性变化、面对新崛起的近代工商阶层完全不知所措，因此制定不出一个基本稳定的经济政策，更谈不上基本稳定的制度建设。由于没有稳定的政策和制度，结果必然是“人治”。而政坛风云向来变幻莫测，今天赞成商办的官员得势，政策自然是“商办”导向；明天力主国有的官员上台，政策立即转向“国有”。

经济政策和制度是最重要、最基本的社会政策和制度，能否制定出大致稳定的经济政策和制度，是统治者执政是否成熟的基本标准。没有大致稳定的经济政策和制度，人民不会安居乐业，社会没有安定和谐，统治者的政权基础自然也不可能巩固。清末的历史再次证明了这一点。

《商务叹》：“轮船招商开平矿，创自商人尽商股。办有成效倏忽变，官夺商权难自主。总办商董举自官，不依商律由商举。律载大事应会议，三占从二有规矩。不闻会议集众商，股东何尝岁一叙？不闻岁举查帐员，股息多少任所予。调剂私人会办多，职事名目不胜举。不洽舆情无是非，事事输入糜费巨。用非所学弊端多，那得不受外人侮？名为保商实剥商，官督商办势如虎。华商因此不及人，为丛驱爵成怨府。”（夏东元编：《郑观应集》（下），上海人民出版社1988年版，第1369页）

“富强由来在商务，商出农工须保护。商律颁行宜认真，精其事者管商部。”

“轮船招商开平矿，创自商人尽商股。国家维持报效多，试看日本何所取。办有成效倏变更，官夺商权难自主。”

“电报贬价归国有，不容商董请公估。轮船局权在直隶，商欲注册官不许。总办商董举自官，不依商律由商举。”

“名为保商实剥商，官督商办势如虎。”

**雷颐微信公号：lyyzgj**

![04.jpg](https://i.loli.net/2018/10/03/5bb4b635c3a1c.jpg)

![05.jpg](https://i.loli.net/2018/10/03/5bb4b635c3618.jpg)
