---

layout: post

title: 中国的儿童性侵到底有多严重

categories: Archive

date: 2018-08-07

tags: MeToo

image_feature: "https://i.loli.net/2018/08/07/5b69ae0410cd4.jpg"

description: 在中国，儿童性侵的现实已经一再揭示出，貌似平静的海面之下，其实潜伏着巨大而沉默的冰山。

---

文章来自微信公众号「三联生活周刊」

文 \| 王海燕

---

这两天，一个名叫趣动旅程的夏令营曝出丑闻，营中某男教练被指猥亵女童。爆料人称，作为孩子妈妈，当“Me Too”运动发生在媒体圈、大学里、甚至龙泉寺，她依然有种作壁上观的感觉，但家长群的爆料让她明白，这件事人人都无法置身事外，每个人都可能成为猥亵的受害者。

事实上，这几年，“儿童遭受性侵”是令人瞠目结舌的个案但又转瞬即逝的热点社会新闻。迄今为止，中国依然没有针对儿童性侵的全面数据调查，但那些提供儿童防性侵教育的公益组织、维权律师、后期援助的心理咨询师、专业社工们都发现，在中国，儿童性侵的现实已经一再揭示出，貌似平静的海面之下，其实潜伏着巨大而沉默的冰山。

![01.jpg](https://i.loli.net/2018/08/07/5b69ae0410cd4.jpg)

很多人的一大困惑是，为什么最近性侵儿童的事件变得如此频繁。在“女童保护”公益项目发起人之一的“凤凰公益”主编孙雪梅看来，这其实完全是来自于媒体热点的错误印象，因为即使以媒体曝光为标准，儿童性侵的案例这些年来一直都非常频繁。

孙雪梅和一批记者成立“女童保护”的初衷来自2013年5月的“校长带女生开房案”。当时海南省万宁市后郎小学6名六年级女生集体失踪，后经调查发现，这6名女生是被万宁市第二小学校长陈在鹏及万宁市一政府单位职员冯小松带走开房了。孙雪梅清楚地记得，在这起案件曝光后的20天里，媒体又曝光了另外7起校园性侵案件，涉及省份包括安徽、山东、河南、湖南、广东，其中甚至有幼儿园保安猥亵幼儿园儿童。

当时孙雪梅和一些记者在群里讨论，最大的感受是愤怒、悲哀又无能为力，最终大家决定做点什么，于是联合了百名女记者，发起了“女童保护”公益项目。和国外对儿童性侵的社会认知历程一样，在中国，记者同样是最早敏锐发现儿童性侵普遍和严重程度的主要群体。

但除了因为身处媒体，对性侵儿童案件有更多的关注，孙雪梅实际上还有切身的经验。原来她在上小学时，曾亲眼看到有10多岁的小男生哄骗更小的女孩实施性侵。她那时候已经开始隐隐感觉到这种行为有哪里不对，但因为缺乏相关教育，她完全不知道如何应对或者阻止发生在眼前的事情。

![02.jpg](https://i.loli.net/2018/08/07/5b69ae0555e6f.jpg)

<figcaption>2013年9月4日，“女童保护”公益项目发起人孙雪梅在云南大理漾濞县给孩子们上“防性侵”课</figcaption>

正是来自切身的经验和对当前儿童性侵现状的考量，在“女童保护”成立后，他们将防性侵教育作为重点推广的理念和活动。但与此同时，她们发现国内并没有较权威的儿童性侵数据统计，因此，“女童保护”也开始收集包括媒体曝光、法院和检察院公布的儿童性侵案等案例，并从2014年开始发布年度报告。这份年度报告也是目前媒体引用最多，公众认知最熟悉的儿童现状报告。

**根据“女童保护”的统计数据，从2013年至2016年，媒体公开报道的性侵儿童（14岁以下）案件就有1401起，平均每1.04天就曝光一起案件，受害人数超过2568人。受害人数并非确数，在“女童保护”的统计数据中，性侵多人的均按3人计算，但实际上，光2015年一人性侵10名以上儿童的案例就有14起**。

但和“女童保护”由媒体人发起，且一开始就直接关注儿童性侵领域不同，在我们采访的其他相关机构里，无论是做法律援助的，还是后期做深度救助和心理干预的，都是因为偶然契机切入到儿童性侵领域后，才发现儿童性侵的严重性。这也和公众对儿童性侵的认知完全一致，即只要关注到这一领域，就会发现，海面之下有着巨大的冰山。

做法律援助的李莹告诉本刊，北京源众性别发展中心最早主要是关注妇女儿童暴力，但李莹很快发现，儿童性侵的现象非常普遍且情节严重。迄今为止，源众已经介入了7起儿童性侵案件，包括湖南益阳市赫山区八字哨镇学校科学课老师性侵19名女童、广西百色助学达人王杰多年性侵多名女童。这些案件虽然几乎都曾引起一时的巨大轰动，但又很快被忘记了。而在介入过程中，李莹还发现，几乎所有的案件取证都非常困难，其中广西百色助学达人王杰性侵儿童一案的重要证据，甚至来自王杰本人录制的视频，这让她意识到，儿童性侵在中国可能非常普遍且隐秘。

![03.jpg](https://i.loli.net/2018/08/07/5b69ae06064bd.jpg)

<figcaption>图 | 视觉中国</figcaption>

儿童希望救助基金会的真爱儿童社工服务项目是目前国内少数做儿童性侵后期救援的公益组织，项目负责人李梓琨告诉本刊，她的经验同样如此。2012年儿童希望基金会成立这一项目时，主要目的是做受虐儿童专业救助，但成立后接到的案例几乎都是儿童性侵，于是儿童性侵自然而然成为项目的主要关注领域。因为需要对案例进行深度介入，耗费的时间和精力都极其巨大，真爱项目甚至不敢大规模接受求助，因为在接触这一领域后，李梓琨发现，案子实在太多了，几乎遍地都是。

隋双戈同样是做儿童性侵后续干预的。2005年他发起“春风计划”，关注的是强奸受害者心理干预，希望为强奸受害者提供帮助，虽然他一开始就关注到中国妇女被强奸后报案率很低，但他当时并没有注意到儿童性侵的问题。直到2008年，他收到了一个求助，一名四川的留守儿童遭到了老师性侵，持续时间还很长，被一个亲戚在日记中发现后报警。但在第一次公诉后，这名老师却被无罪释放了。受害儿童的父母非常不满，找到春风网求助，春风网的律师随后介入，并同时在网上发帖曝光，引起当地司法部门重视。最终案件经过重新审理后，那名教师被判处强奸罪。但在案件的审理过程中，隋双戈发现，那名老师性侵的并不止报警的这名小女孩，但最终却没有更多小孩站出来指认老师的罪行。那时，他才注意到，原来国内的儿童性侵如此严重，并且具有巨大的隐蔽性。

![04.jpg](https://i.loli.net/2018/08/07/5b69ae0558aa9.jpg)

<figcaption>图 | 视觉中国</figcaption>

因此，几乎各个机构都能说明，虽然“女童保护”的数据是目前被引用最多的报告，但因为儿童性侵本身的隐蔽性和媒体报道的选择性，其代表的情况可能只是冰山一角。女童保护儿童性侵数据整理和收集负责人之一徐豪告诉本刊，他们曾在2015年向媒体提供过一些案例，多为猥亵，但因为证据或者案情本身的种种原因，基本无法曝光。

更准确一些的数据来自公检法部门。迄今为止，公检法部门两次公布过全国的儿童性侵案件数据，其中之一是最高人民检察院在2014年儿童节公布的数字：2010〜2013年，全国检察机关起诉猥亵儿童罪7963件8069人，起诉嫖宿幼女罪150件255人，起诉引诱幼女卖淫罪68件121人（如果在2015年11月后，这两项罪名均会变更为强奸罪）。这也是我国公检法机关首次公布有关儿童性侵案件的数据。

三年后的2017年6月1日，中国人民最高法院公布数据，称2013年至2016年，全国法院共审结拐卖妇女、儿童犯罪案件3713件，审结猥亵儿童犯罪案件1.0782万件。但这里的性侵儿童数据并不包括强奸这一更加严重的犯罪手段，因为迄今为止，每年的最高人民法院工作报告里，强奸儿童依然是和强奸妇女、拐卖妇女儿童的数据合并统计的。但即便如此，也可以看出，儿童性侵案件是拐卖妇女儿童案件的近3倍，且光结案量就比2013年前检察机关提起公诉的案件还多。

但因为中国谈性色变的文化土壤和尚称不上完善的法律体系，进入公诉阶段的案件同样占比微小。广泛被引用的中国儿童性侵隐案率为1∶7，媒体据此称中国每一次曝光的儿童性侵背后，起码还有7起未得到曝光的案件，这个数据来自中国人民公安大学犯罪学系王大伟。但王大伟告诉本刊，隐案率是一个犯罪学概念，可以通俗理解为已经曝光的案件和隐而不报的案件之间的比例。儿童性侵隐案率为1∶7，这个数据是多年前英国的警察系统根据英国的情况得出的结论，对中国有借鉴意义，但在性观念文化背景、司法体系和救助体系不同的情况下，完全不可类比到中国。这意味着，直到目前，依然没有任何数据可以较为准确地量化中国儿童性侵的现状。

而“女童保护”在各地做防性侵教育时，发现情况时，很多儿童甚至家长根本不能分辨自己是否受到了性侵犯。孙雪梅记得，“女童保护”某次在大连上课时，有学生下课后跟讲师反映自己受到了非常直接的性侵，而之前这名学生根本不知道自己遭遇的是什么事情。另外一次则是在东北的防性侵教育课堂上，有学生向讲师反映学校的微机课老师会趁上课时，不怀好意地摸学生，让学生感觉非常不舒服，听完课后她们才知道自己受到了性侵。最后，“女童保护”方面跟学校沟通后，这名老师才被调离到不能直接接触学生的岗位。

“女童保护”的另一名负责人徐豪则告诉本刊：“很多孩子虽然受到了侵害，内心感到奇怪，但她们并不知道自己受到的是何种伤害，也不知道应该怎么表达。”

除了孩子们不知道如何表达外，主动沉默同样是造成儿童性侵异常隐蔽的主要原因。“女童保护”的一位讲师曾在讲课后收到过一条短信，发信人称自己童年与人发生过关系，但讲师打过去，电话接不通。过一段时间，这个号码再次发来信息，发信人说自己从来没有跟其他人讲过，但讲师再拨过去，电话依然接不通。直到现在，这名讲师也不知道发信息的女孩到底是谁，她怎么样了。

李梓琨则接触过一个现实版《熔炉》的案例，时间大约在2014年左右。当时一名上海志愿者在云南某山区小学支教，在和孩子们建立信任关系后，这名志愿者通过一名小女孩的描述发现，校长和几名男老师长期在性侵这个女孩和班上另外十来个女孩。这个志愿者当时就报了警，但事情却并没有得到公开的审理或解决，而是不了了之了。这名志愿者回到上海后，找到一个国外的机构，又辗转联系到李梓琨，希望寻求帮助，但除了询问是否报警，作为一个规模很小的公益组织，李梓琨给不出什么救助方案，甚至因为志愿者已经离开当地，她也不知道那些女孩现在怎么样了，那所学校的校长和老师是否还在残害儿童。

走向无声的隐没，无法被纳入到有效的统计中，也正是目前大多数或轻或重的儿童性侵案件的现状。虽然本刊采访的所有关注这一领域的学者、律师和公益组织都希望包括公检法在内的政府部门，能够尽早调查和公开中国儿童性侵现状，以制定更好的儿童性侵政策体系，但迄今为止，中国尚没有全局性的切实的儿童性侵犯数据。

我们能够得到的比较有说服力的数据是，2013年9月，依托中国妇联的中国儿童少年基金会和北京师范大学社会发展与公共政策学院社会公益研究中心发布过的一份《女童保护研究报告》，研究团队在北京、兰州9所高中开展调查，最终结果性侵事件发生率在6.7%〜21.8%之间。2017年4月，北京师范大学社会发展与公共政策学院家庭与儿童研究中心出版《儿童保护制度建设研究：目标、策略与路径》一书，书中根据中国数次局部综合分析，认为中国受到多种形式性侵犯的未成年人在10%以上，其中插入式性侵犯约为1%，与世界平均水平持平。

（本文节选自《三联生活周刊》2017年第37期《向儿童性侵说“不”》封面故事）
