---

layout: post

title: 一场没有人愿意张扬的学术研讨会，和一个日渐紧迫的话题

categories: Archive

date: 2018-07-05 01:57

tags: 知青学术研讨会

image_feature: "https://i.imgur.com/IrZo4GG.jpg"

description: 6月份，潘鸣啸在复旦大学开了一场有关知青上山下乡运动的研讨会。

---

原文来自好奇心日报：~~[一场没有人愿意张扬的学术研讨会，和一个日渐紧迫的话题](https://www.qdaily.com/articles/54840.html)~~

作者：陈莉雅

---

![](https://i.imgur.com/IrZo4GG.jpg)

> 是“房间里的大象”，还是让一代人的命运得到严肃对待，这个起点问题都还没有解决。

潘鸣啸（Michel Bonnin）要来上海开一个研讨会。

他是一名法国汉学家，说着一口流利的中文，目前是法国高等社会科学高等研究院教授，以及香港中文大学中国研究中心的客座教授。

1973年，潘鸣啸带着对中国的好奇心来到香港，原本想研究当代儒学，没想到却在租屋处遇见“逃港知青”，这些知青的真实故事，让潘鸣啸找到了一个窥见神秘中国的途径。

在潘鸣啸之前，美国作者托马斯·伯恩斯坦（Thomas Bernstein）的著作《[上山下乡——一个美国人眼中的中国知青运动](https://book.douban.com/subject/2137378/)》已经在某种程度上，先行定调外国人视角中的“中国知青”——一场 “解决城市人口膨胀和城市失业率日渐高涨的社会压力” 的运动。

但潘鸣啸认为问题不只于此。他开始进行长达 30 多年的研究，采访无数名知青也拜访许多研究知青的学者，为确保资料的真实性，交叉比对过众多的文献资料。2004 年潘鸣啸出版法文版《失落的一代——中国的上山下乡运动（1968-1980）》，此后于 2009 年发行香港版、2010 年发行大陆版。

![](https://i.imgur.com/putWEE2.jpg)
<figcaption>潘鸣啸《失落的一代——中国的上山下乡运动（1968-1980）》</figcaption>

在一段时间里，潘鸣啸是我的采访对象，不过他已经确认要参加在复旦大学举办的研讨会，既没有公开的议程，也没有发布详细的消息。与此同时，复旦大学历史系的官方网站上，也找不到相关的信息。

唯一可以确认的是，这个活动是一个学术研讨会，研讨对象是中国知青。

1968 年是知青上山下乡运动的重要转折点。这场运动从 1955 年在各地就已经陆续开展，但 1968 那一年因为毛泽东的 “一二·二一 指示 ” ，使得下乡人数到达最高峰。

从 1968 年到 1979年共 12 年间，约有 1650 万知青被送到农村，加上之前的数量，总数将近 2000 万人。而他们的子女家庭所覆盖的人口数量，会远远超过这个数字。

![](https://i.imgur.com/aBJflqP.jpg)
*不同年度和种类的知青下放人数，资料参考自潘鸣啸《[上山下乡运动再评价](https://cecmcmb.files.wordpress.com/2010/02/panmingxiao-shehuixueyanjiu.pdf)》。*

从影响和覆盖人群和历史来讲，这个人类近代史中最大规模的迁徙运动，本来应该也是一个大事。不过，这个研讨会却很低调。

“你是复旦的，直接来听就是了”。活动开始前三天，为了确认活动是公开的，《好奇心日报》询问会务方，他们说事前已经讨论过，不把活动消息放上官网，也不刻意宣传。

后来，研讨会的其中一个组织者复旦大学历史系教授金光耀说，去年九月开始筹备会议，并向海内外学者发出邀请信，共有四个单位主办，包含复旦大学历史系、国家社科重大项目课题组、上海知识青年管理干部学院，以及上海知识青年历史文化研究会。

看起来，无论如何都是一件大事，但没有人愿意张扬。

金光耀和上海社科院金大陆研究员上一次组织这个活动是十年前的 2008 年。

同年的 12 月 21 日、22 日，复旦大学历史系和上海社会科学院举办了一场 “2008 知青学术研讨会”。时值中国知青上山下乡运动 40 周年，也是云南西双版纳垦区知青发起的全国知青大返城 30 周年。

“ 2008 年召开了第一次知青学术研讨会。这个会的成果之一，我们编了文集，现在准备编第二个文集。”金大陆说明十年后再次召开会议的原因。

那一年的的研讨会并没有想像中的顺利。“2008 年的会几乎全是知青出身的学者，他们之间的经历千差万别，因此影响到他们的态度和观点，吵得不可开交，所以这次限制了会议规模。” 一名会务人员告诉《好奇心日报》。

2015 年， “知识青年上山下乡史料的搜集、整理和研究” 成为国家社科基金会重大项目，这是中国第一个有关知青的国家级研究课题。金光耀与金大陆分别是课题组的首席专家与子课题负责人。

许多知名知青学者都参与了课题组，包含最早一批研究知青运动的中国社科院刘小萌研究员，中国社科院定宜庄研究员等人，他们认为课题组有助于当代史的研究，同时，也呼吁史料查证与公开的重要性。

[根据课题组的规划](http://www.npopss-cn.gov.cn/BIG5/n1/2017/1208/c400827-29695041.html)，前三年的工作重点将放在“知青史料”，尤其是档案资料的收集和整理。成员们得做出与学术相关的研讨与贡献，比如说，在海内外举办学术研讨会，或是出版研究书籍包含《上海知青在江西档案资料选编》《从“活动”到“运动”：知识青年上山下乡在江西的历史考察》《文革时期京沪知青阶层化的个人阅读》。

2018 年的研讨会其实也是课题组的项目之一，算下来刚好满三年，会议也命名为 “新史料与新视野：上山下乡与知识青年学术研讨会”。

![](https://i.imgur.com/lQOArCu.jpg)
<figcaption>1968 年 12 月《人民日报》接连几天刊出毛泽东的 “一二·二一指示”，写着：知识青年到农村去，接受贫下中农的再教育，很有必要。</figcaption>

## 1.

6 月 22 日，会议如期进行。

学术研讨会是一种相当密集的论坛形式，每二十分钟一个发言，两天的会议，共有多达 23 个报告。

研讨会地点在复旦大学光华楼里的一间研讨室，场地不大，活动当天才来了 40 多人，会场就已经塞满了。与会人员包含 32 位学者、3 位研究生、10 位前来旁听的老知青，以及少许的普通旁听者。

老知青们大多坐在会场外围，他们当中有些人积极记录这场活动的过程，以拍照或是录影的方式。

主办方希望能加强学术讨论的氛围，所以留了不少时间给学者们讨论，会议开始前他们向老知青们说明会议规则：尽量把时间留给与会学者。

这样的提醒，引起部分老知青的不满。

6 月 23 日上午 10 点半左右，研讨会进行到第二天上半场，第一组讨论结束后的茶歇时间，一位名为周公正的老知青从场边的座位站了起来，他向金大陆表示自己要离开现场。

周公正一边指着会议手册上的“与会学者名单”，一边从口袋拿出一百元说要归还前一天所吃的便当餐费，他用上海话说：“我讲句不好听的，我们知青就是来充场面的”。

两个人的争执将近 20 分钟，一路从会议室到电梯口。不过期间没有引起太多人的注意，大部分的人都在会议室里或者走廊上，跟其他学者讨论上一场的主题。反倒是一名老知青经过两人，淡淡地说了句：“我们已经习惯了”，接着走回会议室。

金大陆不停劝阻周公正，并强调活动后半段会给他们发言。最后周公正回到了研讨室里，但待不到两小时之后，又在中场的午餐时间离开会场。

![](https://i.imgur.com/UlOGcK8.jpg)
<figcaption>知青上山下乡通知书（图 / 华夏知青网）</figcaption>

类似的会经常有这种冲突事件。

周公正离开会场前告诉《好奇心日报》：“我对金大陆没有不满。我就是一个老知青，只是很正常参加这个会议。整个社会把我们边缘化。这个研究我很珍重，是唯一可以对知青做出公正评价的，但我们知青就是给人利用，需要的时候就用我们。”

“像病退的主题我最有发言权。”周公正补充说。

周公正口中的病退主题是第二天的一个讨论主题：“疾病与制造疾病：上海知青病退政策的演变”，由上海市第三女子中学朱文静教师报告。

连续两天的研讨会，共有 7 场报告主题，每场分别有 3 - 4 名讲者。这些主题包含后知青时代的问题讨论、知青运动的动机与成因、知青与当地农村的关系、闽粤赣边地区的知青研究、知青口述史、知青美学、知青婚姻等。

议程安排上，通常资深的学者与年轻的讲者也被分在不同组别集中讨论。

学术研究与个人经验有着难以调和的矛盾。美国埃默里大学社会学系助理教授徐彬，在会上提出记忆与历史的问题：“现场很多人有自己的经历，当然这也有好处，学术跟大众的经历模糊，可以使得学术研究传的更快些，第二个就是把这一代人的定位，然后跟学术议题相重合之后，课题就会显得很狭窄，就是变成一个小众消费的东西。”

![](https://i.imgur.com/ecuQAhH.jpg)
<figcaption>1973 年，文革时期的宣传画师张绍城创作的作品《广阔天地新苗壮》，此幅画也被研讨会选为论文集的封面底图。</figcaption>

## 2.

2015 年，[武汉大学哲学系教授邓晓芒接受 “共识网” 里一个栏目“我要问学者”的提问](http://culture.ifeng.com/a/20141210/42684315_0.shtml)，其中对于知青上山下乡运动，有个问题说到：“知识青年下乡可以给广大农村地区输送科技文化知识，给农业的发展带来生机与活力”。

邓晓芒当时回应：“你还相信上山下乡给农村带来了文化知识，可见你只从官样文章中了解这场运动。...你说的那些道理，都是当年骗我们下乡的道理，我们已经醒悟了，想不到你们倒前仆后继了，幸好现在我们还在，不然就死无对证了。”

尽管是学术研讨会，这种“死无对证”的情绪如今依然强烈。

现年 60 岁的朱盛镭，连续两天都来参加研讨会，每当他在现场听到年轻研究者的报告，时不时就会转头对隔壁的人，补上几句：“不是这样的。”

朱盛镭是一名上海人，1970 年下乡到山西，共 7 年时间。由于知青身份，他平时就很积极参与相关的活动，“我不想多说，他们有些想法有些是错的，幸亏我们还在，不然死无对证，年轻一代的研究者，就是有这个问题。他们都是看数据，不太好。” 朱盛镭告诉《好奇心日报》。

这依然是学术研究与个人经验的差别。鉴于可公开资料有限，对资料匮乏的担忧和质疑，往往会为历史研究制造噪音。

清华大学历史系教授秦晖在会上提起一段外人不太清楚的历史事件，[关于央务知青与广西南宁 “四二二” 惨案](http://www.aisixiang.com/data/105991.html)。

“在央务成名时期，那个报告文学《根深叶茂》上是一个字都没有的。如果我们不讲这央务到底是怎么回事，以后的人们就不会知道了”，秦晖进一步补充：“当年知青运动中有很多报导，对这些报导有两种截然相反的态度，一种是你相信他，就会认为那是个激情燃烧的岁月。如果你不相信这些宣传，你就会觉得这些人就是为了想当官而不择手段的那种，是所谓的政治红人。但我觉得实际上的真实可能是在这两者之外的。”

连续两场的研讨会当中，不少学者都会提及史料的问题。确实，一旦有了新史料，就很可能出现有别以往的发现，反之，也会陷入一些难以厘清的逻辑争论当中。

福建师范大学社会历史系学院叶青教授表示：“我们在收集史料上很艰难，比我想象中的艰难，在我看来知青能够成为重要课题应该还好，目前感觉知青还好，但碰到文革还是比较敏感的。”

![](https://i.imgur.com/eXNvkvh.jpg)

## 3.

由于材料缺失，一些关于知青运动的逻辑还没有厘清，比如上山下乡的动机，复旦大学马克思主义学院邓杰讲师提问：“我们发现现在有个主流的解释是意识形态说，就是说教育改革。但这无法解决一个逻辑的问题，为什么要去农村而不是工厂？还有一种就是解决城市就业问题，那这样至少有两条路，就是至少有个是可以增加城市的就业。”

这个看法与潘鸣啸有出入，他认为经济动因不是主要原因：“这个议题还在辩论，之后也还会辩论，我的看法就是政治运动。”

中央党史和文献研究院的郑谦研究员认为，必须掌握史料，才有助于分析知青运动，“知青的叙述将由老一代知青传入年轻一代的手里，他们没有知青的经历，他们面对的是史料、文学作品。他们不会有我们这种强烈的知青经历，他们的研究可一定会跟我们有差。所以将来知青研究会出现多样化。”

金大陆说起十年间，知青研究所出现的其中一个明显的变化，就是 “文学作品变少了，出现文学往史学转的迹象”。

中国社会科学研究院定宜庄研究员说：“过去很多研究会喜欢用文学作品，但我觉得那只能代表知青的一小部分。知青研究中，我们常把小说当作学术研究，其实这是很特殊的，其他运动很少出现这种现象。然而，我们搞知青研究的这种现象出现的特别多。”

面对知青研究，徐彬说：“这不是历史课题，而是记忆课题。”

中国当代史研究的地方档案开放，一直是专业研究的问题。这个问题同样出现在潘鸣啸研究知青的过程。他借助许多已经公开的报刊文献，地方志，统计年鉴，以及文学作品，最后搭配口述访谈资料交互论证，才得以进行一个相对全面的研究分析。

一位年轻研究者说自己在搜寻历史档案时，确实遇上档案不公开的情况，但还是挖掘到不少新的材料，不过由于档案不公开，他也不清楚具体会有哪些档案可以使用。

另一名参与活动的年轻研究者在活动现场表示：“当今所有知青研究中文章被引用次数最高、最核心的成员都来了”，每到茶歇时间，她会把握时间与那些从事相关研究的学者进行交流。

十年前，同样参与知青研讨会的潘鸣啸回忆起两次经历：“当时旁听者比较多，而在我记忆里他们在问答时间谈自己的经历很多，也在他们之间有一些比较激烈的矛盾。这次，组织者成功地保护了学术讨论的气氛。”

2008 年，海内外有将近 80 位知青研究中最具代表性的学者们一同参与研讨会，根据媒体报导，“ 这是 40 年来在中国召开的影响力最大的关于中国知青上山下乡运动的理论研讨会”。

不过说起来，两次会议的参与学者阵容并没有太大差异。

![](https://i.imgur.com/JW3Tvkn.png)
<figcaption>2008 年 "知青学术研讨会"</figcaption>

2018 年 6 月 23 日晚间 6 点，今年的研讨会圆满落幕的那一刻，会务人员才把活动的照片与记录发在朋友圈中。不少人是从这一刻起才知道，原来复旦大学在周末有过这么一场学术研讨会。


> 制图：冯秀霞、王恺曼
>
> 题图来自知青上山下乡宣传图
