---

layout: post

title: 2018年北大校工访谈全记录

categories: Archive

date: 2018-05-04

tags: 工人状况调查

description: 百廿校庆，两个甲子，校内工人不应被忽视，而本应属于劳动者的五一劳动节更不能让他们缺席。

---

文章来自 [马列之声](https://www.mlzs.work/t/topic/1871)

作者：2018年北大工人情况访谈小组

---
## 编者按

此篇文章几日前出现在我的朋友圈，现在在微信微博平台已被全部封杀。编者本身既跟北大无瓜葛，也无意抹黑任意一所学校，只希望一篇不想被别人看到的文章能被更多的人看到。并向关注工人，深入工人访谈小组致敬。

## 摘要

2015年底，北大某学生社团曾组织过关于校内工人的调研，了解了工人的劳动权益状况、食宿生活条件、业余生活以及日常人际关系等情况。该调研报告引发了广泛关注。

今年，十余个院系的五十余名北大同学自发成立2018年北大工人情况访谈小组，以前述报告聚焦的内容为基础，进行了为期十天的集中调研，写下这篇调研报告。

报告调研的279名工人中，有6人的月收入在每月2000元以下，一些工人甚至不得不打两份工。**50%的工人工资集中在2500-3000元/月**，这是北大工人工资平均状况。

调研结果显示，41.3%的工人休息情况不符合劳动法规定。

**54.27%的工人存在加班费缺失情况**。仅有10.05%的工人的加班费是根据劳动法获得的。可见，2015年的调研报告指出的工作时间与工资问题，没有得到明显改善。

调研结果显示，43.0%的工人没有签合同。在签了合同的工人中，至少有20.6%的工人手中并无合同。

77.19%的工人表示，单位没有按照法律为自己缴纳五险一金。

工人的生活空间依旧相较狭小，通气条件仍然有限，地下室闷热和潮湿的环境没有得到明显的改变。

调研结果显示，对文娱活动有需求的工人占38%。但与此同时，在工人群体中，没有时间和精力娱乐的占到29%。**相当一部分工人反映工作时间过长，工作强度过大，由此也导致工人们下班后缺少休息时间，缺少精力**。

上述所说仅仅是调研的一小部分，把这些内容列在开头，是希望能引起大家的重视。

在文末，该报告提出了建议，希望所有关心校内工人的老师、同学和朋友们能够仔细思考，共同建言献策。校内工人不应被忽视，本应属于劳动者的五一劳动节不能让他们缺席。


## 目录

第一部分  前言

访谈过去时

访谈进行时

第二部分  校园工人劳动权益现状

一、经济待遇现状及改善

合法权益的改善

学校洗碗间---校园外包单位的一角

二、精神生活与人际关系

匮乏的文娱生活

单调的人际关系

北大的平民学校

三、边缘化的身份

割裂的学工关系

被遗忘和不被尊重的身份

四、“被消失”的工友之家

第三部分  结语

## 前言 Foreword

### 调研过去时

2015年底发布的调研报告，以专题介绍的形式，展现了用人单位违反劳动法规、工人合法权益遭受侵犯、较为恶劣的食宿条件、下班后乏味的地下室生活、僵硬的劳动管理体制等诸多现象。

2015年的调研报告显示，工人的合法待遇受到严重侵害，校方在对用人单位的审查和监管做得并不到位。例如，超过三分之一的后勤工人在入职以后，单位没有与其签订劳动合同；只有不到10%的单位全额给劳动者缴纳社保；超时加班情况普遍，大多数工人每天工作少则9小时，多则十余小时。

![01.png](https://i.loli.net/2018/05/02/5ae9c919423ce.png)

![02.jpg](https://i.loli.net/2018/05/02/5ae9c9194c83f.jpg)

报告发布后，北大很快进行了回应。北大校方对于进行调研的同学热情与责任心给予了肯定与赞许；对报告本身能否科学客观地反映北大校内工人的真实情况表示质疑；并针对报告所反映的现实问题，做出了积极整改的决定和承诺。

两年后，回顾2015年调研报告和校方回应时，就报告本身和其所产生的效果仍存在以下疑问：

1、2015年底的调研报告是否真实全面地反映了校内工人的状况？接受访谈的100人样本是否具有广泛代表性？北大给出的《说明》里表示2015年采访的对象主要隶属于**劳务外包单位及合作经营用工，学校直属用人单位的工人状况又是如何**？

2、校方已在2015年底的回应中表达了积极整改问题的态度和决心，那么现在工人待遇的改善情况和生活现状又如何？经过查询，在《说明》发出后的两年中，没有找到有关此事后续进展的信息。发布2015年调研报告的公众号“北大马会”上，内容已被发布者删除。

3、两年时间里，北大又走入不少工人与学子，二者目前的关系如何？在未名BBS一些投诉帖的背后，作为投诉方的学生和被投诉方的工人如何看待双方的关系？

### 调研进行时

十余个院系的五十余名北大同学，成立2018年北大工人情况回访小组，以前述报告内容为基础，于近期进行了十天的回访。

为使此次调查的样本尽可能具有广泛代表性，报告在2015年的基础上扩大了样本量，**一共调研了303位工人，占学校工人总数的10%**。

调研对象囊括北大校内绝大多数工人岗位，按工作单位可分为：餐饮中心、动力中心、校园服务中心、公寓服务中心，其中既包括校内直属单位，又包括这些直属单位下的外包单位。访谈时，按照行业特点确定对象比例，以小组为单位进行访谈，将个体访谈与集体访谈结合，力求真实、全面、客观地反映实际情况。

![03.png](https://i.loli.net/2018/05/02/5ae9c9195e78c.png)

调研结束后，来自经济学院、法学院、医学部、中文系等院系的同学组成成果汇总小组，将访谈的原始材料整理成稿。

## 校园工人劳动权益现状 Labor rights

在本次调研所覆盖的303名工人中，有男工217人（71.6%），女工86人（28.4%）；按工作岗位划分，有食堂后勤101人（33.3%），保洁、园林、动力中心76人（25.1%），建筑工100人（33.0%），保安26人（8.6%）。由于某些客观限制（例如难以接触到很多工人），无法完全依据分层抽样的原则确定各单位样本量。

### 年龄和工龄

![03.png](https://i.loli.net/2018/05/02/5ae9c9195e78c.png)

调研对象以中年工人为主：40岁以上的占60%，30岁以下的年轻工人仅占17.53%。而根据男性年满65岁，女性年满60周岁的退休规定（1），有95.24%的男工和51.61%的女工在退休年龄以内。

![04.png](https://i.loli.net/2018/05/02/5ae9c91a5ad2a.png)

校园工人的流动性比较大，接近三分之一在校工作不足半年，57.3%的工人在校工作不足两年，其中有**91.9%属于外包单位、合作经营单位或劳务派遣单位**。在男工中，24.9%的工人有10年以上的工作经历，而女工中这一比例仅为4%。

![05.png](https://i.loli.net/2018/05/02/5ae9c91ac18bc.png)

### 工资待遇

![06.jpg](https://i.loli.net/2018/05/02/5ae9c91a4fcfe.jpg)

截至目前，北京市最低工资标准为每月2000元。但在搜集到数据的279名工人中，仍有6人的月收入在这以下。

一些工人不得不打两份工，接近1/3的工人月收入在5000元以上，这部分工人全都来自于建筑工。除了他们之外，50%的工人工资集中在2500-3000元/月。

在四个职业中，保洁园林动力中心的工人平均工资较其他三个职业低。一名大姐说：“（干保洁）刚开始确实是受不了，后来慢慢地就适应了，想着为同学们、北大同学孩子们打扫卫生，感觉挺好的，也挺自豪。就是说，这个（工作）工资太低。”

![07.png](https://i.loli.net/2018/05/02/5ae9c91ac1294.png)

将工人工资按2000元以下，2000~2500，2500~3000，3000~3500，3500~4000，4000~5000，5000以上分类整理，区间取中间值，2000元以下按2000计算加权平均，求得各职业平均工资。

在加班方面，学校工人的加班形式不一，有的采取每天超时加班，有的采取休息日加班，有的采取总轮流休息综合工时制。

劳动法规定加班时长如下：

![08.jpg](https://i.loli.net/2018/05/02/5ae9c919b4f95.jpg)

而在这个问题上，报告调研的269个工人中，他们提供的休息情况如下图：

![09.jpg](https://i.loli.net/2018/05/02/5ae9c91ae3675.jpg)

可以看到，41.3%的工人休息情况不满足劳动法要求。

除此之外，还发现两个现象：

一、只有建筑工人才会日结工资。表面上看，他们有自己选择休假时间的权力，但迫于工程进度和养家压力，他们只要没有生病都会出工，每月休假往往达不到4天。

二、保安所在的文安公司虽然采取综合工时制，即综合计算周期内的某一具体日（或周、或月、或季）超过法定标准工作时间是允许的，但同样需要遵循劳动法延长工作时间每日不得超过三小时，但是每月不得超过三十六小时的规定。北大保安在轮休制下，每周休息时间不足一日，同样涉嫌违反劳动法。

**2018年北京市最低工资标准目前为11.49元/小时**（见《关于调整北京市2017年最低工资标准的通知》，京人社劳发〔2017〕149号），结合工人的上班时间，来看看工人们的工资：

![10000.png](https://i.loli.net/2018/05/02/5ae9cc77b37bc.png)

以在农园二层某窗口工作的工人为例，一天工作10小时，每月工作26天。按劳动法第44条，她的加班工资应该是22天*2小时*11.49元/小时*1.5(平时加班)+4天*10小时*11.49元/小时*2(休息日加班)=1677.54元，加上北京市2017年的每月最低工资2000元，**一个农园工人应该至少拿到3677.54元。但他们的实际工资大约是3150元**。

![10.png](https://i.loli.net/2018/05/02/5ae9ca7a94fc5.png)

54.27%的工人表示没有拿到加班费。仅有10.05%的工人加班费是按照劳动法给的。2015年的调研报告着重指出这个问题后，在工作时间与工资这两个问题上，并没有大的变化。

按《工资支付暂行规定》，用人单位在支付工资时，应向劳动者提供一份其个人的工资清单。

![12.png](https://i.loli.net/2018/05/02/5ae9cc2e3557d.png)

**但是，仅有17.29%的工人把自己的工资条拿到了手上**。

### 合同和社保

1）合同持有情况

依照《中华人民共和国劳动合同法》，劳动合同是劳动者用于确立，证明劳动关系，维护合法权益必不可少的。

![13](https://i.imgur.com/HyghDZz.jpg)

本次调查对象来自不同单位，因为管理等多方面的原因，直属单位在合同，社保等方面更好。总体看来，43.0%的工人没有签合同，在签了合同的工人中，至少有20.6%合同不在自己手里。

![14](https://i.imgur.com/NDV0xDi.jpg)

2）社保状况

很多工人都是因为在老家赚的钱不多，所以跑到北京来打工以养家糊口。尤其是对于在老家没有办社保的工人来说，在到了法定退休年龄或者失去劳动能力后，便失去了生活的保障。从前文关于年龄的统计我们可以看到，学校存在雇佣超龄职工的现象，或许是因为这些工人在劳动力市场上更廉价。另一方面，当工人满50岁以后，便不再为其缴纳社保，这使得工人老无所依。本次共调查了285位工人的社保情况，数据如下：

![15](https://i.imgur.com/NJjvcps.jpg)

食宿条件

2015年的调研报告给我们展示了工人不一样的生活环境，此次调研，我们发现工人住宿的地点较之前没有发生较大改变，约一半的工人仍住在地下室，集中在36楼、39楼、42楼、45乙楼、畅春园、畅春新园公寓的地下。

![16](https://i.imgur.com/Rtit4a2.jpg)

![17](https://i.imgur.com/EReaePS.jpg)

访谈时一位工人向我们倾诉，在11月大兴大火之后，他们曾一度被要求搬离，但由于无处可去，之后仍然住在地下室。

![18](https://i.imgur.com/DY8wwvu.jpg)

根据《北京市人民防空工程和普通地下室安全使用管理办法》，地下室内不得设置上下床，人均面积不得少于4平方米，但当我们走入工人宿舍时却发现，狭小的个人空间，有限的通风条件，闷热和潮湿的环境仍然没有得到改变，唯一让工人高兴的是，在2015年的调研报告发布后，宿舍被重新粉刷了，床和柜子更换了，部分宿舍装上了空调。

![19](https://www.mlzs.work/uploads/default/optimized/2X/4/446a61e154070f87057fe07169b32a214f32e5d0_1_368x499.jpg)

<figcaption>位于某楼地下的工人宿舍</figcaption>

据统计，除了在食堂有工作的工人外，其余吃饭基本上都要花钱，其中光华楼内工作的工人是例外，在楼下有专属的工人食堂。统计中有13%的工人吃饭被扣税，除了校园保安，还有不少保洁工人，也就是说往卡里冲100元实际只能消费85元，每次刷卡都会扣除额外15%的税。多数买饭的工人会选择学一食堂，艺园食堂以及燕南食堂等便宜窗口，包吃的工人时常吃到的是食堂买剩下的饭菜，如果剩下的是好菜就吃好的，一般的就吃一般的.

![20](https://i.imgur.com/aXMaVG6.jpg)

学校洗碗间–外包单位的一角

以洗碗间为例，所有食堂的洗碗间都被一个私人老板承包了，在洗碗间工作的人，共计有两百人左右。

这两百人日常的工作是怎么进行的呢?一般而言，早上六点到七点之间开始工作(要值班的早上五点就要到)，清洗昨天以及早上的餐具，一直到中午十一点。这时能稍微休息会，吃中饭。到了十一点半以后，食堂开始营业，就要开始收餐具了。期间一直站着，倒剩饭剩菜，把盘子收好，在密集的人群中穿梭过去，送到洗碗间。

下午一点，人群渐渐散去，收餐具也就结束了，但是，实际上为了完成所有的工作，他们还需要继续干到一点半乃至两点。这些时间是不算在加班里面的。到了下午四点钟，经历两个多小时的休息之后，他们又要开始晚上的工作了。这时会一直干到晚上七点，重复与中午一样的工作：收餐具，送餐具，洗餐具，收餐具，送餐具，洗餐具。七点吃了晚饭，回到在地下室的宿舍洗漱，休息。

![21](https://i.imgur.com/9YCxcQZ.jpg)

这是正式工一天的生活，洗碗间的工作是非常累的，双手经常要泡在水中，长时间的处在消毒水和水汽弥漫的空气当中，对碗筷的要求也很高。所以很少有人能坚持干下去。跟一顿饭几千人次的人流量比，一个食堂的正式工只有五到十个人。巨量的工作加重了正式工的负担，所以，老板还雇了小时工，他们只负责中午或者晚上的收餐具工作。

他们吃什么呢?洗碗间作为承包单位，吃的饭是自己做的，往往是炒土豆丝，凉拌豆芽等素菜。有时候食堂会卖剩下一些菜，他们也可以吃一些，剩的菜五花八门，如果有一些荤菜，就可以吃得好一些。

虽然有休假，但是这种休假更像是玩文字游戏：每月有两天的假期，但是这两天假是拆分成四个半天来算的。这半天如果是上午，就是干到中午十点或十一点，休息到下午四点，继续上班，如果是下午，就是一点下了班之后，休息到晚上。也就是说，每次不过是少干了3个小时的时间，老板把这三个小时，叫做半天。

与巨大的工作量相比，更令人难以忍受的是洗碗间的待遇问题。

正式工的工资为三档：2600元(普通员工)，2900元(领班)，3200-3500元(主管)。小时工的工资是8元/小时，远低于北京市非全日制最低工资小时标准22元/小时。

按《关于调整北京市2017年最低工资标准的通知》[1]对正式工而言，按每天九小时估算，休息时间都放在周末，那么每月(30天)的工资也应为11.49*(8+11.5)22+11.49294+11.49264=3780.21元。如果算上超时加班以及节假日工作时间，工资能达到4000元以上。

然而现实却十分荒诞，他们所拿到的，是固定不变的工资，大多数普通员工拿到的都是2600元至2900元之间，即使是加了班，工作超了时，也没有什么加班费的说法，同样，也是没有劳动合同、没有社保的。

外包单位雇佣的大都是45岁以上的工人。他们劳动能力有所下降，已经到了退休年龄，受制于之前恶劣的工作环境，也不会有退休金。双手还能劳作，还有孙辈需要抚养，他们就不愿意也不可能闲着养老。但是年老体弱，大多数单位都不可能要他们，就只好来这里。不干，找不到其他工作。干了，就得拿这个工资。

超时的劳动，休息时间的缺乏，薪水的低廉，严重违规的劳动条件。难以想象，在2015年的调研报告发出两年之后，洗碗间的两百位工人们仍然过着这样的生活。

品质校园的背后，我们很少注意到洗碗间的工人们竟承受如此待遇。学校在规范外包单位用工合法性时，应在何种范围行使自己审核与监督的权利与义务?

## 精神生活与人际关系

![22](https://i.imgur.com/ieWSnHK.jpg)

精神文化生活是人的基本需求，人际关系也能反映出人的精神生活质量。那么北大工人们的业余生活是怎样度过的呢?

访谈结果显示，下班后选择玩手机、玩游戏(57.3%)和看电视(40.4%)的占了绝大多数，其他的生活方式均未达到10%，看书和锻炼、散步加起来也只有8.0%。据我们了解，玩手机的工人多是玩一些手游，看看快手视频，再刷刷朋友圈就睡觉了。选择看电视的工人则是对智能手机不熟悉或者根本没有智能手机，花几十元买来一个二手电视，“看两年坏了就扔了，再买一个”。此外，我们访谈到的工人大部分住的都是八人间的集体宿舍，爱人儿女都在老家或者分居，定期进行视频聊天，成了很多人的选择。

这也与我们走访的经历相符。最常见的情景之一就是推开宿舍的门，几个工人或者坐在床上、或者围坐在电视机旁边，目不转睛的看着(大多是抗日神剧)，时不时的闲聊几句。“不看电视还干啥，下了班也干不了啥事情嘛，也就是有啥看啥。”那些没有电视机的宿舍，宿舍里却是相对安静，工人们往往躺在床上玩着手机，跟家人视频，彼此没有什么交流。有些人会在宿舍喝些酒聊聊天，气氛才热烈一些。有的宿舍情况要更糟糕一些，宿舍里没有WiFi。甚至连手机信号都没有，一进宿舍就失联了。“宿舍里装网络很麻烦，还要自己买路由器自己拉网线，不像你们学生，宿舍里都是装好了的。”

即使是看书，也显得很奢侈(4.3%)，在我们调查到的工人中，有11位工人业余生活会读书，而且全是保安。但是据他们说，即使是读书，也只是消遣，读读小说与成功学。只有2个人仍然在读着专业书籍。虽然很多人是慕名而来，抱着来这里学习考取文凭的目的，但是在这里呆了几个月之后，能坚持看书的也很少了。不规律的上班时间，频繁的加班(加班时一天工作16小时)，宿舍里不上班就打游戏的室友，导致他们很难能有一个合适的氛围静下来学习。

建筑工地的工人们，精神生活更加匮乏。他们住在简易板房里，只有12V的电源，用来给手机充电。同样没有网络，出了宿舍，走到路口才有wifi，有时候去那跟家里打个视频电话。在宿舍里就是洗洗衣服聊聊天就睡觉了。与其说精神文化生活，不如说是消磨时间。
某些东西是数据中无法体现出来的，在我们的访谈中，提到业余生活，有的工人会愣住，在我们的进一步询问下，才会说一两句：“能干啥，就歇着呗。七点钟才下班，下了班就挺晚了，出去也干不了啥，在宿舍玩玩手机也就打发了。”

![23](https://i.imgur.com/1C51vvf.jpg)

对文娱活动有需求的工人占38%。而与此同时，在工人群体中，没有时间和精力娱乐的占到29%，也相当普遍，在访谈中，大家都普遍反映工作时间太长，工作强度太大，导致工人们下班后缺少休息时间，缺少精力。总的来说，工人对网络有一定的需求，达到16%。除此以外，还有极少一部分工人对班后的精神文化生活持无所谓的态度。

繁重的工作，有限的休息时间，让许多工人的精神领域陷入空虚和匮乏。他们很少有娱乐的时间和机会。尽管如此，我们仍然发现很多女工人喜欢唱歌跳舞，男工人喜欢下棋打球，他们都对这些活动表现出很大的兴趣和渴望，但是因为缺少平台以及必要的精力，他们的爱好无法实现。

我们还遇到了一些工人，这部分工人一直在校内寻找为自己开放的课堂，他们希望加入一些社团，学一些感兴趣的东西，诸如书法，乐器等。而由于工作时间的限制，他们往往很难有完整系统的时间投入兴趣中，“老师每周的课都是留作业的，但是下了班就七点多了，收拾收拾哪还有时间呢?而且宿舍里还很吵闹，静不下心来，只有趁着休息时间别人都不在练一练。”采访中，一位工人在谈及他报的一个兴趣班时如是说。

![24](https://i.imgur.com/70i6A0P.jpg)

![25](https://i.imgur.com/9t0NZA6.jpg)

在人际关系方面，根据统计，受访的303人中，很少与人交流的占14.2%，主要与家人、室友、老乡、同事交流的占到50.5%，其他人际关系广泛的仅有1.7%。

调查反映出工人的人际关系普遍范围有限。部分工人很少进行人际交往，而人际交往的建立模式较为单一，以旧有关系为主，局限于亲人、老乡、同事等纽带，拓展面较窄。
根据我们的访谈，工人反映阻碍人际关系的原因主要有：

1、工作时间差异。部分宿舍不同工种的工人混住，上下班时间差异较大，常有部分工人回到宿舍时其他人已经休息的情况。调查员在某间宿舍访谈时，只有一位工人坐在床上看手机，其余几位工人已酣然入睡。这位工人表示自己上下工时间不固定，而且经常在夜间干活，“大家时间都不一样，就不去打扰了。”当调查者约晚9:30离开时，还有部分工人正在回宿舍的路上。

2、缺乏交往平台。由于校内工人组织的缺乏，以及工人对其了解、参与程度度低，工人的人际关系的发展主要依靠传统社会关系。如通过老乡关系相约一起打工。

3、岗位流动性强。一些岗位因工作辛苦等原因，流动性较强，难以深入沟通。调查员在某宿舍听工人们讨论自己的工龄，都没有超过一年。此外有些性格较为外向的工人也反映，跟室友关系不错，但室友也会经常变动，“工作太辛苦，很多人干不动，往往还没熟起来就换人了。”

4、工作强度大、工时长及休假少。工人在下班后普遍反映较累，所以常常只想休息，不愿聊天或出去玩。

5、领导禁止串宿舍。部分宿舍区禁止串宿舍，限制了下班后可交往的范围。

综上，工人的人际交往常受到多种因素的限制，因此社会关系普遍较为局限。

### 北大的平民学校

2006年，北京大学继承蔡先生的“劳工神圣”的真谛与精神[2]，重新创办了北大平民学校。平民学校目前已经运行了十二期，每年三月份定期举行开学典礼，选举班委，开始为期三个月的教学活动，包括主课、计算机、英语兴趣小组、课外教学活动，直到六月底结业。平民学校的教员包括大学教授和学生志愿者，教授给工人普及大学通识教育;学生教工人学英语，使用计算机，培训基本技能。

作为关注校内工人学习发展和丰富业余生活的机构，平民学校在工人中的印象究竟如何呢?

在同一些工人和学生志愿者的交流中，我们发现平民学校对工人的学习和生活起到了一定的促进作用，但是仍然存在着一些不足。

在授课内容上，平民学校的主课包括文学诗歌，科技，还有心理健康，法律知识，由北大教授直接讲解，覆盖面很广，以介绍性、拓展知识面为主。英语和计算机是两门大课，为了将来择业储备技能，不少年轻工人都会对此特别认真。英语课和计算机讲课的都是学生志愿者，准备比较充分，讲课时从最简单的开始讲起。

对于学习课程，一位工人表示：“学的东西有用处，就是用的少还是不熟练。”几位志愿者说“我觉得好像工人们平时接触电脑的机会不是很多，要用Office的机会就更少了，感觉他们在计算机课上学到的东西不容易记住，更不容易掌握了。”“我觉得这些课的性质更偏讲座类，要说收获可能看个人了。”“老师上课可能不必要地讲了很多工人听不懂的知识”。

平民学校每期学员100名左右，覆盖全校工人的3%。在选拔方式上，学员名额为分配制，每个单位的名额是相对固定的，而且领导指定居多。总的来说，参与者很多是本职工作比较轻松或直属单位的年轻人，如勺园西餐厅、百讲、幼儿园，体力劳动量大的工人很少，在一些外包单位，如洗碗间、物业公司中，几乎没有工人听说过平民学校有名额。

从出勤情况看，每节课出勤率大约2/3，工人因为加班或者劳累，不一定愿意来上课。每次都有拿不到结业证的，全勤的很少。单就英语课来看，参加的工人越来越少，到期中之后，甚至出现了一次只去两三个人的情况。

在平民学校里，主要负责和决定授课内容的是学生志愿者和老师，但作为平民学校的主体，工人的主体性并不强，仅仅是作为一个被授课的对象存在。这种不对等的权力关系也导致平民学校并不能完全符合工人的需求。一位工人回忆，在讲到劳动法时，很少涉及工人在劳动权益、劳动纠纷上的规定，这种缺乏也导致工人们面临劳动权益受损害时，很难能拿起法律武器为自己维权。而且，工人，学生，教师三者之间交流少：一般只有班委和老师接触稍多，普通学员和老师基本没有接触;很少有学生志愿者在课后和工人交流;学员间除了上课、偶尔几次外出游玩和排练外，也没有其他活动，学员间除了可能有的私人关系外几乎没有什么集体关系。就如一位志愿者所说：“几乎就是上课的关系，没有其他交流，除非是同事。”

总体而言，我们认为在平民学校里，工人主体性的缺乏，使得平民学校的开展受到了较大的限制，校内工人的需求也未能得到有效的满足。

## 边缘化的群体

### 割裂的学工关系

未名BBS作为发声主体为学生的平台，透过它所呈现出来的学工关系是学生与工人之间的权利关系不对等。工人们自己一般没有BBS的账号，一旦发生纠纷(例如食堂投诉)，BBS上的投诉帖一般是学生单方面呈现问题，并非问题反映的不符合实际，而是矛盾另一方的缺失本身就反映出体制的不健全，直接后果是被投诉员工经济上的处罚(实际上是有投诉，必处罚)，间接后果是真相可能被隐藏。

在我们深度访谈的17位后勤工人中，有8位工人说到了自身和学生老师的交流情况。有6位提出和学生的交流太少，工作得不到学生的尊重和理解的问题。

在我们调查的204位学校后勤职工(178位食堂、保洁工人和26位保安)中有47位职工反映曾经遭遇学生投诉或者与学生发生冲突，占调查总数的23%。

![26](https://i.imgur.com/CreCZQU.jpg)

1、近一段时间bbs举报历史

我们抓取了未名BBS2017-2018的第二学期燕园食宿版的投诉情况。投诉的帖子主要有几种情况：食堂人员服务态度差，建议撤换菜品，食堂卫生环境不好，餐具不洁或菜品中出现异物以及外来人员用餐挤占用餐空间。直接涉及学工关系的是餐具不洁一项，该类投诉在本学期中有83例，外加投诉服务态度的帖子7例，共90例。在所有研究样本中，发声的几方有：学生及其代表食堂监督员，餐饮中心以及食堂经理等直接管理人员，而唯独缺少了员工这一直接矛盾的主体。

2、bbs投诉的特点

投诉同学主观情绪较大

我们看到：BBS上一条题为《凌晨看到楼里保洁大叔工作》的帖子的评论区中有的同学跟了如下的一条帖子：“不过其他的说得有理诶……一般去反应情况只是希望食堂改善，没人是奔着让他们扣工资去的。”这是食宿版留出空间让学生发帖的本意，但是实际情况却并非如此。同学们进行投诉时，发出的帖子却带有一定的主观情绪，例如《震惊，……》、《我发誓，……》、《……，这是要毒死校长吗?》等等，这些帖子更多的从表达个人不满出发，并不利于问题的解决，当事人也无法对此进行回应。最终只有官方的处理结果，摘取一段官方回应“对于你在就餐时的不愉快感到抱歉。食堂已经对员工进行批评，并对员工进行再培训，严格要求，避免此类事故再次发生”。

同学和员工之间直接交流途径的缺失

当出现投诉帖时，处理结果是经过两方代理沟通得出。一方是监督员代表学生，一方是餐饮中心代表工人，但是矛盾的直接双方却缺乏直接交流。在学生看来，只有一个双方代理人之间沟通的处理结果，并不清楚一些具体的细节，便容易主观上根据自己的感受做出一些推断;而在工人看来，容易理解为学生不理解，没有体谅他们的工作。

投诉的后果

![27](https://i.imgur.com/nTYeWEB.jpg)

BBS上曾有一题为《论食堂被舆论监督吓坏》的帖子， “包子凉了宁可不卖也千万不要被发帖‘天啊噜，学一食堂包子冰冰凉’，……，千万别拍照片发论坛上啊”一段反映出食堂员工受投诉帖影响之大，一旦发生投诉，罚钱在所难免，金额从100元到1000元不等。但是这种处罚结果并不会展现给同学，而是食堂内部的决定。在调研中，学一食堂一位工人向我们反映：“也会有学生投诉，这时领导的做法是扣工资和扣分，所谓扣分就是如果因为投诉扣了两分，之后每个月的工资都会扣掉200元，没有理由。”

住在畅春新园负责教学楼清洁的一位大姐向我们反映被学生举报厕所异味较大之后被扣工资50元。一部分同学对此也有所反映，BBS上有两条帖子写道：“本来一件小事，偏偏扣了500.食堂表个态，大不了说几句，下次注意点就过去的事，谁去扣的钱?扣的钱没有到学生手里，挨骂的成了学生。这件事到底从谁手里解决心理都有数，干什么都可能遇到极品顾客，但是极品顾客向你老板抱怨个小事，老板一下子扣好几百，那就是老板的锅。”， “所以有时候感觉，要是能有办法绕过上面和他们沟通就好了……自己也不会变成扣工资的直接原因……”

不仅BBS，为了进一步说明同学和后勤服务人员之间的直接交流的缺乏，我们举在访谈中了解的一个案例。之前负责某宿舍楼清洁工作的大姐屡次发现有学生大便之后不冲水和把卫生纸扔进坑里导致下水管道堵塞的行为。如果卫生间出了任何问题，都由她负全责。一旦有异味被同学举报，面临的就是罚钱。于是，她试图告诉学生不要在做这样的不文明行为，却苦于没有任何渠道。最后没有办法她就在厕所门上贴了一个条子,上面写着“上完厕所要冲水，你是北大博士”。但是，很快被宿管撕了下来，并且被严厉批评，说这是“侮辱北大同学”。

由此，我们可以看出，主要问题在于：一、现实中学工关系的不对等。一旦出现摩擦纠纷，工人面临的是经济制裁，而工资则是他们生活的保障。站在管理者的角度，施以经济压力是简单有效的约束手段，但是对工人而言，则是影响生存的惩罚。正是这种难以承受的压力成为了学工关系割裂的首要原因。二、发声渠道的缺失。处理纠纷和判定错误的基础是充分听取双方的意见，目的则是更好地建设校园，提供更好的服务。但是这种无形中取消一方辩解权的制度，却恰恰做不到这两点，自然问题会不断出现，建设和谐校园的一大方面—和谐的学工关系也难以真正达成。

### 被遗忘和不被尊重的身份

### 掏不出的证件和标签化的形象

在我们的话语体系里以及文安公司的招工信息中，北大保安都被塑造成一个维护校园秩序和有上进心的群体，但是在现实的接触中，误会和不理解依旧在师生与保安个群体之间的关系中占主要部分。进校门查证件是保安的职责所在，目的就是为了防止不明身份的校外人员进入学校带来音画，道理上讲的通的问题却常常不被师生所理解。“有的老师和同学嫌麻烦，不到跟前你不跟他要也不会主动出示，有时候还会抱怨说都走了多少遍了还查，但是人太多我们这流动性又大，很难记得住所有人，这也是职责所在啊，但是还是不被理解，其实只要提前掏一下证件双方就都好做了，也不会一帮人堵在后面。”据他们说，有的时候拦电车被车撞，查证被吼，查车被领导骂，被一些老师威胁辞退等情况也时有发生，有个保安说到“自己也很委屈，有时候也想发火，但是还是忍下来了，只能一遍遍解释，情绪肯定也不会太好”。门岗的人流量确实很大，很容易发生一些矛盾，但是他们的心声却很难表达出来。

被遗忘的群体

在食堂收餐盘的保洁员在工作中同样是被忽视的，燕南和勺园食堂的餐盘回收处，在处于工作台后的保洁员和送餐具的学生之间设置了一道隔板，隔着这层隔板，学生只能看到工人的收餐具的手，而工人则只能看到学生的手和餐具。他们的音容笑貌，他们的言谈举止都被省略了，展现出来的只有一双忙碌的手，迎来送往的都是餐具，用个不恰当的比喻，人与人之间的关系被人与物之间的关系所代替了，而隔板背后的人是谁已经不在重要。可是，他们毕竟是活生生的人，跟所有人一样，有自己的生活轨迹，有自己的想法，他们也住在北大，为北大的发展奉献着自己的劳动，劳动的成果被称赞着，劳动的主体却被遗忘了，甚至自己的容貌都只能隐藏在隔板后面，更不用说名字、年龄和籍贯，一些同学有时候想要微笑感谢都无从做起。

![28](https://i.imgur.com/uJPHsui.jpg)

在我们的访谈中还有一个与我们息息相关却被我们忽略的群体，那就是宿舍楼内的保洁员。他们三班倒着上，一般是早中下午各一次，每两层楼一名保洁员负责。他们的身影往往被我们忽略，或者从来就没有出现在我们的视线里。“我在公寓楼(内干)保洁，每天三点上班、你们都睡觉了，我们上班，厕所刷刷。”有的学生不知道或者不了解楼内的保洁员，有的同学并不体谅他们。《凌晨看到楼里保洁大叔工作》一帖评论区里，有这么一句话“之前从来不知道宿舍楼里还有保洁”，在访谈中一位阿姨说：“有些学生嫌弃保洁人员，在厕所门上贴告示被说是侮辱学生，一些学生乱丢垃圾，尿到饮料瓶里，一些学生嫌厕所臭，被举报扣工资50。”从上述材料可以看出来，宿舍楼内的保洁员虽然就在我们生活的地方工作，而我们对于他们的存在却很陌生，对于他们的态度也不甚友好，这一定程度上也构成了他们主体性的缺失的原因。

### 学校工会

工会在我国是体现工人主体性和维护工人权益的主要组织形式，在《工会法》中的定义为：“工会是职工自愿结合的工人阶级的群众组织”，《工会法》第二章第十条则指出：“企业、事业单位、机关有会员二十五人以上的，应当建立基层工会委员会;不足二十五人的，可以单独建立基层工会委员会，也可以由两个以上单位的会员联合建立基层工会委员会，也可以选举组织员一人，组织会员开展活动。”

通过查询北京大学官方网站的资料，我们明确北京大学是存在工会的，《劳动合同法》第64条规定：“被派遣劳动者有权在劳务派遣单位或者用工单位依法参加或者组织工会，维护自身的合法权益。”但是，在我们访谈到的工人中，只有3%的工人对于工会有一定的了解，参加工会的比例更是只有1%。在以上我们提到的组织和活动中，一些工人介绍说工会的会费为一年50-60元，而工会组织活动的频率很低，工会的人员并没有向工人具体地介绍过工会的参与方式和运作情况。这就导致很多人对工会一无所知，即便有的工人交了会费，实际参与度却依然很低。据工人反映，工会的常规活动是发放一些慰问品，如食用油等，而且慰问品的价格，与所交会费大致相符，比市场价稍低，“像团购一样，东西比市场价便宜些”，一位工人笑称。

由此反映出的两个问题，一是工会本身作为工人的自组织，在丰富工人生活，维护其合法权益方面的实际职用并不理想;二是工会的参与机制和覆盖范围还有待于进一步改进。另外，工会所组织的活动基本为定期活动，并无日常活动，这也进一步削弱了工会在工人之中的影响力。

## “被消失”的工友之家

工友之家是我们在调研过程中发现的一个工人和学生一起自发组建的文娱平台，但是自2015年的调研报告后就消失了。从访谈的结果来看，工友之家是工人们丰富生活，打发业余时间的好去处，在校内工人中影响广泛。

一位来北大工作了七年的工人说：“那时候下班没什么事情，工友之家的活动一个不拉的都参加了，什么唱歌，大合唱，跳舞，电影，讲课，量血压血脂，按摩推拿等等，一下了班，吃了饭就过来了，当时活动都在二教地下，虽然地下环境灰尘很大，但是大家玩的都很开心。”

![29](https://i.imgur.com/kd9a159.jpg)

<figcaption>我们在网上找到有关工友之家</figcaption>

<figcaption>在二教地下开展活动的照片</figcaption>

“我不会跳舞唱歌，一开始是我同事带我过去，看着其他人跳，认识了很多人，后面我就一直自己去了。”有的工人还介绍说，“跳舞一开始是学生带着跳，后面去跳的几个大姐自己就结伴组成了舞蹈队，还动员了想学的一起参加，舞蹈队的人一有时间就聚在一起，不光跳舞，还相互帮忙。”

除了活动，工人眼中的工友之家似乎更像一个集体，在那里工人走出了原子化的社会关系和标签化的形象。同一单位，同一住处原本陌生的人熟悉成了朋友，学生和工人的隔阂被打破，热心的同学们给工人带来了温暖。

“现在的人都好现实，这些学生不图名不图利，真不容易。当年工友之家可红火了，人可多了。那时候有同学会打着拍子教大家唱歌，指挥大家合唱。这些学生平时生活中都很关心我们，真比得上亲人了。”

与工人相比，工友之家在校园学生中间的影响力要小得多，从16年开始，工友之家的声音逐渐减少，入职稍晚的工人甚至没有听说过工友之家。据说跳舞的场地被改造，没了地方，同时不少单位因为对工人和学生接触存在某种顾虑，因此限制本单位的职工参与工友之家的活动。

“以前还能和学生工人一起娱乐，在学校能有个家一样的感觉，现在在楼里值班，就我一个人，经常加班到12个小时以上”。某师傅来北京六年了，在北大换过两份工作，虽然已经有五十多岁了，但为了还贷款，仍然在外打拼。刚来时该师傅想学英语，通过一次偶然的机会遇到了工友之家的学生，学到不少有用的知识，之后便融入了那个集体。2016年之后，该师傅换到了学校外包的物业公司，平时负责楼内维护秩序，登记进出人员，楼内有很多老师，但平时更多的是被叫去打杂，没有交流，一年来的这种工作让他感觉很闷，他很怀念过去在工友之家的日子。

和该师傅一样，对工友之家表达类似想法的工人还有很多，大家都对工人之家的消失表示疑惑和惋惜。

结语
在此次访谈结束后，当我们汇总出访谈数据，并与2015年的报告进行对比之时，我们发现在学校进行整改两年后，工人待遇中不合法的现象仍然泛滥。四成以上的工人拿不到自己的劳动合同，七成以上的工人没有完整的社保，半数工人的加班费仍然不明不白。直属单位的工人依旧是劳务派遣为主，外包公司占据了学校大量的工作岗位，却游走在法律之外。地下室拥挤的生活并未得到根本改善，两点一线，乏味枯燥构成了生活的大部分。

当我们放下统计数据，放眼社会，何处是归途?学校仅仅是社会的缩影，校内工人只是千万北京外来务工中的一员，等待他们的不应该是诸如大火之后的搬迁，还应该有我们的关注。

真正品质校园的建设，离不开劳动者的汗水，也离不开对劳动价值的承认与尊重，在依法治国的今天，值五一国际劳动节、北大120周年校庆和马克思诞辰200周年到来之际，我们尝试以下呼吁：

1、校方及后勤主管部门增强责任意识和担当意识，切实重视本访谈所揭示的问题，会同各方加强监督和管理，敦促相关用人单位严格遵守法律法规，调查在用工方面存在的不合法现象，及时纠正劳动合同缺失、不合理罚款、发放加班费不规范、漏缴社保等违法之处，切实保障工人的尊严与合法权益，积极改善工人食宿条件，并将调查和整改的详细结果尽早向校内师生进行公示。

2、校方协调后勤等部门在工人日常活动场地和资金等方面给予大力支持，为校内工人提供能够在日常进行文娱休闲和自我提高的平台。

3、校方加强制度建设和监督机制，切实保障学生和工人的参与权。如可借鉴食堂监督员制度，建立校内工人权益保障与监督小组，由校方、学生、工人、用工单位等各方产生相应代表组成。

4、所有关注关心北大工人的师生，能够共同努力，关注校内工人权益，助力学校的后勤用工制度建设，推动北大早日向世界一流大学迈进!

北大百廿校庆，校内工人不应被忽视，而本应属于劳动者的五一劳动节更不能让他们缺席。



最后祝广大的劳动者节日快乐!

2018年北大工人情况访谈小组

2018年5月1日


注：1、为保障受访工人的隐私，所有身份信息均在不影响访谈分析结果的前提下进行了相应处理，请勿直接对号入座。

2、本访谈所展现的只是北大校内工人现状的一部分，我们欢迎校内媒体/自媒体等个人或组织针对相关问题开展多角度的调研与思考。

3、由于各种限制，本访谈定有诸多局限之处，如果您对本访谈以及访谈所揭示的问题有任何意见或建议，请发信至pkulabor2018@163.com。

[1] 北京市的最低工资标准调整为每小时不低于11.49元，非全日制从业人员小时最低工资标准提高为22元/小时。

[2] 1920年，在北京大学的五一纪念会上，蔡元培校长发表了题为“劳工神圣”热情洋溢的演讲。他提出“凡是用自己的劳力做成有益他人的事业，不管他用的是体力、是脑力，都是劳工”，并强调“劳工当自尊，不当羡慕其他不劳而获之寄生物”。
