---

layout: post

title: 寻找 “北大精神”，拒绝容忍权力无限扩张

categories: Archive

date: 2018-04-25 09:31

tags: 北大校庆

description: 最近，北大信息公开事件闹得沸沸扬扬，北大一些做法一时成为舆论热议的焦点。早在北大110周年的一次民间校庆时，钱理群教授就曾做了寻找“北大精神”的演讲。在这次演讲中，钱老首度提出，现在的大学教育培养的是 **“精致的利己主义者”** 的观点，呼吁直面现今教育的现实问题，**拒绝容忍权力的继续扩张**，提醒当代学子既要仰望星空，保留“做梦”的能力，也要脚踏实地，勇于对自己、对社会、对国家承担责任。这篇演讲十年之后读来，仍不失精准犀利，其恳切的言辞中也包含着对北大深切的期盼。

---

文章来自微信 ~~[故问研修班](https://mp.weixin.qq.com/s/1ZAAMhSDNOPSMw3gY5FLvA)~~

---

钱理群，1939年1月30日生于重庆，祖籍浙江杭州。北京大学中文系资深教授，博士生导师，并任清华大学中文系兼职教授，中国现代文学研究会副会长，20世纪80年代以来中国最具影响力的人文学者之一。他以对20世纪中国思想、文学和社会的精深研究，特别是对20世纪中国知识分子历史与精神的审察，得到海内外的重视与尊重。钱理群一直关注教育问题，多有撰述并为此奔走。他被认为是当代中国批判知识分子的标志性人物。

> 最近，北大信息公开事件闹得沸沸扬扬，北大一些做法一时成为舆论热议的焦点。早在北大110周年的一次民间校庆时，钱理群教授就曾做了寻找“北大精神”的演讲。在这次演讲中，钱老首度提出，现在的大学教育培养的是 **“精致的利己主义者”** 的观点，呼吁直面现今教育的现实问题，**拒绝容忍权力的继续扩张**，提醒当代学子既要仰望星空，保留“做梦”的能力，也要脚踏实地，勇于对自己、对社会、对国家承担责任。这篇演讲十年之后读来，仍不失精准犀利，其恳切的言辞中也包含着对北大深切的期盼。

今天我们是几代的北大人在这儿聚会，我刚刚想了一下，我是30年后的一代，看到这里有几个蔡恒平他们是60后的一代，然后70年后的一代，在座的是80年后的一代，这么几代人这样聚在这里啊，来纪念北大的110周年。这是一个民间的纪念，所以我很自然地想起十年前，北大的百周年校庆，那是非常热闹的非常轰动的，但是当时呢, 实际上百周年校庆也有两种纪念，一种就是官方的纪念，那是规模宏大，气势磅礴；另外还有一种民间的纪念，我们当时还专门演出了一出话剧叫做《蔡元培》，当时围绕《蔡元培》我们开展了很多活动，其实中心就是要寻找老校长，寻找北大的精神。

刚才主持人讲到我当时写了一篇文章，叫做想起七十六年前的纪念，也就是说是在二十四周年校庆的时候的纪念，那个纪念是当时胡适他们主持的，胡适当时作为北大的教务长，他在这个会上就宣布说：

我们应该反省北大，其实我们北大是徒有其名。

当时我看了很震撼，就是老一辈人把校庆当成一个反省的日子，而我们当时的北大的百周年校庆是一片颂扬之声。所以我当时就唱了一个不和谐的声音，就是说要反省北大。其实这是一个很正常的命题，但是没有想到掀起了轩然大波，但是我想那个纪念，就是十年前的这个民间的纪念它将会流传在北大的校史上。

今天我们又在这里进行十年后的110周年的也是一个民间的纪念。因为我听说今年因为奥运会的原因，所以上面有规定，奥运会之前拒绝大规模的纪念活动，所以今年北大，好像对110周年校庆校方是准备低调处理了，我也同意这样的做法，不一定每一次都搞那么热闹，因此我们今天在这里搞一点民间纪念，我想就有一种特殊意义。

### 梦的精神

刚才老汉说《寻找北大》这本书是遗老遗少的书，那么我就是属于遗老的，所以对于北大历史我大概是有一点发言权的，但是北大的现实我确实是没有发言权的。因为我在2002年8月份从北大退休以后，基本上就和北大很遥远了。

我记得我在一篇文章里讲到我说在我退休之后在我的感觉当中，北大已经变成十分的遥远。更准确地说，现实的北大对于我是越来越陌生了，因此我需要将心中的北大推到远处，成为一个永恒的记忆，一个永远给我带来温馨的梦，尽管明知其虚妄，却好像鲁迅之故乡之于他的记忆，愿意被它哄骗一生，并时时反顾。比如说北大对我来说是一个遥远的梦了，但还要时时反顾，因为要时时反顾，所以就主编了这套（本）《寻找北大》，而且今天在这里还来讲北大，其实这对我来说都是很遥远的事情了。

讲到北大，我想还是从老汉刚才这首歌说起。因为这首歌，我看了歌词就很受震撼，今天听了他自己演唱之后我更受震撼，我真是想建议，就是我们北大把这首歌作为我们的校歌。我在这个书的序言里说过，北大是每一个北大人，所有的中国人的精神的梦乡。我顺便在这里做一个广告，就是我马上要出一本书，就准备把我所有关于北大的文章都聚集起来。这本书我想的名字就叫做《精神的梦乡》，副题是 “我之北大观”，这个书出来以后，我会送给一些同学的。

我就想到这样一个问题：**一个人不能没有梦，一个无梦的人生是很难想象的，但是更重要的是一个民族，特别是民族的年轻人，如果没有一个可以做梦的地方，那样一个精神的净土，精神的圣地，那可能是更加可悲的**。

前几年，我几乎每年都要收到大量的外地的中学生给我写信，他们都表现对北大的无限的向往之情，我每次看到这些信，心里的感情都很复杂。因为我在北大，我知道，这些青年梦中的那个北大已经不复存在了，所以我每次写信都给他们去泼冷水，我说我欢迎你们来北大，但是你们先别做梦，你们做好准备，来了北大以后你们会大大地失望的。

但后来我老这么回信，我一想这个不对，这个你老把别人泼冷水也不行，年轻人总要做梦，总要找一个地方，一个属于精神的净土，精神的圣地，让他做梦，如果这个地方都没有了，那这个国家就成问题了，这个民族就成问题了。所以哪怕这个梦多少带有点虚幻性，可能也得让它保留着，必须有一个精神的梦乡，一个人是这样，一个国家，一个民族也是这样。我想这就是北大，所有的北大人感到骄傲的地方，就是我们生活在一个精神的梦乡里。

我今天要说的是什么意思呢，我想谈一点，也许有一点不大合适宜也不大能被人接受，我认为尤其在今天的中国，不能没有梦。这个话好像说的有点不大对啊，因为今天的中国实在是一个无梦的国家，有点太脱离现实了，但是我还是固执地认为，**今天的中国，尤其需要做梦**。

什么意思呢？所谓梦就是超越于现实，特别是现实物质之上的一种精神的追求。梦本质上就是这样一种东西，超越于物质生活之上的一种精神的追求，为什么说这种追求对今天的中国特别重要呢？我想这就需要对中国的这三十年的历史做一个回顾。

今年正好是改革开放三十周年，我们回顾改革开放三十年，我们可以说，这三十年来我们国家经济的发展，人民生活的提高，这可能是三十年来最基本的主要的收获，也就是说经过三十年来的努力，中国，终于基本上解决了温饱问题，基本上进入了一个小康社会，这是一个非常巨大的进步，这是来之不易的一个进步。当然今天的中国还有很多的贫困的地区还有很多的贫困的人群，还有很多很严重的问题，但是就大多数人来说，或者就大多数地区来说，我们已经基本上解决了温饱问题。

在一个国家一个民族基本上解决温饱问题以后，这个社会应该向哪里走，这个国家应该往哪方向去发展，就成为一个非常大的问题。或者说今天的中国正走在一个十字的路口，中国在经济有了发展，在基本解决温饱问题以后，中国应该向哪里走？这是我们当下所面对的这样一个问题。

我这些天，这些年，一直在思考这个问题。我想提出一个这样的想法，当然可能是梦，又是一个新的梦，我这人不断地做各种各样的梦。我觉得在中国基本解决温饱问题以后，我们现在需要的是四大重建：

一个是制度重建，一个是文化重建，而文化重建的核心是价值重建，还有一个是生活重建。就是说我们需要建立一个能够让中国这块土地上的大多数老百姓能够安居乐业的一个比较合理的比较健全的社会制度，一个健全比较合理的文化，一个健全比较合理的价值，以及一个健全比较合理的生活。

这样的四大重建，无论是**制度重建**，**文化重建**，**价值重建**还是**生活重建**，它其实都是一个精神问题，都提出一种超越于物质的精神的追求，而这样的一种追求它是需要用理想之光来照耀的，也就是需要梦之光来照耀的（梦之光也就是理想之光）。我们常常说一个人最合理的生存状态，是一个什么样的状态呢，我想用两句话来形容，就是应该**脚踏大地，仰望星空**。

我们现在就要解决这两个问题，作为人来说，或者作为一个知识分子来说，或者作为一个大学生来说，如果要寻找一个合理的生存方式的话就要解决这样的问题，**一个是如何脚踏大地，如何更密切地和我们生存的这块土地，土地上的人民，土地上的文化保持密切联系；另一个就是如何仰望星空，如何有一种超越于物质现实生活的超越性的追求，一种精神的追求**。我想这就是今天的中国特别需要这样一种梦的精神。对，这是我的一个理解。

### 北大的使命

那么这里讨论一个问题，在这样一个制度当中，这样一个制度重建文化重建价值重建生活重建的问题当中，中国的大学，或者说中国的北京大学，它应该承担什么责任，他应该有什么使命，它应该发挥什么功能，它应该发挥一种什么样的精神？这就是我们今天要讨论的第二个层面的问题。

按我的理解，或者说我的大学理想——我认为 “大学之为大学”，就是它有两大功能。哪两大功能呢，就是它在整个民族的精神的重建，民族文化的重建当中，它有两个功能：

一个是**保守性的功能**，所谓保守性的功能就是什么呢，就是思想文化学术精神传统的一个传递和坚守的任务，就是大学担负着要把一个国家的思想文化学术精神的传统传递下去，一代一代传递下去，并且要坚守下去。因此大学，特别是北京大学这样一所大学，它应该成为民族精神的一个堡垒，或者说民族精神的一个圣地。这是大学的一个功能，我称之为保守性的功能，就是传递、坚守的一个功能。

另外一个，大学有**革命性的功能**，也就是说它应该有一种批判的精神和一种创造的精神，它应该对社会发展的既定状态，对已有的文化生活体系以及人类本身作不断地反省、不断地怀疑、不断地批判，并且进行新的创造，这样它就能够成为新的思想、新的文化、新的学术的发源地。

简单说两句话，**一个是坚守，坚守民族精神，坚守思想文化；另一个是批判、创造，创造新的思想，新的文化，新的学术**。

我们现在一直在说要创办一流大学。什么叫一流大学？我觉得一流大学就是要有两个标准，一个标准就是一流大学应该是一个民族的精神堡垒，第二个一流大学应该是一个民族的新思想、新文化、新学术的发源地。

这就要说到北大的历史，北大的光荣历史就是在中国的思想文化的发展中，在中国的社会经济的发展起到了这两大作用，起到了精神堡垒的作用，起到了新思想源泉的作用、发源地的作用。因此北大的历史上有两次光辉时期，第一次就是 “五四” 新文化运动时期，就是蔡元培先生所领导的那个北大，那个北大成为当时中国的 “五四” 新文化的现代新文化的发源地。我觉得第二次辉煌就是西南联大，当然西南联大它还不仅是北大，它还包括清华，包括南开。那么西南联大在一个民族危难的时刻，成为我们民族精神的一个堡垒，同时它也成为新思想、新文化、新学术的发源地。我们现在看到很多的非常出色的科学家，出色文学家、思想家、哲学家，创造一种新的文化，都是西南联大所创造。

所以我觉得我们要讲**北大精神**，北大的传统，可能在我理解中主要就是两个东西，**一个是坚守**，它所体现出来的一种坚守精神；**另一个就是它所体现出来的批判和创造的精神**。这就是北大的传统。

那么大学既然是有这样的两个功能，一个坚守功能，一个批判创造功能，因此北大，或者说我们的大学，必须关怀现实，并**和现实保持一定的距离**。而且应该保持两个距离，大学应该和时尚，和世风流俗保持距离。我是不主张不赞成大学要与时俱进的，我觉得大学有时候需要保守，需要和时风流俗，需要和时尚的东西保持距离，跟时髦的东西保持距离，这是一个距离。

大学第二个距离，它必须**和现状现状保持距离**，包括政治经济思想文化学术的现状，现成形态，这样才能保持一种批判的态势，这就是两个距离。既要和时尚保持距离，又要和现状保持距离。

那么这样呢，它就应该有一些相应的精神，我觉得大学特别需要三种精神：一个是**沉静**，一个是**清洁**，一个是定力。沉，清，定，三个字，是大学基本精神。就是说当整个社会陷入喧闹的时候，大学、大学里的老师和学生应该沉静；当整个社会的风气被腐败所污染的时候，大学、大学里的老师和学生应该清洁；当整个社会陷入浮躁的时候，大学、大学里的老师和学生应该有定力；这就是静，清，定——沉静，清洁，定力。

用我们传统的话说，大学和我们大学的老师应该洁身自守，保持自我精神的清洁和纯正，同时要自守，要守住一些基本的规范，学术的规范、治学的规范，还有做人的规范，它是不受外界影响的，不受任何压力和诱惑左右的，它是决不放弃绝不让步决不妥协的，是要守住一些基本的东西。当然今天说这个话是有些痴人说梦，因为现实的中国，现实的大学，也包括现实的北大完全反其道而行之。

社会喧闹，大学更喧闹；社会腐败，大学更腐败；社会浮躁，大学更没有定力。

这就是我们现在面对的现实。

我觉得现在**我们中国的大学弥漫着两种可怕的思潮，一个实用主义，一个虚无主义**。所谓实用主义就是完全为个人利益所用，完全被个人利益所驱使，有用就干，无用不干，因此必然是一种虚无主义，就是除了时尚和利益之外一切都不可信，一切都不足靠，一切都可以在与时俱进的口号下放弃抛弃。

这种**实用主义和虚无主义就导致了大学的两个东西，一个是知识的实用化，一切与实用无关的知识都被大学所拒绝**，既被大学里的老师所拒绝，也被大学里的学生所拒绝。**还有精神的无操守，拒绝一切精神的追求和坚守**，我觉得这两个思潮，就是实用主义和虚无主义所导致的知识的实用化和精神的无操守，这是现在大学里的两个基本的弊病。这是一个方面，我们没有和时尚保持距离，相反我们同流合污了。

另一方面，就是大学的批判功能，大学的创造功能，就决定了它一定的社会和现状，和社会政治历史的现状保持距离，它才能保持一个怀疑的批判的态度。所以在我看来大学里的老师学者，他应该是公共知识分子，或者大学里的学生应该努力培养自己成为公共的知识分子。所谓公共知识分子是什么意思呢，就是他所代表的是公共利益，所坚守的是民族文化和人类文明中的普世性的价值和理想，以及作为生命个体的思想与学术追求。一个是普世价值，一个是个人的，个性的学术的追求，这是代表公共意志的。

所以，**大学绝不能代表国家意志，绝不能代表某一个利益集团的意志，更要防止自己成为一个既得利益集团，这样大学才能真正保持自己精神的独立和思想学术行为特立独行**。我觉得大学里的学生和老师一个基本的品格、基本的风格，就是独立，精神独立和行为学术思想的特立独行，这样才可能有出于公心的批判和创造，才可能真正创造出能够成为社会公器的一种新思想新文化新学术。而我这样的理想同样是远离现实的，因为今天的社会正要求大学里的老师学者学生，成为现状的维护者和辩护士。要求，八个字，**赞成**（拥护），**解释**（用你的学术解释这个理论何等伟大正确，给它赋予合理性、合法性）。第三个就是**宣传**，第四个就是**演戏**，这就是今天对于大学学者的要求。

而这时得到制度的支持的，今天大学这种评职称，博士点等种种制度，在我看来是新的科举制度，请君入瓮。你只要服从，同意、解释、宣传、做戏，那你一切都有，有房子，有职称，有地位，就成为重点学科，就能评奖；如果你拒绝同意、解释、宣传、做戏，一切都没有。

就是这样一个制度的诱惑下，应该说大部分或者相当多的教授学者都被收编。开始有点扭扭捏捏，后来慢慢习惯了，越来越舒服，因为这实在舒服，只要你服从这些就一切都有，最后就舒舒服服地被收编。当然坦白说我今天来敢说这个话，原因在哪里，因为我已经退休了，如果我现在还在当教授，可能我还没有勇气说这番话。

这是制度造成的，不是个人的品德个人的什么东西，而是这个制度造成的，使得你失去了大学应有的独立自由创造的精神，这就是我们正在上演的还会继续上演的大学失精神、失灵魂的悲剧。而且很多的悲剧今天都很难说是悲剧了，因为悲剧还能给你悲壮感，现在都成了滑稽戏了，现在大学里上演的滑稽戏太多了。

这就是我今天要说的第一个意思。我从我的大学理想出发、从我的北大梦出发，我所谈的今天大学失精神的问题，所谓失精神简单说就是失去了坚守精神，失去了独立自由批判创造的精神，而我们今天在这里纪念北大110周年校庆，就是要**寻找北大精神，唤回这个正在失去的坚守精神，正在失去的独立自由批判创造的精神**。这是我今天要说的第一个问题，这是从理想层面。

### 教育的现实层面

那么从现实层面回来，我想来谈一谈2007年我心中关于大学教育问题的两大疼痛。尽管这一年来我的注意力已经不在大学，我更关注中小学教育，更关注农村教育边远地区教育，因为我对大学已经失望了，也许在农村，在边远地区还有说话的某种余地。但我还是很关心大学教育，有两件事让我非常痛心，我称为我的2007年之痛。

**第一痛是关于我们北大的，我们北大三角地被取消了**。这件事引起我很大的震动，我想不只是我，应该说引起了所有的老北大人的心中之痛，因为三角地聚集了我们最神圣最美好的记忆。我说北大历史上有两个标志性的地方，一个是老北大，解放前的北大，今天沙滩那里的北大民主广场；第二个地方就是今天的北大三角地。

这两个地方是北大历史上最神圣、最有纪念意义的两个地方。因为北大最光辉的历史瞬间发生在这两个地方。我曾经说过，北大历史有三次辉煌，我现在要补充，北大历史有四次辉煌，但是在座的同学可能只知道1917的五四新文化运动，其实还有三次辉煌，一个就是1957年北大 “五一九” 民主运动，这是一个北大学生自下而上的社会主义民主运动，这个运动就发生在当年的大礼堂，和今天的百年讲堂和三角地。

第三个辉煌，大家可能忽略的，1980年，北大有一个选举运动，可能大家都完全不知道，当时中国改革开放初期，改革到底到哪里去，北大学生站出来提出对中国未来改革的种种设想。最近我写了一篇文章，同学们可以去网上看一看，就是《不能遗忘的思想——1980年中国校园民主运动》。

再一次就是1989年。所以北大历史上有四次辉煌，我觉得北大历史上应该记住的几个日子，就是1917，1957，1980，1989，而这样四个时刻都是和北大民主广场和三角地联系在一起。所以民主广场和三角地都成为北大的精神象征，现在这个象征在整顿校园的合理合法的名义下被撤销了。

这个讲起来很合理，要整顿校园秩序啊，好像你也没有什么话讲。实质上背后隐含了巨大的问题，问题不在于三角地撤不撤，而在于由此提出了两个问题：一个问题是北大还要不要建立一个师生们自由表达思想、交换思想的精神空间，或者说如何重新建立一个精神空间。

**第二个问题，就是我们要不要实行北大校园民主，我们怎样实行校园民主**。可惜我们已经很多年不提校园民主了，我觉得非常奇怪，因为民主已经是当下流行的词语，而且已经进入十七大报告，我们要建立社会主义民主，但是为什么校园民主就很少提呢？我在退休之后曾写过的唯一的一篇关于北大的长文，没有多少人人注意。那篇文章中谈到了这个问题，题目叫做《中国大学的问题与改革》。我在文章里说现在有一个非常重要的问题，是教师在学校中的地位和权力的问题，实际上现在高校里的普通教师是既无地位也无权利的，更没有维护自己权利和利益的组织，工会的职责被缩小为每年组织一两次联谊活动，所谓职工代表大会最多是一种咨询作用，特别是青年教师，实际上已经成为学校里的弱势群体。

当今的中国大学，即使是教授也缺乏独立的利益欲求和自由表达的权力，以及参与学校各级行政领导的选聘，参与决策过程，制定游戏规则的权力。但教授因其学术地位还有一点有效的发言权，而青年教师连学术上的发言权都没有，这种状况严重地影响了教职员工积极性，成为束缚教学和学术研究生产力的主要原因。

这里有两个问题我百思而不得其解，我觉得中国知识分子也很怪，中国的大学也挺怪，**一个是中国的知识分子老想为别人争取权利（当然公共知识分子是有义务为别人争取权利的），却很少想为自己争取权利，不争取自己的民主权利**，这是我不理解的；**第二个，好像中国的大学是一个特别的地方，中国的教育部门老是例外**，我觉得很怪。

比如说，现在全国都在谈政府部门的职能转变，要分权，要放权，然而教育部越来越扩大自己的权利，几乎扩大到难以想象的地步。比如前不久竟然宣布，要规定中小学音乐课都要唱京戏，这种事该教育部来管吗？之前，还有提倡在中学跳华尔兹舞，这是教育部门改改的吗？**权力扩张到这种可怕的地步**！

全国改革，要放权，教育部的趋势相反，现在全国进行政治体制，社会改革，要搞基层民主选举，我想大学能不能进行民主选举呢？我不知道你们现在研究生会学生会是怎么选的，研究生会学生会是不是可以直选，是不是可以搞竞选？在农村可以搞，为什么大学不能搞呢？你说农民没有文化，那大学生总有文化吧，还有校长系主任能不能民主选举？

我刚刚说十七大报告已经提出来了，要政治体制改革，要民主，那大学能不能成为民主实验区呢？北京大学是不是可以做实验呢？不是说民主需要素质吗？北京大学师生素质最高了，而且成本也不高，都在一个校园里，为什么不可以呢？所以我百思而不得其解，教育部门老是例外于国家的改革，当然我这个话也是胡思乱想。我早就提出建议，认为北大应该成为民主改革的特区，可以做些试验，可以先走一步。当然这都是我的痴人说梦，这是我的第一痛，由三角地被取消而联想起一些基本的大学空间问题和校园民主问题。这是我的一大忧虑。

第二个，去年看的两条新闻，看得我毛骨悚然。一条新闻说是大学新生一报到，（这是去年2007年的报道）学校领导就约见学生家长，提出现在开始就要为学生未来的职业做准备，要对学生进行职业的训练和指导，好像我们北大还有专门的组织，据说指导学生有两个东西，根据求职的需要来设计自己四年的大学生活，还要一个是让这些学生提前和招工单位的人事部门见面，以便公关。这真的让我大吃一惊。

我曾经感慨中国的中学教育已经除了应试教育之外都进入不了中学教育。这里我想讲一讲我的一个亲身经历，前几年，我到北大附中、北师大实验中学去开选修的鲁迅研究课程，我去的时候，老师们向同学们宣传，说同学们，你们都向往北大，但是钱先生退休了，你们到北大也听不到钱先生的课了，现在钱先生到你们中来讲鲁迅，这是百年难遇的机会，你们要好好听。

那是2004年的事情，可以想象中学生们非常兴奋，开始人非常多，到后来人越来越少，最后坚持下来，只有二十人到三十人之间。后来有个中学生，这学生很坦率，他对我这样说：**钱先生，不是你讲的不好，也不是我们不愿意听你讲课，实在是因为你这个课与高考无关，所以我宁愿考上大学之后再来听你讲课**。那是给我很大的刺激，我就意识到一点，当今的中学，与应试无关的教育就进入不了当今的中学，不管你的教育多好。

现在我又看到了新的危机，**与就业无关的教育是不是也进入不了大学教育呢**。我为什么提出这样的问题呢？其实这也是我 2007 年的一个痛。2007年暑假的时候，清华大学举办了一个全国的关于通识教育的培训班，我讲完之后有一个大学老师举手提了一个问题，说钱先生，请你讲一下在当下大学里讲鲁迅的课，怎样帮助学生求职呢？（笑）他觉得听了我的鲁迅的课，就能帮助他找到更好的职业了。

所以，我当时听了是目瞪口呆不知所措，但心里是凉透了，我无意责怪青年教师，因为这是他的职业，因为他在上课的时候别人也这么问他，学生问他你这个课和就业有没有关系，有关系我来听，没关系我不来了。这就非常可怕，当年蔡元培先生提出警告，说大学不能成为职业培训班。

当然，我想北大还不至于，然而北大也有这个趋势。也就是说，今天的整个的教育是围绕着应试和就业来展开的，这是一个非常可怕的现实。当然这也联系着一个很严肃的问题，就是就业和大学教育的关系问题。

我曾经多次的和80后的大学生讲，**坦白地说，我非常同情你们这一代，你们真是不幸的一代，中学碰到应试教育，好不容易考上大学又碰到失业问题，面临着毕业以后可能没有工作**。这在过去没有过，都集中到你们这里来了。像我读中学的时候，当然56年很特别了，大学招生人数比中学毕业人数要多，不存在应试问题，完全不一样。

再早几年，我想蔡恒平他们那个时候，可能也不存在这个毕业即失业的问题，那是毕业了总有工作的。可是你们恰好碰到了，两个东西都给你们遇上了，这是这一代大学生所必须面临的现实的问题。因此我们不能否认就业问题给我们大学教育提出了许多新的问题新的挑战，我们大学教育也不能回避就业问题，正是这一严峻的现实，出现了很多似是而非的论调，所以我要在这里澄清一下，谈谈我对大学教育和职业关系的四点看法。

**第一，我认为大学就业难，确实暴露了大学专业课程设置、教学内容比较陈旧，不能适应社会经济科技发展的新要求，造成了大学生知识结构的缺陷和不足**。这是大学课程设置上的问题，确实是就业难的一个重要原因。因此我认为，大学应该进行教学内容、课程设置上的更新调整。这是大学教育改革必须有的一个内容。

**第二，我们要具体分析一下，大学生不能适应现在社会发展，我觉得一个很重要的原因是精神素质的问题**。我仔细注意了一下现在很多就业单位对现在大学生的批评，我觉得我们大学生应该听一听这样的批评。他们的批评主要认为现在的大学生，一个是独立自主能力比较差，一个是缺少团队精神，不善于和他人合作，还有知识面太狭窄，再一个独立思考创新能力不足。这些问题，其实都是精神素质问题，而这种精神素质问题，其实就是应试教育的后果。所以正是因为这样，大学教育应该补这个课。

现在大学生不能适应社会发展，就是因为他们不能成为一个健全发展的现代人。中学的应试教育造成了你们这些毛病，这些弱点应该在大学里弥补**，大学不仅仅使你成为一个有知识有技术有技能的人，更重要的是成为一个健全发展的现代公民**，这是大学教育应该要补这个课。

**第三个问题，我们对就业问题的看法，应该有一个长远的眼光**。怎么讲呢？我们常说未来社会是一个知识社会、信息社会，这个社会有什么特点呢？就是每一个职业变化很快，很少有固定一个职业的人，因为随着社会科学技术知识的发展，不断有一些新的专业、新的课题、新的职业出现。这使得每个人必须不断变换自己的职业、自己的社会角色，这是现代信息社会的一个很大的特点。这和我们那时候不一样，我们那个时代分配到哪里，就永远不动了，一辈子做这个事儿。现在不行，它是不断变换的。

因此，现代社会对人才的要求是什么呢？它要求两种能力，**一方面，应变能力要强，一方面创新能力要强**。应变和创新的能力，这是新的人才观，是未来社会发展的要求。所以，如果你过早的只顾及某一个职业，某一方面的训练、过分狭窄的训练，就不能适应未来的竞争。

所以，**未来社会的竞争，是一个素质的竞争，一个学养的竞争，一个创新能力和应变能力的竞争**。因此仅仅从职业的角度来考虑，也应该为自己设计一个全面的发展。

在我看来，大学里，除了我刚才说到的一些精神层面的问题、要成为现代公民之外，至少应该具备三大能力：

- **一个是终身学习的能力**，这里包括中外语言的听说读写能力，还有利用文献、工具书等能力。

- **第二，研究能力，** 发现问题、提出问题、解决问题的能力，思考实验计算的基本方法和能力。

- **第三是思维能力，** 具有开阔性广泛性创造性、批判性和想象力的思维能力。

具备了这三大能力，以后就可以不断地变换，你的适应能力和创新能力就强了，这才是未来社会所需要的人才。如果大家放弃这一点而只一味追求眼下的市场需求，把自己的视野、知识面、能力训练弄得非常狭窄，那么即使取得了一时之效，可能找到了一个工作，但是由于底气不足，在持久技能竞争中迟早要被淘汰。

所以，我要提醒在座的诸位，你们已经吃够了应试教育的苦了，在应试教育之下，你们的学养、素质已经非常的狭窄了。如果在大学里再浪费大好时光，再只关注一些眼前的利益，而忽略对自己长远发展的培养和训练，那你的目光短浅，你要抱恨终生的。所以我想，即使从职业的角度说，今天的大学生也应该着眼于自己长远的发展，把自己培养成为应变能力很强的创新能力很强的新的人才，不然迟早要被淘汰。

第四个方面，当然，我们也不可能否认具体技能培养的问题，但我觉得只要在工作之前进行训练就行了，**大家必须建立终身学习、终身进行职业技能培训的理念**。具体的培训是可以通过训练班来解决的，但不是在大学里来解决的。当然，大学适当开一点这种课我也不反对，但大学主要的，我想还是我刚才所提到的两方面的发展，一个是作为人的全面发展，一个是基本能力的培养。否则的话，如果眼光狭窄地把我们的大学办成一个职业培训班，那可能再度耽误大家，而且可能整个地耽误我们国家民族的发展。这是我去年感到沉痛的第二个新闻。

第三个新闻也让我吃了一惊。有这么一条新闻，说新生未入学，家长和学生就忙成一团，通过一切途径，寻找各种关系以求打点照应。据说很多大学生，还没上大学，就开始打听，大学英语课，是某某老师教的？哪个给分数高？还有团委和学生会哪一个比较有前途？评奖学金是不是只看成绩还要在学生会混得很好？还没进学校就开始打听这些消息，据说有一个没有正式报到的新生，就把学校里主要领导、团委书记、班主任都摸得清清楚楚。这真让我目瞪口呆。

公关思维、搞关系思维，已经体现到大学一年级学生中，但这背后却隐藏着一个更加严重的问题，这和我们北大是有关系的。我们经常说北大是全国的尖子的集中地，北大要培养尖子，要培养精英。我自己并不一般地反对精英，但是就我个人来说，我更重视普通的 “非精英”，更重视普通的学生。正像鲁迅所说：

我不反对天才

但是我更重视泥土。

鲁迅让大家都做做泥土呵。但是像北大这样的学校，培养精英是无可厚非的。我们现在需要讨论的是，**我们需要培养什么样的精英，或者我们每个同学要把自己培养成为什么样的尖子**？这个问题是更加重大，也许是更加严峻的。我现在恰好对这些尖子学生非常担心——当然不是全体——但是相当一部分尖子学生，也包括北大的尖子，让我感到忧虑。在我看来，真正的精英是应该有独立自由创造精神，也是上次我在北大中文系演讲时所提出来的，**要有自我的承担，要有对自己职业的承担，要有对国家民族社会的承担**。在我的理解中，是这样的精英。

### 精致的利己主义者

但是我觉得我们现在的教育，特别是我刚才说的，实用主义、实利主义、虚无主义的教育，正在培养出一批，我概括为 **“绝对的、精致的利己主义者”。** 这什么意思呢，所谓绝对的利己主义者，就是一己利益成为他们言行的直接驱动力，为他人做事，全部是一种投资。所谓 “精致” 指什么呢？他们有很高的智商，很高的教养，所做的一切都合理合法无可挑剔，他们惊人地世故、老到、老成，故意做出忠诚姿态，很懂得配合、表演，很懂得利用体制的力量来达成自己的目的，这样一些“绝对的、精致的利己主义者”。

坦白地说，我接触了很多这样的学生，因此我形成了一个文学的概括。我自己学文学，我下边是一个文学的概括，不是具体指某一个人，我接触了很多人之后概括出这样一个典型。

比如说，有一天我去上课，看到一个学生坐在第一排，我一上课他对我点头微笑很有礼貌，然后我开始讲课。在一个老师讲课的时候，也有一些期待，讲到哪里学生会有什么样的反应。

这个学生很明白我的期待，我期待微笑他微笑，我期待鼓掌他鼓掌，就是说他听懂我的课了，我很高兴，我就注意到这个学生了。下课后他就迫不及待地跑到我的面前来，说 “钱老师，今天的课讲得真好啊！” 这样的话，我是有警惕的，我也遇到很多人说我课讲的好，我是有怀疑的。这个学生，他把我讲得好在哪里，讲得头头是道，讲得蜷在点子上，我原来还有点警惕，怕他是来吹捧的，现在很放心，他都听懂了。老师讲的东西被学生懂了，这是多大的快乐！于是我对这个学生有一个好感。一次、两次、三次，我对他的好感与日俱增。到第四天他来了，“钱先生，我要到美国去留学，请你给我写推荐书。” 你说我怎么办？欣然同意！当然了，要不怎么办？但是，写完之后，这个学生不见了，再也不出现了。

于是我就明白了，他以前那些点头微笑等等等等，全是投资！这就是鲁迅说的精神的资本家，投资收获了我的推荐信，然后就完了。这是一个绝对的利己主义者，他的一切行为，都从利益出发，而且是精心设计，但是他是高智商，高水平，你怎么办？他所做的一切都合理合法，我能批评他吗？我能发脾气吗？我发脾气显得我小气啊（笑），一个学生请你帮忙有什么不可以啊？这个学生有这个水平啊，他不是没有这个水平啊。但是，我有上当受骗之感，我有苦难言。这就是今天的北大培养出来的一部分尖子学生。问题是，这样的学生，这样的 “人才”，他是我们的体制里最欢迎的，因为他很能迎合到体制的需要，而且他是高效率啊，高智商啊，可怕的在这里啊。那些太笨的、只会吹牛拍马的人其实体制并不需要，说真话，是不是？**就这种精致的、高水平的人，体制才需要。这样的人，正在被我们培养成接班人**。我觉得这是最大的、我最担心的问题。

我讲这番话的意思，也不是要责备他们，这也不是这些学生本身的问题，而是这种实用主义、实利主义、虚无主义的教育所培养出来的，这是教育的恶果，这是有毒的罂粟花。

我今天讲的话是希望在座的同学，你们不要做这样的行为。这样的行为它的关键性在哪里？关键就是利益，**利益就是它唯一的信仰**。没有自己的信仰，没有自己的理想，没有自己的追求，他这就是完全个人利益作追求，一个人把利益作为唯一的追求，这个人就会变成庸才。我觉得**北大如果危机的话，可能危机在这里，就是培养出这样一些绝对的、高智商的、静止的立体庸才**。如果有危机，我个人，最感忧虑的就是这样的问题，所以今天我想着重提出来。

好像我说得实在太长了，那么我就讲了这一番又是梦话，又是忧患之词。谢谢大家！

*本文为钱理群教授2008年在《寻找北大》新书发布会暨北大110周年校庆民间纪念会上的讲演，由北京大学“我们”文学社整理。转载请注明来源。*