// CPS2 Desuicider 1.06 by arcadehacker.blogspot.com

// Changes
// Version 1.00: [Eduardo] Initial code.
// Version 1.01: [Artemio] Moved strings and keys to flash memory.
// Version 1.02: [Artemio] Removed spaces from game names, refactored code a bit, added left and right menu navigation.
// Version 1.03: [Artemio] Changed startup and end values in lines for consistent results on boards without CN9.
// Version 1.04: [Eduardo] Removed clones. Revised clock delay for improved compatibility.
// Version 1.05: [Eduardo] Fixed keys for batcirj, spf2t. Added games: ringdesth, spf2tu, ssf2th. Thank you smf.
// Version 1.06: [Eduardo] Added back clones to avoid user confusion. Added ssf2tba, xmcotab. Thanks Brian & smf.
//               [Artemio] Modified clock signal order for improved compatibility with board revs 4 & 5
// Version 1.07: [Eduardo] Fixed keys for batcirj, spf2t, previously broken again in 1.06. Thanks Konosuke.
                 
#include <LiquidCrystal.h>

// initialize the library with the numbers of the interface pins
LiquidCrystal lcd(8, 9, 4, 5, 6, 7);

//  CPS2 Board CN9 interface pins
#define DATA        2   //CN9 #2 
#define SETUP1      3   //CN9 #3 
#define CLOCK       11  //CN9 #4
#define SETUP2      12  //CN9 #5

//  CPS2 Board without CN9, CN2 interface pins
//  ------------------------------------------
//  DATA    ->  CN2 A32
//  SETUP1  ->  CN2 A30
//  CLOCK   ->  CN2 A31
//  SETUP2  ->  CN2 A29

#define btnRIGHT  0
#define btnUP     1
#define btnDOWN   2
#define btnLEFT   3
#define btnSELECT 4
#define btnNONE   5

int lcd_key       = btnNONE;
int adc_key_in    = 0;
int adc_key_prev  = 0;

// delay amount
int time = 25;

const unsigned char key_value_p[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x09,0x84,0xC2,0xEB,0x7A,0x3C,0xA5,0x78,0xFE,0x6B,0x44,0xC9,0x39,0xF2,0xE0}; //1944
const unsigned char key_value_0[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x09,0x84,0xC2,0xEB,0x7A,0x3C,0xA5,0x8B,0x93,0x46,0x1D,0x70,0xE7,0xAF,0x10}; //1944j
const unsigned char key_value_1[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x0A,0x04,0xC2,0xA4,0x02,0x02,0x20,0x04,0x3C,0x2F,0xEB,0xE0,0x63,0x81,0xC0}; //19xx
const unsigned char key_value_2[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x0A,0x04,0xC2,0xA4,0x02,0x02,0x22,0x23,0xB1,0x6F,0xB6,0xBC,0xCB,0x9C,0xCC}; //19xxa
const unsigned char key_value_3[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x0A,0x04,0xC2,0xA4,0x02,0x02,0x22,0x23,0xB1,0x6F,0xB6,0xBC,0xCB,0x9C,0xCC}; //19xxar1
const unsigned char key_value_4[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x0A,0x04,0xC2,0xA4,0x02,0x02,0x23,0xF1,0x1B,0x7E,0xD1,0x5B,0x8A,0x7E,0x9C}; //19xxb
const unsigned char key_value_5[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x0A,0x04,0xC2,0xA4,0x02,0x02,0x23,0xE4,0xDA,0x13,0xBD,0x7D,0x76,0x4A,0xE8}; //19xxh
const unsigned char key_value_6[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x0A,0x04,0xC2,0xA4,0x02,0x02,0x21,0xF8,0x7F,0xC0,0x00,0x7E,0xEA,0x20,0x00}; //19xxj
const unsigned char key_value_7[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x0A,0x04,0xC2,0xA4,0x02,0x02,0x21,0xF8,0x7F,0xC0,0x00,0x7E,0xEA,0x20,0x00}; //19xxjr1
const unsigned char key_value_8[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x0A,0x04,0xC2,0xA4,0x02,0x02,0x21,0xF8,0x7F,0xC0,0x00,0x7E,0xEA,0x20,0x00}; //19xxjr2
const unsigned char key_value_9[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x70,0x30,0x04,0x00,0x10,0x0B,0xE0,0x42,0x71,0x47,0x40,0xCA,0xE5,0xE4}; //armwar
const unsigned char key_value_10[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x70,0x30,0x04,0x00,0x10,0x08,0x42,0x71,0x47,0x40,0xCA,0xE5,0xE7,0xE0}; //armwara
const unsigned char key_value_11[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x70,0x30,0x04,0x00,0x10,0x0B,0xE0,0x42,0x71,0x47,0x40,0xCA,0xE5,0xE4}; //armwarr1
const unsigned char key_value_12[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x70,0x30,0x04,0x00,0x10,0x0A,0x5E,0x7E,0x04,0x27,0x14,0x74,0x0C,0xAC}; //armwaru
const unsigned char key_value_13[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x70,0x30,0x04,0x00,0x10,0x0A,0x5E,0x7E,0x04,0x27,0x14,0x74,0x0C,0xAC}; //armwaru1
const unsigned char key_value_14[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0xB1,0x20,0x79,0xAB,0x34,0xD9,0xED,0x4A,0x7B,0xC4,0x12,0xA0}; //avsp
const unsigned char key_value_15[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0xB1,0x20,0x79,0xA8,0x3A,0x69,0x49,0xD2,0xF7,0x3C,0x5A,0x0C}; //avspa
const unsigned char key_value_16[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0xB1,0x20,0x79,0xAB,0xE9,0xC6,0xCF,0x09,0x42,0x5B,0x52,0x38}; //avsph
const unsigned char key_value_17[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0xB1,0x20,0x79,0xA8,0x98,0x13,0xB2,0x29,0x7C,0x74,0xEE,0x5C}; //avspj
const unsigned char key_value_18[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0xB1,0x20,0x79,0xAB,0x11,0x6B,0xBC,0xCE,0x44,0x21,0xBC,0xB4}; //avspu
const unsigned char key_value_19[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x0A,0x04,0xC3,0xA4,0x02,0x32,0x02,0xB5,0x1C,0xF4,0xF3,0xA6,0x9E,0xA6,0x2C}; //batcir
const unsigned char key_value_20[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x0A,0x04,0xC3,0xA4,0x02,0x32,0x03,0x8D,0xD0,0x44,0x67,0x4C,0x06,0xE9,0xE0}; //batcira
const unsigned char key_value_21[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x0A,0x04,0xC3,0xA4,0x02,0x32,0x00,0x5C,0x40,0x00,0x00,0x6E,0xCB,0xFC,0x00}; //batcirj
const unsigned char key_value_22[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x09,0x84,0xC3,0xA2,0xC8,0xF3,0x6A,0xB7,0xA1,0xC7,0xF9,0x8D,0x23,0x7F,0x2C}; //choko
const unsigned char key_value_23[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x0A,0x04,0xC3,0xA4,0x00,0x23,0x02,0x0F,0x9C,0x21,0x08,0x17,0xE5,0xD1,0x98}; //csclub
const unsigned char key_value_24[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x0A,0x04,0xC3,0xA4,0x00,0x23,0x02,0x0F,0x9C,0x21,0x08,0x17,0xE5,0xD1,0x98}; //csclub1
const unsigned char key_value_25[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x0A,0x04,0xC3,0xA4,0x00,0x23,0x03,0xB2,0x50,0xB5,0x65,0x51,0xED,0x9B,0x20}; //cscluba
const unsigned char key_value_26[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x0A,0x04,0xC3,0xA4,0x00,0x23,0x00,0x2C,0xA7,0xB9,0xD3,0x94,0x54,0xA0,0x3C}; //csclubh
const unsigned char key_value_27[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x0A,0x04,0xC3,0xA4,0x00,0x23,0x00,0x0F,0x20,0x0D,0xAA,0x9F,0x42,0xD1,0x48}; //csclubj
const unsigned char key_value_28[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x0A,0x04,0xC3,0xA4,0x00,0x23,0x00,0x0F,0x20,0x0D,0xAA,0x9F,0x42,0xD1,0x48}; //csclubjy
const unsigned char key_value_29[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x70,0xC3,0xFC,0x00,0x70,0xC2,0x02,0x42,0x42,0x83,0x0A,0x69,0x0A,0x88}; //cybots
const unsigned char key_value_30[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x70,0xC3,0xFC,0x00,0x70,0xC3,0x0A,0x69,0x09,0x4A,0x02,0x42,0x42,0x80}; //cybotsj
const unsigned char key_value_31[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x70,0xC3,0xFC,0x00,0x70,0xC2,0x69,0x0A,0xAA,0x02,0x42,0x42,0x83,0x08}; //cybotsu
const unsigned char key_value_32[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x9A,0x62,0x60,0x83,0x1B,0xEB,0xE0,0x6C,0xF5,0x64,0x47,0x84}; //ddsom
const unsigned char key_value_33[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x9A,0x62,0x60,0x82,0x8B,0x05,0x03,0xDE,0xCF,0x56,0x63,0x84}; //ddsoma
const unsigned char key_value_34[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x9A,0x62,0x60,0x81,0xCF,0xF6,0x97,0x3D,0x07,0x96,0x4A,0x38}; //ddsomb
const unsigned char key_value_35[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x9A,0x62,0x60,0x83,0x81,0x9E,0xC1,0x22,0x89,0x0B,0x21,0x08}; //ddsomh
const unsigned char key_value_36[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x9A,0x62,0x60,0x82,0x88,0x25,0x6A,0x30,0xA5,0x7D,0x25,0xD4}; //ddsomj
const unsigned char key_value_37[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x9A,0x62,0x60,0x82,0x88,0x25,0x6A,0x30,0xA5,0x7D,0x25,0xD4}; //ddsomjr1
const unsigned char key_value_38[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x9A,0x62,0x60,0x83,0x1B,0xEB,0xE0,0x6C,0xF5,0x64,0x47,0x84}; //ddsomr1
const unsigned char key_value_39[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x9A,0x62,0x60,0x83,0x1B,0xEB,0xE0,0x6C,0xF5,0x64,0x47,0x84}; //ddsomr2
const unsigned char key_value_40[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x9A,0x62,0x60,0x83,0x1B,0xEB,0xE0,0x6C,0xF5,0x64,0x47,0x84}; //ddsomr3
const unsigned char key_value_41[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x9A,0x62,0x60,0x81,0x79,0xF2,0xCF,0x61,0x92,0x83,0xE4,0x48}; //ddsomu
const unsigned char key_value_42[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x9A,0x62,0x60,0x81,0x79,0xF2,0xCF,0x61,0x92,0x83,0xE4,0x48}; //ddsomur1
const unsigned char key_value_43[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x78,0xC2,0x60,0x20,0x00,0x0A,0x6E,0xB1,0x4C,0xA0,0x41,0xFF,0x9B,0x88}; //ddtod
const unsigned char key_value_44[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x78,0xC2,0x60,0x20,0x00,0x0A,0x20,0x82,0x3A,0x62,0x82,0x0D,0x4D,0xEC}; //ddtoda
const unsigned char key_value_45[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x78,0xC2,0x60,0x20,0x00,0x0A,0x20,0x82,0x3A,0x62,0x82,0x0D,0x4D,0xEC}; //ddtodar1
const unsigned char key_value_46[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x78,0xC2,0x60,0x20,0x00,0x08,0x1E,0xEE,0x90,0x5E,0x60,0x22,0x5A,0x60}; //ddtodh
const unsigned char key_value_47[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x78,0xC2,0x60,0x20,0x00,0x08,0x1E,0xEE,0x90,0x5E,0x60,0x22,0x5A,0x60}; //ddtodhr1
const unsigned char key_value_48[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x78,0xC2,0x60,0x20,0x00,0x08,0x1E,0xEE,0x90,0x5E,0x60,0x22,0x5A,0x60}; //ddtodhr2
const unsigned char key_value_49[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x78,0xC2,0x60,0x20,0x00,0x0A,0xD1,0x47,0x5B,0x3C,0xE7,0x9C,0x22,0x88}; //ddtodj
const unsigned char key_value_50[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x78,0xC2,0x60,0x20,0x00,0x0A,0xD1,0x47,0x5B,0x3C,0xE7,0x9C,0x22,0x88}; //ddtodjr1
const unsigned char key_value_51[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x78,0xC2,0x60,0x20,0x00,0x0A,0xD1,0x47,0x5B,0x3C,0xE7,0x9C,0x22,0x88}; //ddtodjr2
const unsigned char key_value_52[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x78,0xC2,0x60,0x20,0x00,0x0A,0x6E,0xB1,0x4C,0xA0,0x41,0xFF,0x9B,0x88}; //ddtodr1
const unsigned char key_value_53[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x78,0xC2,0x60,0x20,0x00,0x08,0x3F,0x5B,0x38,0x92,0xF0,0xE6,0x14,0xDC}; //ddtodu
const unsigned char key_value_54[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x78,0xC2,0x60,0x20,0x00,0x08,0x3F,0x5B,0x38,0x92,0xF0,0xE6,0x14,0xDC}; //ddtodur1
const unsigned char key_value_55[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0xC9,0xF4,0x89,0x36,0x8D,0xB7,0x52,0xFF,0xA0,0x50,0x09,0xC7,0x6E,0xC0}; //dimahoo
const unsigned char key_value_56[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0xC9,0xF4,0x89,0x36,0x8D,0xB6,0x25,0x95,0xFC,0x36,0x6B,0xD6,0xBA,0x98}; //dimahoou
const unsigned char key_value_57[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x70,0x40,0x00,0x00,0x1A,0x18,0x24,0x34,0x40,0x00,0x57,0x94,0x6F,0x20}; //dstlk
const unsigned char key_value_58[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x70,0x40,0x00,0x00,0x1A,0x1A,0x3A,0x61,0x11,0x80,0x67,0x06,0xE8,0x10}; //dstlka
const unsigned char key_value_59[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x70,0x40,0x00,0x00,0x1A,0x19,0x56,0x5A,0x22,0x01,0xFD,0xF1,0x89,0x10}; //dstlkh
const unsigned char key_value_60[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x70,0x40,0x00,0x00,0x1A,0x1A,0x62,0x39,0x10,0x20,0x3F,0x5C,0x05,0xE0}; //dstlku
const unsigned char key_value_61[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x70,0x40,0x00,0x00,0x1A,0x1A,0x62,0x39,0x10,0x20,0x3F,0x5C,0x05,0xE0}; //dstlkur1
const unsigned char key_value_62[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x00,0x02,0x8B,0x38,0xA9,0xB8,0x65,0x74,0xEE,0x30,0x23,0x24}; //ecofghtr
const unsigned char key_value_63[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x00,0x02,0x8B,0x39,0x30,0xA9,0xB8,0x65,0x76,0x30,0x23,0x24}; //ecofghtra
const unsigned char key_value_64[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x00,0x02,0x8B,0x3B,0x0A,0x9B,0x86,0x57,0x4E,0x30,0x23,0x24}; //ecofghtrh
const unsigned char key_value_65[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x00,0x02,0x8B,0x3A,0x9B,0x86,0x57,0x4E,0xDE,0x30,0x23,0x24}; //ecofghtru
const unsigned char key_value_66[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x00,0x02,0x8B,0x3A,0x9B,0x86,0x57,0x4E,0xDE,0x30,0x23,0x24}; //ecofghtru1
const unsigned char key_value_67[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x90,0x20,0x07,0xAC,0x1B,0x60,0x25,0x1E,0xD2,0x9C}; //gigawing
const unsigned char key_value_68[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x90,0x20,0x5B,0xB6,0x35,0x99,0x68,0x55,0x82,0xB0}; //gigawinga
const unsigned char key_value_69[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x90,0x22,0xE7,0xFB,0xDD,0xA4,0x36,0x8B,0x9F,0xC0}; //gigawingb
const unsigned char key_value_70[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x90,0x22,0x87,0x16,0xC0,0x0A,0x21,0x0B,0x95,0xCC}; //gigawingh
const unsigned char key_value_71[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x90,0x22,0xA4,0x42,0xBD,0xF5,0x5A,0x61,0x92,0x20}; //gigawingj
const unsigned char key_value_72[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0xC9,0xF4,0x89,0x36,0x8D,0xB5,0x1B,0x5E,0x12,0x18,0x69,0xF7,0xBF,0xA4}; //gmahou
const unsigned char key_value_73[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x80,0x00,0x00,0x10,0xE4,0x63,0x15,0xFE,0xEE,0xE5,0xB1,0x68}; //hsf2
const unsigned char key_value_74[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x80,0x00,0x00,0x12,0xF1,0x43,0x1D,0x54,0x31,0xB2,0xDC,0x74}; //hsf2a
const unsigned char key_value_75[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x80,0x00,0x00,0x13,0x89,0xF0,0x77,0x6C,0x1F,0xD0,0x6E,0x98}; //hsf2j
const unsigned char key_value_76[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x29,0xB3,0x3A,0xA2,0x6B,0xF1,0xBD,0x25,0x9D,0x50,0x94,0xD8}; //jyangoku
const unsigned char key_value_77[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0x9A,0x02,0x02,0x38,0x2A,0x98,0xB2,0xDC,0xD4,0xE0,0x28,0x28}; //megaman2
const unsigned char key_value_78[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0x9A,0x02,0x02,0x3A,0xA1,0x42,0x79,0xAF,0x51,0x44,0xA3,0xF0}; //megaman2a
const unsigned char key_value_79[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0x9A,0x02,0x02,0x38,0x2C,0x21,0x02,0x91,0x4F,0x3A,0xA9,0xB8}; //megaman2h
const unsigned char key_value_80[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0x9A,0x80,0xA6,0x12,0x92,0x90,0x98,0xA5,0x7F,0x24,0x4A,0x80}; //mmancp2u
const unsigned char key_value_81[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x0D,0xB7,0x88,0xB7,0xCD,0x77,0xEF,0x98,0x82,0x0A,0x7A,0xF5,0xE4,0xD4}; //mmatrix
const unsigned char key_value_82[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x0D,0xB7,0x88,0xB7,0xCD,0x77,0x10,0x66,0xDD,0x3A,0xA5,0xE0,0x7E,0xC8}; //mmatrixj
const unsigned char key_value_83[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x84,0xC2,0xF8,0xB3,0x16,0x47,0x61,0x17,0x8A,0x9D,0x8E,0x0B,0xBE,0xA4}; //mpang
const unsigned char key_value_84[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x84,0xC2,0xF8,0xB3,0x16,0x47,0x61,0x17,0x8A,0x9D,0x8E,0x0B,0xBE,0xA4}; //mpangj
const unsigned char key_value_85[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x84,0xC2,0xF8,0xB3,0x16,0x47,0x61,0x17,0x8A,0x9D,0x8E,0x0B,0xBE,0xA4}; //mpangr1
const unsigned char key_value_86[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x84,0xC2,0xF8,0xB3,0x16,0x47,0x61,0x17,0x8A,0x9D,0x8E,0x0B,0xBE,0xA4}; //mpangu
const unsigned char key_value_87[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x9A,0x62,0x60,0x83,0xA2,0xEA,0xA7,0x9D,0x91,0xDE,0x21,0x60}; //msh
const unsigned char key_value_88[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x9A,0x62,0x60,0x82,0xF2,0x8F,0xA4,0x72,0x03,0x5D,0x7A,0x88}; //msha
const unsigned char key_value_89[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x9A,0x62,0x60,0x81,0x9C,0x7F,0x92,0xD5,0xA0,0x92,0xA1,0x78}; //mshb
const unsigned char key_value_90[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x9A,0x62,0x60,0x80,0x26,0x0C,0xE6,0xB4,0x29,0x68,0xC8,0xFC}; //mshh
const unsigned char key_value_91[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x9A,0x62,0x60,0x81,0x0A,0x12,0xD6,0x32,0x61,0x04,0x5E,0x80}; //mshj
const unsigned char key_value_92[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x9A,0x62,0x60,0x81,0x0A,0x12,0xD6,0x32,0x61,0x04,0x5E,0x80}; //mshjr1
const unsigned char key_value_93[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x9A,0x62,0x60,0x83,0x66,0x33,0xA1,0x49,0xC9,0x16,0x83,0x84}; //mshu
const unsigned char key_value_94[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x90,0x23,0xF6,0x93,0xAC,0xE4,0x19,0xD4,0x87,0x20}; //mshvsf
const unsigned char key_value_95[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x90,0x20,0x6F,0x7A,0x48,0xC2,0x19,0x7F,0x1D,0x28}; //mshvsfa
const unsigned char key_value_96[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x90,0x20,0x6F,0x7A,0x48,0xC2,0x19,0x7F,0x1D,0x28}; //mshvsfa1
const unsigned char key_value_97[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x90,0x22,0x01,0x1F,0x3F,0x6A,0x4B,0x8C,0x59,0x6C}; //mshvsfb
const unsigned char key_value_98[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x90,0x22,0x01,0x1F,0x3F,0x6A,0x4B,0x8C,0x59,0x6C}; //mshvsfb1
const unsigned char key_value_99[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x90,0x22,0xD2,0x87,0x57,0x00,0x8F,0xDA,0x25,0xF8}; //mshvsfh
const unsigned char key_value_100[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x90,0x20,0xB4,0x1F,0x91,0x94,0x7E,0x27,0x0E,0xE8}; //mshvsfj
const unsigned char key_value_101[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x90,0x20,0xB4,0x1F,0x91,0x94,0x7E,0x27,0x0E,0xE8}; //mshvsfj1
const unsigned char key_value_102[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x90,0x20,0xB4,0x1F,0x91,0x94,0x7E,0x27,0x0E,0xE8}; //mshvsfj2
const unsigned char key_value_103[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x90,0x20,0x53,0x62,0xBD,0xCE,0x3A,0x4A,0xDB,0x14}; //mshvsfu
const unsigned char key_value_104[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x90,0x20,0x53,0x62,0xBD,0xCE,0x3A,0x4A,0xDB,0x14}; //mshvsfu1
const unsigned char key_value_105[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x62,0x12,0x03,0x93,0x7A,0x58,0xE1,0xED,0x69,0x00,0x48}; //mvsc
const unsigned char key_value_106[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x62,0x12,0x03,0xA2,0xCE,0x82,0x79,0x8D,0xD4,0x49,0x3C}; //mvsca
const unsigned char key_value_107[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x62,0x12,0x03,0xA2,0xCE,0x82,0x79,0x8D,0xD4,0x49,0x3C}; //mvscar1
const unsigned char key_value_108[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x62,0x12,0x00,0x67,0xB5,0x0E,0x2B,0x5D,0xAC,0xB8,0x40}; //mvscb
const unsigned char key_value_109[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x62,0x12,0x03,0xDC,0x63,0x5A,0x9F,0x11,0x78,0xEA,0xE4}; //mvsch
const unsigned char key_value_110[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x62,0x12,0x00,0x35,0xF1,0x23,0xA4,0x72,0x1A,0x0F,0xD4}; //mvscj
const unsigned char key_value_111[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x62,0x12,0x00,0x35,0xF1,0x23,0xA4,0x72,0x1A,0x0F,0xD4}; //mvscjr1
const unsigned char key_value_112[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x62,0x12,0x00,0x35,0xF1,0x23,0xA4,0x72,0x1A,0x0F,0xD4}; //mvscjsing
const unsigned char key_value_113[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x62,0x12,0x03,0x93,0x7A,0x58,0xE1,0xED,0x69,0x00,0x48}; //mvscr1
const unsigned char key_value_114[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x62,0x12,0x02,0x80,0x4E,0x3D,0xFB,0x60,0x8E,0xD2,0x58}; //mvscu
const unsigned char key_value_115[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x62,0x12,0x02,0x80,0x4E,0x3D,0xFB,0x60,0x8E,0xD2,0x58}; //mvscur1
const unsigned char key_value_116[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x70,0x40,0x00,0x00,0x1A,0x1A,0x81,0x68,0x3F,0x02,0x8A,0x2E,0x60,0x20}; //nwarr
const unsigned char key_value_117[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x70,0x40,0x00,0x00,0x1A,0x18,0x96,0x18,0x76,0x70,0xC2,0xC0,0xA5,0xC8}; //nwarra
const unsigned char key_value_118[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x70,0x40,0x00,0x00,0x1A,0x18,0x11,0x51,0xB3,0xB6,0x42,0x39,0x8F,0xA0}; //nwarrb
const unsigned char key_value_119[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x70,0x40,0x00,0x00,0x1A,0x18,0x10,0x18,0xA5,0x52,0x03,0x61,0xA4,0x8C}; //nwarrh
const unsigned char key_value_120[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x70,0x40,0x00,0x00,0x1A,0x19,0xE1,0x7B,0x63,0xF0,0xC2,0xF9,0x48,0x20}; //nwarru
const unsigned char key_value_121[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0xBB,0xE1,0x22,0xC3,0xAC,0xA7,0xC4,0x30,0x0F,0x5D,0x2F,0xA4}; //pfghtj
const unsigned char key_value_122[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x70,0x30,0x04,0x00,0x10,0x09,0xE7,0xE0,0x42,0x71,0x47,0x40,0xCA,0xE4}; //pgear
const unsigned char key_value_123[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x70,0x30,0x04,0x00,0x10,0x09,0xE7,0xE0,0x42,0x71,0x47,0x40,0xCA,0xE4}; //pgearr1
const unsigned char key_value_124[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x0A,0x04,0xC2,0x17,0x1B,0x2C,0x77,0x3E,0xC3,0x23,0xDD,0x8C,0x6D,0x67,0x18}; //progear
const unsigned char key_value_125[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x0A,0x04,0xC2,0x17,0x1B,0x2C,0x75,0xEB,0x64,0xEE,0xFC,0x52,0x35,0x46,0x98}; //progeara
const unsigned char key_value_126[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x0A,0x04,0xC2,0x17,0x1B,0x2C,0x75,0xF7,0x8B,0x7E,0x71,0xA8,0xED,0xFB,0xE4}; //progearj
const unsigned char key_value_127[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x09,0x04,0xC3,0x39,0x66,0x3E,0xA0,0xB5,0xB2,0xC0,0x8D,0x20,0x7C,0xA8,0x14}; //pzloop2
const unsigned char key_value_128[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x09,0x04,0xC3,0x39,0x66,0x3E,0xA0,0xB5,0xB2,0xC0,0x8D,0x20,0x7C,0xA8,0x14}; //pzloop2j
const unsigned char key_value_129[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x09,0x04,0xC3,0x39,0x66,0x3E,0xA0,0xB5,0xB2,0xC0,0x8D,0x20,0x7C,0xA8,0x14}; //pzloop2jr1
const unsigned char key_value_130[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC3,0x3A,0x63,0x90,0x40,0x67,0x83,0x59,0xBF,0x39,0x5C,0x80,0x68}; //qndream
const unsigned char key_value_131[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x0A,0x70,0x30,0x04,0x00,0x10,0x0B,0x02,0x48,0x8B,0xA3,0x93,0x80,0xA6,0x60}; //ringdest
const unsigned char key_value_132[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x0A,0x70,0x30,0x04,0x00,0x10,0x0B,0x02,0x12,0x8B,0xA3,0x93,0x80,0xA6,0x60}; //ringdesta
const unsigned char key_value_133[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0x9A,0x80,0xA6,0x10,0x2D,0x31,0x7F,0xB2,0x02,0xAA,0x13,0x80}; //rmancp2j
const unsigned char key_value_134[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0x9A,0x02,0x02,0x38,0x39,0x22,0xA8,0x23,0x39,0x4D,0xE6,0x30}; //rockman2j
const unsigned char key_value_135[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0x9A,0x80,0xA6,0x13,0x61,0x73,0x90,0x8D,0xDA,0xEA,0x47,0xC0}; //sfa
const unsigned char key_value_136[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC2,0x70,0x33,0x07,0xA6,0x7E,0x1F,0x7F,0x70,0xE7,0xCD,0x48,0xFC}; //sfa2
const unsigned char key_value_137[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC2,0x70,0x33,0x07,0xA5,0x4A,0x18,0xBD,0x45,0xA6,0xF3,0xF7,0x60}; //sfa2u
const unsigned char key_value_138[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC2,0x70,0x33,0x07,0xA5,0x4A,0x18,0xBD,0x45,0xA6,0xF3,0xF7,0x60}; //sfa2ur1
const unsigned char key_value_139[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x18,0xE0,0x56,0xBE,0x0E,0xEC,0x07,0x90,0x1C,0x4F,0xF5,0x58}; //sfa3
const unsigned char key_value_140[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x18,0xE0,0x56,0xBD,0xA5,0x2D,0xA2,0x05,0x34,0x0E,0x10,0xAC}; //sfa3b
const unsigned char key_value_141[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x18,0xE0,0x56,0xBE,0x1B,0x17,0xA3,0x78,0xC7,0xED,0x10,0x84}; //sfa3h
const unsigned char key_value_142[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x18,0xE0,0x56,0xBE,0x1B,0x17,0xA3,0x78,0xC7,0xED,0x10,0x84}; //sfa3hr1
const unsigned char key_value_143[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x18,0xE0,0x56,0xBC,0x49,0x30,0xA7,0x9A,0x9C,0x3F,0x77,0x9C}; //sfa3u
const unsigned char key_value_144[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x18,0xE0,0x56,0xBC,0x49,0x30,0xA7,0x9A,0x9C,0x3F,0x77,0x9C}; //sfa3ur1
const unsigned char key_value_145[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0x9A,0x80,0xA6,0x13,0x61,0x73,0x90,0x8D,0xDA,0xEA,0x47,0xC0}; //sfar1
const unsigned char key_value_146[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0x9A,0x80,0xA6,0x13,0x61,0x73,0x90,0x8D,0xDA,0xEA,0x47,0xC0}; //sfar2
const unsigned char key_value_147[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0x9A,0x80,0xA6,0x13,0x61,0x73,0x90,0x8D,0xDA,0xEA,0x47,0xC0}; //sfar3
const unsigned char key_value_148[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0x9A,0x80,0xA6,0x10,0x60,0x0B,0xCF,0xA5,0xB2,0xD5,0xF6,0x90}; //sfau
const unsigned char key_value_149[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC2,0x70,0x33,0x07,0xA7,0x84,0xA4,0x7B,0x08,0xBC,0x5D,0x0F,0xD4}; //sfz2a
const unsigned char key_value_150[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC3,0x39,0xC4,0x22,0x25,0x96,0x11,0x80,0x80,0x2C,0x0D,0x3A,0x3C}; //sfz2al
const unsigned char key_value_151[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC3,0x39,0xC4,0x22,0x24,0xE3,0xD7,0x07,0xFC,0x51,0x4A,0xCF,0x38}; //sfz2alb
const unsigned char key_value_152[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC3,0x39,0xC4,0x22,0x25,0x8C,0x40,0xC0,0x10,0xFB,0x6A,0x3E,0xA4}; //sfz2alh
const unsigned char key_value_153[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC3,0x39,0xC4,0x22,0x26,0xC8,0xD1,0x40,0x14,0x44,0xC2,0x8A,0x64}; //sfz2alj
const unsigned char key_value_154[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC2,0x70,0x33,0x07,0xA5,0xD3,0x74,0x7E,0x1A,0x66,0x8B,0x20,0xD4}; //sfz2b
const unsigned char key_value_155[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC2,0x70,0x33,0x07,0xA5,0xD3,0x74,0x7E,0x1A,0x66,0x8B,0x20,0xD4}; //sfz2br1
const unsigned char key_value_156[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC2,0x70,0x33,0x07,0xA7,0xE4,0x43,0x7A,0x69,0x0A,0xD1,0x46,0x7C}; //sfz2h
const unsigned char key_value_157[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC2,0x70,0x33,0x07,0xA6,0x22,0x13,0xB9,0x6E,0x65,0xF8,0xBF,0x04}; //sfz2j
const unsigned char key_value_158[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC2,0x70,0x33,0x07,0xA6,0x22,0x13,0xB9,0x6E,0x65,0xF8,0xBF,0x04}; //sfz2jr1
const unsigned char key_value_159[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC2,0x70,0x33,0x07,0xA4,0xED,0x8B,0x7A,0x94,0xE4,0x7F,0x53,0x1C}; //sfz2n
const unsigned char key_value_160[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x18,0xE0,0x56,0xBD,0xF8,0xD0,0x9C,0x96,0x03,0x27,0x42,0x64}; //sfz3a
const unsigned char key_value_161[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x18,0xE0,0x56,0xBD,0xF8,0xD0,0x9C,0x96,0x03,0x27,0x42,0x64}; //sfz3ar1
const unsigned char key_value_162[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x18,0xE0,0x56,0xBE,0x7A,0xD1,0xF4,0xC3,0x00,0x7E,0x4A,0xF8}; //sfz3j
const unsigned char key_value_163[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x18,0xE0,0x56,0xBE,0x7A,0xD1,0xF4,0xC3,0x00,0x7E,0x4A,0xF8}; //sfz3jr1
const unsigned char key_value_164[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x18,0xE0,0x56,0xBE,0x7A,0xD1,0xF4,0xC3,0x00,0x7E,0x4A,0xF8}; //sfz3jr2
const unsigned char key_value_165[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0x9A,0x80,0xA6,0x13,0xF9,0x67,0x61,0x18,0x42,0x8E,0xF0,0x9C}; //sfza
const unsigned char key_value_166[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0x9A,0x80,0xA6,0x13,0xF9,0x67,0x61,0x18,0x42,0x8E,0xF0,0x9C}; //sfzar1
const unsigned char key_value_167[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0x9A,0x80,0xA6,0x10,0x05,0x8D,0x25,0x7B,0x2F,0x6A,0x0B,0xDC}; //sfzb
const unsigned char key_value_168[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0x9A,0x80,0xA6,0x10,0x05,0x8D,0x25,0x7B,0x2F,0x6A,0x0B,0xDC}; //sfzbr1
const unsigned char key_value_169[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0x9A,0x80,0xA6,0x12,0x2F,0xC9,0x14,0xEA,0x71,0xC3,0x5B,0x84}; //sfzh
const unsigned char key_value_170[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0x9A,0x80,0xA6,0x12,0x2F,0xC9,0x14,0xEA,0x71,0xC3,0x5B,0x84}; //sfzhr1
const unsigned char key_value_171[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0x9A,0x80,0xA6,0x12,0x8B,0xC1,0xE5,0x0D,0x79,0xA3,0x36,0xC4}; //sfzj
const unsigned char key_value_172[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0x9A,0x80,0xA6,0x12,0x8B,0xC1,0xE5,0x0D,0x79,0xA3,0x36,0xC4}; //sfzjr1
const unsigned char key_value_173[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0x9A,0x80,0xA6,0x12,0x8B,0xC1,0xE5,0x0D,0x79,0xA3,0x36,0xC4}; //sfzjr2
const unsigned char key_value_174[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0xBB,0xE1,0x22,0xC1,0xFB,0x77,0xC1,0xE9,0xBA,0x4B,0x10,0x84}; //sgemf
const unsigned char key_value_175[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0xBB,0xE1,0x22,0xC3,0x26,0x5D,0xF8,0x8D,0x52,0x0B,0x42,0x40}; //sgemfa
const unsigned char key_value_176[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC0,0xBB,0xE1,0x22,0xC0,0x91,0x2F,0xC4,0xFB,0x63,0x97,0x1A,0x04}; //sgemfh
const unsigned char key_value_177[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x0A,0x70,0x30,0x04,0x00,0x10,0x0B,0x00,0xA3,0x03,0xA2,0x41,0x00,0xA6,0x60}; //smbomb
const unsigned char key_value_178[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x0A,0x70,0x30,0x04,0x00,0x10,0x0B,0x00,0xA3,0x03,0xA2,0x41,0x00,0xA6,0x60}; //smbombr1
const unsigned char key_value_179[] PROGMEM =    { 0x3F,0x00,0x02,0x40,0x00,0x08,0x04,0xC2,0x70,0x32,0x60,0x67,0x9D,0xE1,0x06,0xAA,0x43,0xD9,0x1E,0xEC}; //spf2t
const unsigned char key_value_180[] PROGMEM =    { 0x3F,0x00,0x02,0x40,0x00,0x08,0x04,0xC2,0x70,0x32,0x60,0x67,0x7C,0xB3,0xC1,0xAF,0x56,0x1C,0x48,0xE4}; //spf2ta
const unsigned char key_value_181[] PROGMEM =    { 0x3F,0x00,0x02,0x40,0x00,0x08,0x04,0xC2,0x70,0x32,0x60,0x65,0xB6,0x87,0xC5,0x13,0x54,0xC6,0xDE,0x28}; //spf2th
const unsigned char key_value_182[] PROGMEM =    { 0x3F,0x00,0x02,0x40,0x00,0x08,0x04,0xC2,0x70,0x32,0x60,0x67,0xFD,0xBA,0x42,0x5D,0x6B,0x04,0xD2,0x34}; //spf2xj
const unsigned char key_value_183[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x80,0x00,0x00,0x12,0x03,0xDE,0xCF,0x56,0x47,0x9A,0x8B,0x10}; //ssf2
const unsigned char key_value_184[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x80,0x00,0x00,0x11,0x20,0x3D,0xEC,0xF5,0x64,0x79,0xA8,0xB0}; //ssf2a
const unsigned char key_value_185[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x80,0x00,0x00,0x11,0x20,0x3D,0xEC,0xF5,0x64,0x79,0xA8,0xB0}; //ssf2ar1
const unsigned char key_value_186[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x80,0x00,0x00,0x10,0xB1,0x20,0x3D,0xEC,0xF5,0x64,0x79,0xA8}; //ssf2h
const unsigned char key_value_187[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x80,0x00,0x00,0x13,0xDE,0xCF,0x56,0x47,0x9A,0x8B,0x12,0x00}; //ssf2j
const unsigned char key_value_188[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x80,0x00,0x00,0x13,0xDE,0xCF,0x56,0x47,0x9A,0x8B,0x12,0x00}; //ssf2jr1
const unsigned char key_value_189[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x80,0x00,0x00,0x13,0xDE,0xCF,0x56,0x47,0x9A,0x8B,0x12,0x00}; //ssf2jr2
const unsigned char key_value_190[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x80,0x00,0x00,0x10,0xF0,0xA3,0x2D,0xA9,0x03,0x05,0xC8,0xA4}; //ssf2t
const unsigned char key_value_191[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x80,0x00,0x00,0x12,0x38,0xA1,0x49,0x99,0x00,0x2C,0x8C,0xA4}; //ssf2ta
const unsigned char key_value_192[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x80,0x00,0x00,0x13,0x9A,0x8B,0x12,0x03,0xDE,0xCF,0x56,0x44}; //ssf2tb
const unsigned char key_value_193[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x80,0x00,0x00,0x10,0x79,0xA8,0xB1,0x20,0x3D,0xEC,0xF5,0x64}; //ssf2tba
const unsigned char key_value_194[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x80,0x00,0x00,0x11,0x64,0x79,0xA8,0xB1,0x20,0x3D,0xEC,0xF4}; //ssf2tbh
const unsigned char key_value_195[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x80,0x00,0x00,0x12,0x8B,0x12,0x03,0xDE,0xCF,0x56,0x47,0x98}; //ssf2tbj
const unsigned char key_value_196[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x80,0x00,0x00,0x13,0x9A,0x8B,0x12,0x03,0xDE,0xCF,0x56,0x44}; //ssf2tbr1
const unsigned char key_value_197[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x80,0x00,0x00,0x13,0xF0,0xA3,0xB8,0xC9,0x02,0x45,0x7C,0xA4}; //ssf2tu
const unsigned char key_value_198[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x80,0x00,0x00,0x13,0xF0,0xA3,0xB8,0xC9,0x02,0x45,0x7C,0xA4}; //ssf2tur1
const unsigned char key_value_199[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x80,0x00,0x00,0x10,0x3D,0xEC,0xF5,0x64,0x79,0xA8,0xB1,0x20}; //ssf2u
const unsigned char key_value_200[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x80,0x00,0x00,0x11,0xC0,0xA0,0xD6,0x81,0x03,0xA9,0x50,0xA4}; //ssf2xj
const unsigned char key_value_201[] PROGMEM =    { 0x01,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x80,0x00,0x00,0x11,0x10,0xA2,0xCD,0x79,0x03,0x50,0xF0,0xA4}; //ssf2xjr
const unsigned char key_value_202[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x70,0x43,0x00,0x02,0x8B,0x39,0xB8,0x65,0x74,0xED,0xFE,0x30,0x23,0x24}; //uecology
const unsigned char key_value_203[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x70,0x40,0x00,0x00,0x1A,0x19,0xD6,0x60,0x59,0x00,0x80,0x43,0x4F,0xDC}; //vampj
const unsigned char key_value_204[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x70,0x40,0x00,0x00,0x1A,0x19,0xD6,0x60,0x59,0x00,0x80,0x43,0x4F,0xDC}; //vampja
const unsigned char key_value_205[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x70,0x40,0x00,0x00,0x1A,0x19,0xD6,0x60,0x59,0x00,0x80,0x43,0x4F,0xDC}; //vampjr1
const unsigned char key_value_206[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x25,0x80,0x1B,0x80,0x63,0xC2,0x35,0x93,0x17,0x5E,0x0D,0xB0}; //vhunt2
const unsigned char key_value_207[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x25,0x80,0x1B,0x80,0x63,0xC2,0x35,0x93,0x17,0x5E,0x0D,0xB0}; //vhunt2r1
const unsigned char key_value_208[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x70,0x40,0x00,0x00,0x1A,0x19,0x3F,0xAE,0x5C,0x97,0x0D,0x36,0xB2,0x20}; //vhuntj
const unsigned char key_value_209[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x70,0x40,0x00,0x00,0x1A,0x19,0x3F,0xAE,0x5C,0x97,0x0D,0x36,0xB2,0x20}; //vhuntjr1
const unsigned char key_value_210[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x70,0x40,0x00,0x00,0x1A,0x19,0x3F,0xAE,0x5C,0x97,0x0D,0x36,0xB2,0x20}; //vhuntjr1s
const unsigned char key_value_211[] PROGMEM =    { 0x07,0x00,0x02,0x40,0x00,0x08,0x70,0x40,0x00,0x00,0x1A,0x19,0x3F,0xAE,0x5C,0x97,0x0D,0x36,0xB2,0x20}; //vhuntjr2
const unsigned char key_value_212[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x59,0x3B,0xD7,0x48,0x3B,0x75,0x76,0x3A,0x04,0x6A,0xCC,0x1C}; //vsav
const unsigned char key_value_213[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x25,0x80,0x1B,0x83,0xED,0xE3,0xB0,0x18,0xBC,0x9E,0x05,0xAC}; //vsav2
const unsigned char key_value_214[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x59,0x3B,0xD7,0x48,0xD5,0x20,0xB4,0x24,0x32,0x65,0xDF,0x88}; //vsava
const unsigned char key_value_215[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x59,0x3B,0xD7,0x4A,0xED,0x57,0xB7,0x2E,0xC4,0xFB,0x2D,0x34}; //vsavh
const unsigned char key_value_216[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x59,0x3B,0xD7,0x4A,0x76,0x04,0x74,0x97,0x31,0xCB,0xC5,0x7C}; //vsavj
const unsigned char key_value_217[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x59,0x3B,0xD7,0x49,0x9F,0x01,0xF3,0xA9,0xDC,0x15,0xD1,0x94}; //vsavu
const unsigned char key_value_218[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x3A,0x62,0x03,0x02,0x29,0x00,0x7F,0xA4,0x96,0xDD,0x8F,0x70}; //xmcota
const unsigned char key_value_219[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x3A,0x62,0x03,0x00,0xE1,0x87,0xF3,0x6D,0x1C,0x96,0xA7,0x80}; //xmcotaa
const unsigned char key_value_220[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x3A,0x62,0x03,0x00,0xA9,0x65,0xAC,0xE3,0x10,0x1F,0xF7,0x84}; //xmcotab
const unsigned char key_value_221[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x3A,0x62,0x03,0x00,0xE1,0x87,0xF3,0x6D,0x1C,0x96,0xA7,0x80}; //xmcotaar1
const unsigned char key_value_222[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x3A,0x62,0x03,0x03,0xA1,0x35,0xA4,0x14,0xB0,0xEC,0x5E,0xBC}; //xmcotah
const unsigned char key_value_223[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x3A,0x62,0x03,0x03,0xA1,0x35,0xA4,0x14,0xB0,0xEC,0x5E,0xBC}; //xmcotahr1
const unsigned char key_value_224[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x3A,0x62,0x03,0x01,0xE6,0xCF,0x47,0xD6,0xA3,0x39,0x01,0x88}; //xmcotaj
const unsigned char key_value_225[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x3A,0x62,0x03,0x01,0xE6,0xCF,0x47,0xD6,0xA3,0x39,0x01,0x88}; //xmcotaj1
const unsigned char key_value_226[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x3A,0x62,0x03,0x01,0xE6,0xCF,0x47,0xD6,0xA3,0x39,0x01,0x88}; //xmcotaj2
const unsigned char key_value_227[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x3A,0x62,0x03,0x01,0xE6,0xCF,0x47,0xD6,0xA3,0x39,0x01,0x88}; //xmcotaj3
const unsigned char key_value_228[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x3A,0x62,0x03,0x01,0xE6,0xCF,0x47,0xD6,0xA3,0x39,0x01,0x88}; //xmcotajr
const unsigned char key_value_229[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x3A,0x62,0x03,0x02,0x29,0x00,0x7F,0xA4,0x96,0xDD,0x8F,0x70}; //xmcotar1
const unsigned char key_value_230[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x08,0x04,0xC1,0x3A,0x62,0x03,0x03,0x4B,0xDA,0x00,0x66,0xCD,0xFA,0x95,0x30}; //xmcotau
const unsigned char key_value_231[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x93,0x01,0x5C,0xD5,0x37,0xF2,0x62,0x87,0xCE,0xF4}; //xmvsf
const unsigned char key_value_232[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x93,0x00,0x26,0xDF,0x56,0x61,0xF0,0xFC,0x70,0xB8}; //xmvsfa
const unsigned char key_value_233[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x93,0x00,0x26,0xDF,0x56,0x61,0xF0,0xFC,0x70,0xB8}; //xmvsfar1
const unsigned char key_value_234[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x93,0x00,0x26,0xDF,0x56,0x61,0xF0,0xFC,0x70,0xB8}; //xmvsfar2
const unsigned char key_value_235[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x93,0x00,0x26,0xDF,0x56,0x61,0xF0,0xFC,0x70,0xB8}; //xmvsfar3
const unsigned char key_value_236[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x93,0x00,0x3C,0x86,0x10,0x35,0x49,0xE6,0xD5,0xC4}; //xmvsfb
const unsigned char key_value_237[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x93,0x03,0xB2,0x25,0x7D,0x08,0x2D,0x37,0xEB,0x04}; //xmvsfh
const unsigned char key_value_238[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x93,0x00,0xD7,0x3B,0x02,0x10,0xF7,0x27,0xEC,0x70}; //xmvsfj
const unsigned char key_value_239[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x93,0x00,0xD7,0x3B,0x02,0x10,0xF7,0x27,0xEC,0x70}; //xmvsfjr1
const unsigned char key_value_240[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x93,0x00,0xD7,0x3B,0x02,0x10,0xF7,0x27,0xEC,0x70}; //xmvsfjr2
const unsigned char key_value_241[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x93,0x01,0x5C,0xD5,0x37,0xF2,0x62,0x87,0xCE,0xF4}; //xmvsfr1
const unsigned char key_value_242[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x93,0x02,0x0F,0x72,0x98,0x7D,0x2F,0x03,0x4F,0xC8}; //xmvsfu
const unsigned char key_value_243[] PROGMEM =    { 0x0F,0x00,0x02,0x40,0x00,0x0A,0x04,0xC1,0x3A,0x63,0x93,0x02,0x0F,0x72,0x98,0x7D,0x2F,0x03,0x4F,0xC8}; //xmvsfur1
const unsigned char key_value_244[] PROGMEM =    { 0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF}; //Phoenix

const unsigned char *Keys[] = { key_value_p, key_value_0, key_value_1, key_value_2, key_value_3, key_value_4, key_value_5, key_value_6, key_value_7, key_value_8, key_value_9, key_value_10, key_value_11, key_value_12, key_value_13, key_value_14, key_value_15, key_value_16, key_value_17, key_value_18, key_value_19, key_value_20, key_value_21, key_value_22, key_value_23, key_value_24, key_value_25, key_value_26, key_value_27, key_value_28, key_value_29, key_value_30, key_value_31, key_value_32, key_value_33, key_value_34, key_value_35, key_value_36, key_value_37, key_value_38, key_value_39, key_value_40, key_value_41, key_value_42, key_value_43, key_value_44, key_value_45, key_value_46, key_value_47, key_value_48, key_value_49, key_value_50, key_value_51, key_value_52, key_value_53, key_value_54, key_value_55, key_value_56, key_value_57, key_value_58, key_value_59, key_value_60, key_value_61, key_value_62, key_value_63, key_value_64, key_value_65, key_value_66, key_value_67, key_value_68, key_value_69, key_value_70, key_value_71, key_value_72, key_value_73, key_value_74, key_value_75, key_value_76, key_value_77, key_value_78, key_value_79, key_value_80, key_value_81, key_value_82, key_value_83, key_value_84, key_value_85, key_value_86, key_value_87, key_value_88, key_value_89, key_value_90, key_value_91, key_value_92, key_value_93, key_value_94, key_value_95, key_value_96, key_value_97, key_value_98, key_value_99, key_value_100, key_value_101, key_value_102, key_value_103, key_value_104, key_value_105, key_value_106, key_value_107, key_value_108, key_value_109, key_value_110, key_value_111, key_value_112, key_value_113, key_value_114, key_value_115, key_value_116, key_value_117, key_value_118, key_value_119, key_value_120, key_value_121, key_value_122, key_value_123, key_value_124, key_value_125, key_value_126, key_value_127, key_value_128, key_value_129, key_value_130, key_value_131, key_value_132, key_value_133, key_value_134, key_value_135, key_value_136, key_value_137, key_value_138, key_value_139, key_value_140, key_value_141, key_value_142, key_value_143, key_value_144, key_value_145, key_value_146, key_value_147, key_value_148, key_value_149, key_value_150, key_value_151, key_value_152, key_value_153, key_value_154, key_value_155, key_value_156, key_value_157, key_value_158, key_value_159, key_value_160, key_value_161, key_value_162, key_value_163, key_value_164, key_value_165, key_value_166, key_value_167, key_value_168, key_value_169, key_value_170, key_value_171, key_value_172, key_value_173, key_value_174, key_value_175, key_value_176, key_value_177, key_value_178, key_value_179, key_value_180, key_value_181, key_value_182, key_value_183, key_value_184, key_value_185, key_value_186, key_value_187, key_value_188, key_value_189, key_value_190, key_value_191, key_value_192, key_value_193, key_value_194, key_value_195, key_value_196, key_value_197, key_value_198, key_value_199, key_value_200, key_value_201, key_value_202, key_value_203, key_value_204, key_value_205, key_value_206, key_value_207, key_value_208, key_value_209, key_value_210, key_value_211, key_value_212, key_value_213, key_value_214, key_value_215, key_value_216, key_value_217, key_value_218, key_value_219, key_value_220, key_value_221, key_value_222, key_value_223, key_value_224, key_value_225, key_value_226, key_value_227, key_value_228, key_value_229, key_value_230, key_value_231, key_value_232, key_value_233, key_value_234, key_value_235, key_value_236, key_value_237, key_value_238, key_value_239, key_value_240, key_value_241, key_value_242, key_value_243, key_value_244 };

const char game_name_p[] PROGMEM =  "1944            ";
const char game_name_0[] PROGMEM =  "1944j           ";
const char game_name_1[] PROGMEM =  "19xx            ";
const char game_name_2[] PROGMEM =  "19xxa           ";
const char game_name_3[] PROGMEM =  "19xxar1         ";
const char game_name_4[] PROGMEM =  "19xxb           ";
const char game_name_5[] PROGMEM =  "19xxh           ";
const char game_name_6[] PROGMEM =  "19xxj           ";
const char game_name_7[] PROGMEM =  "19xxjr1         ";
const char game_name_8[] PROGMEM =  "19xxjr2         ";
const char game_name_9[] PROGMEM =  "armwar          ";
const char game_name_10[] PROGMEM =  "armwara         ";
const char game_name_11[] PROGMEM =  "armwarr1        ";
const char game_name_12[] PROGMEM =  "armwaru         ";
const char game_name_13[] PROGMEM =  "armwaru1        ";
const char game_name_14[] PROGMEM =  "avsp            ";
const char game_name_15[] PROGMEM =  "avspa           ";
const char game_name_16[] PROGMEM =  "avsph           ";
const char game_name_17[] PROGMEM =  "avspj           ";
const char game_name_18[] PROGMEM =  "avspu           ";
const char game_name_19[] PROGMEM =  "batcir          ";
const char game_name_20[] PROGMEM =  "batcira         ";
const char game_name_21[] PROGMEM =  "batcirj         ";
const char game_name_22[] PROGMEM =  "choko           ";
const char game_name_23[] PROGMEM =  "csclub          ";
const char game_name_24[] PROGMEM =  "csclub1         ";
const char game_name_25[] PROGMEM =  "cscluba         ";
const char game_name_26[] PROGMEM =  "csclubh         ";
const char game_name_27[] PROGMEM =  "csclubj         ";
const char game_name_28[] PROGMEM =  "csclubjy        ";
const char game_name_29[] PROGMEM =  "cybots          ";
const char game_name_30[] PROGMEM =  "cybotsj         ";
const char game_name_31[] PROGMEM =  "cybotsu         ";
const char game_name_32[] PROGMEM =  "ddsom           ";
const char game_name_33[] PROGMEM =  "ddsoma          ";
const char game_name_34[] PROGMEM =  "ddsomb          ";
const char game_name_35[] PROGMEM =  "ddsomh          ";
const char game_name_36[] PROGMEM =  "ddsomj          ";
const char game_name_37[] PROGMEM =  "ddsomjr1        ";
const char game_name_38[] PROGMEM =  "ddsomr1         ";
const char game_name_39[] PROGMEM =  "ddsomr2         ";
const char game_name_40[] PROGMEM =  "ddsomr3         ";
const char game_name_41[] PROGMEM =  "ddsomu          ";
const char game_name_42[] PROGMEM =  "ddsomur1        ";
const char game_name_43[] PROGMEM =  "ddtod           ";
const char game_name_44[] PROGMEM =  "ddtoda          ";
const char game_name_45[] PROGMEM =  "ddtodar1        ";
const char game_name_46[] PROGMEM =  "ddtodh          ";
const char game_name_47[] PROGMEM =  "ddtodhr1        ";
const char game_name_48[] PROGMEM =  "ddtodhr2        ";
const char game_name_49[] PROGMEM =  "ddtodj          ";
const char game_name_50[] PROGMEM =  "ddtodjr1        ";
const char game_name_51[] PROGMEM =  "ddtodjr2        ";
const char game_name_52[] PROGMEM =  "ddtodr1         ";
const char game_name_53[] PROGMEM =  "ddtodu          ";
const char game_name_54[] PROGMEM =  "ddtodur1        ";
const char game_name_55[] PROGMEM =  "dimahoo         ";
const char game_name_56[] PROGMEM =  "dimahoou        ";
const char game_name_57[] PROGMEM =  "dstlk           ";
const char game_name_58[] PROGMEM =  "dstlka          ";
const char game_name_59[] PROGMEM =  "dstlkh          ";
const char game_name_60[] PROGMEM =  "dstlku          ";
const char game_name_61[] PROGMEM =  "dstlkur1        ";
const char game_name_62[] PROGMEM =  "ecofghtr        ";
const char game_name_63[] PROGMEM =  "ecofghtra       ";
const char game_name_64[] PROGMEM =  "ecofghtrh       ";
const char game_name_65[] PROGMEM =  "ecofghtru       ";
const char game_name_66[] PROGMEM =  "ecofghtru1      ";
const char game_name_67[] PROGMEM =  "gigawing        ";
const char game_name_68[] PROGMEM =  "gigawinga       ";
const char game_name_69[] PROGMEM =  "gigawingb       ";
const char game_name_70[] PROGMEM =  "gigawingh       ";
const char game_name_71[] PROGMEM =  "gigawingj       ";
const char game_name_72[] PROGMEM =  "gmahou          ";
const char game_name_73[] PROGMEM =  "hsf2            ";
const char game_name_74[] PROGMEM =  "hsf2a           ";
const char game_name_75[] PROGMEM =  "hsf2j           ";
const char game_name_76[] PROGMEM =  "jyangoku        ";
const char game_name_77[] PROGMEM =  "megaman2        ";
const char game_name_78[] PROGMEM =  "megaman2a       ";
const char game_name_79[] PROGMEM =  "megaman2h       ";
const char game_name_80[] PROGMEM =  "mmancp2u        ";
const char game_name_81[] PROGMEM =  "mmatrix         ";
const char game_name_82[] PROGMEM =  "mmatrixj        ";
const char game_name_83[] PROGMEM =  "mpang           ";
const char game_name_84[] PROGMEM =  "mpangj          ";
const char game_name_85[] PROGMEM =  "mpangr1         ";
const char game_name_86[] PROGMEM =  "mpangu          ";
const char game_name_87[] PROGMEM =  "msh             ";
const char game_name_88[] PROGMEM =  "msha            ";
const char game_name_89[] PROGMEM =  "mshb            ";
const char game_name_90[] PROGMEM =  "mshh            ";
const char game_name_91[] PROGMEM =  "mshj            ";
const char game_name_92[] PROGMEM =  "mshjr1          ";
const char game_name_93[] PROGMEM =  "mshu            ";
const char game_name_94[] PROGMEM =  "mshvsf          ";
const char game_name_95[] PROGMEM =  "mshvsfa         ";
const char game_name_96[] PROGMEM =  "mshvsfa1        ";
const char game_name_97[] PROGMEM =  "mshvsfb         ";
const char game_name_98[] PROGMEM =  "mshvsfb1        ";
const char game_name_99[] PROGMEM =  "mshvsfh         ";
const char game_name_100[] PROGMEM =  "mshvsfj         ";
const char game_name_101[] PROGMEM =  "mshvsfj1        ";
const char game_name_102[] PROGMEM =  "mshvsfj2        ";
const char game_name_103[] PROGMEM =  "mshvsfu         ";
const char game_name_104[] PROGMEM =  "mshvsfu1        ";
const char game_name_105[] PROGMEM =  "mvsc            ";
const char game_name_106[] PROGMEM =  "mvsca           ";
const char game_name_107[] PROGMEM =  "mvscar1         ";
const char game_name_108[] PROGMEM =  "mvscb           ";
const char game_name_109[] PROGMEM =  "mvsch           ";
const char game_name_110[] PROGMEM =  "mvscj           ";
const char game_name_111[] PROGMEM =  "mvscjr1         ";
const char game_name_112[] PROGMEM =  "mvscjsing       ";
const char game_name_113[] PROGMEM =  "mvscr1          ";
const char game_name_114[] PROGMEM =  "mvscu           ";
const char game_name_115[] PROGMEM =  "mvscur1         ";
const char game_name_116[] PROGMEM =  "nwarr           ";
const char game_name_117[] PROGMEM =  "nwarra          ";
const char game_name_118[] PROGMEM =  "nwarrb          ";
const char game_name_119[] PROGMEM =  "nwarrh          ";
const char game_name_120[] PROGMEM =  "nwarru          ";
const char game_name_121[] PROGMEM =  "pfghtj          ";
const char game_name_122[] PROGMEM =  "pgear           ";
const char game_name_123[] PROGMEM =  "pgearr1         ";
const char game_name_124[] PROGMEM =  "progear         ";
const char game_name_125[] PROGMEM =  "progeara        ";
const char game_name_126[] PROGMEM =  "progearj        ";
const char game_name_127[] PROGMEM =  "pzloop2         ";
const char game_name_128[] PROGMEM =  "pzloop2j        ";
const char game_name_129[] PROGMEM =  "pzloop2jr1      ";
const char game_name_130[] PROGMEM =  "qndream         ";
const char game_name_131[] PROGMEM =  "ringdest        ";
const char game_name_132[] PROGMEM =  "ringdesta       ";
const char game_name_133[] PROGMEM =  "rmancp2j        ";
const char game_name_134[] PROGMEM =  "rockman2j       ";
const char game_name_135[] PROGMEM =  "sfa             ";
const char game_name_136[] PROGMEM =  "sfa2            ";
const char game_name_137[] PROGMEM =  "sfa2u           ";
const char game_name_138[] PROGMEM =  "sfa2ur1         ";
const char game_name_139[] PROGMEM =  "sfa3            ";
const char game_name_140[] PROGMEM =  "sfa3b           ";
const char game_name_141[] PROGMEM =  "sfa3h           ";
const char game_name_142[] PROGMEM =  "sfa3hr1         ";
const char game_name_143[] PROGMEM =  "sfa3u           ";
const char game_name_144[] PROGMEM =  "sfa3ur1         ";
const char game_name_145[] PROGMEM =  "sfar1           ";
const char game_name_146[] PROGMEM =  "sfar2           ";
const char game_name_147[] PROGMEM =  "sfar3           ";
const char game_name_148[] PROGMEM =  "sfau            ";
const char game_name_149[] PROGMEM =  "sfz2a           ";
const char game_name_150[] PROGMEM =  "sfz2al          ";
const char game_name_151[] PROGMEM =  "sfz2alb         ";
const char game_name_152[] PROGMEM =  "sfz2alh         ";
const char game_name_153[] PROGMEM =  "sfz2alj         ";
const char game_name_154[] PROGMEM =  "sfz2b           ";
const char game_name_155[] PROGMEM =  "sfz2br1         ";
const char game_name_156[] PROGMEM =  "sfz2h           ";
const char game_name_157[] PROGMEM =  "sfz2j           ";
const char game_name_158[] PROGMEM =  "sfz2jr1         ";
const char game_name_159[] PROGMEM =  "sfz2n           ";
const char game_name_160[] PROGMEM =  "sfz3a           ";
const char game_name_161[] PROGMEM =  "sfz3ar1         ";
const char game_name_162[] PROGMEM =  "sfz3j           ";
const char game_name_163[] PROGMEM =  "sfz3jr1         ";
const char game_name_164[] PROGMEM =  "sfz3jr2         ";
const char game_name_165[] PROGMEM =  "sfza            ";
const char game_name_166[] PROGMEM =  "sfzar1          ";
const char game_name_167[] PROGMEM =  "sfzb            ";
const char game_name_168[] PROGMEM =  "sfzbr1          ";
const char game_name_169[] PROGMEM =  "sfzh            ";
const char game_name_170[] PROGMEM =  "sfzhr1          ";
const char game_name_171[] PROGMEM =  "sfzj            ";
const char game_name_172[] PROGMEM =  "sfzjr1          ";
const char game_name_173[] PROGMEM =  "sfzjr2          ";
const char game_name_174[] PROGMEM =  "sgemf           ";
const char game_name_175[] PROGMEM =  "sgemfa          ";
const char game_name_176[] PROGMEM =  "sgemfh          ";
const char game_name_177[] PROGMEM =  "smbomb          ";
const char game_name_178[] PROGMEM =  "smbombr1        ";
const char game_name_179[] PROGMEM =  "spf2t           ";
const char game_name_180[] PROGMEM =  "spf2ta          ";
const char game_name_181[] PROGMEM =  "spf2th          ";
const char game_name_182[] PROGMEM =  "spf2xj          ";
const char game_name_183[] PROGMEM =  "ssf2            ";
const char game_name_184[] PROGMEM =  "ssf2a           ";
const char game_name_185[] PROGMEM =  "ssf2ar1         ";
const char game_name_186[] PROGMEM =  "ssf2h           ";
const char game_name_187[] PROGMEM =  "ssf2j           ";
const char game_name_188[] PROGMEM =  "ssf2jr1         ";
const char game_name_189[] PROGMEM =  "ssf2jr2         ";
const char game_name_190[] PROGMEM =  "ssf2t           ";
const char game_name_191[] PROGMEM =  "ssf2ta          ";
const char game_name_192[] PROGMEM =  "ssf2tb          ";
const char game_name_193[] PROGMEM =  "ssf2tba         ";
const char game_name_194[] PROGMEM =  "ssf2tbh         ";
const char game_name_195[] PROGMEM =  "ssf2tbj         ";
const char game_name_196[] PROGMEM =  "ssf2tbr1        ";
const char game_name_197[] PROGMEM =  "ssf2tu          ";
const char game_name_198[] PROGMEM =  "ssf2tur1        ";
const char game_name_199[] PROGMEM =  "ssf2u           ";
const char game_name_200[] PROGMEM =  "ssf2xj          ";
const char game_name_201[] PROGMEM =  "ssf2xjr         ";
const char game_name_202[] PROGMEM =  "uecology        ";
const char game_name_203[] PROGMEM =  "vampj           ";
const char game_name_204[] PROGMEM =  "vampja          ";
const char game_name_205[] PROGMEM =  "vampjr1         ";
const char game_name_206[] PROGMEM =  "vhunt2          ";
const char game_name_207[] PROGMEM =  "vhunt2r1        ";
const char game_name_208[] PROGMEM =  "vhuntj          ";
const char game_name_209[] PROGMEM =  "vhuntjr1        ";
const char game_name_210[] PROGMEM =  "vhuntjr1s       ";
const char game_name_211[] PROGMEM =  "vhuntjr2        ";
const char game_name_212[] PROGMEM =  "vsav            ";
const char game_name_213[] PROGMEM =  "vsav2           ";
const char game_name_214[] PROGMEM =  "vsava           ";
const char game_name_215[] PROGMEM =  "vsavh           ";
const char game_name_216[] PROGMEM =  "vsavj           ";
const char game_name_217[] PROGMEM =  "vsavu           ";
const char game_name_218[] PROGMEM =  "xmcota          ";
const char game_name_219[] PROGMEM =  "xmcotaa         ";
const char game_name_220[] PROGMEM =  "xmcotab         ";
const char game_name_221[] PROGMEM =  "xmcotaar1       ";
const char game_name_222[] PROGMEM =  "xmcotah         ";
const char game_name_223[] PROGMEM =  "xmcotahr1       ";
const char game_name_224[] PROGMEM =  "xmcotaj         ";
const char game_name_225[] PROGMEM =  "xmcotaj1        ";
const char game_name_226[] PROGMEM =  "xmcotaj2        ";
const char game_name_227[] PROGMEM =  "xmcotaj3        ";
const char game_name_228[] PROGMEM =  "xmcotajr        ";
const char game_name_229[] PROGMEM =  "xmcotar1        ";
const char game_name_230[] PROGMEM =  "xmcotau         ";
const char game_name_231[] PROGMEM =  "xmvsf           ";
const char game_name_232[] PROGMEM =  "xmvsfa          ";
const char game_name_233[] PROGMEM =  "xmvsfar1        ";
const char game_name_234[] PROGMEM =  "xmvsfar2        ";
const char game_name_235[] PROGMEM =  "xmvsfar3        ";
const char game_name_236[] PROGMEM =  "xmvsfb          ";
const char game_name_237[] PROGMEM =  "xmvsfh          ";
const char game_name_238[] PROGMEM =  "xmvsfj          ";
const char game_name_239[] PROGMEM =  "xmvsfjr1        ";
const char game_name_240[] PROGMEM =  "xmvsfjr2        ";
const char game_name_241[] PROGMEM =  "xmvsfr1         ";
const char game_name_242[] PROGMEM =  "xmvsfu          ";
const char game_name_243[] PROGMEM =  "xmvsfur1        ";
const char game_name_244[] PROGMEM =  "Phoenix         ";

const char* const GameList[] PROGMEM = { game_name_p, game_name_0, game_name_1, game_name_2, game_name_3, game_name_4, game_name_5, game_name_6, game_name_7, game_name_8, game_name_9, game_name_10, game_name_11, game_name_12, game_name_13, game_name_14, game_name_15, game_name_16, game_name_17, game_name_18, game_name_19, game_name_20, game_name_21, game_name_22, game_name_23, game_name_24, game_name_25, game_name_26, game_name_27, game_name_28, game_name_29, game_name_30, game_name_31, game_name_32, game_name_33, game_name_34, game_name_35, game_name_36, game_name_37, game_name_38, game_name_39, game_name_40, game_name_41, game_name_42, game_name_43, game_name_44, game_name_45, game_name_46, game_name_47, game_name_48, game_name_49, game_name_50, game_name_51, game_name_52, game_name_53, game_name_54, game_name_55, game_name_56, game_name_57, game_name_58, game_name_59, game_name_60, game_name_61, game_name_62, game_name_63, game_name_64, game_name_65, game_name_66, game_name_67, game_name_68, game_name_69, game_name_70, game_name_71, game_name_72, game_name_73, game_name_74, game_name_75, game_name_76, game_name_77, game_name_78, game_name_79, game_name_80, game_name_81, game_name_82, game_name_83, game_name_84, game_name_85, game_name_86, game_name_87, game_name_88, game_name_89, game_name_90, game_name_91, game_name_92, game_name_93, game_name_94, game_name_95, game_name_96, game_name_97, game_name_98, game_name_99, game_name_100, game_name_101, game_name_102, game_name_103, game_name_104, game_name_105, game_name_106, game_name_107, game_name_108, game_name_109, game_name_110, game_name_111, game_name_112, game_name_113, game_name_114, game_name_115, game_name_116, game_name_117, game_name_118, game_name_119, game_name_120, game_name_121, game_name_122, game_name_123, game_name_124, game_name_125, game_name_126, game_name_127, game_name_128, game_name_129, game_name_130, game_name_131, game_name_132, game_name_133, game_name_134, game_name_135, game_name_136, game_name_137, game_name_138, game_name_139, game_name_140, game_name_141, game_name_142, game_name_143, game_name_144, game_name_145, game_name_146, game_name_147, game_name_148, game_name_149, game_name_150, game_name_151, game_name_152, game_name_153, game_name_154, game_name_155, game_name_156, game_name_157, game_name_158, game_name_159, game_name_160, game_name_161, game_name_162, game_name_163, game_name_164, game_name_165, game_name_166, game_name_167, game_name_168, game_name_169, game_name_170, game_name_171, game_name_172, game_name_173, game_name_174, game_name_175, game_name_176, game_name_177, game_name_178, game_name_179, game_name_180, game_name_181, game_name_182, game_name_183, game_name_184, game_name_185, game_name_186, game_name_187, game_name_188, game_name_189, game_name_190, game_name_191, game_name_192, game_name_193, game_name_194, game_name_195, game_name_196, game_name_197, game_name_198, game_name_199, game_name_200, game_name_201, game_name_202, game_name_203, game_name_204, game_name_205, game_name_206, game_name_207, game_name_208, game_name_209, game_name_210, game_name_211, game_name_212, game_name_213, game_name_214, game_name_215, game_name_216, game_name_217, game_name_218, game_name_219, game_name_220, game_name_221, game_name_222, game_name_223, game_name_224, game_name_225, game_name_226, game_name_227, game_name_228, game_name_229, game_name_230, game_name_231, game_name_232, game_name_233, game_name_234, game_name_235, game_name_236, game_name_237, game_name_238, game_name_239, game_name_240, game_name_241, game_name_242, game_name_243, game_name_244 };

char buffer[20];  

unsigned char mask = 1; // Bit 
unsigned char bits[8];
int c = -1;


void DisplayIntro()
{
  lcd.begin(16, 2);
  lcd.setCursor(0,0);
  lcd.print("CPS2 Desuicide");
  lcd.setCursor(0,1);
  lcd.print("By ArcadeHacker");
  delay(2500);
}

void DisplayMenu()
{
  lcd.setCursor(0,0);
  lcd.print("Select a game:  ");
  lcd.setCursor(0,1);
  lcd.print(" --press down-- ");
}

void PrepareOutput()
{
  pinMode(SETUP1, OUTPUT); pinMode(SETUP2, OUTPUT);
  pinMode(CLOCK, OUTPUT); pinMode(DATA, OUTPUT); 

  digitalWrite(SETUP1, LOW);
  digitalWrite(CLOCK, LOW);
  digitalWrite(DATA, LOW);
  digitalWrite(SETUP2, HIGH);
}

void setup() {
  PrepareOutput();
  
  DisplayIntro();
  DisplayMenu();
}


void CLK()
{
  digitalWrite(CLOCK, HIGH); 
  delay(time);
  digitalWrite(CLOCK, LOW); 
  delay(time);  
}

void program_unlock()
{
    digitalWrite(SETUP1, HIGH);
    digitalWrite(SETUP2, LOW);
    delay(time); delay(time); delay(time); delay(time); 
} 

void ProgramCPS2(int prg)
{
  int i;
  int test;
  unsigned char cByte;

  
  lcd.clear();
  lcd.setCursor(0,1);
  lcd.print("Unlocking...    ");                  
  
  program_unlock();      
  
  lcd.setCursor(0,0);   
  lcd.print("Programming     ");
  lcd.setCursor(0,1);
  lcd.print("CPS2...        %");    
  
  //Serial.begin(9600);
  
  for(i=0; i<20; i++)        
  {   
    cByte =  pgm_read_byte_near(Keys[prg]+i);
    //Serial.print(cByte, HEX);
    //Serial.print(' ');

    lcd.setCursor(13,1);
    lcd.print(i*5, DEC);  
    
    for (int b = 7; b > -1; b--) {  
      bits[b] = (cByte & (mask << b)) != 0;
      //printf("%d",bits[b]);
    
      if (bits[b] == 1) 
      { digitalWrite(DATA, HIGH); } 
      else 
      { digitalWrite(DATA, LOW);  }
      CLK(); 
    }
  }

  digitalWrite(SETUP1, LOW);
  digitalWrite(SETUP2, HIGH); 
  delay(time);
  digitalWrite(CLOCK, LOW);
  
  lcd.clear();
  lcd.setCursor(0,1);
  lcd.print("Done!           ");                   
  delay(1000);       
  
  
  //while (analogRead (0) != 638) { 
    lcd.setCursor(0,0); lcd.print("--disconnect and ");   lcd.setCursor(0,1); lcd.print("test pcb--"); 
  //}
  delay(2000); 
}

int read_LCD_buttons()
{
  adc_key_in = analogRead(0);   
  delay(5);
  int k = (analogRead(0) - adc_key_in); 
  if (5 < abs(k)) return btnNONE;  
  
  if (adc_key_in > 1000) return btnNONE; 
  if (adc_key_in < 50)   return btnRIGHT;  
  if (adc_key_in < 195)  return btnUP; 
  if (adc_key_in < 380)  return btnDOWN; 
  if (adc_key_in < 555)  return btnLEFT; 
  if (adc_key_in < 790)  return btnSELECT;   
  
  return btnNONE;  
}     

void DisplayName(int game)
{
  int len = 0, i = 0;

  if(c == -1)
    return;
  lcd.setCursor(0,1);            // move to the begining of the second line
  strcpy_P(buffer, (char*)pgm_read_word(&(GameList[c]))); 
  len = strlen(buffer);
  for(i = len; i < 16; i++)
    buffer[i] = ' ';
  buffer[i] = '\0';
  lcd.print(buffer);
}

int FindNextIndex(int pos, int dir)
{
  int TempIndex = pos, found = -1;
  int comp = 4; // 3 and 4 work well, both with disadvantages
  int listsize =  sizeof(GameList)/sizeof(GameList[0])-1;

  if(pos == -1)
    return 0;
  
  strncpy_P(buffer, (char*)pgm_read_word(&(GameList[pos])), comp);
  if(strlen(buffer) == 3) // Adjust for msh
    comp = 3;
  do
  {
    if(dir)
    {
      if(TempIndex < listsize)
        TempIndex++;
    }
    else
    {
      if(TempIndex > 0)
        TempIndex--;
    }
  
    found = strncmp_P(buffer, (char*)pgm_read_word(&(GameList[TempIndex])), comp);
  }while(found == 0 && TempIndex < listsize && TempIndex != 0);

  return TempIndex;
}

void loop()   /*----( LOOP: RUNS CONSTANTLY )----*/
{
  int listsize =  sizeof(GameList)/sizeof(GameList[0])-1;
  adc_key_prev = lcd_key ;       // Looking for changes
  lcd_key = read_LCD_buttons();  // read the buttons
  
  if (adc_key_prev != lcd_key)
  { 
    switch (lcd_key)               // depending on which button was pushed, we perform an action
    {
      case btnRIGHT:
      {
        /*
        if (c+10 < listsize)
          c += 10;
        else
          c = listsize;
        */
        c = FindNextIndex(c, 1);
        break;
      }
      
      case btnLEFT:
      {
        /*
        if (c > 10)
          c -= 10;
        else
          c = 0;    
        */ 
        c = FindNextIndex(FindNextIndex(c, 0), 0); // Calling it once gets the last item.
        if(c) c++; // Get First Item in category
        break;
      }
      
      case btnUP:
      {
        if (c !=0)
        {
          if (c > 0) {c--;} else {c++;}
        }
        break;
      }
      
      case btnDOWN:
      {
        if (c != listsize) 
          {c++;}
        break;
      }
      
      case btnSELECT:
      {
        if (c != -1) 
        {
          ProgramCPS2(c);  

          lcd_key = btnNONE;
          do
          {
            lcd_key = read_LCD_buttons();  // read the buttons
          }while(lcd_key == btnNONE);
          
          PrepareOutput();
          DisplayMenu();
        }
        break;
      }
    }
    DisplayName(c);
  }
}
