// UnderC Development Project, 2001
#ifndef _WININET_H
#define _WININET_H
#include <windows.h>
typedef void *HINTERNET;
typedef WORD INTERNET_PORT,*LPINTERNET_PORT;

#define INTERNET_OPEN_TYPE_PRECONFIG 0
#define INTERNET_OPEN_TYPE_DIRECT 1
#define INTERNET_OPEN_TYPE_PROXY 3
#define INTERNET_DEFAULT_FTP_PORT 21
#define INTERNET_DEFAULT_HTTP_PORT 80
#define INTERNET_SERVICE_FTP 1
#define INTERNET_SERVICE_HTTP 3

// flags
#define INTERNET_FLAG_RELOAD 0x80000000
#define INTERNET_FLAG_RAW_DATA 0x40000000
#define INTERNET_FLAG_EXISTING_CONNECT 0x20000000
#define INTERNET_FLAG_ASYNC 0x10000000
#define INTERNET_FLAG_PASSIVE 0x08000000
#define INTERNET_FLAG_NO_CACHE_WRITE 0x04000000
#define INTERNET_FLAG_DONT_CACHE INTERNET_FLAG_NO_CACHE_WRITE
#define INTERNET_FLAG_MAKE_PERSISTENT 0x02000000
#define INTERNET_FLAG_OFFLINE 0x1000000
#define INTERNET_FLAG_SECURE 0x800000
#define INTERNET_FLAG_KEEP_CONNECTION 0x400000
#define INTERNET_FLAG_NO_AUTO_REDIRECT 0x200000
#define INTERNET_FLAG_READ_PREFETCH 0x100000
#define INTERNET_FLAG_NO_COOKIES 0x80000
#define INTERNET_FLAG_NO_AUTH 0x40000
#define INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTP 0x8000
#define INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTPS 0x4000
#define INTERNET_FLAG_IGNORE_CERT_DATE_INVALID 0x2000
#define INTERNET_FLAG_IGNORE_CERT_CN_INVALID 0x1000
#define INTERNET_FLAG_MUST_CACHE_REQUEST 16
#define INTERNET_FLAG_RESYNCHRONIZE 0x800
#define INTERNET_FLAG_HYPERLINK 0x400

#define FTP_TRANSFER_TYPE_UNKNOWN 0
#define FTP_TRANSFER_TYPE_ASCII 1
#define FTP_TRANSFER_TYPE_BINARY 2
#define FTP_TRANSFER_TYPE_MASK (FTP_TRANSFER_TYPE_ASCII | FTP_TRANSFER_TYPE_BINARY)


#lib WININET.DLL
// Note that UCW requires the attribute _in front_...
extern "C" {
 WINAPI HINTERNET  InternetOpenA(LPCSTR,DWORD,LPCSTR,LPCSTR,DWORD);
 WINAPI BOOL       InternetCloseHandle(HINTERNET);
 WINAPI HINTERNET  InternetConnectA(HINTERNET,LPCSTR,INTERNET_PORT,LPCSTR,LPCSTR,DWORD,DWORD,DWORD);
 WINAPI BOOL       InternetReadFile(HINTERNET,PVOID,DWORD,PDWORD);
 WINAPI HINTERNET  HttpOpenRequestA(HINTERNET,LPCSTR,LPCSTR,LPCSTR,LPCSTR,LPCSTR *,DWORD,DWORD);
 WINAPI BOOL       HttpSendRequestA(HINTERNET,LPCSTR,DWORD,PVOID,DWORD);
// FTP stuff
WINAPI HINTERNET FtpFindFirstFileA(HINTERNET,LPCSTR,LPWIN32_FIND_DATA,DWORD,DWORD);
WINAPI BOOL FtpGetFileA(HINTERNET,LPCSTR,LPCSTR,BOOL,DWORD,DWORD,DWORD);
WINAPI BOOL FtpPutFileA(HINTERNET,LPCSTR,LPCSTR,DWORD,DWORD);
WINAPI BOOL FtpDeleteFileA(HINTERNET,LPCSTR);
WINAPI BOOL FtpRenameFileA(HINTERNET, LPCSTR,LPCSTR);
WINAPI HINTERNET FtpOpenFileA(HINTERNET,LPCSTR,DWORD,DWORD,DWORD);
WINAPI BOOL FtpCreateDirectoryA(HINTERNET,LPCSTR);
WINAPI BOOL FtpRemoveDirectoryA(HINTERNET,LPCSTR);
WINAPI BOOL FtpSetCurrentDirectoryA(HINTERNET,LPCSTR);
WINAPI BOOL FtpGetCurrentDirectoryA(HINTERNET,LPSTR,PDWORD);
WINAPI BOOL FtpCommandA(HINTERNET,BOOL,DWORD,LPCSTR,DWORD);

}
#define HttpSendRequest HttpSendRequestA
#define InternetOpen InternetOpenA
#define HttpOpenRequest HttpOpenRequestA
#define InternetConnect InternetConnectA

#define FtpFindFirstFile FtpFindFirstFileA
#define FtpGetFile FtpGetFileA
#define FtpPutFile FtpPutFileA
#define FtpDeleteFile FtpDeleteFileA
#define FtpRenameFile FtpRenameFileA
#define FtpOpenFile FtpOpenFileA
#define FtpCreateDirectory FtpCreateDirectoryA
#define FtpRemoveDirectory FtpRemoveDirectoryA
#define FtpSetCurrentDirectory FtpSetCurrentDirectoryA
#define FtpCommand FtpCommandA


#endif
