(*)
 [------------------------------------------------------------------------------
 [  D3DX 8.1 Delphi Adaptation (c) by Tim Baumgarten
 [------------------------------------------------------------------------------
 [  Files    : d3dx8.h
 [           : d3dx8math.h
 [           : d3dx8core.h
 [           : d3dx8tex.h
 [           : d3dx8mesh.h
 [           : d3dx8shape.h
 [           : d3dx8effect.h
 [  Modified : 8-Dec-2002
 [  E-Mail   : ampaze at gmx dot net
 [  Download : http://www.crazyentertainment.net
 [------------------------------------------------------------------------------
(*)
// TODO : add more overloads to D3DXLoadSkinMeshFromXof and D3DXSplitMesh
(*)
 [------------------------------------------------------------------------------
 [ History :
 [----------
 [ 8-Dec-2002 (Tim Baumgarten) : Fixed D3DXCreate*TextureFromFileInMemory
 [                                 btw : happy birthday type4 
 [ 6-Nov-2002 (Tim Baumgarten) : Changd PD3DXImageInfo = ^PD3DXImageInfo; to
 [                                 PD3DXImageInfo = ^TD3DXImageInfo;
 [ 11-Sep-2002 (Hirotaka Kadoya) : Fixed D3DXCreateFontIndirect,
 [                                  'Font : ID3DXFont' needed 'out'
 [ 23-Jul-2002 (Tim Baumgarten) : Deklaration of ID3DXSkinMesh was wrong.
 [ 14-Jul-2002 (Tim Baumgarten) : Changed in DrawTextW Rect : PRect to
 [                                  var Rect : TRect, hope all agree ;)
 [ 10-Jul-2002 (Tim Baumgarten) : Fixed linking into the dll, for some
 [                                functions
 [ 18-Jun-2002 (Tim Baumgarten) : Added Overloads to D3DXCreateXXX functions
 [ 29-May-2002 (Tim Baumgarten) : Fixed ConvertToBlendedMesh and
 [                                ConvertToIndexedBlendedMesh of ID3DXSkinMesh
 [                                Added outs to the ID3DXBuffers 
 [ 14-Feb-2002 (Tim Baumgarten) : Fixed / Added some more overloads to the
 [                                following functions :
 [                                 - D3DXCreateSprite
 [                                 - D3DXCreateFont
 [                                 - D3DXAssembleShaderFromFile
 [                                 - D3DXAssembleShader
 [                                 - D3DXAssembleShaderFromResource
 [                                 - D3DXIntersect
 [                                 - D3DXMatrixTranslation
 [ 26-Dez-2001 (Tim Baumgarten) : Some fixes.
 [ 23-Dez-2001 (Tim Baumgarten) : Finished D3DX8.1 conversion, this file is not
 [                                tested in any way, so please report any bugs
 [                                you discover ! Happy Xmas !
 [------------------------------------------------------------------------------
(*)

{$MINENUMSIZE 4}
{$ALIGN ON}

//Remove dot to make all enums to be const's
{.$DEFINE NOENUMS}

{$IFDEF VER150}
  {$WARN UNSAFE_CODE OFF}
  {$WARN UNSAFE_TYPE OFF}
  {$WARN UNSAFE_CAST OFF}
{$ENDIF}

unit D3DX81mo;

interface

uses Windows, DirectXGraphics, DXFile8, SysUtils, ActiveX, math;

type
  PCardinal = ^Cardinal;

const D3DX81DLLName = 'D3DX81ab.dll';
//const D3DX81DLLName = 'D3DX8d.dll';

(*)
[-------------------------------------------------------------------------------
[  Copyright (C) Microsoft Corporation.  All Rights Reserved.
[
[  File    :    d3dx8.h
[  Content :    D3DX utility library
[-------------------------------------------------------------------------------
(*)

const
  D3DX_DEFAULT       : ULONG = $FFFFFFFF;

  D3DX_DEFAULT_FLOAT : Single = 3.402823466e+38;  // max single value

(*)
[-------------------------------------------------------------------------------
[  Copyright (C) Microsoft Corporation.  All Rights Reserved.
[
[  File    :    d3dx8math.h
[  Content :    D3DX math types and functions
[-------------------------------------------------------------------------------
(*)


// General purpose utilities
const
  D3DX_PI    : Single  = 3.141592654;
  D3DX_1BYPI : Single  = 0.318309886;

function D3DXErrorString(DXErrorCode : HResult) : String;  

function D3DXToRadian(Degree : Single) : Single;

function D3DXToDegree(Radian : Single) : Single;

//------------------------------------------------------------------------------
//
// Vectors
//
//------------------------------------------------------------------------------


//--------------------------
// 2D Vector
//--------------------------

type
  PD3DXVector2 = ^TD3DXVector2;
  TD3DXVector2 = packed record
    x, y : Single;
  end;

// Some 2D Vector helpers
//const D3DXVector2Zero : TD3DXVector2 = (x : 0; y : 0);
function D3DXVector2Zero : TD3DXVector2;
function D3DXVector2(const x, y : Single) : TD3DXVector2;
function D3DXVector2Equal(const v1, v2 : TD3DXVector2) : Boolean;

//--------------------------
// 3D Vector
//--------------------------

type
  PD3DXVector3 = ^TD3DXVector3;
  TD3DXVector3 = TD3DVector;

// Some 3D Vector helpers
//const D3DXVector3Zero : TD3DXVector3 = (x : 0; y : 0; z : 0);
function D3DXVector3Zero : TD3DXVector3;
function D3DXVector3(const x, y, z : Single) : TD3DXVector3;
function D3DXVector3Equal(const v1, v2 : TD3DXVector3) : Boolean;


//--------------------------
// 4D Vector
//--------------------------

type
  PD3DXVector4 = ^TD3DXVector4;
  TD3DXVector4 = packed record
    x, y, z, w : Single;
  end;

// Some 4D Vector helpers
//const D3DXVector4Zero : TD3DXVector4 = (x : 0; y : 0; z : 0; w : 0);
function D3DXVector4Zero : TD3DXVector4;
function D3DXVector4(const x, y, z, w : Single) : TD3DXVector4;
function D3DXVector4Equal(const v1, v2 : TD3DXVector4) : Boolean;


//------------------------------------------------------------------------------
//
// Matrices
//
//------------------------------------------------------------------------------

type
  PD3DXMatrix = ^TD3DXMatrix;
  TD3DXMatrix = TD3DMatrix;

const IdentityMatrix : TD3DXMatrix = (_11 : 1; _12 : 0; _13 : 0; _14 : 0;
                                      _21 : 0; _22 : 1; _23 : 0; _24 : 0;
                                      _31 : 0; _32 : 0; _33 : 1; _34 : 0;
                                      _41 : 0; _42 : 0; _43 : 0; _44 : 1);

// Some Matrix helpers
function D3DXMatrix(m00, m01, m02, m03,
                    m10, m11, m12, m13,
                    m20, m21, m22, m23,
                    m30, m31, m32, m33 : Single) : TD3DXMatrix;
function D3DXMatrixAdd(const m1, m2 : TD3DXMatrix) : TD3DXMatrix;
function D3DXMatrixSubtract(const m1, m2 : TD3DXMatrix) : TD3DXMatrix;
function D3DXMatrixScale(const m : TD3DXMatrix; const ScaleBy : Single) : TD3DXMatrix;
function D3DXMatrixEqual(const m1, m2 : TD3DXMatrix) : Boolean;

//------------------------------------------------------------------------------
//
// Aligned Matrices
//
// This class helps keep matrices 16-byte aligned as preferred by P4 cpus.
// It aligns matrices on the stack and on the heap or in global scope.
// It does this using __declspec(align(16)) which works on VC7 and on VC 6
// with the processor pack. Unfortunately there is no way to detect the
// latter so this is turned on only on VC7. On other compilers this is the
// the same as D3DXMATRIX.
// Using this class on a compiler that does not actually do the alignment
// can be dangerous since it will not expose bugs that ignore alignment.
// E.g if an object of this class in inside a struct or class, and some code
// memcopys data in it assuming tight packing. This could break on a compiler
// that eventually start aligning the matrix.
//
//------------------------------------------------------------------------------

// Not possible in Object Pascal, hence use the normal TD3DXMatrix type

type
  PD3DXMatrixA16 = ^TD3DXMatrixA16;
  TD3DXMatrixA16 = TD3DXMatrix;


//------------------------------------------------------------------------------
//
//    Quaternions
//
//------------------------------------------------------------------------------

type
  PD3DXQuaternion = ^TD3DXQuaternion;
  TD3DXQuaternion = packed record
    x, y, z, w : Single;
  end;

const IdentityQuaternion : TD3DXQuaternion = (x : 0; y : 0; z : 0; w : 1);

// Some Quaternion helpers
function D3DXQuaternion(const x, y, z, w : Single) : TD3DXQuaternion;
function D3DXQuaternionAdd(const q1, q2 : TD3DXQuaternion) : TD3DXQuaternion;
function D3DXQuaternionSubtract(const q1, q2 : TD3DXQuaternion) : TD3DXQuaternion;
function D3DXQuaternionEqual(const q1, q2 : TD3DXQuaternion) : Boolean;
function D3DXQuaternionScale(const q : TD3DXQuaternion; const ScaleBy : Single) : TD3DXQuaternion;

//------------------------------------------------------------------------------
//
// Planes
//
//------------------------------------------------------------------------------

type
  PD3DXPlane = ^TD3DXPlane;
  TD3DXPlane = packed record
    a, b, c, d : Single;
  end;

// Some Plane helpers
//const D3DXPlaneZero : TD3DXPlane = (a : 0; b : 0; c : 0; d : 0);
function D3DXPlaneZero : TD3DXPlane;
function D3DXPlane(const a, b, c, d : Single) : TD3DXPlane;
function D3DXPlaneEqual(const p1, p2 : TD3DXPlane) : Boolean;


//------------------------------------------------------------------------------
//
// Colors
//
//------------------------------------------------------------------------------

type
  PD3DXColor = ^TD3DXColor;
  TD3DXColor = packed record
    r, g, b, a : Single;
  end;

function D3DXColor(const r, g, b, a : Single) : TD3DXColor;
function D3DXColorToLongWord(c : TD3DXColor): LongWord;
function D3DXColorFromLongWord(c : LongWord) : TD3DXColor;
function D3DXColorEqual(const c1, c2 : TD3DXColor) : Boolean;


//------------------------------------------------------------------------------
//
// D3DX math functions:
//
// NOTE:
//  * All these functions can take the same object as in and out parameters.
//
//  * Out parameters are typically also returned as return values, so that
//    the output of one function may be used as a parameter to another.
//
//------------------------------------------------------------------------------

//--------------------------
// 2D Vector
//--------------------------

// inline

function D3DXVec2Length(const V : TD3DXVector2) : Single;

function D3DXVec2LengthSq(const V : TD3DXVector2) : Single;

function D3DXVec2Dot(const V1, V2 : TD3DXVector2) : Single;

// Z component of ((x1,y1,0) cross (x2,y2,0))
function D3DXVec2CCW(const V1, V2 : TD3DXVector2) : Single;

function D3DXVec2Add(const V1, V2 : TD3DXVector2) : TD3DXVector2;

function D3DXVec2Subtract(const V1, V2 : TD3DXVector2) : TD3DXVector2;

// Minimize each component.  x = min(x1, x2), y = min(y1, y2)
function D3DXVec2Minimize(const v1, v2 : TD3DXVector2) : TD3DXVector2;

// Maximize each component.  x = max(x1, x2), y = max(y1, y2)
function D3DXVec2Maximize(const v1, v2 : TD3DXVector2) : TD3DXVector2;

function D3DXVec2Scale(const V : TD3DXVector2; const ScaleBy : Single) : TD3DXVector2;

// Linear interpolation. V1 + s(V2-V1)
function D3DXVec2Lerp(const V1, V2 : TD3DXVector2; const ScaleBy : Single) : TD3DXVector2;

// non-inline

function D3DXVec2Normalize(out, V : PD3DXVector2) : PD3DXVector2; stdcall; overload;
function D3DXVec2Normalize(out Out : TD3DXVector2; V : PD3DXVector2) : PD3DXVector2; stdcall; overload;
function D3DXVec2Normalize(Out : PD3DXVector2; var V : TD3DXVector2) : PD3DXVector2; stdcall; overload;
function D3DXVec2Normalize(out Out : TD3DXVector2; var V : TD3DXVector2) : PD3DXVector2; stdcall; overload;

// Hermite interpolation between position V1, tangent T1 (when s == 0)
// and position V2, tangent T2 (when s == 1).
function D3DXVec2Hermite(Out, V1, T1, V2, T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(out Out : TD3DXVector2; V1, T1, V2, T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(Out : PD3DXVector2; var V1 : TD3DXVector2; T1, V2, T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(out Out : TD3DXVector2; var V1 : TD3DXVector2; T1, V2, T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(Out, V1 : PD3DXVector2; var T1 : TD3DXVector2; V2, T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(out Out : TD3DXVector2; V1 : PD3DXVector2; var T1 : TD3DXVector2; V2, T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(Out : PD3DXVector2; var V1, T1 : TD3DXVector2; V2, T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(out Out : TD3DXVector2; var V1, T1 : TD3DXVector2; V2, T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(Out, V1, T1 : PD3DXVector2; var V2 : TD3DXVector2; T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(out Out : TD3DXVector2; V1, T1 : PD3DXVector2; var V2 : TD3DXVector2; T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(Out : PD3DXVector2; var V1 : TD3DXVector2; T1 : PD3DXVector2; var V2 : TD3DXVector2; T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(out Out : TD3DXVector2; var V1 : TD3DXVector2; T1 : PD3DXVector2; var V2 : TD3DXVector2; T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(Out, V1 : PD3DXVector2; var T1, V2 : TD3DXVector2; T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(out Out : TD3DXVector2; V1 : PD3DXVector2; var T1, V2 : TD3DXVector2; T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(Out : PD3DXVector2; var V1, T1, V2 : TD3DXVector2; T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(out Out : TD3DXVector2; var V1, T1, V2 : TD3DXVector2; T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(Out, V1, T1, V2 : PD3DXVector2; var T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(out Out : TD3DXVector2; V1, T1, V2 : PD3DXVector2; var T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(Out : PD3DXVector2; var V1 : TD3DXVector2; T1, V2 : PD3DXVector2; var T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(out Out : TD3DXVector2; var V1 : TD3DXVector2; T1, V2 : PD3DXVector2; var T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(Out, V1 : PD3DXVector2; var T1 : TD3DXVector2; V2 : PD3DXVector2; var T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(out Out : TD3DXVector2; V1 : PD3DXVector2; var T1 : TD3DXVector2; V2 : PD3DXVector2; var T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(Out : PD3DXVector2; var V1, T1 : TD3DXVector2; V2 : PD3DXVector2; var T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(out Out : TD3DXVector2; var V1, T1 : TD3DXVector2; V2 : PD3DXVector2; var T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(Out, V1, T1 : PD3DXVector2; var V2, T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(out Out : TD3DXVector2; V1, T1 : PD3DXVector2; var V2, T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(Out : PD3DXVector2; var V1 : TD3DXVector2; T1 : PD3DXVector2; var V2, T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(out Out : TD3DXVector2; var V1 : TD3DXVector2; T1 : PD3DXVector2; var V2, T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(Out, V1 : PD3DXVector2; var T1, V2, T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(out Out : TD3DXVector2; V1 : PD3DXVector2; var T1, V2, T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(Out : PD3DXVector2; var V1, T1, V2, T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2Hermite(out Out : TD3DXVector2; var V1, T1, V2, T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;

// CatmullRom interpolation between V1 (when s == 0) and V2 (when s == 1)
function D3DXVec2CatmullRom(Out, v0, v1, v2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2CatmullRom(out Out : TD3DXVector2; v0, v1, v2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2CatmullRom(Out : PD3DXVector2; var v0 : TD3DXVector2; v1, v2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2CatmullRom(out Out : TD3DXVector2; var v0 : TD3DXVector2; v1, v2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2CatmullRom(Out, v0 : PD3DXVector2; var v1 : TD3DXVector2; v2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2CatmullRom(out Out : TD3DXVector2; v0 : PD3DXVector2; var v1 : TD3DXVector2; v2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2CatmullRom(Out : PD3DXVector2; var v0, v1 : TD3DXVector2; v2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2CatmullRom(out Out : TD3DXVector2; var v0, v1 : TD3DXVector2; v2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2CatmullRom(Out, v0, v1 : PD3DXVector2; var v2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2CatmullRom(out Out : TD3DXVector2; v0, v1 : PD3DXVector2; var v2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2CatmullRom(Out : PD3DXVector2; var v0 : TD3DXVector2; v1 : PD3DXVector2; var v2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2CatmullRom(out Out : TD3DXVector2; var v0 : TD3DXVector2; v1 : PD3DXVector2; var v2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2CatmullRom(Out, v0 : PD3DXVector2; var v1, v2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2CatmullRom(out Out : TD3DXVector2; v0 : PD3DXVector2; var v1, v2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2CatmullRom(Out : PD3DXVector2; var v0, v1, v2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2CatmullRom(out Out : TD3DXVector2; var v0, v1, v2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; overload;

// Barycentric coordinates.  V1 + f(V2-V1) + g(V3-V1)
function D3DXVec2BaryCentric(Out, v1, v2, v3 : PD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2BaryCentric(out Out : TD3DXVector2; v1, v2, v3 : PD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2BaryCentric(Out : PD3DXVector2; var v1 : TD3DXVector2; v2, v3 : PD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2BaryCentric(out Out : TD3DXVector2; var v1 : TD3DXVector2; v2, v3 : PD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2BaryCentric(Out, v1 : PD3DXVector2; var v2 : TD3DXVector2; v3 : PD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2BaryCentric(out Out : TD3DXVector2; v1 : PD3DXVector2; var v2 : TD3DXVector2; v3 : PD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2BaryCentric(Out : PD3DXVector2; var v1, v2 : TD3DXVector2; v3 : PD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2BaryCentric(out Out : TD3DXVector2; var v1, v2 : TD3DXVector2; v3 : PD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2BaryCentric(Out, v1, v2 : PD3DXVector2; var v3 : TD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2BaryCentric(out Out : TD3DXVector2; v1, v2 : PD3DXVector2; var v3 : TD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2BaryCentric(Out : PD3DXVector2; var v1 : TD3DXVector2; v2 : PD3DXVector2; var v3 : TD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2BaryCentric(out Out : TD3DXVector2; var v1 : TD3DXVector2; v2 : PD3DXVector2; var v3 : TD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2BaryCentric(Out, v1 : PD3DXVector2; var v2, v3 : TD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2BaryCentric(out Out : TD3DXVector2; v1 : PD3DXVector2; var v2, v3 : TD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2BaryCentric(Out : PD3DXVector2; var v1, v2, v3 : TD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; overload;
function D3DXVec2BaryCentric(out Out : TD3DXVector2; var v1, v2, v3 : TD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; overload;

// Transform (x, y, 0, 1) by matrix.
function D3DXVec2Transform(Out : PD3DXVector4; v : PD3DXVector2; m : PD3DXMatrix) : PD3DXVector4; stdcall; overload;
function D3DXVec2Transform(out Out : TD3DXVector4; v : PD3DXVector2; m : PD3DXMatrix) : PD3DXVector4; stdcall; overload;
function D3DXVec2Transform(Out : PD3DXVector4; var v : TD3DXVector2; m : PD3DXMatrix) : PD3DXVector4; stdcall; overload;
function D3DXVec2Transform(out Out : TD3DXVector4; var v : TD3DXVector2; m : PD3DXMatrix) : PD3DXVector4; stdcall; overload;
function D3DXVec2Transform(Out : PD3DXVector4; v : PD3DXVector2; var m : TD3DXMatrix) : PD3DXVector4; stdcall; overload;
function D3DXVec2Transform(out Out : TD3DXVector4; v : PD3DXVector2; var m : TD3DXMatrix) : PD3DXVector4; stdcall; overload;
function D3DXVec2Transform(Out : PD3DXVector4; var v : TD3DXVector2; var m : TD3DXMatrix) : PD3DXVector4; stdcall; overload;
function D3DXVec2Transform(out Out : TD3DXVector4; var v : TD3DXVector2; var m : TD3DXMatrix) : PD3DXVector4; stdcall; overload;

// Transform (x, y, 0, 1) by matrix, project result back into w=1.
function D3DXVec2TransformCoord(Out, v : PD3DXVector2; m : PD3DXMatrix) : PD3DXVector2; stdcall; overload;
function D3DXVec2TransformCoord(out Out : TD3DXVector2; v : PD3DXVector2; m : PD3DXMatrix) : PD3DXVector2; stdcall; overload;
function D3DXVec2TransformCoord(Out : PD3DXVector2; var v : TD3DXVector2; m : PD3DXMatrix) : PD3DXVector2; stdcall; overload;
function D3DXVec2TransformCoord(out Out : TD3DXVector2; var v : TD3DXVector2; m : PD3DXMatrix) : PD3DXVector2; stdcall; overload;
function D3DXVec2TransformCoord(Out, v : PD3DXVector2; var m : TD3DXMatrix) : PD3DXVector2; stdcall; overload;
function D3DXVec2TransformCoord(out Out : TD3DXVector2; v : PD3DXVector2; var m : TD3DXMatrix) : PD3DXVector2; stdcall; overload;
function D3DXVec2TransformCoord(Out : PD3DXVector2; var v : TD3DXVector2; var m : TD3DXMatrix) : PD3DXVector2; stdcall; overload;
function D3DXVec2TransformCoord(out Out : TD3DXVector2; var v : TD3DXVector2; var m : TD3DXMatrix) : PD3DXVector2; stdcall; overload;

// Transform (x, y, 0, 0) by matrix.
function D3DXVec2TransformNormal(Out, v : PD3DXVector2; m : PD3DXMatrix) : PD3DXVector2; stdcall; overload;
function D3DXVec2TransformNormal(out Out : TD3DXVector2; v : PD3DXVector2; m : PD3DXMatrix) : PD3DXVector2; stdcall; overload;
function D3DXVec2TransformNormal(Out : PD3DXVector2; var v : TD3DXVector2; m : PD3DXMatrix) : PD3DXVector2; stdcall; overload;
function D3DXVec2TransformNormal(out Out : TD3DXVector2; var v : TD3DXVector2; m : PD3DXMatrix) : PD3DXVector2; stdcall; overload;
function D3DXVec2TransformNormal(Out, v : PD3DXVector2; var m : TD3DXMatrix) : PD3DXVector2; stdcall; overload;
function D3DXVec2TransformNormal(out Out : TD3DXVector2; v : PD3DXVector2; var m : TD3DXMatrix) : PD3DXVector2; stdcall; overload;
function D3DXVec2TransformNormal(Out : PD3DXVector2; var v : TD3DXVector2; var m : TD3DXMatrix) : PD3DXVector2; stdcall; overload;
function D3DXVec2TransformNormal(out Out : TD3DXVector2; var v : TD3DXVector2; var m : TD3DXMatrix) : PD3DXVector2; stdcall; overload;

//--------------------------
// 3D Vector
//--------------------------

// inline

function D3DXVec3Length(var V : TD3DXVector3) : Single;

function D3DXVec3LengthSq(var V : TD3DXVector3) : Single;

function D3DXVec3Dot(var V1, V2 : TD3DXVector3) : Single;

function D3DXVec3Cross(out Out : TD3DXVector3; const V1, V2 : TD3DXVector3) : PD3DXVector3; overload;
function D3DXVec3Cross(Out : PD3DXVector3; const V1, V2 : TD3DXVector3) : PD3DXVector3; overload;

function D3DXVec3Add(out Out : TD3DXVector3; var V1, V2 : TD3DXVector3) : PD3DXVector3;

function D3DXVec3Subtract(out Out : TD3DXVector3; var V1, V2 : TD3DXVector3) : PD3DXVector3;

// Minimize each component.  x = min(x1, x2), y = min(y1, y2), ...
function D3DXVec3Minimize(out Out : TD3DXVector3; var V1, V2 : TD3DXVector3) : PD3DXVector3;

// Maximize each component.  x = max(x1, x2), y = max(y1, y2), ...
function D3DXVec3Maximize(out Out : TD3DXVector3; var V1, V2 : TD3DXVector3) : PD3DXVector3;

function D3DXVec3Scale(out Out : TD3DXVector3; var V : TD3DXVector3; s : Single) : PD3DXVector3;

// Linear interpolation. V1 + s(V2-V1)
function D3DXVec3Lerp(out Out : TD3DXVector3; var V1, V2 : TD3DXVector3; s : Single) : PD3DXVector3;

// non-inline

function D3DXVec3Normalize(Out, V : PD3DXVector3) : PD3DXVector3; stdcall; overload;
function D3DXVec3Normalize(out Out : TD3DXVector3; V : PD3DXVector3) : PD3DXVector3; stdcall; overload;
function D3DXVec3Normalize(Out : PD3DXVector3; var V : TD3DXVector3) : PD3DXVector3; stdcall; overload;
function D3DXVec3Normalize(out Out : TD3DXVector3; var V : TD3DXVector3) : PD3DXVector3; stdcall; overload;

// Hermite interpolation between position V1, tangent T1 (when s == 0)
// and position V2, tangent T2 (when s == 1).
function D3DXVec3Hermite(Out, V1, T1, V2, T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(out Out : TD3DXVector3; V1, T1, V2, T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(Out : PD3DXVector3; var V1 : TD3DXVector3; T1, V2, T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(out Out : TD3DXVector3; var V1 : TD3DXVector3; T1, V2, T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(Out, V1 : PD3DXVector3; var T1 : TD3DXVector3; V2, T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(out Out : TD3DXVector3; V1 : PD3DXVector3; var T1 : TD3DXVector3; V2, T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(Out : PD3DXVector3; var V1, T1 : TD3DXVector3; V2, T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(out Out : TD3DXVector3; var V1, T1 : TD3DXVector3; V2, T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(Out, V1, T1 : PD3DXVector3; var V2 : TD3DXVector3; T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(out Out : TD3DXVector3; V1, T1 : PD3DXVector3; var V2 : TD3DXVector3; T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(Out : PD3DXVector3; var V1 : TD3DXVector3; T1 : PD3DXVector3; var V2 : TD3DXVector3; T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(out Out : TD3DXVector3; var V1 : TD3DXVector3; T1 : PD3DXVector3; var V2 : TD3DXVector3; T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(Out, V1 : PD3DXVector3; var T1, V2 : TD3DXVector3; T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(out Out : TD3DXVector3; V1 : PD3DXVector3; var T1, V2 : TD3DXVector3; T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(Out : PD3DXVector3; var V1, T1, V2 : TD3DXVector3; T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(out Out : TD3DXVector3; var V1, T1, V2 : TD3DXVector3; T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(Out, V1, T1, V2 : PD3DXVector3; var T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(out Out : TD3DXVector3; V1, T1, V2 : PD3DXVector3; var T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(Out : PD3DXVector3; var V1 : TD3DXVector3; T1, V2 : PD3DXVector3; var T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(out Out : TD3DXVector3; var V1 : TD3DXVector3; T1, V2 : PD3DXVector3; var T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(Out, V1 : PD3DXVector3; var T1 : TD3DXVector3; V2 : PD3DXVector3; var T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(out Out : TD3DXVector3; V1 : PD3DXVector3; var T1 : TD3DXVector3; V2 : PD3DXVector3; var T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(Out : PD3DXVector3; var V1, T1 : TD3DXVector3; V2 : PD3DXVector3; var T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(out Out : TD3DXVector3; var V1, T1 : TD3DXVector3; V2 : PD3DXVector3; var T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(Out, V1, T1 : PD3DXVector3; var V2, T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(out Out : TD3DXVector3; V1, T1 : PD3DXVector3; var V2, T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(Out : PD3DXVector3; var V1 : TD3DXVector3; T1 : PD3DXVector3; var V2, T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(out Out : TD3DXVector3; var V1 : TD3DXVector3; T1 : PD3DXVector3; var V2, T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(Out, V1 : PD3DXVector3; var T1, V2, T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(out Out : TD3DXVector3; V1 : PD3DXVector3; var T1, V2, T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(Out : PD3DXVector3; var V1, T1, V2, T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3Hermite(out Out : TD3DXVector3; var V1, T1, V2, T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;

// CatmullRom interpolation between V1 (when s == 0) and V2 (when s == 1)
function D3DXVec3CatmullRom(Out, pV0, V1, V2, V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; pV0, V1, V2, V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(Out : PD3DXVector3; var pV0 : TD3DXVector3; V1, V2, V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; var pV0 : TD3DXVector3; V1, V2, V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(Out, pV0 : PD3DXVector3; var V1 : TD3DXVector3; V2, V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; pV0 : PD3DXVector3; var V1 : TD3DXVector3; V2, V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(Out : PD3DXVector3; var pV0, V1 : TD3DXVector3; V2, V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; var pV0, V1 : TD3DXVector3; V2, V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(Out, pV0, V1 : PD3DXVector3; var V2 : TD3DXVector3; V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; pV0, V1 : PD3DXVector3; var V2 : TD3DXVector3; V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(Out : PD3DXVector3; var pV0 : TD3DXVector3; V1 : PD3DXVector3; var V2 : TD3DXVector3; V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; var pV0 : TD3DXVector3; V1 : PD3DXVector3; var V2 : TD3DXVector3; V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(Out, pV0 : PD3DXVector3; var V1, V2 : TD3DXVector3; V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; pV0 : PD3DXVector3; var V1, V2 : TD3DXVector3; V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(Out : PD3DXVector3; var pV0, V1, V2 : TD3DXVector3; V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; var pV0, V1, V2 : TD3DXVector3; V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(Out, pV0, V1, V2 : PD3DXVector3; var V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; pV0, V1, V2 : PD3DXVector3; var V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(Out : PD3DXVector3; var pV0 : TD3DXVector3; V1, V2 : PD3DXVector3; var V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; var pV0 : TD3DXVector3; V1, V2 : PD3DXVector3; var V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(Out, pV0 : PD3DXVector3; var V1 : TD3DXVector3; V2 : PD3DXVector3; var V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; pV0 : PD3DXVector3; var V1 : TD3DXVector3; V2 : PD3DXVector3; var V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(Out : PD3DXVector3; var pV0, V1 : TD3DXVector3; V2 : PD3DXVector3; var V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; var pV0, V1 : TD3DXVector3; V2 : PD3DXVector3; var V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(Out, pV0, V1 : PD3DXVector3; var V2, V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; pV0, V1 : PD3DXVector3; var V2, V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(Out : PD3DXVector3; var pV0 : TD3DXVector3; V1 : PD3DXVector3; var V2, V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; var pV0 : TD3DXVector3; V1 : PD3DXVector3; var V2, V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(Out, pV0 : PD3DXVector3; var V1, V2, V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; pV0 : PD3DXVector3; var V1, V2, V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(Out : PD3DXVector3; var pV0, V1, V2, V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; var pV0, V1, V2, V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; overload;

// Barycentric coordinates.  V1 + f(V2-V1) + g(V3-V1)
function D3DXVec3BaryCentric(Out, V1, V2, V3 : PD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3BaryCentric(out Out : TD3DXVector3; V1, V2, V3 : PD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3BaryCentric(Out : PD3DXVector3; var V1 : TD3DXVector3; V2, V3 : PD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3BaryCentric(out Out : TD3DXVector3; var V1 : TD3DXVector3; V2, V3 : PD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3BaryCentric(Out, V1 : PD3DXVector3; var V2 : TD3DXVector3; V3 : PD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3BaryCentric(out Out : TD3DXVector3; V1 : PD3DXVector3; var V2 : TD3DXVector3; V3 : PD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3BaryCentric(Out : PD3DXVector3; var V1, V2 : TD3DXVector3; V3 : PD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3BaryCentric(out Out : TD3DXVector3; var V1, V2 : TD3DXVector3; V3 : PD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3BaryCentric(Out, V1, V2 : PD3DXVector3; var V3 : TD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3BaryCentric(out Out : TD3DXVector3; V1, V2 : PD3DXVector3; var V3 : TD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3BaryCentric(Out : PD3DXVector3; var V1 : TD3DXVector3; V2 : PD3DXVector3; var V3 : TD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3BaryCentric(out Out : TD3DXVector3; var V1 : TD3DXVector3; V2 : PD3DXVector3; var V3 : TD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3BaryCentric(Out, V1 : PD3DXVector3; var V2, V3 : TD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3BaryCentric(out Out : TD3DXVector3; V1 : PD3DXVector3; var V2, V3 : TD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3BaryCentric(Out : PD3DXVector3; var V1, V2, V3 : TD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; overload;
function D3DXVec3BaryCentric(out Out : TD3DXVector3; var V1, V2, V3 : TD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; overload;

// Transform (x, y, z, 1) by matrix.
function D3DXVec3Transform(Out : PD3DXVector4; V : PD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Transform(out Out : TD3DXVector4; V : PD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Transform(Out : PD3DXVector4; var V : TD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Transform(out Out : TD3DXVector4; var V : TD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Transform(Out : PD3DXVector4; V : PD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Transform(out Out : TD3DXVector4; V : PD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Transform(Out : PD3DXVector4; var V : TD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Transform(out Out : TD3DXVector4; var V : TD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; overload;

// Transform (x, y, z, 1) by matrix, project result back into w=1.
function D3DXVec3TransformCoord(Out, V : PD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3TransformCoord(out Out : TD3DXVector3; V : PD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3TransformCoord(Out : PD3DXVector3; var V : TD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3TransformCoord(out Out : TD3DXVector3; var V : TD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3TransformCoord(Out, V : PD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3TransformCoord(out Out : TD3DXVector3; V : PD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3TransformCoord(Out : PD3DXVector3; var V : TD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3TransformCoord(out Out : TD3DXVector3; var V : TD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; overload;

// Transform (x, y, z, 0) by matrix.  If you transforming a normal by a
// non-affine matrix, the matrix you pass to this function should be the
// transpose of the inverse of the matrix you would use to transform a coord.
function D3DXVec3TransformNormal(Out, V : PD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3TransformNormal(out Out : TD3DXVector3; V : PD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3TransformNormal(Out : PD3DXVector3; var V : TD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3TransformNormal(out Out : TD3DXVector3; var V : TD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3TransformNormal(Out, V : PD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3TransformNormal(out Out : TD3DXVector3; V : PD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3TransformNormal(Out : PD3DXVector3; var V : TD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3TransformNormal(out Out : TD3DXVector3; var V : TD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; overload;

// Project vector from object space into screen space
function D3DXVec3Project(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;

// Project vector from screen space into object space
function D3DXVec3Unproject(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; overload;

//--------------------------
// 4D Vector
//--------------------------

// inline

function D3DXVec4Length(var V : TD3DXVector4) : Single;

function D3DXVec4LengthSq(var V : TD3DXVector4) : Single;

function D3DXVec4Dot(var V1, V2 : TD3DXVector4) : Single;

function D3DXVec4Add(out Out : TD3DXVector4; var V1, V2 : TD3DXVector4) : PD3DXVector4;

function D3DXVec4Subtract(out Out : TD3DXVector4; var V1, V2 : TD3DXVector4) : PD3DXVector4;

// Minimize each component.  x = min(x1, x2), y = min(y1, y2), ...
function D3DXVec4Minimize(out Out : TD3DXVector4; var V1, V2 : TD3DXVector4) : PD3DXVector4;

// Maximize each component.  x = max(x1, x2), y = max(y1, y2), ...
function D3DXVec4Maximize(out Out : TD3DXVector4; var V1, V2 : TD3DXVector4) : PD3DXVector4;

function D3DXVec4Scale(out Out : TD3DXVector4; var V : TD3DXVector4; s : Single) : PD3DXVector4;

// Linear interpolation. V1 + s(V2-V1)
function D3DXVec4Lerp(out Out : TD3DXVector4; var V1, V2 : TD3DXVector4; s : Single) : PD3DXVector4;

// non-inline

// Cross-product in 4 dimensions.
function D3DXVec4Cross(Out, V1, V2, V3 : PD3DXVector4) : PD3DXVector4; stdcall; overload;
function D3DXVec4Cross(out Out : TD3DXVector4; V1, V2, V3 : PD3DXVector4) : PD3DXVector4; stdcall; overload;
function D3DXVec4Cross(Out : PD3DXVector4; var V1 : TD3DXVector4; V2, V3 : PD3DXVector4) : PD3DXVector4; stdcall; overload;
function D3DXVec4Cross(out Out : TD3DXVector4; var V1 : TD3DXVector4; V2, V3 : PD3DXVector4) : PD3DXVector4; stdcall; overload;
function D3DXVec4Cross(Out, V1 : PD3DXVector4; var V2 : TD3DXVector4; V3 : PD3DXVector4) : PD3DXVector4; stdcall; overload;
function D3DXVec4Cross(out Out : TD3DXVector4; V1 : PD3DXVector4; var V2 : TD3DXVector4; V3 : PD3DXVector4) : PD3DXVector4; stdcall; overload;
function D3DXVec4Cross(Out : PD3DXVector4; var V1, V2 : TD3DXVector4; V3 : PD3DXVector4) : PD3DXVector4; stdcall; overload;
function D3DXVec4Cross(out Out : TD3DXVector4; var V1, V2 : TD3DXVector4; V3 : PD3DXVector4) : PD3DXVector4; stdcall; overload;
function D3DXVec4Cross(Out, V1, V2 : PD3DXVector4; var V3 : TD3DXVector4) : PD3DXVector4; stdcall; overload;
function D3DXVec4Cross(out Out : TD3DXVector4; V1, V2 : PD3DXVector4; var V3 : TD3DXVector4) : PD3DXVector4; stdcall; overload;
function D3DXVec4Cross(Out : PD3DXVector4; var V1 : TD3DXVector4; V2 : PD3DXVector4; var V3 : TD3DXVector4) : PD3DXVector4; stdcall; overload;
function D3DXVec4Cross(out Out : TD3DXVector4; var V1 : TD3DXVector4; V2 : PD3DXVector4; var V3 : TD3DXVector4) : PD3DXVector4; stdcall; overload;
function D3DXVec4Cross(Out, V1 : PD3DXVector4; var V2, V3 : TD3DXVector4) : PD3DXVector4; stdcall; overload;
function D3DXVec4Cross(out Out : TD3DXVector4; V1 : PD3DXVector4; var V2, V3 : TD3DXVector4) : PD3DXVector4; stdcall; overload;
function D3DXVec4Cross(Out : PD3DXVector4; var V1, V2, V3 : TD3DXVector4) : PD3DXVector4; stdcall; overload;
function D3DXVec4Cross(out Out : TD3DXVector4; var V1, V2, V3 : TD3DXVector4) : PD3DXVector4; stdcall; overload;

function D3DXVec4Normalize(Out, V : PD3DXVector4) : PD3DXVector4; stdcall; overload;
function D3DXVec4Normalize(out Out : TD3DXVector4; V : PD3DXVector4) : PD3DXVector4; stdcall; overload;
function D3DXVec4Normalize(Out : PD3DXVector4; var V : TD3DXVector4) : PD3DXVector4; stdcall; overload;
function D3DXVec4Normalize(out Out : TD3DXVector4; var V : TD3DXVector4) : PD3DXVector4; stdcall; overload;

// Hermite interpolation between position V1, tangent T1 (when s == 0)
// and position V2, tangent T2 (when s == 1).
function D3DXVec4Hermite(Out, V1, T1, V2, T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(out Out : TD3DXVector4; V1, T1, V2, T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(Out : PD3DXVector4; var V1 : TD3DXVector4; T1, V2, T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(out Out : TD3DXVector4; var V1 : TD3DXVector4; T1, V2, T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(Out, V1 : PD3DXVector4; var T1 : TD3DXVector4; V2, T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(out Out : TD3DXVector4; V1 : PD3DXVector4; var T1 : TD3DXVector4; V2, T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(Out : PD3DXVector4; var V1, T1 : TD3DXVector4; V2, T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(out Out : TD3DXVector4; var V1, T1 : TD3DXVector4; V2, T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(Out, V1, T1 : PD3DXVector4; var V2 : TD3DXVector4; T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(out Out : TD3DXVector4; V1, T1 : PD3DXVector4; var V2 : TD3DXVector4; T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(Out : PD3DXVector4; var V1 : TD3DXVector4; T1 : PD3DXVector4; var V2 : TD3DXVector4; T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(out Out : TD3DXVector4; var V1 : TD3DXVector4; T1 : PD3DXVector4; var V2 : TD3DXVector4; T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(Out, V1 : PD3DXVector4; var T1, V2 : TD3DXVector4; T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(out Out : TD3DXVector4; V1 : PD3DXVector4; var T1, V2 : TD3DXVector4; T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(Out : PD3DXVector4; var V1, T1, V2 : TD3DXVector4; T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(out Out : TD3DXVector4; var V1, T1, V2 : TD3DXVector4; T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(Out, V1, T1, V2 : PD3DXVector4; var T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(out Out : TD3DXVector4; V1, T1, V2 : PD3DXVector4; var T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(Out : PD3DXVector4; var V1 : TD3DXVector4; T1, V2 : PD3DXVector4; var T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(out Out : TD3DXVector4; var V1 : TD3DXVector4; T1, V2 : PD3DXVector4; var T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(Out, V1 : PD3DXVector4; var T1 : TD3DXVector4; V2 : PD3DXVector4; var T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(out Out : TD3DXVector4; V1 : PD3DXVector4; var T1 : TD3DXVector4; V2 : PD3DXVector4; var T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(Out : PD3DXVector4; var V1, T1 : TD3DXVector4; V2 : PD3DXVector4; var T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(out Out : TD3DXVector4; var V1, T1 : TD3DXVector4; V2 : PD3DXVector4; var T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(Out, V1, T1 : PD3DXVector4; var V2, T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(out Out : TD3DXVector4; V1, T1 : PD3DXVector4; var V2, T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(Out : PD3DXVector4; var V1 : TD3DXVector4; T1 : PD3DXVector4; var V2, T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(out Out : TD3DXVector4; var V1 : TD3DXVector4; T1 : PD3DXVector4; var V2, T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(Out, V1 : PD3DXVector4; var T1, V2, T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(out Out : TD3DXVector4; V1 : PD3DXVector4; var T1, V2, T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(Out : PD3DXVector4; var V1, T1, V2, T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4Hermite(out Out : TD3DXVector4; var V1, T1, V2, T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;

// CatmullRom interpolation between V1 (when s == 0) and V2 (when s == 1)
function D3DXVec4CatmullRom(Out, pV0, V1, V2, V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; pV0, V1, V2, V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(Out : PD3DXVector4; var pV0 : TD3DXVector4; V1, V2, V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; var pV0 : TD3DXVector4; V1, V2, V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(Out, pV0 : PD3DXVector4; var V1 : TD3DXVector4; V2, V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; pV0 : PD3DXVector4; var V1 : TD3DXVector4; V2, V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(Out : PD3DXVector4; var pV0, V1 : TD3DXVector4; V2, V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; var pV0, V1 : TD3DXVector4; V2, V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(Out, pV0, V1 : PD3DXVector4; var V2 : TD3DXVector4; V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; pV0, V1 : PD3DXVector4; var V2 : TD3DXVector4; V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(Out : PD3DXVector4; var pV0 : TD3DXVector4; V1 : PD3DXVector4; var V2 : TD3DXVector4; V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; var pV0 : TD3DXVector4; V1 : PD3DXVector4; var V2 : TD3DXVector4; V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(Out, pV0 : PD3DXVector4; var V1, V2 : TD3DXVector4; V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; pV0 : PD3DXVector4; var V1, V2 : TD3DXVector4; V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(Out : PD3DXVector4; var pV0, V1, V2 : TD3DXVector4; V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; var pV0, V1, V2 : TD3DXVector4; V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(Out, pV0, V1, V2 : PD3DXVector4; var V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; pV0, V1, V2 : PD3DXVector4; var V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(Out : PD3DXVector4; var pV0 : TD3DXVector4; V1, V2 : PD3DXVector4; var V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; var pV0 : TD3DXVector4; V1, V2 : PD3DXVector4; var V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(Out, pV0 : PD3DXVector4; var V1 : TD3DXVector4; V2 : PD3DXVector4; var V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; pV0 : PD3DXVector4; var V1 : TD3DXVector4; V2 : PD3DXVector4; var V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(Out : PD3DXVector4; var pV0, V1 : TD3DXVector4; V2 : PD3DXVector4; var V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; var pV0, V1 : TD3DXVector4; V2 : PD3DXVector4; var V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(Out, pV0, V1 : PD3DXVector4; var V2, V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; pV0, V1 : PD3DXVector4; var V2, V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(Out : PD3DXVector4; var pV0 : TD3DXVector4; V1 : PD3DXVector4; var V2, V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; var pV0 : TD3DXVector4; V1 : PD3DXVector4; var V2, V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(Out, pV0 : PD3DXVector4; var V1, V2, V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; pV0 : PD3DXVector4; var V1, V2, V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(Out : PD3DXVector4; var pV0, V1, V2, V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; var pV0, V1, V2, V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; overload;

// Barycentric coordinates.  V1 + f(V2-V1) + g(V3-V1)
function D3DXVec4BaryCentric(Out, V1, V2, V3 : PD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4BaryCentric(out Out : TD3DXVector4; V1, V2, V3 : PD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4BaryCentric(Out : PD3DXVector4; var V1 : TD3DXVector4; V2, V3 : PD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4BaryCentric(out Out : TD3DXVector4; var V1 : TD3DXVector4; V2, V3 : PD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4BaryCentric(Out, V1 : PD3DXVector4; var V2 : TD3DXVector4; V3 : PD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4BaryCentric(out Out : TD3DXVector4; V1 : PD3DXVector4; var V2 : TD3DXVector4; V3 : PD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4BaryCentric(Out : PD3DXVector4; var V1, V2 : TD3DXVector4; V3 : PD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4BaryCentric(out Out : TD3DXVector4; var V1, V2 : TD3DXVector4; V3 : PD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4BaryCentric(Out, V1, V2 : PD3DXVector4; var V3 : TD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4BaryCentric(out Out : TD3DXVector4; V1, V2 : PD3DXVector4; var V3 : TD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4BaryCentric(Out : PD3DXVector4; var V1 : TD3DXVector4; V2 : PD3DXVector4; var V3 : TD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4BaryCentric(out Out : TD3DXVector4; var V1 : TD3DXVector4; V2 : PD3DXVector4; var V3 : TD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4BaryCentric(Out, V1 : PD3DXVector4; var V2, V3 : TD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4BaryCentric(out Out : TD3DXVector4; V1 : PD3DXVector4; var V2, V3 : TD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4BaryCentric(Out : PD3DXVector4; var V1, V2, V3 : TD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; overload;
function D3DXVec4BaryCentric(out Out : TD3DXVector4; var V1, V2, V3 : TD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; overload;

// Transform vector by matrix.
function D3DXVec4Transform(Out, V : PD3DXVector4; M : PD3DXMatrix) : PD3DXVector4; stdcall; overload;
function D3DXVec4Transform(out Out : TD3DXVector4; V : PD3DXVector4; M : PD3DXMatrix) : PD3DXVector4; stdcall; overload;
function D3DXVec4Transform(Out : PD3DXVector4; var V : TD3DXVector4; M : PD3DXMatrix) : PD3DXVector4; stdcall; overload;
function D3DXVec4Transform(out Out : TD3DXVector4; var V : TD3DXVector4; M : PD3DXMatrix) : PD3DXVector4; stdcall; overload;
function D3DXVec4Transform(Out, V : PD3DXVector4; var M : TD3DXMatrix) : PD3DXVector4; stdcall; overload;
function D3DXVec4Transform(out Out : TD3DXVector4; V : PD3DXVector4; var M : TD3DXMatrix) : PD3DXVector4; stdcall; overload;
function D3DXVec4Transform(Out : PD3DXVector4; var V : TD3DXVector4; var M : TD3DXMatrix) : PD3DXVector4; stdcall; overload;
function D3DXVec4Transform(out Out : TD3DXVector4; var V : TD3DXVector4; var M : TD3DXMatrix) : PD3DXVector4; stdcall; overload;

//--------------------------
// 4D Matrix
//--------------------------

// inline

function D3DXMatrixIdentity(out Out : TD3DXMatrix) : PD3DXMatrix;

function D3DXMatrixIsIdentity(var M : TD3DXMatrix) : Boolean;


// non-inline

function D3DXMatrixfDeterminant(M : PD3DXMatrix) : Single; stdcall; overload;
function D3DXMatrixfDeterminant(var M : TD3DXMatrix) : Single; stdcall; overload;

function D3DXMatrixTranspose(Out, M : PD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTranspose(out Out : TD3DXMatrix; M : PD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTranspose(Out : PD3DXMatrix; var M : TD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTranspose(out Out : TD3DXMatrix; var M : TD3DXMatrix) : PD3DXMatrix; stdcall; overload;

// Matrix multiplication.  The result represents the transformation M2
// followed by the transformation M1.  (Out = M1 * M2)
function D3DXMatrixMultiply(Out, M1, M2 : PD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixMultiply(out Out : TD3DXMatrix; M1, M2 : PD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixMultiply(Out : PD3DXMatrix; var M1 : TD3DXMatrix; M2 : PD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixMultiply(out Out : TD3DXMatrix; var M1 : TD3DXMatrix; M2 : PD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixMultiply(Out, M1 : PD3DXMatrix; var M2 : TD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixMultiply(out Out : TD3DXMatrix; M1 : PD3DXMatrix; var M2 : TD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixMultiply(Out : PD3DXMatrix; var M1, M2 : TD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixMultiply(out Out : TD3DXMatrix; var M1, M2 : TD3DXMatrix) : PD3DXMatrix; stdcall; overload;

// Matrix multiplication, followed by a transpose. (Out = T(M1 * M2))
function D3DXMatrixMultiplyTranspose(Out, M1, M2 : PD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixMultiplyTranspose(out Out : TD3DXMatrix; M1, M2 : PD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixMultiplyTranspose(Out : PD3DXMatrix; var M1 : TD3DXMatrix; M2 : PD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixMultiplyTranspose(out Out : TD3DXMatrix; var M1 : TD3DXMatrix; M2 : PD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixMultiplyTranspose(Out, M1 : PD3DXMatrix; var M2 : TD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixMultiplyTranspose(out Out : TD3DXMatrix; M1 : PD3DXMatrix; var M2 : TD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixMultiplyTranspose(Out : PD3DXMatrix; var M1, M2 : TD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixMultiplyTranspose(out Out : TD3DXMatrix; var M1, M2 : TD3DXMatrix) : PD3DXMatrix; stdcall; overload;

// Calculate inverse of matrix.  Inversion my fail, in which case NULL will
// be returned.  The determinant of M is also returned it pfDeterminant
// is non-NULL.
function D3DXMatrixInverse(Out : PD3DXMatrix; pDeterminant : PSingle; M : PD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixInverse(out Out : TD3DXMatrix; pDeterminant : PSingle; M : PD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixInverse(Out : PD3DXMatrix; var pDeterminant : Single; M : PD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixInverse(out Out : TD3DXMatrix; var pDeterminant : Single; M : PD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixInverse(Out : PD3DXMatrix; pDeterminant : PSingle; var M : TD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixInverse(out Out : TD3DXMatrix; pDeterminant : PSingle; var M : TD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixInverse(Out : PD3DXMatrix; var pDeterminant : Single; var M : TD3DXMatrix) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixInverse(out Out : TD3DXMatrix; var pDeterminant : Single; var M : TD3DXMatrix) : PD3DXMatrix; stdcall; overload;

// Build a matrix which scales by (sx, sy, sz)
function D3DXMatrixScaling(Out : PD3DXMatrix; sx, sy, sz : Single) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixScaling(out Out : TD3DXMatrix; sx, sy, sz : Single) : PD3DXMatrix; stdcall; overload;

// Build a matrix which translates by (x, y, z)
function D3DXMatrixTranslation(Out : PD3DXMatrix; x, y, z : Single) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTranslation(out Out : TD3DXMatrix; x, y, z : Single) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTranslation(Out : PD3DXMatrix; xyz : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTranslation(out Out : TD3DXMatrix; xyz : TD3DXVector3) : PD3DXMatrix; stdcall; overload;

// Build a matrix which rotates around the X axis
function D3DXMatrixRotationX(Out : PD3DXMatrix; Angle : Single) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixRotationX(out Out : TD3DXMatrix; Angle : Single) : PD3DXMatrix; stdcall; overload;

// Build a matrix which rotates around the Y axis
function D3DXMatrixRotationY(Out : PD3DXMatrix; Angle : Single) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixRotationY(out Out : TD3DXMatrix; Angle : Single) : PD3DXMatrix; stdcall; overload;

// Build a matrix which rotates around the Z axis
function D3DXMatrixRotationZ(Out : PD3DXMatrix; Angle : Single) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixRotationZ(out Out : TD3DXMatrix; Angle : Single) : PD3DXMatrix; stdcall; overload;

// Build a matrix which rotates around an arbitrary axis
function D3DXMatrixRotationAxis(Out : PD3DXMatrix; V : PD3DXVector3; Angle : Single) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixRotationAxis(out Out : TD3DXMatrix; V : PD3DXVector3; Angle : Single) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixRotationAxis(Out : PD3DXMatrix; var V : TD3DXVector3; Angle : Single) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixRotationAxis(out Out : TD3DXMatrix; var V : TD3DXVector3; Angle : Single) : PD3DXMatrix; stdcall; overload;

// Build a matrix from a quaternion
function D3DXMatrixRotationQuaternion(Out : PD3DXMatrix; Q : PD3DXQuaternion) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixRotationQuaternion(out Out : TD3DXMatrix; Q : PD3DXQuaternion) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixRotationQuaternion(Out : PD3DXMatrix; var Q : TD3DXQuaternion) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixRotationQuaternion(out Out : TD3DXMatrix; var Q : TD3DXQuaternion) : PD3DXMatrix; stdcall; overload;

// Yaw around the Y axis, a pitch around the X axis,
// and a roll around the Z axis.
function D3DXMatrixRotationYawPitchRoll(Out : PD3DXMatrix; Yaw, Pitch, Roll : Single) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixRotationYawPitchRoll(out Out : TD3DXMatrix; Yaw, Pitch, Roll : Single) : PD3DXMatrix; stdcall; overload;

// Build transformation matrix.  NULL arguments are treated as identity.
// Mout = Msc-1 * Msr-1 * Ms * Msr * Msc * Mrc-1 * Mr * Mrc * Mt
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;

// Build affine transformation matrix.  NULL arguments are treated as identity.
// Mout = Ms * Mrc-1 * Mr * Mrc * Mt
function D3DXMatrixAffineTransformation(Out : PD3DXMatrix; Scaling : Single; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixAffineTransformation(out Out : TD3DXMatrix; Scaling : Single; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixAffineTransformation(Out : PD3DXMatrix; Scaling : Single; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixAffineTransformation(out Out : TD3DXMatrix; Scaling : Single; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixAffineTransformation(Out : PD3DXMatrix; Scaling : Single; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixAffineTransformation(out Out : TD3DXMatrix; Scaling : Single; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixAffineTransformation(Out : PD3DXMatrix; Scaling : Single; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixAffineTransformation(out Out : TD3DXMatrix; Scaling : Single; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixAffineTransformation(Out : PD3DXMatrix; Scaling : Single; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixAffineTransformation(out Out : TD3DXMatrix; Scaling : Single; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixAffineTransformation(Out : PD3DXMatrix; Scaling : Single; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixAffineTransformation(out Out : TD3DXMatrix; Scaling : Single; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixAffineTransformation(Out : PD3DXMatrix; Scaling : Single; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixAffineTransformation(out Out : TD3DXMatrix; Scaling : Single; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixAffineTransformation(Out : PD3DXMatrix; Scaling : Single; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixAffineTransformation(out Out : TD3DXMatrix; Scaling : Single; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; overload;

// Build a lookat matrix. (right-handed)
function D3DXMatrixLookAtRH(Out : PD3DXMatrix; pEye, pAt, pUp : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtRH(out Out : TD3DXMatrix; pEye, pAt, pUp : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtRH(Out : PD3DXMatrix; var pEye : TD3DXVector3; pAt, pUp : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtRH(out Out : TD3DXMatrix; var pEye : TD3DXVector3; pAt, pUp : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtRH(Out : PD3DXMatrix; pEye : PD3DXVector3; var pAt : TD3DXVector3; pUp : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtRH(out Out : TD3DXMatrix; pEye : PD3DXVector3; var pAt : TD3DXVector3; pUp : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtRH(Out : PD3DXMatrix; var pEye, pAt : TD3DXVector3; pUp : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtRH(out Out : TD3DXMatrix; var pEye, pAt : TD3DXVector3; pUp : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtRH(Out : PD3DXMatrix; pEye, pAt : PD3DXVector3; var pUp : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtRH(out Out : TD3DXMatrix; pEye, pAt : PD3DXVector3; var pUp : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtRH(Out : PD3DXMatrix; var pEye : TD3DXVector3; pAt : PD3DXVector3; var pUp : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtRH(out Out : TD3DXMatrix; var pEye : TD3DXVector3; pAt : PD3DXVector3; var pUp : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtRH(Out : PD3DXMatrix; pEye : PD3DXVector3; var pAt, pUp : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtRH(out Out : TD3DXMatrix; pEye : PD3DXVector3; var pAt, pUp : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtRH(Out : PD3DXMatrix; var pEye, pAt, pUp : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtRH(out Out : TD3DXMatrix; var pEye, pAt, pUp : TD3DXVector3) : PD3DXMatrix; stdcall; overload;

// Build a lookat matrix. (left-handed)
function D3DXMatrixLookAtLH(Out : PD3DXMatrix; pEye, pAt, pUp : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtLH(out Out : TD3DXMatrix; pEye, pAt, pUp : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtLH(Out : PD3DXMatrix; var pEye : TD3DXVector3; pAt, pUp : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtLH(out Out : TD3DXMatrix; var pEye : TD3DXVector3; pAt, pUp : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtLH(Out : PD3DXMatrix; pEye : PD3DXVector3; var pAt : TD3DXVector3; pUp : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtLH(out Out : TD3DXMatrix; pEye : PD3DXVector3; var pAt : TD3DXVector3; pUp : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtLH(Out : PD3DXMatrix; var pEye, pAt : TD3DXVector3; pUp : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtLH(out Out : TD3DXMatrix; var pEye, pAt : TD3DXVector3; pUp : PD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtLH(Out : PD3DXMatrix; pEye, pAt : PD3DXVector3; var pUp : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtLH(out Out : TD3DXMatrix; pEye, pAt : PD3DXVector3; var pUp : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtLH(Out : PD3DXMatrix; var pEye : TD3DXVector3; pAt : PD3DXVector3; var pUp : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtLH(out Out : TD3DXMatrix; var pEye : TD3DXVector3; pAt : PD3DXVector3; var pUp : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtLH(Out : PD3DXMatrix; pEye : PD3DXVector3; var pAt, pUp : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtLH(out Out : TD3DXMatrix; pEye : PD3DXVector3; var pAt, pUp : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtLH(Out : PD3DXMatrix; var pEye, pAt, pUp : TD3DXVector3) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixLookAtLH(out Out : TD3DXMatrix; var pEye, pAt, pUp : TD3DXVector3) : PD3DXMatrix; stdcall; overload;

// Build a perspective projection matrix. (right-handed)
function D3DXMatrixPerspectiveRH(Out : PD3DXMatrix; w, h, zn, zf : Single) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixPerspectiveRH(out Out : TD3DXMatrix; w, h, zn, zf : Single) : PD3DXMatrix; stdcall; overload;

// Build a perspective projection matrix. (left-handed)
function D3DXMatrixPerspectiveLH(Out : PD3DXMatrix; w, h, zn, zf : Single) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixPerspectiveLH(out Out : TD3DXMatrix; w, h, zn, zf : Single) : PD3DXMatrix; stdcall; overload;

// Build a perspective projection matrix. (right-handed)
function D3DXMatrixPerspectiveFovRH(Out : PD3DXMatrix; fovy, Aspect, zn, zf : Single) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixPerspectiveFovRH(out Out : TD3DXMatrix; fovy, Aspect, zn, zf : Single) : PD3DXMatrix; stdcall; overload;

// Build a perspective projection matrix. (left-handed)
function D3DXMatrixPerspectiveFovLH(Out : PD3DXMatrix; fovy, Aspect, zn, zf : Single) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixPerspectiveFovLH(out Out : TD3DXMatrix; fovy, Aspect, zn, zf : Single) : PD3DXMatrix; stdcall; overload;

// Build a perspective projection matrix. (right-handed)
function D3DXMatrixPerspectiveOffCenterRH(Out : PD3DXMatrix; l, r, b, t, zn, zf : Single) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixPerspectiveOffCenterRH(out Out : TD3DXMatrix; l, r, b, t, zn, zf : Single) : PD3DXMatrix; stdcall; overload;

// Build a perspective projection matrix. (left-handed)
function D3DXMatrixPerspectiveOffCenterLH(Out : PD3DXMatrix; l, r, b, t, zn, zf : Single) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixPerspectiveOffCenterLH(out Out : TD3DXMatrix; l, r, b, t, zn, zf : Single) : PD3DXMatrix; stdcall; overload;

// Build an ortho projection matrix. (right-handed)
function D3DXMatrixOrthoRH(Out : PD3DXMatrix; w, h, zn, zf : Single) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixOrthoRH(out Out : TD3DXMatrix; w, h, zn, zf : Single) : PD3DXMatrix; stdcall; overload;

// Build an ortho projection matrix. (left-handed)
function D3DXMatrixOrthoLH(Out : PD3DXMatrix; w, h, zn, zf : Single) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixOrthoLH(out Out : TD3DXMatrix; w, h, zn, zf : Single) : PD3DXMatrix; stdcall; overload;

// Build an ortho projection matrix. (right-handed)
function D3DXMatrixOrthoOffCenterRH(Out : PD3DXMatrix; l, r, b, t, zn, zf : Single) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixOrthoOffCenterRH(out Out : TD3DXMatrix; l, r, b, t, zn, zf : Single) : PD3DXMatrix; stdcall; overload;

// Build an ortho projection matrix. (left-handed)
function D3DXMatrixOrthoOffCenterLH(Out : PD3DXMatrix; l, r, b, t, zn, zf : Single) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixOrthoOffCenterLH(out Out : TD3DXMatrix; l, r, b, t, zn, zf : Single) : PD3DXMatrix; stdcall; overload;

// Build a matrix which flattens geometry into a plane, as if casting
// a shadow from a light.
function D3DXMatrixShadow(Out : PD3DXMatrix; pLight : PD3DXVector4; Plane : PD3DXPlane) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixShadow(out Out : TD3DXMatrix; pLight : PD3DXVector4; Plane : PD3DXPlane) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixShadow(Out : PD3DXMatrix; var pLight : TD3DXVector4; Plane : PD3DXPlane) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixShadow(out Out : TD3DXMatrix; var pLight : TD3DXVector4; Plane : PD3DXPlane) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixShadow(Out : PD3DXMatrix; pLight : PD3DXVector4; var Plane : TD3DXPlane) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixShadow(out Out : TD3DXMatrix; pLight : PD3DXVector4; var Plane : TD3DXPlane) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixShadow(Out : PD3DXMatrix; var pLight : TD3DXVector4; var Plane : TD3DXPlane) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixShadow(out Out : TD3DXMatrix; var pLight : TD3DXVector4; var Plane : TD3DXPlane) : PD3DXMatrix; stdcall; overload;

// Build a matrix which reflects the coordinate system about a plane
function D3DXMatrixReflect(Out : PD3DXMatrix; Plane : PD3DXPlane) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixReflect(out Out : TD3DXMatrix; Plane : PD3DXPlane) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixReflect(Out : PD3DXMatrix; var Plane : TD3DXPlane) : PD3DXMatrix; stdcall; overload;
function D3DXMatrixReflect(out Out : TD3DXMatrix; var Plane : TD3DXPlane) : PD3DXMatrix; stdcall; overload;

//--------------------------
// Quaternion
//--------------------------

// inline

function D3DXQuaternionLength(var Q : TD3DXQuaternion) : Single;

// Length squared, or "norm"
function D3DXQuaternionLengthSq(var Q : TD3DXQuaternion) : Single;

function D3DXQuaternionDot(var Q1, Q2 : TD3DXQuaternion) : Single;

// (0, 0, 0, 1)
function D3DXQuaternionIdentity(out Out : TD3DXQuaternion) : PD3DXQuaternion;

function D3DXQuaternionIsIdentity(var Q : TD3DXQuaternion) : Boolean;

// (-x, -y, -z, w)
function D3DXQuaternionConjugate(out Out : TD3DXQuaternion; var Q : TD3DXQuaternion): PD3DXQuaternion;

// non-inline

// Compute a quaternin's axis and angle of rotation. Expects unit quaternions.
procedure D3DXQuaternionToAxisAngle(Q : PD3DXQuaternion; pAxis : PD3DXVector3; pAngle : PSingle); stdcall; overload;
procedure D3DXQuaternionToAxisAngle(var Q : TD3DXQuaternion; pAxis : PD3DXVector3; pAngle : PSingle); stdcall; overload;
procedure D3DXQuaternionToAxisAngle(Q : PD3DXQuaternion; var pAxis : TD3DXVector3; pAngle : PSingle); stdcall; overload;
procedure D3DXQuaternionToAxisAngle(var Q : TD3DXQuaternion; var pAxis : TD3DXVector3; pAngle : PSingle); stdcall; overload;
procedure D3DXQuaternionToAxisAngle(Q : PD3DXQuaternion; pAxis : PD3DXVector3; var pAngle : Single); stdcall; overload;
procedure D3DXQuaternionToAxisAngle(var Q : TD3DXQuaternion; pAxis : PD3DXVector3; var pAngle : Single); stdcall; overload;
procedure D3DXQuaternionToAxisAngle(Q : PD3DXQuaternion; var pAxis : TD3DXVector3; var pAngle : Single); stdcall; overload;
procedure D3DXQuaternionToAxisAngle(var Q : TD3DXQuaternion; var pAxis : TD3DXVector3; var pAngle : Single); stdcall; overload;

// Build a quaternion from a rotation matrix.
function D3DXQuaternionRotationMatrix(Out : PD3DXQuaternion; M : PD3DXMatrix) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionRotationMatrix(out Out : TD3DXQuaternion; M : PD3DXMatrix) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionRotationMatrix(Out : PD3DXQuaternion; var M : TD3DXMatrix) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionRotationMatrix(out Out : TD3DXQuaternion; var M : TD3DXMatrix) : PD3DXQuaternion; stdcall; overload;

// Rotation about arbitrary axis.
function D3DXQuaternionRotationAxis(Out : PD3DXQuaternion; V : PD3DXVector3; Angle : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionRotationAxis(out Out : TD3DXQuaternion; V : PD3DXVector3; Angle : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionRotationAxis(Out : PD3DXQuaternion; var V : TD3DXVector3; Angle : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionRotationAxis(out Out : TD3DXQuaternion; var V : TD3DXVector3; Angle : Single) : PD3DXQuaternion; stdcall; overload;

// Yaw around the Y axis, a pitch around the X axis,
// and a roll around the Z axis.
function D3DXQuaternionRotationYawPitchRoll(Out : PD3DXQuaternion; Yaw, Pitch, Roll : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionRotationYawPitchRoll(out Out : TD3DXQuaternion; Yaw, Pitch, Roll : Single) : PD3DXQuaternion; stdcall; overload;

// Quaternion multiplication.  The result represents the rotation Q2
// followed by the rotation Q1.  (Out = Q2 * Q1)
function D3DXQuaternionMultiply(Out, Q1, Q2 : PD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionMultiply(out Out : TD3DXQuaternion; Q1, Q2 : PD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionMultiply(Out : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionMultiply(out Out : TD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionMultiply(Out, Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionMultiply(out Out : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionMultiply(Out : PD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionMultiply(out Out : TD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;

function D3DXQuaternionNormalize(Out, Q : PD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionNormalize(out Out : TD3DXQuaternion; Q : PD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionNormalize(Out : PD3DXQuaternion; var Q : TD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionNormalize(out Out : TD3DXQuaternion; var Q : TD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;

// Conjugate and re-norm
function D3DXQuaternionInverse(Out, Q : PD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionInverse(out Out : TD3DXQuaternion; Q : PD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionInverse(Out : PD3DXQuaternion; var Q : TD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionInverse(out Out : TD3DXQuaternion; var Q : TD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;

// Expects unit quaternions.
// if q = (cos(theta), sin(theta) * v); ln(q) = (0, theta * v)
function D3DXQuaternionLn(Out, Q : PD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionLn(out Out : TD3DXQuaternion; Q : PD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionLn(Out : PD3DXQuaternion; var Q : TD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionLn(out Out : TD3DXQuaternion; var Q : TD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;

// Expects pure quaternions. (w == 0)  w is ignored in calculation.
// if q = (0, theta * v); exp(q) = (cos(theta), sin(theta) * v)
function D3DXQuaternionExp(Out, Q : PD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionExp(out Out : TD3DXQuaternion; Q : PD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionExp(Out : PD3DXQuaternion; var Q : TD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionExp(out Out : TD3DXQuaternion; var Q : TD3DXQuaternion) : PD3DXQuaternion; stdcall; overload;

// Spherical linear interpolation between Q1 (t == 0) and Q2 (t == 1).
// Expects unit quaternions.
function D3DXQuaternionSlerp(Out, Q1, Q2 : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSlerp(out Out : TD3DXQuaternion; Q1, Q2 : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSlerp(Out : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSlerp(out Out : TD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSlerp(Out, Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSlerp(out Out : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSlerp(Out : PD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSlerp(out Out : TD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;

// Spherical quadrangle interpolation.
// Slerp(Slerp(Q1, C, t), Slerp(A, B, t), 2t(1-t))
function D3DXQuaternionSquad(Out, Q1, pA, pB, C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; Q1, pA, pB, C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(Out : PD3DXQuaternion; var Q1 : TD3DXQuaternion; pA, pB, C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; var Q1 : TD3DXQuaternion; pA, pB, C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(Out, Q1 : PD3DXQuaternion; var pA : TD3DXQuaternion; pB, C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; Q1 : PD3DXQuaternion; var pA : TD3DXQuaternion; pB, C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(Out : PD3DXQuaternion; var Q1, pA : TD3DXQuaternion; pB, C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; var Q1, pA : TD3DXQuaternion; pB, C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(Out, Q1, pA : PD3DXQuaternion; var pB : TD3DXQuaternion; C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; Q1, pA : PD3DXQuaternion; var pB : TD3DXQuaternion; C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(Out : PD3DXQuaternion; var Q1 : TD3DXQuaternion; pA : PD3DXQuaternion; var pB : TD3DXQuaternion; C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; var Q1 : TD3DXQuaternion; pA : PD3DXQuaternion; var pB : TD3DXQuaternion; C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(Out, Q1 : PD3DXQuaternion; var pA, pB : TD3DXQuaternion; C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; Q1 : PD3DXQuaternion; var pA, pB : TD3DXQuaternion; C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(Out : PD3DXQuaternion; var Q1, pA, pB : TD3DXQuaternion; C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; var Q1, pA, pB : TD3DXQuaternion; C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(Out, Q1, pA, pB : PD3DXQuaternion; var C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; Q1, pA, pB : PD3DXQuaternion; var C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(Out : PD3DXQuaternion; var Q1 : TD3DXQuaternion; pA, pB : PD3DXQuaternion; var C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; var Q1 : TD3DXQuaternion; pA, pB : PD3DXQuaternion; var C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(Out, Q1 : PD3DXQuaternion; var pA : TD3DXQuaternion; pB : PD3DXQuaternion; var C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; Q1 : PD3DXQuaternion; var pA : TD3DXQuaternion; pB : PD3DXQuaternion; var C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(Out : PD3DXQuaternion; var Q1, pA : TD3DXQuaternion; pB : PD3DXQuaternion; var C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; var Q1, pA : TD3DXQuaternion; pB : PD3DXQuaternion; var C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(Out, Q1, pA : PD3DXQuaternion; var pB, C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; Q1, pA : PD3DXQuaternion; var pB, C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(Out : PD3DXQuaternion; var Q1 : TD3DXQuaternion; pA : PD3DXQuaternion; var pB, C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; var Q1 : TD3DXQuaternion; pA : PD3DXQuaternion; var pB, C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(Out, Q1 : PD3DXQuaternion; var pA, pB, C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; Q1 : PD3DXQuaternion; var pA, pB, C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(Out : PD3DXQuaternion; var Q1, pA, pB, C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; var Q1, pA, pB, C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; overload;

// Setup control points for spherical quadrangle interpolation
// from Q1 to Q2.  The control points are chosen in such a way
// to ensure the continuity of tangents with adjacent segments.
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut, Q0, Q1, Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut, Q0, Q1, Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut, Q0, Q1, Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut, Q0, Q1, Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0, Q1, Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0, Q1, Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; Q0, Q1, Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; Q0, Q1, Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut, Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut, Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut, Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut, Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut : PD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut : PD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut, Q0, Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut, Q0, Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut, Q0, Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut, Q0, Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0, Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0, Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; Q0, Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; Q0, Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut, Q0 : PD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut, Q0 : PD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut, Q0 : PD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut, Q0 : PD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut : PD3DXQuaternion; var Q0, Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut : PD3DXQuaternion; var Q0, Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0, Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0, Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0, Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0, Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; var Q0, Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; var Q0, Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut, Q0, Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut, Q0, Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut, Q0, Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut, Q0, Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0, Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0, Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; Q0, Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; Q0, Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut, Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut, Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut, Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut, Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut : PD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut : PD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut, Q0, Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut, Q0, Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut, Q0, Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut, Q0, Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0, Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0, Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; Q0, Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; Q0, Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut, Q0 : PD3DXQuaternion; var Q1, Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut, Q0 : PD3DXQuaternion; var Q1, Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut, Q0 : PD3DXQuaternion; var Q1, Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut, Q0 : PD3DXQuaternion; var Q1, Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1, Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1, Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1, Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1, Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut : PD3DXQuaternion; var Q0, Q1, Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut : PD3DXQuaternion; var Q0, Q1, Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0, Q1, Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0, Q1, Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0, Q1, Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0, Q1, Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; var Q0, Q1, Q2, Q3 : TD3DXQuaternion); stdcall; overload;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; var Q0, Q1, Q2, Q3 : TD3DXQuaternion); stdcall; overload;

// Barycentric interpolation.
// Slerp(Slerp(Q1, Q2, f+g), Slerp(Q1, Q3, f+g), g/(f+g))
function D3DXQuaternionBaryCentric(Out, Q1, Q2, Q3 : PD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionBaryCentric(out Out : TD3DXQuaternion; Q1, Q2, Q3 : PD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionBaryCentric(Out : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionBaryCentric(out Out : TD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionBaryCentric(Out, Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionBaryCentric(out Out : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionBaryCentric(Out : PD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionBaryCentric(out Out : TD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionBaryCentric(Out, Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionBaryCentric(out Out : TD3DXQuaternion; Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionBaryCentric(Out : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionBaryCentric(out Out : TD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionBaryCentric(Out, Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionBaryCentric(out Out : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionBaryCentric(Out : PD3DXQuaternion; var Q1, Q2, Q3 : TD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; overload;
function D3DXQuaternionBaryCentric(out Out : TD3DXQuaternion; var Q1, Q2, Q3 : TD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; overload;

//--------------------------
// Plane
//--------------------------

// inline

// ax + by + cz + dw
function D3DXPlaneDot(var P : TD3DXPlane; var V : TD3DXVector4) : Single;

// ax + by + cz + d
function D3DXPlaneDotCoord(var P : TD3DXPlane; var V : TD3DXVector3) : Single;

// ax + by + cz
function D3DXPlaneDotNormal(var P : TD3DXPlane; var V : TD3DXVector3) : Single;

// non-inline

// Normalize plane (so that |a,b,c| == 1)
function D3DXPlaneNormalize(Out, P : PD3DXPlane) : PD3DXPlane; stdcall; overload;
function D3DXPlaneNormalize(out Out : TD3DXPlane; P : PD3DXPlane) : PD3DXPlane; stdcall; overload;
function D3DXPlaneNormalize(Out : PD3DXPlane; var P : TD3DXPlane) : PD3DXPlane; stdcall; overload;
function D3DXPlaneNormalize(out Out : TD3DXPlane; var P : TD3DXPlane) : PD3DXPlane; stdcall; overload;

// Find the intersection between a plane and a line.  If the line is
// parallel to the plane, NULL is returned.
function D3DXPlaneIntersectLine(Out, P : PD3DXPlane; V1, V2 : PD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneIntersectLine(out Out : TD3DXPlane; P : PD3DXPlane; V1, V2 : PD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneIntersectLine(Out : PD3DXPlane; var P : TD3DXPlane; V1, V2 : PD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneIntersectLine(out Out : TD3DXPlane; var P : TD3DXPlane; V1, V2 : PD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneIntersectLine(Out, P : PD3DXPlane; var V1 : TD3DXVector3; V2 : PD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneIntersectLine(out Out : TD3DXPlane; P : PD3DXPlane; var V1 : TD3DXVector3; V2 : PD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneIntersectLine(Out : PD3DXPlane; var P : TD3DXPlane; var V1 : TD3DXVector3; V2 : PD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneIntersectLine(out Out : TD3DXPlane; var P : TD3DXPlane; var V1 : TD3DXVector3; V2 : PD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneIntersectLine(Out, P : PD3DXPlane; V1 : PD3DXVector3; var V2 : TD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneIntersectLine(out Out : TD3DXPlane; P : PD3DXPlane; V1 : PD3DXVector3; var V2 : TD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneIntersectLine(Out : PD3DXPlane; var P : TD3DXPlane; V1 : PD3DXVector3; var V2 : TD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneIntersectLine(out Out : TD3DXPlane; var P : TD3DXPlane; V1 : PD3DXVector3; var V2 : TD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneIntersectLine(Out, P : PD3DXPlane; var V1, V2 : TD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneIntersectLine(out Out : TD3DXPlane; P : PD3DXPlane; var V1, V2 : TD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneIntersectLine(Out : PD3DXPlane; var P : TD3DXPlane; var V1, V2 : TD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneIntersectLine(out Out : TD3DXPlane; var P : TD3DXPlane; var V1, V2 : TD3DXVector3) : PD3DXPlane; stdcall; overload;

// Construct a plane from a point and a normal
function D3DXPlaneFromPointNormal(Out : PD3DXPlane; Point, Normal : PD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneFromPointNormal(out Out : TD3DXPlane; Point, Normal : PD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneFromPointNormal(Out : PD3DXPlane; var Point : TD3DXVector3; Normal : PD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneFromPointNormal(out Out : TD3DXPlane; var Point : TD3DXVector3; Normal : PD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneFromPointNormal(Out : PD3DXPlane; Point : PD3DXVector3; var Normal : TD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneFromPointNormal(out Out : TD3DXPlane; Point : PD3DXVector3; var Normal : TD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneFromPointNormal(Out : PD3DXPlane; var Point, Normal : TD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneFromPointNormal(out Out : TD3DXPlane; var Point, Normal : TD3DXVector3) : PD3DXPlane; stdcall; overload;

// Construct a plane from 3 points
function D3DXPlaneFromPoints(Out : PD3DXPlane; V1, V2, V3 : PD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneFromPoints(out Out : TD3DXPlane; V1, V2, V3 : PD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneFromPoints(Out : PD3DXPlane; var V1 : TD3DXVector3; V2, V3 : PD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneFromPoints(out Out : TD3DXPlane; var V1 : TD3DXVector3; V2, V3 : PD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneFromPoints(Out : PD3DXPlane; V1 : PD3DXVector3; var V2 : TD3DXVector3; V3 : PD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneFromPoints(out Out : TD3DXPlane; V1 : PD3DXVector3; var V2 : TD3DXVector3; V3 : PD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneFromPoints(Out : PD3DXPlane; var V1, V2 : TD3DXVector3; V3 : PD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneFromPoints(out Out : TD3DXPlane; var V1, V2 : TD3DXVector3; V3 : PD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneFromPoints(Out : PD3DXPlane; V1, V2 : PD3DXVector3; var V3 : TD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneFromPoints(out Out : TD3DXPlane; V1, V2 : PD3DXVector3; var V3 : TD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneFromPoints(Out : PD3DXPlane; var V1 : TD3DXVector3; V2 : PD3DXVector3; var V3 : TD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneFromPoints(out Out : TD3DXPlane; var V1 : TD3DXVector3; V2 : PD3DXVector3; var V3 : TD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneFromPoints(Out : PD3DXPlane; V1 : PD3DXVector3; var V2, V3 : TD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneFromPoints(out Out : TD3DXPlane; V1 : PD3DXVector3; var V2, V3 : TD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneFromPoints(Out : PD3DXPlane; var V1, V2, V3 : TD3DXVector3) : PD3DXPlane; stdcall; overload;
function D3DXPlaneFromPoints(out Out : TD3DXPlane; var V1, V2, V3 : TD3DXVector3) : PD3DXPlane; stdcall; overload;

// Transform a plane by a matrix.  The vector (a,b,c) must be normal.
// M should be the inverse transpose of the transformation desired.
function D3DXPlaneTransform(Out, P : PD3DXPlane; M : TD3DXMatrix) : PD3DXPlane; stdcall; overload;
function D3DXPlaneTransform(out Out : TD3DXPlane; P : PD3DXPlane; M : TD3DXMatrix) : PD3DXPlane; stdcall; overload;
function D3DXPlaneTransform(Out : PD3DXPlane; var P : TD3DXPlane; M : TD3DXMatrix) : PD3DXPlane; stdcall; overload;
function D3DXPlaneTransform(out Out : TD3DXPlane; var P : TD3DXPlane; M : TD3DXMatrix) : PD3DXPlane; stdcall; overload;

//--------------------------
// Color
//--------------------------

// inline

// (1-r, 1-g, 1-b, a)
function D3DXColorNegative(out Out : TD3DXColor; var C : TD3DXColor) : PD3DXColor;

function D3DXColorAdd(out Out : TD3DXColor; var C1, C2 : TD3DXColor) : PD3DXColor;

function D3DXColorSubtract(out Out : TD3DXColor; var C1, C2 : TD3DXColor) : PD3DXColor;

function D3DXColorScale(out Out : TD3DXColor; var C : TD3DXColor; s : Single) : PD3DXColor;

// (r1*r2, g1*g2, b1*b2, a1*a2)
function D3DXColorModulate(out Out : TD3DXColor; var C1, C2 : TD3DXColor) : PD3DXColor;

// Linear interpolation of r,g,b, and a. C1 + s(C2-C1)
function D3DXColorLerp(out Out : TD3DXColor; var C1, C2 : TD3DXColor; s : Single) : PD3DXColor;

// non-inline

// Interpolate r,g,b between desaturated color and color.
// DesaturatedColor + s(Color - DesaturatedColor)
function D3DXColorAdjustSaturation(Out, C : PD3DXColor; s : Single) : PD3DXColor; stdcall; overload;
function D3DXColorAdjustSaturation(out Out : TD3DXColor; C : PD3DXColor; s : Single) : PD3DXColor; stdcall; overload;
function D3DXColorAdjustSaturation(Out : PD3DXColor; var C : TD3DXColor; s : Single) : PD3DXColor; stdcall; overload;
function D3DXColorAdjustSaturation(out Out : TD3DXColor; var C : TD3DXColor; s : Single) : PD3DXColor; stdcall; overload;

// Interpolate r,g,b between 50% grey and color.  Grey + s(Color - Grey)
function D3DXColorAdjustContrast(Out, C : PD3DXColor; co : Single) : PD3DXColor; stdcall; overload;
function D3DXColorAdjustContrast(out Out : TD3DXColor; C : PD3DXColor; co : Single) : PD3DXColor; stdcall; overload;
function D3DXColorAdjustContrast(Out : PD3DXColor; var C : TD3DXColor; co : Single) : PD3DXColor; stdcall; overload;
function D3DXColorAdjustContrast(out Out : TD3DXColor; var C : TD3DXColor; co : Single) : PD3DXColor; stdcall; overload;

//--------------------------
// Misc
//--------------------------

// Calculate Fresnel term given the cosine of theta (likely obtained by
// taking the dot of two normals), and the refraction index of the material.
function D3DXFresnelTerm(CosTheta, RefractionIndex : Single) : Single; stdcall;

//===========================================================================
//
//    Matrix Stack
//
//===========================================================================

const
  IID_ID3DXMatrixStack : TGUID = '{E3357330-CC5E-11D2-A434-00A0C90629A8}';

type
  ID3DXMatrixStack = interface (IUnknown)
    ['{E3357330-CC5E-11D2-A434-00A0C90629A8}']
    (*** ID3DXMatrixStack methods ***)
    // Pops the top of the stack, returns the current top
    // *after* popping the top.
    function Pop : HResult; stdcall;

    // Pushes the stack by one, duplicating the current matrix.
    function Push : HResult; stdcall;

    // Loads identity in the current matrix.
    function LoadIdentity : HResult; stdcall;

    // Loads the given matrix into the current matrix
    function LoadMatrix(var M : TD3DXMatrix) : HResult; stdcall;

    // Right-Multiplies the given matrix to the current matrix.
    // (transformation is about the current world origin)
    function MultMatrix(var M : TD3DXMatrix) : HResult; stdcall;

    // Left-Multiplies the given matrix to the current matrix
    // (transformation is about the local origin of the object)
    function MultMatrixLocal(var M : TD3DXMatrix) : HResult; stdcall;

    // Right multiply the current matrix with the computed rotation
    // matrix, counterclockwise about the given axis with the given angle.
    // (rotation is about the current world origin)
    function RotateAxis(var V : TD3DXVector3; const Angle : Single) : HResult; stdcall;

    // Left multiply the current matrix with the computed rotation
    // matrix, counterclockwise about the given axis with the given angle.
    // (rotation is about the local origin of the object)
    function RotateAxisLocal(var V : TD3DXVector3; const Angle : Single) : HResult; stdcall;

    // Right multiply the current matrix with the computed rotation
    // matrix. All angles are counterclockwise. (rotation is about the
    // current world origin)

    // The rotation is composed of a yaw around the Y axis, a pitch around
    // the X axis, and a roll around the Z axis.
    function RotateYawPitchRoll(const Yaw, Pitch, Roll : Single) : HResult; stdcall;
    
    // Left multiply the current matrix with the computed rotation
    // matrix. All angles are counterclockwise. (rotation is about the
    // local origin of the object)

    // The rotation is composed of a yaw around the Y axis, a pitch around
    // the X axis, and a roll around the Z axis.
    function RotateYawPitchRollLocal(const Yaw, Pitch, Roll : Single) : HResult; stdcall;

    // Right multiply the current matrix with the computed scale
    // matrix. (transformation is about the current world origin)
    function Scale(const x, y, z : Single) : HResult; stdcall;

    // Left multiply the current matrix with the computed scale
    // matrix. (transformation is about the local origin of the object)
    function ScaleLocal(const x, y, z : Single) : HResult; stdcall;

    // Right multiply the current matrix with the computed translation
    // matrix. (transformation is about the current world origin)
    function Translate(const x, y, z : Single) : HResult; stdcall;

    // Left multiply the current matrix with the computed translation
    // matrix. (transformation is about the local origin of the object)
    function TranslateLocal(const x, y, z : Single) : HResult; stdcall;

    // Obtain the current matrix at the top of the stack
    function GetTop : PD3DXMatrix; stdcall;
  end;

function D3DXCreateMatrixStack(const Flags : LongWord; out Stack : ID3DXMatrixStack) : HResult; stdcall;


(*)
[-------------------------------------------------------------------------------
[  Copyright (C) Microsoft Corporation.  All Rights Reserved.
[
[  File:       d3dx8core.h
[  Content:    D3DX core types and functions
[-------------------------------------------------------------------------------
(*)

const
  IID_ID3DXBuffer          : TGUID = '{932E6A7E-C68E-45dd-A7BF-53D19C86DB1F}';
  IID_ID3DXFont            : TGUID = '{89FAD6A5-024D-49af-8FE7-F51123B85E25}';
  IID_ID3DXSprite          : TGUID = '{13D69D15-F9B0-4e0f-B39E-C91EB33F6CE7}';
  IID_ID3DXRenderToSurface : TGUID = '{82DF5B90-E34E-496e-AC1C-62117A6A5913}';
  IID_ID3DXRenderToEnvMap  : TGUID = '{4E42C623-9451-44b7-8C86-ABCCDE5D52C8}';


(*)
[-------------------------------------------------------------------------------
[ ID3DXBuffer:
[ ------------
[ The buffer object is used by D3DX to return arbitrary size data.
[
[ GetBufferPointer -
[    Returns a pointer to the beginning of the buffer.
[
[ GetBufferSize -
[    Returns the size of the buffer, in bytes.
[-------------------------------------------------------------------------------
(*)

type
  PID3DXBuffer = ^ID3DXBuffer;
  ID3DXBuffer = interface (IUnknown)
    ['{932E6A7E-C68E-45dd-A7BF-53D19C86DB1F}']
    (*** ID3DXBuffer methods ***)
    function GetBufferPointer : Pointer; stdcall;
    function GetBufferSize : LongWord; stdcall;
  end;

(*)
[-------------------------------------------------------------------------------
[ ID3DXFont:
[ ----------
[ Font objects contain the textures and resources needed to render
[ a specific font on a specific device.
[
[ Begin -
[    Prepartes device for drawing text.  This is optional.. if DrawText
[    is called outside of Begin/End, it will call Begin and End for you.
[
[ DrawText -
[    Draws formatted text on a D3D device.  Some parameters are
[    surprisingly similar to those of GDI's DrawText function.  See GDI
[    documentation for a detailed description of these parameters.
[
[ End -
[    Restores device state to how it was when Begin was called.
[
[ OnLostDevice, OnResetDevice -
[    Call OnLostDevice() on this object before calling Reset() on the
[    device, so that this object can release any stateblocks and video
[    memory resources.  After Reset(), the call OnResetDevice().
[-------------------------------------------------------------------------------
(*)

type
  PID3DXFont = ^ID3DXFont;
  ID3DXFont = interface (IUnknown)
    ['{89FAD6A5-024D-49af-8FE7-F51123B85E25}']
    (*** ID3DXFont methods ***)

    function GetDevice(out Device : IDirect3DDevice8) : HResult; stdcall;
    function GetLogFont(var LogFont : TLogFont) : HResult;  stdcall;

    function _Begin : HResult; stdcall;
    function DrawTextA(_String : PAnsiChar; Count : Integer; var Rect : TRect; Format : LongWord; Color : TD3DColor) : Integer; stdcall;
    function DrawTextW(_String : PWideChar; Count : Integer; var Rect : TRect; Format : LongWord; Color : TD3DColor) : Integer; stdcall;
    function _End : HResult; stdcall;

    function OnLostDevice : HResult; stdcall;
    function OnResetDevice : HResult;  stdcall;
  end;


function D3DXCreateFont(Device : IDirect3DDevice8; InFont : HFONT; out OutFont : ID3DXFont) : HResult; stdcall;

function D3DXCreateFontIndirect(Device : IDirect3DDevice8; LogFont : PLogFont; out Font : ID3DXFont) : HResult; stdcall; overload;
function D3DXCreateFontIndirect(Device : IDirect3DDevice8; var LogFont : TLogFont; out Font : ID3DXFont) : HResult; stdcall; overload;

(*)
[-------------------------------------------------------------------------------
[ ID3DXSprite:
[ ------------
[ This object intends to provide an easy way to drawing sprites using D3D.
[
[ Begin -
[    Prepares device for drawing sprites
[
[ Draw, DrawAffine, DrawTransform -
[    Draws a sprite in screen-space.  Before transformation, the sprite is
[    the size of SrcRect, with its top-left corner at the origin (0,0).
[    The color and alpha channels are modulated by Color.
[
[ End -
[     Restores device state to how it was when Begin was called.
[
[ OnLostDevice, OnResetDevice -
[    Call OnLostDevice() on this object before calling Reset() on the
[    device, so that this object can release any stateblocks and video
[    memory resources.  After Reset(), the call OnResetDevice().
[-------------------------------------------------------------------------------
(*)

type
  PID3DXSprite = ^ID3DXSprite;
  ID3DXSprite = interface (IUnknown)
    ['{13D69D15-F9B0-4e0f-B39E-C91EB33F6CE7}']
    (*** ID3DXSprite methods ***)
    function GetDevice(out Device : IDirect3DDevice8) : HResult; stdcall;

    function _Begin : HResult; stdcall;

    function Draw(const SrcTexture : IDirect3DTexture8; const SrcRect : PRect; Scaling, RotationCenter : PD3DXVector2; Rotation : Single; Translation  : PD3DXVector2; Color : TD3DColor) : HResult; stdcall;

    function DrawTransform(const SrcTexture : IDirect3DTexture8; const SrcRect : PRect; var Transform : TD3DXMatrix; Color : TD3DColor) : HResult; stdcall;

    function _End : HResult; stdcall;

    function OnLostDevice : HResult; stdcall;
    function OnResetDevice : HResult; stdcall;
  end;


function D3DXCreateSprite(Device : IDirect3DDevice8; out Sprite : ID3DXSprite) : HResult; stdcall; overload;
function D3DXCreateSprite(Device : IDirect3DDevice8; Sprite : PID3DXSprite) : HResult; stdcall; overload;



(*)
[-------------------------------------------------------------------------------
[ ID3DXRenderToSurface:
[ ---------------------
[ This object abstracts rendering to surfaces.  These surfaces do not
[ necessarily need to be render targets.  If they are not, a compatible
[ render target is used, and the result copied into surface at end scene.
[
[ BeginScene, EndScene -
[    Call BeginScene() and EndScene() at the beginning and ending of your
[    scene.  These calls will setup and restore render targets, viewports,
[    etc..
[
[ OnLostDevice, OnResetDevice -
[    Call OnLostDevice() on this object before calling Reset() on the
[    device, so that this object can release any stateblocks and video
[    memory resources.  After Reset(), the call OnResetDevice().
[-------------------------------------------------------------------------------
(*)

type
  TD3DXRTSDesc = packed record
    Width              : Cardinal;
    Height             : Cardinal;
    Format             : TD3DFormat;
    DepthStencil       : BOOL;
    DepthStencilFormat : TD3DFormat;
  end;

  TD3DXRTS_Desc = TD3DXRTSDesc;

type
  PID3DXRenderToSurface = ^ID3DXRenderToSurface;
  ID3DXRenderToSurface = interface (IUnknown)
    ['{82DF5B90-E34E-496e-AC1C-62117A6A5913}']
    (*** ID3DXRenderToSurface methods ***)

    // ID3DXRenderToSurface
    function GetDevice(out Device : IDirect3DDevice8) : HResult; stdcall;
    function GetDesc(out Desc : TD3DXRTSDesc) : HResult; stdcall;

    function BeginScene(var Surface : IDirect3DSurface8; var Viewport : TD3DViewport8) : HResult; stdcall;
    function EndScene : HResult; stdcall;

    function OnLostDevice : HResult; stdcall;
    function OnResetDevice : HResult; stdcall;
  end;

function D3DXCreateRenderToSurface(const Device : IDirect3DDevice8; Width, Height : Cardinal; Format : TD3DFormat; DepthStencil : BOOL; DepthStencilFormat : TD3DFormat; out RenderToSurface : ID3DXRenderToSurface) : HResult; stdcall;

(*)
[-------------------------------------------------------------------------------
[ ID3DXRenderToEnvMap:
[ --------------------
[ This object abstracts rendering to environment maps.  These surfaces
[ do not necessarily need to be render targets.  If they are not, a
[ compatible render target is used, and the result copied into the
[ environment map at end scene.
[
[ BeginCube, BeginSphere, BeginHemisphere, BeginParabolic -
[    This function initiates the rendering of the environment map.  As
[    parameters, you pass the textures in which will get filled in with
[    the resulting environment map.
[
[ Face -
[    Call this function to initiate the drawing of each face.  For each
[    environment map, you will call this six times.. once for each face
[    in D3DCUBEMAP_FACES.
[
[ End -
[    This will restore all render targets, and if needed compose all the
[    rendered faces into the environment map surfaces.
[
[ OnLostDevice, OnResetDevice -
[    Call OnLostDevice() on this object before calling Reset() on the
[    device, so that this object can release any stateblocks and video
[    memory resources.  After Reset(), the call OnResetDevice().
[-------------------------------------------------------------------------------
(*)

type
  TD3DXRTEDesc = packed record
    Size               : Cardinal;
    Format             : TD3DFormat;
    DepthStencil       : Bool;
    DepthStencilFormat : TD3DFormat;
  end;
  TD3DXRTE_Desc = TD3DXRTEDesc;

type
  PID3DXRenderToEnvMap = ^ID3DXRenderToEnvMap;
  ID3DXRenderToEnvMap = interface (IUnknown)
    ['{4E42C623-9451-44b7-8C86-ABCCDE5D52C8}']
    (*** ID3DXRenderToEnvMap methods ***)

    function GetDevice(out Device : IDirect3DDevice8) : HResult; stdcall;
    function GetDesc(out Desc : TD3DXRTEDesc) : HResult; stdcall;

    function BeginCube(const CubeTex : IDirect3DCubeTexture8) : HResult; stdcall;

    function BeginSphere(const Tex : IDirect3DTexture8) : HResult; stdcall;

    function BeginHemisphere(const TexZPos, TexZNeg : IDirect3DTexture8) : HResult; stdcall;

    function BeginParabolic(const TexZPos, TexZNeg : IDirect3DTexture8) : HResult; stdcall;

    function Face(Face : TD3DCubeMapFaces) : HResult; stdcall;
    function _End : HResult; stdcall;

    function OnLostDevice : HResult; stdcall;
    function OnResetDevice : HResult; stdcall;
  end;

function D3DXCreateRenderToEnvMap(const Device : IDirect3DDevice8; const Size : Cardinal; const Format : TD3DFormat; DepthStencil : Bool; DepthStencilFormat : TD3DFormat; out RenderToEnvMap : ID3DXRenderToEnvMap): HResult; stdcall;

(*)
[-------------------------------------------------------------------------------
[ Shader assemblers:
[-------------------------------------------------------------------------------
(*)

(*)
[-------------------------------------------------------------------------------
[ D3DXASM flags:
[ --------------
[
[ D3DXASM_DEBUG
[   Generate debug info.
[
[ D3DXASM_SKIPVALIDATION
[   Do not validate the generated code against known capabilities and
[   constraints.  This option is only recommended when assembling shaders
[   you KNOW will work.  (ie. have assembled before without this option.)
[-------------------------------------------------------------------------------
(*)

const
  D3DXASM_DEBUG           = (1 shl 0);
  D3DXASM_SKIPVALIDATION  = (1 shl 1);

(*)
[-------------------------------------------------------------------------------
[ D3DXAssembleShader:
[ -------------------
[ Assembles an ascii description of a vertex or pixel shader into
[ binary form.
[
[ Parameters:
[  pSrcFile
[      Source file name
[  hSrcModule
[      Module handle. if NULL, current module will be used.
[  pSrcResource
[      Resource name in module
[  pSrcData
[      Pointer to source code
[  SrcDataLen
[      Size of source code, in bytes
[  Flags
[      D3DXASM_xxx flags
[  ppConstants
[      Returns an ID3DXBuffer object containing constant declarations.
[  ppCompiledShader
[      Returns an ID3DXBuffer object containing the object code.
[  ppCompilationErrors
[      Returns an ID3DXBuffer object containing ascii error messages
[-------------------------------------------------------------------------------
(*)

function D3DXAssembleShaderFromFileA(SrcFile : PAnsiChar; Flags : LongWord; Constants, CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFileA(SrcFile : PAnsiChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFileA(SrcFile : PAnsiChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFileA(SrcFile : PAnsiChar; Flags : LongWord; out Constants, CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFileA(SrcFile : PAnsiChar; Flags : LongWord; Constants, CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFileA(SrcFile : PAnsiChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFileA(SrcFile : PAnsiChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFileA(SrcFile : PAnsiChar; Flags : LongWord; out Constants, CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;

function D3DXAssembleShaderFromFileW(SrcFile : PWideChar; Flags : LongWord; Constants, CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFileW(SrcFile : PWideChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFileW(SrcFile : PWideChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFileW(SrcFile : PWideChar; Flags : LongWord; out Constants, CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFileW(SrcFile : PWideChar; Flags : LongWord; Constants, CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFileW(SrcFile : PWideChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFileW(SrcFile : PWideChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFileW(SrcFile : PWideChar; Flags : LongWord; out Constants, CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;

{$IFDEF UNICODE}
function D3DXAssembleShaderFromFile(SrcFile : PWideChar; Flags : LongWord; Constants, CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFile(SrcFile : PWideChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFile(SrcFile : PWideChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFile(SrcFile : PWideChar; Flags : LongWord; out Constants, CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFile(SrcFile : PWideChar; Flags : LongWord; Constants, CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFile(SrcFile : PWideChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFile(SrcFile : PWideChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFile(SrcFile : PWideChar; Flags : LongWord; out Constants, CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
{$ELSE}
function D3DXAssembleShaderFromFile(SrcFile : PAnsiChar; Flags : LongWord; Constants, CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFile(SrcFile : PAnsiChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFile(SrcFile : PAnsiChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFile(SrcFile : PAnsiChar; Flags : LongWord; out Constants, CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFile(SrcFile : PAnsiChar; Flags : LongWord; Constants, CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFile(SrcFile : PAnsiChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFile(SrcFile : PAnsiChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromFile(SrcFile : PAnsiChar; Flags : LongWord; out Constants, CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
{$ENDIF}

function D3DXAssembleShaderFromResourceA(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; Constants, CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResourceA(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResourceA(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResourceA(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; out Constants, CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResourceA(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; Constants, CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResourceA(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResourceA(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResourceA(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; out Constants, CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;

function D3DXAssembleShaderFromResourceW(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; Constants, CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResourceW(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResourceW(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResourceW(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; out Constants, CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResourceW(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; Constants, CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResourceW(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResourceW(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResourceW(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; out Constants, CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;

{$IFDEF UNICODE}
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; Constants, CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; out Constants, CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; Constants, CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; out Constants, CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
{$ELSE}
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; Constants, CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; out Constants, CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; Constants, CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; out Constants, CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
{$ENDIF}

function D3DXAssembleShader(SrcData : Pointer; SrcDataLen : Cardinal; Flags : LongWord; Constants, CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShader(SrcData : Pointer; SrcDataLen : Cardinal; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShader(SrcData : Pointer; SrcDataLen : Cardinal; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShader(SrcData : Pointer; SrcDataLen : Cardinal; Flags : LongWord; out Constants, CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShader(SrcData : Pointer; SrcDataLen : Cardinal; Flags : LongWord; Constants, CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShader(SrcData : Pointer; SrcDataLen : Cardinal; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShader(SrcData : Pointer; SrcDataLen : Cardinal; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXAssembleShader(SrcData : Pointer; SrcDataLen : Cardinal; Flags : LongWord; out Constants, CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;

(*)
[-------------------------------------------------------------------------------
[ Misc APIs:
[-------------------------------------------------------------------------------
(*)

(*)
[-------------------------------------------------------------------------------
[ D3DXGetErrorString:
[ ------------------
[ Returns the error string for given an hresult.  Interprets all D3DX and
[ D3D hresults.
[
[ Parameters:
[  hr
[      The error code to be deciphered.
[  pBuffer
[      Pointer to the buffer to be filled in.
[  BufferLen
[      Count of characters in buffer.  Any error message longer than this
[      length will be truncated to fit.
[-------------------------------------------------------------------------------
(*)

function D3DXGetErrorStringA(hr : HResult; Buffer : PAnsiChar; BufferLen : Cardinal) : HResult; stdcall;

function D3DXGetErrorStringW(hr : HResult; Buffer : PWideChar; BufferLen : Cardinal) : HResult; stdcall;

{$IFDEF UNICODE}
function D3DXGetErrorString(hr : HResult; Buffer : PWideChar; BufferLen : Cardinal) : HResult; stdcall;
{$ELSE}
function D3DXGetErrorString(hr : HResult; Buffer : PAnsiChar; BufferLen : Cardinal) : HResult; stdcall;
{$ENDIF}


(*)
[-------------------------------------------------------------------------------
[  Copyright (C) Microsoft Corporation.  All Rights Reserved.
[
[  File:       d3dx8tex.h
[  Content:    D3DX texturing APIs
[-------------------------------------------------------------------------------
(*)

(*)
[-------------------------------------------------------------------------------
[ D3DX_FILTER flags:
[ ------------------
[
[ A valid filter must contain one of these values:
[
[  D3DX_FILTER_NONE
[      No scaling or filtering will take place.  Pixels outside the bounds
[      of the source image are assumed to be transparent black.
[  D3DX_FILTER_POINT
[      Each destination pixel is computed by sampling the nearest pixel
[      from the source image.
[  D3DX_FILTER_LINEAR
[      Each destination pixel is computed by linearly interpolating between
[      the nearest pixels in the source image.  This filter works best 
[      when the scale on each axis is less than 2.
[  D3DX_FILTER_TRIANGLE
[      Every pixel in the source image contributes equally to the
[      destination image.  This is the slowest of all the filters.
[  D3DX_FILTER_BOX
[      Each pixel is computed by averaging a 2x2(x2) box pixels from 
[      the source image. Only works when the dimensions of the 
[      destination are half those of the source. (as with mip maps)
[
[ And can be OR'd with any of these optional flags:
[
[  D3DX_FILTER_MIRROR_U
[      Indicates that pixels off the edge of the texture on the U-axis
[      should be mirrored, not wraped.
[  D3DX_FILTER_MIRROR_V
[      Indicates that pixels off the edge of the texture on the V-axis
[      should be mirrored, not wraped.
[  D3DX_FILTER_MIRROR_W
[      Indicates that pixels off the edge of the texture on the W-axis
[      should be mirrored, not wraped.
[  D3DX_FILTER_MIRROR
[      Same as specifying D3DX_FILTER_MIRROR_U | D3DX_FILTER_MIRROR_V |
[      D3DX_FILTER_MIRROR_V
[  D3DX_FILTER_DITHER
[      Dithers the resulting image.
[-------------------------------------------------------------------------------
(*)

const
  D3DX_FILTER_NONE            = (1 shl 0);
  D3DX_FILTER_POINT           = (2 shl 0);
  D3DX_FILTER_LINEAR          = (3 shl 0);
  D3DX_FILTER_TRIANGLE        = (4 shl 0);
  D3DX_FILTER_BOX             = (5 shl 0);

  D3DX_FILTER_MIRROR_U        = (1 shl 16);
  D3DX_FILTER_MIRROR_V        = (2 shl 16);
  D3DX_FILTER_MIRROR_W        = (4 shl 16);
  D3DX_FILTER_MIRROR          = (7 shl 16);
  D3DX_FILTER_DITHER          = (8 shl 16);

(*)
[-------------------------------------------------------------------------------
[ D3DX_NORMALMAP flags:
[ ---------------------
[ These flags are used to control how D3DXComputeNormalMap generates normal
[ maps.  Any number of these flags may be OR'd together in any combination.
[
[  D3DX_NORMALMAP_MIRROR_U
[      Indicates that pixels off the edge of the texture on the U-axis
[      should be mirrored, not wraped.
[  D3DX_NORMALMAP_MIRROR_V
[      Indicates that pixels off the edge of the texture on the V-axis
[      should be mirrored, not wraped.
[  D3DX_NORMALMAP_MIRROR
[      Same as specifying D3DX_NORMALMAP_MIRROR_U | D3DX_NORMALMAP_MIRROR_V
[  D3DX_NORMALMAP_INVERTSIGN
[      Inverts the direction of each normal
[  D3DX_NORMALMAP_COMPUTE_OCCLUSION
[      Compute the per pixel Occlusion term and encodes it into the alpha.
[      An Alpha of 1 means that the pixel is not obscured in anyway, and
[      an alpha of 0 would mean that the pixel is completly obscured.
[-------------------------------------------------------------------------------
(*)

const                              
  D3DX_NORMALMAP_MIRROR_U          = (1 shl 16);
  D3DX_NORMALMAP_MIRROR_V          = (2 shl 16);
  D3DX_NORMALMAP_MIRROR            = (3 shl 16);
  D3DX_NORMALMAP_INVERTSIGN        = (8 shl 16);
  D3DX_NORMALMAP_COMPUTE_OCCLUSION = (16 shl 16);

(*)
[-------------------------------------------------------------------------------
[ D3DX_CHANNEL flags:
[ -------------------
[ These flags are used by functions which operate on or more channels
[ in a texture.
[
[ D3DX_CHANNEL_RED
[     Indicates the red channel should be used
[ D3DX_CHANNEL_BLUE
[     Indicates the blue channel should be used
[ D3DX_CHANNEL_GREEN
[     Indicates the green channel should be used
[ D3DX_CHANNEL_ALPHA
[     Indicates the alpha channel should be used
[ D3DX_CHANNEL_LUMINANCE
[     Indicates the luminaces of the red green and blue channels should be
[     used.
[-------------------------------------------------------------------------------
(*)

const
  D3DX_CHANNEL_RED            = (1 shl 0);
  D3DX_CHANNEL_BLUE           = (1 shl 1);
  D3DX_CHANNEL_GREEN          = (1 shl 2);
  D3DX_CHANNEL_ALPHA          = (1 shl 3);
  D3DX_CHANNEL_LUMINANCE      = (1 shl 4);

(*)
[-------------------------------------------------------------------------------
[ D3DXIMAGE_FILEFORMAT:
[ ---------------------
[ This enum is used to describe supported image file formats.
[-------------------------------------------------------------------------------
(*)

type
  TD3DXImageFileFormat = {$IFNDEF NOENUMS}({$ELSE}LongWord;{$ENDIF}
{$IFDEF NOENUMS}const{$ENDIF}
    D3DXIFF_BMP         = 0{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}
    D3DXIFF_JPG         = 1{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}
    D3DXIFF_TGA         = 2{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}
    D3DXIFF_PNG         = 3{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}
    D3DXIFF_DDS         = 4{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}
    D3DXIFF_PPM         = 5{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}
    D3DXIFF_DIB         = 6{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}
    D3DXIFF_FORCE_DWORD = $7fffffff{$IFNDEF NOENUMS}){$ENDIF};

type
  TD3DXImage_FileFormat = TD3DXImageFileFormat;

(*)
[-------------------------------------------------------------------------------
[ LPD3DXFILL2D and LPD3DXFILL3D:
[ ------------------------------
[ Function types used by the texture fill functions.
[
[ Parameters:
[  pOut
[      Pointer to a vector which the function uses to return its result.
[      X,Y,Z,W will be mapped to R,G,B,A respectivly.
[  pTexCoord
[      Pointer to a vector containing the coordinates of the texel currently
[      being evaluated.  Textures and VolumeTexture texcoord components
[      range from 0 to 1. CubeTexture texcoord component range from -1 to 1.
[  pTexelSize
[      Pointer to a vector containing the dimensions of the current texel.
[  pData
[      Pointer to user data.
[-------------------------------------------------------------------------------
(*)

type
  TD3DXFILL2D = procedure(out Out : TD3DXVector4; var TexCoord, TexelSize : TD3DXVector2; Data : Pointer); stdcall;
  TD3DXFILL3D = procedure(out Out : TD3DXVector4; var TexCoord, TexelSize : TD3DXVector3; Data : Pointer); stdcall;

(*)
[-------------------------------------------------------------------------------
[ D3DXIMAGE_INFO:
[ ---------------
[ This structure is used to return a rough description of what the
[ the original contents of an image file looked like.
[
[  Width
[      Width of original image in pixels
[  Height
[      Height of original image in pixels
[  Depth
[      Depth of original image in pixels
[  MipLevels
[      Number of mip levels in original image
[  Format
[      D3D format which most closely describes the data in original image
[  ResourceType
[      D3DRESOURCETYPE representing the type of texture stored in the file.
[      D3DRTYPE_TEXTURE, D3DRTYPE_VOLUMETEXTURE, or D3DRTYPE_CUBETEXTURE.
[  ImageFileFormat
[      D3DXIMAGE_FILEFORMAT representing the format of the image file.
[-------------------------------------------------------------------------------
(*)

type
  PD3DXImageInfo = ^TD3DXImageInfo;
  TD3DXImageInfo = packed record
    Width           : Cardinal;
    Height          : Cardinal;
    Depth           : Cardinal;
    MipLevels       : Cardinal;
    Format          : TD3DFormat;
    ResourceType    : TD3DResourceType;
    ImageFileFormat : TD3DXImageFileFormat;
  end;
  PD3DXImage_Info = ^TD3DXImage_Info;
  TD3DXImage_Info = TD3DXImageInfo;

(*)
[-------------------------------------------------------------------------------
[ Image File APIs
[-------------------------------------------------------------------------------
(*)

(*)
[-------------------------------------------------------------------------------
[ GetImageInfoFromFile/Resource:
[ ------------------------------
[ Fills in a D3DXIMAGE_INFO struct with information about an image file.
[
[ Parameters:
[  pSrcFile
[      File name of the source image.
[  pSrcModule
[      Module where resource is located, or NULL for module associated
[      with image the os used to create the current process.
[  pSrcResource
[      Resource name
[  pSrcData
[      Pointer to file in memory.
[  SrcDataSize
[      Size in bytes of file in memory.
[  pSrcInfo
[      Pointer to a D3DXIMAGE_INFO structure to be filled in with the
[      description of the data in the source image file.
[-------------------------------------------------------------------------------
(*)

function D3DXGetImageInfoFromFileA(const SrcFile : PAnsiChar; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXGetImageInfoFromFileA(const SrcFile : PAnsiChar; out SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;

function D3DXGetImageInfoFromFileW(const SrcFile : PWideChar; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXGetImageInfoFromFileW(const SrcFile : PWideChar; out SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;

{$IFDEF UNICODE}
function D3DXGetImageInfoFromFile(const SrcFile : PWideChar; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXGetImageInfoFromFile(const SrcFile : PWideChar; out SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
{$ELSE}
function D3DXGetImageInfoFromFile(const SrcFile : PAnsiChar; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXGetImageInfoFromFile(const SrcFile : PAnsiChar; out SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
{$ENDIF}

function D3DXGetImageInfoFromResourceA(const SrcModule : HMODULE; const SrcResource : PAnsiChar; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXGetImageInfoFromResourceA(const SrcModule : HMODULE; const SrcResource : PAnsiChar; out SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;

function D3DXGetImageInfoFromResourceW(const SrcModule : HMODULE; const SrcResource : PWideChar; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXGetImageInfoFromResourceW(const SrcModule : HMODULE; const SrcResource : PWideChar; out SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;

{$IFDEF UNICODE}
function D3DXGetImageInfoFromResource(const SrcModule : HMODULE; const SrcResource : PWideChar; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXGetImageInfoFromResource(const SrcModule : HMODULE; const SrcResource : PWideChar; out SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
{$ELSE}
function D3DXGetImageInfoFromResource(const SrcModule : HMODULE; const SrcResource : PAnsiChar; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXGetImageInfoFromResource(const SrcModule : HMODULE; const SrcResource : PAnsiChar; out SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
{$ENDIF}

function D3DXGetImageInfoFromFileInMemory(const SrcData : Pointer; const SrcDataSize : Cardinal; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXGetImageInfoFromFileInMemory(const SrcData : Pointer; const SrcDataSize : Cardinal; out SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;


(*)
[-------------------------------------------------------------------------------
[ Load/Save Surface APIs
[-------------------------------------------------------------------------------
(*)

(*)
[-------------------------------------------------------------------------------
[ D3DXLoadSurfaceFromFile/Resource:
[ ---------------------------------
[ Load surface from a file or resource
[
[ Parameters:
[  pDestSurface
[      Destination surface, which will receive the image.
[  pDestPalette
[      Destination palette of 256 colors, or NULL
[  pDestRect
[      Destination rectangle, or NULL for entire surface
[  pSrcFile
[      File name of the source image.
[  pSrcModule
[      Module where resource is located, or NULL for module associated
[      with image the os used to create the current process.
[  pSrcResource
[      Resource name
[  pSrcData
[      Pointer to file in memory.
[  SrcDataSize
[      Size in bytes of file in memory.
[  pSrcRect
[      Source rectangle, or NULL for entire image
[  Filter
[      D3DX_FILTER flags controlling how the image is filtered.
[      Or D3DX_DEFAULT for D3DX_FILTER_TRIANGLE.
[  ColorKey
[      Color to replace with transparent black, or 0 to disable colorkey.
[      This is always a 32-bit ARGB color, independent of the source image
[      format.  Alpha is significant, and should usually be set to FF for
[      opaque colorkeys.  (ex. Opaque black == 0xff000000)
[  pSrcInfo
[      Pointer to a D3DXIMAGE_INFO structure to be filled in with the
[      description of the data in the source image file, or NULL.
[-------------------------------------------------------------------------------
(*)

function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;

function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;

{$IFDEF UNICODE}
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
{$ELSE}
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
{$ENDIF}

function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;

function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;

{$IFDEF UNICODE}
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
{$ELSE}
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
{$ENDIF}

function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcData : Pointer; SrcDataSize : Cardinal; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcData : Pointer; SrcDataSize : Cardinal; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcData : Pointer; SrcDataSize : Cardinal; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcData : Pointer; SrcDataSize : Cardinal; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcData : Pointer; SrcDataSize : Cardinal; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcData : Pointer; SrcDataSize : Cardinal; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcData : Pointer; SrcDataSize : Cardinal; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcData : Pointer; SrcDataSize : Cardinal; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcData : Pointer; SrcDataSize : Cardinal; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcData : Pointer; SrcDataSize : Cardinal; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcData : Pointer; SrcDataSize : Cardinal; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcData : Pointer; SrcDataSize : Cardinal; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcData : Pointer; SrcDataSize : Cardinal; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcData : Pointer; SrcDataSize : Cardinal; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcData : Pointer; SrcDataSize : Cardinal; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcData : Pointer; SrcDataSize : Cardinal; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;

(*)
[-------------------------------------------------------------------------------
[ D3DXLoadSurfaceFromSurface:
[ ---------------------------
[ Load surface from another surface (with color conversion)
[
[ Parameters:
[  pDestSurface
[      Destination surface, which will receive the image.
[  pDestPalette
[      Destination palette of 256 colors, or NULL
[  pDestRect
[      Destination rectangle, or NULL for entire surface
[  pSrcSurface
[      Source surface
[  pSrcPalette
[      Source palette of 256 colors, or NULL
[  pSrcRect
[      Source rectangle, or NULL for entire surface
[  Filter
[      D3DX_FILTER flags controlling how the image is filtered.
[      Or D3DX_DEFAULT for D3DX_FILTER_TRIANGLE.
[  ColorKey
[      Color to replace with transparent black, or 0 to disable colorkey.
[      This is always a 32-bit ARGB color, independent of the source image
[      format.  Alpha is significant, and should usually be set to FF for
[      opaque colorkeys.  (ex. Opaque black == 0xff000000)
[-------------------------------------------------------------------------------
(*)

function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;

(*)
[-------------------------------------------------------------------------------
[ D3DXLoadSurfaceFromMemory:
[ --------------------------
[ Load surface from memory.
[
[ Parameters:
[  pDestSurface
[      Destination surface, which will receive the image.
[  pDestPalette
[      Destination palette of 256 colors, or NULL
[  pDestRect
[      Destination rectangle, or NULL for entire surface
[  pSrcMemory
[      Pointer to the top-left corner of the source image in memory
[  SrcFormat
[      Pixel format of the source image.
[  SrcPitch
[      Pitch of source image, in bytes.  For DXT formats, this number
[      should represent the width of one row of cells, in bytes.
[  pSrcPalette
[      Source palette of 256 colors, or NULL
[  pSrcRect
[      Source rectangle.
[  Filter
[      D3DX_FILTER flags controlling how the image is filtered.
[      Or D3DX_DEFAULT for D3DX_FILTER_TRIANGLE.
[  ColorKey
[      Color to replace with transparent black, or 0 to disable colorkey.
[      This is always a 32-bit ARGB color, independent of the source image
[      format.  Alpha is significant, and should usually be set to FF for
[      opaque colorkeys.  (ex. Opaque black == 0xff000000)
[-------------------------------------------------------------------------------
(*)

function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; SrcPalette : PPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; SrcPalette : PPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; SrcPalette : PPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; SrcPalette : PPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; var SrcPalette : TPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; var SrcPalette : TPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; var SrcPalette : TPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; var SrcPalette : TPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; SrcPalette : PPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; SrcPalette : PPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; SrcPalette : PPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; SrcPalette : PPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; var SrcPalette : TPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; var SrcPalette : TPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; var SrcPalette : TPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; var SrcPalette : TPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;

(*)
[-------------------------------------------------------------------------------
[ D3DXSaveSurfaceToFile:
[ ----------------------
[ Save a surface to a image file.
[
[ Parameters:
[  pDestFile
[      File name of the destination file
[  DestFormat
[      D3DXIMAGE_FILEFORMAT specifying file format to use when saving.
[  pSrcSurface
[      Source surface, containing the image to be saved
[  pSrcPalette
[      Source palette of 256 colors, or NULL
[  pSrcRect
[      Source rectangle, or NULL for the entire image
[-------------------------------------------------------------------------------
(*)

function D3DXSaveSurfaceToFileA(DestFile : PAnsiChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; SrcRect : PRect) : HResult; stdcall; overload;
function D3DXSaveSurfaceToFileA(DestFile : PAnsiChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; SrcRect : PRect) : HResult; stdcall; overload;
function D3DXSaveSurfaceToFileA(DestFile : PAnsiChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; var SrcRect : TRect) : HResult; stdcall; overload;
function D3DXSaveSurfaceToFileA(DestFile : PAnsiChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; var SrcRect : TRect) : HResult; stdcall; overload;

function D3DXSaveSurfaceToFileW(DestFile : PWideChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; SrcRect : PRect) : HResult; stdcall; overload;
function D3DXSaveSurfaceToFileW(DestFile : PWideChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; SrcRect : PRect) : HResult; stdcall; overload;
function D3DXSaveSurfaceToFileW(DestFile : PWideChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; var SrcRect : TRect) : HResult; stdcall; overload;
function D3DXSaveSurfaceToFileW(DestFile : PWideChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; var SrcRect : TRect) : HResult; stdcall; overload;

{$IFDEF UNICODE}
function D3DXSaveSurfaceToFile(DestFile : PWideChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; SrcRect : PRect) : HResult; stdcall; overload;
function D3DXSaveSurfaceToFile(DestFile : PWideChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; SrcRect : PRect) : HResult; stdcall; overload;
function D3DXSaveSurfaceToFile(DestFile : PWideChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; var SrcRect : TRect) : HResult; stdcall; overload;
function D3DXSaveSurfaceToFile(DestFile : PWideChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; var SrcRect : TRect) : HResult; stdcall; overload;
{$ELSE}
function D3DXSaveSurfaceToFile(DestFile : PAnsiChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; SrcRect : PRect) : HResult; stdcall; overload;
function D3DXSaveSurfaceToFile(DestFile : PAnsiChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; SrcRect : PRect) : HResult; stdcall; overload;
function D3DXSaveSurfaceToFile(DestFile : PAnsiChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; var SrcRect : TRect) : HResult; stdcall; overload;
function D3DXSaveSurfaceToFile(DestFile : PAnsiChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; var SrcRect : TRect) : HResult; stdcall; overload;
{$ENDIF}

(*)
[-------------------------------------------------------------------------------
[ Load/Save Volume APIs
[-------------------------------------------------------------------------------
(*)

(*)
[-------------------------------------------------------------------------------
[ D3DXLoadVolumeFromFile/Resource:
[ --------------------------------
[ Load volume from a file or resource
[
[ Parameters:
[  pDestVolume
[      Destination volume, which will receive the image.
[  pDestPalette
[      Destination palette of 256 colors, or NULL
[  pDestBox
[      Destination box, or NULL for entire volume
[  pSrcFile
[      File name of the source image.
[  pSrcModule
[      Module where resource is located, or NULL for module associated
[      with image the os used to create the current process.
[  pSrcResource
[      Resource name
[  pSrcData
[      Pointer to file in memory.
[  SrcDataSize
[      Size in bytes of file in memory.
[  pSrcBox
[      Source box, or NULL for entire image
[  Filter
[      D3DX_FILTER flags controlling how the image is filtered.
[      Or D3DX_DEFAULT for D3DX_FILTER_TRIANGLE.
[  ColorKey
[      Color to replace with transparent black, or 0 to disable colorkey.
[      This is always a 32-bit ARGB color, independent of the source image
[      format.  Alpha is significant, and should usually be set to FF for
[      opaque colorkeys.  (ex. Opaque black == 0xff000000)
[  pSrcInfo
[      Pointer to a D3DXIMAGE_INFO structure to be filled in with the
[      description of the data in the source image file, or NULL.
[-------------------------------------------------------------------------------
(*)

function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;

function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;

{$IFDEF UNICODE}
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
{$ELSE}
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
{$ENDIF}

function D3DXLoadVolumeFromResourceA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;

function D3DXLoadVolumeFromResourceW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResourceW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;

{$IFDEF UNICODE}
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
{$ELSE}
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromResource(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
{$ENDIF}

function D3DXLoadVolumeFromFileInMemory(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcData : Pointer; const SrcDataSize : Cardinal; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileInMemory(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcData : Pointer; const SrcDataSize : Cardinal; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileInMemory(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcData : Pointer; const SrcDataSize : Cardinal; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileInMemory(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcData : Pointer; const SrcDataSize : Cardinal; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileInMemory(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcData : Pointer; const SrcDataSize : Cardinal; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileInMemory(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcData : Pointer; const SrcDataSize : Cardinal; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileInMemory(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcData : Pointer; const SrcDataSize : Cardinal; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileInMemory(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcData : Pointer; const SrcDataSize : Cardinal; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileInMemory(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcData : Pointer; const SrcDataSize : Cardinal; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileInMemory(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcData : Pointer; const SrcDataSize : Cardinal; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileInMemory(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcData : Pointer; const SrcDataSize : Cardinal; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileInMemory(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcData : Pointer; const SrcDataSize : Cardinal; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileInMemory(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcData : Pointer; const SrcDataSize : Cardinal; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileInMemory(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcData : Pointer; const SrcDataSize : Cardinal; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileInMemory(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcData : Pointer; const SrcDataSize : Cardinal; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;
function D3DXLoadVolumeFromFileInMemory(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcData : Pointer; const SrcDataSize : Cardinal; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; overload;

(*)
[-------------------------------------------------------------------------------
[ D3DXLoadVolumeFromVolume:
[ -------------------------
[ Load volume from another volume (with color conversion)
[
[ Parameters:
[  pDestVolume
[      Destination volume, which will receive the image.
[  pDestPalette
[      Destination palette of 256 colors, or NULL
[  pDestBox
[      Destination box, or NULL for entire volume
[  pSrcVolume
[      Source volume
[  pSrcPalette
[      Source palette of 256 colors, or NULL
[  pSrcBox
[      Source box, or NULL for entire volume
[  Filter
[      D3DX_FILTER flags controlling how the image is filtered.
[      Or D3DX_DEFAULT for D3DX_FILTER_TRIANGLE.
[  ColorKey
[      Color to replace with transparent black, or 0 to disable colorkey.
[      This is always a 32-bit ARGB color, independent of the source image
[      format.  Alpha is significant, and should usually be set to FF for
[      opaque colorkeys.  (ex. Opaque black == 0xff000000)
[-------------------------------------------------------------------------------
(*)

function D3DXLoadVolumeFromVolume(const DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; const SrcVolume : IDirect3DVolume8; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadVolumeFromVolume(const DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; const SrcVolume : IDirect3DVolume8; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadVolumeFromVolume(const DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; const SrcVolume : IDirect3DVolume8; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadVolumeFromVolume(const DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; const SrcVolume : IDirect3DVolume8; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadVolumeFromVolume(const DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; const SrcVolume : IDirect3DVolume8; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadVolumeFromVolume(const DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; const SrcVolume : IDirect3DVolume8; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadVolumeFromVolume(const DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; const SrcVolume : IDirect3DVolume8; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadVolumeFromVolume(const DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; const SrcVolume : IDirect3DVolume8; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;

(*)
[-------------------------------------------------------------------------------
[ D3DXLoadVolumeFromMemory:
[ -------------------------
[ Load volume from memory.
[
[ Parameters:
[  pDestVolume
[      Destination volume, which will receive the image.
[  pDestPalette
[      Destination palette of 256 colors, or NULL
[  pDestBox
[      Destination box, or NULL for entire volume
[  pSrcMemory
[      Pointer to the top-left corner of the source volume in memory
[  SrcFormat
[      Pixel format of the source volume.
[  SrcRowPitch
[      Pitch of source image, in bytes.  For DXT formats, this number
[      should represent the size of one row of cells, in bytes.
[  SrcSlicePitch
[      Pitch of source image, in bytes.  For DXT formats, this number
[      should represent the size of one slice of cells, in bytes.
[  pSrcPalette
[      Source palette of 256 colors, or NULL
[  pSrcBox
[      Source box.
[  Filter
[      D3DX_FILTER flags controlling how the image is filtered.
[      Or D3DX_DEFAULT for D3DX_FILTER_TRIANGLE.
[  ColorKey
[      Color to replace with transparent black, or 0 to disable colorkey.
[      This is always a 32-bit ARGB color, independent of the source image
[      format.  Alpha is significant, and should usually be set to FF for
[      opaque colorkeys.  (ex. Opaque black == 0xff000000)
[-------------------------------------------------------------------------------
(*)

function D3DXLoadVolumeFromMemory(const DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcMemory : Pointer; const SrcFormat : TD3DFormat; const SrcRowPitch, SrcSlicePitch : Cardinal; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadVolumeFromMemory(const DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcMemory : Pointer; const SrcFormat : TD3DFormat; const SrcRowPitch, SrcSlicePitch : Cardinal; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadVolumeFromMemory(const DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcMemory : Pointer; const SrcFormat : TD3DFormat; const SrcRowPitch, SrcSlicePitch : Cardinal; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadVolumeFromMemory(const DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcMemory : Pointer; const SrcFormat : TD3DFormat; const SrcRowPitch, SrcSlicePitch : Cardinal; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadVolumeFromMemory(const DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcMemory : Pointer; const SrcFormat : TD3DFormat; const SrcRowPitch, SrcSlicePitch : Cardinal; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadVolumeFromMemory(const DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcMemory : Pointer; const SrcFormat : TD3DFormat; const SrcRowPitch, SrcSlicePitch : Cardinal; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadVolumeFromMemory(const DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcMemory : Pointer; const SrcFormat : TD3DFormat; const SrcRowPitch, SrcSlicePitch : Cardinal; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;
function D3DXLoadVolumeFromMemory(const DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcMemory : Pointer; const SrcFormat : TD3DFormat; const SrcRowPitch, SrcSlicePitch : Cardinal; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; overload;

(*)
[-------------------------------------------------------------------------------
[ D3DXSaveVolumeToFile:
[ ---------------------
[ Save a volume to a image file.
[
[ Parameters:
[  pDestFile
[      File name of the destination file
[  DestFormat
[      D3DXIMAGE_FILEFORMAT specifying file format to use when saving.
[  pSrcVolume
[      Source volume, containing the image to be saved
[  pSrcPalette
[      Source palette of 256 colors, or NULL
[  pSrcBox
[      Source box, or NULL for the entire volume
[-------------------------------------------------------------------------------
(*)

function D3DXSaveVolumeToFileA(DestFile : PAnsiChar; DestFormat : TD3DXImageFileFormat; SrcVolume : IDirect3DVolume8; SrcPalette : PPaletteEntry; SrcBox : PD3DBox) : HResult; stdcall; overload;
function D3DXSaveVolumeToFileA(DestFile : PAnsiChar; DestFormat : TD3DXImageFileFormat; SrcVolume : IDirect3DVolume8; var SrcPalette : TPaletteEntry; SrcBox : PD3DBox) : HResult; stdcall; overload;
function D3DXSaveVolumeToFileA(DestFile : PAnsiChar; DestFormat : TD3DXImageFileFormat; SrcVolume : IDirect3DVolume8; SrcPalette : PPaletteEntry; var SrcBox : TD3DBox) : HResult; stdcall; overload;
function D3DXSaveVolumeToFileA(DestFile : PAnsiChar; DestFormat : TD3DXImageFileFormat; SrcVolume : IDirect3DVolume8; var SrcPalette : TPaletteEntry; var SrcBox : TD3DBox) : HResult; stdcall; overload;

function D3DXSaveVolumeToFileW(DestFile : PWideChar; DestFormat : TD3DXImageFileFormat; SrcVolume : IDirect3DVolume8; SrcPalette : PPaletteEntry; SrcBox : PD3DBox) : HResult; stdcall; overload;
function D3DXSaveVolumeToFileW(DestFile : PWideChar; DestFormat : TD3DXImageFileFormat; SrcVolume : IDirect3DVolume8; var SrcPalette : TPaletteEntry; SrcBox : PD3DBox) : HResult; stdcall; overload;
function D3DXSaveVolumeToFileW(DestFile : PWideChar; DestFormat : TD3DXImageFileFormat; SrcVolume : IDirect3DVolume8; SrcPalette : PPaletteEntry; var SrcBox : TD3DBox) : HResult; stdcall; overload;
function D3DXSaveVolumeToFileW(DestFile : PWideChar; DestFormat : TD3DXImageFileFormat; SrcVolume : IDirect3DVolume8; var SrcPalette : TPaletteEntry; var SrcBox : TD3DBox) : HResult; stdcall; overload;

{$IFDEF UNICODE}
function D3DXSaveVolumeToFile(DestFile : PWideChar; DestFormat : TD3DXImageFileFormat; SrcVolume : IDirect3DVolume8; SrcPalette : PPaletteEntry; SrcBox : PD3DBox) : HResult; stdcall; overload;
function D3DXSaveVolumeToFile(DestFile : PWideChar; DestFormat : TD3DXImageFileFormat; SrcVolume : IDirect3DVolume8; var SrcPalette : TPaletteEntry; SrcBox : PD3DBox) : HResult; stdcall; overload;
function D3DXSaveVolumeToFile(DestFile : PWideChar; DestFormat : TD3DXImageFileFormat; SrcVolume : IDirect3DVolume8; SrcPalette : PPaletteEntry; var SrcBox : TD3DBox) : HResult; stdcall; overload;
function D3DXSaveVolumeToFile(DestFile : PWideChar; DestFormat : TD3DXImageFileFormat; SrcVolume : IDirect3DVolume8; var SrcPalette : TPaletteEntry; var SrcBox : TD3DBox) : HResult; stdcall; overload;
{$ELSE}
function D3DXSaveVolumeToFile(DestFile : PAnsiChar; DestFormat : TD3DXImageFileFormat; SrcVolume : IDirect3DVolume8; SrcPalette : PPaletteEntry; SrcBox : PD3DBox) : HResult; stdcall; overload;
function D3DXSaveVolumeToFile(DestFile : PAnsiChar; DestFormat : TD3DXImageFileFormat; SrcVolume : IDirect3DVolume8; var SrcPalette : TPaletteEntry; SrcBox : PD3DBox) : HResult; stdcall; overload;
function D3DXSaveVolumeToFile(DestFile : PAnsiChar; DestFormat : TD3DXImageFileFormat; SrcVolume : IDirect3DVolume8; SrcPalette : PPaletteEntry; var SrcBox : TD3DBox) : HResult; stdcall; overload;
function D3DXSaveVolumeToFile(DestFile : PAnsiChar; DestFormat : TD3DXImageFileFormat; SrcVolume : IDirect3DVolume8; var SrcPalette : TPaletteEntry; var SrcBox : TD3DBox) : HResult; stdcall; overload;
{$ENDIF}

(*)
[-------------------------------------------------------------------------------
[ Create/Save Texture APIs
[-------------------------------------------------------------------------------
(*)

(*)
[-------------------------------------------------------------------------------
[ D3DXCheckTextureRequirements:
[ -----------------------------
[ Checks texture creation parameters.  If parameters are invalid, this
[ function returns corrected parameters.
[
[ Parameters:
[
[  pDevice
[      The D3D device to be used
[  pWidth, pHeight, pDepth, pSize
[      Desired size in pixels, or NULL.  Returns corrected size.
[  pNumMipLevels
[      Number of desired mipmap levels, or NULL.  Returns corrected number.
[  Usage
[      Texture usage flags
[  pFormat
[      Desired pixel format, or NULL.  Returns corrected format.
[  Pool
[      Memory pool to be used to create texture
[-------------------------------------------------------------------------------
(*)

function D3DXCheckTextureRequirements(Device : IDirect3DDevice8; Width, Height, NumMipLevels : PCardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckTextureRequirements(Device : IDirect3DDevice8; var Width : Cardinal; Height, NumMipLevels : PCardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckTextureRequirements(Device : IDirect3DDevice8; Width : PCardinal; var Height : Cardinal; NumMipLevels : PCardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckTextureRequirements(Device : IDirect3DDevice8; var Width, Height : Cardinal; NumMipLevels : PCardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckTextureRequirements(Device : IDirect3DDevice8; Width, Height : PCardinal; var NumMipLevels : Cardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckTextureRequirements(Device : IDirect3DDevice8; var Width : Cardinal; Height : PCardinal; var NumMipLevels : Cardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckTextureRequirements(Device : IDirect3DDevice8; Width : PCardinal; var Height, NumMipLevels : Cardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckTextureRequirements(Device : IDirect3DDevice8; var Width, Height, NumMipLevels : Cardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckTextureRequirements(Device : IDirect3DDevice8; Width, Height, NumMipLevels : PCardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckTextureRequirements(Device : IDirect3DDevice8; var Width : Cardinal; Height, NumMipLevels : PCardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckTextureRequirements(Device : IDirect3DDevice8; Width : PCardinal; var Height : Cardinal; NumMipLevels : PCardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckTextureRequirements(Device : IDirect3DDevice8; var Width, Height : Cardinal; NumMipLevels : PCardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckTextureRequirements(Device : IDirect3DDevice8; Width, Height : PCardinal; var NumMipLevels : Cardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckTextureRequirements(Device : IDirect3DDevice8; var Width : Cardinal; Height : PCardinal; var NumMipLevels : Cardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckTextureRequirements(Device : IDirect3DDevice8; Width : PCardinal; var Height, NumMipLevels : Cardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckTextureRequirements(Device : IDirect3DDevice8; var Width, Height, NumMipLevels : Cardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;

function D3DXCheckCubeTextureRequirements(Device : IDirect3DDevice8; Size, NumMipLevels : PCardinal; const Usage : LongWord; Format : PD3DFormat; const Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckCubeTextureRequirements(Device : IDirect3DDevice8; var Size : Cardinal; NumMipLevels : PCardinal; const Usage : LongWord; Format : PD3DFormat; const Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckCubeTextureRequirements(Device : IDirect3DDevice8; Size : PCardinal; var NumMipLevels : Cardinal; const Usage : LongWord; Format : PD3DFormat; const Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckCubeTextureRequirements(Device : IDirect3DDevice8; var Size, NumMipLevels : Cardinal; const Usage : LongWord; Format : PD3DFormat; const Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckCubeTextureRequirements(Device : IDirect3DDevice8; Size, NumMipLevels : PCardinal; const Usage : LongWord; var Format : TD3DFormat; const Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckCubeTextureRequirements(Device : IDirect3DDevice8; var Size : Cardinal; NumMipLevels : PCardinal; const Usage : LongWord; var Format : TD3DFormat; const Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckCubeTextureRequirements(Device : IDirect3DDevice8; Size : PCardinal; var NumMipLevels : Cardinal; const Usage : LongWord; var Format : TD3DFormat; const Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckCubeTextureRequirements(Device : IDirect3DDevice8; var Size, NumMipLevels : Cardinal; const Usage : LongWord; var Format : TD3DFormat; const Pool : TD3DPool) : HResult; stdcall; overload;


function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; Width, Height, Depth, NumMipLevels : PCardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; var Width : Cardinal; Height, Depth, NumMipLevels : PCardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; Width : PCardinal; var Height : Cardinal; Depth, NumMipLevels : PCardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; var Width, Height : Cardinal; Depth, NumMipLevels : PCardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; Width, Height : PCardinal; var Depth : Cardinal; NumMipLevels : PCardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; var Width : Cardinal; Height : PCardinal; var Depth : Cardinal; NumMipLevels : PCardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; Width : PCardinal; var Height, Depth : Cardinal; NumMipLevels : PCardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; var Width, Height, Depth : Cardinal; NumMipLevels : PCardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; Width, Height, Depth : PCardinal; var NumMipLevels : Cardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; var Width : Cardinal; Height, Depth : PCardinal; var NumMipLevels : Cardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; Width : PCardinal; var Height : Cardinal; Depth : PCardinal; var NumMipLevels : Cardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; var Width, Height : Cardinal; Depth : PCardinal; var NumMipLevels : Cardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; Width, Height : PCardinal; var Depth, NumMipLevels : Cardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; var Width : Cardinal; Height : PCardinal; var Depth, NumMipLevels : Cardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; Width : PCardinal; var Height, Depth, NumMipLevels : Cardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; var Width, Height, Depth, NumMipLevels : Cardinal; Usage : LongWord; Format : PD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; Width, Height, Depth, NumMipLevels : PCardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; var Width : Cardinal; Height, Depth, NumMipLevels : PCardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; Width : PCardinal; var Height : Cardinal; Depth, NumMipLevels : PCardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; var Width, Height : Cardinal; Depth, NumMipLevels : PCardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; Width, Height : PCardinal; var Depth : Cardinal; NumMipLevels : PCardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; var Width : Cardinal; Height : PCardinal; var Depth : Cardinal; NumMipLevels : PCardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; Width : PCardinal; var Height, Depth : Cardinal; NumMipLevels : PCardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; var Width, Height, Depth : Cardinal; NumMipLevels : PCardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; Width, Height, Depth : PCardinal; var NumMipLevels : Cardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; var Width : Cardinal; Height, Depth : PCardinal; var NumMipLevels : Cardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; Width : PCardinal; var Height : Cardinal; Depth : PCardinal; var NumMipLevels : Cardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; var Width, Height : Cardinal; Depth : PCardinal; var NumMipLevels : Cardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; Width, Height : PCardinal; var Depth, NumMipLevels : Cardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; var Width : Cardinal; Height : PCardinal; var Depth, NumMipLevels : Cardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; Width : PCardinal; var Height, Depth, NumMipLevels : Cardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;
function D3DXCheckVolumeTextureRequirements(Device : IDirect3DDevice8; var Width, Height, Depth, NumMipLevels : Cardinal; Usage : LongWord; var Format : TD3DFormat; Pool : TD3DPool) : HResult; stdcall; overload;

(*)
[-------------------------------------------------------------------------------
[ D3DXCreateTexture:
[ ------------------
[ Create an empty texture
[
[ Parameters:
[
[  pDevice
[      The D3D device with which the texture is going to be used.
[  Width, Height, Depth, Size
[      size in pixels; these must be non-zero
[  MipLevels
[      number of mip levels desired; if zero or D3DX_DEFAULT, a complete
[      mipmap chain will be created.
[  Usage
[      Texture usage flags
[  Format
[      Pixel format.
[  Pool
[      Memory pool to be used to create texture
[  ppTexture, ppCubeTexture, ppVolumeTexture
[      The texture object that will be created
[-------------------------------------------------------------------------------
(*)

function D3DXCreateTexture(Device : IDirect3DDevice8; Width, Height, MipLevels : Cardinal; Usage : LongWord; Format : TD3DFormat; Pool : TD3DPool; out Texture : IDirect3DTexture8) : HResult; stdcall;

function D3DXCreateCubeTexture(Device : IDirect3DDevice8; Size, MipLevels : Cardinal; Usage : LongWord; Format : TD3DFormat; Pool : TD3DPool; out Texture : IDirect3DCubeTexture8) : HResult; stdcall;

function D3DXCreateVolumeTexture(Device : IDirect3DDevice8; Width, Height, Depth, MipLevels : Cardinal; Usage : LongWord; Format : TD3DFormat; Pool : TD3DPool; out Texture : IDirect3DVolumeTexture8) : HResult; stdcall;


(*)
[-------------------------------------------------------------------------------
[ D3DXCreateTextureFromFile/Resource:
[ -----------------------------------
[ Create a texture object from a file or resource.
[
[ Parameters:
[
[  pDevice
[      The D3D device with which the texture is going to be used.
[  pSrcFile
[      File name.
[  hSrcModule
[      Module handle. if NULL, current module will be used.
[  pSrcResource
[      Resource name in module
[  pvSrcData
[      Pointer to file in memory.
[  SrcDataSize
[      Size in bytes of file in memory.
[  Width, Height, Depth, Size
[      Size in pixels; if zero or D3DX_DEFAULT, the size will be taken
[      from the file.
[  MipLevels
[      Number of mip levels;  if zero or D3DX_DEFAULT, a complete mipmap
[      chain will be created.
[  Usage
[      Texture usage flags
[  Format
[      Desired pixel format.  If D3DFMT_UNKNOWN, the format will be
[      taken from the file.
[  Pool
[      Memory pool to be used to create texture
[  Filter
[      D3DX_FILTER flags controlling how the image is filtered.
[      Or D3DX_DEFAULT for D3DX_FILTER_TRIANGLE.
[  MipFilter
[      D3DX_FILTER flags controlling how each miplevel is filtered.
[      Or D3DX_DEFAULT for D3DX_FILTER_BOX,
[  ColorKey
[      Color to replace with transparent black, or 0 to disable colorkey.
[      This is always a 32-bit ARGB color, independent of the source image
[      format.  Alpha is significant, and should usually be set to FF for
[      opaque colorkeys.  (ex. Opaque black == 0xff000000)
[  pSrcInfo
[      Pointer to a D3DXIMAGE_INFO structure to be filled in with the
[      description of the data in the source image file, or NULL.
[  pPalette
[      256 color palette to be filled in, or NULL
[  ppTexture, ppCubeTexture, ppVolumeTexture
[      The texture object that will be created
[-------------------------------------------------------------------------------
(*)


// FromFile

function D3DXCreateTextureFromFileA(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; out Texture : IDirect3DTexture8) : HResult; stdcall;

function D3DXCreateTextureFromFileW(const Device : IDirect3DDevice8; SrcFile : PWideChar; out Texture : IDirect3DTexture8) : HResult; stdcall;

{$IFDEF UNICODE}
function D3DXCreateTextureFromFile(const Device : IDirect3DDevice8; SrcFile : PWideChar; out Texture : IDirect3DTexture8) : HResult; stdcall;
{$ELSE}
function D3DXCreateTextureFromFile(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; out Texture : IDirect3DTexture8) : HResult; stdcall;
{$ENDIF}

function D3DXCreateCubeTextureFromFileA(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall;

function D3DXCreateCubeTextureFromFileW(const Device : IDirect3DDevice8; SrcFile : PWideChar; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall;

{$IFDEF UNICODE}
function D3DXCreateCubeTextureFromFile(const Device : IDirect3DDevice8; SrcFile : PWideChar; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall;
{$ELSE}
function D3DXCreateCubeTextureFromFile(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall;
{$ENDIF}

function D3DXCreateVolumeTextureFromFileA(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall;

function D3DXCreateVolumeTextureFromFileW(const Device : IDirect3DDevice8; SrcFile : PWideChar; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall;

{$IFDEF UNICODE}
function D3DXCreateVolumeTextureFromFile(const Device : IDirect3DDevice8; SrcFile : PWideChar; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall;
{$ELSE}
function D3DXCreateVolumeTextureFromFile(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall;
{$ENDIF}


// FromResource

function D3DXCreateTextureFromResourceA(const Device : IDirect3DDevice8; const SrcModule : HMODULE; SrcResource : PAnsiChar; out Texture : IDirect3DTexture8) : HResult; stdcall;

function D3DXCreateTextureFromResourceW(const Device : IDirect3DDevice8; const SrcModule : HMODULE; SrcResource : PWideChar; out Texture : IDirect3DTexture8) : HResult; stdcall;

{$IFDEF UNICODE}
function D3DXCreateTextureFromResource(const Device : IDirect3DDevice8; const SrcModule : HMODULE; SrcResource : PWideChar; out Texture : IDirect3DTexture8) : HResult; stdcall;
{$ELSE}
function D3DXCreateTextureFromResource(const Device : IDirect3DDevice8; const SrcModule : HMODULE; SrcResource : PAnsiChar; out Texture : IDirect3DTexture8) : HResult; stdcall;
{$ENDIF}

function D3DXCreateCubeTextureFromResourceA(const Device : IDirect3DDevice8; const SrcModule : HMODULE; SrcResource : PAnsiChar; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall;

function D3DXCreateCubeTextureFromResourceW(const Device : IDirect3DDevice8; const SrcModule : HMODULE; SrcResource : PWideChar; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall;

{$IFDEF UNICODE}
function D3DXCreateCubeTextureFromResource(const Device : IDirect3DDevice8; const SrcModule : HMODULE; SrcResource : PWideChar; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall;
{$ELSE}
function D3DXCreateCubeTextureFromResource(const Device : IDirect3DDevice8; const SrcModule : HMODULE; SrcResource : PAnsiChar; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall;
{$ENDIF}


function D3DXCreateVolumeTextureFromResourceA(const Device : IDirect3DDevice8; const SrcModule : HMODULE; SrcResource : PAnsiChar; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall;

function D3DXCreateVolumeTextureFromResourceW(const Device : IDirect3DDevice8; const SrcModule : HMODULE; SrcResource : PWideChar; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall;

{$IFDEF UNICODE}
function D3DXCreateVolumeTextureFromResource(const Device : IDirect3DDevice8; const SrcModule : HMODULE; SrcResource : PWideChar; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall;
{$ELSE}
function D3DXCreateVolumeTextureFromResource(const Device : IDirect3DDevice8; const SrcModule : HMODULE; SrcResource : PAnsiChar; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall;
{$ENDIF}

// FromFileEx

function D3DXCreateTextureFromFileExA(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromFileExA(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromFileExA(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromFileExA(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;

function D3DXCreateTextureFromFileExW(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromFileExW(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromFileExW(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromFileExW(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;

{$IFDEF UNICODE}
function D3DXCreateTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
{$ELSE}
function D3DXCreateTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
{$ENDIF}


function D3DXCreateCubeTextureFromFileExA(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileExA(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileExA(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileExA(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;

function D3DXCreateCubeTextureFromFileExW(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileExW(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileExW(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileExW(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;

{$IFDEF UNICODE}
function D3DXCreateCubeTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
{$ELSE}
function D3DXCreateCubeTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
{$ENDIF}

function D3DXCreateVolumeTextureFromFileExA(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileExA(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileExA(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileExA(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;

function D3DXCreateVolumeTextureFromFileExW(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileExW(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileExW(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileExW(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;

{$IFDEF UNICODE}
function D3DXCreateVolumeTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PWideChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
{$ELSE}
function D3DXCreateVolumeTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileEx(const Device : IDirect3DDevice8; SrcFile : PAnsiChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
{$ENDIF}

// FromResourceEx


function D3DXCreateTextureFromResourceExA(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromResourceExA(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromResourceExA(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromResourceExA(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;

function D3DXCreateTextureFromResourceExW(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromResourceExW(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromResourceExW(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromResourceExW(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;

{$IFDEF UNICODE}
function D3DXCreateTextureFromResourceEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromResourceEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromResourceEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromResourceEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
{$ELSE}
function D3DXCreateTextureFromResourceEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromResourceEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromResourceEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromResourceEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
{$ENDIF}

function D3DXCreateCubeTextureFromFileExA(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileExA(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileExA(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileExA(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;

function D3DXCreateCubeTextureFromFileExW(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileExW(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileExW(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileExW(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;

{$IFDEF UNICODE}
function D3DXCreateCubeTextureFromFileEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
{$ELSE}
function D3DXCreateCubeTextureFromFileEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
{$ENDIF}

function D3DXCreateVolumeTextureFromFileExA(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileExA(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileExA(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileExA(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;

function D3DXCreateVolumeTextureFromFileExW(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileExW(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileExW(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileExW(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;

{$IFDEF UNICODE}
function D3DXCreateVolumeTextureFromFileEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PWideChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
{$ELSE}
function D3DXCreateVolumeTextureFromFileEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileEx(const Device : IDirect3DDevice8; const SrcModule : HMODULE; const SrcResource : PAnsiChar; const Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
{$ENDIF}

// FromFileInMemory

function D3DXCreateTextureFromFileInMemory(const Device : IDirect3DDevice8; SrcData : Pointer; const SrcDataSize : Cardinal; out Texture : IDirect3DTexture8) : HResult; stdcall;

function D3DXCreateCubeTextureFromFileInMemory(const Device : IDirect3DDevice8; SrcData : Pointer; const SrcDataSize : Cardinal; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall;

function D3DXCreateVolumeTextureFromFileInMemory(const Device : IDirect3DDevice8; SrcData : Pointer; const SrcDataSize : Cardinal; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall;

// FromFileInMemoryEx

function D3DXCreateTextureFromFileInMemoryEx(const Device : IDirect3DDevice8; SrcData : Pointer; const SrcDataSize, Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromFileInMemoryEx(const Device : IDirect3DDevice8; SrcData : Pointer; const SrcDataSize, Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromFileInMemoryEx(const Device : IDirect3DDevice8; SrcData : Pointer; const SrcDataSize, Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;
function D3DXCreateTextureFromFileInMemoryEx(const Device : IDirect3DDevice8; SrcData : Pointer; const SrcDataSize, Width, Height, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out Texture : IDirect3DTexture8) : HResult; stdcall; overload;

function D3DXCreateCubeTextureFromFileInMemoryEx(const Device : IDirect3DDevice8; SrcData : Pointer; const SrcDataSize, Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileInMemoryEx(const Device : IDirect3DDevice8; SrcData : Pointer; const SrcDataSize, Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileInMemoryEx(const Device : IDirect3DDevice8; SrcData : Pointer; const SrcDataSize, Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;
function D3DXCreateCubeTextureFromFileInMemoryEx(const Device : IDirect3DDevice8; SrcData : Pointer; const SrcDataSize, Size, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out CubeTexture : IDirect3DCubeTexture8) : HResult; stdcall; overload;

function D3DXCreateVolumeTextureFromFileInMemoryEx(const Device : IDirect3DDevice8; SrcData : Pointer; const SrcDataSize, Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; Palette : PPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileInMemoryEx(const Device : IDirect3DDevice8; SrcData : Pointer; const SrcDataSize, Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; Palette : PPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileInMemoryEx(const Device : IDirect3DDevice8; SrcData : Pointer; const SrcDataSize, Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo; var Palette : TPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;
function D3DXCreateVolumeTextureFromFileInMemoryEx(const Device : IDirect3DDevice8; SrcData : Pointer; const SrcDataSize, Width, Height, Depth, MipLevels : Cardinal; const Usage : LongWord; const Format : TD3DFormat; const Pool : TD3DPool; const Filter, MipFilter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo; var Palette : TPaletteEntry; out VolumeTexture : IDirect3DVolumeTexture8) : HResult; stdcall; overload;

(*)
[-------------------------------------------------------------------------------
[ D3DXSaveTextureToFile:
[ ----------------------
[ Save a texture to a file.
[
[ Parameters:
[  pDestFile
[      File name of the destination file
[  DestFormat
[      D3DXIMAGE_FILEFORMAT specifying file format to use when saving.
[  pSrcTexture
[      Source texture, containing the image to be saved
[  pSrcPalette
[      Source palette of 256 colors, or NULL
[-------------------------------------------------------------------------------
(*)


function D3DXSaveTextureToFileA(const DestFile : PAnsiChar; const DestFormat : TD3DXImageFileFormat; const SrcTexture : IDirect3DBaseTexture8; SrcPalette : PPaletteEntry) : HResult; stdcall; overload;
function D3DXSaveTextureToFileA(const DestFile : PAnsiChar; const DestFormat : TD3DXImageFileFormat; const SrcTexture : IDirect3DBaseTexture8; var SrcPalette : TPaletteEntry) : HResult; stdcall; overload;

function D3DXSaveTextureToFileW(const DestFile : PWideChar; const DestFormat : TD3DXImageFileFormat; const SrcTexture : IDirect3DBaseTexture8; SrcPalette : PPaletteEntry) : HResult; stdcall; overload;
function D3DXSaveTextureToFileW(const DestFile : PWideChar; const DestFormat : TD3DXImageFileFormat; const SrcTexture : IDirect3DBaseTexture8; var SrcPalette : TPaletteEntry) : HResult; stdcall; overload;

{$IFDEF UNICODE}
function D3DXSaveTextureToFile(const DestFile : PWideChar; const DestFormat : TD3DXImageFileFormat; const SrcTexture : IDirect3DBaseTexture8; SrcPalette : PPaletteEntry) : HResult; stdcall; overload;
function D3DXSaveTextureToFile(const DestFile : PWideChar; const DestFormat : TD3DXImageFileFormat; const SrcTexture : IDirect3DBaseTexture8; var SrcPalette : TPaletteEntry) : HResult; stdcall; overload;
{$ELSE}
function D3DXSaveTextureToFile(const DestFile : PAnsiChar; const DestFormat : TD3DXImageFileFormat; const SrcTexture : IDirect3DBaseTexture8; SrcPalette : PPaletteEntry) : HResult; stdcall; overload;
function D3DXSaveTextureToFile(const DestFile : PAnsiChar; const DestFormat : TD3DXImageFileFormat; const SrcTexture : IDirect3DBaseTexture8; var SrcPalette : TPaletteEntry) : HResult; stdcall; overload;
{$ENDIF}

(*)
[-------------------------------------------------------------------------------
[ Misc Texture APIs
[-------------------------------------------------------------------------------
(*)
(*)
[-------------------------------------------------------------------------------
[ D3DXFilterTexture:
[ ------------------
[ Filters mipmaps levels of a texture.
[
[ Parameters:
[  pBaseTexture
[      The texture object to be filtered
[  pPalette
[      256 color palette to be used, or NULL for non-palettized formats
[  SrcLevel
[      The level whose image is used to generate the subsequent levels.
[  Filter
[      D3DX_FILTER flags controlling how each miplevel is filtered.
[      Or D3DX_DEFAULT for D3DX_FILTER_BOX,
[-------------------------------------------------------------------------------
(*)

function D3DXFilterTexture(BaseTexture : IDirect3DBaseTexture8; Palette : PPaletteEntry; const SrcLevel : Cardinal; Filter : LongWord) : HResult; stdcall; overload;
function D3DXFilterTexture(BaseTexture : IDirect3DBaseTexture8; var Palette : TPaletteEntry; const SrcLevel : Cardinal; Filter : LongWord) : HResult; stdcall; overload;

function D3DXFilterCubeTexture(BaseTexture : IDirect3DBaseTexture8; Palette : PPaletteEntry; const SrcLevel : Cardinal; Filter : LongWord) : HResult; stdcall; overload;
function D3DXFilterCubeTexture(BaseTexture : IDirect3DBaseTexture8; var Palette : TPaletteEntry; const SrcLevel : Cardinal; Filter : LongWord) : HResult; stdcall; overload;

function D3DXFilterVolumeTexture(BaseTexture : IDirect3DBaseTexture8; Palette : PPaletteEntry; const SrcLevel : Cardinal; Filter : LongWord) : HResult; stdcall; overload;
function D3DXFilterVolumeTexture(BaseTexture : IDirect3DBaseTexture8; var Palette : TPaletteEntry; const SrcLevel : Cardinal; Filter : LongWord) : HResult; stdcall; overload;


(*)
[-------------------------------------------------------------------------------
[ D3DXFillTexture:
[ ----------------
[ Uses a user provided function to fill each texel of each mip level of a
[ given texture.
[
[ Paramters:
[  pTexture, pCubeTexture, pVolumeTexture
[      Pointer to the texture to be filled.
[  pFunction
[      Pointer to user provided evalutor function which will be used to
[      compute the value of each texel.
[  pData
[      Pointer to an arbitrary block of user defined data.  This pointer
[      will be passed to the function provided in pFunction
[-------------------------------------------------------------------------------
(*)

function D3DXFillTexture(Texture : IDirect3DTexture8; FillFunction : TD3DXFILL2D; Data : Pointer) : HResult; stdcall; 

function D3DXFillCubeTexture(CubeTexture : IDirect3DCubeTexture8; FillFunction : TD3DXFILL3D; Data : Pointer) : HResult; stdcall;

function D3DXFillVolumeTexture(VolumeTexture : IDirect3DVolumeTexture8; FillFunction : TD3DXFILL3D; Data : Pointer) : HResult; stdcall;

(*)
[-------------------------------------------------------------------------------
// D3DXComputeNormalMap:
// ---------------------
// Converts a height map into a normal map.  The (x,y,z) components of each
// normal are mapped to the (r,g,b) channels of the output texture.
//
// Parameters
//  pTexture
//      Pointer to the destination texture
//  pSrcTexture
//      Pointer to the source heightmap texture
//  pSrcPalette
//      Source palette of 256 colors, or NULL
//  Flags
//      D3DX_NORMALMAP flags
//  Channel
//      D3DX_CHANNEL specifying source of height information
//  Amplitude
//      The constant value which the height information is multiplied by.
[-------------------------------------------------------------------------------
(*)

function D3DXComputeNormalMap(Texture, SrcTexture : IDirect3DTexture8; SrcPalette : PPaletteEntry; const Flags, Channel : LongWord; const Amplitude : Single) : HResult; stdcall; overload;
function D3DXComputeNormalMap(Texture, SrcTexture : IDirect3DTexture8; var SrcPalette : TPaletteEntry; const Flags, Channel : LongWord; const Amplitude : Single) : HResult; stdcall; overload;


(*)
[-------------------------------------------------------------------------------
[  Copyright (C) Microsoft Corporation.  All Rights Reserved.
[
[  File:       d3dx8mesh.h
[  Content:    D3DX mesh types and functions
[-------------------------------------------------------------------------------
(*)

const
  IID_ID3DXBaseMesh : TGUID = '{2A835771-BF4D-43f4-8E14-82A809F17D8A}';
  IID_ID3DXMesh     : TGUID = '{CCAE5C3B-4DD1-4d0f-997E-4684CA64557F}';
  IID_ID3DXPMesh    : TGUID = '{19FBE386-C282-4659-97BD-CB869B084A6C}';
  IID_ID3DXSPMesh   : TGUID = '{4E3CA05C-D4FF-4d11-8A02-16459E08F6F4}';
  IID_ID3DXSkinMesh : TGUID = '{8DB06ECC-EBFC-408a-9404-3074B4773515}';

// Mesh options - lower 3 bytes only, upper byte used by _D3DXMESHOPT option flags

type TD3DXMesh = {$IFNDEF NOENUMS}({$ELSE}LongWord;{$ENDIF}
{$IFDEF NOENUMS}const{$ENDIF}
    D3DXMESH_32BIT                  = $00001{$IFNDEF NOENUMS},{$ELSE};{$ENDIF} // If set, then use 32 bit indices, if not set use 16 bit indices.
    D3DXMESH_DONOTCLIP              = $00002{$IFNDEF NOENUMS},{$ELSE};{$ENDIF} // Use D3DUSAGE_DONOTCLIP for VB & IB.
    D3DXMESH_POINTS                 = $00004{$IFNDEF NOENUMS},{$ELSE};{$ENDIF} // Use D3DUSAGE_POINTS for VB & IB.
    D3DXMESH_RTPATCHES              = $00008{$IFNDEF NOENUMS},{$ELSE};{$ENDIF} // Use D3DUSAGE_RTPATCHES for VB & IB.
    D3DXMESH_NPATCHES               = $04000{$IFNDEF NOENUMS},{$ELSE};{$ENDIF} // Use D3DUSAGE_NPATCHES for VB & IB.
    D3DXMESH_VB_SYSTEMMEM           = $00010{$IFNDEF NOENUMS},{$ELSE};{$ENDIF} // Use D3DPOOL_SYSTEMMEM for VB. Overrides D3DXMESH_MANAGEDVERTEXBUFFER
    D3DXMESH_VB_MANAGED             = $00020{$IFNDEF NOENUMS},{$ELSE};{$ENDIF} // Use D3DPOOL_MANAGED for VB.
    D3DXMESH_VB_WRITEONLY           = $00040{$IFNDEF NOENUMS},{$ELSE};{$ENDIF} // Use D3DUSAGE_WRITEONLY for VB.
    D3DXMESH_VB_DYNAMIC             = $00080{$IFNDEF NOENUMS},{$ELSE};{$ENDIF} // Use D3DUSAGE_DYNAMIC for VB.
    D3DXMESH_VB_SOFTWAREPROCESSING  = $08000{$IFNDEF NOENUMS},{$ELSE};{$ENDIF} // Use D3DUSAGE_SOFTWAREPROCESSING for VB.
    D3DXMESH_IB_SYSTEMMEM           = $00100{$IFNDEF NOENUMS},{$ELSE};{$ENDIF} // Use D3DPOOL_SYSTEMMEM for IB. Overrides D3DXMESH_MANAGEDINDEXBUFFER
    D3DXMESH_IB_MANAGED             = $00200{$IFNDEF NOENUMS},{$ELSE};{$ENDIF} // Use D3DPOOL_MANAGED for IB.
    D3DXMESH_IB_WRITEONLY           = $00400{$IFNDEF NOENUMS},{$ELSE};{$ENDIF} // Use D3DUSAGE_WRITEONLY for IB.
    D3DXMESH_IB_DYNAMIC             = $00800{$IFNDEF NOENUMS},{$ELSE};{$ENDIF} // Use D3DUSAGE_DYNAMIC for IB.
    D3DXMESH_IB_SOFTWAREPROCESSING  = $10000{$IFNDEF NOENUMS},{$ELSE};{$ENDIF} // Use D3DUSAGE_SOFTWAREPROCESSING for IB.

    D3DXMESH_VB_SHARE               = $01000{$IFNDEF NOENUMS},{$ELSE};{$ENDIF} // Valid for Clone* calls only, forces cloned mesh/pmesh to share vertex buffer

    D3DXMESH_USEHWONLY              = $02000{$IFNDEF NOENUMS},{$ELSE};{$ENDIF} // Valid for ID3DXSkinMesh::ConvertToBlendedMesh

    // Helper options
    D3DXMESH_SYSTEMMEM              = $00110{$IFNDEF NOENUMS},{$ELSE};{$ENDIF} // D3DXMESH_VB_SYSTEMMEM | D3DXMESH_IB_SYSTEMMEM
    D3DXMESH_MANAGED                = $00220{$IFNDEF NOENUMS},{$ELSE};{$ENDIF} // D3DXMESH_VB_MANAGED | D3DXMESH_IB_MANAGED
    D3DXMESH_WRITEONLY              = $00440{$IFNDEF NOENUMS},{$ELSE};{$ENDIF} // D3DXMESH_VB_WRITEONLY | D3DXMESH_IB_WRITEONLY
    D3DXMESH_DYNAMIC                = $00880{$IFNDEF NOENUMS},{$ELSE};{$ENDIF} // D3DXMESH_VB_DYNAMIC | D3DXMESH_IB_DYNAMIC
    D3DXMESH_SOFTWAREPROCESSING     = $18000{$IFNDEF NOENUMS}){$ENDIF};        // D3DXMESH_VB_SOFTWAREPROCESSING | D3DXMESH_IB_SOFTWAREPROCESSING

// option field values for specifying min value in D3DXGeneratePMesh and D3DXSimplifyMesh
type
  TD3DXMeshSimp = {$IFNDEF NOENUMS}({$ELSE}LongWord;{$ENDIF}
  {$IFDEF NOENUMS}const{$ENDIF}
    D3DXMESHSIMP_VERTEX   = $1{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}
    D3DXMESHSIMP_FACE     = $2{$IFNDEF NOENUMS}){$ENDIF};

type
  TMAXFVFDECLSize = {$IFNDEF NOENUMS}({$ELSE}LongWord;{$ENDIF}
  {$IFDEF NOENUMS}const{$ENDIF}
    MAX_FVF_DECL_SIZE = 20{$IFNDEF NOENUMS}){$ENDIF};

type
  PD3DXAttributeRange = ^TD3DXAttributeRange;
  TD3DXAttributeRange = packed record
    AttribId    : LongWord;
    FaceStart   : LongWord;
    FaceCount   : LongWord;
    VertexStart : LongWord;
    VertexCount : LongWord;
  end;


type
  PD3DXMaterial = ^TD3DXMaterial;
  TD3DXMaterial = packed record
    MatD3D          : TD3DMaterial8;
    TextureFilename : PAnsiChar;
  end;

type
  PD3DXAttributeWeights = ^TD3DXAttributeWeights;
  TD3DXAttributeWeights = packed record
    Position : Single;
    Boundary : Single;
    Normal   : Single;
    Diffuse  : Single;
    Specular : Single;
    Tex      : array[0..7] of Single;
  end;

type
  TD3DXWeldEpsilonsFlags = {$IFNDEF NOENUMS}({$ELSE}LongWord;{$ENDIF}
  {$IFDEF NOENUMS}const{$ENDIF}

    D3DXWELDEPSILONS_WELDALL             = $1{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}   // weld all vertices marked by adjacency as being overlapping
    D3DXWELDEPSILONS_WELDPARTIALMATCHES  = $2{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}   // if a given vertex component is within epsilon, modify partial matched
                                                                                  // vertices so that both components identical AND if all components "equal"
                                                                                  // remove one of the vertices
    D3DXWELDEPSILONS_DONOTREMOVEVERTICES = $4{$IFNDEF NOENUMS}){$ENDIF};          // instructs weld to only allow modifications to vertices and not removal
                                                                                  // ONLY valid if D3DXWELDEPSILONS_WELDPARTIALMATCHES is set
                                                                                  // useful to modify vertices to be equal, but not allow vertices to be removed

type
  PD3DXWeldEpsilons = ^TD3DXWeldEpsilons;
  TD3DXWeldEpsilons = packed record
    SkinWeights : Single;
    Normal      : Single;
    Tex         : array[0..7]of Single;
    Flags       : LongWord;
  end;

type
  TFVFDeclaration = array [0..LongWord(MAX_FVF_DECL_SIZE) - 1] of LongWord;

  ID3DXMesh = interface;

  ID3DXBaseMesh = interface (IUnknown)
    ['{2A835771-BF4D-43f4-8E14-82A809F17D8A}']
    {*** ID3DXBaseMesh methods ***}
    function DrawSubset(const AttribId : LongWord) : HResult; stdcall;
    function GetNumFaces : LongWord; stdcall;
    function GetNumVertices : LongWord; stdcall;
    function GetFVF : LongWord; stdcall;
    function GetDeclaration(Declaration : TFVFDeclaration) : HResult; stdcall;
    function GetOptions : LongWord; stdcall;
    function GetDevice(out Device : IDirect3DDevice8) : HResult; stdcall;
    function CloneMeshFVF(const Options, FVF : LongWord; const D3DDevice : IDirect3DDevice8; out CloneMesh : ID3DXMesh) : HResult; stdcall;
    function CloneMesh(const Options : LongWORD; var Declaration : LongWord; const D3DDevice : IDirect3DDevice8; out CloneMesh : ID3DXMesh) : HResult; stdcall;
    function GetVertexBuffer(out VB : IDirect3DVertexBuffer8) : HResult; stdcall;
    function GetIndexBuffer(out IB : IDirect3DIndexBuffer8) : HResult; stdcall;
    function LockVertexBuffer(const Flags : LongWord; out Data : PByte) : HResult; stdcall;
    function UnlockVertexBuffer : HResult; stdcall;
    function LockIndexBuffer(const Flags : LongWord; out Data : PByte) : HResult; stdcall;
    function UnlockIndexBuffer : HResult; stdcall;
    function GetAttributeTable(AttribTable : PD3DXAttributeRange; var AttribTableSize : LongWord) : HResult; stdcall;

    function ConvertPointRepsToAdjacency(PRep : PLongWord; out Adjacency : LongWord) : HResult; stdcall;
    function ConvertAdjacencyToPointReps(var Adjacency : LongWord; out PRep : LongWord) : HResult; stdcall;
    function GenerateAdjacency(const Epsilon : Single; var Adjacency : LongWord) : HResult; stdcall;
  end;

  ID3DXMesh = interface (ID3DXBaseMesh)
    ['{CCAE5C3B-4DD1-4d0f-997E-4684CA64557F}']
    {*** ID3DXMesh methods ***}
    function LockAttributeBuffer(const Flags : LongWord; out Data : PLongWord) : HResult; stdcall;
    function UnlockAttributeBuffer : HResult; stdcall;
    function Optimize(const Flags : LongWord; AdjacencyIn, AdjacencyOut, FaceRemap : PLongWord; out VertexRemap : ID3DXBuffer; out OptMesh : ID3DXMesh) : HResult; stdcall;
    function OptimizeInplace(const Flags : LongWord; AdjacencyIn, AdjacencyOut, FaceRemap : PLongWord; out VertexRemap : ID3DXBuffer) : HResult; stdcall;
  end;

  ID3DXPMesh = interface (ID3DXBaseMesh)
    ['{19FBE386-C282-4659-97BD-CB869B084A6C}']
    {*** ID3DXPMesh methods ***}
    function ClonePMeshFVF(const Options, FVF : LongWord; D3D : IDirect3DDevice8; out CloneMesh : ID3DXPMesh) : HResult; stdcall;
    function ClonePMesh(const Options : LongWord; var Declaration : LongWord; D3D : IDirect3DDevice8; out CloneMesh : ID3DXPMesh) : HResult; stdcall;
    function SetNumFaces(const Faces : LongWord) : HResult; stdcall;
    function SetNumVertices(const Vertices : LongWord) : HResult; stdcall;
    function GetMaxFaces : LongWord; stdcall;
    function GetMinFaces : LongWord; stdcall;
    function GetMaxVertices : LongWord; stdcall;
    function GetMinVertices : LongWord; stdcall;
    function Save(const Stream : IStream; const Materials : TD3DXMaterial; const NumMaterials : LongWord) : HResult; stdcall;

    function Optimize(const Flags : LongWord; pAdjacencyOut, FaceRemap : PLongWord ; out VertexRemap : ID3DXBuffer; out OptMesh : ID3DXMesh) : HResult; stdcall;

    function OptimizeBaseLOD(const Flags : LongWord; FaceRemap : PLongWord) : HResult; stdcall;
    function TrimByFaces(const NewFacesMin, NewFacesMax : LongWord; rgiFaceRemap, rgiVertRemap : PLongWord) : HResult; stdcall;
    function TrimByVertices(const NewVerticesMin, NewVerticesMax : LongWord; rgiFaceRemap, rgiVertRemap : PLongWord) : HResult; stdcall;

    function GetAdjacency(out Adjacency : LongWord) : HResult; stdcall;
  end;

  ID3DXSPMesh = interface (IUnknown)
    ['{4E3CA05C-D4FF-4d11-8A02-16459E08F6F4}']
    {*** ID3DXSPMesh methods ***}
    function GetNumFaces : LongWord; stdcall;
    function GetNumVertices : LongWord; stdcall;
    function GetFVF : LongWord; stdcall;
    function GetDeclaration(Declaration : TFVFDeclaration) : HResult; stdcall;
    function GetOptions : LongWord; stdcall;
    function GetDevice(out Device : IDirect3DDevice8) : HResult; stdcall;
    function CloneMeshFVF(const Options, FVF : LongWord; const D3D : IDirect3DDevice8; AdjacencyOut, VertexRemapOut : PLongWord; out CloneMesh : ID3DXMesh) : HResult; stdcall;
    function CloneMesh(const Options : LongWord; var Declaration : LongWord; const D3DDevice : IDirect3DDevice8; AdjacencyOut, VertexRemapOut : PLongWord; out CloneMesh : ID3DXMesh) : HResult; stdcall;

    function ClonePMeshFVF(const Options, FVF : LongWord; const D3D : IDirect3DDevice8; VertexRemapOut : PLongWord; out CloneMesh : ID3DXMesh) : HResult; stdcall;

    function ClonePMesh(const Options : LongWord; var Declaration : LongWord; const D3DDevice : IDirect3DDevice8; VertexRemapOut : PLongWord; out CloneMesh : ID3DXMesh) : HResult; stdcall;

    function ReduceFaces(const Faces : LongWord) : HResult; stdcall;
    function ReduceVertices(const Vertices : LongWord) : HResult; stdcall;
    function GetMaxFaces : LongWord; stdcall;
    function GetMaxVertices : LongWord; stdcall;
    function GetVertexAttributeWeights(out VertexAttributeWeights : TD3DXAttributeWeights) : HResult; stdcall;
    function GetVertexWeights(VertexWeights : PSingle) : HResult; stdcall;
  end;

const
  UNUSED16 = $ffff;
  UNUSED32 = $ffffffff;

// ID3DXMesh::Optimize options - upper byte only, lower 3 bytes used from _D3DXMESH option flags
type TD3DXMeshOpt = {$IFNDEF NOENUMS}({$ELSE}LongWord;{$ENDIF}
  {$IFDEF NOENUMS}const{$ENDIF}
    D3DXMESHOPT_COMPACT       = $01000000{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}
    D3DXMESHOPT_ATTRSORT      = $02000000{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}
    D3DXMESHOPT_VERTEXCACHE   = $04000000{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}
    D3DXMESHOPT_STRIPREORDER  = $08000000{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}
    D3DXMESHOPT_IGNOREVERTS   = $10000000{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}  // optimize faces only, don't touch vertices
    D3DXMESHOPT_SHAREVB       = $00001000{$IFNDEF NOENUMS}){$ENDIF};         // same as D3DXMESH_VB_SHARE

// Subset of the mesh that has the same attribute and bone combination.
// This subset can be rendered in a single draw call
type
  PD3DXBoneCombination = ^TD3DXBoneCombination;
  TD3DXBoneCombination = packed record
    AttribId    : LongWord;
    FaceStart   : LongWord;
    FaceCount   : LongWord;
    VertexStart : LongWord;
    VertexCount : LongWord;
    BoneId      : PLongWord;
  end;

  ID3DXSkinMesh = interface (IUnknown)
    ['{8DB06ECC-EBFC-408a-9404-3074B4773515}']
    {*** ID3DXMesh methods ***}
    function GetNumFaces : LongWord; stdcall;
    function GetNumVertices : LongWord; stdcall;
    function GetFVF : LongWord; stdcall;
    function GetDeclaration(Declaration : TFVFDeclaration) : HResult; stdcall;
    function GetOptions : LongWord; stdcall;
    function GetDevice(out Device : IDirect3DDevice8) : HResult; stdcall;
    function GetVertexBuffer(out VB : IDirect3DVertexBuffer8) : HResult; stdcall;
    function GetIndexBuffer(out IB : IDirect3DIndexBuffer8) : HResult; stdcall;
    function LockVertexBuffer(const Flags : LongWord; out Data : PByte) : HResult; stdcall;
    function UnlockVertexBuffer : HResult; stdcall;
    function LockIndexBuffer(const Flags : LongWord; out Data : PByte) : HResult; stdcall;
    function UnlockIndexBuffer : HResult; stdcall;
    function LockAttributeBuffer(const Flags : LongWord; out Data : PLongWord) : HResult; stdcall;
    function UnlockAttributeBuffer : HResult; stdcall;

    {*** ID3DXSkinMesh methods ***}
    function GetNumBones : LongWord; stdcall;
    function GetOriginalMesh(out Mesh : ID3DXMesh) : HResult; stdcall;
    function SetBoneInfluence(const Bone, numInfluences : LongWord; Vertices : PLongWord; Weights : PSingle) : HResult; stdcall;
    function GetNumBoneInfluences(const Bone : LongWord) : LongWord; stdcall;
    function GetBoneInfluence(const Bone : LongWord; Vertices : PLongWord; Weights : PSingle) : HResult; stdcall;
    function GetMaxVertexInfluences(out maxVertexInfluences : LongWord) : HResult; stdcall;
    function GetMaxFaceInfluences(out maxFaceInfluences : LongWord) : HResult; stdcall;

    function ConvertToBlendedMesh(const Options : LongWord; AdjacencyIn, AdjacencyOut : PLongWord; var NumBoneCombinations : LongWord; out BoneCombinationTable : ID3DXBuffer; FaceRemap : PLongWord; out VertexRemap : ID3DXBuffer; out Mesh : ID3DXMesh) : HResult; stdcall;

    function ConvertToIndexedBlendedMesh(const Options : LongWord; AdjacencyIn : PLongWord; const paletteSize : LongWord; pAdjacencyOut : PLongWord; var NumBoneCombinations : LongWord; out BoneCombinationTable : ID3DXBuffer; FaceRemap : PLongWord; out VertexRemap : ID3DXBuffer; out Mesh : ID3DXMesh) : HResult; stdcall;

    function GenerateSkinnedMesh(const Options : LongWord; const minWeight : Single; AdjacencyIn, AdjacencyOut, pFaceRemap : PLongWord; VertexRemap : ID3DXBuffer; out Mesh : ID3DXMesh) : HResult; stdcall;
    function UpdateSkinnedMesh(const pBoneTransforms, BoneInvTransforms : PD3DXMatrix ; Mesh : ID3DXMesh) : HResult; stdcall;
  end;

function D3DXCreateMesh(const NumFaces, NumVertices, Options : LongWord; Declaration : PLongWord; const D3D : IDirect3DDevice8; out Mesh : ID3DXMesh) : HResult; stdcall; overload;
function D3DXCreateMesh(const NumFaces, NumVertices, Options : LongWord; var Declaration : LongWord; const D3D : IDirect3DDevice8; out Mesh : ID3DXMesh) : HResult; stdcall; overload;

function D3DXCreateMeshFVF(const NumFaces, NumVertices, Options, FVF : LongWord; const D3D : IDirect3DDevice8; out Mesh : ID3DXMesh) : HResult; stdcall;

function D3DXCreateSPMesh(const Mesh : ID3DXMesh; const Adjacency : PLongWord; var VertexAttributeWeights : TD3DXAttributeWeights; const VertexWeights : PSingle; out SMesh : ID3DXSPMesh) : HResult; stdcall; overload;
function D3DXCreateSPMesh(const Mesh : ID3DXMesh; const Adjacency : PLongWord; VertexAttributeWeights : PD3DXAttributeWeights; const VertexWeights : PSingle; out SMesh : ID3DXSPMesh) : HResult; stdcall; overload;

// clean a mesh up for simplification, try to make manifold
function D3DXCleanMesh(const MeshIn : ID3DXMesh; AdjacencyIn : PLongWord; out MeshOut : ID3DXMesh; AdjacencyOut : PLongWord; out ErrorsAndWarnings : ID3DXBuffer) : HResult; stdcall;

function D3DXValidMesh(const MeshIn : ID3DXMesh; Adjacency : PLongWord; out ErrorsAndWarnings : ID3DXBuffer) : HResult; stdcall;

function D3DXGeneratePMesh(const Mesh : ID3DXMesh; Adjacency : PLongWord; var VertexAttributeWeights : TD3DXAttributeWeights; const VertexWeights : PSingle; const MinValue, Options : LongWord; out PMesh : ID3DXPMesh) : HResult; stdcall; overload;
function D3DXGeneratePMesh(const Mesh : ID3DXMesh; Adjacency : PLongWord; VertexAttributeWeights : PD3DXAttributeWeights; const VertexWeights : PSingle; const MinValue, Options : LongWord; out PMesh : ID3DXPMesh) : HResult; stdcall; overload;

function D3DXSimplifyMesh(const Mesh : ID3DXMesh; Adjacency : PLongWord; VertexAttributeWeights : PD3DXAttributeWeights; const VertexWeights : PSingle; const MinValue, Options : LongWord; out MeshOut : ID3DXMesh) : HResult; stdcall; overload;
function D3DXSimplifyMesh(const Mesh : ID3DXMesh; Adjacency : PLongWord; var VertexAttributeWeights : TD3DXAttributeWeights; const VertexWeights : PSingle; const MinValue, Options : LongWord; out MeshOut : ID3DXMesh) : HResult; stdcall; overload;

function D3DXComputeBoundingSphere(PointsFVF : Pointer; const NumVertices, FVF : LongWord; Center : PD3DXVector3; Radius : PSingle) : HResult; stdcall; overload;
function D3DXComputeBoundingSphere(PointsFVF : Pointer; const NumVertices, FVF : LongWord; out Center : TD3DXVector3; Radius : PSingle) : HResult; stdcall; overload;
function D3DXComputeBoundingSphere(PointsFVF : Pointer; const NumVertices, FVF : LongWord; Center : PD3DXVector3; out Radius : Single) : HResult; stdcall; overload;
function D3DXComputeBoundingSphere(PointsFVF : Pointer; const NumVertices, FVF : LongWord; out Center : TD3DXVector3; out Radius : Single) : HResult; stdcall; overload;

function D3DXComputeBoundingBox(PointsFVF : Pointer; const NumVertices, FVF : LongWord; Min, Max : PD3DXVector3) : HResult; stdcall; overload;
function D3DXComputeBoundingBox(PointsFVF : Pointer; const NumVertices, FVF : LongWord; out Min : TD3DXVector3; Max : PD3DXVector3) : HResult; stdcall; overload;
function D3DXComputeBoundingBox(PointsFVF : Pointer; const NumVertices, FVF : LongWord; Min : PD3DXVector3; out Max : TD3DXVector3) : HResult; stdcall; overload;
function D3DXComputeBoundingBox(PointsFVF : Pointer; const NumVertices, FVF : LongWord; out Min, Max : TD3DXVector3) : HResult; stdcall; overload;

function D3DXComputeNormals(const Mesh : ID3DXBaseMesh; Adjacency : PLongWord) : HResult; stdcall;

function D3DXCreateBuffer(const NumBytes : LongWord; out Buffer : ID3DXBuffer) : HResult; stdcall;

function D3DXLoadMeshFromX(Filename : PAnsiChar; const Options : LongWord; const D3D : IDirect3DDevice8; out Adjacency, Materials : ID3DXBuffer; var NumMaterials : LongWord; out Mesh : ID3DXMesh) : HResult; stdcall; overload;
function D3DXLoadMeshFromX(Filename : PAnsiChar; const Options : LongWord; const D3D : IDirect3DDevice8; out Adjacency, Materials : ID3DXBuffer; NumMaterials : PLongWord; out Mesh : ID3DXMesh) : HResult; stdcall; overload;

function D3DXLoadMeshFromXInMemory(Memory : PByte; const SizeOfMemory, Options : LongWord; const D3D : IDirect3DDevice8; out Adjacency, Materials : ID3DXBuffer; var NumMaterials : LongWord; out Mesh : ID3DXMesh) : HResult; stdcall; overload;
function D3DXLoadMeshFromXInMemory(Memory : PByte; const SizeOfMemory, Options : LongWord; const D3D : IDirect3DDevice8; out Adjacency, Materials : ID3DXBuffer; NumMaterials : PLongWord; out Mesh : ID3DXMesh) : HResult; stdcall; overload;

function D3DXLoadMeshFromXResource(const Module : HMODULE; Name, _Type : PAnsiChar; const Options : LongWord; const D3D : IDirect3DDevice8; out Adjacency, Materials : ID3DXBuffer; var NumMaterials : LongWord; out Mesh : ID3DXMesh) : HResult; stdcall; overload;
function D3DXLoadMeshFromXResource(const Module : HMODULE; Name, _Type : PAnsiChar; const Options : LongWord; const D3D : IDirect3DDevice8; out Adjacency, Materials : ID3DXBuffer; NumMaterials : PLongWord; out Mesh : ID3DXMesh) : HResult; stdcall; overload;

function D3DXSaveMeshToX(Filename : PAnsiChar; const Mesh : ID3DXMesh; Adjacency : PLongWord; var Materials : TD3DXMaterial; const NumMaterials, Format : LongWord) : HResult; stdcall; overload;
function D3DXSaveMeshToX(Filename : PAnsiChar; const Mesh : ID3DXMesh; Adjacency : PLongWord; Materials : PD3DXMaterial; const NumMaterials, Format : LongWord) : HResult; stdcall; overload;

function D3DXCreatePMeshFromStream(const Stream : IStream; const Options : LongWord; const D3DDevice : IDirect3DDevice8; out Materials : ID3DXBuffer; out NumMaterials : LongWord; out PMesh : ID3DXPMesh) : HResult; stdcall; overload;
function D3DXCreatePMeshFromStream(const Stream : IStream; const Options : LongWord; const D3DDevice : IDirect3DDevice8; out Materials : ID3DXBuffer; NumMaterials : PLongWord; out PMesh : ID3DXPMesh) : HResult; stdcall; overload;

function D3DXCreateSkinMesh(const NumFaces, NumVertices, NumBones, Options : LongWord; Declaration : PLongWord; const D3D : IDirect3DDevice8; out SkinMesh : ID3DXSkinMesh) : HResult; stdcall;

function D3DXCreateSkinMeshFVF(const NumFaces, NumVertices, NumBones, Options, FVF : LongWord; const D3D : IDirect3DDevice8; out SkinMesh : ID3DXSkinMesh) : HResult; stdcall;

function D3DXCreateSkinMeshFromMesh(const Mesh : ID3DXMesh; const numBones : LongWord; out SkinMesh : ID3DXSkinMesh) : HResult; stdcall;

function D3DXLoadMeshFromXof(const XofObjMesh : IDirectXFileData; const Options : LongWord; const D3DDevice : IDirect3DDevice8; var Adjacency, Materials : ID3DXBuffer; out NumMaterials : LongWord; out Mesh : ID3DXMesh) : HResult; stdcall; overload;
function D3DXLoadMeshFromXof(const XofObjMesh : IDirectXFileData; const Options : LongWord; const D3DDevice : IDirect3DDevice8; var Adjacency, Materials : ID3DXBuffer; NumMaterials : PLongWord; out Mesh : ID3DXMesh) : HResult; stdcall; overload;

function D3DXLoadSkinMeshFromXof(const XofObjMesh : IDirectXFileData; const Options : LongWord; const D3DDevice : IDirect3DDevice8; var Adjacency, Materials : ID3DXBuffer; NumMaterials : PLongWord; var BoneNames, BoneTransforms : ID3DXBuffer; out SkinMesh : ID3DXSkinMesh) : HResult; stdcall; overload;
function D3DXLoadSkinMeshFromXof(const XofObjMesh : IDirectXFileData; const Options : LongWord; const D3DDevice : IDirect3DDevice8; var Adjacency, Materials : ID3DXBuffer; var NumMaterials : LongWord; var BoneNames, BoneTransforms : ID3DXBuffer; out SkinMesh : ID3DXSkinMesh) : HResult; stdcall; overload;

function D3DXTessellateNPatches(const MeshIn : ID3DXMesh; AdjacencyIn : PLongWord; const NumSegs : Single; QuadraticInterpNormals : BOOL; out MeshOut : ID3DXMesh; out AdjacencyOut : ID3DXBuffer) : HResult; stdcall;
//   QuadraticInterpNormals : BOOL;     // if false use linear intrep for normals, if true use quadratic

function D3DXGetFVFVertexSize(const FVF : LongWord) : Cardinal; stdcall;

function D3DXDeclaratorFromFVF(const FVF : LongWord; Declaration : TFVFDeclaration) : HResult; stdcall;

function D3DXFVFFromDeclarator(Declarator, FVF : PLongWord) : HResult; stdcall; overload;
function D3DXFVFFromDeclarator(var Declarator : LongWord; FVF : PLongWord) : HResult; stdcall; overload;
function D3DXFVFFromDeclarator(Declarator : PLongWord; out FVF : LongWord) : HResult; stdcall; overload;
function D3DXFVFFromDeclarator(var Declarator : LongWord; out FVF : LongWord) : HResult; stdcall; overload;

function D3DXWeldVertices(const Mesh : ID3DXMesh; var Epsilons : TD3DXWeldEpsilons; AdjacencyIn, AdjacencyOut, FaceRemap : PLongWord; out VertexRemap : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXWeldVertices(const Mesh : ID3DXMesh; Epsilons : PD3DXWeldEpsilons; AdjacencyIn, AdjacencyOut, FaceRemap : PLongWord; out VertexRemap : ID3DXBuffer) : HResult; stdcall; overload;

type
  PD3DXIntersectInfo = ^TD3DXIntersectInfo;
  TD3DXIntersectInfo = packed record
    FaceIndex : LongWord;       // index of face intersected
    U         : Single;         // Barycentric Hit Coordinates
    V         : Single;         // Barycentric Hit Coordinates
    Dist      : Single;         // Ray-Intersection Parameter Distance
  end;

function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; AllHits : PID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersect(const Mesh : ID3DXBaseMesh; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
(*)
Hit         : BOOL;         // True if any faces were intersected
FaceIndex   : LongWord,     // index of closest face intersected
U, V        : Single;       // Barycentric Hit Coordinates
Dist        : Single;       // Ray-Intersection Parameter Distance
AllHits     : ID3DXBuffer   // Array of D3DXINTERSECTINFOs for all hits (not just closest)
CountOfHits : LongWord      // Number of entries in AllHits array
(*)


function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; CountOfHits : PLongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V, Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V : Single; Dist : PSingle; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U, V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U : Single; V : PSingle; out Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; U : PSingle; out V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; FaceIndex : PLongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; Hit : PBOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos, RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;
function D3DXIntersectSubset(const Mesh : ID3DXBaseMesh; const AttribId : LongWord; var RayPos, RayDir : TD3DXVector3; out Hit : BOOL; out FaceIndex : LongWord; out U, V, Dist : Single; out AllHits : ID3DXBuffer; out CountOfHits : LongWord) : HResult; stdcall; overload;

function D3DXSplitMesh(const MeshIn : ID3DXMesh; AdjacencyIn : PLongWord; const MaxSize, Options : LongWord; MeshesOut : PLongWord; out MeshArrayOut, AdjacencyArrayOut, FaceRemapArrayOut, VertRemapArrayOut : ID3DXBuffer) : HResult; stdcall;

function D3DXIntersectTri(vp0, vp1, vp2, RayPos, RayDir : PD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2, RayPos, RayDir : PD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2, RayPos, RayDir : PD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2, RayPos, RayDir : PD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2, RayPos, RayDir : TD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2, RayPos, RayDir : TD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2, RayPos, RayDir : TD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2, RayPos, RayDir : TD3DXVector3; U, V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2, RayPos, RayDir : PD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2, RayPos, RayDir : PD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2, RayPos, RayDir : PD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2, RayPos, RayDir : PD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2, RayPos, RayDir : TD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2, RayPos, RayDir : TD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2, RayPos, RayDir : TD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2, RayPos, RayDir : TD3DXVector3; out U : Single; V, Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2, RayPos, RayDir : PD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2, RayPos, RayDir : PD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2, RayPos, RayDir : PD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2, RayPos, RayDir : PD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2, RayPos, RayDir : TD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2, RayPos, RayDir : TD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2, RayPos, RayDir : TD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2, RayPos, RayDir : TD3DXVector3; U : PSingle; out V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2, RayPos, RayDir : PD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2, RayPos, RayDir : PD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2, RayPos, RayDir : PD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2, RayPos, RayDir : PD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2, RayPos, RayDir : TD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2, RayPos, RayDir : TD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2, RayPos, RayDir : TD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2, RayPos, RayDir : TD3DXVector3; out U, V : Single; Dist : PSingle) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2, RayPos, RayDir : PD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2, RayPos, RayDir : PD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2, RayPos, RayDir : PD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2, RayPos, RayDir : PD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2, RayPos, RayDir : TD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2, RayPos, RayDir : TD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2, RayPos, RayDir : TD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2, RayPos, RayDir : TD3DXVector3; U, V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2, RayPos, RayDir : PD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2, RayPos, RayDir : PD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2, RayPos, RayDir : PD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2, RayPos, RayDir : PD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2, RayPos, RayDir : TD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2, RayPos, RayDir : TD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2, RayPos, RayDir : TD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2, RayPos, RayDir : TD3DXVector3; out U : Single; V : PSingle; out Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2, RayPos, RayDir : PD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2, RayPos, RayDir : PD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2, RayPos, RayDir : PD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2, RayPos, RayDir : PD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2, RayPos, RayDir : TD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2, RayPos, RayDir : TD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2, RayPos, RayDir : TD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2, RayPos, RayDir : TD3DXVector3; U : PSingle; out V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2, RayPos, RayDir : PD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2, RayPos, RayDir : PD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2, RayPos, RayDir : PD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2, RayPos, RayDir : PD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2 : TD3DXVector3; RayPos, RayDir : PD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2, RayPos : TD3DXVector3; RayDir : PD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2, RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2 : TD3DXVector3; RayPos : PD3DXVector3; var RayDir : TD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1, vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1, vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1 : TD3DXVector3; vp2 : PD3DXVector3; var RayPos, RayDir : TD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0, vp1 : PD3DXVector3; var vp2, RayPos, RayDir : TD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0 : TD3DXVector3; vp1 : PD3DXVector3; var vp2, RayPos, RayDir : TD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(vp0 : PD3DXVector3; var vp1, vp2, RayPos, RayDir : TD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;
function D3DXIntersectTri(var vp0, vp1, vp2, RayPos, RayDir : TD3DXVector3; out U, V, Dist : Single) : Bool; stdcall; overload;

(*)
(
vp0,       // Triangle vertex 0 position
vp1,       // Triangle vertex 1 position
vp2,       // Triangle vertex 2 position
RayPos,    // Ray origin
RayDir,    // Ray direction
U,         // Barycentric Hit Coordinates
V,         // Barycentric Hit Coordinates
Dist       // Ray-Intersection Parameter Distance
(*)

function D3DXSphereBoundProbe(Center : PD3DXVector3; const Radius : Single; RayPosition, RayDirection : PD3DXVector3) : Bool; stdcall; overload;
function D3DXSphereBoundProbe(var Center : TD3DXVector3; const Radius : Single; RayPosition, RayDirection : PD3DXVector3) : Bool; stdcall; overload;
function D3DXSphereBoundProbe(Center : PD3DXVector3; const Radius : Single; var RayPosition : TD3DXVector3; RayDirection : PD3DXVector3) : Bool; stdcall; overload;
function D3DXSphereBoundProbe(var Center : TD3DXVector3; const Radius : Single; var RayPosition : TD3DXVector3; RayDirection : PD3DXVector3) : Bool; stdcall; overload;
function D3DXSphereBoundProbe(Center : PD3DXVector3; const Radius : Single; RayPosition : PD3DXVector3; var RayDirection : TD3DXVector3) : Bool; stdcall; overload;
function D3DXSphereBoundProbe(var Center : TD3DXVector3; const Radius : Single; RayPosition : PD3DXVector3; var RayDirection : TD3DXVector3) : Bool; stdcall; overload;
function D3DXSphereBoundProbe(Center : PD3DXVector3; const Radius : Single; var RayPosition, RayDirection : TD3DXVector3) : Bool; stdcall; overload;
function D3DXSphereBoundProbe(var Center : TD3DXVector3; const Radius : Single; var RayPosition, RayDirection : TD3DXVector3) : Bool; stdcall; overload;

function D3DXBoxBoundProbe(Min, Max, RayPosition, RayDirection : PD3DXVector3) : Bool; stdcall; overload;
function D3DXBoxBoundProbe(var Min : TD3DXVector3; Max, RayPosition, RayDirection : PD3DXVector3) : Bool; stdcall; overload;
function D3DXBoxBoundProbe(Min : PD3DXVector3; var Max : TD3DXVector3; RayPosition, RayDirection : PD3DXVector3) : Bool; stdcall; overload;
function D3DXBoxBoundProbe(var Min, Max : TD3DXVector3; RayPosition, RayDirection : PD3DXVector3) : Bool; stdcall; overload;
function D3DXBoxBoundProbe(Min, Max : PD3DXVector3; var RayPosition : TD3DXVector3; RayDirection : PD3DXVector3) : Bool; stdcall; overload;
function D3DXBoxBoundProbe(var Min : TD3DXVector3; Max : PD3DXVector3; var RayPosition : TD3DXVector3; RayDirection : PD3DXVector3) : Bool; stdcall; overload;
function D3DXBoxBoundProbe(Min : PD3DXVector3; var Max, RayPosition : TD3DXVector3; RayDirection : PD3DXVector3) : Bool; stdcall; overload;
function D3DXBoxBoundProbe(var Min, Max, RayPosition : TD3DXVector3; RayDirection : PD3DXVector3) : Bool; stdcall; overload;
function D3DXBoxBoundProbe(Min, Max, RayPosition : PD3DXVector3; var RayDirection : TD3DXVector3) : Bool; stdcall; overload;
function D3DXBoxBoundProbe(var Min : TD3DXVector3; Max, RayPosition : PD3DXVector3; var RayDirection : TD3DXVector3) : Bool; stdcall; overload;
function D3DXBoxBoundProbe(Min : PD3DXVector3; var Max : TD3DXVector3; RayPosition : PD3DXVector3; var RayDirection : TD3DXVector3) : Bool; stdcall; overload;
function D3DXBoxBoundProbe(var Min, Max : TD3DXVector3; RayPosition : PD3DXVector3; var RayDirection : TD3DXVector3) : Bool; stdcall; overload;
function D3DXBoxBoundProbe(Min, Max : PD3DXVector3; var RayPosition, RayDirection : TD3DXVector3) : Bool; stdcall; overload;
function D3DXBoxBoundProbe(var Min : TD3DXVector3; Max : PD3DXVector3; var RayPosition, RayDirection : TD3DXVector3) : Bool; stdcall; overload;
function D3DXBoxBoundProbe(Min : PD3DXVector3; var Max, RayPosition, RayDirection : TD3DXVector3) : Bool; stdcall; overload;
function D3DXBoxBoundProbe(var Min, Max, RayPosition, RayDirection : TD3DXVector3) : Bool; stdcall; overload;

type
  TD3DXERR = LongWord;

const
  MAKE_DDHRESULT_D                    = (1 shl 31) or (_FACD3D shl 16);
  D3DXERR_CANNOTMODIFYINDEXBUFFER     = HResult(MAKE_DDHRESULT_D or 2900);
  D3DXERR_INVALIDMESH                 = HResult(MAKE_DDHRESULT_D or 2901);
  D3DXERR_CANNOTATTRSORT              = HResult(MAKE_DDHRESULT_D or 2902);
  D3DXERR_SKINNINGNOTSUPPORTED        = HResult(MAKE_DDHRESULT_D or 2903);
  D3DXERR_TOOMANYINFLUENCES           = HResult(MAKE_DDHRESULT_D or 2904);
  D3DXERR_INVALIDDATA                 = HResult(MAKE_DDHRESULT_D or 2905);
  D3DXERR_LOADEDMESHASNODATA          = HResult(MAKE_DDHRESULT_D or 2906);

const
  D3DX_COMP_TANGENT_NONE = $FFFFFFFF;

function D3DXComputeTangent(const InMesh : ID3DXMesh; const TexStage : LongWord; const OutMesh : ID3DXMESH; const TexStageUVec, TexStageVVec, Wrap : LongWord; Adjacency : PLongWord) : HResult; stdcall;

function D3DXConvertMeshSubsetToSingleStrip(const MeshIn : ID3DXBaseMesh; const AttribId, IBOptions : LongWord; out IndexBuffer : IDirect3DIndexBuffer8; out NumIndices : LongWord) : HResult; stdcall; overload;
function D3DXConvertMeshSubsetToSingleStrip(const MeshIn : ID3DXBaseMesh; const AttribId, IBOptions : LongWord; out IndexBuffer : IDirect3DIndexBuffer8; NumIndices : PLongWord) : HResult; stdcall; overload;

function D3DXConvertMeshSubsetToStrips(const MeshIn : ID3DXBaseMesh; const AttribId, IBOptions : LongWord; out IndexBuffer : IDirect3DIndexBuffer8; out NumIndices : LongWord; out StripLengths : ID3DXBuffer; out NumStrips : LongWord) : HResult; stdcall; overload;
function D3DXConvertMeshSubsetToStrips(const MeshIn : ID3DXBaseMesh; const AttribId, IBOptions : LongWord; out IndexBuffer : IDirect3DIndexBuffer8; out NumIndices : LongWord; out StripLengths : ID3DXBuffer; NumStrips : PLongWord) : HResult; stdcall; overload;
function D3DXConvertMeshSubsetToStrips(const MeshIn : ID3DXBaseMesh; const AttribId, IBOptions : LongWord; out IndexBuffer : IDirect3DIndexBuffer8; NumIndices : PLongWord; out StripLengths : ID3DXBuffer; out NumStrips : LongWord) : HResult; stdcall; overload;
function D3DXConvertMeshSubsetToStrips(const MeshIn : ID3DXBaseMesh; const AttribId, IBOptions : LongWord; out IndexBuffer : IDirect3DIndexBuffer8; NumIndices : PLongWord; out StripLengths : ID3DXBuffer; NumStrips : PLongWord) : HResult; stdcall; overload;


(*)
[-------------------------------------------------------------------------------
[  Copyright (C) Microsoft Corporation.  All Rights Reserved.
[
[  File:       d3dx8shapes.h
[  Content:    D3DX simple shapes
[-------------------------------------------------------------------------------
(*)
(*)
[-------------------------------------------------------------------------------
[ Functions:
[-------------------------------------------------------------------------------
(*)
(*)
[-------------------------------------------------------------------------------
[ D3DXCreatePolygon:
[ ------------------
[ Creates a mesh containing an n-sided polygon.  The polygon is centered
[ at the origin.
[
[ Parameters:
[
[  pDevice     The D3D device with which the mesh is going to be used.
[  Length      Length of each side.
[  Sides       Number of sides the polygon has.  (Must be >= 3)
[  ppMesh      The mesh object which will be created
[  ppAdjacency Returns a buffer containing adjacency info.  Can be NULL.
[-------------------------------------------------------------------------------
(*)

function D3DXCreatePolygon(const Device : IDirect3DDevice8; const Length : Single; const Sides : Cardinal; out Mesh : ID3DXMesh; out Adjacency : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXCreatePolygon(const Device : IDirect3DDevice8; const Length : Single; const Sides : Cardinal; out Mesh : ID3DXMesh; const Adjacency : PID3DXBuffer) : HResult; stdcall; overload;

(*)
[-------------------------------------------------------------------------------
[ D3DXCreateBox:
[ --------------
[ Creates a mesh containing an axis-aligned box.  The box is centered at
[ the origin.
[
[ Parameters:
[
[  pDevice     The D3D device with which the mesh is going to be used.
[  Width       Width of box (along X-axis)
[  Height      Height of box (along Y-axis)
[  Depth       Depth of box (along Z-axis)
[  ppMesh      The mesh object which will be created
[  ppAdjacency Returns a buffer containing adjacency info.  Can be NULL.
[-------------------------------------------------------------------------------
(*)

function D3DXCreateBox(const Device : IDirect3DDevice8; const Width, Height, Depth : Single; out Mesh : ID3DXMesh; out Adjacency : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXCreateBox(const Device : IDirect3DDevice8; const Width, Height, Depth : Single; out Mesh : ID3DXMesh; const Adjacency : PID3DXBuffer) : HResult; stdcall; overload;

(*)
[-------------------------------------------------------------------------------
[ D3DXCreateCylinder:
[ -------------------
[ Creates a mesh containing a cylinder.  The generated cylinder is
[ centered at the origin, and its axis is aligned with the Z-axis.
[
[ Parameters:
[
[  pDevice     The D3D device with which the mesh is going to be used.
[  Radius1     Radius at -Z end (should be >= 0.0f)
[  Radius2     Radius at +Z end (should be >= 0.0f)
[  Length      Length of cylinder (along Z-axis)
[  Slices      Number of slices about the main axis
[  Stacks      Number of stacks along the main axis
[  ppMesh      The mesh object which will be created
[  ppAdjacency Returns a buffer containing adjacency info.  Can be NULL.
[-------------------------------------------------------------------------------
(*)

function D3DXCreateCylinder(const Device : IDirect3DDevice8; const Radius1, Radius2, Length : Single; const Slices, Stacks : Cardinal; out Mesh : ID3DXMesh; out Adjacency : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXCreateCylinder(const Device : IDirect3DDevice8; const Radius1, Radius2, Length : Single; const Slices, Stacks : Cardinal; out Mesh : ID3DXMesh; const Adjacency : PID3DXBuffer) : HResult; stdcall; overload;

(*)
[-------------------------------------------------------------------------------
[ D3DXCreateSphere:
[ -----------------
[ Creates a mesh containing a sphere.  The sphere is centered at the
[ origin.
[
[ Parameters:
[
[  pDevice     The D3D device with which the mesh is going to be used.
[  Radius      Radius of the sphere (should be >= 0.0f)
[  Slices      Number of slices about the main axis
[  Stacks      Number of stacks along the main axis
[  ppMesh      The mesh object which will be created
[  ppAdjacency Returns a buffer containing adjacency info.  Can be NULL.
[-------------------------------------------------------------------------------
(*)

function D3DXCreateSphere(const Device : IDirect3DDevice8; const Radius : Single; const Slices, Stacks : Cardinal; out Mesh : ID3DXMesh; out Adjacency : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXCreateSphere(const Device : IDirect3DDevice8; const Radius : Single; const Slices, Stacks : Cardinal; out Mesh : ID3DXMesh; const Adjacency : PID3DXBuffer) : HResult; stdcall; overload;

(*)
[-------------------------------------------------------------------------------
// D3DXCreateTorus:
// ----------------
// Creates a mesh containing a torus.  The generated torus is centered at
// the origin, and its axis is aligned with the Z-axis.
//
// Parameters:
//
//  pDevice     The D3D device with which the mesh is going to be used.
//  InnerRadius Inner radius of the torus (should be >= 0.0f)
//  OuterRadius Outer radius of the torue (should be >= 0.0f)
//  Sides       Number of sides in a cross-section (must be >= 3)
//  Rings       Number of rings making up the torus (must be >= 3)
//  ppMesh      The mesh object which will be created
//  ppAdjacency Returns a buffer containing adjacency info.  Can be NULL.
[-------------------------------------------------------------------------------
(*)

function D3DXCreateTorus(const Device : IDirect3DDevice8; const InnerRadius, OuterRadius : Single; const Sides, Rings : Cardinal; out Mesh : ID3DXMesh; out Adjacency : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXCreateTorus(const Device : IDirect3DDevice8; const InnerRadius, OuterRadius : Single; const Sides, Rings : Cardinal; out Mesh : ID3DXMesh; const Adjacency : PID3DXBuffer) : HResult; stdcall; overload;

(*)
[-------------------------------------------------------------------------------
[ D3DXCreateTeapot:
[ -----------------
[ Creates a mesh containing a teapot.
[
[ Parameters:
[
[  pDevice     The D3D device with which the mesh is going to be used.
[  ppMesh      The mesh object which will be created
[  ppAdjacency Returns a buffer containing adjacency info.  Can be NULL.
[-------------------------------------------------------------------------------
(*)

function D3DXCreateTeapot(const Device : IDirect3DDevice8; out Mesh : ID3DXMesh; out Adjacency : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXCreateTeapot(const Device : IDirect3DDevice8; out Mesh : ID3DXMesh; const Adjacency : PID3DXBuffer) : HResult; stdcall; overload;

(*)
[-------------------------------------------------------------------------------
[ D3DXCreateText:
[ ---------------
[ Creates a mesh containing the specified text using the font associated
[ with the device context.
[
[ Parameters:
[
[  pDevice       The D3D device with which the mesh is going to be used.
[  hDC           Device context, with desired font selected
[  pText         Text to generate
[  Deviation     Maximum chordal deviation from true font outlines
[  Extrusion     Amount to extrude text in -Z direction
[  ppMesh        The mesh object which will be created
[  pGlyphMetrics Address of buffer to receive glyph metric data (or NULL)
[-------------------------------------------------------------------------------
(*)

function D3DXCreateTextA(const Device : IDirect3DDevice8; const DC : HDC; pText : PAnsiChar; const Deviation, Extrusion : Single; out Mesh : ID3DXMesh; out Adjacency : ID3DXBuffer; var GlyphMetrics : TGlyphMetricsFloat) : HResult; stdcall; overload;
function D3DXCreateTextA(const Device : IDirect3DDevice8; const DC : HDC; pText : PAnsiChar; const Deviation, Extrusion : Single; out Mesh : ID3DXMesh; out Adjacency : ID3DXBuffer; GlyphMetrics : PGlyphMetricsFloat) : HResult; stdcall; overload;

function D3DXCreateTextW(const Device : IDirect3DDevice8; const DC : HDC; pText : PWideChar; const Deviation, Extrusion : Single; out Mesh : ID3DXMesh; out Adjacency : ID3DXBuffer; var GlyphMetrics : TGlyphMetricsFloat) : HResult; stdcall; overload;
function D3DXCreateTextW(const Device : IDirect3DDevice8; const DC : HDC; pText : PWideChar; const Deviation, Extrusion : Single; out Mesh : ID3DXMesh; out Adjacency : ID3DXBuffer; GlyphMetrics : PGlyphMetricsFloat) : HResult; stdcall; overload;

{$IFDEF UNICODE}
function D3DXCreateText(const Device : IDirect3DDevice8; const DC : HDC; pText : PWideChar; const Deviation, Extrusion : Single; out Mesh : ID3DXMesh; out Adjacency : ID3DXBuffer; var GlyphMetrics : TGlyphMetricsFloat) : HResult; stdcall; overload;
function D3DXCreateText(const Device : IDirect3DDevice8; const DC : HDC; pText : PWideChar; const Deviation, Extrusion : Single; out Mesh : ID3DXMesh; out Adjacency : ID3DXBuffer; GlyphMetrics : PGlyphMetricsFloat) : HResult; stdcall; overload;
{$ELSE}
function D3DXCreateText(const Device : IDirect3DDevice8; const DC : HDC; pText : PAnsiChar; const Deviation, Extrusion : Single; out Mesh : ID3DXMesh; out Adjacency : ID3DXBuffer; var GlyphMetrics : TGlyphMetricsFloat) : HResult; stdcall; overload;
function D3DXCreateText(const Device : IDirect3DDevice8; const DC : HDC; pText : PAnsiChar; const Deviation, Extrusion : Single; out Mesh : ID3DXMesh; out Adjacency : ID3DXBuffer; GlyphMetrics : PGlyphMetricsFloat) : HResult; stdcall; overload;
{$ENDIF}

(*)
[-------------------------------------------------------------------------------
[  Copyright (C) Microsoft Corporation.  All Rights Reserved.
[
[  File:       d3dx8effect.h
[  Content:    D3DX effect types and functions
[-------------------------------------------------------------------------------
(*)

const
  D3DXFX_DONOTSAVESTATE = (1 shl 0);

type
  TD3DXParameterType = {$IFNDEF NOENUMS}({$ELSE}LongWord;{$ENDIF}
  {$IFDEF NOENUMS}const{$ENDIF}
    D3DXPT_DWORD        = 0{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}
    D3DXPT_FLOAT        = 1{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}
    D3DXPT_VECTOR       = 2{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}
    D3DXPT_MATRIX       = 3{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}
    D3DXPT_TEXTURE      = 4{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}
    D3DXPT_VERTEXSHADER = 5{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}
    D3DXPT_PIXELSHADER  = 6{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}
    D3DXPT_CONSTANT     = 7{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}
    D3DXPT_STRING       = 8{$IFNDEF NOENUMS},{$ELSE};{$ENDIF}
    D3DXPT_FORCE_DWORD  = $7fffffff{$IFNDEF NOENUMS}){$ENDIF};

type
  PD3DXEffectDesc = ^TD3DXEffectDesc;
  TD3DXEffectDesc = packed record
    Parameters : Cardinal;
    Techniques : Cardinal;
  end;
  PD3DXEffect_Desc = ^TD3DXEffect_Desc; 
  TD3DXEffect_Desc = TD3DXEffectDesc;

type
  PD3DXParameterDesc = ^TD3DXParameterDesc;
  TD3DXParameterDesc = packed record
    Name  : PAnsiChar;
    Index : PAnsiChar;
    _Type : TD3DXParameterType; 
  end;
  PD3DXParameter_Desc = ^TD3DXParameter_Desc;
  TD3DXParameter_Desc = TD3DXParameterDesc;



type
  PD3DXTechniqueDesc = ^TD3DXTechniqueDesc;
  TD3DXTechniqueDesc = packed record
    Name   : PAnsiChar;
    Index  : PAnsiChar;
    Passes : Cardinal;
 end;
 PD3DXTechnique_Desc = ^TD3DXTechnique_Desc;
 TD3DXTechnique_Desc = TD3DXTechniqueDesc;

type
  PD3DXPassDesc = ^TD3DXPassDesc;
  TD3DXPassDesc = packed record
    Name  : PAnsiChar;
    Index : PAnsiChar;
  end;
  PD3DXPass_Desc = ^TD3DXPass_Desc;
  TD3DXPass_Desc = TD3DXPassDesc;

(*)
[-------------------------------------------------------------------------------
[ ID3DXEffect
[-------------------------------------------------------------------------------
(*)

const
  IID_ID3DXEffect : TGUID = '{648B1CEB-8D4E-4d66-B6FA-E44969E82E89}';

type
  ID3DXEffect = interface (IUnknown)
  ['{648B1CEB-8D4E-4d66-B6FA-E44969E82E89}']
  (*** ID3DXEffect methods ***)
    function GetDevice(out Device : IDirect3DDevice8) : HResult; stdcall;
    function GetDesc(out Desc : TD3DXEffectDesc) : HResult; stdcall;
    function GetParameterDesc(Parameter : PAnsiChar; out Desc : TD3DXParameterDesc) : HResult; stdcall;
    function GetTechniqueDesc(Technique : PAnsiChar; out Desc : TD3DXTechniqueDesc) : HResult; stdcall;
    function GetPassDesc(Technique, Pass : PAnsiChar; out Desc : TD3DXPassDesc) : HResult; stdcall;
    function FindNextValidTechnique(Technique : PAnsiChar; out Desc : TD3DXTechniqueDesc) : HResult; stdcall;
    function CloneEffect(Device : IDirect3DDevice8; out Effect : ID3DXEffect) : HResult; stdcall;
    function GetCompiledEffect(out CompiledEffect : ID3DXBuffer) : HResult; stdcall;

    function SetTechnique(Technique : PAnsiChar) : HResult; stdcall;
    function GetTechnique(out Technique : PAnsiChar) : HResult; stdcall;

    function SetDword(Parameter : PAnsiChar; const dw : LongWord) : HResult; stdcall;
    function GetDword(Parameter : PAnsiChar; out dw : LongWord) : HResult; stdcall;
    function SetFloat(Parameter : PAnsiChar; const f : Single) : HResult; stdcall;
    function GetFloat(Parameter : PAnsiChar; out f : Single) : HResult; stdcall;
    function SetVector(Parameter : PAnsiChar; var Vector : TD3DXVector4) : HResult; stdcall;
    function GetVector(Parameter : PAnsiChar; out Vector : TD3DXVector4) : HResult; stdcall;
    function SetMatrix(Parameter : PAnsiChar; var Matrix : TD3DXMatrix) : HResult; stdcall;
    function GetMatrix(Parameter : PAnsiChar; out Matrix : TD3DXMatrix) : HResult; stdcall;
    function SetTexture(Parameter : PAnsiChar; const Texture : IDirect3DBaseTexture8) : HResult; stdcall;
    function GetTexture(Parameter : PAnsiChar; out Texture : IDirect3DBaseTexture8) : HResult; stdcall;
    function SetVertexShader(Parameter : PAnsiChar; const Handle : LongWord) : HResult; stdcall;
    function GetVertexShader(Parameter : PAnsiChar; out Handle : LongWord) : HResult; stdcall;
    function SetPixelShader(Parameter : PAnsiChar; const Handle : LongWord) : HResult; stdcall;
    function GetPixelShader(Parameter : PAnsiChar; out Handle : LongWord) : HResult; stdcall;
    function SetString(Parameter, _String : PAnsiChar) : HResult; stdcall;
    function GetString(Parameter : PAnsiChar; out _String : PAnsiChar)  : HResult; stdcall;
    function IsParameterUsed(Parameter : PAnsiChar) : Bool; stdcall;

    function Validate : HResult; stdcall;
    function _Begin(out Passes : Cardinal; const Flags : LongWord) : HResult; stdcall;
    function Pass(const Pass : Cardinal) : HResult; stdcall;
    function _End : HResult; stdcall;
    function OnLostDevice : HResult; stdcall;
    function OnResetDevice : HResult; stdcall;
  end;

(*)
[-------------------------------------------------------------------------------
[ APIs
[-------------------------------------------------------------------------------
(*)
(*)
[-------------------------------------------------------------------------------
[ D3DXCreateEffect:
[ -----------------
[ Creates an effect from an ascii or binaray effect description.
[
[ Parameters:
[  pDevice
[      Pointer of the device on which to create the effect
[  pSrcFile
[      Name of the file containing the effect description
[  hSrcModule
[      Module handle. if NULL, current module will be used.
[  pSrcResource
[      Resource name in module
[  pSrcData
[      Pointer to effect description
[  SrcDataSize
[      Size of the effect description in bytes
[  ppEffect
[      Returns a buffer containing created effect.
[  ppCompilationErrors
[      Returns a buffer containing any error messages which occurred during
[      compile.  Or NULL if you do not care about the error messages.
[-------------------------------------------------------------------------------
(*)



function D3DXCreateEffectFromFileA(Device : IDirect3DDevice8; SrcFile : PAnsiChar; out Effect : ID3DXEffect; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXCreateEffectFromFileA(Device : IDirect3DDevice8; SrcFile : PAnsiChar; out Effect : ID3DXEffect; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;

function D3DXCreateEffectFromFileW(Device : IDirect3DDevice8; SrcFile : PWideChar; out Effect : ID3DXEffect; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXCreateEffectFromFileW(Device : IDirect3DDevice8; SrcFile : PWideChar; out Effect : ID3DXEffect; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;

{$IFDEF UNICODE}
function D3DXCreateEffectFromFile(Device : IDirect3DDevice8; SrcFile : PWideChar; out Effect : ID3DXEffect; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXCreateEffectFromFile(Device : IDirect3DDevice8; SrcFile : PWideChar; out Effect : ID3DXEffect; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
{$ELSE}
function D3DXCreateEffectFromFile(Device : IDirect3DDevice8; SrcFile : PAnsiChar; out Effect : ID3DXEffect; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXCreateEffectFromFile(Device : IDirect3DDevice8; SrcFile : PAnsiChar; out Effect : ID3DXEffect; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
{$ENDIF}


function D3DXCreateEffectFromResourceA(Device : IDirect3DDevice8; const SrcModule : HMODULE; SrcResource : PAnsiChar; out Effect : ID3DXEffect; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXCreateEffectFromResourceA(Device : IDirect3DDevice8; const SrcModule : HMODULE; SrcResource : PAnsiChar; out Effect : ID3DXEffect; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;

function D3DXCreateEffectFromResourceW(Device : IDirect3DDevice8; const SrcModule : HMODULE; SrcResource : PWideChar; out Effect : ID3DXEffect; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXCreateEffectFromResourceW(Device : IDirect3DDevice8; const SrcModule : HMODULE; SrcResource : PWideChar; out Effect : ID3DXEffect; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;

{$IFDEF UNICODE}
function D3DXCreateEffectFromResource(Device : IDirect3DDevice8; const SrcModule : HMODULE; SrcResource : PWideChar; out Effect : ID3DXEffect; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXCreateEffectFromResource(Device : IDirect3DDevice8; const SrcModule : HMODULE; SrcResource : PWideChar; out Effect : ID3DXEffect; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
{$ELSE}
function D3DXCreateEffectFromResource(Device : IDirect3DDevice8; const SrcModule : HMODULE; SrcResource : PAnsiChar; out Effect : ID3DXEffect; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;
function D3DXCreateEffectFromResource(Device : IDirect3DDevice8; const SrcModule : HMODULE; SrcResource : PAnsiChar; out Effect : ID3DXEffect; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
{$ENDIF}

function D3DXCreateEffect(Device : IDirect3DDevice8; SrcData : Pointer; const SrcDataSize : Cardinal; out Effect : ID3DXEffect; CompilationErrors : PID3DXBuffer) : HResult; stdcall; overload;
function D3DXCreateEffect(Device : IDirect3DDevice8; SrcData : Pointer; const SrcDataSize : Cardinal; out Effect : ID3DXEffect; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; overload;


implementation

function D3DXToRadian(Degree : Single) : Single;
begin
  Result := Degree * (D3DX_PI / 180.0);
end;

function D3DXToDegree(Radian : Single) : Single;
begin
  Result := Radian * (180.0 / D3DX_PI);
end;

//--------------------------
// 2D Vector
//--------------------------

function D3DXVector2Zero : TD3DXVector2;
begin
  Result.x := 0;
  Result.y := 0;
end;

function D3DXVector2(const x, y : Single) : TD3DXVector2;
begin
  Result.x := x;
  Result.y := y;
end;

function D3DXVector2Equal(const v1, v2 : TD3DXVector2) : Boolean;
begin
  Result := (v1.x = v2.x) and (v1.y = v2.y);
end;

// "inline"
function D3DXVec2Length(const v : TD3DXVector2) : Single;
begin
  with v do Result := Sqrt(Sqr(x) + Sqr(y));
end;

function D3DXVec2LengthSq(const V : TD3DXVector2) : Single;
begin
  with V do Result := Sqr(x) + Sqr(y);
end;

function D3DXVec2Dot(const V1, V2 : TD3DXVector2) : Single;
begin
  Result := v1.x * v2.x + v1.y * v2.y;
end;

// Z component of ((x1,y1,0) cross (x2,y2,0))
function D3DXVec2CCW(const V1, V2 : TD3DXVector2) : Single;
begin
  Result := v1.x * v2.y - v1.y * v2.x;
end;

function D3DXVec2Add(const V1, V2 : TD3DXVector2) : TD3DXVector2;
begin
  Result.x := v1.x + v2.x;
  Result.y := v1.y + v2.y;
end;

function D3DXVec2Subtract(const V1, V2 : TD3DXVector2) : TD3DXVector2;
begin
  Result.x := v1.x - v2.x;
  Result.y := v1.y - v2.y;
end;

// Minimize each component.  x = min(x1, x2), y = min(y1, y2)
function D3DXVec2Minimize(const v1, v2 : TD3DXVector2) : TD3DXVector2;
begin
  if v1.x < v2.x then Result.x := v1.x else Result.y := v2.x;
  if v1.y < v2.y then Result.y := v1.y else Result.y := v2.y;
end;

// Maximize each component.  x = max(x1, x2), y = max(y1, y2)
function D3DXVec2Maximize(const v1, v2 : TD3DXVector2) : TD3DXVector2;
begin
  if v1.x > v2.x then Result.x := v1.x else Result.y := v2.x;
  if v1.y > v2.y then Result.y := v1.y else Result.y := v2.y;
end;

function D3DXVec2Scale(const V : TD3DXVector2; const ScaleBy : Single) : TD3DXVector2;
begin
  with Result do
  begin
    x := v.x * ScaleBy;
    y := v.y * ScaleBy;
  end;
end;

// Linear interpolation. V1 + s(V2-V1)
function D3DXVec2Lerp(const V1, V2 : TD3DXVector2; const ScaleBy : Single) : TD3DXVector2;
begin
  with Result do
  begin
    x := V1.x + ScaleBy * (V2.x - V1.x);
    y := V1.y + ScaleBy * (V2.y - V1.y);
  end;
end;

function D3DXVec2Normalize(Out, V : PD3DXVector2) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Normalize(out Out : TD3DXVector2; V : PD3DXVector2) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Normalize(Out : PD3DXVector2; var V : TD3DXVector2) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Normalize(out Out : TD3DXVector2; var V : TD3DXVector2) : PD3DXVector2; stdcall; external D3DX81DLLName;

function D3DXVec2Hermite(Out, V1, T1, V2, T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(out Out : TD3DXVector2; V1, T1, V2, T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(Out : PD3DXVector2; var V1 : TD3DXVector2; T1, V2, T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(out Out : TD3DXVector2; var V1 : TD3DXVector2; T1, V2, T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(Out, V1 : PD3DXVector2; var T1 : TD3DXVector2; V2, T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(out Out : TD3DXVector2; V1 : PD3DXVector2; var T1 : TD3DXVector2; V2, T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(Out : PD3DXVector2; var V1, T1 : TD3DXVector2; V2, T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(out Out : TD3DXVector2; var V1, T1 : TD3DXVector2; V2, T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(Out, V1, T1 : PD3DXVector2; var V2 : TD3DXVector2; T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(out Out : TD3DXVector2; V1, T1 : PD3DXVector2; var V2 : TD3DXVector2; T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(Out : PD3DXVector2; var V1 : TD3DXVector2; T1 : PD3DXVector2; var V2 : TD3DXVector2; T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(out Out : TD3DXVector2; var V1 : TD3DXVector2; T1 : PD3DXVector2; var V2 : TD3DXVector2; T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(Out, V1 : PD3DXVector2; var T1, V2 : TD3DXVector2; T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(out Out : TD3DXVector2; V1 : PD3DXVector2; var T1, V2 : TD3DXVector2; T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(Out : PD3DXVector2; var V1, T1, V2 : TD3DXVector2; T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(out Out : TD3DXVector2; var V1, T1, V2 : TD3DXVector2; T2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(Out, V1, T1, V2 : PD3DXVector2; var T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(out Out : TD3DXVector2; V1, T1, V2 : PD3DXVector2; var T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(Out : PD3DXVector2; var V1 : TD3DXVector2; T1, V2 : PD3DXVector2; var T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(out Out : TD3DXVector2; var V1 : TD3DXVector2; T1, V2 : PD3DXVector2; var T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(Out, V1 : PD3DXVector2; var T1 : TD3DXVector2; V2 : PD3DXVector2; var T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(out Out : TD3DXVector2; V1 : PD3DXVector2; var T1 : TD3DXVector2; V2 : PD3DXVector2; var T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(Out : PD3DXVector2; var V1, T1 : TD3DXVector2; V2 : PD3DXVector2; var T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(out Out : TD3DXVector2; var V1, T1 : TD3DXVector2; V2 : PD3DXVector2; var T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(Out, V1, T1 : PD3DXVector2; var V2, T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(out Out : TD3DXVector2; V1, T1 : PD3DXVector2; var V2, T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(Out : PD3DXVector2; var V1 : TD3DXVector2; T1 : PD3DXVector2; var V2, T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(out Out : TD3DXVector2; var V1 : TD3DXVector2; T1 : PD3DXVector2; var V2, T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(Out, V1 : PD3DXVector2; var T1, V2, T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(out Out : TD3DXVector2; V1 : PD3DXVector2; var T1, V2, T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(Out : PD3DXVector2; var V1, T1, V2, T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2Hermite(out Out : TD3DXVector2; var V1, T1, V2, T2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;

function D3DXVec2CatmullRom(Out, v0, v1, v2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2CatmullRom(out Out : TD3DXVector2; v0, v1, v2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2CatmullRom(Out : PD3DXVector2; var v0 : TD3DXVector2; v1, v2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2CatmullRom(out Out : TD3DXVector2; var v0 : TD3DXVector2; v1, v2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2CatmullRom(Out, v0 : PD3DXVector2; var v1 : TD3DXVector2; v2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2CatmullRom(out Out : TD3DXVector2; v0 : PD3DXVector2; var v1 : TD3DXVector2; v2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2CatmullRom(Out : PD3DXVector2; var v0, v1 : TD3DXVector2; v2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2CatmullRom(out Out : TD3DXVector2; var v0, v1 : TD3DXVector2; v2 : PD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2CatmullRom(Out, v0, v1 : PD3DXVector2; var v2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2CatmullRom(out Out : TD3DXVector2; v0, v1 : PD3DXVector2; var v2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2CatmullRom(Out : PD3DXVector2; var v0 : TD3DXVector2; v1 : PD3DXVector2; var v2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2CatmullRom(out Out : TD3DXVector2; var v0 : TD3DXVector2; v1 : PD3DXVector2; var v2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2CatmullRom(Out, v0 : PD3DXVector2; var v1, v2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2CatmullRom(out Out : TD3DXVector2; v0 : PD3DXVector2; var v1, v2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2CatmullRom(Out : PD3DXVector2; var v0, v1, v2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2CatmullRom(out Out : TD3DXVector2; var v0, v1, v2 : TD3DXVector2; s : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;

function D3DXVec2BaryCentric(Out, v1, v2, v3 : PD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2BaryCentric(out Out : TD3DXVector2; v1, v2, v3 : PD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2BaryCentric(Out : PD3DXVector2; var v1 : TD3DXVector2; v2, v3 : PD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2BaryCentric(out Out : TD3DXVector2; var v1 : TD3DXVector2; v2, v3 : PD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2BaryCentric(Out, v1 : PD3DXVector2; var v2 : TD3DXVector2; v3 : PD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2BaryCentric(out Out : TD3DXVector2; v1 : PD3DXVector2; var v2 : TD3DXVector2; v3 : PD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2BaryCentric(Out : PD3DXVector2; var v1, v2 : TD3DXVector2; v3 : PD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2BaryCentric(out Out : TD3DXVector2; var v1, v2 : TD3DXVector2; v3 : PD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2BaryCentric(Out, v1, v2 : PD3DXVector2; var v3 : TD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2BaryCentric(out Out : TD3DXVector2; v1, v2 : PD3DXVector2; var v3 : TD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2BaryCentric(Out : PD3DXVector2; var v1 : TD3DXVector2; v2 : PD3DXVector2; var v3 : TD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2BaryCentric(out Out : TD3DXVector2; var v1 : TD3DXVector2; v2 : PD3DXVector2; var v3 : TD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2BaryCentric(Out, v1 : PD3DXVector2; var v2, v3 : TD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2BaryCentric(out Out : TD3DXVector2; v1 : PD3DXVector2; var v2, v3 : TD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2BaryCentric(Out : PD3DXVector2; var v1, v2, v3 : TD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2BaryCentric(out Out : TD3DXVector2; var v1, v2, v3 : TD3DXVector2; f, g : Single) : PD3DXVector2; stdcall; external D3DX81DLLName;

function D3DXVec2Transform(Out : PD3DXVector4; v : PD3DXVector2; m : PD3DXMatrix) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec2Transform(out Out : TD3DXVector4; v : PD3DXVector2; m : PD3DXMatrix) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec2Transform(Out : PD3DXVector4; var v : TD3DXVector2; m : PD3DXMatrix) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec2Transform(out Out : TD3DXVector4; var v : TD3DXVector2; m : PD3DXMatrix) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec2Transform(Out : PD3DXVector4; v : PD3DXVector2; var m : TD3DXMatrix) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec2Transform(out Out : TD3DXVector4; v : PD3DXVector2; var m : TD3DXMatrix) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec2Transform(Out : PD3DXVector4; var v : TD3DXVector2; var m : TD3DXMatrix) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec2Transform(out Out : TD3DXVector4; var v : TD3DXVector2; var m : TD3DXMatrix) : PD3DXVector4; stdcall; external D3DX81DLLName;

function D3DXVec2TransformCoord(Out, v : PD3DXVector2; m : PD3DXMatrix) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2TransformCoord(out Out : TD3DXVector2; v : PD3DXVector2; m : PD3DXMatrix) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2TransformCoord(Out : PD3DXVector2; var v : TD3DXVector2; m : PD3DXMatrix) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2TransformCoord(out Out : TD3DXVector2; var v : TD3DXVector2; m : PD3DXMatrix) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2TransformCoord(Out, v : PD3DXVector2; var m : TD3DXMatrix) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2TransformCoord(out Out : TD3DXVector2; v : PD3DXVector2; var m : TD3DXMatrix) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2TransformCoord(Out : PD3DXVector2; var v : TD3DXVector2; var m : TD3DXMatrix) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2TransformCoord(out Out : TD3DXVector2; var v : TD3DXVector2; var m : TD3DXMatrix) : PD3DXVector2; stdcall; external D3DX81DLLName;

function D3DXVec2TransformNormal(Out, v : PD3DXVector2; m : PD3DXMatrix) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2TransformNormal(out Out : TD3DXVector2; v : PD3DXVector2; m : PD3DXMatrix) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2TransformNormal(Out : PD3DXVector2; var v : TD3DXVector2; m : PD3DXMatrix) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2TransformNormal(out Out : TD3DXVector2; var v : TD3DXVector2; m : PD3DXMatrix) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2TransformNormal(Out, v : PD3DXVector2; var m : TD3DXMatrix) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2TransformNormal(out Out : TD3DXVector2; v : PD3DXVector2; var m : TD3DXMatrix) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2TransformNormal(Out : PD3DXVector2; var v : TD3DXVector2; var m : TD3DXMatrix) : PD3DXVector2; stdcall; external D3DX81DLLName;
function D3DXVec2TransformNormal(out Out : TD3DXVector2; var v : TD3DXVector2; var m : TD3DXMatrix) : PD3DXVector2; stdcall; external D3DX81DLLName;


//--------------------------
// 3D Vector
//--------------------------

function D3DXVector3Zero : TD3DXVector3;
begin
  Result.x := 0;
  Result.y := 0;
  Result.z := 0;
end;

function D3DXVector3(const x, y, z : Single) : TD3DXVector3;
begin
  Result.x := x;
  Result.y := y;
  Result.z := z;
end;

function D3DXVector3Equal(const v1, v2 : TD3DXVector3) : Boolean;
begin
  Result := (v1.x = v2.x) and (v1.y = v2.y) and (v1.z = v2.z);
end;

// inline

function D3DXVec3Length(var V : TD3DXVector3) : Single;
begin
  with V do Result := Sqrt(Sqr(x) + Sqr(y) + Sqr(z));
end;

function D3DXVec3LengthSq(var V : TD3DXVector3) : Single;
begin
  with V do Result := Sqr(x) + Sqr(y) + Sqr(z);
end;

function D3DXVec3Dot(var V1, V2 : TD3DXVector3) : Single;
begin
  Result := V1.x * V2.x + V1.y * V2.y + V1.z * V2.z;
end;

function D3DXVec3Cross(out Out : TD3DXVector3; const V1, V2 : TD3DXVector3) : PD3DXVector3; overload;
begin
  with Out do
  begin
    x := V1.y * V2.z - V1.z * V2.y;
    y := V1.z * V2.x - V1.x * V2.z;
    z := V1.x * V2.y - V1.y * V2.x;
  end;
  Result := @Out;
end;

function D3DXVec3Cross(Out : PD3DXVector3; const V1, V2 : TD3DXVector3) : PD3DXVector3; overload;
begin
  Result := D3DXVec3Cross(Result^, V1, V2);
  if Out <> nil then
    Out := Result;

end;

function D3DXVec3Add(out Out : TD3DXVector3; var V1, V2 : TD3DXVector3) : PD3DXVector3;
begin
  with Out do
  begin
    x := V1.x + V2.x;
    y := V1.y + V2.y;
    z := V1.z + V2.z;
  end;
  Result := @Out;
end;

function D3DXVec3Subtract(out Out : TD3DXVector3; var V1, V2 : TD3DXVector3) : PD3DXVector3;
begin
  with Out do
  begin
    x := V1.x - V2.x;
    y := V1.y - V2.y;
    z := V1.z - V2.z;
  end;
  Result := @Out;
end;

// Minimize each component.  x = min(x1, x2), y = min(y1, y2), ...
function D3DXVec3Minimize(out Out : TD3DXVector3; var V1, V2 : TD3DXVector3) : PD3DXVector3;
begin
  with Out do
  begin
    if V1.x < V2.x then x := V1.x else x := V2.x;
    if V1.y < V2.y then y := V1.y else y := V2.y;
    if V1.z < V2.z then z := V1.z else z := V2.z;
  end;
  Result := @Out;
end;

// Maximize each component.  x = max(x1, x2), y = max(y1, y2), ...
function D3DXVec3Maximize(out Out : TD3DXVector3; var V1, V2 : TD3DXVector3) : PD3DXVector3;
begin
  with Out do
  begin
    if V1.x > V2.x then x := V1.x else x := V2.x;
    if V1.y > V2.y then y := V1.y else y := V2.y;
    if V1.z > V2.z then z := V1.z else z := V2.z;
  end;
  Result := @Out;
end;

function D3DXVec3Scale(out Out : TD3DXVector3; var V : TD3DXVector3; s : Single) : PD3DXVector3;
begin
  with Out do
  begin
    x := V.x * s;
    y := V.y * s;
    z := V.z * s;
  end;
  Result := @Out;
end;

// Linear interpolation. V1 + s(V2-V1)
function D3DXVec3Lerp(out Out : TD3DXVector3; var V1, V2 : TD3DXVector3; s : Single) : PD3DXVector3;
begin
  with Out do
  begin
    x := V1.x + s * (V2.x - V1.x);
    y := V1.y + s * (V2.y - V1.y);
    z := V1.z + s * (V2.z - V1.z);
  end;
  Result := @Out;
end;

// non-inline

function D3DXVec3Normalize(Out, V : PD3DXVector3) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Normalize(out Out : TD3DXVector3; V : PD3DXVector3) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Normalize(Out : PD3DXVector3; var V : TD3DXVector3) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Normalize(out Out : TD3DXVector3; var V : TD3DXVector3) : PD3DXVector3; stdcall; external D3DX81DLLName;

function D3DXVec3Hermite(Out, V1, T1, V2, T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(out Out : TD3DXVector3; V1, T1, V2, T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(Out : PD3DXVector3; var V1 : TD3DXVector3; T1, V2, T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(out Out : TD3DXVector3; var V1 : TD3DXVector3; T1, V2, T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(Out, V1 : PD3DXVector3; var T1 : TD3DXVector3; V2, T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(out Out : TD3DXVector3; V1 : PD3DXVector3; var T1 : TD3DXVector3; V2, T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(Out : PD3DXVector3; var V1, T1 : TD3DXVector3; V2, T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(out Out : TD3DXVector3; var V1, T1 : TD3DXVector3; V2, T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(Out, V1, T1 : PD3DXVector3; var V2 : TD3DXVector3; T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(out Out : TD3DXVector3; V1, T1 : PD3DXVector3; var V2 : TD3DXVector3; T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(Out : PD3DXVector3; var V1 : TD3DXVector3; T1 : PD3DXVector3; var V2 : TD3DXVector3; T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(out Out : TD3DXVector3; var V1 : TD3DXVector3; T1 : PD3DXVector3; var V2 : TD3DXVector3; T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(Out, V1 : PD3DXVector3; var T1, V2 : TD3DXVector3; T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(out Out : TD3DXVector3; V1 : PD3DXVector3; var T1, V2 : TD3DXVector3; T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(Out : PD3DXVector3; var V1, T1, V2 : TD3DXVector3; T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(out Out : TD3DXVector3; var V1, T1, V2 : TD3DXVector3; T2 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(Out, V1, T1, V2 : PD3DXVector3; var T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(out Out : TD3DXVector3; V1, T1, V2 : PD3DXVector3; var T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(Out : PD3DXVector3; var V1 : TD3DXVector3; T1, V2 : PD3DXVector3; var T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(out Out : TD3DXVector3; var V1 : TD3DXVector3; T1, V2 : PD3DXVector3; var T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(Out, V1 : PD3DXVector3; var T1 : TD3DXVector3; V2 : PD3DXVector3; var T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(out Out : TD3DXVector3; V1 : PD3DXVector3; var T1 : TD3DXVector3; V2 : PD3DXVector3; var T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(Out : PD3DXVector3; var V1, T1 : TD3DXVector3; V2 : PD3DXVector3; var T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(out Out : TD3DXVector3; var V1, T1 : TD3DXVector3; V2 : PD3DXVector3; var T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(Out, V1, T1 : PD3DXVector3; var V2, T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(out Out : TD3DXVector3; V1, T1 : PD3DXVector3; var V2, T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(Out : PD3DXVector3; var V1 : TD3DXVector3; T1 : PD3DXVector3; var V2, T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(out Out : TD3DXVector3; var V1 : TD3DXVector3; T1 : PD3DXVector3; var V2, T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(Out, V1 : PD3DXVector3; var T1, V2, T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(out Out : TD3DXVector3; V1 : PD3DXVector3; var T1, V2, T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(Out : PD3DXVector3; var V1, T1, V2, T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Hermite(out Out : TD3DXVector3; var V1, T1, V2, T2 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;

function D3DXVec3CatmullRom(Out, pV0, V1, V2, V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; pV0, V1, V2, V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(Out : PD3DXVector3; var pV0 : TD3DXVector3; V1, V2, V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; var pV0 : TD3DXVector3; V1, V2, V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(Out, pV0 : PD3DXVector3; var V1 : TD3DXVector3; V2, V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; pV0 : PD3DXVector3; var V1 : TD3DXVector3; V2, V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(Out : PD3DXVector3; var pV0, V1 : TD3DXVector3; V2, V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; var pV0, V1 : TD3DXVector3; V2, V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(Out, pV0, V1 : PD3DXVector3; var V2 : TD3DXVector3; V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; pV0, V1 : PD3DXVector3; var V2 : TD3DXVector3; V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(Out : PD3DXVector3; var pV0 : TD3DXVector3; V1 : PD3DXVector3; var V2 : TD3DXVector3; V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; var pV0 : TD3DXVector3; V1 : PD3DXVector3; var V2 : TD3DXVector3; V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(Out, pV0 : PD3DXVector3; var V1, V2 : TD3DXVector3; V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; pV0 : PD3DXVector3; var V1, V2 : TD3DXVector3; V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(Out : PD3DXVector3; var pV0, V1, V2 : TD3DXVector3; V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; var pV0, V1, V2 : TD3DXVector3; V3 : PD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(Out, pV0, V1, V2 : PD3DXVector3; var V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; pV0, V1, V2 : PD3DXVector3; var V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(Out : PD3DXVector3; var pV0 : TD3DXVector3; V1, V2 : PD3DXVector3; var V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; var pV0 : TD3DXVector3; V1, V2 : PD3DXVector3; var V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(Out, pV0 : PD3DXVector3; var V1 : TD3DXVector3; V2 : PD3DXVector3; var V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; pV0 : PD3DXVector3; var V1 : TD3DXVector3; V2 : PD3DXVector3; var V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(Out : PD3DXVector3; var pV0, V1 : TD3DXVector3; V2 : PD3DXVector3; var V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; var pV0, V1 : TD3DXVector3; V2 : PD3DXVector3; var V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(Out, pV0, V1 : PD3DXVector3; var V2, V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; pV0, V1 : PD3DXVector3; var V2, V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(Out : PD3DXVector3; var pV0 : TD3DXVector3; V1 : PD3DXVector3; var V2, V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; var pV0 : TD3DXVector3; V1 : PD3DXVector3; var V2, V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(Out, pV0 : PD3DXVector3; var V1, V2, V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; pV0 : PD3DXVector3; var V1, V2, V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(Out : PD3DXVector3; var pV0, V1, V2, V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3CatmullRom(out Out : TD3DXVector3; var pV0, V1, V2, V3 : TD3DXVector3; s : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;

function D3DXVec3BaryCentric(Out, V1, V2, V3 : PD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3BaryCentric(out Out : TD3DXVector3; V1, V2, V3 : PD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3BaryCentric(Out : PD3DXVector3; var V1 : TD3DXVector3; V2, V3 : PD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3BaryCentric(out Out : TD3DXVector3; var V1 : TD3DXVector3; V2, V3 : PD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3BaryCentric(Out, V1 : PD3DXVector3; var V2 : TD3DXVector3; V3 : PD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3BaryCentric(out Out : TD3DXVector3; V1 : PD3DXVector3; var V2 : TD3DXVector3; V3 : PD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3BaryCentric(Out : PD3DXVector3; var V1, V2 : TD3DXVector3; V3 : PD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3BaryCentric(out Out : TD3DXVector3; var V1, V2 : TD3DXVector3; V3 : PD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3BaryCentric(Out, V1, V2 : PD3DXVector3; var V3 : TD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3BaryCentric(out Out : TD3DXVector3; V1, V2 : PD3DXVector3; var V3 : TD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3BaryCentric(Out : PD3DXVector3; var V1 : TD3DXVector3; V2 : PD3DXVector3; var V3 : TD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3BaryCentric(out Out : TD3DXVector3; var V1 : TD3DXVector3; V2 : PD3DXVector3; var V3 : TD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3BaryCentric(Out, V1 : PD3DXVector3; var V2, V3 : TD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3BaryCentric(out Out : TD3DXVector3; V1 : PD3DXVector3; var V2, V3 : TD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3BaryCentric(Out : PD3DXVector3; var V1, V2, V3 : TD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3BaryCentric(out Out : TD3DXVector3; var V1, V2, V3 : TD3DXVector3; f, g : Single) : PD3DXVector3; stdcall; external D3DX81DLLName;

function D3DXVec3Transform(Out : PD3DXVector4; V : PD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Transform(out Out : TD3DXVector4; V : PD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Transform(Out : PD3DXVector4; var V : TD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Transform(out Out : TD3DXVector4; var V : TD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Transform(Out : PD3DXVector4; V : PD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Transform(out Out : TD3DXVector4; V : PD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Transform(Out : PD3DXVector4; var V : TD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Transform(out Out : TD3DXVector4; var V : TD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;

function D3DXVec3TransformCoord(Out, V : PD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3TransformCoord(out Out : TD3DXVector3; V : PD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3TransformCoord(Out : PD3DXVector3; var V : TD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3TransformCoord(out Out : TD3DXVector3; var V : TD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3TransformCoord(Out, V : PD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3TransformCoord(out Out : TD3DXVector3; V : PD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3TransformCoord(Out : PD3DXVector3; var V : TD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3TransformCoord(out Out : TD3DXVector3; var V : TD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;

function D3DXVec3TransformNormal(Out, V : PD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3TransformNormal(out Out : TD3DXVector3; V : PD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3TransformNormal(Out : PD3DXVector3; var V : TD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3TransformNormal(out Out : TD3DXVector3; var V : TD3DXVector3; M : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3TransformNormal(Out, V : PD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3TransformNormal(out Out : TD3DXVector3; V : PD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3TransformNormal(Out : PD3DXVector3; var V : TD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3TransformNormal(out Out : TD3DXVector3; var V : TD3DXVector3; var M : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;

function D3DXVec3Project(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Project(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;

function D3DXVec3Unproject(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView, pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView : TD3DXMatrix; pWorld : PD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection, pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection : TD3DXMatrix; pView : PD3DXMatrix; var pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; Projection : PD3DXMatrix; var pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out, V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; pViewport : PD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out, V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; V : PD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(Out : PD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;
function D3DXVec3Unproject(out Out : TD3DXVector3; var V : TD3DXVector3; var pViewport : TD3DViewPort8; var Projection, pView, pWorld : TD3DXMatrix) : PD3DXVector3; stdcall; external D3DX81DLLName;


//--------------------------
// 4D Vector
//--------------------------

function D3DXVector4Zero : TD3DXVector4;
begin
  Result.x := 0;
  Result.y := 0;
  Result.z := 0;
  Result.w := 0;
end;

function D3DXVector4(const x, y, z, w : Single) : TD3DXVector4;
begin
  Result.x := x;
  Result.y := y;
  Result.z := z;
  Result.w := w;
end;

function D3DXVector4Equal(const v1, v2 : TD3DXVector4) : Boolean;
begin
  Result:= (v1.x = v2.x) and (v1.y = v2.y) and (v1.z = v2.z) and (v1.w = v2.w);
end;

function D3DXVec4Length(var V : TD3DXVector4) : Single;
begin
  with V do Result := Sqrt(Sqr(x) + Sqr(y) + Sqr(z) + Sqr(w));
end;

function D3DXVec4LengthSq(var V : TD3DXVector4) : Single;
begin
  with V do Result := Sqr(x) + Sqr(y) + Sqr(z) + Sqr(w);
end;

function D3DXVec4Dot(var V1, V2 : TD3DXVector4) : Single;
begin
  Result := V1.x * V2.x + V1.y * V2.y + V1.z * V2.z + V1.w * V2.w;
end;

function D3DXVec4Add(out Out : TD3DXVector4; var V1, V2 : TD3DXVector4) : PD3DXVector4;
begin
  with Out do
  begin
    x := V1.x + V2.x;
    y := V1.y + V2.y;
    z := V1.z + V2.z;
    w := V1.w + V2.w;
  end;
  Result := @Out;
end;

function D3DXVec4Subtract(out Out : TD3DXVector4; var V1, V2 : TD3DXVector4) : PD3DXVector4;
begin
  with Out do
  begin
    x := V1.x - V2.x;
    y := V1.y - V2.y;
    z := V1.z - V2.z;
    w := V1.w - V2.w;
  end;
  Result := @Out;
end;

// Minimize each component.  x = min(x1, x2), y = min(y1, y2), ...
function D3DXVec4Minimize(out Out : TD3DXVector4; var V1, V2 : TD3DXVector4) : PD3DXVector4;
begin
  with Out do
  begin
    if V1.x < V2.x then x := V1.x else x := V2.x;
    if V1.y < V2.y then y := V1.y else y := V2.y;
    if V1.z < V2.z then z := V1.z else z := V2.z;
    if V1.w < V2.w then w := V1.w else w := V2.w;
  end;
  Result := @Out;
end;

// Maximize each component.  x = max(x1, x2), y = max(y1, y2), ...
function D3DXVec4Maximize(out Out : TD3DXVector4; var V1, V2 : TD3DXVector4) : PD3DXVector4;
begin
  with Out do
  begin
    if V1.x > V2.x then x := V1.x else x := V2.x;
    if V1.y > V2.y then y := V1.y else y := V2.y;
    if V1.z > V2.z then z := V1.z else z := V2.z;
    if V1.w > V2.w then w := V1.w else w := V2.w;
  end;
  Result := @Out;
end;

function D3DXVec4Scale(out Out : TD3DXVector4; var V : TD3DXVector4; s : Single) : PD3DXVector4;
begin
  with Out do
  begin
    x := V.x * s;
    y := V.y * s;
    z := V.z * s;
    w := V.w * s;
  end;
  Result := @Out;
end;

// Linear interpolation. V1 + s(V2-V1)
function D3DXVec4Lerp(out Out : TD3DXVector4; var V1, V2 : TD3DXVector4; s : Single) : PD3DXVector4;
begin
  with Out do
  begin
    x := V1.x + s * (V2.x - V1.x);
    y := V1.y + s * (V2.y - V1.y);
    z := V1.z + s * (V2.z - V1.z);
    w := V1.w + s * (V2.w - V1.w);
  end;
  Result := @Out;
end;

// non-inline

function D3DXVec4Cross(Out, V1, V2, V3 : PD3DXVector4) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Cross(out Out : TD3DXVector4; V1, V2, V3 : PD3DXVector4) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Cross(Out : PD3DXVector4; var V1 : TD3DXVector4; V2, V3 : PD3DXVector4) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Cross(out Out : TD3DXVector4; var V1 : TD3DXVector4; V2, V3 : PD3DXVector4) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Cross(Out, V1 : PD3DXVector4; var V2 : TD3DXVector4; V3 : PD3DXVector4) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Cross(out Out : TD3DXVector4; V1 : PD3DXVector4; var V2 : TD3DXVector4; V3 : PD3DXVector4) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Cross(Out : PD3DXVector4; var V1, V2 : TD3DXVector4; V3 : PD3DXVector4) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Cross(out Out : TD3DXVector4; var V1, V2 : TD3DXVector4; V3 : PD3DXVector4) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Cross(Out, V1, V2 : PD3DXVector4; var V3 : TD3DXVector4) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Cross(out Out : TD3DXVector4; V1, V2 : PD3DXVector4; var V3 : TD3DXVector4) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Cross(Out : PD3DXVector4; var V1 : TD3DXVector4; V2 : PD3DXVector4; var V3 : TD3DXVector4) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Cross(out Out : TD3DXVector4; var V1 : TD3DXVector4; V2 : PD3DXVector4; var V3 : TD3DXVector4) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Cross(Out, V1 : PD3DXVector4; var V2, V3 : TD3DXVector4) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Cross(out Out : TD3DXVector4; V1 : PD3DXVector4; var V2, V3 : TD3DXVector4) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Cross(Out : PD3DXVector4; var V1, V2, V3 : TD3DXVector4) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Cross(out Out : TD3DXVector4; var V1, V2, V3 : TD3DXVector4) : PD3DXVector4; stdcall; external D3DX81DLLName;

function D3DXVec4Normalize(Out, V : PD3DXVector4) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Normalize(out Out : TD3DXVector4; V : PD3DXVector4) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Normalize(Out : PD3DXVector4; var V : TD3DXVector4) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Normalize(out Out : TD3DXVector4; var V : TD3DXVector4) : PD3DXVector4; stdcall; external D3DX81DLLName;

function D3DXVec4Hermite(Out, V1, T1, V2, T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(out Out : TD3DXVector4; V1, T1, V2, T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(Out : PD3DXVector4; var V1 : TD3DXVector4; T1, V2, T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(out Out : TD3DXVector4; var V1 : TD3DXVector4; T1, V2, T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(Out, V1 : PD3DXVector4; var T1 : TD3DXVector4; V2, T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(out Out : TD3DXVector4; V1 : PD3DXVector4; var T1 : TD3DXVector4; V2, T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(Out : PD3DXVector4; var V1, T1 : TD3DXVector4; V2, T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(out Out : TD3DXVector4; var V1, T1 : TD3DXVector4; V2, T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(Out, V1, T1 : PD3DXVector4; var V2 : TD3DXVector4; T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(out Out : TD3DXVector4; V1, T1 : PD3DXVector4; var V2 : TD3DXVector4; T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(Out : PD3DXVector4; var V1 : TD3DXVector4; T1 : PD3DXVector4; var V2 : TD3DXVector4; T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(out Out : TD3DXVector4; var V1 : TD3DXVector4; T1 : PD3DXVector4; var V2 : TD3DXVector4; T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(Out, V1 : PD3DXVector4; var T1, V2 : TD3DXVector4; T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(out Out : TD3DXVector4; V1 : PD3DXVector4; var T1, V2 : TD3DXVector4; T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(Out : PD3DXVector4; var V1, T1, V2 : TD3DXVector4; T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(out Out : TD3DXVector4; var V1, T1, V2 : TD3DXVector4; T2 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(Out, V1, T1, V2 : PD3DXVector4; var T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(out Out : TD3DXVector4; V1, T1, V2 : PD3DXVector4; var T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(Out : PD3DXVector4; var V1 : TD3DXVector4; T1, V2 : PD3DXVector4; var T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(out Out : TD3DXVector4; var V1 : TD3DXVector4; T1, V2 : PD3DXVector4; var T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(Out, V1 : PD3DXVector4; var T1 : TD3DXVector4; V2 : PD3DXVector4; var T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(out Out : TD3DXVector4; V1 : PD3DXVector4; var T1 : TD3DXVector4; V2 : PD3DXVector4; var T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(Out : PD3DXVector4; var V1, T1 : TD3DXVector4; V2 : PD3DXVector4; var T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(out Out : TD3DXVector4; var V1, T1 : TD3DXVector4; V2 : PD3DXVector4; var T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(Out, V1, T1 : PD3DXVector4; var V2, T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(out Out : TD3DXVector4; V1, T1 : PD3DXVector4; var V2, T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(Out : PD3DXVector4; var V1 : TD3DXVector4; T1 : PD3DXVector4; var V2, T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(out Out : TD3DXVector4; var V1 : TD3DXVector4; T1 : PD3DXVector4; var V2, T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(Out, V1 : PD3DXVector4; var T1, V2, T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(out Out : TD3DXVector4; V1 : PD3DXVector4; var T1, V2, T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(Out : PD3DXVector4; var V1, T1, V2, T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Hermite(out Out : TD3DXVector4; var V1, T1, V2, T2 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;

function D3DXVec4CatmullRom(Out, pV0, V1, V2, V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; pV0, V1, V2, V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(Out : PD3DXVector4; var pV0 : TD3DXVector4; V1, V2, V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; var pV0 : TD3DXVector4; V1, V2, V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(Out, pV0 : PD3DXVector4; var V1 : TD3DXVector4; V2, V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; pV0 : PD3DXVector4; var V1 : TD3DXVector4; V2, V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(Out : PD3DXVector4; var pV0, V1 : TD3DXVector4; V2, V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; var pV0, V1 : TD3DXVector4; V2, V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(Out, pV0, V1 : PD3DXVector4; var V2 : TD3DXVector4; V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; pV0, V1 : PD3DXVector4; var V2 : TD3DXVector4; V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(Out : PD3DXVector4; var pV0 : TD3DXVector4; V1 : PD3DXVector4; var V2 : TD3DXVector4; V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; var pV0 : TD3DXVector4; V1 : PD3DXVector4; var V2 : TD3DXVector4; V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(Out, pV0 : PD3DXVector4; var V1, V2 : TD3DXVector4; V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; pV0 : PD3DXVector4; var V1, V2 : TD3DXVector4; V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(Out : PD3DXVector4; var pV0, V1, V2 : TD3DXVector4; V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; var pV0, V1, V2 : TD3DXVector4; V3 : PD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(Out, pV0, V1, V2 : PD3DXVector4; var V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; pV0, V1, V2 : PD3DXVector4; var V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(Out : PD3DXVector4; var pV0 : TD3DXVector4; V1, V2 : PD3DXVector4; var V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; var pV0 : TD3DXVector4; V1, V2 : PD3DXVector4; var V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(Out, pV0 : PD3DXVector4; var V1 : TD3DXVector4; V2 : PD3DXVector4; var V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; pV0 : PD3DXVector4; var V1 : TD3DXVector4; V2 : PD3DXVector4; var V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(Out : PD3DXVector4; var pV0, V1 : TD3DXVector4; V2 : PD3DXVector4; var V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; var pV0, V1 : TD3DXVector4; V2 : PD3DXVector4; var V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(Out, pV0, V1 : PD3DXVector4; var V2, V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; pV0, V1 : PD3DXVector4; var V2, V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(Out : PD3DXVector4; var pV0 : TD3DXVector4; V1 : PD3DXVector4; var V2, V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; var pV0 : TD3DXVector4; V1 : PD3DXVector4; var V2, V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(Out, pV0 : PD3DXVector4; var V1, V2, V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; pV0 : PD3DXVector4; var V1, V2, V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(Out : PD3DXVector4; var pV0, V1, V2, V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4CatmullRom(out Out : TD3DXVector4; var pV0, V1, V2, V3 : TD3DXVector4; s : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;

function D3DXVec4BaryCentric(Out, V1, V2, V3 : PD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4BaryCentric(out Out : TD3DXVector4; V1, V2, V3 : PD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4BaryCentric(Out : PD3DXVector4; var V1 : TD3DXVector4; V2, V3 : PD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4BaryCentric(out Out : TD3DXVector4; var V1 : TD3DXVector4; V2, V3 : PD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4BaryCentric(Out, V1 : PD3DXVector4; var V2 : TD3DXVector4; V3 : PD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4BaryCentric(out Out : TD3DXVector4; V1 : PD3DXVector4; var V2 : TD3DXVector4; V3 : PD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4BaryCentric(Out : PD3DXVector4; var V1, V2 : TD3DXVector4; V3 : PD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4BaryCentric(out Out : TD3DXVector4; var V1, V2 : TD3DXVector4; V3 : PD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4BaryCentric(Out, V1, V2 : PD3DXVector4; var V3 : TD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4BaryCentric(out Out : TD3DXVector4; V1, V2 : PD3DXVector4; var V3 : TD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4BaryCentric(Out : PD3DXVector4; var V1 : TD3DXVector4; V2 : PD3DXVector4; var V3 : TD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4BaryCentric(out Out : TD3DXVector4; var V1 : TD3DXVector4; V2 : PD3DXVector4; var V3 : TD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4BaryCentric(Out, V1 : PD3DXVector4; var V2, V3 : TD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4BaryCentric(out Out : TD3DXVector4; V1 : PD3DXVector4; var V2, V3 : TD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4BaryCentric(Out : PD3DXVector4; var V1, V2, V3 : TD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4BaryCentric(out Out : TD3DXVector4; var V1, V2, V3 : TD3DXVector4; f, g : Single) : PD3DXVector4; stdcall; external D3DX81DLLName;

function D3DXVec4Transform(Out, V : PD3DXVector4; M : PD3DXMatrix) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Transform(out Out : TD3DXVector4; V : PD3DXVector4; M : PD3DXMatrix) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Transform(Out : PD3DXVector4; var V : TD3DXVector4; M : PD3DXMatrix) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Transform(out Out : TD3DXVector4; var V : TD3DXVector4; M : PD3DXMatrix) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Transform(Out, V : PD3DXVector4; var M : TD3DXMatrix) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Transform(out Out : TD3DXVector4; V : PD3DXVector4; var M : TD3DXMatrix) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Transform(Out : PD3DXVector4; var V : TD3DXVector4; var M : TD3DXMatrix) : PD3DXVector4; stdcall; external D3DX81DLLName;
function D3DXVec4Transform(out Out : TD3DXVector4; var V : TD3DXVector4; var M : TD3DXMatrix) : PD3DXVector4; stdcall; external D3DX81DLLName;

//------------------------------------------------------------------------------
//
// Matrices
//
//------------------------------------------------------------------------------


function D3DXMatrix(m00, m01, m02, m03,
                    m10, m11, m12, m13,
                    m20, m21, m22, m23,
                    m30, m31, m32, m33 : Single) : TD3DXMatrix;
begin
  with Result do
  begin
    m[0,0] := m00;
    m[0,1] := m01;
    m[0,2] := m02;
    m[0,3] := m03;
    m[1,0] := m10;
    m[1,1] := m11;
    m[1,2] := m12;
    m[1,3] := m13;
    m[2,0] := m20;
    m[2,1] := m21;
    m[2,2] := m22;
    m[2,3] := m23;
    m[3,0] := m30;
    m[3,1] := m31;
    m[3,2] := m32;
    m[3,3] := m33;
  end;
end;

function D3DXMatrixAdd(const m1, m2 : TD3DXMatrix) : TD3DXMatrix;
var i,j : Byte;
begin
  for i := 0 to 3 do
    for j := 0 to 3 do
     Result.m[i,j] := m1.m[i,j] + m2.m[i,j];
end;

function D3DXMatrixSubtract(const m1, m2 : TD3DXMatrix) : TD3DXMatrix;
var i, j : Byte;
begin
  for i := 0 to 3 do
    for j := 0 to 3 do
     Result.m[i,j] := m1.m[i,j] - m2.m[i,j];
end;

function D3DXMatrixScale(const m : TD3DXMatrix; const ScaleBy : Single) : TD3DXMatrix;
var i, j : Byte;
begin
  for i := 0 to 3 do
    for j := 0 to 3 do
      Result.m[i,j] := m.m[i,j] * ScaleBy;
end;

function D3DXMatrixEqual(const m1, m2 : TD3DXMatrix) : Boolean;
begin
  Result := CompareMem(@m1, @m2, SizeOf(TD3DXMatrix));
end;

// inline

function D3DXMatrixIdentity(out Out : TD3DXMatrix) : PD3DXMatrix;
begin
  Out := IdentityMatrix;

{  FillChar(Out, SizeOf(Out), 0);
  Out._11 := 1;
  Out._22 := 1;
  Out._33 := 1;
  Out._44 := 1;}

  Result := @Out;
end;

function D3DXMatrixIsIdentity(var M : TD3DXMatrix) : Boolean;
begin
  Result := CompareMem(@IdentityMatrix, @M, SizeOf(m));
end;

function D3DXMatrixfDeterminant(M : PD3DXMatrix) : Single; stdcall; external D3DX81DLLName;
function D3DXMatrixfDeterminant(var M : TD3DXMatrix) : Single; stdcall; external D3DX81DLLName;

function D3DXMatrixTranspose(Out, M : PD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTranspose(out Out : TD3DXMatrix; M : PD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTranspose(Out : PD3DXMatrix; var M : TD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTranspose(out Out : TD3DXMatrix; var M : TD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;

function D3DXMatrixMultiply(Out, M1, M2 : PD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixMultiply(out Out : TD3DXMatrix; M1, M2 : PD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixMultiply(Out : PD3DXMatrix; var M1 : TD3DXMatrix; M2 : PD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixMultiply(out Out : TD3DXMatrix; var M1 : TD3DXMatrix; M2 : PD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixMultiply(Out, M1 : PD3DXMatrix; var M2 : TD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixMultiply(out Out : TD3DXMatrix; M1 : PD3DXMatrix; var M2 : TD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixMultiply(Out : PD3DXMatrix; var M1, M2 : TD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixMultiply(out Out : TD3DXMatrix; var M1, M2 : TD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;

function D3DXMatrixMultiplyTranspose(Out, M1, M2 : PD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixMultiplyTranspose(out Out : TD3DXMatrix; M1, M2 : PD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixMultiplyTranspose(Out : PD3DXMatrix; var M1 : TD3DXMatrix; M2 : PD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixMultiplyTranspose(out Out : TD3DXMatrix; var M1 : TD3DXMatrix; M2 : PD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixMultiplyTranspose(Out, M1 : PD3DXMatrix; var M2 : TD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixMultiplyTranspose(out Out : TD3DXMatrix; M1 : PD3DXMatrix; var M2 : TD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixMultiplyTranspose(Out : PD3DXMatrix; var M1, M2 : TD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixMultiplyTranspose(out Out : TD3DXMatrix; var M1, M2 : TD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;

function D3DXMatrixInverse(Out : PD3DXMatrix; pDeterminant : PSingle; M : PD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixInverse(out Out : TD3DXMatrix; pDeterminant : PSingle; M : PD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixInverse(Out : PD3DXMatrix; var pDeterminant : Single; M : PD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixInverse(out Out : TD3DXMatrix; var pDeterminant : Single; M : PD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixInverse(Out : PD3DXMatrix; pDeterminant : PSingle; var M : TD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixInverse(out Out : TD3DXMatrix; pDeterminant : PSingle; var M : TD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixInverse(Out : PD3DXMatrix; var pDeterminant : Single; var M : TD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixInverse(out Out : TD3DXMatrix; var pDeterminant : Single; var M : TD3DXMatrix) : PD3DXMatrix; stdcall; external D3DX81DLLName;

function D3DXMatrixScaling(Out : PD3DXMatrix; sx, sy, sz : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixScaling(out Out : TD3DXMatrix; sx, sy, sz : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;

function D3DXMatrixTranslation(Out : PD3DXMatrix; x, y, z : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTranslation(out Out : TD3DXMatrix; x, y, z : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTranslation(Out : PD3DXMatrix; xyz : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTranslation(out Out : TD3DXMatrix; xyz : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;

function D3DXMatrixRotationX(Out : PD3DXMatrix; Angle : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixRotationX(out Out : TD3DXMatrix; Angle : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;

function D3DXMatrixRotationY(Out : PD3DXMatrix; Angle : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixRotationY(out Out : TD3DXMatrix; Angle : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;

// Build a matrix which rotates around the Z axis
function D3DXMatrixRotationZ(Out : PD3DXMatrix; Angle : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixRotationZ(out Out : TD3DXMatrix; Angle : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;

function D3DXMatrixRotationAxis(Out : PD3DXMatrix; V : PD3DXVector3; Angle : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixRotationAxis(out Out : TD3DXMatrix; V : PD3DXVector3; Angle : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixRotationAxis(Out : PD3DXMatrix; var V : TD3DXVector3; Angle : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixRotationAxis(out Out : TD3DXMatrix; var V : TD3DXVector3; Angle : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;

function D3DXMatrixRotationQuaternion(Out : PD3DXMatrix; Q : PD3DXQuaternion) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixRotationQuaternion(out Out : TD3DXMatrix; Q : PD3DXQuaternion) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixRotationQuaternion(Out : PD3DXMatrix; var Q : TD3DXQuaternion) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixRotationQuaternion(out Out : TD3DXMatrix; var Q : TD3DXQuaternion) : PD3DXMatrix; stdcall; external D3DX81DLLName;

function D3DXMatrixRotationYawPitchRoll(Out : PD3DXMatrix; Yaw, Pitch, Roll : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixRotationYawPitchRoll(out Out : TD3DXMatrix; Yaw, Pitch, Roll : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;

function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling, RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling : TD3DXVector3; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; Scaling : PD3DXVector3; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; ScalingRotation : PD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; ScalingCenter : PD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(Out : PD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixTransformation(out Out : TD3DXMatrix; var ScalingCenter : TD3DXVector3; var ScalingRotation : TD3DXQuaternion; var Scaling, RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;

function D3DXMatrixAffineTransformation(Out : PD3DXMatrix; Scaling : Single; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixAffineTransformation(out Out : TD3DXMatrix; Scaling : Single; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixAffineTransformation(Out : PD3DXMatrix; Scaling : Single; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixAffineTransformation(out Out : TD3DXMatrix; Scaling : Single; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixAffineTransformation(Out : PD3DXMatrix; Scaling : Single; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixAffineTransformation(out Out : TD3DXMatrix; Scaling : Single; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixAffineTransformation(Out : PD3DXMatrix; Scaling : Single; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixAffineTransformation(out Out : TD3DXMatrix; Scaling : Single; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; Translation : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixAffineTransformation(Out : PD3DXMatrix; Scaling : Single; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixAffineTransformation(out Out : TD3DXMatrix; Scaling : Single; RotationCenter : PD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixAffineTransformation(Out : PD3DXMatrix; Scaling : Single; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixAffineTransformation(out Out : TD3DXMatrix; Scaling : Single; var RotationCenter : TD3DXVector3; Rotation : PD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixAffineTransformation(Out : PD3DXMatrix; Scaling : Single; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixAffineTransformation(out Out : TD3DXMatrix; Scaling : Single; RotationCenter : PD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixAffineTransformation(Out : PD3DXMatrix; Scaling : Single; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixAffineTransformation(out Out : TD3DXMatrix; Scaling : Single; var RotationCenter : TD3DXVector3; var Rotation : TD3DXQuaternion; var Translation : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;

function D3DXMatrixLookAtRH(Out : PD3DXMatrix; pEye, pAt, pUp : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtRH(out Out : TD3DXMatrix; pEye, pAt, pUp : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtRH(Out : PD3DXMatrix; var pEye : TD3DXVector3; pAt, pUp : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtRH(out Out : TD3DXMatrix; var pEye : TD3DXVector3; pAt, pUp : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtRH(Out : PD3DXMatrix; pEye : PD3DXVector3; var pAt : TD3DXVector3; pUp : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtRH(out Out : TD3DXMatrix; pEye : PD3DXVector3; var pAt : TD3DXVector3; pUp : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtRH(Out : PD3DXMatrix; var pEye, pAt : TD3DXVector3; pUp : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtRH(out Out : TD3DXMatrix; var pEye, pAt : TD3DXVector3; pUp : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtRH(Out : PD3DXMatrix; pEye, pAt : PD3DXVector3; var pUp : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtRH(out Out : TD3DXMatrix; pEye, pAt : PD3DXVector3; var pUp : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtRH(Out : PD3DXMatrix; var pEye : TD3DXVector3; pAt : PD3DXVector3; var pUp : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtRH(out Out : TD3DXMatrix; var pEye : TD3DXVector3; pAt : PD3DXVector3; var pUp : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtRH(Out : PD3DXMatrix; pEye : PD3DXVector3; var pAt, pUp : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtRH(out Out : TD3DXMatrix; pEye : PD3DXVector3; var pAt, pUp : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtRH(Out : PD3DXMatrix; var pEye, pAt, pUp : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtRH(out Out : TD3DXMatrix; var pEye, pAt, pUp : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;

function D3DXMatrixLookAtLH(Out : PD3DXMatrix; pEye, pAt, pUp : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtLH(out Out : TD3DXMatrix; pEye, pAt, pUp : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtLH(Out : PD3DXMatrix; var pEye : TD3DXVector3; pAt, pUp : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtLH(out Out : TD3DXMatrix; var pEye : TD3DXVector3; pAt, pUp : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtLH(Out : PD3DXMatrix; pEye : PD3DXVector3; var pAt : TD3DXVector3; pUp : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtLH(out Out : TD3DXMatrix; pEye : PD3DXVector3; var pAt : TD3DXVector3; pUp : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtLH(Out : PD3DXMatrix; var pEye, pAt : TD3DXVector3; pUp : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtLH(out Out : TD3DXMatrix; var pEye, pAt : TD3DXVector3; pUp : PD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtLH(Out : PD3DXMatrix; pEye, pAt : PD3DXVector3; var pUp : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtLH(out Out : TD3DXMatrix; pEye, pAt : PD3DXVector3; var pUp : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtLH(Out : PD3DXMatrix; var pEye : TD3DXVector3; pAt : PD3DXVector3; var pUp : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtLH(out Out : TD3DXMatrix; var pEye : TD3DXVector3; pAt : PD3DXVector3; var pUp : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtLH(Out : PD3DXMatrix; pEye : PD3DXVector3; var pAt, pUp : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtLH(out Out : TD3DXMatrix; pEye : PD3DXVector3; var pAt, pUp : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtLH(Out : PD3DXMatrix; var pEye, pAt, pUp : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixLookAtLH(out Out : TD3DXMatrix; var pEye, pAt, pUp : TD3DXVector3) : PD3DXMatrix; stdcall; external D3DX81DLLName;

// Build a perspective projection matrix. (right-handed)
function D3DXMatrixPerspectiveRH(Out : PD3DXMatrix; w, h, zn, zf : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixPerspectiveRH(out Out : TD3DXMatrix; w, h, zn, zf : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;

// Build a perspective projection matrix. (left-handed)
function D3DXMatrixPerspectiveLH(Out : PD3DXMatrix; w, h, zn, zf : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixPerspectiveLH(out Out : TD3DXMatrix; w, h, zn, zf : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;

// Build a perspective projection matrix. (right-handed)
function D3DXMatrixPerspectiveFovRH(Out : PD3DXMatrix; fovy, Aspect, zn, zf : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixPerspectiveFovRH(out Out : TD3DXMatrix; fovy, Aspect, zn, zf : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;

// Build a perspective projection matrix. (left-handed)
function D3DXMatrixPerspectiveFovLH(Out : PD3DXMatrix; fovy, Aspect, zn, zf : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixPerspectiveFovLH(out Out : TD3DXMatrix; fovy, Aspect, zn, zf : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;

// Build a perspective projection matrix. (right-handed)
function D3DXMatrixPerspectiveOffCenterRH(Out : PD3DXMatrix; l, r, b, t, zn, zf : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixPerspectiveOffCenterRH(out Out : TD3DXMatrix; l, r, b, t, zn, zf : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;

// Build a perspective projection matrix. (left-handed)
function D3DXMatrixPerspectiveOffCenterLH(Out : PD3DXMatrix; l, r, b, t, zn, zf : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixPerspectiveOffCenterLH(out Out : TD3DXMatrix; l, r, b, t, zn, zf : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;

// Build an ortho projection matrix. (right-handed)
function D3DXMatrixOrthoRH(Out : PD3DXMatrix; w, h, zn, zf : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixOrthoRH(out Out : TD3DXMatrix; w, h, zn, zf : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;

// Build an ortho projection matrix. (left-handed)
function D3DXMatrixOrthoLH(Out : PD3DXMatrix; w, h, zn, zf : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixOrthoLH(out Out : TD3DXMatrix; w, h, zn, zf : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;

// Build an ortho projection matrix. (right-handed)
function D3DXMatrixOrthoOffCenterRH(Out : PD3DXMatrix; l, r, b, t, zn, zf : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixOrthoOffCenterRH(out Out : TD3DXMatrix; l, r, b, t, zn, zf : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;

// Build an ortho projection matrix. (left-handed)
function D3DXMatrixOrthoOffCenterLH(Out : PD3DXMatrix; l, r, b, t, zn, zf : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixOrthoOffCenterLH(out Out : TD3DXMatrix; l, r, b, t, zn, zf : Single) : PD3DXMatrix; stdcall; external D3DX81DLLName;

// Build a matrix which flattens geometry into a plane, as if casting
// a shadow from a light.
function D3DXMatrixShadow(Out : PD3DXMatrix; pLight : PD3DXVector4; Plane : PD3DXPlane) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixShadow(out Out : TD3DXMatrix; pLight : PD3DXVector4; Plane : PD3DXPlane) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixShadow(Out : PD3DXMatrix; var pLight : TD3DXVector4; Plane : PD3DXPlane) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixShadow(out Out : TD3DXMatrix; var pLight : TD3DXVector4; Plane : PD3DXPlane) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixShadow(Out : PD3DXMatrix; pLight : PD3DXVector4; var Plane : TD3DXPlane) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixShadow(out Out : TD3DXMatrix; pLight : PD3DXVector4; var Plane : TD3DXPlane) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixShadow(Out : PD3DXMatrix; var pLight : TD3DXVector4; var Plane : TD3DXPlane) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixShadow(out Out : TD3DXMatrix; var pLight : TD3DXVector4; var Plane : TD3DXPlane) : PD3DXMatrix; stdcall; external D3DX81DLLName;

function D3DXMatrixReflect(Out : PD3DXMatrix; Plane : PD3DXPlane) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixReflect(out Out : TD3DXMatrix; Plane : PD3DXPlane) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixReflect(Out : PD3DXMatrix; var Plane : TD3DXPlane) : PD3DXMatrix; stdcall; external D3DX81DLLName;
function D3DXMatrixReflect(out Out : TD3DXMatrix; var Plane : TD3DXPlane) : PD3DXMatrix; stdcall; external D3DX81DLLName;

//------------------------------------------------------------------------------
//
//    Quaternions
//
//------------------------------------------------------------------------------

function D3DXQuaternion(const x, y, z, w : Single) : TD3DXQuaternion;
begin
  Result.x := x;
  Result.y := y;
  Result.z := z;
  Result.w := w;
end;

function D3DXQuaternionAdd(const q1, q2 : TD3DXQuaternion) : TD3DXQuaternion;
begin
  with Result do
  begin
    x := q1.x + q2.x;
    y := q1.y + q2.y;
    z := q1.z + q2.z;
    w := q1.w + q2.w;
  end;
end;

function D3DXQuaternionSubtract(const q1, q2 : TD3DXQuaternion) : TD3DXQuaternion;
begin
  with Result do
  begin
    x := q1.x - q2.x;
    y := q1.y - q2.y;
    z := q1.z - q2.z;
    w := q1.w - q2.w;
  end;
end;

function D3DXQuaternionEqual(const q1, q2 : TD3DXQuaternion) : Boolean;
begin
  Result := (q1.x = q2.x) and (q1.y = q2.y) and(q1.z = q2.z) and (q1.w = q2.w);
end;

function D3DXQuaternionScale(const q : TD3DXQuaternion; const ScaleBy : Single) : TD3DXQuaternion;
begin
  with Result do
  begin
    x := q.x * ScaleBy;
    y := q.y * ScaleBy;
    z := q.z * ScaleBy;
    w := q.w * ScaleBy;
  end;
end;

// inline

function D3DXQuaternionLength(var Q : TD3DXQuaternion) : Single;
begin
  with Q do Result := Sqrt(Sqr(x) + Sqr(y) + Sqr(z) + Sqr(w));
end;

// Length squared, or "norm"
function D3DXQuaternionLengthSq(var Q : TD3DXQuaternion) : Single;
begin
  with Q do Result := Sqr(x) + Sqr(y) + Sqr(z) + Sqr(w);
end;

function D3DXQuaternionDot(var Q1, Q2 : TD3DXQuaternion) : Single;
begin
  Result := Q1.x * Q2.x + Q1.y * Q2.y + Q1.z * Q2.z + Q1.w * Q2.w;
end;

// (0, 0, 0, 1)
function D3DXQuaternionIdentity(out Out : TD3DXQuaternion) : PD3DXQuaternion;
begin
  Out := IdentityQuaternion; 
  Result := @Out;
end;

function D3DXQuaternionIsIdentity(var Q : TD3DXQuaternion) : Boolean;
begin
//  Result := CompareMem(@IdentityQuaternion, @Q, SizeOf(Q));
  with q do Result := (x = 0) and (y = 0) and (z = 0) and (w = 1.0);
end;

// (-x, -y, -z, w)
function D3DXQuaternionConjugate(out Out : TD3DXQuaternion; var Q : TD3DXQuaternion): PD3DXQuaternion;
begin
  with Out do
  begin
    x := -Q.x;
    y := -Q.y;
    z := -Q.z;
    w := -q.w;
  end;
  Result := @Out;
end;

// non-inline

// Compute a quaternin's axis and angle of rotation. Expects unit quaternions.
procedure D3DXQuaternionToAxisAngle(Q : PD3DXQuaternion; pAxis : PD3DXVector3; pAngle : PSingle); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionToAxisAngle(var Q : TD3DXQuaternion; pAxis : PD3DXVector3; pAngle : PSingle); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionToAxisAngle(Q : PD3DXQuaternion; var pAxis : TD3DXVector3; pAngle : PSingle); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionToAxisAngle(var Q : TD3DXQuaternion; var pAxis : TD3DXVector3; pAngle : PSingle); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionToAxisAngle(Q : PD3DXQuaternion; pAxis : PD3DXVector3; var pAngle : Single); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionToAxisAngle(var Q : TD3DXQuaternion; pAxis : PD3DXVector3; var pAngle : Single); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionToAxisAngle(Q : PD3DXQuaternion; var pAxis : TD3DXVector3; var pAngle : Single); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionToAxisAngle(var Q : TD3DXQuaternion; var pAxis : TD3DXVector3; var pAngle : Single); stdcall; external D3DX81DLLName;

// Build a quaternion from a rotation matrix.
function D3DXQuaternionRotationMatrix(Out : PD3DXQuaternion; M : PD3DXMatrix) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionRotationMatrix(out Out : TD3DXQuaternion; M : PD3DXMatrix) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionRotationMatrix(Out : PD3DXQuaternion; var M : TD3DXMatrix) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionRotationMatrix(out Out : TD3DXQuaternion; var M : TD3DXMatrix) : PD3DXQuaternion; stdcall; external D3DX81DLLName;

// Rotation about arbitrary axis.
function D3DXQuaternionRotationAxis(Out : PD3DXQuaternion; V : PD3DXVector3; Angle : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionRotationAxis(out Out : TD3DXQuaternion; V : PD3DXVector3; Angle : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionRotationAxis(Out : PD3DXQuaternion; var V : TD3DXVector3; Angle : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionRotationAxis(out Out : TD3DXQuaternion; var V : TD3DXVector3; Angle : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;

// Yaw around the Y axis, a pitch around the X axis,
// and a roll around the Z axis.
function D3DXQuaternionRotationYawPitchRoll(Out : PD3DXQuaternion; Yaw, Pitch, Roll : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionRotationYawPitchRoll(out Out : TD3DXQuaternion; Yaw, Pitch, Roll : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;

// Quaternion multiplication.  The result represents the rotation Q2
// followed by the rotation Q1.  (Out = Q2 * Q1)
function D3DXQuaternionMultiply(Out, Q1, Q2 : PD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionMultiply(out Out : TD3DXQuaternion; Q1, Q2 : PD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionMultiply(Out : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionMultiply(out Out : TD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionMultiply(Out, Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionMultiply(out Out : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionMultiply(Out : PD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionMultiply(out Out : TD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;

function D3DXQuaternionNormalize(Out, Q : PD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionNormalize(out Out : TD3DXQuaternion; Q : PD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionNormalize(Out : PD3DXQuaternion; var Q : TD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionNormalize(out Out : TD3DXQuaternion; var Q : TD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;

// Conjugate and re-norm
function D3DXQuaternionInverse(Out, Q : PD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionInverse(out Out : TD3DXQuaternion; Q : PD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionInverse(Out : PD3DXQuaternion; var Q : TD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionInverse(out Out : TD3DXQuaternion; var Q : TD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;

// Expects unit quaternions.
// if q = (cos(theta), sin(theta) * v); ln(q) = (0, theta * v)
function D3DXQuaternionLn(Out, Q : PD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionLn(out Out : TD3DXQuaternion; Q : PD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionLn(Out : PD3DXQuaternion; var Q : TD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionLn(out Out : TD3DXQuaternion; var Q : TD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;

// Expects pure quaternions. (w == 0)  w is ignored in calculation.
// if q = (0, theta * v); exp(q) = (cos(theta), sin(theta) * v)
function D3DXQuaternionExp(Out, Q : PD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionExp(out Out : TD3DXQuaternion; Q : PD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionExp(Out : PD3DXQuaternion; var Q : TD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionExp(out Out : TD3DXQuaternion; var Q : TD3DXQuaternion) : PD3DXQuaternion; stdcall; external D3DX81DLLName;

// Spherical linear interpolation between Q1 (t == 0) and Q2 (t == 1).
// Expects unit quaternions.
function D3DXQuaternionSlerp(Out, Q1, Q2 : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSlerp(out Out : TD3DXQuaternion; Q1, Q2 : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSlerp(Out : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSlerp(out Out : TD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSlerp(Out, Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSlerp(out Out : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSlerp(Out : PD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSlerp(out Out : TD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;

// Spherical quadrangle interpolation.
// Slerp(Slerp(Q1, C, t), Slerp(A, B, t), 2t(1-t))
function D3DXQuaternionSquad(Out, Q1, pA, pB, C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; Q1, pA, pB, C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(Out : PD3DXQuaternion; var Q1 : TD3DXQuaternion; pA, pB, C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; var Q1 : TD3DXQuaternion; pA, pB, C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(Out, Q1 : PD3DXQuaternion; var pA : TD3DXQuaternion; pB, C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; Q1 : PD3DXQuaternion; var pA : TD3DXQuaternion; pB, C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(Out : PD3DXQuaternion; var Q1, pA : TD3DXQuaternion; pB, C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; var Q1, pA : TD3DXQuaternion; pB, C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(Out, Q1, pA : PD3DXQuaternion; var pB : TD3DXQuaternion; C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; Q1, pA : PD3DXQuaternion; var pB : TD3DXQuaternion; C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(Out : PD3DXQuaternion; var Q1 : TD3DXQuaternion; pA : PD3DXQuaternion; var pB : TD3DXQuaternion; C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; var Q1 : TD3DXQuaternion; pA : PD3DXQuaternion; var pB : TD3DXQuaternion; C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(Out, Q1 : PD3DXQuaternion; var pA, pB : TD3DXQuaternion; C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; Q1 : PD3DXQuaternion; var pA, pB : TD3DXQuaternion; C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(Out : PD3DXQuaternion; var Q1, pA, pB : TD3DXQuaternion; C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; var Q1, pA, pB : TD3DXQuaternion; C : PD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(Out, Q1, pA, pB : PD3DXQuaternion; var C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; Q1, pA, pB : PD3DXQuaternion; var C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(Out : PD3DXQuaternion; var Q1 : TD3DXQuaternion; pA, pB : PD3DXQuaternion; var C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; var Q1 : TD3DXQuaternion; pA, pB : PD3DXQuaternion; var C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(Out, Q1 : PD3DXQuaternion; var pA : TD3DXQuaternion; pB : PD3DXQuaternion; var C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; Q1 : PD3DXQuaternion; var pA : TD3DXQuaternion; pB : PD3DXQuaternion; var C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(Out : PD3DXQuaternion; var Q1, pA : TD3DXQuaternion; pB : PD3DXQuaternion; var C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; var Q1, pA : TD3DXQuaternion; pB : PD3DXQuaternion; var C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(Out, Q1, pA : PD3DXQuaternion; var pB, C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; Q1, pA : PD3DXQuaternion; var pB, C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(Out : PD3DXQuaternion; var Q1 : TD3DXQuaternion; pA : PD3DXQuaternion; var pB, C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; var Q1 : TD3DXQuaternion; pA : PD3DXQuaternion; var pB, C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(Out, Q1 : PD3DXQuaternion; var pA, pB, C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; Q1 : PD3DXQuaternion; var pA, pB, C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(Out : PD3DXQuaternion; var Q1, pA, pB, C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionSquad(out Out : TD3DXQuaternion; var Q1, pA, pB, C : TD3DXQuaternion; t : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;

// Setup control points for spherical quadrangle interpolation
// from Q1 to Q2.  The control points are chosen in such a way
// to ensure the continuity of tangents with adjacent segments.

procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut, Q0, Q1, Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut, Q0, Q1, Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut, Q0, Q1, Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut, Q0, Q1, Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0, Q1, Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0, Q1, Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; Q0, Q1, Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; Q0, Q1, Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut, Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut, Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut, Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut, Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut : PD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut : PD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut, Q0, Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut, Q0, Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut, Q0, Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut, Q0, Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0, Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0, Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; Q0, Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; Q0, Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut, Q0 : PD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut, Q0 : PD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut, Q0 : PD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut, Q0 : PD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut : PD3DXQuaternion; var Q0, Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut : PD3DXQuaternion; var Q0, Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0, Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0, Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0, Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0, Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; var Q0, Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; var Q0, Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut, Q0, Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut, Q0, Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut, Q0, Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut, Q0, Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0, Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0, Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; Q0, Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; Q0, Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut, Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut, Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut, Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut, Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut : PD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut : PD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; var Q0, Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut, Q0, Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut, Q0, Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut, Q0, Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut, Q0, Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0, Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0, Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; Q0, Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; Q0, Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; var Q0 : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut, Q0 : PD3DXQuaternion; var Q1, Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut, Q0 : PD3DXQuaternion; var Q1, Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut, Q0 : PD3DXQuaternion; var Q1, Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut, Q0 : PD3DXQuaternion; var Q1, Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1, Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1, Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1, Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; Q0 : PD3DXQuaternion; var Q1, Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut, COut : PD3DXQuaternion; var Q0, Q1, Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut, COut : PD3DXQuaternion; var Q0, Q1, Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0, Q1, Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut : TD3DXQuaternion; COut : PD3DXQuaternion; var Q0, Q1, Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut, pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0, Q1, Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut : TD3DXQuaternion; pBOut : PD3DXQuaternion; out COut : TD3DXQuaternion; var Q0, Q1, Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(pAOut : PD3DXQuaternion; out pBOut, COut : TD3DXQuaternion; var Q0, Q1, Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;
procedure D3DXQuaternionSquadSetup(out pAOut, pBOut, COut : TD3DXQuaternion; var Q0, Q1, Q2, Q3 : TD3DXQuaternion); stdcall; external D3DX81DLLName;

// Barycentric interpolation.
// Slerp(Slerp(Q1, Q2, f+g), Slerp(Q1, Q3, f+g), g/(f+g))
function D3DXQuaternionBaryCentric(Out, Q1, Q2, Q3 : PD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionBaryCentric(out Out : TD3DXQuaternion; Q1, Q2, Q3 : PD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionBaryCentric(Out : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionBaryCentric(out Out : TD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2, Q3 : PD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionBaryCentric(Out, Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionBaryCentric(out Out : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionBaryCentric(Out : PD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionBaryCentric(out Out : TD3DXQuaternion; var Q1, Q2 : TD3DXQuaternion; Q3 : PD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionBaryCentric(Out, Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionBaryCentric(out Out : TD3DXQuaternion; Q1, Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionBaryCentric(Out : PD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionBaryCentric(out Out : TD3DXQuaternion; var Q1 : TD3DXQuaternion; Q2 : PD3DXQuaternion; var Q3 : TD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionBaryCentric(Out, Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionBaryCentric(out Out : TD3DXQuaternion; Q1 : PD3DXQuaternion; var Q2, Q3 : TD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionBaryCentric(Out : PD3DXQuaternion; var Q1, Q2, Q3 : TD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;
function D3DXQuaternionBaryCentric(out Out : TD3DXQuaternion; var Q1, Q2, Q3 : TD3DXQuaternion; f, g : Single) : PD3DXQuaternion; stdcall; external D3DX81DLLName;


//------------------------------------------------------------------------------
//
// Planes
//
//------------------------------------------------------------------------------

function D3DXPlaneZero : TD3DXPlane;
begin
  Result.a := 0;
  Result.b := 0;
  Result.c := 0;
  Result.d := 0;
end;

function D3DXPlane(const a, b, c, d : Single) : TD3DXPlane;
begin
  Result.a := a;
  Result.b := b;
  Result.c := c;
  Result.d := d;
end;

function D3DXPlaneEqual(const p1, p2 : TD3DXPlane) : Boolean;
begin
  //Note there may be unlimited definitions of one and the same plane
  Result := (p1.a = p2.a) and (p1.b = p2.b) and (p1.c = p2.c) and (p1.d = p2.d);
end;

// inline

// ax + by + cz + dw
function D3DXPlaneDot(var P : TD3DXPlane; var V : TD3DXVector4) : Single;
begin
  with P, V do Result := a * x + b * y + c * z + d * w;
end;

// ax + by + cz + d
function D3DXPlaneDotCoord(var P : TD3DXPlane; var V : TD3DXVector3) : Single;
begin
  with P, V do Result := a * x + b * y + c * z + d;
end;

// ax + by + cz
function D3DXPlaneDotNormal(var P : TD3DXPlane; var V : TD3DXVector3) : Single;
begin
  with P, V do Result := a * x + b * y + c * z;
end;

// non-inline

// Normalize plane (so that |a,b,c| == 1)
function D3DXPlaneNormalize(Out, P : PD3DXPlane) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneNormalize(out Out : TD3DXPlane; P : PD3DXPlane) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneNormalize(Out : PD3DXPlane; var P : TD3DXPlane) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneNormalize(out Out : TD3DXPlane; var P : TD3DXPlane) : PD3DXPlane; stdcall; external D3DX81DLLName;

// Find the intersection between a plane and a line.  If the line is
// parallel to the plane, NULL is returned.
function D3DXPlaneIntersectLine(Out, P : PD3DXPlane; V1, V2 : PD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneIntersectLine(out Out : TD3DXPlane; P : PD3DXPlane; V1, V2 : PD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneIntersectLine(Out : PD3DXPlane; var P : TD3DXPlane; V1, V2 : PD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneIntersectLine(out Out : TD3DXPlane; var P : TD3DXPlane; V1, V2 : PD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneIntersectLine(Out, P : PD3DXPlane; var V1 : TD3DXVector3; V2 : PD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneIntersectLine(out Out : TD3DXPlane; P : PD3DXPlane; var V1 : TD3DXVector3; V2 : PD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneIntersectLine(Out : PD3DXPlane; var P : TD3DXPlane; var V1 : TD3DXVector3; V2 : PD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneIntersectLine(out Out : TD3DXPlane; var P : TD3DXPlane; var V1 : TD3DXVector3; V2 : PD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneIntersectLine(Out, P : PD3DXPlane; V1 : PD3DXVector3; var V2 : TD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneIntersectLine(out Out : TD3DXPlane; P : PD3DXPlane; V1 : PD3DXVector3; var V2 : TD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneIntersectLine(Out : PD3DXPlane; var P : TD3DXPlane; V1 : PD3DXVector3; var V2 : TD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneIntersectLine(out Out : TD3DXPlane; var P : TD3DXPlane; V1 : PD3DXVector3; var V2 : TD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneIntersectLine(Out, P : PD3DXPlane; var V1, V2 : TD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneIntersectLine(out Out : TD3DXPlane; P : PD3DXPlane; var V1, V2 : TD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneIntersectLine(Out : PD3DXPlane; var P : TD3DXPlane; var V1, V2 : TD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneIntersectLine(out Out : TD3DXPlane; var P : TD3DXPlane; var V1, V2 : TD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;

// Construct a plane from a point and a normal
function D3DXPlaneFromPointNormal(Out : PD3DXPlane; Point, Normal : PD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneFromPointNormal(out Out : TD3DXPlane; Point, Normal : PD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneFromPointNormal(Out : PD3DXPlane; var Point : TD3DXVector3; Normal : PD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneFromPointNormal(out Out : TD3DXPlane; var Point : TD3DXVector3; Normal : PD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneFromPointNormal(Out : PD3DXPlane; Point : PD3DXVector3; var Normal : TD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneFromPointNormal(out Out : TD3DXPlane; Point : PD3DXVector3; var Normal : TD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneFromPointNormal(Out : PD3DXPlane; var Point, Normal : TD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneFromPointNormal(out Out : TD3DXPlane; var Point, Normal : TD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;

// Construct a plane from 3 points
function D3DXPlaneFromPoints(Out : PD3DXPlane; V1, V2, V3 : PD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneFromPoints(out Out : TD3DXPlane; V1, V2, V3 : PD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneFromPoints(Out : PD3DXPlane; var V1 : TD3DXVector3; V2, V3 : PD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneFromPoints(out Out : TD3DXPlane; var V1 : TD3DXVector3; V2, V3 : PD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneFromPoints(Out : PD3DXPlane; V1 : PD3DXVector3; var V2 : TD3DXVector3; V3 : PD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneFromPoints(out Out : TD3DXPlane; V1 : PD3DXVector3; var V2 : TD3DXVector3; V3 : PD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneFromPoints(Out : PD3DXPlane; var V1, V2 : TD3DXVector3; V3 : PD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneFromPoints(out Out : TD3DXPlane; var V1, V2 : TD3DXVector3; V3 : PD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneFromPoints(Out : PD3DXPlane; V1, V2 : PD3DXVector3; var V3 : TD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneFromPoints(out Out : TD3DXPlane; V1, V2 : PD3DXVector3; var V3 : TD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneFromPoints(Out : PD3DXPlane; var V1 : TD3DXVector3; V2 : PD3DXVector3; var V3 : TD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneFromPoints(out Out : TD3DXPlane; var V1 : TD3DXVector3; V2 : PD3DXVector3; var V3 : TD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneFromPoints(Out : PD3DXPlane; V1 : PD3DXVector3; var V2, V3 : TD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneFromPoints(out Out : TD3DXPlane; V1 : PD3DXVector3; var V2, V3 : TD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneFromPoints(Out : PD3DXPlane; var V1, V2, V3 : TD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneFromPoints(out Out : TD3DXPlane; var V1, V2, V3 : TD3DXVector3) : PD3DXPlane; stdcall; external D3DX81DLLName;

// Transform a plane by a matrix.  The vector (a,b,c) must be normal.
// M should be the inverse transpose of the transformation desired.
function D3DXPlaneTransform(Out, P : PD3DXPlane; M : TD3DXMatrix) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneTransform(out Out : TD3DXPlane; P : PD3DXPlane; M : TD3DXMatrix) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneTransform(Out : PD3DXPlane; var P : TD3DXPlane; M : TD3DXMatrix) : PD3DXPlane; stdcall; external D3DX81DLLName;
function D3DXPlaneTransform(out Out : TD3DXPlane; var P : TD3DXPlane; M : TD3DXMatrix) : PD3DXPlane; stdcall; external D3DX81DLLName;

//------------------------------------------------------------------------------
//
// Colors
//
//------------------------------------------------------------------------------

function D3DXColor(const r, g, b, a : Single) : TD3DXColor;
begin
  Result.r := r;
  Result.g := g;
  Result.b := b;
  Result.a := a;
end;

function D3DXColorToLongWord(c : TD3DXColor) : LongWord;
type TLongWordAsArrayOfByte = array[0..3] of Byte;
  function ColorLimit(const x : Single) : Byte;
  begin
    if x > 1.0 then
      Result := 255
    else
      if x < 0 then
        Result := 0
      else
        Result := Trunc(x * 255.0);
  end;
begin
  with c do
  begin
    TLongWordAsArrayOfByte(Result)[3] := ColorLimit(a);
    TLongWordAsArrayOfByte(Result)[2] := ColorLimit(r);
    TLongWordAsArrayOfByte(Result)[1] := ColorLimit(g);
    TLongWordAsArrayOfByte(Result)[0] := ColorLimit(b);
  end;
end;

function D3DXColorFromLongWord(c : LongWord) : TD3DXColor;
type TLongWordAsArrayOfByte = array[0..3] of Byte;
begin
  with Result do
  begin
    a := TLongWordAsArrayOfByte(c)[3] / 255;
    r := TLongWordAsArrayOfByte(c)[2] / 255;
    g := TLongWordAsArrayOfByte(c)[1] / 255;
    b := TLongWordAsArrayOfByte(c)[0] / 255;
  end;
end;

function D3DXColorEqual(const c1, c2 : TD3DXColor) : Boolean;
begin
  Result := (c1.r = c2.r) and (c1.g = c2.g) and (c1.b = c2.b) and (c1.a = c2.a);
end;

// inline

// (1-r, 1-g, 1-b, a)
function D3DXColorNegative(out Out : TD3DXColor; var C : TD3DXColor) : PD3DXColor;
begin
  with Out do
  begin
    r := 1.0 - c.r;
    g := 1.0 - c.g;
    b := 1.0 - c.b;
    a := c.a;
  end;
  Result := @Out;
end;

function D3DXColorAdd(out Out : TD3DXColor; var C1, C2 : TD3DXColor) : PD3DXColor;
begin
  with Out do
  begin
    r := c1.r + c2.r;
    g := c1.g + c2.g;
    b := c1.b + c2.b;
    a := c1.a + c2.a;
  end;
  Result := @Out;
end;

function D3DXColorSubtract(out Out : TD3DXColor; var C1, C2 : TD3DXColor) : PD3DXColor;
begin
  with Out do
  begin
    r := c1.r - c2.r;
    g := c1.g - c2.g;
    b := c1.b - c2.b;
    a := c1.a - c2.a;
  end;
  Result := @Out;
end;

function D3DXColorScale(out Out : TD3DXColor; var C : TD3DXColor; s : Single) : PD3DXColor;
begin
  with Out do
  begin
    r := c.r * s;
    g := c.g * s;
    b := c.b * s;
    a := c.a * s;
  end;
  Result := @Out;
end;

// (r1*r2, g1*g2, b1*b2, a1*a2)
function D3DXColorModulate(out Out : TD3DXColor; var C1, C2 : TD3DXColor) : PD3DXColor;
begin
  with Out do
  begin
    r := c1.r * c2.r;
    g := c1.g * c2.g;
    b := c1.b * c2.b;
    a := c1.a * c2.a;
  end;
  Result := @Out;
end;

// Linear interpolation of r,g,b, and a. C1 + s(C2-C1)
function D3DXColorLerp(out Out : TD3DXColor; var C1, C2 : TD3DXColor; s : Single) : PD3DXColor;
begin
  with Out do
  begin
    r := c1.r + s * (c2.r - c1.r);
    g := c1.g + s * (c2.g - c1.g);
    b := c1.b + s * (c2.b - c1.b);
    a := c1.a + s * (c2.a - c1.a);
  end;
  Result := @Out;
end;

// non-inline

// Interpolate r,g,b between desaturated color and color.
// DesaturatedColor + s(Color - DesaturatedColor)
function D3DXColorAdjustSaturation(Out, C : PD3DXColor; s : Single) : PD3DXColor; stdcall; external D3DX81DLLName;
function D3DXColorAdjustSaturation(out Out : TD3DXColor; C : PD3DXColor; s : Single) : PD3DXColor; stdcall; external D3DX81DLLName;
function D3DXColorAdjustSaturation(Out : PD3DXColor; var C : TD3DXColor; s : Single) : PD3DXColor; stdcall; external D3DX81DLLName;
function D3DXColorAdjustSaturation(out Out : TD3DXColor; var C : TD3DXColor; s : Single) : PD3DXColor; stdcall; external D3DX81DLLName;

// Interpolate r,g,b between 50% grey and color.  Grey + s(Color - Grey)
function D3DXColorAdjustContrast(Out, C : PD3DXColor; co : Single) : PD3DXColor; stdcall; external D3DX81DLLName;
function D3DXColorAdjustContrast(out Out : TD3DXColor; C : PD3DXColor; co : Single) : PD3DXColor; stdcall; external D3DX81DLLName;
function D3DXColorAdjustContrast(Out : PD3DXColor; var C : TD3DXColor; co : Single) : PD3DXColor; stdcall; external D3DX81DLLName;
function D3DXColorAdjustContrast(out Out : TD3DXColor; var C : TD3DXColor; co : Single) : PD3DXColor; stdcall; external D3DX81DLLName;

//--------------------------
// Misc
//--------------------------

// Calculate Fresnel term given the cosine of theta (likely obtained by
// taking the dot of two normals), and the refraction index of the material.
function D3DXFresnelTerm(CosTheta, RefractionIndex : Single) : Single; stdcall; external D3DX81DLLName;

//--------------------------
//    Matrix Stack
//--------------------------

function D3DXCreateMatrixStack(const Flags : LongWord; out Stack : ID3DXMatrixStack) : HResult; stdcall; external D3DX81DLLName;

//--------------------------
// ID3DXFont
//--------------------------

function D3DXCreateFont(Device : IDirect3DDevice8; InFont : HFONT; out OutFont : ID3DXFont) : HResult; stdcall; external D3DX81DLLName;

function D3DXCreateFontIndirect(Device : IDirect3DDevice8; LogFont : PLogFont; out Font : ID3DXFont) : HResult; stdcall; external D3DX81DLLName;
function D3DXCreateFontIndirect(Device : IDirect3DDevice8; var LogFont : TLogFont; out Font : ID3DXFont) : HResult; stdcall; external D3DX81DLLName;

//--------------------------
// ID3DXSprite:
//--------------------------

function D3DXCreateSprite(Device : IDirect3DDevice8; out Sprite : ID3DXSprite) : HResult; stdcall; external D3DX81DLLName;
function D3DXCreateSprite(Device : IDirect3DDevice8; Sprite : PID3DXSprite) : HResult; stdcall; external D3DX81DLLName;

//--------------------------
// ID3DXRenderToSurface
//--------------------------

function D3DXCreateRenderToSurface(const Device : IDirect3DDevice8; Width, Height : Cardinal; Format : TD3DFormat; DepthStencil : BOOL; DepthStencilFormat : TD3DFormat; out RenderToSurface : ID3DXRenderToSurface) : HResult; stdcall; external D3DX81DLLName;

//--------------------------
// ID3DXRenderToEnvMap
//--------------------------

function D3DXCreateRenderToEnvMap(const Device : IDirect3DDevice8; const Size : Cardinal; const Format : TD3DFormat; DepthStencil : Bool; DepthStencilFormat : TD3DFormat; out RenderToEnvMap : ID3DXRenderToEnvMap): HResult; stdcall; external D3DX81DLLName;

//--------------------------
// D3DXAssembleShader:
//--------------------------

function D3DXAssembleShaderFromFileA(SrcFile : PAnsiChar; Flags : LongWord; Constants, CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromFileA(SrcFile : PAnsiChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromFileA(SrcFile : PAnsiChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromFileA(SrcFile : PAnsiChar; Flags : LongWord; out Constants, CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromFileA(SrcFile : PAnsiChar; Flags : LongWord; Constants, CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromFileA(SrcFile : PAnsiChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromFileA(SrcFile : PAnsiChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromFileA(SrcFile : PAnsiChar; Flags : LongWord; out Constants, CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;

function D3DXAssembleShaderFromFileW(SrcFile : PWideChar; Flags : LongWord; Constants, CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromFileW(SrcFile : PWideChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromFileW(SrcFile : PWideChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromFileW(SrcFile : PWideChar; Flags : LongWord; out Constants, CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromFileW(SrcFile : PWideChar; Flags : LongWord; Constants, CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromFileW(SrcFile : PWideChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromFileW(SrcFile : PWideChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromFileW(SrcFile : PWideChar; Flags : LongWord; out Constants, CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;

{$IFDEF UNICODE}
function D3DXAssembleShaderFromFile(SrcFile : PWideChar; Flags : LongWord; Constants, CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromFileW';
function D3DXAssembleShaderFromFile(SrcFile : PWideChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromFileW';
function D3DXAssembleShaderFromFile(SrcFile : PWideChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromFileW';
function D3DXAssembleShaderFromFile(SrcFile : PWideChar; Flags : LongWord; out Constants, CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromFileW';
function D3DXAssembleShaderFromFile(SrcFile : PWideChar; Flags : LongWord; Constants, CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromFileW';
function D3DXAssembleShaderFromFile(SrcFile : PWideChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromFileW';
function D3DXAssembleShaderFromFile(SrcFile : PWideChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromFileW';
function D3DXAssembleShaderFromFile(SrcFile : PWideChar; Flags : LongWord; out Constants, CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromFileW';
{$ELSE}
function D3DXAssembleShaderFromFile(SrcFile : PAnsiChar; Flags : LongWord; Constants, CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromFileA';
function D3DXAssembleShaderFromFile(SrcFile : PAnsiChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromFileA';
function D3DXAssembleShaderFromFile(SrcFile : PAnsiChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromFileA';
function D3DXAssembleShaderFromFile(SrcFile : PAnsiChar; Flags : LongWord; out Constants, CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromFileA';
function D3DXAssembleShaderFromFile(SrcFile : PAnsiChar; Flags : LongWord; Constants, CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromFileA';
function D3DXAssembleShaderFromFile(SrcFile : PAnsiChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromFileA';
function D3DXAssembleShaderFromFile(SrcFile : PAnsiChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromFileA';
function D3DXAssembleShaderFromFile(SrcFile : PAnsiChar; Flags : LongWord; out Constants, CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromFileA';
{$ENDIF}

function D3DXAssembleShaderFromResourceA(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; Constants, CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromResourceA(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromResourceA(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromResourceA(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; out Constants, CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromResourceA(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; Constants, CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromResourceA(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromResourceA(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromResourceA(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; out Constants, CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;

function D3DXAssembleShaderFromResourceW(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; Constants, CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromResourceW(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromResourceW(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromResourceW(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; out Constants, CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromResourceW(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; Constants, CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromResourceW(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromResourceW(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShaderFromResourceW(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; out Constants, CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;

{$IFDEF UNICODE}
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; Constants, CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromResourceW';
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromResourceW';
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromResourceW';
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; out Constants, CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromResourceW';
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; Constants, CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromResourceW';
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromResourceW';
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromResourceW';
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PWideChar; Flags : LongWord; out Constants, CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromResourceW';
{$ELSE}
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; Constants, CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromResourceA';
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromResourceA';
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromResourceA';
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; out Constants, CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromResourceA';
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; Constants, CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromResourceA';
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromResourceA';
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromResourceA';
function D3DXAssembleShaderFromResource(SrcModule : HMODULE; SrcResource : PAnsiChar; Flags : LongWord; out Constants, CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName name 'D3DXAssembleShaderFromResourceA';
{$ENDIF}

function D3DXAssembleShader(SrcData : Pointer; SrcDataLen : Cardinal; Flags : LongWord; Constants, CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShader(SrcData : Pointer; SrcDataLen : Cardinal; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader, CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShader(SrcData : Pointer; SrcDataLen : Cardinal; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShader(SrcData : Pointer; SrcDataLen : Cardinal; Flags : LongWord; out Constants, CompiledShader : ID3DXBuffer; CompilationErrors : PID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShader(SrcData : Pointer; SrcDataLen : Cardinal; Flags : LongWord; Constants, CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShader(SrcData : Pointer; SrcDataLen : Cardinal; Flags : LongWord; out Constants : ID3DXBuffer; CompiledShader : PID3DXBuffer; out CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShader(SrcData : Pointer; SrcDataLen : Cardinal; Flags : LongWord; Constants : PID3DXBuffer; out CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;
function D3DXAssembleShader(SrcData : Pointer; SrcDataLen : Cardinal; Flags : LongWord; out Constants, CompiledShader, CompilationErrors : ID3DXBuffer) : HResult; stdcall; external D3DX81DLLName;

//--------------------------
// D3DXGetErrorString
//--------------------------

function D3DXGetErrorStringA; external D3DX81DLLName;

function D3DXGetErrorStringW; external D3DX81DLLName;

{$IFDEF UNICODE}
function D3DXGetErrorString; external D3DX81DLLName name 'D3DXGetErrorStringW';
{$ELSE}
function D3DXGetErrorString; external D3DX81DLLName name 'D3DXGetErrorStringA';
{$ENDIF}


//--------------------------
// GetImageInfoFromFile/Resource
//--------------------------

function D3DXGetImageInfoFromFileA(const SrcFile : PAnsiChar; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXGetImageInfoFromFileA(const SrcFile : PAnsiChar; out SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;

function D3DXGetImageInfoFromFileW(const SrcFile : PWideChar; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXGetImageInfoFromFileW(const SrcFile : PWideChar; out SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;

{$IFDEF UNICODE}
function D3DXGetImageInfoFromFile(const SrcFile : PWideChar; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXGetImageInfoFromFileW';
function D3DXGetImageInfoFromFile(const SrcFile : PWideChar; out SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXGetImageInfoFromFileW';
{$ELSE}
function D3DXGetImageInfoFromFile(const SrcFile : PAnsiChar; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXGetImageInfoFromFileA';
function D3DXGetImageInfoFromFile(const SrcFile : PAnsiChar; out SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXGetImageInfoFromFileA';
{$ENDIF}

function D3DXGetImageInfoFromResourceA(const SrcModule : HMODULE; const SrcResource : PAnsiChar; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXGetImageInfoFromResourceA(const SrcModule : HMODULE; const SrcResource : PAnsiChar; out SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;

function D3DXGetImageInfoFromResourceW(const SrcModule : HMODULE; const SrcResource : PWideChar; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXGetImageInfoFromResourceW(const SrcModule : HMODULE; const SrcResource : PWideChar; out SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;


{$IFDEF UNICODE}
function D3DXGetImageInfoFromResource(const SrcModule : HMODULE; const SrcResource : PWideChar; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXGetImageInfoFromResourceW';
function D3DXGetImageInfoFromResource(const SrcModule : HMODULE; const SrcResource : PWideChar; out SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXGetImageInfoFromResourceW';
{$ELSE}
function D3DXGetImageInfoFromResource(const SrcModule : HMODULE; const SrcResource : PAnsiChar; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXGetImageInfoFromResourceA';
function D3DXGetImageInfoFromResource(const SrcModule : HMODULE; const SrcResource : PAnsiChar; out SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXGetImageInfoFromResourceA';
{$ENDIF}

function D3DXGetImageInfoFromFileInMemory(const SrcData : Pointer; const SrcDataSize : Cardinal; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXGetImageInfoFromFileInMemory(const SrcData : Pointer; const SrcDataSize : Cardinal; out SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;

//--------------------------
// D3DXLoadSurfaceFromFile/Resource
//--------------------------

function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;

function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;

{$IFDEF UNICODE}
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileW';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileW';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileW';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileW';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileW';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileW';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileW';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileW';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileW';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileW';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileW';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileW';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileW';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileW';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileW';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileW';
{$ELSE}
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileA';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileA';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileA';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileA';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileA';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileA';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileA';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileA';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileA';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileA';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileA';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileA';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileA';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileA';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileA';
function D3DXLoadSurfaceFromFile(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcFile : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromFileA';
{$ENDIF}

function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceA(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;

function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromResourceW(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;

{$IFDEF UNICODE}
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceW';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceW';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceW';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceW';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceW';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceW';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceW';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceW';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceW';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceW';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceW';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceW';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceW';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceW';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceW';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PWideChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceW';
{$ELSE}
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceA';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceA';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceA';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceA';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceA';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceA';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceA';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceA';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceA';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceA';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceA';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceA';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceA';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceA';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceA';
function D3DXLoadSurfaceFromResource(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcModule : HMODULE; SrcResource : PAnsiChar; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadSurfaceFromResourceA';
{$ENDIF}

function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcData : Pointer; SrcDataSize : Cardinal; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcData : Pointer; SrcDataSize : Cardinal; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcData : Pointer; SrcDataSize : Cardinal; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcData : Pointer; SrcDataSize : Cardinal; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcData : Pointer; SrcDataSize : Cardinal; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcData : Pointer; SrcDataSize : Cardinal; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcData : Pointer; SrcDataSize : Cardinal; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcData : Pointer; SrcDataSize : Cardinal; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcData : Pointer; SrcDataSize : Cardinal; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcData : Pointer; SrcDataSize : Cardinal; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcData : Pointer; SrcDataSize : Cardinal; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcData : Pointer; SrcDataSize : Cardinal; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcData : Pointer; SrcDataSize : Cardinal; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcData : Pointer; SrcDataSize : Cardinal; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcData : Pointer; SrcDataSize : Cardinal; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromFileInMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcData : Pointer; SrcDataSize : Cardinal; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;

//--------------------------
// D3DXLoadSurfaceFromSurface
//--------------------------

function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; const SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; const SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; const SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromSurface(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; const SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;

//--------------------------
// D3DXLoadSurfaceFromMemory
//--------------------------

function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; SrcPalette : PPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; SrcPalette : PPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; SrcPalette : PPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; SrcPalette : PPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; var SrcPalette : TPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; var SrcPalette : TPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; var SrcPalette : TPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; var SrcPalette : TPaletteEntry; SrcRect : PRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; SrcPalette : PPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; SrcPalette : PPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; SrcPalette : PPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; SrcPalette : PPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; DestRect : PRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; var SrcPalette : TPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; DestRect : PRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; var SrcPalette : TPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; DestPalette : PPaletteEntry; var DestRect : TRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; var SrcPalette : TPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadSurfaceFromMemory(DestSurface : IDirect3DSurface8; var DestPalette : TPaletteEntry; var DestRect : TRect; SrcMemory : Pointer; const SrcFormat : TD3DFormat; SrcPitch : Cardinal; var SrcPalette : TPaletteEntry; var SrcRect : TRect; const Filter : LongWord; const ColorKey : TD3DColor) : HResult; stdcall; external D3DX81DLLName;

//--------------------------
// D3DXSaveSurfaceToFile
//--------------------------

function D3DXSaveSurfaceToFileA(DestFile : PAnsiChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; SrcRect : PRect) : HResult; stdcall; external D3DX81DLLName;
function D3DXSaveSurfaceToFileA(DestFile : PAnsiChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; SrcRect : PRect) : HResult; stdcall; external D3DX81DLLName;
function D3DXSaveSurfaceToFileA(DestFile : PAnsiChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; var SrcRect : TRect) : HResult; stdcall; external D3DX81DLLName;
function D3DXSaveSurfaceToFileA(DestFile : PAnsiChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; var SrcRect : TRect) : HResult; stdcall; external D3DX81DLLName;

function D3DXSaveSurfaceToFileW(DestFile : PWideChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; SrcRect : PRect) : HResult; stdcall; external D3DX81DLLName;
function D3DXSaveSurfaceToFileW(DestFile : PWideChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; SrcRect : PRect) : HResult; stdcall; external D3DX81DLLName;
function D3DXSaveSurfaceToFileW(DestFile : PWideChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; var SrcRect : TRect) : HResult; stdcall; external D3DX81DLLName;
function D3DXSaveSurfaceToFileW(DestFile : PWideChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; var SrcRect : TRect) : HResult; stdcall; external D3DX81DLLName;

{$IFDEF UNICODE}
function D3DXSaveSurfaceToFile(DestFile : PWideChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; SrcRect : PRect) : HResult; stdcall; external D3DX81DLLName name 'D3DXSaveSurfaceToFileW';
function D3DXSaveSurfaceToFile(DestFile : PWideChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; SrcRect : PRect) : HResult; stdcall; external D3DX81DLLName name 'D3DXSaveSurfaceToFileW';
function D3DXSaveSurfaceToFile(DestFile : PWideChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; var SrcRect : TRect) : HResult; stdcall; external D3DX81DLLName name 'D3DXSaveSurfaceToFileW';
function D3DXSaveSurfaceToFile(DestFile : PWideChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; var SrcRect : TRect) : HResult; stdcall; external D3DX81DLLName name 'D3DXSaveSurfaceToFileW';
{$ELSE}
function D3DXSaveSurfaceToFile(DestFile : PAnsiChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; SrcRect : PRect) : HResult; stdcall; external D3DX81DLLName name 'D3DXSaveSurfaceToFileA';
function D3DXSaveSurfaceToFile(DestFile : PAnsiChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; SrcRect : PRect) : HResult; stdcall; external D3DX81DLLName name 'D3DXSaveSurfaceToFileA';
function D3DXSaveSurfaceToFile(DestFile : PAnsiChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; SrcPalette : PPaletteEntry; var SrcRect : TRect) : HResult; stdcall; external D3DX81DLLName name 'D3DXSaveSurfaceToFileA';
function D3DXSaveSurfaceToFile(DestFile : PAnsiChar; const DestFormat : TD3DXImageFileFormat; SrcSurface : IDirect3DSurface8; var SrcPalette : TPaletteEntry; var SrcRect : TRect) : HResult; stdcall; external D3DX81DLLName name 'D3DXSaveSurfaceToFileA';
{$ENDIF}

//--------------------------
// D3DXLoadVolumeFromFile/Resource
//--------------------------

function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileA(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;

function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;
function D3DXLoadVolumeFromFileW(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName;

{$IFDEF UNICODE}
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileW';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileW';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileW';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileW';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileW';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileW';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileW';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileW';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileW';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileW';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileW';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileW';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileW';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileW';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileW';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PWideChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileW';
{$ELSE}
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileA';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileA';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileA';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileA';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileA';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileA';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileA';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; var SrcBox : TD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; SrcInfo : PD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileA';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileA';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; var DestPalette : TPaletteEntry; DestBox : PD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external D3DX81DLLName name 'D3DXLoadVolumeFromFileA';
function D3DXLoadVolumeFromFile(DestVolume : IDirect3DVolume8; DestPalette : PPaletteEntry; var DestBox : TD3DBox; SrcFile : PAnsiChar; SrcBox : PD3DBox; const Filter : LongWord; const ColorKey : TD3DColor; var SrcInfo : TD3DXImageInfo) : HResult; stdcall; external