# Contribution Guidelines

Please ensure your pull request adheres to the following guidelines:

* Use the following format:
  * `[Name](link)` - Brief Description of what the module does. (Status: *Stable* or *In Development*)
* Make an individual pull request for each new item.
* Link additions should be inserted alphabetically to the relevant category.
* New categories or improvements to the existing categorization are welcome.
* Check your spelling and grammar.
* The pull request and commit should have a useful title.

Unsure whether something fits here or not? Answering these questions will help.

* Is the tool used in a formal web archiving programme?
* Does it archive or capture and preserve other people's data not just backup your own?
* Does it make use of widely accepted web archiving standards ([WARC](https://iipc.github.io/warc-specifications/), [Memento](https://tools.ietf.org/html/rfc7089), [CDX](https://archive.org/web/researcher/cdx_file_format.php), etc.)?
* Is it focused on a broader sense of web sites and web-like platforms (public, interlinked), and not on individual applications that just happen to use a browser as a runtime environment?
