# Awesome IoT Hacks

A curated list of hacks in IoT space so that researchers and industrial products
can address the security vulnerabilities (_hopefully_).

The table of content is generated with
[doctoc](https://github.com/thlorenz/doctoc). Make sure you run it and update
the table of content before making pull requests.

## Contents
<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Analysis, Reports and Slides](#analysis-reports-and-slides)
- [Communities](#communities)
- [IoT Hacks](#iot-hacks)
  - [Thingbots](#thingbots)
  - [RFID](#rfid)
  - [Home Automation](#home-automation)
  - [Connected Doorbell](#connected-doorbell)
  - [Hub](#hub)
  - [Smart Coffee](#smart-coffee)
  - [Wearable](#wearable)
  - [Smart Plug](#smart-plug)
  - [Cameras](#cameras)
  - [Traffic Lights](#traffic-lights)
  - [Automobiles](#automobiles)
  - [Airplanes](#airplanes)
  - [Light Bulbs](#light-bulbs)
  - [Locks](#locks)
  - [Smart Scale](#smart-scale)
  - [Smart Meters](#smart-meters)
  - [Pacemaker](#pacemaker)
  - [Thermostats](#thermostats)
  - [Fridge](#fridge)
  - [Media Player & TV](#media-player--tv)
  - [Firearms](#firearms)
  - [Toilet](#toilet)
  - [Toys](#toys)
  - [Drones](#drones)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Analysis, Reports and Slides

- [Internet of Things Research Study (HP 2014 Report)](http://www8.hp.com/h20195/V2/GetPDF.aspx/4AA5-4759ENW.pdf)
- [The Internet of Fails](http://www.slideshare.net/markstanislav/the-internet-of-fails-where-iot-has-gone-wrong-and-how-were-making-it-right),
  ([video](www.youtube.com/watch?v=8hLeVSvoHqI))
- [Cameras, Thermostats, and Home Automation Controllers, Hacking 14 IoT Devices](https://www.iotvillage.org/slides_DC23/IoT11-slides.pdf)
- [Hack All The Things: 20 Devices in 45 Minutes](https://www.defcon.org/images/defcon-22/dc-22-presentations/Heres-Etemadieh-Baker-Nielsen/DEFCON-22-Heres-Etemadieh-Baker-Nielsen-Hack-All-The-Things.pdf) - ([wiki](https://www.exploitee.rs/), [video](www.youtube.com/watch?v=h5PRvBpLuJs))
- [Careful Connections: Building Security in the Internet of Things (FTC)](https://www.ftc.gov/system/files/documents/plain-language/pdf0199-carefulconnections-buildingsecurityinternetofthings.pdf)
- [Analysis of IoT honeypot data; How devices are hacked, type of infections and origin of attacks (Kaspersky lab, 2018)](https://securelist.com/new-trends-in-the-world-of-iot-threats/87991/)

## Communities

- [IoT Village<sup>TM</sup>](https://www.iotvillage.org/)
- [BuildItSecure.ly](http://builditsecure.ly/)
- [Secure Internet of Things Project (Stanford)](http://iot.stanford.edu/people.html)
- [The Open Web Application Security Project (OWASP)](https://www.owasp.org/index.php/Main_Page)

## IoT Hacks

### Thingbots

- [Proofpoint Uncovers Internet of Things (IoT) Cyberattack](http://investors.proofpoint.com/releasedetail.cfm?releaseid=819799)

### RFID

- [Vulnerabilities in First-Generation RFID-enabled Credit Cards](http://www.arijuels.com/wp-content/uploads/2013/09/HBFJ+07.pdf)
- [MIT Subway Hack Paper Published on the Web](http://www.pcmag.com/article2/0,2817,2327898,00.asp)
- [Tampered Card Readers Steal Data via Bluetooth](http://www.americanbanker.com/security-watch/bluetooth-skimming-1042020-1.html)

### Home Automation

- [IOActive identifies vulnerabilities in Belkin WeMo's Home Automation](http://www.ioactive.com/pdfs/IOActive_Belkin-advisory-lite.pdf)
- [Cameras, Thermostats, and Home Automation Controllers, Hacking 14 IoT Devices](https://www.iotvillage.org/slides_DC23/IoT11-slides.pdf)
- [Popular Home Automation System Backdoored Via Unpatched Flaw](http://www.darkreading.com/vulnerabilities---threats/popular-home-automation-system-backdoored-via-unpatched-flaw/d/d-id/1320004?_mc=sm_dr_editor_kellyjacksonhiggins)

### Connected Doorbell
- [CVE-2015-4400: Backdoorbot, Network Configuration Leak on a Connected Doorbell](https://blog.fortinet.com/2016/01/22/cve-2015-4400-backdoorbot-network-configuration-leak-on-a-connected-doorbell), ([video](https://www.youtube.com/watch?v=a05RciFhPrs))

### Hub

- [TWSL2013-023: Lack of Web and API AuthenticationVulnerability in INSTEON Hub](https://www.trustwave.com/Resources/Security-Advisories/Advisories/TWSL2013-023/?fid=3869)

### Smart Coffee

- [Reversing the Smarter Coffee IoT Machine Protocol to Make Coffee Using the Terminal](https://www.evilsocket.net/2016/10/09/IoCOFFEE-Reversing-the-Smarter-Coffee-IoT-machine-protocol-to-make-coffee-using-terminal/)

### Wearable

- [How I hacked my smart bracelet](https://securelist.com/blog/research/69369/how-i-hacked-my-smart-bracelet/)

### Smart Plug

- [Hacking the D-Link DSP-W215 Smart Plug](http://www.devttys0.com/2014/05/hacking-the-d-link-dsp-w215-smart-plug/)
- [Reverse Engineering the TP-Link HS110](https://www.softscheck.com/en/reverse-engineering-tp-link-hs110/)
- [Hacking Kankun Smart Wifi Plug](http://www.anites.com/2015/01/hacking-kankun-smart-wifi-plug.html)
- [Smart Socket Hack Tutorial](http://souliss.net/media/smart-socket-hack/)

### Cameras

- [Trendnet Cameras - I always feel like somebody's watching me](http://console-cowboys.blogspot.com/2012/01/trendnet-cameras-i-always-feel-like.html)
- [Hacker Hotshots: Eyes on IZON Surveilling IP Camera Security](https://www.concise-courses.com/security/izon-hacking/)
- [Cameras, Thermostats, and Home Automation Controllers, Hacking 14 IoT Devices](https://www.iotvillage.org/slides_DC23/IoT11-slides.pdf)
- [Hacker 'shouts abuse' via Foscam baby monitoring camera](http://www.bbc.com/news/technology-23693460)
- [Urban surveillance camera systems lacking security](https://blog.kaspersky.com/urban-surveillance-not-secure/8901/)
- [TWSL2014-007: Multiple Vulnerabilities in Y-Cam IP Cameras](https://www.trustwave.com/Resources/Security-Advisories/Advisories/TWSL2014-007/?fid=3850)
- [Say Cheese: a snapshot of the massive DDoS attacks coming from IoT cameras](https://blog.cloudflare.com/say-cheese-a-snapshot-of-the-massive-ddos-attacks-coming-from-iot-cameras/)
- [Samsung SmartCam install.php Remote Root Command Exec](https://www.exploitee.rs/index.php/Samsung_SmartCam%E2%80%8B)

### Traffic Lights

- [Green Lights Forever: Analyzing The Security of Traffic Infrastructure](https://jhalderm.com/pub/papers/traffic-woot14.pdf)
- [Hacking US (and UK, Australia, France, etc.) Traffic Control Systems](http://blog.ioactive.com/2014/04/hacking-us-and-uk-australia-france-etc.html)

### Automobiles

- [Hackers Remotely Attack a Jeep on the Highway](http://www.wired.com/2015/07/hackers-remotely-kill-jeep-highway/)
- [Comprehensive Experimental Analyses of Automotive Attack Surfaces](http://static.usenix.org/events/sec11/tech/full_papers/Checkoway.pdf)

### Airplanes

- [Hackers could take control of a plane using in-flight entertainment system](http://www.telegraph.co.uk/technology/2016/12/20/hackers-could-take-control-plane-using-in-flight-entertainment/)

### Light Bulbs

- [Hacking into Internet Connected Light Bulbs](http://www.contextis.com/resources/blog/hacking-internet-connected-light-bulbs/)
- [Hacking Lightbulbs: Security Evaluation Of The Philips Hue Personal Wireless Lighting System](http://www.dhanjani.com/docs/Hacking%20Lighbulbs%20Hue%20Dhanjani%202013.pdf)
- [IoT Goes Nuclear: Creating a ZigBee Chain Reaction](http://www.wisdom.weizmann.ac.il/~eyalro/iotworm/iotworm.pdf)
- [Extended Functionality Attacks on IoT Devices: The Case of Smart Lights](https://zh.scribd.com/doc/306620189/Eyal-Ronen-and-Adi-Shamir-Hack-Lightbulbs)

### Locks

- [Lockpicking in the IoT](https://media.ccc.de/v/33c3-8019-lockpicking_in_the_iot)

### Smart Scale

- [Fitbit Aria Wi-Fi Smart Scale](https://www.hackerspace-bamberg.de/Fitbit_Aria_Wi-Fi_Smart_Scale)

### Smart Meters

- [Solar Power Firm Patches Meters Vulnerable to Command Injection Attacks](https://threatpost.com/solar-power-firm-patches-meters-vulnerable-to-command-injection-attacks/122324/)

### Pacemaker

- [Pacemakers and Implantable Cardiac Defibrillators: Software Radio Attacks and Zero-Power Defenses](http://www.secure-medicine.org/public/publications/icd-study.pdf)

### Thermostats

- [Cameras, Thermostats, and Home Automation Controllers, Hacking 14 IoT Devices](https://www.iotvillage.org/slides_DC23/IoT11-slides.pdf)
- [Google Nest: Exploiting DFU For Root](https://blog.exploitee.rs/2014/google-nest-exploiting-dfu-for-root/)
- [Smart Nest Thermostat, A Smart Spy in Your Home](https://www.blackhat.com/docs/us-14/materials/us-14-Jin-Smart-Nest-Thermostat-A-Smart-Spy-In-Your-Home.pdf)
- [TWSL2013-022: No Authentication Vulnerability in Radio Thermostat](https://www.trustwave.com/Resources/Security-Advisories/Advisories/TWSL2013-022/?fid=3870)

### Fridge

- [Proofpoint Uncovers Internet of Things (IoT) Cyberattack](http://investors.proofpoint.com/releasedetail.cfm?releaseid=819799) - Spam emails from fridges.
- [Hacking Defcon 23'S IoT Village Samsung Fridge](https://www.pentestpartners.com/blog/hacking-defcon-23s-iot-village-samsung-fridge/)

### Media Player & TV

- [Breaking Secure-Boot on the Roku](https://blog.exploitee.rs/2013/breaking-secure-boot-on-the-roku/)
- [Google TV Or: How I Learned to Stop Worrying and Exploit Secure Boot](https://blog.exploitee.rs/2013/google-tv-or-how-i-learned-to-stop-worrying-and-exploit-secure-boot/)
- [Chromecast: Exploiting the Newest Device By Google](https://blog.exploitee.rs/2013/chromecast-exploiting-the-newest-device-by-google/)
- [Ransomware Ruins Holiday By Hijacking Family's LG Smart TV on Christmas Day](https://www.yahoo.com/tech/ransomware-ruins-holiday-hijacking-familys-201136667.html)

### Firearms

- [DEF CON 25 - Plore - Popping a Smart Gun](https://www.youtube.com/watch?v=J3f0p3vTY-c) ([Slides](https://media.defcon.org/DEF%20CON%2025/DEF%20CON%2025%20presentations/DEFCON-25-Plore-Popping-a-Smart-Gun.pdf))
- [Hacking a IoT Rifle - BlackHat 2015 - 36 slides](https://www.blackhat.com/docs/us-15/materials/us-15-Sandvik-When-IoT-Attacks-Hacking-A-Linux-Powered-Rifle.pdf)
- [Hackers Can Disable a Sniper Rifle—Or Change Its Target - Wired 2015](https://www.wired.com/2015/07/hackers-can-disable-sniper-rifleor-change-target/)

### Toilet

- [TWSL2013-020: Hard-Coded Bluetooth PIN Vulnerability in LIXIL Satis Toilet](https://www.trustwave.com/Resources/Security-Advisories/Advisories/TWSL2013-020/?fid=3872)

### Toys

- [TWSL2013-021: Multiple Vulnerabilities in Karotz Smart Rabbit](https://www.trustwave.com/Resources/Security-Advisories/Advisories/TWSL2013-021/?fid=3871)
- [Fisher-Price smart bear allowed hacking of children's biographical data (CVE-2015-8269)](https://www.theguardian.com/technology/2016/feb/02/fisher-price-mattel-smart-toy-bear-data-hack-technology)
- [Hello Barbie Initial Security Analysis](https://static1.squarespace.com/static/543effd8e4b095fba39dfe59/t/56a66d424bf1187ad34383b2/1453747529070/HelloBarbieSecurityAnalysis.pdf)
- [Security researcher Ken Munro discovers vulnerability in Vivid Toy's talking Doll 'Cayla'](http://www.techworm.net/2015/01/vivid-toys-cayla-talking-doll-vulnerable-hacking-says-security-researcher.html)
- [Data from connected CloudPets teddy bears leaked and ransomed, exposing kids' voice messages](https://www.troyhunt.com/data-from-connected-cloudpets-teddy-bears-leaked-and-ransomed-exposing-kids-voice-messages/)

### Drones

- [Parrot Drones Hijacking - RSA2018 Video, Pedro Cabrera, March 2018](https://youtu.be/66z-aXy_1Yo) ([Slides](https://www.rsaconference.com/writable/presentations/file_upload/mbs-w14-parrot-drones-hijacking.pdf))
- [Hacking the DJI Phantom 3, Paolo Stagno, January 25, 2017](http://dronesec.xyz/2017/01/25/hacking-the-dji-phantom-3/)
- [PHDays VI, hacking Syma X5C quadcopter, Pavel Novikov and Artur Garipov, June 9, 2016](http://blog.ptsecurity.com/2016/06/phd-vi-how-they-stole-our-drone.html)
- [All your bebop drones still belong to us, drone hijacking, Pedro Cabrera, 2016](https://youtu.be/ra0nKHvaXnc)
- [Shelling out on 3DR Solo, Kevin Finisterre,June 15, 2015](http://www.digitalmunition.com/ShellingOutOnSolo_nopass.pdf)

