# CVE-2017-5754 (rogue data cache load)

- Report: Jun 1, 2017
- Credit: Jann Horn (Google Project Zero), Werner Haas, Thomas Prescher @ Cyberus Technology, and Daniel Gruss, Moritz Lipp, Stefan Mangard, Michael Schwarz @ Graz University of Technology

## PoC

- [IAIK/meltdown](https://github.com/IAIK/meltdown)
- [CacheAttack.cpp](https://pastebin.com/CF91uGTG)
- [paboldin/meltdown-exploit](https://github.com/paboldin/meltdown-exploit)
- [raphaelsc/Am-I-affected-by-Meltdown](https://github.com/raphaelsc/Am-I-affected-by-Meltdown)
- [lgeek/spec_poc_arm](https://github.com/lgeek/spec_poc_arm)
- [GitMirar/meltdown-poc](https://github.com/GitMirar/meltdown-poc)

## Reference

- [Meltdown](https://meltdownattack.com/meltdown.pdf)
- [Time-travelling exploits with Meltdown](https://medium.com/@pwnallthethings/time-travelling-exploits-with-meltdown-1189548f1e1d)
- [Reading privileged memory with a side-channel](https://googleprojectzero.blogspot.tw/2018/01/reading-privileged-memory-with-side.html)
- [marcan/speculation-bugs](https://github.com/marcan/speculation-bugs)
- [A Simple Explanation of the Differences Between Meltdown and Spectre](https://danielmiessler.com/blog/simple-explanation-difference-meltdown-spectre/)
- [Intel: Intel Responds to Security Research Findings](https://newsroom.intel.com/news/intel-responds-to-security-research-findings/)
- [Negative Result: Reading Kernel Memory From User Mode](https://cyber.wtf/2017/07/28/negative-result-reading-kernel-memory-from-user-mode/)
- [History stealing using timing attack](http://antoinevastel.github.io/security/privacy/2017/04/09/history-stealing.html)
- [CVE-2017-5754](https://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-5754)
