# awesome-reversing    

A curated list of awesome reversing resources   

- [Awesome Reversing](#awesome-reversing)
    - [Books](#books)
    - [Courses](#courses)
    - [Channels](#channels)
    - [Practice](#practice)
    - [Hex Editors](#hex-editors)
    - [Binary Format](#binary-format)
    - [Disassemblers](#disassemblers)
    - [Binary Analysis](#binary-analysis)
    - [Bytecode Analysis](#bytecode-analysis)
    - [Import Reconstruction](#import-reconstruction)
    - [Dynamic Analysis](#dynamic-analysis)
    - [Debugging](#debugging)
    - [Mac Decrypt](#mac-decrypt)
    - [Document Analysis](#document-analysis)
    - [Scripting](#scripting)
    - [Android](#android)
    - [Yara](#yara)

- - -

## Books

*Reverse Engineering Books*

* [The IDA Pro Book](http://amzn.com/1593272898)
* [Reverse Engineering for Beginners](http://beginners.re/)
* [Assembly Language for Intel-Based Computers (5th Edition) ](http://a.co/4OR6I9U)
* [Practical Reverse Engineering](http://amzn.com/B00IA22R2Y)
* [Reversing: Secrets of Reverse Engineering](http://amzn.com/B007032XZK)
* [Practical Malware Analysis](http://amzn.com/1593272901)
* [Malware Analyst's Cookbook](http://amzn.com/B0047DWCMA)
* [Gray Hat Hacking](http://amzn.com/0071832386)
* [The Art of Memory Forensics](http://amzn.com/1118825098)
* [Hacking: The Art of Exploitation](http://amzn.com/1593271441)
* [Fuzzing for Software Security](http://amzn.com/1596932147)
* [Art of Software Security Assessment](http://amzn.com/0321444426)
* [The Antivirus Hacker's Handbook](http://amzn.com/1119028752)
* [The Rootkit Arsenal](http://amzn.com/144962636X)
* [Windows Internals Part 1](http://amzn.com/0735648735) [Part 2](http://amzn.com/0735665877)
* [Inside Windows Debugging](http://amzn.com/0735662789)
* [iOS Reverse Engineering](https://github.com/iosre/iOSAppReverseEngineering)
* [The Shellcoders Handbook](http://a.co/6H55943)
* [A Guide to Kernel Exploitation](http://a.co/aM4cENn)
* [Agner's software optimization resources](http://www.agner.org/optimize/)
* [Learning Malware Analysis](https://www.amazon.com/Learning-Malware-Analysis-techniques-investigate/dp/1788392507/)
* [Binary Analysis](https://nostarch.com/binaryanalysis)
* [Rootkits and Bootkits](https://nostarch.com/rootkits)
* [Serious Cryptography](https://nostarch.com/seriouscrypto)

## Courses

*Reverse Engineering Courses*

* [Lenas Reversing for Newbies](https://tuts4you.com/download.php?list.17)
* [Open Security Training](http://opensecuritytraining.info/Training.html)
* [Dr. Fu's Malware Analysis](http://fumalwareanalysis.blogspot.sg/p/malware-analysis-tutorials-reverse.html)
* [Binary Auditing Course](http://www.binary-auditing.com/)
* [TiGa's Video Tutorials](http://www.woodmann.com/TiGa/)
* [Legend of Random](https://tuts4you.com/download.php?list.97)
* [Practical Malware Analysis](https://samsclass.info/126/126_S17.shtml)
* [Modern Binary Exploitation](http://security.cs.rpi.edu/courses/binexp-spring2015/)
* [RPISEC Malware Course](https://github.com/RPISEC/Malware)
* [begin.re](https://www.begin.re/)
* [RE101](https://securedorg.github.io/RE101/)
* [RE102](https://securedorg.github.io/RE102/)
* [ARM Assembly Basics](https://azeria-labs.com/writing-arm-assembly-part-1/)
* [Offensive and Defensive Android Reversing](https://github.com/rednaga/training/raw/master/DEFCON23/O%26D%20-%20Android%20Reverse%20Engineering.pdf)

## Channels

*Binary Analysis Channels*

* [OALabs](https://www.youtube.com/channel/UC--DwaiMV-jtO-6EvmKOnqg)
* [MalwareTech](https://www.youtube.com/channel/UCLDnEn-TxejaDB8qm2AUhHQ)
* [GynvaelEN](https://www.youtube.com/user/GynvaelEN)
* [VirusBtn](https://www.youtube.com/user/virusbtn)
* [Intro to WinDBG](https://www.youtube.com/playlist?list=PLhx7-txsG6t6n_E2LgDGqgvJtCHPL7UFu)
* [hasherzade](https://www.youtube.com/channel/UCNWVswPNgn5kutPNa5sprkg)
* [Colin Hardy](https://www.youtube.com/channel/UCND1KVdVt8A580SjdaS4cZg)
* [MalwareAnalysisHedgehog](https://www.youtube.com/channel/UCVFXrUwuWxNlm6UNZtBLJ-A)


## Practice

*Practice Reverse Engineering.  Be careful with malware.*

* [Crackmes.de](http://www.crackmes.de/)
* [OSX Crackmes](https://reverse.put.as/crackmes/)
* [ESET Challenges](http://www.joineset.com/jobs-analyst.html)
* [Flare-on Challenges](http://flare-on.com/)
* [Github CTF Archives](http://github.com/ctfs/)
* [Reverse Engineering Challenges](http://challenges.re/)
* [xorpd Advanced Assembly Exercises](http://www.xorpd.net/pages/xchg_rax/snip_00.html)
* [Virusshare.com](http://virusshare.com/)
* [Contagio](http://contagiodump.blogspot.com/)
* [Malware-Traffic-Analysis](https://malware-traffic-analysis.com/)
* [Malshare](http://malshare.com/)
* [Malware Blacklist](http://www.malwareblacklist.com/showMDL.php)
* [malwr.com](https://malwr.com/)
* [vxvault](http://vxvault.net/)

## Hex Editors

*Hex Editors*

* [HxD](https://mh-nexus.de/en/hxd/)
* [010 Editor](http://www.sweetscape.com/010editor/)
* [Hex Workshop](http://www.hexworkshop.com/)
* [HexFiend](http://ridiculousfish.com/hexfiend/)
* [Hiew](http://www.hiew.ru/)

## Binary Format

*Binary Format Tools*

* [CFF Explorer](http://www.ntcore.com/exsuite.php)
* [Cerbero Profiler](http://cerbero.io/profiler/) // [Lite PE Insider](http://cerbero.io/peinsider/)
* [Detect It Easy](http://ntinfo.biz/)
* [PeStudio](http://www.winitor.com/)
* [PEiD](https://tuts4you.com/download.php?view.398)
* [PPEE](https://www.mzrst.com/)
* [MachoView](https://github.com/gdbinit/MachOView)
* [nm](https://developer.apple.com/library/mac/documentation/Darwin/Reference/ManPages/man1/nm.1.html) - View Symbols
* [file](https://developer.apple.com/library/mac/documentation/Darwin/Reference/ManPages/man1/file.1.html) - File information
* [codesign](https://developer.apple.com/library/mac/documentation/Darwin/Reference/ManPages/man1/codesign.1.html) - Code signing information usage: codesign -dvvv filename

## Disassemblers/Decompilers

*Disassemblers/Decompilers*

* [Ghidra](https://ghidra-sre.org/)
* [IDA Pro](https://www.hex-rays.com/products/ida/index.shtml)
* [Binary Ninja](https://binary.ninja/)
* [JEB](https://www.pnfsoftware.com/jeb2/)
* [Radare](http://www.radare.org/r/)
* [Hopper](http://hopperapp.com/)
* [Capstone](http://www.capstone-engine.org/)
* [objdump](http://linux.die.net/man/1/objdump)
* [fREedom](https://github.com/cseagle/fREedom)
* [Retdec](https://retdec.com/)
* [Snowman](https://derevenets.com/)

## Binary Analysis

*Binary Analysis Resources*

* [Mobius Resources](http://www.msreverseengineering.com/research/)
* [z3](https://z3.codeplex.com/)
* [bap](https://github.com/BinaryAnalysisPlatform/bap)
* [angr](https://github.com/angr/angr)

## Bytecode Analysis

*Bytecode Analysis Tools*

* [dnSpy](https://github.com/0xd4d/dnSpy)
* [Bytecode Viewer](https://bytecodeviewer.com/)
* [Bytecode Visualizer](http://www.drgarbage.com/bytecode-visualizer/)
* [JPEXS Flash Decompiler](https://www.free-decompiler.com/flash/)

## Import Reconstruction

*Import Reconstruction Tools*

* [ImpRec](http://www.woodmann.com/collaborative/tools/index.php/ImpREC)
* [Scylla](https://github.com/NtQuery/Scylla)
* [LordPE](http://www.woodmann.com/collaborative/tools/images/Bin_LordPE_2010-6-29_3.9_LordPE_1.41_Deluxe_b.zip)

## Dynamic Analysis

*Dynamic Analysis Tools*

* [ProcessHacker](http://processhacker.sourceforge.net/)
* [Process Explorer](https://technet.microsoft.com/en-us/sysinternals/processexplorer)
* [Process Monitor](https://technet.microsoft.com/en-us/sysinternals/processmonitor)
* [Autoruns](https://technet.microsoft.com/en-us/sysinternals/bb963902)
* [Noriben](https://github.com/Rurik/Noriben)
* [API Monitor](http://www.rohitab.com/apimonitor)
* [iNetSim](http://www.inetsim.org/)
* [Wireshark](https://www.wireshark.org/download.html)
* [Fakenet](http://practicalmalwareanalysis.com/fakenet/)
* [netzob](https://www.netzob.org/)
* [Volatility](https://github.com/volatilityfoundation/volatility)
* [Dumpit](http://www.moonsols.com/products/)
* [LiME](https://github.com/504ensicsLabs/LiME)
* [Cuckoo](https://www.cuckoosandbox.org/)
* [Objective-See Utilities](https://objective-see.com/products.html)
* [XCode Instruments](https://developer.apple.com/xcode/download/) - XCode Instruments for Monitoring Files and Processes [User Guide](https://developer.apple.com/library/watchos/documentation/DeveloperTools/Conceptual/InstrumentsUserGuide/index.html) 
* [dtrace](http://dtrace.org/blogs/brendan/2011/10/10/top-10-dtrace-scripts-for-mac-os-x/) - sudo dtruss = strace [dtrace recipes](http://mfukar.github.io/2014/03/19/dtrace.html)
* [fs_usage](https://developer.apple.com/library/mac/documentation/Darwin/Reference/ManPages/man1/fs_usage.1.html) - report system calls and page faults related to filesystem activity in real-time.  File I/O: fs_usage -w -f filesystem 
* [dmesg](https://developer.apple.com/library/mac/documentation/Darwin/Reference/ManPages/man8/dmesg.8.html) - display the system message buffer

## Debugging

*Debugging Tools*

* [WinDbg](https://msdn.microsoft.com/en-us/windows/hardware/hh852365.aspx)
* [OllyDbg v1.10](http://www.ollydbg.de/)
* [OllyDbg v2.01](http://www.ollydbg.de/version2.html)
* [OllySnD](https://tuts4you.com/download.php?view.2061)
* [Olly Shadow](https://tuts4you.com/download.php?view.6)
* [Olly CiMs](https://tuts4you.com/download.php?view.1206)
* [Olly UST_2bg](https://tuts4you.com/download.php?view.1206)
* [x64dbg](http://x64dbg.com/#start)
* [gdb](https://www.gnu.org/software/gdb/)
* [vdb](https://github.com/vivisect/vivisect)
* [lldb](http://lldb.llvm.org/)
* [qira](http://qira.me/)
* [unicorn](https://github.com/unicorn-engine/unicorn)

## Mac Decrypt

*Mac Decrypting Tools*

* [Cerbero Profiler](http://cerbero-blog.com/?p=1311) - Select all -> Copy to new file
* [AppEncryptor](https://github.com/AlanQuatermain/appencryptor) - Tool for decrypting
* [Class-Dump](http://stevenygard.com/projects/class-dump/) - use deprotect option 
* [readmem](https://github.com/gdbinit/readmem) - OS X Reverser's process dumping tool

## Document Analysis

*Document Analysis Tools*

* [Ole Tools](http://www.decalage.info/python/oletools)
* [Didier's PDF Tools](http://blog.didierstevens.com/programs/pdf-tools/)
* [Origami](https://github.com/cogent/origami-pdf)

## Scripting

*Scripting*

* [IDA Python Src](https://github.com/idapython/src)
* [IDC Functions Doc](https://www.hex-rays.com/products/ida/support/idadoc/162.shtml)
* [Using IDAPython to Make your Life Easier](http://researchcenter.paloaltonetworks.com/tag/idapython/)
* [Introduction to IDA Python](https://tuts4you.com/download.php?view.3229)
* [The Beginner's Guide to IDA Python](https://leanpub.com/IDAPython-Book)
* [IDA Plugin Contest](https://www.hex-rays.com/contests/)
* [onehawt IDA Plugin List](https://github.com/onethawt/idaplugins-list)
* [pefile Python Libray](https://github.com/erocarrera/pefile)
* [ghidra ninja](https://github.com/ghidraninja/ghidra_scripts)

## Android

*Android tools*

* [Android Developer Studio](http://developer.android.com/sdk/index.html)
* [APKtool](http://ibotpeaches.github.io/Apktool/)
* [dex2jar](https://github.com/pxb1988/dex2jar)
* [Bytecode Viewer](https://bytecodeviewer.com/)
* [IDA Pro](https://www.hex-rays.com/products/ida/index.shtml)

## Yara

*Yara Resources*

* [Yara docs](http://yara.readthedocs.org/en/v3.4.0/writingrules.html)
* [Cheatsheet](https://gist.github.com/tylerha97/eeabc765e9befad9b80a)
* [yarGen](https://github.com/Neo23x0/yarGen)
* [yabin](https://github.com/AlienVault-OTX/yabin)
* [Yara First Presentation](/Users/thalfpop/Downloads/first_2014_-_schuster-_andreas_-_yara_basic_and_advanced_20140619.pdf)
