# awesome-mobile-CTF
This is a curated list of mobile based CTFs, write-ups and vulnerable mobile apps. Most of them are android based due to the popularity of the platform. 

Inspired by [android-security-awesome](https://github.com/ashishb/android-security-awesome), [osx-and-ios-security-awesome](https://github.com/ashishb/osx-and-ios-security-awesome) and all the other awesome security lists on [@github](https://github.com/search?utf8=%E2%9C%93&q=awesome+security&type=Repositories&ref=searchresults).

## Mobile CTF challenges
* [KGB Messenger](https://github.com/tlamb96/kgb_messenger)
* [ASIS CTF — ShareL Walkthrough](https://medium.com/bugbountywriteup/asis-ctf-sharel-walkthrough-da32f3533b40?)
* [Android reversing challenges](https://github.com/kiyadesu/android-reversing-challenges)
* [Android app for IOT CTF](https://github.com/atekippe/SecDSM_April_2019_IOT_CTF_Android_APP)
* [CyberTruck Challenge 2019 (Detroit USA)](https://github.com/nowsecure/cybertruckchallenge19)
* [Matryoshka-style Android reversing challenge](https://github.com/o-o-overflow/dc2019q-vitor-public)
* [Cybertruckchallenge19](https://github.com/nowsecure/cybertruckchallenge19)
* [You Shall Not Pass - BSides Canberra 2019](https://gitlab.com/cybears/fall-of-cybeartron/tree/master/challenges/rev/youshallnotpass)
* [Mobile challenges collection](https://drive.google.com/folderview?id=0B7rtSe_PH_fTWDQ0RC1DeWVoVUE&usp=sharing)
* [BSidesSF 2018 CTF](https://github.com/antojoseph/androidCTF)
* [h1-702-2018-ctf-wu](https://github.com/luc10/h1-702-2018-ctf-wu)
* [THC CTF 2018 - Reverse - Android serial](https://github.com/ToulouseHackingConvention/bestpig-reverse-android-serial)
* Mobile CTF Challenges: [Challenge 1](https://goo.gl/zx4BB6), [Challenge 2](https://goo.gl/2hL6GW), [Challenge 3](https://goo.gl/pBgvF7), [Challenge 4](https://goo.gl/o6MgqU) ZIP password is CTF. 
* [Android crack me challenges](https://github.com/reoky/android-crackme-challenge)
* [OWASP crack me](https://github.com/OWASP/owasp-mstg/tree/master/Crackmes)
* [Rednaga Challenges](https://github.com/rednaga/training/tree/master/DEFCON23/challenges)
* [iOS CTF](https://www.ivrodriguez.com/mobile-ctf)
* [Android Hacking Event 2017: AES-Decrypt](https://team-sik.org/wp-content/uploads/2017/06/AES-Decrypt.apk_.zip)
* [Android Hacking Event 2017: Token-Generator](https://team-sik.org/wp-content/uploads/2017/06/Token-Generator.apk_.zip)
* [Android Hacking Event 2017: Flag-Validator](https://team-sik.org/wp-content/uploads/2017/06/FlagValidator.apk_.zip)
* [Android Hacking Event 2017: You Can Hide – But You Cannot Run](https://team-sik.org/wp-content/uploads/2017/06/YouCanHideButYouCannotRun.apk_.zip)
* [Android Hacking Event 2017: Why Should I Pay?](https://team-sik.org/wp-content/uploads/2017/06/WhyShouldIPay.apk_.zip)
* [Android Hacking Event 2017: Esoteric](https://team-sik.org/wp-content/uploads/2017/06/esoteric.apk_.zip)
* [Android Hacking Event 2016: StrangeCalculator](https://team-sik.org/wp-content/uploads/2016/06/strangecalculator.apk_.zip)
* [Android Hacking Event 2016: ReverseMe](https://team-sik.org/wp-content/uploads/2016/06/ReverseMe.apk_.zip)
* [Android Hacking Event 2016: ABunchOfNative](https://team-sik.org/wp-content/uploads/2016/06/aBunchOfNative.apk_.zip)
* [Android Hacking Event 2016: DynChallenge](https://team-sik.org/wp-content/uploads/2016/06/dynChallenge.apk_.zip)
* [PicoCTF-2014: Pickle Jar - 30](http://shell-storm.org/repo/CTF/PicoCTF-2014/Forensics/Pickle%20Jar%20-%2030/)
* [PicoCTF-2014: Revenge of the Bleichenbacher](http://shell-storm.org/repo/CTF/PicoCTF-2014/crypto/Revenge%20of%20the%20Bleichenbacher%20-%20170/)
* [Android MIT LL CTF 2013](https://github.com/huyle333/androidmitllctf2013)
* [InsomniDroid - Description](http://www.strazzere.com/blog/2012/03/488/), [APK File](http://www.strazzere.com/crackmes/insomnidroid.apk)
* [Evil Planner Bsides Challenge](https://labs.mwrinfosecurity.com/blog/2013/03/11/bsides-challenge/)
* [Crack-Mes](http://www.droidsec.org/wiki/#crack-mes)
* [GreHack-2012 - GrehAndroidMe](http://shell-storm.org/repo/CTF/GreHack-2012/reverse_engineering/100-GrehAndroidMe.apk/)
* [Hackplayers.com Crackmes (in Spanish so an extra challenge): crackme 1 ](http://www.hackplayers.com/2010/12/reto-android-crackme1.html)
* [Hackplayers.com Crackmes (in Spanish so an extra challenge): crackme 2](http://www.hackplayers.com/2011/12/reto-14-android-crackme2.html)
* [Hack.Lu's CTF 2011 Reverse Engineering 300](http://shell-storm.org/repo/CTF/Hacklu-2011/Reversing/Space%20Station%200xB321054A%20(300)/)
* [Androidcracking.blogspot.com's Crackme’s: cracker 0](http://androidcracking.blogspot.com/2012/01/way-of-android-cracker-0-rewrite.html)
* [Androidcracking.blogspot.com's Crackme’s: cracker 1](http://androidcracking.blogspot.com/2010/10/way-of-android-cracker-1.html)
* [Insomnia'hack-2K11](http://shell-storm.org/repo/CTF/Insomnia'hack-2K11/Reverse/validate.apk)
* [CSAW-2011: Reversing101](http://shell-storm.org/repo/CTF/CSAW-2011/Reversing/Reversing101%20-%20100%20Points/)
* [Defcon-19-quals: Binary_L33tness](http://shell-storm.org/repo/CTF/Defcon-19-quals/Binary_L33tness/b300/)
* [Crack me's](https://github.com/as0ler/Android-Examples)
* [SecuInside: CTF2011](http://big-daddy.fr/repository/CTF2011/SecuInside-CTF/Q7/)
* [EnoWars-CTF2011: broken_droid](http://big-daddy.fr/repository/CTF2011/EnoWars-CTF/broken_droid/)
* [Anonim1133](https://github.com/anonim1133/CTF)
* [Challenge4ctf](https://github.com/CvvT/challenge_for_ctf)
* [Ctfpro](https://github.com/jhong01/ctfpro)
* [CTFDroid](https://github.com/rajasaur/CTFDroid)
* [Android CTF](https://github.com/fathulkirom22/AndroidCTF)
* [Android_ctf](https://github.com/artwyman/android_ctf)
* [Robot CTF Android](https://github.com/KappaEtaKappa/Robot-CTF-android)
* [Cl.ctfk](https://github.com/CTFK/cl.ctfk)
* [Cryptax](https://github.com/cryptax/challenges)

## CTF Writeups
### 2019
* [DroidCon, SEC-T CTF 2019](https://anee.me/droidcon-sec-t-ctf-2019-d796be91bb3f)
* [You Shall Not Pass - BSides Canberra 2019](https://medium.com/tsscyber/ctf-writeup-you-shall-not-pass-2c7a9254549b)
* [CyberTruck Challenge 2019 — Android CTF](https://medium.com/bugbountywriteup/cybertruck-challenge-2019-android-ctf-e39c7f796530)
* [Bsidessf-ctf-2019-mobile-track](https://aadityapurani.com/2019/03/07/bsidessf-ctf-2019-mobile-track/)
* BsidesSF CTF - Challenge: [Part 1](https://medium.com/@itsc0rg1/bsidessf-ctf-challenge-write-up-part-1-e849bc917d37), [Part 2](https://medium.com/@itsc0rg1/bsidessf-ctf-challenge-write-up-part-2-f8f597be659)

### 2018
* [H1 202 2018 / H1 202 CTF](https://corb3nik.github.io/blog/h1-202-2018/h1-202-ctf)
* [ H1-702 CTF (Capture the Flag)](https://aadityapurani.com/2018/06/25/h1-702-ctf-writeups/#mobile)
* [BSidesSF 2018 CTF — Android Reversing/Forensic Challenge](https://medium.com/@antojoseph_1995/bsidessf-2018-ctf-android-reversing-forensics-challenge-f5522664b6a2)
* [Hack the Android4: Walkthrough (CTF Challenge)](https://www.hackingarticles.in/hack-the-android4-walkthrough-ctf-challenge/)
* [Google CTF Quals 2018](https://w0y.at/writeup/2018/07/02/google-ctf-quals-2018-shall-we-play-a-game.html)
* [Ilam CTF: Android Reverse WriteUp](https://mstajbakhsh.ir/ilam-ctf-android-reverse-writeup/)
* 8st SharifCTF Android WriteUps: [Vol I](https://mstajbakhsh.ir/8st-sharifctf-android-writeups-vol/), [Vol II](https://mstajbakhsh.ir/8st-sharifctf-android-writeups-vol-ii/)
* [ASIS 2018 Finals: Gunshop](https://saarsec.rocks/2018/11/27/Gunshop.html)
* [H1-202 CTF - Writeup](https://pwning.re/2018/02/23/h1-202-writeup/)
* [M1Con CTF Write up](https://blog.manchestergreyhats.co.uk/2018/03/28/m1con-ctf-writeup/)
* [AES decode with Cyberchef](https://blog.manchestergreyhats.co.uk/2018/04/18/aes-decode-with-cyberchef/)

### 2017
* [BSides San Francisco CTF 2017 : pinlock-150](https://github.com/ctfs/write-ups-2017/tree/10bad9bd24b3f84c761faa4d78e223a3a29b2959/bsidessf-ctf-2017/reversing/pinlock-150)
* [BSides San Francisco CTF 2017 : flag-receiver-200](https://github.com/ctfs/write-ups-2017/tree/10bad9bd24b3f84c761faa4d78e223a3a29b2959/bsidessf-ctf-2017/reversing/flag-receiver-200)
* [BSidesSF CTF wrap-up](https://blog.skullsecurity.org/2017/bsidessf-ctf-wrap-up)
* [itsC0rg1's mobile challenge and BSides SF CTF](https://medium.com/@itsc0rg1/my-mobile-challenge-and-bsides-sf-ctf-f9fc4dfca60)
* [Insomni'hack Teaser 2017 : mindreader-250](https://github.com/ctfs/write-ups-2017/tree/6a3df5bcece6f952cb60db4a3ae2ce97a189b62d/insomnihack-teaser-2017/mobile/mindreader-250)
* [2017_labyREnth: mob1_ezdroid](https://github.com/gray-panda/grayrepo/tree/1a0c2e033621af9900932252cda31c14a4fbbce8/2017_labyREnth/chal/mob1_ezdroid)
* [2017_labyREnth: mob2_routerlocker](https://github.com/gray-panda/grayrepo/tree/1a0c2e033621af9900932252cda31c14a4fbbce8/2017_labyREnth/chal/mob2_routerlocker)
* [2017_labyREnth: mob3_showmewhatyougot](https://github.com/gray-panda/grayrepo/tree/6a0d2fce53b71135286fac3c323b712af08d6913/2017_labyREnth/chal/mob3_showmewhatyougot)
* [2017_labyREnth: mob4_androidpan](https://github.com/gray-panda/grayrepo/tree/ffbf17ec172f1624ba6607cc7756ed7b99d95b63/2017_labyREnth/chal/mob4_androidpan)
* [2017_labyREnth: mob5_iotctf](https://github.com/gray-panda/grayrepo/tree/1a0c2e033621af9900932252cda31c14a4fbbce8/2017_labyREnth/chal/mob5_iotctf)

### 2016
* [LabyREnth](http://researchcenter.paloaltonetworks.com/2016/09/unit42-labyrenth-capture-the-flag-ctf-mobile-track-solutions/)
* [2016_labyREnth: mob1_lastchance](https://github.com/gray-panda/grayrepo/tree/f054b5d66af66ff684449dcb8e6c9e146213971b/2016_labyREnth/mob1_lastchance)
* [2016_labyREnth: mob2_cups](https://github.com/gray-panda/grayrepo/tree/f054b5d66af66ff684449dcb8e6c9e146213971b/2016_labyREnth/mob2_cups)
* [2016_labyREnth: mob3_watt](https://github.com/gray-panda/grayrepo/tree/f054b5d66af66ff684449dcb8e6c9e146213971b/2016_labyREnth/mob3_watt)
* [2016_labyREnth: mob4_swip3r](https://github.com/gray-panda/grayrepo/tree/f054b5d66af66ff684449dcb8e6c9e146213971b/2016_labyREnth/mob4_swip3r)
* [2016_labyREnth: mob5_ioga](https://github.com/gray-panda/grayrepo/tree/f054b5d66af66ff684449dcb8e6c9e146213971b/2016_labyREnth/mob5_ioga)
* [2016_labyREnth: mob6_ogmob](https://github.com/gray-panda/grayrepo/tree/f054b5d66af66ff684449dcb8e6c9e146213971b/2016_labyREnth/mob6_ogmob)
* [Holiday hack challenge: Part 01](https://github.com/gray-panda/grayrepo/tree/76925522bb0ce3a9615f0022300d525a958bc260/2016_holidayhackchallenge/01)
* [Holiday hack challenge: Part 02](https://github.com/gray-panda/grayrepo/tree/76925522bb0ce3a9615f0022300d525a958bc260/2016_holidayhackchallenge/02)
* [Holiday hack challenge: Part 04a](https://github.com/gray-panda/grayrepo/tree/76925522bb0ce3a9615f0022300d525a958bc260/2016_holidayhackchallenge/04a)
* [Holiday hack challenge: Part 04b](https://github.com/gray-panda/grayrepo/tree/76925522bb0ce3a9615f0022300d525a958bc260/2016_holidayhackchallenge/04b)
* [Holiday hack challenge: Part 04c](https://github.com/gray-panda/grayrepo/tree/76925522bb0ce3a9615f0022300d525a958bc260/2016_holidayhackchallenge/04c)
* [Holiday hack challenge: Part 04d](https://github.com/gray-panda/grayrepo/tree/76925522bb0ce3a9615f0022300d525a958bc260/2016_holidayhackchallenge/04d)
* [Holiday hack challenge: Part 04e](https://github.com/gray-panda/grayrepo/tree/76925522bb0ce3a9615f0022300d525a958bc260/2016_holidayhackchallenge/04e)
* [Holiday hack challenge: Part 04f](https://github.com/gray-panda/grayrepo/tree/76925522bb0ce3a9615f0022300d525a958bc260/2016_holidayhackchallenge/04f)
* [Holiday hack challenge: Part 5](https://github.com/gray-panda/grayrepo/tree/76925522bb0ce3a9615f0022300d525a958bc260/2016_holidayhackchallenge/05)
* [0ctf-2016](https://github.com/ctfs/write-ups-2016/tree/master/0ctf-2016/mobile)
* [Google-ctf-2016](https://github.com/ctfs/write-ups-2016/tree/39e9a0e2adca3a3d0d39a6ae24fa51196282aae4/google-ctf-2016/mobile)
* [Google-ctf-2016: ill intentions 1](http://security.claudio.pt/solving-google-ctf-2016-android-challenges/)
* [Google-ctf-2016: ill intentions 2](https://github.com/d3rezz/Google-Capture-The-Flag-2016)
* [Cyber-security-challenge-belgium-2016-qualifiers](https://github.com/ctfs/write-ups-2016/tree/c35549398f88d3755dc31a8fe995f15ef876ee18/cyber-security-challenge-belgium-2016-qualifiers/Mobile%20Security)
* [Su-ctf-2016 - android-app-100](https://github.com/ctfs/write-ups-2016/tree/274307f43140bb4a52e0729ecf1282628fb22f5b/su-ctf-2016/reverse/android-app-100)
* [Hackcon-ctf-2016 - you-cant-see-me-150](https://github.com/ctfs/write-ups-2016/tree/274307f43140bb4a52e0729ecf1282628fb22f5b/hackcon-ctf-2016/reversing/you-cant-see-me-150)
* [RC3 CTF 2016: My Lil Droid](http://aukezwaan.nl/write-ups/rc3-ctf-2016-my-lil-droid-100-points/)
* [Cyber Security Challenge 2016: Dexter](https://github.com/ctfs/write-ups-2016/tree/39e9a0e2adca3a3d0d39a6ae24fa51196282aae4/cyber-security-challenge-belgium-2016-qualifiers/Mobile%20Security/Dexter)
* [Cyber Security Challenge 2016: Phishing is not a crime](https://github.com/ctfs/write-ups-2016/tree/39e9a0e2adca3a3d0d39a6ae24fa51196282aae4/cyber-security-challenge-belgium-2016-qualifiers/Mobile%20Security/Phishing-is-not-a-crime)
* [google-ctf-2016 : little-bobby-application-250](https://github.com/ctfs/write-ups-2016/tree/39e9a0e2adca3a3d0d39a6ae24fa51196282aae4/google-ctf-2016/mobile/little-bobby-application-250)

### 2015
* [Rctf-quals-2015](https://github.com/ctfs/write-ups-2015/tree/9b3c290275718ff843c409842d738e6ef3e565fd/rctf-quals-2015/mobile)
* [Insomni-hack-ctf-2015](https://github.com/ctfs/write-ups-2015/tree/9b3c290275718ff843c409842d738e6ef3e565fd/insomni-hack-ctf-2015/mobile)
* [0ctf-2015](https://github.com/ctfs/write-ups-2015/tree/9b3c290275718ff843c409842d738e6ef3e565fd/0ctf-2015/mobile)
* [Cyber-security-challenge-2015](https://github.com/ctfs/write-ups-2015/tree/9b3c290275718ff843c409842d738e6ef3e565fd/cyber-security-challenge-2015/mobile-application-security)
* [Trend-micro-ctf-2015: offensive-200](https://github.com/ctfs/write-ups-2015/tree/9b3c290275718ff843c409842d738e6ef3e565fd/trend-micro-ctf-2015/analysis/offensive-200)
* [codegate-ctf-2015: dodocrackme2](https://github.com/ctfs/write-ups-2015/tree/9b3c290275718ff843c409842d738e6ef3e565fd/codegate-ctf-2015/reversing/dodocrackme2)
* [Seccon-quals-ctf-2015: reverse-engineering-android-apk-1](https://github.com/ctfs/write-ups-2015/tree/9b3c290275718ff843c409842d738e6ef3e565fd/seccon-quals-ctf-2015/binary/reverse-engineering-android-apk-1)
* [Seccon-quals-ctf-2015 - reverse-engineering-android-apk-2](https://github.com/ctfs/write-ups-2015/tree/9b3c290275718ff843c409842d738e6ef3e565fd/seccon-quals-ctf-2015/unknown/reverse-engineering-android-apk-2)
* [Pragyan-ctf-2015](https://github.com/ctfs/write-ups-2015/tree/9b3c290275718ff843c409842d738e6ef3e565fd/pragyan-ctf-2015/android)
* [Volgactf-quals-2015](https://github.com/ctfs/write-ups-2015/tree/9b3c290275718ff843c409842d738e6ef3e565fd/volgactf-quals-2015/web/malware)
* [Opentoall-ctf-2015: android-oh-no](https://github.com/ctfs/write-ups-2015/tree/9b3c290275718ff843c409842d738e6ef3e565fd/opentoall-ctf-2015/misc/android-oh-no)
* [32c3-ctf-2015: libdroid-150](https://github.com/ctfs/write-ups-2015/tree/9b3c290275718ff843c409842d738e6ef3e565fd/32c3-ctf-2015/reversing/libdroid-150)
* [Polictf 2015: crack-me-if-you-can](https://github.com/ctfs/write-ups-2015/tree/9b3c290275718ff843c409842d738e6ef3e565fd/polictf-2015/reversing/crack-me-if-you-can)
* [Icectf-2015: Husavik](https://github.com/ctfs/write-ups-2015/tree/9b3c290275718ff843c409842d738e6ef3e565fd/icectf-2015/forensics/husavik)

## 2014
* [Qiwi-ctf-2014: not-so-one-time](https://github.com/ctfs/write-ups-2014/tree/b02bcbb2737907dd0aa39c5d4df1d1e270958f54/qiwi-ctf-2014/not-so-one-time)
* [Fdfpico-ctf-2014: droid-app-80](https://github.com/ctfs/write-ups-2014/tree/b02bcbb2737907dd0aa39c5d4df1d1e270958f54/pico-ctf-2014/forensics/droid-app-80)
* [Su-ctf-quals-2014: commercial_application](https://github.com/ctfs/write-ups-2014/tree/b02bcbb2737907dd0aa39c5d4df1d1e270958f54/su-ctf-quals-2014/commercial_application)
* [defkthon-ctf 2014: web-300](https://github.com/ctfs/write-ups-2014/tree/b02bcbb2737907dd0aa39c5d4df1d1e270958f54/defkthon-ctf/web-300)
* [secuinside-ctf-prequal-2014: wooyatalk](https://github.com/ctfs/write-ups-2014/tree/b02bcbb2737907dd0aa39c5d4df1d1e270958f54/secuinside-ctf-prequal-2014/wooyatalk)
* [Qiwi-ctf-2014: easydroid](https://github.com/ctfs/write-ups-2014/tree/b02bcbb2737907dd0aa39c5d4df1d1e270958f54/qiwi-ctf-2014/easydroid)
* [Qiwi-ctf-2014: stolen-prototype](https://github.com/ctfs/write-ups-2014/tree/b02bcbb2737907dd0aa39c5d4df1d1e270958f54/qiwi-ctf-2014/stolen-prototype)
* [TinyCTF 2014: Ooooooh! What does this button do?](https://github.com/ctfs/write-ups-2014/tree/b02bcbb2737907dd0aa39c5d4df1d1e270958f54/tinyctf-2014/ooooooh-what-does-this-button-do)
* [31c3-ctf-2014: Nokia 1337](https://github.com/ctfs/write-ups-2014/tree/b02bcbb2737907dd0aa39c5d4df1d1e270958f54/31c3-ctf-2014/pwn/nokia-1337)
* [Asis-ctf-finals-2014: numdroid](https://github.com/ctfs/write-ups-2014/tree/b02bcbb2737907dd0aa39c5d4df1d1e270958f54/asis-ctf-finals-2014/numdroid)
* [PicoCTF-2014: Droid App](http://shell-storm.org/repo/CTF/PicoCTF-2014/Forensics/Droid%20App%20-%2080/)
* [NDH2k14-wargames: crackme200-ChunkNorris](http://shell-storm.org/repo/CTF/NDH2k14-wargames/crackme200-ChunkNorris/)

## 2013
* [Hack.lu CTF 2013: Robot Plans](https://github.com/ctfs/write-ups-2013/tree/816de23a940856c10987b5047823de48a192c270/hack-lu-ctf-2013/internals/Robot-Plans)
* [CSAW Quals CTF 2015: Herpderper](https://github.com/ctfs/write-ups-2013/tree/816de23a940856c10987b5047823de48a192c270/csaw-quals-2013/web/herpderper-300)

## 2012
* [Atast CTF 2012 Bin 300](http://andromedactf.wordpress.com/2013/01/02/atast-ctf-2012-bin300chall5/)

## Misc
* [Nuit du Hack's 2k12 & 2k11 (pre-quals and finals) Android Crackme’s 1](http://blog.w3challs.com/index.php?post/2012/07/02/NDH2k12-wargame-CrackMe-Android)
* [Nuit du Hack's 2k12 & 2k11 (pre-quals and finals) Android Crackme’s 2](http://blog.spiderboy.fr/tag/crackme/)

## Vulnerable Mobile apps:
### Android
* [OWASP: OMTG-Hacking-Playground](https://github.com/OWASP/OMTG-Hacking-Playground)
* [Damn insecure and vulnerable App (DIVA)](http://payatu.com/damn-insecure-and-vulnerable-app/)
* [Damn Vulnerable Hybrid Mobile App (DVHMA)](https://github.com/logicalhacking/DVHMA)
* [Owasp: Goatdroid Project](https://github.com/jackMannino/OWASP-GoatDroid-Project)
* [InjuredAndroid - CTF](https://github.com/B3nac/InjuredAndroid)
* [ExploitMe labs by SecurityCompass](http://securitycompass.github.io/AndroidLabs/setup.html)
* [InsecureBankv2](https://github.com/dineshshetty/Android-InsecureBankv2)
* [Sieve (Vulnerable ‘Password Manager’ app)](https://github.com/mwrlabs/drozer/releases/download/2.3.4/sieve.apk)
* [sievePWN](https://github.com/tanprathan/sievePWN)
* [ExploitMe Mobile Android Labs](http://securitycompass.github.io/AndroidLabs/)
* [Hacme Bank](http://www.mcafee.com/us/downloads/free-tools/hacme-bank-android.aspx)
* [Android Labs](https://github.com/SecurityCompass/AndroidLabs)
* [Digitalbank](https://github.com/CyberScions/Digitalbank)
* [Dodo vulnerable bank](https://github.com/CSPF-Founder/DodoVulnerableBank)
* [Oracle android app](https://github.com/dan7800/VulnerableAndroidAppOracle)
* [Urdu vulnerable app](http://urdusecurity.blogspot.co.ke/2014/08/Exploiting-debuggable-android-apps.html)
* [MoshZuk](http://imthezuk.blogspot.co.ke/2011/07/creating-vulnerable-android-application.html?m=1) [File](https://dl.dropboxusercontent.com/u/37776965/Work/MoshZuk.apk)
* [Appknox](https://github.com/appknox/vulnerable-application)
* [Vuln app](https://github.com/Lance0312/VulnApp)
* [Damn Vulnerable FirefoxOS Application](https://github.com/arroway/dvfa)
* [Android security sandbox](https://github.com/rafaeltoledo/android-security)

### iOS
* [ExploitMe Mobile iPhone Labs](http://securitycompass.github.io/iPhoneLabs/)
* [Owasp: iGoat](https://github.com/hankbao/owasp-igoat)
* [Damn Vulnerable iOS App (DVIA)](https://github.com/prateek147/DVIA)
* [Damn Vulnerable iOS App (DVIA) v2](https://github.com/prateek147/DVIA-v2)


## Vulnerable Web apps:
### Node
* [Damn Vulnerable NodeJS Application](https://github.com/appsecco/dvna)
* [Damn Vulnerable Serverless Application](https://github.com/OWASP/DVSA)
* [OWASP: Juice Shop](https://github.com/bkimminich/juice-shop)
* [Damn Vulnerable Node Application](https://github.com/isp1r0/DVNA)
* [Intentionally Vulnerable node.js application](https://github.com/nVisium/node.nV)
* [Vulnode](https://github.com/dpnishant/vulnode)
* [OWASP: NodeGoat](https://github.com/OWASP/NodeGoat)
* [Vulnerable-node](https://github.com/cr0hn/vulnerable-node)

### PHP
* [OWASP: Broken Web Applications(BWA)](https://github.com/chuckfw/owaspbwa/)
* [Damn Vulnerable Web Application (DVWA)](https://github.com/ethicalhack3r/DVWA)
* [Damn Vulnerable Web Services(DVWS)](https://github.com/snoopysecurity/dvws)
* [OWASP Hackademic Challenges](https://github.com/Hackademic/hackademic)
* [OWASP: Insecure Web App Project](https://sourceforge.net/projects/insecurewebapp/files/)
* [OWASP: WebGoat](https://github.com/OWASP/OWASPWebGoatPHP)
* [Bwapp](https://sourceforge.net/projects/bwapp/files/bWAPP/)
* [Beebox](https://sourceforge.net/projects/bwapp/files/bee-box/)
* [XVWA - Badly coded web application](https://github.com/s4n7h0/xvwa)
* [Drunk Admin Web Hacking Challenge](http://bechtsoudis.com/archive/2012/04/02/drunk-admin-web-hacking-challenge/index.html)
* [Peruggia](https://sourceforge.net/projects/peruggia/files/)
* [Mutillidae](http://www.irongeek.com/i.php?page=mutillidae/mutillidae-deliberately-vulnerable-php-owasp-top-10)
* [Btslab](https://github.com/CSPF-Founder/btslab/)
* [OWASP: Bricks](http://sechow.com/bricks/index.html)
* [The ButterFly Security Project](http://sourceforge.net/projects/thebutterflytmp/files/)
* [WackoPicko](https://github.com/adamdoupe/WackoPicko)
* [Vicnum](https://sourceforge.net/projects/vicnum/files/)
* [GameOver](https://sourceforge.net/projects/null-gameover/)
* [LAMPSecurity Training](https://sourceforge.net/projects/lampsecurity/)
* [Metasploitable](https://download.vulnhub.com/metasploitable/Metasploitable.zip)
* [Metasploitable 2](https://sourceforge.net/projects/metasploitable/files/)
* [Metasploitable 3](https://github.com/rapid7/metasploitable3)
* [Hackazon](https://github.com/rapid7/hackazon)
* [Twiterlike](https://github.com/sakti/twitterlike)
* [UltimateLAMP](https://download.vulnhub.com/ultimatelamp/UltimateLAMP-0.2.zip)

## Sql
* [SQLI-labs](https://github.com/Audi-1/sqli-labs)
* [Testenv](https://github.com/sqlmapproject/testenv)

### Python
* [Google Gruyere](http://google-gruyere.appspot.com)

### Java
* [Owasp: WebGoat](https://github.com/WebGoat/WebGoat)
* [Puzzlemall](https://code.google.com/p/puzzlemall/)
* [Hacme Books](http://www.mcafee.com/us/downloads/free-tools/hacmebooks.aspx)
* [Bodgeit](https://github.com/psiinon/bodgeit)
* [OWASP: Web Goat](https://github.com/WebGoat/WebGoat)

### Ruby on Rails
* [Hacme Casino](http://www.mcafee.com/us/downloads/free-tools/hacme-casino.aspx)
* [RailsGoat](https://github.com/OWASP/railsgoat)

### C++
* [Hacme Travel](http://www.mcafee.com/us/downloads/free-tools/hacmetravel.aspx) 

### .NET
* [OWASP: WebGoat.NET](https://github.com/jerryhoff/WebGoat.NET)
* [Hacme Bank](http://www.mcafee.com/us/downloads/free-tools/hacme-bank.aspx)
* [VulnApp](https://labs.portcullis.co.uk/tools/vulnapp/)

### ColdFusion
* [Hacme Shipping](http://www.mcafee.com/us/downloads/free-tools/hacmeshipping.aspx)

## Mobile security resources
* [Mobile app pentest cheatsheet](https://github.com/tanprathan/MobileApp-Pentest-Cheatsheet)
* [Android security awesome](https://github.com/ashishb/android-security-awesome)
* [Android security reference](https://github.com/doridori/Android-Security-Reference)
* [Awesome-linux-android-hacking](https://github.com/pfalcon/awesome-linux-android-hacking)
* [iOS security awesome](https://github.com/ashishb/osx-and-ios-security-awesome)
* [awesome-iOS-resource](https://github.com/aozhimin/awesome-iOS-resource)
* [Mobile security wiki](https://mobilesecuritywiki.com/)
* [iPhone wiki](https://www.theiphonewiki.com/wiki/Main_Page)
* [Nyxbone](http://www.nyxbone.com/malware/android_tools.html)
* [Nowhere](https://n0where.net/best-android-security-resources/)
* [Secmobi](https://github.com/secmobi/wiki.secmobi.com)

## Infosec resources
* [OSX-iOS-reverse-engineering](https://github.com/michalmalik/osx-re-101)
* [OSX-security-awesome](https://github.com/kai5263499/osx-security-awesome)
* [Awesome-web-hacking](https://github.com/infoslack/awesome-web-hacking)
* [Awesome-windows-exploitation](https://github.com/enddo/awesome-windows-exploitation)
* [windows-privesc-check](https://github.com/pentestmonkey/windows-privesc-check)
* [Awesome-Hacking](https://github.com/Hack-with-Github/Awesome-Hacking)
* [Awesome-reversing](https://github.com/fdivrp/awesome-reversing)
* [Aweasome-Frida](https://github.com/dweinstein/awesome-frida)
* [Awesome-security](https://github.com/sbilly/awesome-security)
* [Awesome-fuzzing](https://github.com/secfigo/Awesome-Fuzzing)
* [Awesome-wifi-security](https://github.com/edelahozuah/awesome-wifi-security)
* [Android vulnerabilities overview](https://github.com/CHEF-KOCH/Android-Vulnerabilities-Overview)
* [OSX-security-awesome](https://github.com/kai5263499/osx-security-awesome)
* [Infosec_Reference](https://github.com/rmusser01/Infosec_Reference)
* [PayloadsAllTheThings](https://github.com/swisskyrepo/PayloadsAllTheThings)
* [Awesome-malware-analysis](https://github.com/rshipp/awesome-malware-analysis)
* [Linux-reverse-engineering-101](https://github.com/michalmalik/linux-re-101)


## Mobile security standards
* [OWASP Mobile Security Project](https://www.owasp.org/index.php/OWASP_Mobile_Security_Project)
* [OWASP Top 10 - 2016](https://www.owasp.org/index.php/Mobile_Top_10_2016-Top_10)
* [OWASP Mobile Application Security Verification Standard (MASVS)](https://github.com/OWASP/owasp-masvs)
* [OWASP Mobile Security Testing Guide (MSTG)](https://github.com/OWASP/owasp-mstg)

# Credits
* http://carnal0wnage.attackresearch.com/2013/08/want-to-break-some-android-apps.html
* https://www.owasp.org/index.php
* https://github.com/ctfs
* http://shell-storm.org/repo/
