# CVE-2013-1858

```
The clone system-call implementation in the Linux kernel before 3.8.3 does not properly handle a combination of the CLONE_NEWUSER and CLONE_FS flags,
which allows local users to gain privileges by calling chroot and leveraging the sharing of the 
/ directory between a parent process and a child process.
```

Vulnerability reference:
 * [CVE-2013-1858](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2013-1858)  
 * [exp-db](https://www.exploit-db.com/exploits/38390/)  


## Kernels
```
before 3.8.3
```   

## Usage
```
$ cc -Wall clown-newuser.c -static

$ ./a.out
```  

## References
* [CVE Reference: CVE-2013-1858](https://secuniaresearch.flexerasoftware.com/advisories/cve_reference/CVE-2013-1858/)  



